/*							*/
/*   Licensed Materials - Property of IBM               */
/*							*/
/*   5765-530            				*/
/*   (C) Copyright IBM Corp. 1996 All Rights Reserved.	*/
/*							*/

/******************************************************************************
*
*	File		: drivers/ing64/src/sql_unload2.sc, drivers.unix, wm.v1
* 
*	Date		: 95/06/12
*
*	Language	: C
*
*	Operating System: AIX & SOLARIS & HPUX
*
*	Part of		: Ingres Driver
*
*	Functions	: Unload Data from SQL query to file
*
*****************************************************************************/

#include <stdio.h>
#include <fcntl.h>
#include <ctype.h>
#include <time.h>
#include <sys/stat.h>
#include <sys/types.h>

#include <files/generr.h>

#include "ipc.h"
#include "trace.h"
#include "lib.h"
#include "msg.h"

EXEC SQL INCLUDE SQLCA;
EXEC SQL INCLUDE SQLDA;

EXEC SQL BEGIN DECLARE SECTION;
        char    insertstat[20480];
EXEC SQL END DECLARE SECTION;

extern IISQLDA	*do_fetch( int index);
extern char	*generate_filename( char *prefix, char *suffix);
extern char	*find_localset();
extern int      curr_tracelevel;
#define MAX_STATEMENT   20480
extern char 	s[MAX_STATEMENT];

/*
 * Function  : sqlUnloadSyll( int, char *,  int)
 * Arguments
 *      arg1 :  Socket to send reply to
 *      arg2 :  Conversion types 
 *      arg3 :  Cursor of SQL-statement to use for unload
 * Return Value:
 *      None
 * Comments  :
 *      Unloads data from a previously opened select statement to a file
 * Author    : Marc Gathier
 * History
 *      Created         : Mon Oct  3 12:30:19 CET 1994
 *      Modifications   :
 *
 *
 */
int 
sqlUnloadSyll(int sock, char *conversions, int index)
{
	int		len, result, rc, i;
	short		*indicator;
	IISQLDA		*dp;
	struct contents inq;
	int		fd;
	char		*newfile;
	int		isoset, columns;
	int		collen;
	char		*localset;
	char		timest[27];

	TRACE_FUNC_ENTRY( 1, "sqlUnload");
	TRACE_FUNC_DATA( 1, INT, (char *)&sock);
	TRACE_FUNC_DATA( 1, INT, (char *)&index);
	
	newfile = generate_filename( "/tmp/unload", ".sxf");
	strcpy( inq.remarks, newfile);
	free( newfile);

	if( (fd = creat( inq.remarks, 0777)) == -1 ) {
		result = -FILEOPEN_FAILED;
                Write( sock, (char *)&result, sizeof( result),
                        "sqlUnload", INT);
                len = strlen( inq.remarks) + 1;
                Write( sock, (char *)&len, sizeof( len), "sqlUnload",
                        INT);
                Write( sock, inq.remarks, len, "sqlUnload",
                        STRING);
		TRACE_FUNC_EXIT( 1, "sqlUnload", NONE,  0);
		return( 0);
	}

	/* write header information: 
		iso-codeset number-of-columns conversions
		(int)       (int)             (char)
	*/

	localset = find_localset();
	isoset = find_isoset( localset);
	initConversionTable( "dummy", isoset, fd);
	columns = strlen( conversions);
	write( fd, (char *)&isoset, sizeof( int));
	write( fd, (char *)&columns, sizeof( int));
	write( fd, conversions, columns);

	rc = 0;

	while( (dp = do_fetch( index)) && sqlca.sqlcode == GE_OK) {

		for(i = 0 ; i < dp->sqld ; i++) {

      			indicator = (short *) dp->sqlvar[i].sqlind;
      			if (dp->sqlvar[i].sqltype < 0 && *indicator < 0) {
				collen = -1;	/* Null */
				write( fd, (char *)&collen, sizeof( int));
			}
      			else  {
				get_field( dp->sqlvar[i].sqltype, 
					dp->sqlvar[i].sqllen,
					dp->sqlvar[i].sqldata,
					s);

				if( conversions[i] == 'f' ) {
					ing_string_to_isotime( s, timest);
					collen = 25;
					write( fd, (char *)&collen,
						sizeof( int));
					write( fd, timest, collen);
				}
				else {
				duplicate_quotes(s);
				collen = strlen( s);
				if ( conversions[i] == 'b' ) {
					collen = strlen( s);
					write( fd, (char *)&collen, 
								sizeof( int));
					write( fd, s, collen);
				}
				else {
					char *cs;
					cs = convertStringForFile( 'w',
							s, sizeof(s), fd);
					collen = strlen( cs);
					write( fd, (char *)&collen,
							sizeof( int));
					write( fd, cs, collen);
					free( cs);
				}
				}
			}
		}

		collen = -2;	/* End of Record */
		write( fd, (char *)&collen, sizeof( int));

		rc++;
	}

	close( fd);
	sqlCloseCursor( index);
	if( rc >= 0)
		result = rc;
	else
		result = -DBERROR;

        Write( sock, (char *)&result, sizeof( result),
                "sqlUnload", INT);
        len = strlen( inq.remarks) + 1;
        Write( sock, (char *)&len, sizeof( len), "sqlUnload",
                INT);
        Write( sock, inq.remarks, len, "sqlUnload",
                STRING);

	TRACE_FUNC_EXIT( 1, "sqlUnload", NONE,  0);
	return( 0);
}

ing_string_to_isotime( char *s, char *ts)
{
	char *p, *q;
	int	year, mon, day, hour, min, sec, msec=0;

	q = p = s;
	while( *p && *p != '-' && *p != ' ' )
		p++;
	*p = '\0';
	year = atoi( q);

	q = p = s+7;
	while( *p && *p != '-' && *p != ' ' )
		p++;
	*p = '\0';
	mon = atoi( q);
	
	q = p = s+14;
	while( *p && *p != '-' && *p != ' ' )
		p++;
	*p = '\0';
	day = atoi(q);
	
	q = p = s+21;
	while( *p && *p != '.' && *p != ' ' )
		p++;
	*p = '\0';
	hour = atoi(q);
	
	q = p = s+28;
	while( *p && *p != '.' && *p != ' ' )
		p++;
	*p = '\0';
	min = atoi(q);
	
	q = p = s+35;
	while( *p && *p != '.' && *p != ' ' )
		p++;
	*p = '\0';
	sec = atoi(q);

	sprintf( ts, "%.4d %.2d %.2d %.2d %.2d %.5d", 
		year, mon, day, hour, min, sec, msec);
}

sqlLoadSyll( int sock, char *file, char *db, char *owner, char *name)
{
	int	fd;
	int	codeset, columns, collen, colnum, rownum=0;
	char	*conversions;
	struct 	contents inq;
	int	clen, len, result;
	char	*cbuf;
	char	*errmess, *c, *nc;

	/* open file and initialize conversion table */

	if( (fd = open( file, O_RDONLY)) == -1) {
		result = FILEOPEN_FAILED;
                Write( sock, (char *)&result, sizeof( result),
                        "sqlUnload", INT);
                len = strlen( inq.remarks) + 1;
                Write( sock, (char *)&len, sizeof( len), "sqlload",
                        INT);
                Write( sock, inq.remarks, len, "sqlload",
                        STRING);
		return(-1);
	}

	if( read( fd, (int *)&codeset, sizeof( int)) != sizeof( int) ) {
		result = FILEOPEN_FAILED;
                Write( sock, (char *)&result, sizeof( result),
                        "sqlUnload", INT);
                len = strlen( inq.remarks) + 1;
                Write( sock, (char *)&len, sizeof( len), "sqlload",
                        INT);
                Write( sock, inq.remarks, len, "sqlload",
                        STRING);
		return(-2);
	}
	initConversionTable( "dummy", codeset, fd);

	if( read( fd, (int *)&columns, sizeof( int)) != sizeof( int) ) {
		result = FILEOPEN_FAILED;
                Write( sock, (char *)&result, sizeof( result),
                        "sqlUnload", INT);
                len = strlen( inq.remarks) + 1;
                Write( sock, (char *)&len, sizeof( len), "sqlload",
                        INT);
                Write( sock, inq.remarks, len, "sqlload",
                        STRING);
		return(-3);
	}

	conversions = (char *) malloc( columns + 1);
	read( fd, conversions, columns);


	/* Read in records */

	colnum = 0;
	while( read( fd, (int *)&collen, sizeof( int)) == sizeof( int)) {
		switch( collen) {
		case -2: {
			/* End of Record */
			sprintf( insertstat, "insert into %s.%s values (%s)", 
				owner, name, c);

			EXEC SQL PREPARE I1 FROM :insertstat;

			EXEC SQL EXECUTE I1;

			if( sqlca.sqlcode ) {
				if( sqlca.sqlcode > 0) 
					result = sqlca.sqlcode * -1;
				else
					result = sqlca.sqlcode;
				errmess = get_message();
				Write( sock, (char *)&result, sizeof( result),
                                        "sqlUnload", INT);
                                len = strlen( errmess) + 1;
                                Write( sock, (char *)&len, sizeof( len), 
					"sqlload", INT);
                                Write( sock, errmess, len, "sqlload",
                                        STRING);
				return(-4);
			}
			colnum = 0;
			rownum++;

			break;
			}

		case -1: {
			if( colnum == 0 ) {
				c = (char *) malloc( 5);
				strcpy( c, "null");
			}
			else {
				nc = (char *)malloc( strlen(c) + 7);
				sprintf( nc, "%s, null", c);
				free( c);
				c = nc;
			}

			colnum++;
			break;
			}

		default : 
			{

			cbuf = (char *) malloc( collen + 1);
			read( fd, cbuf, collen);
			cbuf[collen] = '\0';

			switch( conversions[colnum] ) {
			case 'd': {
				cbuf[4] = '.';
				cbuf[7] = '.';
				cbuf[10] = '\0';

				if( colnum == 0) {
					c = (char *) malloc(13);
					sprintf( c, "'%s'", cbuf);
				}
				else {
					nc = (char *)malloc(strlen(c)+15);
					sprintf( nc, "%s, '%s'", c, cbuf);
					free( c);
					c = nc;
				}
				break;
				}
			case 'e':	{
				cbuf[13] = ':';
				cbuf[16] = ':';
				cbuf[19] = '\0';

				if( colnum == 0) {
					c = (char *) malloc(11);
					sprintf( c, "'%s'", cbuf+11);
				}
				else {
					nc = (char *)malloc(strlen(c)+13);
					sprintf( nc, "%s, '%s'", c, cbuf+11);
					free( c);
					c = nc;
				}
				break;
				}
			case 'f':	{
				int     sh;

				cbuf[4] = '.';
				cbuf[7] = '.';
				cbuf[13] = ':';
				cbuf[16] = ':';
				cbuf[19] = '\0';

				if( colnum == 0) {
					c = (char *) malloc(22);
					sprintf( c, "'%s'", cbuf);
				}
				else {
					nc = (char *)malloc(strlen(c)+24);
					sprintf(nc, "%s, '%s'", c, cbuf);
					free( c);
					c = nc;
				}
				break;
				}
			case 'n':
				if( colnum == 0 ) {
					c = (char *) malloc( collen + 1);
					sprintf( c, "%s", cbuf);
				}
				else {
					nc = (char *)malloc( strlen(c) + 
								collen + 5);
					sprintf( nc, "%s, %s", c, cbuf);
					free( c);
					c = nc;
				}
				break;
			case 'b':
				if( colnum == 0 ) {
					c = (char *) malloc( collen + 3);
					sprintf( c, "'%s'", cbuf);
				}
				else {
					nc = (char *)malloc( strlen(c) + 
								collen + 5);
					sprintf( nc, "%s, '%s'", c, cbuf);
					free( c);
					c = nc;
				}
				break;
			case 't': 
			case 'g': 
				{
				char *cs;
				cs = convertStringForFile( 'r', cbuf,
							collen+1, fd);
				collen = strlen(cs);
				if( colnum == 0 ) {
					c = (char *) malloc( collen + 3);
					sprintf( c, "'%s'", cs);
				}
				else {
					nc = (char *)malloc( strlen(c) +
								collen + 5);
					sprintf( nc, "%s, '%s'", c, cs);
					free( c);
					c = nc;
				}
				free( cs);
				break;
				}
			}

			free( cbuf);
			colnum++;
			}
		}
	}

	close( fd);
	result = rownum;
        Write( sock, (char *)&result, sizeof( result),
                "sqlUnload", INT);
        len = strlen( inq.remarks) + 1;
        Write( sock, (char *)&len, sizeof( len), "sqlload",
                INT);
        Write( sock, inq.remarks, len, "sqlload",
                STRING);

	return(0);
}
