--                                                                           --
--                                                                           --
--  Licensed Materials - Property of IBM                                     --
--					                                     --
--  5765-530 (C) Copyright IBM Corp. 1996 All Rights Reserved.               --
--						                             --
--                                                                           --
--                                                                           --
-- This is a DB2/6000 v2 SQL Script to migrate a previously installed        --
-- repository to a new repository                                            --
--                                                                           --
-- Migration of Red db2v2 data to Orange                                     --
--                                                                           --

-- dba_host_profile --
-- host_name increased from 40 to 100  --
-- user_name increased from 40 to 50   --
-- password increased from 40 to 50    --

insert into dba_host_profile ( HOST_NAME, USER_NAME, PASSWORD )
	select HOST_NAME, USER_NAME, PASSWORD from #red#.dba_host_profile;


-- dba_host --
-- host_name increased from 45 to 100  --
-- host_type increased from 10 to 50   --

insert into dba_host ( HOST_NUM, HOST_NAME, HOST_TYPE, 
				HOST_DESC, HOST_DIR )
	select HOST_NUM, HOST_NAME, HOST_TYPE, HOST_DESC, HOST_DIR
		from #red#.dba_host;


-- dba_database --
-- db_type increased from 7 to 50   --
-- db_name increased from 20 to 50  --
-- db_desc increased from 80 to 255 --

insert into dba_database (DB_NUM, HOST_NUM, DB_TYPE, DB_NAME,
				DB_DIR, DB_DESC, DB_STATUS )
	select DB_NUM, HOST_NUM, DB_TYPE, DB_NAME, DB_DIR, DB_DESC, DB_STATUS
		from #red#.dba_database;


-- dba_application --
-- app_name increased from 45 to 50 --

insert into dba_application (APP_NUM, APP_NAME )
	select APP_NUM, APP_NAME
		from #red#.dba_application;


-- dba_host_app --

insert into dba_host_app ( HOST_NUM, APP_NUM )
	select HOST_NUM, APP_NUM
		from #red#.dba_host_app;


-- dba_db_table --
-- db_name increased from 40 to 50     --
-- tab_owner increased from 40 to 50   --
-- tab_name increased from 40 to 50    --

insert into dba_db_table ( TAB_NUM, DB_NUM, DB_NAME, TAB_OWNER,
		TAB_NAME, TYPE )
	select TAB_NUM, DB_NUM, DB_NAME, TAB_OWNER, TAB_NAME, TYPE
		from #red#.dba_db_table;


-- dba_app_table --
-- app_name increased from 45 to 50 --

insert into dba_app_table (APP_TAB_NUM, TAB_NUM, APP_NUM )
	select APP_TAB_NUM, TAB_NUM, APP_NUM
		from #red#.dba_app_table;


--  dba_relation  --
--  col_from increased from 40 to 50 --
--  col_to increased from 40 to 50 --

insert into dba_relation (rel_num, tab_from, tab_to, 
			col_from, col_to, col_pos)
        select rel_num, tab_from, tab_to, col_from, col_to, col_pos 
        from #red#.dba_relation;


-- dba_db_check --
-- db_name should be defaulted 	        --
-- check_scope increased from 15 to 50  --
-- obj_owner increased from 40 to 50    --
-- obj_name increased from 40 to 50     --
-- sql_text increased from 1000 to 1024 --
-- filter_type increased from 2 to 4    --
-- ret_type changed from int to smallint--

insert into dba_db_check ( CHECK_NUM, CHECK_SCOPE, DB_NUM, OBJ_OWNER,
		OBJ_NAME, CHECK_TYPE, SQL_TEXT, FILTER_TYPE, FILTER_VAL, 
		CHECK_NAME, RET_TYPE )
	select CHECK_NUM, CHECK_SCOPE, DB_NUM, OBJ_OWNER, OBJ_NAME, CHECK_TYPE,
		SQL_TEXT, FILTER_TYPE, FILTER_VAL, CHECK_NAME, RET_TYPE
		from #red#.dba_db_check;

-- Updates required as the select returns an empty string ("") rather than NULL
update dba_db_check set obj_owner = NULL where obj_owner ='';
update dba_db_check set obj_name = NULL where obj_name ='';

-- Update checks on Sybase database level
update dba_db_check
set check_scope = 'database_syb',
  obj_name = obj_owner,
  obj_owner = null
where
  db_num in (
    select db_num
    from dba_database
    where db_type = 'syb'
  )
  and check_scope = 'database';


-- dba_host_check --
-- sql_text increased from 255 to 1024  --
-- filter_type increased from 2 to 4    --
-- ret_type changed from int to smallint--

insert into dba_host_check ( CHECK_NUM, HOST_NUM, CHECK_TYPE, 
		SQL_TEXT, FILTER_TYPE, FILTER_VAL, CHECK_NAME, RET_TYPE )
	select CHECK_NUM, HOST_NUM, CHECK_TYPE, SQL_TEXT, FILTER_TYPE,
		FILTER_VAL, CHECK_NAME, RET_TYPE
		from #red#.dba_host_check;


-- dba_db_rule --
-- action_type increased from 7 to 50      --
-- command_host increased from 40 to 50    --
-- command_user increased from 40 to 50    --

insert into dba_db_rule ( RULE_NUM, CONDITION, ACTION_TYPE, ACTION,
		COMMAND_HOST, COMMAND_USER )
	select RULE_NUM, CONDITION, ACTION_TYPE, ACTION, 
		COMMAND_HOST, COMMAND_USER from #red#.dba_db_rule;


-- dba_check_rule --

insert into dba_check_rule (CHECK_NUM, RULE_NUM )
	select CHECK_NUM, RULE_NUM
		from #red#.dba_check_rule;


-- dba_check_times --

insert into dba_check_times (CHECK_NUM, START_TYPE, START_TIME,
			REPEAT_TYPE, REPEAT_TIME, END_TYPE, END_TIME )
	select CHECK_NUM, START_TYPE, START_TIME, REPEAT_TYPE, REPEAT_TIME,
		END_TYPE, END_TIME
		from #red#.dba_check_times;


-- dba_alert --
-- alert_class increased from 20 to 50 --

insert into dba_alert (ALERT_NUM, ALERT_CLASS, ALERT_MESSAGE, ACTION )
	select ALERT_NUM, ALERT_CLASS, ALERT_MESSAGE, ACTION 
		from #red#.dba_alert;


-- dba_alert_send --
-- send_user increased from 40 to 50 --

insert into dba_alert_send (ALERT_NUM, RULE_NUM, SEND_USER, RECEIVED )
	select ALERT_NUM, RULE_NUM, SEND_USER, RECEIVED 
		from #red#.dba_alert_send;


-- dba_check_vals --
-- ret_type changed from int to smallint           --
-- set_nr was added and removed -- Barry           --

insert into dba_check_vals (CHECK_NUM, TS, RET_TYPE, IVALUE,
				FVALUE, SVALUE )
	select CHECK_NUM, TS, RET_TYPE, IVALUE, FVALUE, SVALUE
		from #red#.dba_check_vals;


-- alert_table --
-- alert_user increased from 32 to 50 --

insert into alert_table (ALERT_NUM, ALERT_USER, TS, SEEN )
	select ALERT_NUM, ALERT_USER, TS, SEEN 
		from #red#.alert_table;


-- dba_group --
-- group_name increased from 20 to 50  --
-- Note : where clause due to data previously entered --

insert into dba_group ( GROUP_NR, GROUP_NAME )
	select GROUP_NR, GROUP_NAME
		from #red#.dba_group where GROUP_NR <> 0;


-- dba_host_type --
-- Note : where clause due to data previously entered --

insert into dba_host_type (host_type )
        select host_type 
	from #red#.dba_host_type 
	where host_type not in
	(select host_type from dba_host_type); 


-- dba_database_type --
-- Note : where clause due to data previously entered --

insert into dba_database_type ( DB_TYPE )
	select DB_TYPE 
	from #red#.dba_database_type
	where DB_TYPE not in
	(select DB_TYPE from dba_database_type);


--  dba_user  --
--  user_name increased from 32 50  --
-- Note : where clause due to data previously entered --

insert into dba_user ( user_nr, user_name )
        select user_nr, user_name
        from #red#.dba_user where user_nr <> 0;


--  dba_user_groups  --
--  user_name increased from 32 50  --
-- Note : where clause due to data previously entered --

insert into dba_user_groups ( user_nr, group_nr )
        select user_nr, group_nr
        from #red#.dba_user_groups
	where user_nr <> 0 and group_nr <> 0;


-- dba_class --
-- class_name shortened from 32 to 19      --
-- User Defined class are to be between 1000 & 5000 --

insert into dba_class (CLASS_NR, CLASS_NAME )
	select CLASS_NR, substr(CLASS_NAME, 1, 19)
	from #red#.dba_class
	where CLASS_NR >= 1000
        and   CLASS_NR <= 5000;

-- dba_class_data --
-- db_type shortened from 10 to 6      --
-- par_name increased from 30 to 50    --

insert into dba_class_data (CLASS_NR, DB_TYPE, PAR_NUM, PAR_NAME )
 	select CLASS_NR, substr(DBTYPE, 1, 6), PAR_NUM, PAR_NAME
 	from #red#.dba_class_data
        where CLASS_NR >= 1000
	and   CLASS_NR <= 5000;


-- dba_class_status --
-- db_type shortened from 10 to 6      --
-- value increased from 30 to 50    --
-- color increased from 20 to 50    --

insert into dba_class_status (CLASS_NR, DB_TYPE, VALUE, COLOR )
	select CLASS_NR, substr(DBTYPE, 1, 6), VALUE, COLOR
	from #red#.dba_class_status
        where CLASS_NR >= 1000
        and   CLASS_NR <= 5000;


--  dba_udisp_func  --
--  from_type increased from 30 to 50  --
--  output_sep changed from varchar to char  --
--  status changed from varchar to char  --

insert into dba_udisp_func ( ud_func_num, from_class, from_type, to_class, 
			command_type, output_sep, status)
        select ud_func_num, from_class, from_type, to_class, command_type, 
		output_sep, status
        from #red#.dba_udisp_func;


--  dba_udisp_comm  --

insert into dba_udisp_comm ( ud_func_num, comm_part, command )
        select ud_func_num, comm_part, command
        from #red#.dba_udisp_comm;


--  dba_udisp_filter  --

insert into dba_udisp_filter ( ud_func_num, filter_num, filter_name )
        select ud_func_num, filter_num, filter_name
        from #red#.dba_udisp_filter;


--  dba_udisp_priv  --

insert into dba_udisp_priv ( group_num, ud_func_num )
        select group_num, ud_func_num
        from #red#.dba_udisp_priv;

-------------------------------------------------------------------------
-- User Defined Functions
-------------------------------------------------------------------------

-- dba_function
-- Note only migrate functions between 20,000 & 50,000 - User defined

insert into dba_function ( function, name, color, type )
        select FUNCTION, NAME, COLOR, TYPE
        from #red#.dba_function
        where FUNCTION >= 20000
        and   FUNCTION <= 50000;


-- dba_privs
-- Note only migrate functions between 20,000 & 50,000 - User defined

insert into dba_privs ( function_nr, class_nr, host_type, db_type, group_nr )
        select FUNCTION_NR, CLASS_NR, HOST_TYPE, DB_TYPE, GROUP_NR
        from #red#.dba_privs
        where FUNCTION_NR >= 20000
        and   FUNCTION_NR <= 50000;


-- dba_func_attr_desc
-- Note only migrate functions between 20,000 & 50,000 - User defined

insert into dba_func_attr_desc ( function_nr, class_or_instance, one_or_multi )
        select FUNCTION_NR, CLASS_OR_INSTANCE, ONE_OR_MULTI
        from #red#.dba_func_attr_desc
        where FUNCTION_NR >= 20000
        and   FUNCTION_NR <= 50000;


-- dba_func_comm --
-- Note only migrate functions between 20,000 & 50,000 - User defined

insert into dba_func_comm ( func_nr, command_nr, command_type )
	select FUNC_NR, COMMAND_NR, COMMAND_TYPE
	from #red#.dba_func_comm
        where FUNC_NR >= 20000
        and   FUNC_NR <= 50000;



--  dba_ud_func_desc  --
-- Note only migrate functions between 20,000 & 50,000 - User defined

insert into dba_ud_func_desc ( func_nr, command_nr, segment_nr, segment )
        select FUNC_NR, COMMAND_NR, SEGMENT_NR, SEGMENT
        from #red#.dba_ud_func_desc
        where FUNC_NR >= 20000
        and   FUNC_NR <= 50000;



-- dba_func_param --
-- Note only migrate functions between 20,000 & 50,000 - User defined
-- param_name increased from 40 to 50    --

insert into dba_func_param ( func_nr, param_nr, param_name )
	select FUNC_NR, PARAM_NR, PARAM_NAME
	from #red#.dba_func_param
        where FUNC_NR >= 20000
        and   FUNC_NR <= 50000;


-------------------------------------------------------------------------
-- User Defined Functions
-------------------------------------------------------------------------

-- name_ctr --

-- This is because Name counter will have previosly been set --
-- to '1' in the dba script. --
-- Barry --
update name_ctr set  V  = 
	( select V from #red#.dba_group_ctr )
	where NAME = 'dba_group_ctr';

update name_ctr set V  = 
	(select V  from #red#.dba_user_ctr)
	where NAME = 'dba_user_ctr';

insert into name_ctr (NAME, V) 
	select 'dba_check_ctr', V  from #red#.dba_check_ctr;

insert into name_ctr (NAME, V) 
	select 'dba_rule_ctr', V  from #red#.dba_rule_ctr;

insert into name_ctr (NAME, V) 
	select 'dba_alert_ctr', V  from #red#.dba_alert_ctr;

insert into name_ctr (NAME, V) 
	select 'dba_host_ctr', V  from #red#.dba_host_ctr;

insert into name_ctr (NAME, V) 
	select 'dba_db_ctr', V  from #red#.dba_db_ctr;

insert into name_ctr (NAME, V) 
	select 'dba_app_tab_ctr', V  from #red#.dba_app_tab_ctr;

insert into name_ctr (NAME, V) 
	select 'dba_tab_ctr', V  from #red#.dba_tab_ctr;

insert into name_ctr (NAME, V) 
	select 'dba_rel_ctr', V  from #red#.dba_rel_ctr;

insert into name_ctr (NAME, V) 
	select 'dba_app_ctr', V  from #red#.dba_app_ctr;

insert into name_ctr (NAME, V) 
	select 'dba_function_ctr', V  from #red#.dba_function_ctr;

-- Theses counters are needed as the follwing counter names have changed
-- dba_alert_ctr has become wd_alert_ctr
-- dba_rule_ctr has become wd_rule_ctr
-- For the moment dba_alert_ctr & dba_rule_ctr will also be kept -- Barry

insert into name_ctr (NAME, V)
        select 'wd_alert_ctr', V  from #red#.dba_alert_ctr;

insert into name_ctr (NAME, V)
        select 'wd_rule_ctr', V  from #red#.dba_rule_ctr;

-- Note this is need as Red & Orange relerases use counters differently
update name_ctr set v = v+1;



-- dba_check_status --
-- Changes recommended by Stan Wong for watchdog migration --
-- Barry 16 Feb 96 --

insert into dba_check_status (check_num) select check_num                    
   from #red#.dba_db_check union select check_num from #red#.dba_host_check;              
                                                                              
update dba_check_status set store_status = 'y', active_status = 'y';         
                                                                              


