/*
 * Decompiled with CFR 0.152.
 */
import com.ibm.db2.cli.traceparse.CLIAPIFunction;
import com.ibm.db2.cli.traceparse.CLITrace;
import com.ibm.db2.cli.traceparse.CLITraceProcessor;
import com.ibm.db2.cli.traceparse.InvalidCliTraceErrorCodes;
import com.ibm.db2.cli.traceparse.InvalidCliTraceException;
import corejava.Format;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;

public class CLITraceParser
implements InvalidCliTraceErrorCodes {
    private CLITraceProcessor processor;
    private CLITrace trace;
    private boolean traceFileSet;
    private boolean outFileSet;
    private boolean conserveMemory;
    private final int TRACEFILE = 0;
    private final int OUTPUTFILE = 1;
    private final int MAXARGSLENGTH = 3;
    private final int TOTALFILES = 2;
    private String[] files;
    private long linesRead;
    private long offset;
    private int offsetCounter;
    private static final String version = "CLITraceParser -- CLI Trace Parsing Tool v1.0.4d";

    CLITraceParser() {
        this.offset = 0L;
        this.offsetCounter = 0;
        this.conserveMemory = false;
        this.outFileSet = false;
        this.traceFileSet = false;
    }

    private CLITraceParser(long l, int n) {
        this.offset = l;
        this.offsetCounter = n;
        this.conserveMemory = false;
        this.outFileSet = false;
        this.traceFileSet = false;
    }

    public static void main(String[] stringArray) {
        CLITraceParser.printVersion(System.out);
        CLITraceParser cLITraceParser = new CLITraceParser();
        cLITraceParser.runParser(stringArray);
        System.exit(0);
    }

    private void outputConnectInfo(PrintWriter printWriter) {
        printWriter.println("Report of Connections that are made in this CLI Trace");
        printWriter.println("=====================================================");
        Enumeration enumeration = this.trace.getConnections();
        int n = 0;
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                CLIAPIFunction cLIAPIFunction = (CLIAPIFunction)enumeration.nextElement();
                printWriter.println("Connection #" + ++n + ":");
                printWriter.println("Line number  : " + cLIAPIFunction.getLineNumber());
                printWriter.println("Information  : " + cLIAPIFunction.getconnectinfo());
                printWriter.println();
            }
        } else {
            printWriter.println("No Connections made in trace.");
        }
        printWriter.println();
        printWriter.println("End of Connections report.");
    }

    private void outputErrorStats(PrintWriter printWriter) {
        printWriter.println("Report of errors that occurred in this CLI Trace");
        printWriter.println("================================================");
        Enumeration enumeration = this.trace.getErrors();
        int n = 0;
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                CLIAPIFunction cLIAPIFunction;
                CLIAPIFunction cLIAPIFunction2 = (CLIAPIFunction)enumeration.nextElement();
                printWriter.println("Error #" + ++n + ":");
                printWriter.println("Function name : " + cLIAPIFunction2.getFunctionName());
                printWriter.println("Line number   : " + cLIAPIFunction2.getLineNumber());
                printWriter.println("Return code   : " + cLIAPIFunction2.getReturnCode());
                if (!this.conserveMemory && (cLIAPIFunction = this.trace.getStatement((int)cLIAPIFunction2.getStatementNumber() + 1)) != null && (cLIAPIFunction.getFunctionName().equals("SQLGetDiagRec") || cLIAPIFunction.getFunctionName().equals("SQLError"))) {
                    printWriter.println("Error message : " + cLIAPIFunction.getReturnValue("pszErrorMsg"));
                    printWriter.println("SQL Error code: " + cLIAPIFunction.getReturnValue("pfNativeError"));
                }
                printWriter.println();
            }
        } else {
            printWriter.println("No errors in trace.");
        }
        printWriter.println();
        printWriter.println("End of error report.");
    }

    private void outputFunctionStats(PrintWriter printWriter) {
        printWriter.println("Function specific statistics");
        printWriter.println("========================================================");
        printWriter.println();
        Format.print(printWriter, "%43s", "Timing");
        Format.print(printWriter, "%30s", "Network Send");
        Format.print(printWriter, "%28s", "Network Receive");
        printWriter.println();
        Format.print(printWriter, "%-30s", "Function Name");
        Format.print(printWriter, "%-7s", "Total");
        Format.print(printWriter, "%-12s", "Application");
        Format.print(printWriter, "%-12s", "CLI");
        Format.print(printWriter, "%-6s", "Flows");
        Format.print(printWriter, "%-12s", "Bytes");
        Format.print(printWriter, "%-7s", "Time");
        Format.print(printWriter, "%-6s", "Flows");
        Format.print(printWriter, "%-12s", "Bytes");
        Format.print(printWriter, "%-7s", "Time");
        printWriter.println();
        printWriter.print("-------------------------------------------------------");
        printWriter.println("------------------------------------------------------");
        Enumeration enumeration = this.trace.getFunctionStatistics();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                CLITrace.CliAPICallInfo cliAPICallInfo = (CLITrace.CliAPICallInfo)enumeration.nextElement();
                Format.print(printWriter, "%-30s", cliAPICallInfo.getFunctionName());
                Format.print(printWriter, "%-7d", cliAPICallInfo.getTimesCalled());
                Format.print(printWriter, "%-12.3f", cliAPICallInfo.getAppProcessingTime());
                Format.print(printWriter, "%-12.3f", cliAPICallInfo.getCliProcessingTime());
                Format.print(printWriter, "%-6d", cliAPICallInfo.getSendFlows());
                Format.print(printWriter, "%-12d", cliAPICallInfo.getBytesSent());
                Format.print(printWriter, "%-7.3f", cliAPICallInfo.getNetSendProcessingTime());
                Format.print(printWriter, "%-6d", cliAPICallInfo.getRecvFlows());
                Format.print(printWriter, "%-12d", cliAPICallInfo.getBytesRecd());
                Format.print(printWriter, "%-7.3f", cliAPICallInfo.getNetRecvProcessingTime());
                printWriter.println();
            }
        } else {
            printWriter.println("Trace is empty: no function calls. Please check the trace");
        }
        printWriter.println();
        printWriter.println("End of function specific statistics report");
    }

    private void outputOverallStats(PrintWriter printWriter) {
        printWriter.println("Overall Trace statistics");
        printWriter.println("========================================================");
        printWriter.println();
        Format.print(printWriter, "%15d", this.trace.getNumberOfStatements());
        printWriter.println(" statements in trace.");
        Format.print(printWriter, "%15.3f", this.trace.getTotalTraceTime());
        printWriter.println(" seconds total trace time.");
        Format.print(printWriter, "%15.3f", this.trace.getTotalAppProcessingTime());
        printWriter.println(" seconds spent for application processing.");
        Format.print(printWriter, "%15.3f", this.trace.getTotalCliProcessingTime());
        printWriter.println(" seconds spent for CLI processing.");
        printWriter.println();
        printWriter.println("Network Specific CLI processing time statistics");
        printWriter.println("========================================================");
        Format.print(printWriter, "%15d", this.trace.getTotalNetworkSendFlows());
        printWriter.println(" network flows sent to transmit ");
        Format.print(printWriter, "%15d", this.trace.getTotalBytesSent());
        printWriter.println(" bytes, requiring a total of");
        Format.print(printWriter, "%15.3f", this.trace.getTotalNetworkSendProcessingTime());
        printWriter.println(" seconds.");
        printWriter.println();
        Format.print(printWriter, "%15d", this.trace.getTotalNetworkRecvFlows());
        printWriter.println(" network flows received, transmitting ");
        Format.print(printWriter, "%15d", this.trace.getTotalBytesRecd());
        printWriter.println(" bytes, requiring a total of");
        Format.print(printWriter, "%15.3f", this.trace.getTotalNetworkRecvProcessingTime());
        printWriter.println(" seconds.");
        printWriter.println();
        printWriter.println("End of overall trace statistics report");
    }

    private void outputReportFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("==========================================================");
        printWriter.println("                End of CLI Trace Report");
        printWriter.println();
    }

    private void outputReportHeader(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("       CLI Trace Report generated by CLITraceParser (1.04d)");
        printWriter.println("===========================================================");
        printWriter.println();
        printWriter.println("CLI Trace file                    : " + this.files[0]);
        printWriter.println("Lines read in file                : " + this.linesRead);
        if (this.offset != 0L) {
            printWriter.println("Current report processed from line: " + this.offset);
        }
        if (this.trace.getCLITraceVersion() == 6) {
            printWriter.println("Trace build info                  : " + this.trace.getTraceBuild());
        } else {
            printWriter.println("Trace build info                  : ");
            printWriter.println(this.trace.getPIDInfo());
            printWriter.println(this.trace.getDateTime());
            printWriter.println(this.trace.getClientProduct());
            printWriter.println(this.trace.getClientLevel());
            printWriter.println(this.trace.getDriverVersion());
            printWriter.println(this.trace.getInformationalTokens());
        }
        printWriter.println();
    }

    private void outputSeparator(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("*********************************************************************************************************************");
        printWriter.println();
    }

    private void parseCommandLine(String[] stringArray) {
        if (stringArray.length > 3) {
            this.usage();
            System.exit(0);
        }
        if (stringArray.length > 0) {
            for (int i = 0; !(i >= stringArray.length || this.traceFileSet && this.outFileSet && this.conserveMemory); ++i) {
                if (stringArray[i].equals("-help") || stringArray[i].equals("-?")) {
                    this.usageVerbose();
                    System.exit(0);
                }
                if (stringArray[i].equals("-c")) {
                    this.conserveMemory = true;
                    continue;
                }
                if (this.files == null) {
                    this.files = new String[2];
                }
                if (!this.traceFileSet) {
                    this.files[0] = new String(stringArray[i]);
                    this.traceFileSet = true;
                    continue;
                }
                if (!this.outFileSet) {
                    this.files[1] = new String(stringArray[i]);
                    this.outFileSet = true;
                    continue;
                }
                System.out.println("Error: Invalid command line arguments.");
                this.usage();
                System.exit(0);
            }
            if (this.traceFileSet && !this.outFileSet) {
                this.files[1] = this.files[0] + ".out";
            }
        }
        if (!this.traceFileSet) {
            Frame frame = new Frame();
            FileDialog fileDialog = new FileDialog(frame, "Select a CLI Trace file", 0);
            fileDialog.show();
            this.files = new String[2];
            this.files[0] = new String(fileDialog.getDirectory() + fileDialog.getFile());
            this.files[1] = new String(this.files[0] + ".out");
            frame.dispose();
        }
    }

    public static void printVersion(PrintStream printStream) {
        printStream.println();
        printStream.println(version);
        printStream.println();
    }

    public static void printVersion(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println(version);
        printWriter.println();
    }

    public void runParser(String[] stringArray) {
        this.parseCommandLine(stringArray);
        if (this.files[0].equals("")) {
            System.out.println("No input file selected.  Exiting");
            return;
        }
        try {
            this.processor = new CLITraceProcessor(this.files[0]);
            this.linesRead = this.offset == 0L ? this.processor.processTrace(this.conserveMemory) : this.processor.processTrace(this.offset, this.conserveMemory);
        }
        catch (InvalidCliTraceException invalidCliTraceException) {
            this.linesRead = invalidCliTraceException.getLineNumber();
            if (invalidCliTraceException.getErrorCode() == -2 || invalidCliTraceException.getErrorCode() == -4) {
                String[] stringArray2 = new String[]{new String(this.files[0]), this.offsetCounter > 0 ? new String(this.files[1].substring(0, this.files[1].lastIndexOf(".")) + "." + (this.offsetCounter + 1)) : new String(this.files[1] + "." + (this.offsetCounter + 1))};
                if (this.offsetCounter == 0) {
                    this.files[1] = this.files[1] + "." + this.offsetCounter;
                }
                System.err.print("New trace at line " + this.linesRead);
                System.err.println(".  Current trace will be saved as " + this.files[1]);
                CLITraceParser cLITraceParser = new CLITraceParser(this.linesRead, this.offsetCounter + 1);
                cLITraceParser.conserveMemory = this.conserveMemory;
                cLITraceParser.runParser(stringArray2);
            } else if (invalidCliTraceException.getErrorCode() == -3) {
                System.err.println("A fatal Java error occurred while processing the trace.");
                System.err.println("Please report this error to cliparse@ca.ibm.com so that ");
                System.err.println("it can be fixed.  Please send a CLI trace with your report.\n");
                System.err.println("A description of the error follows:\n");
                System.err.println("Exception at line: " + this.linesRead);
                System.err.println("Stack traceback of failing scenario:\n");
                invalidCliTraceException.getException().printStackTrace();
                System.err.println("\n\nStill attempting to produce report.");
            } else {
                System.err.println("Please report this error to cliparse@ca.ibm.com so that ");
                System.err.println("it can be fixed.  Please send a CLI trace with your report.\n");
                System.err.println("The trace file was not completely processed due to the following error:");
                invalidCliTraceException.printStackTrace();
                System.err.println(this.linesRead + " total lines were read");
                System.err.println("Attempting to still produce report");
            }
        }
        catch (Exception exception) {
            System.out.println("\nA fatal occurred while parsing the trace file.");
            System.out.println("Please make certain that you specified a valid trace file.\n");
            System.out.println("Please report this error to cliparse@ca.ibm.com so that ");
            System.out.println("it can be fixed.  Please send a CLI trace with your report.\n");
            System.out.print("\nJava Exception thrown: ");
            System.out.println(exception);
            System.out.println("\nStack traceback of failing scenario.");
            exception.printStackTrace();
            this.usage();
            System.exit(1);
        }
        this.trace = this.processor.getCLITrace();
        try {
            System.out.println("Generating report file:" + this.files[1]);
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(this.files[1]));
            this.outputReportHeader(printWriter);
            this.outputOverallStats(printWriter);
            this.outputSeparator(printWriter);
            this.outputFunctionStats(printWriter);
            this.outputSeparator(printWriter);
            this.outputErrorStats(printWriter);
            this.outputSeparator(printWriter);
            this.outputConnectInfo(printWriter);
            this.outputReportFooter(printWriter);
            printWriter.close();
            System.out.println("Report file " + this.files[1] + " complete.\n");
        }
        catch (Exception exception) {
            System.out.println("\nA fatal error occurred while outputting the results.");
            System.out.println("Please make certain that you specified a valid trace file.\n");
            System.out.println("Please report this error to cliparse@ca.ibm.com so that ");
            System.out.println("it can be fixed.  Please send a CLI trace with your report.\n");
            System.out.print("\nJava Exception thrown: ");
            System.out.println(exception);
            System.out.println("\nStack traceback of failing scenario.");
            exception.printStackTrace();
            this.usage();
            System.exit(0);
        }
    }

    private void usage() {
        System.out.println();
        System.out.println("CLITraceParser -- CLI Trace Parsing Tool");
        System.out.println();
        System.out.println("  For help on this tool");
        System.out.println();
        System.out.println("    CLITraceParser <? | -? | -help>");
        System.out.println();
        System.out.println("  Command line syntax");
        System.out.println();
        System.out.println("  To run, specifying command line parameters:");
        System.out.println();
        System.out.println("    CLITraceParser [-c] [<trace-file> [<results-output-file>]]");
        System.out.println();
        System.out.println("  If <results-output-file> is not specified, it will be called");
        System.out.println("  <trace-file>.out");
        System.out.println();
        System.out.println("  To run with a file dialog to specify input file, simply type: ");
        System.out.println();
        System.out.println("    CLITraceParser [-c]");
        System.out.println();
        System.out.println("  with no file arguments.  In this case, the output file will be called ");
        System.out.println("  called <inputfile>.out.");
        System.out.println();
        System.out.println("  Non file arguments:");
        System.out.println();
        System.out.println("  -c   Conserve memory when analyzing trace.  Analyzes less information.");
        System.out.println("       Good for large trace files or when not enough memory available.  ");
    }

    private void usageVerbose() {
        this.usage();
        System.out.println();
        System.out.println("  Additional Notes:");
        System.out.println();
        System.out.println("  Multiple traces in one file -- automatic results-output-file renaming");
        System.out.println();
        System.out.println("  Some trace files may have what are in effect multiple traces.  These are");
        System.out.println("  identified with multiple occurrences of a Build header in the same trace");
        System.out.println("  file.  In this case, the results-output-file will be modified with an");
        System.out.println("  added extension indicating the relative trace number within the trace file.");
    }
}

