/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cli.traceparse;

import com.ibm.db2.cli.traceparse.CLIAttribute;
import com.ibm.db2.cli.traceparse.CLITrace;
import com.ibm.db2.cli.traceparse.InvalidCliTraceException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class CLIAPIFunction
implements Serializable {
    private final int PARAMCAPACITY = 15;
    private double appProcessingTime;
    private double cliProcessingTime;
    private double netSendProcessingTime;
    private double netRecvProcessingTime;
    private long bytesSent;
    private long bytesRecd;
    private long sendFlows;
    private long recvFlows;
    private String sqlReturnCode;
    private String connectinfo;
    protected Hashtable inputValues;
    protected Hashtable returnValues;
    protected CLITrace trace;
    private long lineNumber;
    private long statementNumber;
    String cliScriptToolSyntax;

    public void addInformationalMessage(String string) throws InvalidCliTraceException {
    }

    public double getAppProcessingTime() {
        return this.appProcessingTime;
    }

    public long getBytesRecd() {
        return this.bytesRecd;
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public double getCliProcessingTime() {
        return this.cliProcessingTime;
    }

    public static CLIAPIFunction getFunction(CLITrace cLITrace, String string, long l, long l2) throws InvalidCliTraceException {
        try {
            CLIAPIFunction cLIAPIFunction = (CLIAPIFunction)Class.forName("com.ibm.db2.cli.traceparse." + string).newInstance();
            cLIAPIFunction.trace = cLITrace;
            cLIAPIFunction.statementNumber = l;
            cLIAPIFunction.lineNumber = l2;
            return cLIAPIFunction;
        }
        catch (Exception exception) {
            System.out.println(exception);
            System.out.println("Please report this error to cliparse@ca.ibm.com so that ");
            System.out.println("it can be fixed.  Please send a CLI trace with your report.\n");
            InvalidCliTraceException invalidCliTraceException = new InvalidCliTraceException("Error: class parsed is not a CLI function.");
            throw invalidCliTraceException;
        }
    }

    public String getFunctionName() {
        String string = this.getClass().getName();
        return string.substring(string.indexOf("SQL"));
    }

    public String getInputValue(String string) {
        CLIAttribute cLIAttribute = (CLIAttribute)this.inputValues.get(string);
        if (cLIAttribute == null) {
            return null;
        }
        return cLIAttribute.getAttributeValue();
    }

    public long getLineNumber() {
        return this.lineNumber;
    }

    public double getNetRecvProcessingTime() {
        return this.netRecvProcessingTime;
    }

    public double getNetSendProcessingTime() {
        return this.netSendProcessingTime;
    }

    public long getRecvFlows() {
        return this.recvFlows;
    }

    public String getReturnCode() {
        return this.sqlReturnCode;
    }

    public String getReturnValue(String string) {
        CLIAttribute cLIAttribute = (CLIAttribute)this.returnValues.get(string);
        if (cLIAttribute == null) {
            return null;
        }
        return cLIAttribute.getAttributeValue();
    }

    public long getSendFlows() {
        return this.sendFlows;
    }

    public long getStatementNumber() {
        return this.statementNumber;
    }

    public void setAppProcessingTime(double d) {
        this.appProcessingTime = d;
    }

    public void setBytesRecd(long l) {
        this.bytesRecd = l;
    }

    public void setBytesSent(long l) {
        this.bytesSent = l;
    }

    public void setCliProcessingTime(double d) {
        this.cliProcessingTime = d;
    }

    public void setInputValues(Enumeration enumeration) throws InvalidCliTraceException {
        if (this.inputValues != null) {
            throw new InvalidCliTraceException("Error: input values already set for this call");
        }
        this.inputValues = new Hashtable(15);
        this.setValues(this.inputValues, enumeration);
    }

    public void setNetRecvProcessingTime(double d) {
        this.netRecvProcessingTime = d;
    }

    public void setNetSendProcessingTime(double d) {
        this.netSendProcessingTime = d;
    }

    public void setRecvFlows(long l) {
        this.recvFlows = l;
    }

    public void setReturnCode(String string) {
        this.sqlReturnCode = string;
        if (!string.equals("SQL_SUCCESS") && !string.equals("SQL_NO_DATA_FOUND")) {
            this.trace.addError(this);
        }
    }

    public void setConnectInformation(String string) {
        if (this.connectinfo != null) {
            this.connectinfo = this.connectinfo.concat("\n").concat(string);
        } else {
            this.connectinfo = string;
            this.trace.addConnectionInfo(this);
        }
    }

    public String getconnectinfo() {
        return this.connectinfo;
    }

    public void setReturnValues(Enumeration enumeration) throws InvalidCliTraceException {
        if (this.returnValues != null) {
            throw new InvalidCliTraceException("Error: return values already set for this call.");
        }
        this.returnValues = new Hashtable(5);
        this.setValues(this.returnValues, enumeration);
    }

    public void setSendFlows(long l) {
        this.sendFlows = l;
    }

    private void setValues(Hashtable hashtable, Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            CLIAttribute cLIAttribute = (CLIAttribute)enumeration.nextElement();
            hashtable.put(cLIAttribute.getAttributeName(), cLIAttribute);
        }
    }
}

