#!/bin/ksh
#-----------------------------------------------------------------------
#--(c) Copyright IBM Corporation 2009  All rights reserved.           --
#--                                                                   --
#--This sample program is owned by International Business Machines    --
#--Corporation or one of its subsidiaries ("IBM") and is copyrighted  --
#--and licensed, not sold.                                            --
#--BY ACCESSING, COPYING, OR USING THIS SAMPLE PROGRAM, YOU AGREE TO  --
#--THE TERMS OF THE AGREEMENT TITLED "International License Agreement --
#--for Non-Warranted db2perf Programs" LOCATED IN THE FILE NAMED      --
#--"license.txt".                                                     --
#--                                                                   --
#-- db2perf_export_explain.ksh                                        --
#-- Steve Rees - srees@ca.ibm.com                                     --
#--                                                                   --
#-- Exports EXPLAIN tables for later import by db2perf_import_explain --
#--                                                                   --
#-- Arguments                                                         --
#--   dbname - database name to import into                           --
#--   export-path - location for IXF files containing EXPLAIN data    --
#--   explain-schema (optional) - schema under which to extract       --
#--      explain tables from, if not the default.                     --
#--                                                                   --
#-----------------------------------------------------------------------


if [ $# -lt 2 -o $# -gt 3 ] ; then
  echo "Usage: $0 dbname export-path [explain-schema]"
  exit 1
fi

db2 -v connect to $1

if [ "$3" != "" ] ; then
  db2 -v set current schema = $3
fi
db2 -v values current schema

for i in EXPLAIN_ARGUMENT EXPLAIN_DIAGNOSTIC EXPLAIN_DIAGNOSTIC_DATA EXPLAIN_INSTANCE EXPLAIN_OBJECT EXPLAIN_OPERATOR EXPLAIN_PREDICATE  EXPLAIN_STATEMENT EXPLAIN_STREAM ; do
  db2 -v export to $2/$i.ixf of ixf lobs to $2 "select * from $i"
done

db2 terminate

schema=""
if [ "$3" != "" ] ; then
  schema="-e $3"
fi

echo db2exfmt -no_prompt $schema -w % -d $1 -o $2/db2perf_plandiff_db2exfmt.out
db2exfmt -no_prompt $schema -w % -d $1 -o $2/db2perf_plandiff_db2exfmt.out
