#!/bin/ksh
#!/bin/ksh
#-----------------------------------------------------------------------
#--(c) Copyright IBM Corporation 2009  All rights reserved.           --
#--                                                                   --
#--This sample program is owned by International Business Machines    --
#--Corporation or one of its subsidiaries ("IBM") and is copyrighted  --
#--and licensed, not sold.                                            --
#--BY ACCESSING, COPYING, OR USING THIS SAMPLE PROGRAM, YOU AGREE TO  --
#--THE TERMS OF THE AGREEMENT TITLED "International License Agreement --
#--for Non-Warranted db2perf Programs" LOCATED IN THE FILE NAMED      --
#--"license.txt".                                                     --
#--                                                                   --
#-- db2perf_import_explain.ksh                                        --
#-- Steve Rees - srees@ca.ibm.com                                     --
#--                                                                   --
#-- Imports EXPLAIN table data previously exported by                 --
#-- db2perf_export_explain.ksh                                        --
#--                                                                   --
#-- Arguments                                                         --
#--   dbname - database name to import into                           --
#--   import-path - location of IXF files containing EXPLAIN data     --
#--   explain-schema (optional) - schema under which to create        --
#--      explain tables.  Script fails if they already exist to avoid --
#--      accidental overwrites.                                       --
#-----------------------------------------------------------------------


if [ $# -lt 2 -o $# -gt 3 ] ; then
  echo "Usage: $0 dbname import-path [explain-schema]"
  exit 1
fi

db2 -v connect to $1

if [ "$3" != "" ] ; then
  db2 -v set current schema = $3
  modifier="modified by indexschema=$3"
fi
db2 -v values current schema

for i in EXPLAIN_ARGUMENT EXPLAIN_DIAGNOSTIC EXPLAIN_DIAGNOSTIC_DATA EXPLAIN_INSTANCE EXPLAIN_OBJECT EXPLAIN_OPERATOR EXPLAIN_PREDICATE  EXPLAIN_STATEMENT EXPLAIN_STREAM ; do
  db2 -v import from $2/$i.ixf of ixf lobs from $2 $modifier create into $i
done

db2 terminate

