@
CREATE PROCEDURE VO.GetWishedTitles (
      IN MID INT )
    RESULT SETS 1
    LANGUAGE SQL
------------------------------------------------------------------------
-- SQL Stored Procedure VO.GetMyWishedFull
-- Result Set 1 - Returns Full Wished List based on specified MemberID
------------------------------------------------------------------------
P1: BEGIN
    -- Declare cursor 1
    DECLARE cursor1 CURSOR WITH RETURN TO CALLER FOR
        SELECT
            VO.TITLE.TITLEID AS TITLEID,
            VO.TITLE.NAME AS TITLENAME,
            VO.TITLEAVAILABILITY(VO.TITLE.TITLEID) AS AVAILABILITYICON,
            VO.TITLE.IMAGEFILE AS IMAGEFILE,
            VO.TITLERATING(VO.TITLESTATS.AVGCUSTOMERRATING) AS CUSTRATINGICON,
            VO.TITLERATING(VO.TITLESTATS.AVGCRITICRATING) AS CRITRATINGICON,
            VO.TITLESTATS.RANK AS MOVIERANK,
            VO.WISHEDTITLES.DATEADDED AS DATEADDED,
            VO.TITLEPERSON.PERSONID AS PERSONID,
            VO.PERSON.FIRSTNAME AS PERSONFIRSTNAME,
            VO.PERSON.LASTNAME AS PERSONLASTNAME
        FROM
           VO.WISHEDTITLES,
           VO.TITLESTATS,
           VO.TITLE,
           VO.TITLEPERSON,
           VO.PERSON
        WHERE
                VO.WISHEDTITLES.CUSTOMERID = MID
          AND   VO.TITLE.TITLEID = VO.WISHEDTITLES.TITLEID
          AND   VO.TITLESTATS.TITLEID = VO.WISHEDTITLES.TITLEID
          AND   VO.TITLEPERSON.TITLEID = VO.WISHEDTITLES.TITLEID
          AND   VO.PERSON.PERSONID = VO.TITLEPERSON.PERSONID
        ORDER BY DATEADDED DESC, TITLEID;
    -- Cursor left open for client application
    OPEN cursor1;
END P1
@
