Attribute VB_Name = "DBUtil"
'create and return ADO Connection Object.
Public Function SAMPLE_GetConnection( _
        Optional strUserName As String = "", _
        Optional strPassword As String = "") As ADODB.Connection
    On Error GoTo SAMPLE_ErrHandler

    Dim strConnectionString As String
    strConnectionString = "Provider=IBMDADB2; DSN=SAMPLE"
    If strUserName <> "" And strPassword <> "" Then
        strConnectionString = strConnectionString & "; User ID=" & strUserName _
                 & "; Password=" & strPassword
    End If
    'Create new ADO connection object
    Dim adoConnection As New ADODB.Connection
    With adoConnection
        .CursorLocation = adUseClient
        .ConnectionString = strConnectionString
    End With

    'Open ADO Connection Object
   ' Call adoConnection.Open

    'Return new ADO connection object
    Set SAMPLE_GetConnection = adoConnection
    Exit Function

SAMPLE_ErrHandler:
    MsgBox "Error Code: " & Err.Number & vbNewLine & _
            "Description: " & Err.Description & vbNewLine & _
            "Source: " & Err.Source, _
            vbOKOnly + vbCritical
    Err.Clear
    Set SAMPLE_GetConnection = Nothing
End Function



    'Create and execute a command object. Return a RecordSet object
Public Function GETNONWISHEDTITLES_ExecuteCommand(ByRef adoConnection As ADODB.Connection, _
                ByVal vMID As Long) _
                As ADODB.Recordset
    'create ADOCommand Object.
    Dim adoCommand As ADODB.Command
    Dim adoRecordSet As ADODB.Recordset

    On Error GoTo GETNONWISHEDTITLES_ExecuteCommand_ErrHandler

    Set adoCommand = New ADODB.Command

    With adoCommand
        .CommandType = adCmdStoredProc
        .ActiveConnection = adoConnection
        .CommandText = "VO.GETNONWISHEDTITLES"
    End With

    'Add Parameters to the Command object
    Dim adoParm As Parameter
    Set adoParm = adoCommand.CreateParameter("MID", _
                    adInteger, _
                    adParamInput, _
                    Value:=vMID)
    Call adoCommand.Parameters.Append(adoParm)
    Set adoRecordSet = New ADODB.Recordset
    adoRecordSet.Open adoCommand, , adOpenStatic, adLockOptimistic

    'Return the record set object object
    Set GETNONWISHEDTITLES_ExecuteCommand = adoRecordSet
    Set adoCommand = Nothing
    Exit Function

GETNONWISHEDTITLES_ExecuteCommand_ErrHandler:
    If adoConnection.Errors.Count > 0 Then
        MsgBox "Error code:  " & adoConnection.Errors(0).Number & vbNewLine & _
                "Description: " & adoConnection.Errors(0).Description & vbNewLine & _
                "Source:      " & adoConnection.Errors(0).Source, _
                vbOKOnly + vbCritical
        adoConnection.Errors.Clear
    Else
        MsgBox "Error code:  " & Err.Number & vbNewLine & _
                "Description: " & Err.Description & vbNewLine & _
                "Source:      " & Err.Source, _
                vbOKOnly + vbCritical
        Err.Clear
    End If
End Function


    'Create and execute a command object. Return a RecordSet object
Public Function XGETWISHEDTITLES_ExecuteCommand(ByRef adoConnection As ADODB.Connection, _
                ByVal vMID As Long, _
                ByRef vXML As String) _
                As ADODB.Recordset
    'create ADOCommand Object.
    Dim adoCommand As ADODB.Command
    Dim adoRecordSet As ADODB.Recordset

    On Error GoTo XGETWISHEDTITLES_ExecuteCommand_ErrHandler

    Set adoCommand = New ADODB.Command

    With adoCommand
        .CommandType = adCmdStoredProc
        .ActiveConnection = adoConnection
        .CommandText = "VO.XGETWISHEDTITLES"
    End With

    'Add Parameters to the Command object
    Dim adoParm As Parameter
    Set adoParm = adoCommand.CreateParameter("MID", _
                    adInteger, _
                    adParamInput, _
                    Value:=vMID)
    Call adoCommand.Parameters.Append(adoParm)
    Set adoParm = adoCommand.CreateParameter("XML", _
                    adVarChar, _
                    adParamOutput, _
                    32000)
    Call adoCommand.Parameters.Append(adoParm)
    Set adoRecordSet = New ADODB.Recordset
    adoRecordSet.Open adoCommand, , adOpenStatic, adLockOptimistic

    'Get the output values
    vXML = adoCommand.Parameters("XML").Value
    'Return the record set object object
    Set XGETWISHEDTITLES_ExecuteCommand = adoRecordSet
    Set adoCommand = Nothing
    Exit Function

XGETWISHEDTITLES_ExecuteCommand_ErrHandler:
    If adoConnection.Errors.Count > 0 Then
        MsgBox "Error code:  " & adoConnection.Errors(0).Number & vbNewLine & _
                "Description: " & adoConnection.Errors(0).Description & vbNewLine & _
                "Source:      " & adoConnection.Errors(0).Source, _
                vbOKOnly + vbCritical
        adoConnection.Errors.Clear
    Else
        MsgBox "Error code:  " & Err.Number & vbNewLine & _
                "Description: " & Err.Description & vbNewLine & _
                "Source:      " & Err.Source, _
                vbOKOnly + vbCritical
        Err.Clear
    End If
End Function


    'Create and execute a command object. Return a RecordSet object
Public Function XWISHEDTITLESADD_ExecuteCommand(ByRef adoConnection As ADODB.Connection, _
                ByVal vMID As Long, _
                ByVal vTITLES As String) _
                As ADODB.Recordset
    'create ADOCommand Object.
    Dim adoCommand As ADODB.Command
    Dim adoRecordSet As ADODB.Recordset

    On Error GoTo XWISHEDTITLESADD_ExecuteCommand_ErrHandler

    Set adoCommand = New ADODB.Command

    With adoCommand
        .CommandType = adCmdStoredProc
        .ActiveConnection = adoConnection
        .CommandText = "VO.XWISHEDTITLESADD"
    End With

    'Add Parameters to the Command object
    Dim adoParm As Parameter
    Set adoParm = adoCommand.CreateParameter("MID", _
                    adInteger, _
                    adParamInput, _
                    Value:=vMID)
    Call adoCommand.Parameters.Append(adoParm)
    Set adoParm = adoCommand.CreateParameter("TITLES", _
                    adVarChar, _
                    adParamInput, _
                    4000, _
                    Value:=vTITLES)
    Call adoCommand.Parameters.Append(adoParm)
    Set adoRecordSet = New ADODB.Recordset
    adoRecordSet.Open adoCommand, , adOpenStatic, adLockOptimistic

    'Return the record set object object
    Set XWISHEDTITLESADD_ExecuteCommand = adoRecordSet
    Set adoCommand = Nothing
    Exit Function

XWISHEDTITLESADD_ExecuteCommand_ErrHandler:
    If adoConnection.Errors.Count > 0 Then
        MsgBox "Error code:  " & adoConnection.Errors(0).Number & vbNewLine & _
                "Description: " & adoConnection.Errors(0).Description & vbNewLine & _
                "Source:      " & adoConnection.Errors(0).Source, _
                vbOKOnly + vbCritical
        adoConnection.Errors.Clear
    Else
        MsgBox "Error code:  " & Err.Number & vbNewLine & _
                "Description: " & Err.Description & vbNewLine & _
                "Source:      " & Err.Source, _
                vbOKOnly + vbCritical
        Err.Clear
    End If
End Function


