VERSION 5.00

Begin VB.Form Sam1Init 

   Caption         =   "Initialization, Login, Logout, and Terminate"

   ClientHeight    =   1575

   ClientLeft      =   60

   ClientTop       =   345

   ClientWidth     =   5175

   LinkTopic       =   "Form1"

   ScaleHeight     =   1575

   ScaleWidth      =   5175

   StartUpPosition =   3  'Windows Default

   Begin VB.CommandButton cmdLogout 

      Caption         =   "EsbLogout()"

      Enabled         =   0   'False

      Height          =   375

      Left            =   1800

      TabIndex        =   4

      Top             =   1080

      Width           =   1575

   End

   Begin VB.CommandButton cmdTerm 

      Caption         =   "EsbTerm()"

      Enabled         =   0   'False

      Height          =   375

      Left            =   3480

      TabIndex        =   3

      Top             =   1080

      Width           =   1575

   End

   Begin VB.CommandButton cmdGetAPIVers 

      Caption         =   "EsbGetAPIVersion()"

      Height          =   375

      Left            =   120

      TabIndex        =   2

      Top             =   120

      Width           =   1575

   End

   Begin VB.CommandButton cmdInit 

      Caption         =   "EsbInit()"

      Height          =   375

      Left            =   120

      TabIndex        =   1

      Top             =   600

      Width           =   1575

   End

   Begin VB.CommandButton cmdAutoLogin 

      Caption         =   "EsbAutoLogin()"

      Enabled         =   0   'False

      Height          =   375

      Left            =   1800

      TabIndex        =   0

      Top             =   600

      Width           =   1575

   End

End

Attribute VB_Name = "Sam1Init"

Attribute VB_GlobalNameSpace = False

Attribute VB_Creatable = False

Attribute VB_PredeclaredId = True

Attribute VB_Exposed = False

Option Explicit



'*** Always obtain and process the return error status

  Dim lngStatus As Long  ' Return error status



'*** EsbGetAPIVersion()needs the following

  Dim lngAPIVersion As Long



'*** EsbInit() accepts an initialization structure

'***   and returns an instance handle

  Dim structInit  As ESB_INIT_T  ' Create an instance of the initialization structure

  Dim lngInstHndl As Long        ' Instance handle for program (returned by EsbInit())



'*** EsbGetMessage() (enabled by cmdInit()) needs the following

'*** (see EsbListMessages() for intMsgLen and strMsg)

  Dim intMsgLev  As Integer  ' Whether information/warning/serious error/fatal error

  Dim lngMsgNmbr As Long     ' Message number in Essbase.mdb



'*** EsbAutoLogin()needs the following

  Dim strServer   As String * ESB_SVRNAMELEN   ' Empty string okay

  Dim strUser     As String * ESB_USERNAMELEN  ' Empty string okay

  Dim strPassword As String * ESB_PASSWORDLEN  ' Empty string okay

  Dim strAppName  As String * ESB_APPNAMELEN   ' Empty string okay

  Dim strDbName   As String * ESB_DBNAMELEN    ' Empty string okay

  Dim intOption   As Integer  ' Flags whether to display dialog box, allow user to log

                              '   in without selecting the application/database, or

                              '   allow user to interact with dialog box to log in and

                              '   select the application/database

  Dim intAccess  As Integer  ' User's access level to application/database

  Dim lngCtxHndl As Long     ' Context handle for login (returned by EsbAutoLogin()

                      

'***

' Initialized, logged in, able to log out, able to terminate

' Ready to work with databases, users, objects

'***



'*** MORE DECLARATIONS HERE OR IN SUB PROCEDURES

  Dim intArrayIndex As Integer ' Declare an integer, for example



Public Sub Main()

End Sub





Private Sub ESB_ListErrorStackMsgs()



'*** EsbGetMessage() needs the following

'*** (see Declarations for intMsgLev and lngMsgNmbr)

  Const intMsgLen = 256             ' Set maximum message length as a constant,

  Dim strMsg As String * intMsgLen  '   then Dim message string at that length

  

'*** Get all messages from error stack and display them in list box

  lngStatus = EsbGetMessage(lngInstHndl, intMsgLev, lngMsgNmbr, strMsg, intMsgLen)

                           ' Retrieves strMsg from stack and decrements stack pointer

  

  Dim intStackNmbr As Integer  ' To track the number of messages on the error stack

  intStackNmbr = 1

  

  Do While Mid$(strMsg, 1, 1) <> Chr$(0)  ' Do while the error stack has messages

    MsgBox "Error stack #" & (intStackNmbr) & " is level #" & (intMsgLev) _

           & "/message #" & (lngMsgNmbr)

    intStackNmbr = intStackNmbr + 1       ' Increment the stack number displayed

    lngStatus = EsbGetMessage(lngInstHndl, intMsgLev, lngMsgNmbr, strMsg, intMsgLen)

  Loop

  

End Sub





Private Sub cmdAutoLogin_Click()

  

  intOption = ESB_AUTO_DEFAULT  ' Allows user to interact with login dialog box

  

'*** Call EsbAutoLogin() and obtain the return error status

  lngStatus = EsbAutoLogin(lngInstHndl, _

                           strServer, strUser, strPassword, _

                           strAppName, strDbName, _

                           intOption, _

                           intAccess, _

                           lngCtxHndl)  ' EsbAutoLogin() returns a unique

                                        '   context handle for each login, even if the

                                        '   user and server are the same



'*** Display the return error status

  If lngStatus = 0 Then

    MsgBox "This login ID (context handle) is logged in: " & (lngCtxHndl)

    Call ESB_ListErrorStackMsgs   ' Even successful logins return useful messages

    cmdAutoLogin.Enabled = False  ' True would allow other login IDs (context handles)  cmdLogout.Enabled = True

    cmdLogout.Enabled = True      ' Log out;

    cmdTerm.Enabled = False       '   then terminate the API

  Else

    MsgBox "Login failed: " & (lngStatus)

    Call ESB_ListErrorStackMsgs   ' Always handle messages if function call fails

  End If

  

End Sub









Private Sub cmdGetAPIVers_Click()



'***

' You can call EsbGetAPIVersion() before or after you call EsbInit()

'***



'*** Call EsbGetAPIVersion() and obtain the return error status

  lngStatus = EsbGetAPIVersion(lngAPIVersion)

 

'*** Display the API version or that the call failed

  If lngStatus = 0 Then

    MsgBox "The API version is " & (lngAPIVersion)

  Else

    MsgBox "EsbGetAPIVersion() failed: " & (lngStatus)

  End If



End Sub





Private Sub cmdInit_Click()

 

'*** Initialize the structure before you call EsbInit()

  structInit.Version = ESB_API_VERSION

  structInit.MaxHandles = 10

  structInit.LocalPath = "D:\Essbase\Client"  ' <ARBORPATH>\Client is the default

  structInit.MessageFile = ""                 ' The default message file

  structInit.ClientError = ESB_TRUE           ' Enables EsbGetMessage() to retrieve

                                              '   top message in stack

  structInit.ErrorStack = 100                 ' No. of messages allowed in stack;

                                              '   stack initialized on each call

  

'*** Call EsbInit() to initialize the API; obtain the return error status

  lngStatus = EsbInit(structInit, lngInstHndl)

  

'*** Display the return error status

  If lngStatus = 0 Then

    MsgBox "The API is initialized: " & (lngInstHndl)

    cmdAutoLogin.Enabled = True  ' You can log in only after you initialize the API

    cmdInit.Enabled = False      ' Initialization endures until you terminate the API

    cmdTerm.Enabled = True

  Else

    MsgBox "The API failed to initialize: " & (lngStatus)

  End If

  

End Sub





Private Sub cmdLogout_Click()



'*** Call EsbLogout() and obtain return error status

  lngStatus = EsbLogout(lngCtxHndl)  ' Logs user out for the specified login context

  

'*** Display whether the logout succeeded or failed

  If lngStatus = 0 Then  ' Should test that all login IDs (contexts) are logged out

    MsgBox "This login ID (context handle) is logged out: " & (lngCtxHndl)

    cmdLogout.Enabled = False  ' Log out;

    cmdTerm.Enabled = True     '   then terminate the API

  Else

    MsgBox "EsbLogout() failed: " & (lngStatus)

  End If



End Sub



Private Sub cmdTerm_Click()

  

'*** Call EsbTerm() after all other calls are completed

  EsbTerm (lngInstHndl)

  

'*** Display whether the API terminated

  If lngStatus = 0 Then

    MsgBox "The API is terminated"

    cmdGetAPIVers.Enabled = True  ' After you terminate the API,

    cmdInit.Enabled = True        '   you can call only EsbInit() and EsbGetVersion()

    cmdTerm.Enabled = False

    cmdAutoLogin.Enabled = False

  Else

    MsgBox "EsbTerm() failed: " & (lngStatus)

  End If

 

End Sub





Private Sub Form_Load()



' *** Must set boolean values in the form

  ESB_TRUE = 1   ' ESB_TRUE

  ESB_FALSE = 0  '   and ESB_FALSE are variables, not constants



End Sub





