profiles = new Array(
    "Aggregate Storage Applications, Databases, and Outlines||This chapter provides information about creating aggregate storage applications, databases, and outlines and discusses the differences between aggregate storage databases and block storage databases in regard to the creation of applications, databases, and outlines. To use the information in these topics, you should be familiar with application, database, and outline concepts for block storage databases. For information about these concepts, see Creating Applications and Databases , Creating and Changing Database Outlines , Setting Dimension and Member Properties , and Working with Attributes . Aggregate storage applications and databases and block storage applications and databases differ in both concept and design. Some block storage outline features do not apply to aggregate storage. For example, the concept of dense and sparse dimensions does not apply. Also, in aggregate storage outlines, formulas are allowed only within the dimension tagged as accounts and must be written in MDX syntax. For a full list of differences, see Comparison of Aggregate and Block Storage . A new sample application (ASOsamp), a data file, and a rules file are provided to demonstrate aggregate storage functionality. This chapter includes the following topics: Workflow for Creating Aggregate Storage Applications Creating Aggregate Storage Applications, Databases, and Outlines Developing Formulas on Aggregate Storage Outlines Using a Transparent Partition to Enable Write-Back for Aggregate Storage Databases Workflow for Creating Aggregate Storage Applications This topic provides a high-level workflow for creating an aggregate storage application. Create an aggregate storage application, database, and outline. See Creating Aggregate Storage Applications, Databases, and Outlines . Use tablespaces to optimize data storage and retrieval. See Managing Storage for Aggregate Storage Applications . Specify the maximum size of the aggregate storage cache. See Managing the Aggregate Storage Cache . Load data into the aggregate storage database. A data load can be combined with a dimension build. See Preparing Aggregate Storage Databases . You can preview a subset of the data in Essbase Administration Services. See Previewing Data in Essbase Administration Services Online Help . Precalculate chosen aggregations to optimize retrieval time. See Calculating Aggregate Storage Databases . View database statistics. See Viewing Aggregate Storage Statistics in Essbase Administration Services Online Help . If required, enable write-back by using the Aggregate Storage Partition Wizard. See Using a Transparent Partition to Enable Write-Back for Aggregate Storage Databases . View data using Hyperion tools (for example Essbase Spreadsheet Add-in) or third-party tools. Creating Aggregate Storage Applications, Databases, and Outlines You must create an aggregate storage application to contain an aggregate storage database. An aggregate storage application can contain only one database. You can create an aggregate storage application, database, and outline in the following ways: Convert a block storage outline to an aggregate storage outline, and create an aggregate storage application to contain the converted database and outline. Note: An aggregate storage outline cannot be converted to a block storage outline. Create an aggregate storage application and database. The aggregate storage outline is created automatically when you create the database. For information on loading dimensions and members into an aggregate storage outline, see Building Dimensions in Aggregate Storage Databases and Loading Data into Aggregate Storage Databases . Aggregate storage application and database information differs from block storage information, and specific naming restrictions apply to aggregate storage applications and databases. For information on the differences, see Inherent Differences Between Aggregate Storage and Block Storage . To convert a block storage outline to an aggregate storage outline, use any of the following methods: Tool Topic Location Administration Services Aggregate Storage Outline Conversion Wizard Essbase Administration Services Online Help MaxL create outline Technical Reference Note: Do not use the file system to copy a block storage outline into an aggregate storage application. Use the Aggregate Storage Outline Conversion Wizard in Essbase Administration Services to convert the outline. To create an aggregate storage application, use any of the following methods: Tool Topic Location Administration Services Creating Applications Essbase Administration Services Online Help MaxL create application Technical Reference To create an aggregate storage database use any of the following methods: Tool Topic Location Administration Services Creating Databases Essbase Administration Services Online Help MaxL create database Technical Reference When creating aggregate storage applications, databases, and outlines, you need to consider differences between aggregate storage and block storage and issues specific to aggregate storage. For information about such differences and issues, see the following topics: Outline Paging Optimizing Outline Paging Choosing an Accounts Dimension Attribute Dimensions Verifying Outlines Outline Paging Aggregate storage database outlines are pageable. This feature may significantly reduce memory usage for very large database outlines. For aggregate storage databases, Essbase Analytic Services preloads part of the database outline into memory. Then, during data retrieval, Analytic Services pages other parts of the outline into memory as required. When you create an aggregate storage database, the outline is created in a pageable format. When you use the Aggregate Storage Outline Conversion Wizard to convert an existing block storage outline to aggregate storage, the outline is automatically converted to a pageable format. Paging an outline into memory enables Analytic Services to handle very large outlines (for example, 10 million or more members), but potentially increases data retrieval time. You can customize outline paging to obtain the optimum balance between memory usage and data retrieval time. For configuration information, see Optimizing Outline Paging . Note: Aggregate storage databases that have pageable outlines contain memory pages, and therefore their outline files may be larger than binary, block storage database outline files. Outline Paging Limits The maximum size of a buildable outline (the number of members) depends on a number of factors: The available memory for Analytic Services The amount of memory in Analytic Services allocated for other uses The amount of memory required for each member (and aliases for each member) Table1 shows the amount of addressable memory available for Analytic Services for different operating systems. Table 1: Addressable Memory Per Operating System  Operating System Addressable Memory Windows 2000, Windows 2003, Window XP 2 GB addressable memory 1.85 GB available to any application, including Analytic Services Windows 2000 Advanced Server Windows 2003 Advanced Server 3 GB Requires a setting in the boot.ini file AIXU 2 GB Up to 8 (256 MB) segments AIX 5. x 3.25 GB Up to 13 (256 MB) segments. Requires setting the LDR_CNTRL environment variable to: 0xD0000000@DSA HP-UX 2.9 GB Requires using the following command to set the addressable memory for the Essbase server process, ESSSVR: chatr +q3p enable ESSSVR Solaris, Linux 3.9 GB available by default Analytic Services uses about 40 MB of memory on startup. In addition, the various caches require the following memory allocations: Outline paging cache: 8 MB Aggregate storage data cache: 32 MB Aggregate storage aggregation cache: 10 MB Therefore, the initial memory footprint for Analytic Services is about 90 MB. In addition, memory has to be allocated to process incoming query requests. A typical amount of memory to reserve for this purpose is about 300 MB. The total memory allocated for Analytic Services is therefore 390 MB. On a Windows system with 1.85 GB of addressable memory, the amount available to build and load the outline is about 1.46 GB (1.85 GB - 390 MB = 1.46 GB). The maximum size of an outline depends on whether the outline is built using a dimension build or is built from an outline already loaded into Analytic Services. Dimension Build Limit To build the outline by using a dimension build, Analytic Services allocates about 100 bytes per member, plus the size of the member name, plus the size of all alias names for the member (up to 10 aliases are allowed). For a sample outline (using a single byte codepage) where the average member name is 15 characters and there is one alias (of 20 characters) per member, the memory requirement for each member that is added is: 100 + 15 + 20 bytes = 135 bytes The total number of members that can be added in a dimension build is the available memory (1.46 GB, or 153092060 bytes) divided by the number of bytes per member (135), which equals approximately 11 million members. On systems with more than 2 GB of addressable memory, the outline can be larger in proportion to the extra memory that is available. When the dimension build is complete, a databaseName .otn file is saved in the database directory. The .otn file is used as input for the outline restructuring process, which replaces the old outline with the new one. During restructuring, two copies of the outline are loaded into memory, the old one (potentially empty), and the new one, so the maximum size of an outline that can be restructured depends on the size of the old outline. In a dimension build, which starts with an empty outline, only one outline is loaded into memory. Loaded Outline Limit The memory requirement for an outline loaded into Analytic Services at runtime or during restructuring is different from the memory requirements for a dimension build. Analytic Services allocates about 60 bytes per member, plus the size of the member name plus 5 bytes, plus the size of all alias names for the member (up to 10 aliases are allowed) plus 5 bytes. For a sample outline where the average member name is 15 characters and there is one alias (of 20 characters) per member, the memory requirement for each member that is added is: 60 + 15 + 5 + 20 + 5 bytes = 105 bytes per member Assuming 1.46 GB of available memory, the maximum size of an outline that can be loaded is one with 14 million members (1.46GB/105bytes). The 14 million members are the sum of two outlines that are loaded during restructuring. For example, if an existing outline has 5 million members, the new outline can have a maximum of 9 million members. In an incremental dimension build, it is recommended to build the smaller dimensions first and the larger ones last to allow for a maximum outline size. Optimizing Outline Paging Depending on how you want to balance memory usage and data retrieval time, you can customize outline paging for aggregate storage outlines by using one or more of the following settings in the essbase.cfg file: PRELOADMEMBERNAMESPACE to turn off preloading of the member namespace. See Member and Alias Namespaces . PRELOADALIASNAMESPACE to turn off preloading of the alias namespace. See Member and Alias Namespaces . OPGCACHESIZE to change the size of the outline paging cache. See Outline Paging Cache . For specific information on these configuration file settings for outline paging, see the Technical Reference . Member and Alias Namespaces When Analytic Services loads an outline, it attempts to load into memory the namespaces for both member names and all alias tables to allow optimal performance during name lookup. Name lookup is used during data load, and during report, spreadsheet, and MDX queries. If the available memory does not allow all namespaces to be preloaded, the alias name space is left on disk and paged in on demand. If there is still not enough memory, the member namespace is also left on disk and paged in on demand. If memory calculations indicate that it is possible to build and restructure a particular outline if one or both namespaces are not preloaded, you can set one or both of the PRELOADMEMBERNAMESPACE and PRELOADALIASNAMESPACE configuration settings to FALSE to turn off preloading the namespaces. Not preloading the namespaces will have a severe performance impact but could be a temporary measure to be build a very large outline. After the outline is built and restructured Analytic Services can be restarted with the namespace settings set back to their default TRUE (on) setting. Outline Paging Cache For aggregate storage outlines, member data resides in pages in the outline ( .otl ) file. These pages are brought into memory whenever some member information is needed. To maximize performance for outline paging, pages are loaded into the outline paging cache. The outline paging cache uses a 'least recently used' algorithm (LRU), which means pages loaded into the cache to satisfy a member data request remain in the cache until they have to make room for new pages to be brought in. Page content is organized to provide maximum locality of reference, that is, a good number of a member's siblings are most likely on the same page. Therefore, subsequent requests for the same data or even similar data are executed much more quickly than they would be otherwise. The default cache size is 8MB and the page size for all supported operating systems is 8192 bytes. Therefore, 1024 pages can be loaded into the cache at any one time. For very large outlines, performance may be improved by increasing the cache size. To find out if it makes sense to increase the cache you must determine the cache hit rate (the percent of requested pages that are found in the cache). To determine the cache hit rate, use any of the following methods: Tool Topic Location MaxL query application Technical Reference ESSCMD GETOPGCACHESTATISTICS Technical Reference For example, use the following MaxL statement to see information on the effectiveness of the current setting for outline paging cache size (including the number of pages read into the cache, the number of pages found in the cache, and the hit rate): query application APP-NAME get opg_cache statistics;. If the hit rate is low, increasing the cache size might make sense. However, increasing the cache size requires additional memory, which impacts the number of members that can be loaded. Outline Paging File For aggregate storage outlines, the outline file ( .otl ) is pageable and contains outline data organized in pages of 8192 bytes. Pageable outline files are larger than traditional outline files. Although the data is packed in a way to provide maximum page fill, empty space in the pages results in larger files. The outline paging file is organized into the following sections, each of which contains a specific type of outline data: Member Data Member Name Name Space Member Formula Member UDA (User defined attributes) Member UDA Name Space Attribute to Base Member Association Member Comment Extended Member Comment Member Alias Name Space Each dimension in the outline contains all of these sections except for the namespaces. For each alias table there is one member namespace and one alias namespace. The sections are organized as balanced binary trees (BTREE). You cannot view the content of outline paging files directly. Rather, you must use a MaxL statement or ESSCMD command. To view information about the outline paging file, use any of the following methods: Tool Topic Location MaxL query database Technical Reference ESSCMD GETOPGDIMSTATISTICS Technical Reference For example, to display information about the outline paging file, including BTREE information, number of keys, number of pages, and number of levels in the tree, use the following MaxL statement: query database DBS-NAME get opg_state of TABLE-TYPE for dimension DIM-NAME Note: The information about the outline paging file is mostly valuable to the Analytic Services technical support team. However, you might find the number of keys to be useful. In any given section, the number of keys is equivalent to the number of records in that section. For example, the number of keys in the Member Formula section is the number of formulas for that dimension. Likewise, the number of keys in the Member Data section is the number of members in that dimension, so you can use query database to see the number of members for each dimension in the outline. Choosing an Accounts Dimension For aggregate storage databases, only the accounts dimension (the dimension tagged as accounts) can contain member formulas. All calculations performed on the accounts dimension happen at data retrieval time (when the database is queried). In most cases, the need for formulas on the dimension dictates which dimension you choose to tag as the accounts dimension. However, if there is more than one option for which dimension you tag as accounts, use the following criteria in the specified order: Choose a flat dimension, a dimension that does not have many levels (for example, less than three levels). Of two equally flat dimensions, choose the densest dimension, the dimension with the highest probability that data exists for every combination of dimension members. Of two equally flat, dense dimensions, choose the larger dimension. If you are converting a block storage outline to an aggregate storage outline and the dimension currently tagged as accounts contains only the addition (+) operator, consider choosing a different dimension as the accounts dimension or having no accounts dimension. Analytic Services uses the accounts dimension to enable data compression, which is most effective when the accounts dimension is dense. Therefore, an outline with no accounts dimension may be a good choice for outlines that have the following characteristics: All dimensions have a low probability that data exists for every combination of dimension members (the more important criteria). All dimensions have hierarchies of more than two levels. Attribute Dimensions This topic provides information on the differences between aggregate storage databases and block storage databases in regard to attribute dimensions. To use the information in this topic, you should be familiar with attribute dimension concepts for block storage databases. For information about these concepts, see Working with Attributes. The following information applies to attribute dimensions when used on aggregate storage databases: Only the Sum calculation is available for attribute calculations. Attribute dimensions can be associated with any dimension except the dimension tagged as accounts. Attribute dimensions have no impact on data load time or aggregated storage database size. Retrievals that query attribute dimensions are calculated at retrieval time. Note: Calculation order may affect calculation results. Aggregate storage calculation order and block storage calculation order may differ. For information on aggregate storage calculation, see Loading, Calculating, and Retrieving Aggregate Storage Data . Verifying Outlines Aggregate storage outline files have the same file extension ( .otl ) as block storage database outline files and are stored in an equivalent directory structure. When you save an outline, Analytic Services verifies it for errors. You can also verify the accuracy of an outline before you save it. Some block storage database features do not apply to aggregate storage databases, and the verification process considers the rules for aggregate storage databases. For a full list of outline feature differences, see Comparison of Aggregate and Block Storage . To verify an aggregate storage outline, use the following method: Tool Topic Location Administration Services Verifying Outlines Essbase Administration Services Online Help Developing Formulas on Aggregate Storage Outlines Formulas calculate relationships between members in a database outline. If you are familiar with using formulas on block storage outlines, keep in mind the following differences when using formulas on aggregate storage outlines: Apply formulas directly to members in the database outline. For block storage databases, formulas can be placed in a calculation script. You cannot place formulas in a calculation script. Apply formulas to members of the dimension tagged as accounts. In block storage outlines, formulas can be written for members in any dimension. Analytic Services provides a native calculation language (referred to as the Calc language, or Calc) to write formulas on block storage outlines. To write formulas for aggregate storage outlines, the MDX (Multidimensional Expressions) language is required. The current chapter concentrates on using MDX to write formulas on aggregate storage databases. For information about using MDX to write queries, see Writing MDX Queries. For information about writing formulas for block storage outlines, see Developing Formulas. For a reference to MDX functions and syntax, see the MDX section of the Technical Reference . Using MDX Formulas An MDX formula must always be an MDX numeric value expression. In MDX, a numeric value expression is any combination of functions, operators, and member names that does one of the following: Calculates a value Tests for a condition Performs a mathematical operation A numeric value expression is different from a set expression. A set expression is used on query axes and describes members and member combinations. A numeric value expression is used to specify a value. A numeric value expression is used in queries to build calculated members. Calculated members are logical members created for analytical purposes in the WITH section of the query, but which do not exist in the outline. The following query defines a calculated member and uses a numeric value expression to provide a value for it: WITH MEMBER [Measures].[Prod Count] AS 'Count ( Crossjoin ( [Units] , [Products].children ) )' SELECT [Geography].children ON COLUMNS, Crossjoin ( [Units] , [Products].children ), ([Measures].[Prod Count], [Products]) ON ROWS FROM ASOSamp.Sample In the sample query, the WITH clause defines a calculated member, Product Count, in the Measures dimension, as follows: WITH MEMBER [Measures].[Prod Count] The numeric value expression follows the WITH clause and is enclosed in single quotation marks. In the sample query, the numeric value expression is specified as follows: 'Count ( Crossjoin ( [Units] , [Products].children ) )' Note: For an explanation of the syntax rules used to build the numeric value expression in the example, see the documentation in the Technical Reference for the Count, CrossJoin, and Children functions. A numeric value expression can also be used as an MDX formula to calculate the value of an existing outline member. Therefore, rather than creating the example query, you can create an outline member on the Measures dimension called Prod Count that is calculated in the outline in the same way that the hypothetical Prod Count was calculated in the sample query. To create a calculated member with a formula: Create a member somewhere in the dimension tagged as accounts. Attach an MDX formula to the member. Assuming that you created the example Prod Count member, you would use the following formula, which is the equivalent of the numeric value expression used to create the calculated member in the example query: Count(Crossjoin ( [Units] , [Products].children )) Verify the formula by verifying the outline. When you retrieve data from the aggregate storage database, the formula is used to calculate the member value. Before applying formulas to members in the outline, you can write MDX queries that contain calculated members. When you can write an MDX query that returns the calculated member results that you want, you are ready to apply the logic of the numeric value expression to an outline member and validate and test the expression. For information about writing MDX queries, see Writing MDX Queries . For syntax information about MDX, see the MDX section of the Technical Reference . Formula Calculation for Aggregate Storage Databases Formula calculation is much simpler for aggregate storage databases than for block storage databases. Analytic Services calculates formulas in aggregate storage outlines only when data is retrieved. Calculation order may affect calculation results. For information on calculation order for aggregate storage databases, see Calculation Order . Formula Syntax for Aggregate Storage Databases When you create member formulas for aggregate storage outlines, make sure that you observe the following rules: Enclose a member name in braces ( [] ) if the member name meets any of the following conditions: Starts with a number or contains spaces; for example, [100] . B races are recommended for all member names, for clarity and code readability. Is the same as an operator or function name. See the Technical Reference for a list of operators and functions. Includes any non-alphanumeric character; for example, a hyphen ( - ), an asterisk ( * ), or a slash ( / ). Use the IIF function to write conditional tests with a single else condition. The syntax for the IIF function does not require an ELSEIF keyword to identify the else condition nor an ENDIF keyword to terminate the statement. You can nest IIF functions to create a more complex formula. Use the CASE, WHEN, THEN construct to write conditional tests with multiple conditions. Be certain that tuples are specified correctly. A tuple is a collection of members with the restriction that no two members can be from the same dimension. Enclose tuples in parentheses; for example, (Actual, Sales) . Be certain that sets are specified correctly. A set is an ordered collection of one or more tuples. When a set has more than one tuple, the following rule applies: In each tuple of the set, members must represent the same dimensions as do the members of other tuples of the set. Additionally, the dimensions must be represented in the same order. In other words, all tuples of the set must have the same dimensionality . See Rules for Specifying Sets for more information about sets. Enclose sets in curly braces, for example: [Year].[Qtr1], [Year].[Qtr2], [Year].[Qtr3], [Year].[Qtr4] Creating Formulas on Aggregate Storage Outlines You use Formula Editor to create formulas. Formula Editor is a tab in the Member Properties dialog box in Outline Editor. Formulas are plain text. You can type the formulas directly into the formula text area, or you can create a formula in the text editor of your choice and paste it into Formula Editor. You can also include formulas in a dimension build data source. For information, see Setting Field Type Information . To create a formula, use the following method: Tool Topic Location Administration Services Creating Formulas for Aggregate Storage Databases Essbase Administration Services Online Help Checking Formula Syntax Analytic Services includes MDX-based syntax checking that tells you about syntax errors in formulas. For example, Analytic Services tells you if you have mistyped a function name or specified a non existent member. Unknown names can be validated against a list of function names. If you are not connected to Analytic Server or to the application associated with the outline, Analytic Services may connect you to validate unknown names. Syntax checking occurs when you save a formula. Errors are displayed in the Messages panel. If an error occurs, you are given a choice to save or not save the formula. If you save a formula with errors, you are warned when you verify or save the outline. When you calculate a formula with errors, the formula is ignored and the member is given a value of $MISSING. A syntax checker cannot tell you about semantic errors in a formula. Semantic errors occur when a formula does not work as you expect. One way to find semantic errors in a formula is to place the numeric value expression that defines the formula into a query and run the query to verify that the results are as you expect. See Using MDX Formulas to see how to place a formula into a query. You can use MDX Script Editor to create a query. MDX Script editor provides features such as color coding and auto-completion of MDX syntax. See About MDX Script Editor in Essbase Administration Services Online Help . Displaying Formulas To display a formula, use any of the following methods: Tool Topic Location Administration Services Creating Formulas for Aggregate Storage Databases Essbase Administration Services Online Help ESSCMD GETMBRCALC Technical Reference MaxL query database Technical Reference Composing Formulas on Aggregate Storage Outlines The following topics discuss and give examples of how to write a variety of formulas for members in aggregate storage outlines: Basic Equations for Aggregate Storage Outlines Members Across Dimensions in Aggregate Storage Outlines Conditional Tests in Formulas for Aggregate Storage Outlines Specifying a User-Defined Attribute in a Formula for Aggregate Storage Outlines Basic Equations for Aggregate Storage Outlines You can apply a mathematical operation to a formula to create a basic equation. For example, the following formula is applied to the Avg Units/Transaction member in the ASOsamp Sample database: [Units]/[Transactions] The formula in Avg Units/Transaction divides the number of units by the number of transactions to arrive at the average number of units per transaction. In aggregate storage outlines, members cannot be tagged as expense items. Therefore, functions in Calc, such as @VAR and @VARPER, which determine the difference between two members by considering expense tags, are not relevant in aggregate storage outlines. The MDX subtraction operator can be used to calculate the difference between two members. For example, the following formula can be applied to a new member, called Price Diff, in ASOsamp Sample to calculate the difference between the price paid and the original price: [Price Paid]-[Original Price] Members Across Dimensions in Aggregate Storage Outlines ASOsamp Sample provides a formula on a member called % of Total. This member formula identifies the percentage of the Measures total that is produced by Transactions. The formula for % of Total is as follows: Transactions/(Transactions,Years,Months, [Transaction Type],[Payment Type],Promotions,Age, [Income Level],Products,Stores,Geography) The formula specifies a member (Transactions) divided by a tuple (Transactions, Years, ...). The formula lists a top member from every dimension to account for all Transaction data in the cube; that is, not Transaction data for the Curr Year member but Transaction data for all members of the Years dimension, not Transaction data for months in the first two quarters but Transaction for all months, and so on. In this way, the value of % of Total represents the percentage of the Measures total that are produced by Transactions. Conditional Tests in Formulas for Aggregate Storage Outlines You can define a formula that uses a conditional test or a series of conditional tests to determine the value for a member. Use the IIF function to perform a test with a single else condition. You can nest IIF functions to create a more complex query. The example specifies a formula for a member that represents the price the company must pay for credit card transactions, which includes a 5% charge. The following example assumes that the Credit Price member has been added to the Measures dimension of the ASOsamp Sample database. Credit Price has the following formula, which adds 5% to Price Paid when the payment type is a credit card. IIF ( [Payment Type].CurrentMember=[Credit Card], [Price Paid] * 1.05, [Price Paid] ) Use the CASE, WHEN, THEN construct to create formulas with multiple tests and else conditions. The Filter function returns the tuples of the input set that meet the criteria of the specified search condition. For example, to establish a baseline (100) for all products you can add a Baseline member and create a formula for it, as follows: Count(Filter(Descendants([Personal Electronics],[Products].Levels(0)),[Qtr1] &gt; 100.00)) Specifying a User-Defined Attribute in a Formula for Aggregate Storage Outlines User-defined attributes (UDAs) are words or phrases that you create for a member. For example, in Sample Basic, top level members of the Market dimension have the UDA Small Market or the UDA Major Market. The Major Market example used in this topic shows how to create a formula for a member that shows the sum of sales for all major market members. The example assumes that a new member (Major Market Total) has been added to Sample Basic. MDX provides a Boolean function, IsUDA, which Returns TRUE if a member has the associated UDA tag. The following syntax returns TRUE if the current member of the Market dimension has the UDA Major Market: IsUda([Market].CurrentMember, Major Market) A Filter function, when used with IsUDA (as shown in the following syntax), cycles through each member of the Market dimension and returns a value for each member that has the Major Market UDA: Filter([Market].Members, IsUda([Market].CurrentMember, Major Market)) The Sum function is used to add the values returned by the Filter function, and for the Major Market example, the following formula is produced: Sum (Filter([Market].Members, IsUda([Market].CurrentMember, Major Market))) This is the formula that is attached to the Major Market Total member. Using a Transparent Partition to Enable Write-Back for Aggregate Storage Databases This topic discusses creating a transparent partition that connects an aggregate storage database and a block storage database. The partition, called a write-back partition, enables the user to update data on-the-fly (for example, from Spreadsheet Add-in) in the block storage database while data in the aggregate storage database remains unchanged. See Figure1 . Creating a write-back partition potentially decreases calculation time and reduces database size. To use the information in this topic, you should be familiar with the concepts of partitioned applications. For information about these concepts, see Designing Partitioned Applications Note: Partitioning is licensed separately from Analytic Services. Figure 1: Conceptual Diagram Showing a Transparent Partition Used for Analyzing Variance Between Forecast and Actual Data To create an aggregate storage and block storage write-back partition, use any of the following methods: Tool Topic Location Administration Services Aggregate Storage Partition Wizard Creating Partitions Essbase Administration Services Online Help MaxL create database, create partition Technical Reference You need Database Designer permissions to create a partitioned application. Workflow for Creating Write-Back Partitions This topic provides a high-level workflow for creating write-back partitions. The Administration Services Aggregate Storage Partition Wizard guides you through the following steps: Select or create the aggregate storage database. Create the block storage database in a different application other than the one in which the aggregate storage database is located. Typically the block storage database contains a subset of the dimensions in the aggregate storage database. Create a transparent partition based on where you want the data to be stored. Make the block storage database the target and the aggregate storage database the source. Note: You may want to partition on the time dimension if data for some time periods is stored in the aggregate storage database and data for other time periods is stored in the block storage database. For example, if you have actual data for January through March, which is stored in an aggregate storage database, and you want to budget for the last nine months of the year using write-back members in a block storage database. Users query and write back to the block storage database. Queries are processed by the block storage database or transparently by the aggregate storage database. For detailed information on using the Administration Services Aggregate Storage Partition wizard to create write-back partitions, see Aggregate Storage Partition Wizard in Essbase Administration Services Online Help . Example of Use of a Write-Back Partition Consider a situation in which you want to compare (do variance analysis) between forecast data and actual data. The following example is based on the ASOsample Sample database, which is provided with Analytic Services. You can recreate the example by using the Administration Services Aggregate Storage Partition wizard to guide you through the process described in this topic. To create a write-back partition for ASOsample sample, complete the following steps: Select the aggregate storage ASOsample Sample database, which contains the actual data for the current year and for previous years; see Figure2 . Figure 2: ASOsample Sample Aggregate Storage Database Outline Create a block storage database containing the following subset of dimensions from ASOsample Sample: Measures, Years, Months, Products, Stores, Geography; see Figure3 . Edit the Years dimension to add the following two additional members to the block storage database outline; see Figure3 : A Forecast member to contain the forecast data. A Variance member with a formula to calculate the variance between actual data and forecast data. Figure 3: Block Storage Database Outline Showing Years Dimension Members for Calculating Variance Between Actual and Forecast Data Delete the Measures dimension member formulas on Avg Units/Transaction and % of Total. These formulas are expressions written in MDX that are copied over from the aggregate storage database. MDX formula expressions cannot be interpreted in block storage databases. Link the databases with a transparent partition on the Years dimension. The block storage database (forecast data) as the target. The aggregate storage database (actual data) as the source. Do not include the write-back members (Forecast and Variance) in the partitioned area. Note: If you are using the Administration Services Aggregate Storage Partition wizard this step is done automatically. The databases are automatically partitioned on the Years dimension because you selected the Years dimension in step3 . The write-back members are not included in the partitioned area. You input forecast values into the block storage database write-back members. Because the added members are outside the partitioned area, you can write to them and then calculate data and generate reports based on updated data. The transparent partition provides a seamless view of both databases. For detailed information on using the Administration Services Aggregate Storage Partition wizard to create write-back partitions, see Aggregate Storage Partition Wizard in Essbase Administration Services Online Help .  |../acrtapdb.htm",
    "Comparison of Aggregate and Block Storage||Essbase Analytic Services provides an aggregate storage kernel as a persistence mechanism for multidimensional databases. Aggregate storage databases enable dramatic improvements in both database aggregation time and dimensional scalability. The aggregate storage kernel is an alternative to the block storage kernel. Aggregate storage databases typically address read-only, rack and stack applications that have large dimensionality, such as the following applications: Customer analysis. Data is analyzed from any dimension and there are potentially millions of customers. Procurement analysis. Many products are tracked across many vendors. Logistics analysis. Near real-time updates of product shipments are provided. A new sample application (ASOsamp), a data file, and a rules file are provided to demonstrate aggregate storage functionality. Differences Between Aggregate and Block Storage Aggregate storage applications differ from block storage applications in both concept and design. Additionally, aggregate storage applications have some limitations that do not apply to block storage applications. The following tables describe the differences between aggregate and block storage. Table1 , Inherent Differences Between Aggregate Storage and Block Storage Table2 , Outline Differences Between Aggregate Storage and Block Storage Table3 , Calculation Differences Between Aggregate Storage and Block Storage Table4 , Partitioning and Write Back Differences Between Aggregate Storage and Block Storage Table5 , Data Load Differences Between Aggregate Storage and Block Storage Table6 , Query Differences Between Aggregate Storage and Block Storage Table7 , Features Supported by Aggregate and Block Storage Table 1: Inherent Differences Between Aggregate Storage and Block Storage Inherent Differences Aggregate Storage Block Storage Storage kernel Architecture that supports rapid aggregation, optimized to support high dimensionality and sparse data Multiple blocks defined by dense and sparse dimensions and their members, optimized for financial applications Physical storage definition Through the Application Properties window, Tablespaces tab in Essbase Administration Services Through the Database Properties window, Storage tab in Essbase Administration Services. Database creation Migrate a block storage outline or define after application creation Note: Do not use the file system to copy a block storage outline into an aggregate storage application. Use the migration wizard in Administration Services to Migrate the outline Define after application creation Databases supported per application One Several Application and database names Names reserved for tablespaces, cannot be used as application or database names: default log metadata temp No reserved names Application and database information display Displayed in the Application Properties window and the Database Properties window in Administration Services (Information not supported by or relevant to aggregate storage applications is not shown. For a description of aggregate storage specific information, see Essbase Administration Services Online Help for the Application Properties window and Database Properties window) Displayed in the Application Properties window and the Database Properties window in Administration Services Configuration settings ( Essbase.CFG ) For a list of the settings that apply to aggregate storage databases, see the Technical Reference . For a list of the settings that do not apply to block storage databases, see the Technical Reference . Table 2: Outline Differences Between Aggregate Storage and Block Storage  Outline Functionality Aggregate Storage Block Storage Dense or sparse dimension designation Not relevant Relevant Accounts dimensions Support with the following exceptions: No time balance members No two-pass calculation No association of attribute dimensions (See also Formulas .) Full support Non-accounts dimensions Support with the following exceptions: No member formulas Support for only the + (addition) consolidation operator Restrictions on label only members No Dynamic Time Series members (See also Member consolidation properties and Member storage types .) Full support Member consolidation properties For non-accounts dimensions, support for only the + (addition) consolidation operator For all dimensions, support for all consolidation properties Member storage types Support with the following exceptions: No shared members Never Share member not relevant Dynamic Calc and Store not relevant On non-accounts dimensions, two limitations if a member is label only: All dimension members at the same level as the member must be label only The parents of the member must be label only. Note: On accounts dimensions, ability to tag any member as label only Note: On conversion from a block storage database, attribute dimension members are tagged as Dynamic Calc. On standard dimension members Dynamic Calc tags are converted and tagged as stored members, which changes the Members Stored value on the Dimensions tab of the Database Properties window in Administration Services. Support for all member storage types in all types of dimensions except attribute dimensions Ragged hierarchies and hierarchies with more than 10 levels Support, with possible performance impact Support Outline validation When database is started When outline is saved When block storage outline is converted to aggregate storage outline When user requests When outline is saved When user requests Outline paging Support No support Database restructure The following actions cause Analytic Services to restructure the outline and clear all data: Add, delete, or move a standard dimension member Add, delete, or move a standard dimension Add, delete, or move an attribute dimension Add a formula to a level 0 member Delete a formula from a level 0 member The following actions cause an outline restructure, but do not clear the data: Add, delete, or move an attribute dimension member Add or delete a formula from a non-level 0 member Rename a member or dimension Add or delete an alias Add or delete member comments or extended member comments Add or delete a user-defined attribute (UDA) Associate or disassociate an attribute dimension Several levels of restructure. See Optimizing Database Restructuring . Table 3: Calculation Differences Between Aggregate Storage and Block Storage  Calculation Functionality Aggregate Storage Block Storage Database calculation Aggregation of the database, which can be predefined by defining aggregate views Calculation script or outline consolidation Formulas Allowed with the following restrictions: Only in the dimension tagged as accounts Must be valid numeric value expressions written in MDX (cannot contain % operator, replace with expression: ( value1/value2 )*100) No support for Analytic Services calculation functions Allowed in all dimension types Calculation scripts Not supported Supported Attribute calculations dimension Support for Sum Support for Sum, Count, Min, Max, and Average Calculation order Not relevant (Predefined by the outline) Defined by the user in the outline consolidation order or in a calculation script Table 4: Partitioning and Write Back Differences Between Aggregate Storage and Block Storage Partitioning and Write-Back Functionality Aggregate Storage Block Storage Partitioning Support with the following restrictions: Transparent partitions only Aggregate storage database as the source database No outline synchronization Support with no restrictions User ability to change data (write back) Transparent partition technique used to enable limited write back Full support Table 5: Data Load Differences Between Aggregate Storage and Block Storage Data Load Functionality Aggregate Storage Block Storage Cells loaded through data loads Only level-0 cells whose values do not depend on formulas in the outline are loaded Cells at all levels can be loaded Update of database values At the end of a data load, if an aggregation exists, the values in the aggregation are recalculated and updated. No automatic update of values. To update data values you must execute all necessary calculation scripts. Incremental data load Data values are cleared each time the outline is changed structurally. Therefore, incremental data loads are supported only for outlines that do not change (for example, logistics analysis applications). Outline changes do not automatically clear data values, even if a data source is used to both modify members and load values. Therefore, incremental data loads are supported for all outlines. Table 6: Query Differences Between Aggregate Storage and Block Storage  Query Functionality Aggregate Storage Block Storage Report Writer Supported, except for commands related to sparsity and density of data Fully supported Spreadsheet Add-in Supported, with limited ability to change data (write back) (See User ability to change data (write back) .) Fully supported API Supported Supported Export Not supported, except for the MaxL export data using report_file grammar Supported MDX queries Supported Supported Queries on attribute members that are associated with non-level 0 members Returns values for descendants of the non-level 0 member. Returns #MISSING for descendants of the non-level 0 member. Features Supported by Aggregate and Block Storage Some features are not supported for aggregate storage. The following table describes the differences between aggregate and block storage. Table 7: Features Supported by Aggregate and Block Storage  Features Aggregate Storage Block Storage Aliases Supported Supported Currency conversion Not supported Supported Data mining Not supported Supported Hybrid analysis Support with the following restriction: queries that contain a relational member and an Analytic Services member with a formula in the same query are not supported. For example, if California is a relational member and the member Profit has a formula, the following report script returns an error: Jan California Profit ! Supported Linked reporting objects (LROs) Not supported Supported Time balance reporting Not supported Supported Triggers After-update triggers supported On-update triggers and after-update triggers supported Unicode Not supported Supported Variance reporting Not supported Supported  |../ainaggr.htm",
    "Loading, Calculating, and Retrieving Aggregate Storage Data||The most common processes for working with database information include maintaining the outline, loading data values to the database, calculating values, and retrieving database information. In the following topics, this chapter describes how performing these tasks with aggregate storage databases is different from performing these tasks with block storage databases: Preparing Aggregate Storage Databases Calculating Aggregate Storage Databases Retrieving Aggregate Storage Data Examples in this chapter refer to the outline in Figure1 . Figure 1: Sample Aggregate Storage Outline The simplified aggregate storage outline in Figure1 is not completely expanded. A plus sign (+) node at the left of a member name indicates that the member has children that are not displayed. Preparing Aggregate Storage Databases The following topics describe dimension build and data load process differences between aggregate storage databases and block storage databases: Building Dimensions in Aggregate Storage Databases Loading Data into Aggregate Storage Databases Combining Data Loads and Dimension Builds To use the information in these topics, you should be familiar with data load, dimension build, and rules file concepts and procedures. For information about using data sources to change outlines and to load data values, see Understanding Data Loading and Dimension Building. Building Dimensions in Aggregate Storage Databases If a dimension build of an aggregate storage database makes a structural change to the outline, all data values are cleared from the database when the dimension build is finished. See Table2 , Outline Differences Between Aggregate Storage and Block Storage for details about outline changes that cause restructuring. Differences between outline characteristics of block storage outlines and aggregate storage outlines affect data sources and rules files. For example, defining a dimension as sparse or dense is not relevant to aggregate storage outlines. For details, see the following subtopics of this topic: Rules File Differences for Aggregate Storage Dimension Builds Data Source Differences for Aggregate Storage Dimension Builds Rules File Differences for Aggregate Storage Dimension Builds Rules files for building aggregate storage outlines must define only outline properties that apply to aggregate storage outlines. For details about aggregate storage outline features and differences, see Table2 , Outline Differences Between Aggregate Storage and Block Storage . Before using a rules file that is defined for a block storage outline with an aggregate storage outline, open the rules file in Data Prep Editor, associate the rules file with the aggregate storage outline, and validate the rules file. For instructions for associating outlines, see Associating an Outline with an Editor in Essbase Administration Services Online Help . As you edit rules files for aggregate storage databases, some dimension build rules file options that apply only to block storage databases are displayed in Data Prep Editor dialog boxes. Table1 lists block storage rules file settings that do not apply to aggregate storage outlines. Entries in rules files for these options are ignored when the rules file is processed. Table 1: Aggregate Storage Dimension Build Rules File Differences Rules File Location in the Administration Services Interface Dimension Build Rules File Options That Do Not Apply to Aggregate Storage Databases Dimension Build Settings dialog box, Global Settings tab Data configuration options Dimension Build Settings dialog box, Dimension Build Settings tab Existing members option: Do not share Dimension Properties dialog box, Dimension Properties tab Dimension types option: Country Two-Pass calculation option Data storage options: Never share Dynamic Calc and Store Dynamic Calc All configuration options Dimension Properties dialog box, Accounts Dimension tab None of the options on this tab apply. Field Properties dialog box, Dimension Build Properties tab Field type options: Currency name Currency category Currency functionality does not apply to aggregate storage databases. For details about the dialog boxes, see Essbase Administration Services Online Help . Data Source Differences for Aggregate Storage Dimension Builds Data sources for modifying aggregate storage outlines should not include field values that apply only to block storage outlines. Table2 displays property code values that are recognized in dimension build data sources as consolidation properties for members of aggregate storage databases: Any other code is ignored and + (Add) is assumed. For details about specifying member property codes, see Using the Data Source to Set Member Properties . Table 2: Valid Consolidation Properties for Members of Aggregate Storage Outlines Code Description % Express as a percentage of the current total in a consolidation (applies only to accounts dimensions) * Multiply by the current total in a consolidation (applies only to accounts dimensions) + Add to the current total in a consolidation (applies only to accounts dimensions) - Subtract from the current total in a consolidation (applies only to accounts dimensions) / Divide by the current total in a consolidation (applies only to accounts dimensions) ~ Exclude from the consolidation (applies only to accounts dimensions) O Tag as label only Currency name and currency category field types are not supported for aggregate storage outlines. In aggregate storage outlines, formulas must be specified in the same format as MDX numeric value expressions. For information about writing formulas for aggregate storage outlines, see Developing Formulas on Aggregate Storage Outlines . Loading Data into Aggregate Storage Databases The differences between loading data into aggregate storage databases and loading data into block storage databases are described in the following topics: Data Source Differences for Aggregate Storage Data Loads Rules File Differences for Aggregate Storage Data Loads Aggregate Storage Data Load Process For additional information related to aggregate storage data loads, see Table5 , Data Load Differences Between Aggregate Storage and Block Storage . Data Source Differences for Aggregate Storage Data Loads While processing data source records for loading values into aggregate storage databases, Analytic Services processes source data records only for the level 0 dimension intersections where the accounts dimension member does not have a formula. The following example shows a data source with records for only level 0 intersections. The last field contains data values; the other fields are level 0 members of their respective dimensions. Jan, Curr Year, Digital Cameras, CO, Original Price, 10784 Jan, Prev Year, Camcorders, CO, Original Price, 13573 Analytic Services ignores records that specify upper-level members and, at the end of the data load, displays the number of skipped records. For example, the following record would be skipped because member Mid West is a level 1 member: Jan, Curr Year, Digital Cameras, Mid West, Original Price, 121301 Since level 0 cells exist only if they contain values, specifying #MISSING or #MI as a value removes the associated cell if it is present in the database. Sorting data sources is unnecessary because Analytic Server reads and sorts all records internally before loading values to the database. Rules File Differences for Aggregate Storage Data Loads Rules file specifications for loading values to aggregate storage databases reflect the aggregate storage data load process. Options that apply only to block storage data loads are grayed out in Data Prep Editor when the rules file is associated with an aggregate storage outline. For block storage data loads, you choose for each data source, through the rules file, whether to overwrite existing values, add values in the data source to existing values, or subtract them from existing values. For aggregate storage data loads using the aggregate storage data load buffer, you make this choice for all data load sources that are gathered into the data load buffer before they are loaded to the database. For information about the data load process, see Aggregate Storage Data Load Process . Before using with an aggregate storage outline a rules file that is defined for a block storage outline, open the rules file in Data Prep Editor, associate it with the aggregate storage outline, and validate the rules file. For instructions, see Associating an Outline with an Editor in Essbase Administration Services Online Help . Aggregate Storage Data Load Process For general information about loading data, see Performing and Debugging Data Loads or Dimension Builds. Aggregate storage databases facilitate analysis of very large dimensions containing up to a million or more members. To efficiently support loading data values into such large databases, Analytic Services enables you to combine the processing of multiple data sources through a temporary aggregate storage data load buffer. When you take advantage of the aggregate storage data load buffer, Analytic Services sorts and works with the values after all data sources have been read. If multiple records are encountered for any specific data cell, the values are accumulated. Analytic Services then stores the accumulated values-replacing, adding to, or subtracting from existing data values in the database. Note: For data loads using the aggregate storage data load buffer, the choice for replacing, adding, or subtracting values is specified for the entire set of data sources. For all other data loads, the choice for replacing, adding, or subtracting values is specified per data source through rules files. Taking advantage of the aggregate storage data load buffer can significantly improve overall data load performance because it requires fewer input/output operations. The following topics provide an overview of the data load processes based on the method used. Using MaxL to Perform Aggregate Storage Data Loads Using Essbase Administration Services Console to Perform Aggregate Storage Data Loads Using MaxL to Perform Aggregate Storage Data Loads Using the MaxL import database data statement to load data values from a single data source does not involve the aggregate storage data load buffer. If you use multiple statements in incremental data loads to aggregate storage databases, you can significantly improve performance if you load values to the aggregate storage data load buffer first, with a final write to storage after all data sources have been read. To use this buffer in MaxL, you specify a series of separate statements that perform the following tasks: Prepare the aggregate storage data load buffer to accumulate the data values Define and provide the data sources and rules files Conclude the operation by writing the accumulated values to the database A sample of the sequence of statements loading three data sources (file_1, file_2, and file_3) follows: First, an aggregate storage data load buffer is initialized, as defined by the following MaxL alter database statement: alter database agg.sample  initialize load buffer with buffer_id 1; Next, data sources are read into the aggregate storage data load buffer where they are sorted and accumulated. You can include any combination of data sources, such as .xls files, text files, and SQL relational sources. The following three statements show an example of multiple data sources to be accumulated in the buffer: import database agg.sample data from server data_file 'file_1.txt' to load_buffer with buffer_id 1; import database agg.sample data from server data_file 'file_2' using server rules_file 'rule' to load_buffer with buffer_id 1; import database agg.sample data from server excel data_file 'file_3.xls' to load_buffer with buffer_id 1; Note: Import statements need not be contiguous. As long as the buffer exists, the database is locked from queries, aggregations, or data loads from other means, such as from Administration Services. You can perform other MaxL operations, such as displaying security information or creating triggers. A final import statement loads the buffer contents to the database cells, replacing existing values: import database agg.sample data from load_buffer with buffer_id 1 override values; Note: Performing an application restart loses the data load buffer. When you restart the application, you restart the entire process. Using Essbase Administration Services Console to Perform Aggregate Storage Data Loads Essbase Administration Services Console always uses the aggregate storage data load buffer for aggregate storage data loads. In this process, when you initiate a data load you provide all data source file names and rules file names in a single dialog box. For further information about the methods for loading values to aggregate storage databases, see the following topics: Tool Topic Location Administration Services Performing a Data Load or Dimension Build for Aggregate Storage Databases Essbase Administration Services Online Help ESSCMD BUILDDIM IMPORT LOADDB Technical Reference MaxL alter database import data Technical Reference Note: If values have been calculated and stored through an aggregation, Analytic Services automatically updates higher-level stored values when data values are changed. No additional calculation step is necessary. The existence and size of an aggregation can affect the time it takes to perform a data load. For additional information about aggregations, see Aggregations . Combining Data Loads and Dimension Builds When using the aggregate storage data load buffer, you can combine data sources and rules files to add members to the outline and to load data values to the level 0 cells. Regardless of the order you specify the files, Analytic Services first makes the outline changes and then loads the data values. Calculating Aggregate Storage Databases Aggregate storage database values are calculated through the outline structure and MDX formulas. When a data load is complete, all the information needed to calculate an aggregate storage database is available. The values to support a retrieval request are calculated by a consolidation of the values loaded for level 0 members. Formulas for accounts dimension members are calculated for each retrieval. Values calculated for retrievals are not stored. To improve retrieval performance, Analytic Services can aggregate values and store them ahead of time. However, aggregating and storing all values can be a lengthy process that requires disk space for storage. Analytic Services provides an intelligent aggregation process that balances time and storage resources. For details, see Aggregating an Aggregate Storage Database . To prepare an aggregate storage database for retrieval, you create the outline and load the level 0 values. Then you calculate the database by aggregating, and storing additional values, with the remaining values to be calculated when retrieved. Note: If a database needs calculation scripts for special calculations and data dependencies, make it a block storage database. The following topics further describe calculation of aggregate storage databases: Outline Factors Affecting Data Values Block Storage Calculation Features That Do Not Apply to Aggregate Storage Databases Calculation Order Aggregating an Aggregate Storage Database For additional information related to aggregate storage database calculations, see Table3 , Calculation Differences Between Aggregate Storage and Block Storage . Outline Factors Affecting Data Values The hierarchical structure of an aggregate storage outline determines how values are rolled up. L0 member values roll up to L1 member values, L1 member values roll up to L2 member values, and so on. Consolidation operators assigned to members of the dimension tagged as accounts define the operations used in the roll-up: add (+), subtract (-), multiply (*), divide (/), percent (%), and no operation (~). For an explanation of operators, see Table10 . Note: In aggregate storage outlines, consolidation operators assigned to members of non-accounts dimensions have no effect on calculation. For non-accounts dimensions, the only allowable consolidation operator is the add (+) operator. For more complex operations, you can provide MDX formulas for members of the accounts dimension. MDX formulas are written in the same format as MDX numeric value expressions. For information about writing formulas for aggregate storage outlines, see Developing Formulas on Aggregate Storage Outlines . Block Storage Calculation Features That Do Not Apply to Aggregate Storage Databases The following characteristics of calculating block storage databases do not apply to aggregate storage databases: Calculation script calculations and concern for monitoring and tracing calculations Dynamic Calc and Dynamic Calc and Store member storage properties Block storage formula syntax and pre-defined Essbase functions in formulas Custom-defined calculation functions and custom-defined calculation macros Formulas on members of dimensions other than the accounts dimension Preloaded values for member intersections above level 0 Calculation order and two-pass calculations and concern for dimension order in the outline Time balance data values; for example, carrying over the value from the end of a time period, such as Jan, to the beginning value for the next time period, such as Feb Time series data values; for example, calculating period-to-date, first, last, and average sales values Block storage performance features such as Intelligent Calculation Calculation Order Calculation order may affect calculation results. Aggregate storage calculation order and block storage calculation order may differ. For block storage databases, by default, Analytic Services calculates dynamically-calculated members on standard dimensions and then aggregates members along the attribute dimensions. For aggregate storage databases, Analytic Services calculates data in the following order: Aggregates members on all dimensions except the dimension tagged as accounts.The order in which members and dimensions are aggregated is optimized internally and changes according to the nature of the database outline. Calculates accounts dimension members and formulas. Because the internal calculation order for an aggregate storage database is not predictable, any inherent rounding errors are also not predictable. These rounding errors are expected behavior in computer calculation and are extremely small in relation to the data values concerned. Aggregating an Aggregate Storage Database For aggregate storage databases, after data values are loaded into the level 0 cells of an outline, the database requires no separate calculation step. From any point in the database, users can retrieve and view values that are aggregated for only the current retrieval. Aggregate storage databases are smaller than block storage databases, enabling quick retrieval of data values. For even faster retrieval, you can precalculate data values and store the precalculated results in aggregations. The following terms are integral to an explanation of aggregate storage database calculation: Aggregate Cells Aggregate Views Aggregations Aggregate Cells Cells for level 0 intersections across dimensions, without formulas, are called input cells. Data values can be loaded to them. Higher-level cells of the accounts dimension are always calculated at retrieval. All other higher-level intersections across dimensions are aggregate cells . For example, for the outline in Figure1 , Price Paid &gt; Curr Year &gt; 1st Half &gt; Portable Audio &gt; CO is an aggregate cell; Original Price &gt; Curr Year &gt; Jan &gt; Camcorders &gt; CO is another aggregate cell. Values for aggregate cells must be rolled up from lower-level values. Aggregate cell values are calculated for each request, or they can be precalculated and stored in aggregations. Aggregate Views When Analytic Services defines which aggregate cells to precalculate and store, it works with the cells in sets, known as aggregate views. An aggregate view is a collection of aggregate cells. The collection is based on the levels of the members within each dimension. For example, consider one aggregate view for the outline in Figure1 . This aggregate view includes aggregate cells for level 0 members of the Measures, Years, and Geography dimensions, level 1 members of the Months dimension, and level 2 members of the Products dimension. The dimensions are arranged in the outline as Measures, Years, Months, Products, Geography. The example aggregate view is shown as 0,0,1,2,0. The 0,0,1,2,0 aggregate view contains aggregate cells that include the following member intersections: Original Price, Curr Year, Qtr1, Personal Electronics, CO Original Price, Curr Year, Qtr1, Personal Electronics, KS Original Price, Curr Year, Qtr1, Home Entertainment, CO Original Price, Curr Year, Qtr1, Home Entertainment, KS Original Price, Curr Year, Qtr2, Personal Electronics, CO Original Price, Curr Year, Qtr2, Personal Electronics, KS Original Price, Curr Year, Qtr2, Home Entertainment, CO Original Price, Curr Year, Qtr2, Home Entertainment, KS Original Price, Curr Year, Qtr3, Personal Electronics, CO Original Price, Curr Year, Qtr3, Personal Electronics, KS Original Price, Curr Year, Qtr3, Home Entertainment, CO Original Price, Curr Year, Qtr3, Home Entertainment, KS Original Price, Curr Year, Qtr4, Personal Electronics, CO Original Price, Curr Year, Qtr4, Personal Electronics, KS Original Price, Curr Year, Qtr4, Home Entertainment, CO Original Price, Curr Year, Qtr4, Home Entertainment, KS Original Price, Prev Year, Qtr1, Personal Electronics, CO Original Price, Prev Year, Qtr1, Personal Electronics, KS Original Price, Prev Year, Qtr1, Home Entertainment, CO Original Price, Prev Year, Qtr1, Home Entertainment, KS and so on... Aggregations Aggregations are consolidations, based on outline hierarchy, of level 0 data values. An aggregation contains one or more aggregate views. Analytic Services provides an intelligent aggregation process that selects aggregate views to be rolled up, aggregates them, and then stores the values for the cells in the selected views. If an aggregation includes aggregate cells dependent on level 0 values that are changed through a data load, the higher-level values are automatically updated at the end of the data load process. The term aggregation is used for both the process and the result of the process. Performing Database Aggregations You can use either Administration Services Aggregation Design Wizard or MaxL statements to perform an aggregation. Internally, the aggregation process has two phases: Aggregate view selection. Calculation and storage of values for the selected aggregate views. This phase is also called the materialization of the aggregation. During the aggregate view selection phase, Analytic Services analyzes how calculating and storing various combinations of aggregate views would affect average query response time. Based on their usefulness, Analytic Services creates an internal list of the aggregate views and determines a stopping point in physical storage used that balances performance requirements with the impact on physical storage. If desired, you can specify the amount of physical storage for an aggregation. The first time that you perform an aggregation after an outline change, it is recommended that you let Analytic Services select the physical storage stopping point. After the calculation and storage phase, you can test retrieval times based on your retrieval requirements. To optimize performance for your situation, you can rerun the aggregation wherein you can increase or decrease the storage stopping point to be used by the aggregation. Specifying a storage limit reduces or increases the storage space required, the time required to materialize the aggregation, and the time required for some retrievals. Administration Services Aggregation Design Wizard enables you to create aggregation scripts. An aggregation script represents a specific scenario that is relevant to the existing outline and to aggregate view selection determined by the storage limit, if one is specified. Aggregation Design Wizard displays the selected aggregate views and enables you to save aggregation scripts for later materialization. You can also execute the aggregation script immediately to materialize the aggregate views that it specifies. For additional information about aggregation scripts, see Working with Aggregation Scripts . Aggregation Design Wizard also enables running aggregation processes in the background. When you run an Administration Services process in the background you can continue to use Essbase Administration Services Console for other activities at the same time as the background process is running. MaxL addresses the aggregation selection and materialization phases in a single statement. To specify that Analytic Services determine the stopping point, omit the optional part of the MaxL execute aggregate process statement beginning with the keywords stopping when total_size exceeds . To perform a database aggregation, use any of the following methods: Tool Topic Location Administration Services Improving Retrievals by Precalculating Aggregations Essbase Administration Services Online Help MaxL execute aggregate process Technical Reference Working with Aggregation Scripts Saved aggregation scripts enable you to materialize an aggregation at a different time than the aggregate views for the aggregation are selected. Support for multiple aggregation scripts also enables you to choose from different selection scenarios. For example, one aggregation script that builds a 40 MB aggregation may support normal retrieval requirements. For a large, detailed weekly report, you could build a 60 MB aggregation that reduces the time to produce the report, then go back to the 40 MB script. Only Administration Services Aggregation Design Wizard enables you to save aggregation scripts. Aggregation scripts are stored in the database directory as text files with the .csc extension and are valid until the outline is changed. To avoid the potential clutter of invalid aggregation script files, when you change the outline, be sure to delete existing aggregation scripts manually or through the Aggregation Design Wizard. You can also rename existing aggregation scripts. Note: When Aggregation Design Wizard displays the list of existing aggregation scripts, it lists all files with the .csc extension in the database directory. Only valid aggregation script files can be executed. You can use the Aggregation Design Wizard to execute an aggregation script or you can manually copy the contents of the aggregation script to a MaxL script which can be executed at a later time. Executing an aggregation script materializes the aggregate views specified within it. Although you can create multiple aggregation scripts, only one aggregation can be materialized at a time. Retrieving Aggregate Storage Data This topic includes the following subtopics: Attribute Calculation Retrievals Retrieval Tools Supporting Aggregate Storage Databases For additional information related to query support, see Table6 , Query Differences Between Aggregate Storage and Block Storage . Attribute Calculation Retrievals Aggregate storage applications support only the Sum member of the Attribute Calculations dimension. If you specify any other member name from the Attribute Calculations dimension, such as Min or Avg, an error is returned. For information about the Attribute Calculations dimension, see Understanding the Attribute Calculations Dimension . Retrieval Tools Supporting Aggregate Storage Databases Analytic Services provides the following programs and tools that enable data retrieval from aggregate storage databases: MDX Queries Report Writer, which is run through Essbase Administration Services Console or the MaxL export data using report_file grammar Essbase Spreadsheet Services Essbase Spreadsheet Add-in Any commands that support features that apply only to block storage cannot be used with aggregate storage databases; for example, the Report Writer &lt;SPARSE command.  |../alocare.htm",
    "Managing Aggregate Storage Applications and Databases||Most processes for managing aggregate storage applications are the same as for managing block storage applications. This chapter describes differences in the following topics: Aggregate Storage Security Backing Up Aggregate Storage Applications Managing Storage for Aggregate Storage Applications Managing the Aggregate Storage Cache See also Table1 for basic information about how aggregate storage applications are structured and managed. Aggregate Storage Security Defining and executing aggregations requires Calculation (Essbase Administration Services) or Execute (MaxL) permission or higher. Dimension builds clear the database and can be performed only by users with Write permissions. In all other areas, security for aggregate storage applications and security for block storage applications is the same. For information about permissions, see the following documentation: Topic Location Understanding Security and Permissions Essbase Analytic Services Database Administrator's Guide Managing User/Group Permissions for Applications and Databases Essbase Administration Services Online Help Privileges and Roles Technical Reference From the index, use the keyword privileges, defined. Backing Up Aggregate Storage Applications The file structure used by aggregate storage applications to store application and database information differs from the file structure used by block storage applications use. Table1 lists the major directories and files associated with aggregate storage applications. Table 1: Aggregate Storage Files Directory or File Location Description appname \\ arborpath \\app\\ Application directory appname .app \\ arborpath \\app\\ appname \\ Application file containing application settings appname .LOG \\ arborpath \\app\\ appname \\ Application log file dbname \\ arborpath \\app\\ appname \\ Database directory dbname .db \\ arborpath \\app\\ appname \\ dbname \\ Database file containing database settings dbname .dbb \\ arborpath \\app\\ appname \\ dbname \\ Backup of database file dbname .ddb \\ arborpath \\app\\ appname \\ dbname \\ Partition definition file dbname .otl \\ arborpath \\app\\ appname \\ dbname \\ Outline file trigger.trg \\ arborpath \\app\\ appname \\ dbname \\ Trigger file default \\ arborpath \\app\\ appname \\ Tablespace directory: default temp \\ arborpath \\app\\ appname \\ Tablespace directory: temp log \\ arborpath \\app\\ appname \\ Log directory metadata \\ arborpath \\app\\ appname \\ Metadata directory ess n .dat \\ arborpath \\app\\ appname \\default\\ \\ arborpath \\app\\ appname \\log\\ \\ arborpath \\app\\ appname \\metadata\\ Data file To back up an aggregate storage database, ensure that the application is stopped and use the operating system to copy the entire application directory: arborpath \\app\\ appname \\ . Note: The ESSCMD command BEGINARCHIVE and the MaxL statement alter database begin archive do not support aggregate storage databases. Managing Storage for Aggregate Storage Applications For aggregate storage applications, Tablespace Manager controls all aspects of retrieving and storing data. For information about how block storage is managed, see Understanding the Analytic Server Kernel . Tablespace manager works with tablespace definitions to manage the physical disk for data storage and work areas. The following topics describe tablespaces and how to work with them: Working with Tablespaces Defining Tablespaces Working with Tablespaces Essbase Analytic Services uses tablespaces to optimize data storage and to optimize retrieval for data files and work files. Tablespaces define one or more location definitions that map data objects, such as aggregate views and aggregations, to files. Within each application directory, Analytic Services sets up directories for four tablespaces. You cannot change the location or size of metadata and log, two of the tablespaces. You can specify sizes and multiple locations for the other tablespaces: The default tablespace, which contains the database data structure and the database values. After data is loaded to this tablespace, the location cannot be changed. The temp tablespace, which provides a temporary work space for Analytic Services to use during various operations, such as data loads, aggregations, and retrievals. You can define the following tablespace properties: Directory path locations Maximum disk space to be used at each location Maximum file size allowed within each location Note: You can modify or delete the file locations used to store information within each tablespace. You cannot delete a file location if it contains data. Defining a maximum disk space for a tablespace location defines an end point for the location. Files cannot be written past the end point. The maximum disk space definition does not reserve the entire amount of disk space specified. As needed, Tablespace Manager allocates disk space in fixed-size increments. When Analytic Services extends a file or adds a file to a tablespace, it looks for space in the first location. If the disk space is not available, Analytic Services checks the next location, and so on. Analytic Services starts writing files to the first available space within the defined locations. When no space is available, because all file locations are used, an error is returned. When values in a database are cleared, the files in the tablespaces shrink, releasing disk space. When work files are no longer needed, they are deleted and disk space in the tablespace is released. If space is unused, other computer programs can use it. Based on the maximum size specified for files, Analytic Services writes multiple files; for example, ess00001.dat , ess00002.dat , and so on. If you back up database files to other media, you should not set the maximum file size for a tablespace to be greater than the maximum file size that the media can handle. Defining Tablespaces You define separate tablespace definitions for each aggregate storage application. For further information about the methods for defining tablespaces, see the following topics: Tool Topic Location Administration Services Managing Tablespaces Essbase Administration Services Online Help MaxL alter tablespace Technical Reference Managing the Aggregate Storage Cache Analytic Services uses the aggregate storage cache to facilitate use of memory during data loads, aggregations, and retrievals. The aggregate storage cache is the only cache relevant to aggregate storage databases. Note: The cache memory locking feature is used only with block storage applications. When an aggregate storage outline is started, Analytic Services allocates a small area in memory as the aggregate storage cache for the relevant application. As additional cache area is needed, Analytic Services increases the cache size incrementally until the maximum cache size specified for the application is used or until the operating system denies additional allocations. Note: After additional aggregate cache memory allocations are denied, use of existing memory can still increase. You can view the current aggregate cache memory allocation and the maximum aggregate cache size setting. In some situations, changing the current setting can optimize use of memory. By default, the maximum cache size is set at 32 MB, the minimum size for the setting. As a general guideline, you can use the size of input-level data to determine when to increase the maximum size for the cache. The size of input-level data is the size of level 0 values. The size of input-level data is a database statistic that both Administration Services and MaxL display as an aggregate storage database property. A 32 MB cache setting supports a database with approximately 2 GB of input-level data. If the input-level data size is greater than 2 GB by some factor, the aggregate storage cache can be increased by the square root of that factor. For example, if the input-level data size is 3 GB (which is 2 GB*1.5), multiply the aggregate storage cache size of 32 MB by 1.22 (which is approximately the square root of 1.5), and set the aggregate cache size to the result: 39.04 MB. Another factor to consider is the number of threads set for parallel calculation. Essbase uses multiple threads during the aggregation materialization process. The threads divide up aggregate storage cache. If you increase the number of threads specified in the CALCPARALLEL configuration setting for aggregate storage applications or databases, consider the possible need to increase the size of the aggregate storage cache. For information about the CALCPARALLEL configuration setting, see the Technical Reference . Note: It is possible, for aggregate storage applications, to improve performance by setting the number of threads higher than the number of processors. Do not increase the maximum size of the aggregate storage cache if a greater size is not needed. For further information about viewing and setting the aggregate storage cache size for an application, see the following topics: Tool Topic Location Administration Services Sizing the Aggregate Storage Cache Essbase Administration Services Online Help MaxL query application alter application Technical Reference Note: A changed aggregate storage cache setting does not take effect until the application is restarted.  |../asysadmn.htm",
    "Database Administrator's Guide||Essbase &REG Analytic Services Database Administrator's Guide Information Map Copyright and Trademark Information &#169; 1996-2004 Hyperion Solutions Corporation. All rights reserved. Hyperion&#44; Essbase&#44; the Hyperion H logo&#44; Hyperion Solutions&#44; are registered trademarks or trademarks of Hyperion Solutions Corporation. No portion of this manual may be reproduced or transmitted in any form or by any means, electronic or mechanical, including photocopying, recording, or information storage and retrieval systems, for any purpose other than the purchasers personal use, without the express written permission of Hyperion Solutions Corporation. Notice: The information contained in this document is subject to change without notice. Hyperion Solutions Corporation shall not be liable for errors contained herein or consequential damages in connection with the furnishing, performance, or use of this material. Hyperion Solutions Corporation 1344 Crossman Avenue Sunnyvale, CA 94089  |../copyrite.htm",
    "Running Analytic Servers, Applications, and Databases||This chapter describes the various methods used to run Essbase Analytic Server and its associated applications and databases. It defines the role of the Agent, which is the central organizing subsystem for Analytic Server, and describes different methods of starting and stopping Analytic Servers, applications, and databases. This chapter includes the following sections: Understanding Analytic Services Executable Files Understanding the Agent Starting and Stopping Managing Security-File Defragmentation Managing Ports Specifying Non-Default Port Values Installing Additional Instances of Analytic Server: Windows Installing Additional Instances of Analytic Server: UNIX Increasing Agent Connections to Analytic Server Limiting the Number of User Sessions Understanding Analytic Services Executable Files Seven main executable files contain the server and client software for Analytic Services: Table 35: Main Analytic Services Executable Files Executable File Description More Information essbase.exe Analytic Server Agent process Understanding the Agent esssvr.exe Application process Starting and Stopping Applications essmsh.exe MaxL Shell Technical Reference esscmd.exe ESSCMD command-line client interface Technical Reference startEAS.exe Administration Server executable Essbase Administration Services Online Help admincon.exe Administration Services Console application Essbase Administration Services Online Help The files that start with ess are stored in the \\ ARBORPATH \\bin directory ( / ARBORPATH /bin on UNIX). adminsvr.exe is stored in ARBORPATH \\eas\\server\\bin directory ( ARBORPATH /eas/bin on UNIX), and admincon.exe is stored in ARBORPATH \\eas\\console\\bin directory ( ARBORPATH /eas/bin on UNIX). On UNIX systems, these files do not have the .exe extension. You can launch any executable file by typing its name at the operating system command prompt. On Windows, you can also launch a program by double-clicking the file in Explorer, double-clicking a desktop icon, or entering its name in the dialog box displayed when you select Run from the Start menu. Understanding the Agent The Agent Process is the Analytic Server process that starts and stops all applications and acts as the traffic coordinator for the Analytic Server. Use this section to understand more about the Agent: Flow of Communications Events Multithreading Displaying of a List of Agent Commands The agent log is called the Analytic Server log. For information on viewing the Analytic Server log, see Viewing the Analytic Server and Application Logs . When you start Analytic Server in the foreground, the Agent becomes active in an operating system window. You should see information like the following appear in the operating system window: Figure 218: Sample Agent Output to Operating System Window Unlimited login system Hyperion Essbase Analytic Server - X.X Copyright 1991-2002 Hyperion Solutions Corporation. US Patent Number 5,359,724 All Rights Reserved. Serial number:XXXXXXXXXXXX-XXXXXXXXXXX Registered to:admin hyperion Please type the system password: ******** Startup sequence completed Security is enabled Logins are enabled Essbase Default Storage type is Multidimensional [Wed Dec 06 14:00:20 2002]Local/ESSBASE0\/\//Info(1051051) Hyperion Essbase Analytic Server - started Waiting for Client Requests... In the Agent, you can enter administrative commands and monitor the behavior of Analytic Services. The Agent is accessible only from the server console on the Analytic Server computer. The server console is the primary terminal, or monitor, connected to the server computer. The server computer is the computer on which Analytic Server runs. The Agent executable file, essbase.exe ( ESSBASE on UNIX systems), is stored in the \\ ARBORPATH \\bin directory. Launching this executable file starts Analytic Server. You can start Analytic Server in the foreground or as a background process. If you start Analytic Server in the background, the terminal becomes free for other input, and the Agent activities are not visible in the terminal. For a detailed explanation, see Starting Analytic Server as a Background Process . Flow of Communications Events When a user logs on to Analytic Server, these events occur: An Analytic Services client logs on, using a predefined address: For TCP/IP connections, the address is port number 1423 unless it has been changed using the configuration setting AGENTPORT. For Named Pipes connections, the address is \\\\pipe\\essbase0 . The user selects an application/database combination. The Agent compares the requested application with applications currently running. If the specified application is already running, the Agent does not need to do anything. If the requested application is not already running, the Agent initiates startup, and the following events occur: The Agent assigns a dynamic port for the application server or creates a dynamic name for a named pipe. The application server returns the port number for the application to the Agent and to the client. Port number information is stored at run time in Analytic Services API. The Agent sets the application server as active with the current user and security information. When the client later sends a data request to the application server, the security information captured by the API is embedded in the request. The Agent sends the client query to the application server (ESSSVR). For every request that the client makes, the application server causes the following events to occur: Connect Send request Get response Send data Receive data Disconnect Multithreading essbase.exe and esssvr.exe ( ESSBASE and ESSSVR on UNIX) are multithreaded applications. By default, the number of threads is based on the number of licensed ports that are purchased, as shown in Table36 . The number of ports represents the number of concurrent connections that Analytic Services supports. Analytic Services provides one reserve port for the system administrator. The system administrator uses the reserve port to log off one or more users when all other ports are in use. Table 36: Licensed Ports and Multithreading Number of Licensed Ports Default Number of Threads 1-5 ports 5 6-10 ports 10 11 or more ports 20 You can set the number of threads for the Agent or Analytic Server in the essbase.cfg file. For complete details on setting the number of threads for the Agent and the server, refer to the AGENTTHREADS, AGTSVRCONNECTIONS, and SERVERTHREADS configuration settings in the Technical Reference . Displaying of a List of Agent Commands To display a list of all available Agent commands, press Enter in the operating system window where you started Analytic Server in the foreground. For an example of Agent output, see Figure218 . Use the following table to understand the function of each Agent command displayed, and the MaxL, ESSCMD, or Administration Services equivalents: Table 37: Agent Commands and MaxL, ESSCMD, or Administration Services Equivalents  Agent Command Function MaxL, ESSCMD, or Administration Services Equivalent START appname Starts the specified application. MaxL: alter system load application appname ; ESSCMD: LOADAPP Administration Services: Right-click menu off application node in Enterprise View STOP appname Stops the specified application. MaxL: alter system unload application appname ; ESSCMD: UNLOADAPP Administration Services: Right-click menu off application node in Enterprise View USERS Displays a list of all users connected to the Analytic Server. The following information is displayed: Names of all users connected to the Analytic Server Total number of ports installed Total number of existing connections Application to which each user is connected Database to which each user is connected MaxL: display user; (lists all users and shows which users are logged on) ESSCMD: LISTUSERS (lists all users) Administration Services: N/A PORTS Displays the number of ports installed on the Analytic Server and the number of ports in use. MaxL: display system; (to display available unused ports) ESSCMD: N/A Administration Services: Analytic Server Properties window, Statistics tab LOGOUTUSER user Disconnects a user from the Analytic Server and frees a port. This command requires the Analytic Services system password. MaxL: alter system logout session by user username ; ESSCMD: LOGOUTUSER Administration Services: Sessions window PASSWORD Changes the system password that is required to start the Analytic Server. This command requires the Analytic Services system password. MaxL: alter user system supervisor set password password ; ESSCMD: SETPASSWORD Administration Services: N/A COMPACT Enables defragmentation of the security file when the Agent is running. Note: Analytic Services compacts the security file automatically each time the Agent is stopped. MaxL alter system compact security file; ESSCMD: N/A Administration Services: N/A DUMP filename Dumps information from the Analytic Services security system to a specified file in ASCII format. If you do not supply a path with the file name, the file is saved to the bin directory, for example, \\essbase\\bin . This command requires the Analytic Services system password. N/A VERSION Displays the Analytic Server software version number. MaxL: display system; ESSCMD: GETVERSION Administration Services: Analytic Server Properties window, License tab HELP Lists all valid Agent commands and their respective functions. Same as pressing Enter. N/A QUIT and EXIT Shuts down all open applications and stops Analytic Server. MaxL: alter system shutdown; ESSCMD: SHUTDOWNSERVER Administration Services: Right-click menu off server node in Enterprise View Starting and Stopping Use these sections for instructions about starting and stopping Analytic Servers, applications, and databases: Starting and Stopping Analytic Server Starting Analytic Server Remotely from Administration Services Console Starting and Stopping Administration Services Starting and Stopping Applications Starting and Stopping Databases Starting and Stopping Analytic Server You can start Analytic Server in a variety of ways. You need Supervisor permissions to start Analytic Server. Use these sections for instructions about starting and stopping Analytic Server: Starting Analytic Server Starting Analytic Server as a Background Process Changing the System Password Stopping Analytic Server Note: For instructions about starting Analytic Server from Administration Services, see Starting Analytic Server Remotely from Administration Services Console . Starting Analytic Server Analytic Server can be started in the foreground using several methods. To start Analytic Server in the foreground, use any of the following methods: Operating System Instructions UNIX Enter the following command at the operating system prompt. ESSBASE password Windows Use any of the following methods: Enter the following command at the operating system prompt. ESSBASE password Select Analytic Server from the Hyperion Solutions program group on the Start menu. Double-click essbase.exe , located in the bin directory, and enter the password when prompted. From the Start menu, select Run, and type ESSBASE password in the Open field. password is the password to access Analytic Server. Any of these actions start the Agent in the operating system command console. In the Agent, you can enter commands or monitor Analytic Services activities (see Understanding the Agent ). You cannot start from ESSCMD or MaxL. To start Analytic Server from Administration Services Console, see Starting Analytic Server Remotely from Administration Services Console . Starting Analytic Server as a Background Process Analytic Server can run as a background process on the Analytic Server computer. System administrators might choose to run Analytic Server as a background process when working in batch mode. Running in batch mode means, for example, that the administrator can start Analytic Server, launch MaxL or ESSCMD, log on to Analytic Server, load data, run calculation scripts or reports, stop Analytic Server, and perform a backup, all from a single UNIX shell script or a Windows NT .bat file. System administrators running Analytic Server on Windows NT or Windows 2000 might also choose to run Analytic Server as a background process in order to use Windows settings to give a performance boost to applications running in the foreground. If you start Analytic Server in the background, these conditions apply: You do not have access to Agent commands. You cannot shut down Analytic Server from the Agent . You must use MaxL or ESSCMD to shut down Analytic Server. You cannot access the application server window to monitor a running application. You must access this information from the application log ( ARBORPATH /app/ appname / appname .log ). You cannot monitor Analytic Server activity using the Agent. You must access this information from the Analytic Server log ( ARBORPATH /essbase.log ). To start Analytic Server in the background on UNIX, or on Windows systems utilizing a UNIX-like shell such as MKS, enter the following command at the operating system command prompt: essbase password -b &amp; You can start Analytic Server without using the ampersand (&amp;) at the end of the command, but if you do not use &amp;, the command prompt is not returned after the Analytic Server is started. Note: The ampersand (&amp;) used in the above context has no effect when used on Windows, unless you are using a UNIX-like shell such as MKS. Analytic Server starts in the background, but control of the command prompt is not returned. You may need to press the Enter key twice in Windows before the command prompt returns. On UNIX systems, to find out if Analytic Server is already running in the background, type this command at the operating system command prompt: ps -ef grep ESS If the Analytic Server is running in the background, it appears in the process list: essbase password -b &amp; For information about hiding the password from the UNIX process list, see the Essbase Analytic Services Installation Guide . For information about how to run Analytic Server as a Windows NT Service, or to see if Analytic Server is already installed as a Windows NT Service, see the Essbase Analytic Services Installation Guide . Changing the System Password Using an Agent command, you can change the password that is required to start the Analytic Server. Note: Changing the system password does not change the connection password that is established for the Analytic Services system supervisor. To change the Analytic Server system password, perform the following tasks: Type password at the command prompt of the Agent in the server console. Type the old (current) system password. Type the new system password. Retype the new system password. Analytic Services verifies that the system password has been updated. For instructions on how to change passwords for users or groups, see Editing Users . Stopping Analytic Server You need Supervisor permissions to stop Analytic Server. To stop (also shut down) Analytic Server and all running applications, use any of the following methods: Tool Topic Location Agent quit exit Enter the command at the command prompt for the Agent in the Analytic Server console window Administration Services Stopping Analytic Server Essbase Administration Services Online Help MaxL alter system shutdown Technical Reference ESSCMD SHUTDOWNSERVER Technical Reference If you stop the Agent by closing the server console window or by pressing Ctrl+C, the next time you start the database, Analytic Services rolls back any transactions that were in progress. See Rollback with Committed Access or Rollback with Uncommitted Access for a description of the roll back process (undoing all transactions after the last committed transaction). Starting Analytic Server Remotely from Administration Services Console You can start Analytic Server remotely from the Enterprise View tree in Administration Services Console. To enable this functionality, you configure and start Remote Start Server on the Analytic Server machine. Remote Start Server then handles requests from Administration Services to start Analytic Server. Each Analytic Server installation includes all files necessary to configure and start Remote Start Server. If you want to start different Analytic Servers from Administration Services Console, you must configure and start a Remote Start Server instance for each Analytic Server. To start Analytic Servers from previous releases, you must first download Remote Start Server from Hyperion Developer Network and install it on each Analytic Server machine. Use the following topics for instructions about starting Analytic Server remotely: Configuring Remote Start Server Starting and Stopping Remote Start Server Running Remote Start Server as a Windows Service Starting Analytic Server from Enterprise View Configuring Remote Start Server Before starting Remote Start Server, you need to configure it if any of the following conditions apply: Analytic Server is configured to run on a non-default port. Environment variables need to be set when Analytic Server is started. The default port used for Remote Start Server (9010) is being used by another program. More than one instance of Analytic Server is installed on a single machine. If none of the conditions apply, you are ready to start Remote Start Server. Skip to Starting and Stopping Remote Start Server . A configuration file for Remote Start Server is installed with Analytic Server. The following topics describe the configuration file and tell you how to modify the file for different purposes: About the Configuration File Specifying a Non-default Analytic Server Port Setting Environment Variables for Startup Specifying a Non-default Remote Start Server Port Configuring Remote Start Server for Multiple Instances of Analytic Server Sample Configuration File About the Configuration File Each Analytic Server installation contains a configuration file that you can use to configure Remote Start Server. The configuration file is: ARBORPATH \\bin\\server.properties The default configuration file contains the following lines: Server1=localhost localhostExecutable = PathToEssbase.exe Where PathToEssbase.exe is the location of the Analytic Server executable file. Keep in mind the following information when editing the configuration file: You can edit the file in any text editor. On Windows, you must always escape the backslash (\\) with an additional backslash (\\\\). See the examples in the following sections. The structure of each line in the file is: key=keyValue The value for the Server1 key may be any one of the following: localhost machineName machineName : port If you change the value of Server1 to machineName , you need to use machineName in place of localhost as the key prefix for any rows you add to the file. As an example on UNIX: Server1=jdoe2 jdoe2Exec utable=/essbase/bin/essbase.exe If you change the value of Server1 to machineName:port , you need to use Server1 in place of localhost as the key prefix for any rows you add to the file. For example (on Windows): Server1=jdoe2:4050 Server1Executable =c:\\\\hyperion\\\\essbase\\\\essbase.exe When adding environment rows to the file, you first specify how many environment rows you are adding. For example: localhostEnvRows= 3 lo calhostEnv1= Variable = VariableValue localhostEnv2= Variable = VariableValue localhostEnv3= Variable = VariableValue For examples, see Setting Environment Variables for Startup Specifying a Non-default Analytic Server Port If Analytic Server is configured to run on a non-default port, in the Remote Start Server configuration file, you must specify the port number being used for Analytic Server. If you are using a non-default port because you are using more than one instance of Analytic Server on a single machine, see Configuring Remote Start Server for Multiple Instances of Analytic Server . To specify a non-default Analytic Server port: From the Analytic Server machine, open the following file: ARBORPATH \\bin\\server.properties Change the following lines, supplying the appropriate information for the italicized text: Server1=localhost localhostExecutable = PathToEssbase.exe to Server1= MachineName:PortNumber Server1Executable = PathToEssbase.exe As an example for Windows: Server1=jdoe2:4050 Server1 Executable= c:\\\\hyperion\\\\essbase\\\\bin\\\\essbase.exe Setting Environment Variables for Startup If environment variables need to be set when Analytic Server is started remotely, you need to add environment information to the Remote Start Server configuration file: On Windows, unless you are using more than one instance of Analytic Server on the same machine, you do not need to set environment variables. For information about configuring multiple instances of Analytic Server, see Configuring Remote Start Server for Multiple Instances of Analytic Server . On UNIX, the environment must be set properly when Analytic Server is started. If the environment is not set, in the Remote Start Server configuration file, you must specify environment variable information to be used for startup. Each UNIX platform has different environment variable requirements; for information about the environment variables that are required for each UNIX platform, see Essbase Analytic Services Installation Guide . To set environment variables for startup: From the Analytic Server machine, open the following file: ARBORPATH \\bin\\server.properties Add lines for each environment variable you need to specify, using the format described in About the Configuration File . The number of environment rows that need to be set depends on your platform. The following sections show examples of how to set environment variables for different UNIX platforms, using the default Analytic Server port and an English ESSLANG value). Solaris Example: Server1=localhost localhostEnvRows=4 localhostEnv1=ARBORPATH=/vol1/essbase localhostEnv2=LD_LIBRARY_PATH=/vol1/common/ODBC/Merant/ 4.2/lib:/vol1/essbase/bin;$LD_LIBARY_PATH localhostEnv3=ESS_JVM_OPTION1=-Xusealtsigs localhostEnv4=ESSLANG=English_UnitedStates.Latin1@Binary localhostExecutable=/vol1/essbase/bin/ESSBASE AIX Example: Server1=localhost localhostEnvRows=3 localhostEnv1=ARBORPATH=/vol1/essbase localhostEnv2=LIBPATH=/vol1/common/ODBC/Merant/ 4.2/lib:/vol1/essbase/bin;$LIBPATH localhostEnv3=ESSLANG=English_UnitedStates.Latin1@Binary localhostExecutable=/vol1/essbase/bin/ESSBASE HP-UX Example Server1=localhost localhostEnvRows=3 localhostEnv1=ARBORPATH=/vol1/essbase localhostEnv2=SHLIB_PATH=/vol1/common/ODBC/Merant/ 4.2/lib:/vol1/essbase/bin;$SHLIB_PATH localhostEnv3=ESSLANG=English_UnitedStates.Latin1@Binary localhostExecutable=/vol1/essbase/bin/ESSBASE Specifying a Non-default Remote Start Server Port By default, the Remote Start Server is configured to run on port 9010. If this port is being used by another program, you must specify a different port number before you start Remote Start Server. The port number must be specified in the Remote Start Server configuration file on the Analytic Server machine and in a configuration file on the Administration Server machine. To specify a non-default Remote Start Server port: From the Analytic Server machine, open the following file: ARBORPATH \\bin\\server.properties Add the following line, supplying the appropriate information for the italicized text: ServerPort= PortNumber For example: ServerPort=9030 From the Administration Server machine, open the following file: EASPATH \\eas\\server\\olapadmin.properties Add one of the following lines: If you want Remote Start Server to use a specific port for a specific Analytic Server, add the following line, supplying the appropriate information for the italicized text: AnalyticServerName .REMOTE_START_SERVER= PortNumber For example: jdoe2.REMOTE_START_SERVER=9030 If you want Remote Start Server to use the same, non-default port for all Analytic Servers, add the following line, supplying the appropriate information for the italicized text: REMOTE_START_SERVER= PortNumber For example: REMOTE_START_SERVER=9030 Configuring Remote Start Server for Multiple Instances of Analytic Server If more than one instance of Analytic Server is installed on one machine, you need to configure and start Remote Start Server for only one of the installations. Choose one of the Analytic Server installations, and add configuration information for both Analytic Server instances to the configuration file that is installed with that instance. Note: For information about installing multiple Analytic Server agents, see Installing Additional Instances of Analytic Server: Windows or Installing Additional Instances of Analytic Server: UNIX . To configure Remote Start Server for multiple instances of Analytic Server on one machine: Select one of the Analytic Server installations, and open the following file from the directory structure under that installation: ARBORPATH \\bin\\server.properties Add the following lines to the file, supplying the appropriate information for the italicized text: Server2= MachineName:PortNumber Server2EnvRows=1 Server2Env1=ARBORPATH= ARBORPATHvalue Server2Executable= PathToEssbase.exe As an example on Windows: Server2=jdoe2:4050 Server2EnvRows=1 Server2Env1=ARBORPATH=c:\\\\hyperion\\\\essbase Server2Executable=c:\\\\hyperion\\\\essbase2\\\\ bin\\\\essbase.exe Note that ARBORPATH must be set explicitly for the second server instance. Also, for UNIX platforms, if the environment is not already set for either Analytic Server instance, you need to specify environment variable information in the Remote Start Server configuration file. For information about the environment variables that are required for each UNIX platform, see Essbase Analytic Services Installation Guide . Windows Example The following example for Windows shows the default configuration for localhost and the additional configuration needed for a second instance of Analytic Server ( jdoe2 ), which runs on port 4050. Server1=localhost localhostExecutable=c:\\\\hyperion\\\\essbase\\\\ bin\\\\essbase.exe Server2=jdoe2:4050 Server2EnvRows=1 Server2Env1=ARBORPATH=c:\\\\hyperion\\\\essbase2 Server2Executable=c:\\\\hyperion\\\\essbase2\\\\ bin\\\\essbase.exe UNIX Example (Solaris) The following example for Solaris shows the configuration for localhost and for the second instance of Analytic Server ( jdoe2 ), which runs on port 4050. In this example, the environment is set for both Analytic Server instances. Server1=localhost localhostEnvRows=4 lo calhostEnv1=ARBORPATH=/vol1/essbase localhostEnv2=LD_LIBRARY_PATH=/vol1/common/ODBC/Merant/ 4.2/lib:/vol1/essbase/bin;$LD_LIBARY_PATH localhostEnv3=ESS_JVM_OPTION1=-Xusealtsigs localhostEnv4=ESSLANG=English_UnitedStates.Latin1@Binary localhostExecutable=/vol1/essbase/bin/ESSBASE Server2=jdoe2:4050 Server2EnvRows=4 Server2 Env1=ARBORPATH=/vol2/essbase2 Server2 Env2=LD_LIBRARY_PATH=/vol2/common/ODBC/Merant/ 4.2/lib:/vol2/essbase2/bin:$LD_LIBRARY_PATH Server2 Env3=ESS_JVM_OPTION1=-Xusealtsigs Server2 Env4=ESSLANG=English_UnitedStates.Latin1@Binary Server2 Executable=/vol2/essbase2/bin/ESSBASE Sample Configuration File The following sample configuration file for Windows sets the Analytic Server port to 4050; sets the ARBORPATH environment variable; and sets the Remote Start Server port to 9030: Server1=jdoe2:4050 Server1EnvRows=1 Server1Env1=ARBORPATH=c:\\\\hyperion\\\\essbase Server1Executable=c:\\\\hyperion\\\\essbase\\\\bin\\\\essbase.exe ServerPort=9030 Starting and Stopping Remote Start Server When you are sure that Remote Start Server is properly configured, you can start and stop it as needed. After Remote Start Server is started, you can start Analytic Server. Note: On UNIX platforms, Remote Start Server can start an Analytic Server only if the Analytic Server is installed by the same user ID that was used to start Remote Start Server. If Remote Start Server is started by the root user, then Remote Start Server can start an Analytic Server that was installed by any user. To start Remote Start Server: On Windows platforms, launch ARBORPATH \\bin\\remoteStart.exe On UNIX platforms, launch ARBORPATH /bin/remotesvr To stop Remote Start Server: On Windows platforms, launch ARBORPATH \\bin\\stopsvr.exe On UNIX platforms, launch ARBORPATH /bin/stopsvr Running Remote Start Server as a Windows Service You can install and start Remote Start Server as a Windows service. To install and start Remote Start Server as a Windows Service, launch ARBORPATH \\bin\\install_service.bat This file installs Remote Start Server as a Windows service (named Essbase Remote Start Server) and starts the service. You can then manage the service by using Windows Control Panel or by using the net start and net stop commands. To remove the Essbase Remote Start Server Windows Service, launch ARBORPATH \\bin\\remove_service.bat Starting Analytic Server from Enterprise View After Remote Start Server is started, you can start Analytic Server from Enterprise View in Administration Services Console: To start Analytic Server: From Enterprise View, select the Analytic Server node that you want to start. Right-click and select Start from the pop-up menu. When prompted, enter the password for Analytic Server. The request is sent to Remote Start Server, which then starts Analytic Server. If Remote Start Server is not running, an error message is displayed in Administration Services Console. Note: Analytic Server starts in the background on all platforms, with the password hidden. Starting and Stopping Administration Services Before you start Administration Services, make sure that the Analytic Servers you want to manage are started. To start Administration Services, first start Administration Server, and then start Administration Services Console. To start Administration Services, see Starting Administration Services in Essbase Administration Services Installation Guide . Starting and Stopping Applications When an application is started, Analytic Services loads the application and all associated databases into memory on the Analytic Server. All client requests for data, such as data loads, calculations, reports, and spreadsheet lock and sends, are then handled through the application server, the ESSSVR process. The application server is always started by the Agent. Multiple applications (ESSSVR processes) can run on Analytic Server concurrently. On Windows, a separate window opens for each ESSSVR process that is running. If an application contains multiple running databases, all databases are managed by the one application server. When you stop an application, Analytic Services unloads all information and databases from memory on Analytic Server and closes the application server process. This section contains the following sections: Starting an Application Stopping an Application Stopping an Application Improperly Starting an Application When you start an application, the following actions can happen: Users can connect to the application. The application can respond to commands from the Agent. Users can change the settings of the application. Data and user security are enabled. Each database in the application can start. To start an application, use any of the following methods: Tool Topic Location Agent START appname Enter the command at the command prompt for the Agent in the Analytic Server console window Administration Services Starting Applications Essbase Administration Services Online Help MaxL alter system load application Technical Reference ESSCMD LOADAPP or SELECT Technical Reference This action starts the application and, if you are running on Windows, opens the application server window on the Analytic Server computer. You can also start an application by completing any of these actions: Starting a database within an application, as discussed under Starting a Database . Saving an outline to Analytic Server. Opening an outline does not start an application. To control how applications are started, use either of the following methods: Tool Topic Location Administration Services Configuring Applications to Start Automatically Essbase Administration Services Online Help MaxL alter application enable autostartup Technical Reference When application startup (Allow user to start application) is enabled, if an application is stopped and a user attempts to retrieve data from any databases within that application, the application starts on the Analytic Server computer automatically. When application autostartup (Start application when Analytic Services starts) is enabled, users may experience better initial performance when they make requests of databases in that application, because the application and databases are already loaded into memory on the Analytic Server computer. Stopping an Application When you stop an application, transactions may be currently running. If you stop an application using any of the following methods, the application does not stop if a calculation or data load is in progress. Instead, Analytic Services displays a message in the Agent console. It is important to stop an application properly. If the application server is not brought down properly, databases within the application may become corrupt. To stop the application, use any of the following methods: Tool Topic Location Agent stop appname Enter the command at the command prompt for the Agent in the Analytic Server console window Administration Services Stopping Applications Essbase Administration Services Online Help MaxL alter system unload application Technical Reference ESSCMD UNLOADAPP Technical Reference If you stop the Agent by closing the server console window or by pressing Ctrl+C, the application stops, and the next time you start the application, Analytic Services rolls back any transactions that were in progress. See Rollback with Committed Access or Rollback with Uncommitted Access for a description of the rollback process (undoing all transactions after the last committed transaction). Stopping an Application Improperly There are times when stopping the application server process improperly is necessary; for example, if the application server is corrupted and not processing client requests. In this case, stopping the application server by shutting down its corresponding window is the only method of the stopping the application. To stop the application improperly, use any of the following methods: Operating system Instructions to stop the application improperly Windows Use any of the following methods: Perform a Windows operating system End Task. The Windows NT Task Manager does not display process IDs for individual Analytic Services applications-all of the running Analytic Services applications are displayed as undifferentiated ESSSVR processes. This situation prevents you from stopping a single application, in the event that the application freezes. Click the Close button in the upper-right corner of the application server window. Kill the process ID by using the process ID number in conjunction with a kill operating system utility. Such a utility is provided with Windows NT Resource Kit and with various other toolkits. You can find the process ID for individual servers in the essbase.log file in the ARBORPATH directory. When the server starts, a line like the following is displayed in the Analytic Server log: Application [Sample] started with process id [225] UNIX Kill the ESSSVR process. On UNIX platforms, you can use the ps output to identify individual applications. If an application freezes, you can stop the application by using this command: kill -9 &lt;pid&gt; Both On any platform, shut down the Analytic Server computer prior to shutting down the Agent Starting and Stopping Databases Starting a database loads the database into memory on the Analytic Server computer. Stopping a database unloads all database information from memory on the Analytic Server computer. This section contains the following sections: Starting a Database Stopping a Database Starting a Database When Analytic Services starts a database and loads it to memory, the entire index cache for that database is allocated in memory automatically. The data cache and data file cache are allocated as blocks are requested from Analytic Services clients. When you start an application, Analytic Services loads the application and its databases into memory on the Analytic Server computer. When you start a database from an application that is not loaded, the application is loaded along with all its related databases. To start a database, use any of the following methods: Tool Topic Location Agent START appname Enter the command at the command prompt for the Agent in the Analytic Server console window. Administration Services Starting Databases Essbase Administration Services Online Help MaxL alter application load database Technical Reference ESSCMD LOADDB or SELECT Technical Reference To configure a database to start automatically when its parent application starts, use either of the following methods: Tool Topic Location Administration Services Configuring Databases to Start Automatically Essbase Administration Services Online Help MaxL alter database enable autostartup Technical Reference Stopping a Database Stopping a database unloads all data from memory and commits any updated data to disk. If a database is stopped and a user attempts to retrieve data from it, the database starts on Analytic Server automatically, without any explicit commands issued. When you stop a database, transactions may be currently running. If you issue the STOP command in the server console window, an UNLOADDB command in ESSCMD, or alter application unload database in MaxL, the database does not stop if a calculation or data load is in progress. Instead, Analytic Services displays a message in the server console window. If you stop the Agent by closing the server console window or by pressing Ctrl + C, the database stops, and the next time you start the database, Analytic Services rolls back any transactions that were in progress. See Rollback with Committed Access or Rollback with Uncommitted Access for a description of the rollback process (undoing all transactions after the last committed transaction). To stop a database, use any of the following methods: Tool Topic Location Agent STOP appname Enter the command at the command prompt for the Agent in the Analytic Server console window. Administration Services Stopping Databases Essbase Administration Services Online Help MaxL alter application unload database Technical Reference ESSCMD UNLOADDB Technical Reference Managing Security-File Defragmentation Changing or deleti ng the following Essbase security entities can cause fragmentation in the security file (essbase.sec): filters, users, groups, applications, databases, substitution variables, disk volumes, passwords, and other Essbase objects. Too much fragmentation in files can slow down security-related performance. Analytic Services compacts the security file automatically each time the Agent is stopped. You can check the defragmentation status of the security file and, if desired, you can compact the security file without stopping the Agent. Displaying the Defragmentation Status of the Security File The defragmentation status of the security file is displayed as a percent. To display the defragmentation status of the security file, use the following method: Tool Topic Location MaxL display system security file fragmentation_percent Technical Reference Compacting the Security File While the Agent is Running Besides manually compacting the security file, you can use the SECURITYFILECOMPACTIONPERCENT configuration setting to define a percentage of defragmentation that triggers defragmentation automatically. To compact the security file without stopping the Agent, use either of the following methods: Tool Method Documentation Location Agent COMPACT Enter the command at the command prompt for the Agent in the Analytic Server console window &#160; MaxL alter system compact security file Technical Reference essbase.cfg SECURITYFILECOMPACTIONPERCENT Technical Reference Note: Compacting the security file while the Agent is running slows down Agent activity until the operation is completed, which could take a few minutes. Managing Ports The Agent enables you to manage ports on Analytic Server. This section contains the following sections: Viewing a List of Users and Available Ports Specifying Non-Default Port Values Changing Port Default Values Viewing Port Statistics Managing Administration Server Communication Ports Viewing a List of Users and Available Ports The Agent enables you to view a list of all users that are connected to Analytic Server at any given time. Additionally, you can view the total number of ports available, as well as the number of existing connections. For information about how connections/ports are established in Administration Services, see About Analytic Services Connections and Ports in Essbase Administration Services Online Help . To view a list of all users connected to Analytic Server, type the command USERS at the command prompt of the Analytic Server console. The server console displays the following information: The names of all users connected to Analytic Server The total number of ports available The total number of existing connections The application to which each user is connected The database to which each user is connected To view the number of ports installed on Analytic Server, as well as the number of ports in use, use any of the following methods: Tool Topic Location Agent PORTS Enter the command at the command prompt for the Agent in the Analytic Server console window. Administration Services Checking Available Ports Essbase Administration Services Online Help MaxL display user Technical Reference ESSCMD LISTUSERS Technical Reference Specifying Non-Default Port Values If you wish to change the default port values used by the Agent, you must set one or more of these configuration settings: AGENTPORT specifies the port that the Agent uses. SERVERPORTBEGIN specifies the first port number the Agent on a single computer tries to use for its first server process. SERVERPORTEND specifies the highest value the Agent tries to use for a port when it tries to start a server process. If the value is unavailable, the server process fails. PORTINC specifies the value of the increment in between port numbers used by the Agent. You may wish to change the default for many reasons. Here are two examples: The default value is inappropriate for your site because it specifies a port number already in use. To change default values for one installation on a single computer, see Changing Port Default Values . You may wish to install a second instance of Analytic Server on a single computer to facilitate testing. Use the configuration settings to assign the second Analytic Server instance to a different port than the first. For detailed instructions, see Installing Additional Instances of Analytic Server: Windows or Installing Additional Instances of Analytic Server: UNIX . Changing Port Default Values If you simply need to change one or more of the default values associated with Agent and server ports, review the Technical Reference for instructions about the correct configuration setting to change: AGENTPORT specifies the port that the Agent uses. SERVERPORTBEGIN specifies the first port number the Agent on a single computer tries to use for its first server process. SERVERPORTEND specifies the highest value the Agent tries to use for a port when it tries to start a server process. If the value is unavailable, the server process fails. PORTINC specifies the value of the increment in between port numbers used by the Agent. Viewing Port Statistics You can enable Analytic Services to log, at a specified interval, the number of ports being used. By analyzing the information in the log, you can monitor port utilization and identify a need for more ports before end users are unable to connect. To enable Analytic Server to check port use statistics and write those statistics to the Analytic Server log: Edit the server configuration file essbase.cfg to include the setting, PORTUSAGELOGINTERVAL: PORTUSAGELOGINTERVAL n where the value of n represents the number of minutes between each check of the number of ports in use. The value of n can be any whole number from 1 to 60, with five being the recommended minimum and default value. Analytic Services ignores any portion of a non-whole number. For example, Analytic Services evaluates 2.5 as 2 minutes. Statistics are written to the log immediately after each check. After adding PORTUSAGELOGINTERVAL to essbase.cfg, you need to restart Analytic Server, then view the Analytic Server log file. The log file will look similar to the following output: [Mon Apr 22 00:48:50 2003]Local/ESSBASE0\/\//Info(1056214) [3] ports in use, [10] ports allowed For more information about the PORTUSAGELOGINTERVAL setting, see the Technical Reference . Managing Administration Server Communication Ports Administration Server has several configurable communication ports, which are different from Analytic Server ports. For more information, see About Administration Server . Controlling Query Size and Duration Users may unintentionally request information that is so large or so complex to retrieve that the query will slow performance or fail to complete properly. To prevent this from occurring, use the following configuration settings to control query size or duration: QRYGOVEXECTIME limits the length of time Analytic Server allows a query to run before terminating the query. QRYGOVEXECBLK limits the number of blocks a query can access before terminating the query. These two configuration settings are also referred to as query governors . You can apply these settings to all the applications and databases on Analytic Server, to all the databases on a single application, or to a single database. For details about how to use these configuration settings, see the Technical Reference , in the essbase.cfg Settings topic. Installing Additional Instances of Analytic Server: Windows You can install multiple instances of Analytic Server on a single Windows computer. For example, you could install a test version and a production version. To install and configure an additional instance of Analytic Server on a single Windows computer, perform the following tasks: On a computer where you have already installed Analytic Server according to the instructions in the Essbase Analytic Services Installation Guide , install the Analytic Server component in a different directory from the first Analytic Server installation. You need not install any of the clients, such as Administration Services. In the ARBORPATH \\bin directory on the Analytic Server computer of the new installation, create or modify the essbase.cfg file on the Analytic Server so that it contains these settings: AGENTPORT: The port that this second Analytic Server Agent uses to connect. SERVERPORTBEGIN: The first port that the first Analytic Server process tries to use to connect. SERVERPORTEND: The highest value for a port number that the Analytic Server process can use to connect. PORTINC: The increment between ports. For example, if PORTINC is assigned a value of 5, Analytic Services looks for ports 32700, 32705, and so on up to the value of SERVERPORTEND. Use the instructions in the Technical Reference to select values for these settings. Create a batch script ( .bat ) that performs these tasks: Sets ARBORPATH to the correct value for this installation Adds this path to the PATH variable: %arborpath%\\bin;%path% Starts Analytic Server Note: This installation is a separate installation of Analytic Server. It shares none of the security or objects of any other Analytic Server installation on the same computer. When multiple instances of Analytic Server are installed on a single machine, you can connect to an Analytic Server agent by specifying the machine name and the agent port number, in the form: machineName : agentPort . You can also edit or create the client configuration file to identify the Analytic Server agent port to connect to. The configuration file identifies the default Analytic Server agent port. When you connect to an Analytic Server and specify the machine name only (but no agent port number), you are connected to the Analytic Server agent port specified in the configuration file. You can override the configuration file setting by using the machineName : agentPort syntax when connecting. To connect to an Analytic Server when multiple instances of Analytic Server are installed on the same machine, perform either of the following actions: Explicitly identify the Analytic Server agent port to connect to. When you connect to an Analytic Server agent and are prompted for the hostname, specify the machine name and the Analytic Server agent port in the form: machineName : agentPort . For example: Enter Host&gt; localHost:9008 agentPort is the Analytic Server agent port number, which is specified in the server configuration file for Analytic Server. See step2 for information on editing the server configuration file. Create or modify the essbase.cfg file on the client machine to identify the Analytic Server agent port to connect to. Note: When working with a partitioned database, if the partition's source or target database resides on an Analytic Server where the Agent port is different from the default port, the user's connection to both Analytic Servers must be defined using servername :: portnumber . This rule applies to both Analytic Servers, even if only one of them uses a non-default Agent port. To create or modify the client configuration file, essbase.cfg , specify the same settings as you did in step2 for the Analytic Server configuration file. The client configuration file is located on the client computer at \\ ARBORPATH \\bin . When you connect to an Analytic Server and are prompted for the hostname, specify the hostname and not the port because the port is read from the configuration file. For example: Enter Host&gt; localHost Note: You can override the setting in the client configuration file and connect to a different Analytic Server by using the machineName : agentPort syntax when prompted for the hostname. Installing Additional Instances of Analytic Server: UNIX To install and configure a second instance of Analytic Server on a single UNIX computer, perform these tasks: On the computer where you plan to use two instances of Analytic Server, create a new operating system login ID to run the new Analytic Server. For instructions, refer to your operating system documentation. On a computer where you have already installed Analytic Server according to the instructions in the Essbase Analytic Services Installation Guide , install the Analytic Server component in a different directory from the first Analytic Server installation. You need not install any of the clients, such as Administration Services. Assign the correct permissions so the new login ID can be used to run Analytic Server. For instructions, see the Essbase Analytic Services Installation Guide . Create the necessary path and library statements in the profile for the new login ID. You may want to copy an existing login ID profile for a login ID that runs the existing Analytic Server installation, and change the values for the new installation. Perform step2 from Installing Additional Instances of Analytic Server: Windows . Repeat previous step for the essbase.cfg file on the client. Start the new Analytic Server using the new login ID. Increasing Agent Connections to Analytic Server You can use the configuration settings AGENTTHREADS and AGTSVRCONNECTIONS to control the maximum number of threads that the Agent creates to perform the initial connection to Analytic Server. Increasing the maximum number of possible threads between Analytic Server and the Agent allows more than one user to log on and connect to an application and database at a time. Note: All requests for information after initial connection and before disconnection are handled by a different set of server threads, whose maximum number is controlled by the SERVERTHREADS configuration parameter. To increase the maximum possible number of agent threads, perform these tasks: Create or edit the essbase.cfg file on Analytic Server to include these settings: AGENTTHREADS maximum_number_of_threads Maximum number of threads that can be spawned by the Agent. These threads are agent threads, and are used by both the server threads controlled by AGTSVRCONNECTIONS for initial connection and disconnection and for other Agent tasks such as answering a request to list users, list applications, or create new users, for example. AGTSVRCONNECTIONS maximum_number_of_threads Maximum number of threads that the server can spawn to communicate with Agent for initial connection and disconnection. These threads are unrelated to the server threads whose maximum number is controlled by SERVERTHREADS. Keep the value of maximum_number_of_threads for AGTSVRCONNECTIONS equal to or less than that value for AGENTTHREADS to avoid wasting resources. Each connection requires one thread each from server and Agent, so there is no need for higher values for AGTSVRCONNECTIONS. The default value for each setting is 5, the minimum is 1, and the maximum is 500. Save the essbase.cfg file. Stop and restart Analytic Server to initialize the changes. Limiting the Number of User Sessions You can limit the maximum number of user sessions allowed to connect to Analytic Server at any one time, using the configuration parameter MAXLOGIN. This number includes multiple instances of the same user. For example, the same user with five open Excel worksheets connected to the same Analytic Server use one port, but five sessions. You may wish to adjust the value of MAXLOGIN to match computer resources, or to more closely manage concurrent ports and user sessions. A concurrent port is used for each unique combination of client machine, Analytic Server, and login name. To limit the number of simultaneous user sessions using the configuration setting MAXLOGIN, create or edit the essbase.cfg file on Analytic Server to contain this setting: MAXLOGIN maximum_number_of_user_sessions The maximum_number_of_user_sessions minimum is 1, maximum is 1048575, and the default value is 1000. User sessions use the threads whose maximum is controlled by the configuration setting SERVERTHREADS, and are not related to the threads whose maximum is controlled by AGENTTHREADS and AGTSVRCONNECTIONS.  |../dagent.htm",
    "Managing Applications and Databases||This chapter describes the files that are associated with Analytic Services and describes operations that you can perform to manage Analytic Services applications, databases, and database objects. This chapter contains the following sections: Understanding Applications and Databases Understanding How Analytic Services Files Are Stored Managing Applications, Databases, and Database Objects Migrating Applications Using Administration Services Porting Applications Across Platforms Understanding Applications and Databases An application is a management structure that contains one or more Analytic Services databases and related files. Analytic Services applications and databases usually reside on the Analytic Server. The server computer can store multiple applications. An Analytic Services database is a data repository that contains a multidimensional data storage array. A multidimensional database supports multiple views of data so that users can analyze the data and make meaningful business decisions. Files that are related to Analytic Services databases are called objects . Database objects perform actions against one or more Analytic Services databases, such as defining calculations or reporting against data. By default, objects are stored in their associated database folder on the server. Some objects can also be saved to a client computer or to other available network directories. For a detailed description of how Analytic Services stores files, see Understanding How Analytic Services Files Are Stored . In Analytic Services, the common types of database objects include the following: A database outline (a storage structure definition) Data sources Rules for loading data and building dimensions dynamically (rules files) Scripts that define how to calculate data (calculation scripts) Scripts that generate reports on data (report scripts) Security definitions Security filters Linked reporting objects Partition definitions Some of these objects are optional, such as calculation scripts, filters, and linked reporting objects. For a complete description of each database object, see Understanding Database Objects . Understanding How Analytic Services Files Are Stored In order to manage applications and databases, you need to know how Analytic Services stores server, application, database, and database object files. In particular, there are a few key directories that you should know about. These directories are created under the root directory of the Analytic Services installation (the directory path named by the value of ARBORPATH ): An App directory stores Analytic Services application files as they are created. Each application is stored in a subdirectory under the App directory (for example, \\essbase\\App\\Sample ). Each database in an application is stored in a subdirectory under the application subdirectory (for example, \\essbase\\App\\Sample\\Basic ). Database objects, such as outlines, calculation scripts, report scripts, rules files, and data sources, are typically stored on the server in the appname or dbname directory, on a client computer, or on a network. See Table39 for a list of application and database files. The bin directory contains the Analytic Services software. See Table38 for a list of files stored in this directory. The client directory contains client-based applications and databases. This folder is created during installation of Spreadsheet Add-in or the Runtime Client. The docs directory is created if you choose to install online HTML or PDF documentation. This directory contains numerous subdirectories and files. The eas directory is created if you installed Administration Services on the same computer as Analytic Services. For more information about the contents of this directory, see Essbase Administration Services Installation Guide . The locale directory contains the character-set files necessary for all languages that are supported by Analytic Services, including English. If you installed SQL Interface, ODBC-driver documentation is located in the odbcdocs directory in PDF format. Note: On Windows platforms, these directory names may appear with different case. For more information about all directories created on the server and for information about platform differences, see the Essbase Analytic Services Installation Guide . Server Software File Types This table lists the types of Analytic Services files that are stored in the \\essbase\\bin directory: Table 38: Analytic Services File Types in the \\essbase\\bin Directory File Extension Description bak Backup of security file bnd Microsoft ODBC file for SQL Interface installation using a DB2 database cfg Analytic Server configuration file cnt Online help contents file cpl Microsoft ODBC driver for Windows platforms dll Microsoft Windows Dynamic Link Library eqd Query Designer files exe Executable file hlp Online help file lck Lock file lic License information file for ODBC pl Sample Perl script pm Perl Module mdb Message database file sec Security file sl HP-UX shared library file so Solaris shared library file xll Spreadsheet Add-in for Microsoft Excel Application and Database File Types The following table lists the file types that Analytic Services uses to store applications, databases, and their related objects. Table 39: Analytic Services File Types for Applications and Databases  File Extension Description alg Spreadsheet audit historical information apb Backup of application file app Application file, defining the name and location of the application and other application settings arc Archive file atx Spreadsheet audit transaction chg Outline synchronization change file csc Analytic Services calculation script db Database file, defining the name, location, and other database settings dbb Backup of database file dbf dBASE data file ddb Partitioning definition file ddm Temporary partitioning file ddn Temporary partitioning file esm Analytic Services kernel file that manages pointers to data blocks, and contains control information that is used for database recovery esr Temporary database root file esn Temporary Analytic Services kernel file ind Analytic Services index file inn Temporary Analytic Services index file log Server or application log lro Linked reporting object file that is linked to a data cell lst Cascade table of contents or list of files to back up mdx dBASE multiple index file mxl MaxL script file (saved in Administration Services) ocl Database change log ocn Incremental restructuring file oco Incremental restructuring file olb Backup of outline change log olg Outline change log otl Analytic Services outline file otm Temporary Analytic Services outline file otn Temporary Analytic Services outline file oto Temporary Analytic Services outline file pag Analytic Services database data (page) file pan Temporary Analytic Services database data (page) file rep Analytic Services report script rul Analytic Services rules file scr Analytic Services ESSCMD script sel Saved member select file tct Analytic Services database transaction control file that manages all commits of data and follows and maintains all transactions tcu Temporary database transaction control file trg Trigger definition file.XML (Extensible Markup Language) format. txt Text file, such as a data file to load or a text document to link as a linked reporting object xcp Exception error log xls Microsoft Excel spreadsheet file API File Types The following table lists the types of Analytic Services files that are stored in the \\ ARBORPATH \\api sub-directories: Table 40: Analytic Services File Types in the api Directory File Extension Description a UNIX static library file bas Microsoft Visual Basic program source file, containing header definitions for the Analytic Services API h C or C++ header file, containing header definitions for the Analytic Services API lib C or C++ program library np Named Pipes network library tcp TCP/IP network library Managing Applications, Databases, and Database Objects This section explains how to manage applications, databases, and database objects: Using the File System to Manage Applications and Databases During Backup Monitoring Applications Using Analytic Services to Manage Applications and Databases Using Analytic Services to Manage Objects For a description of Analytic Services applications, databases, and database objects, see Understanding Applications and Databases and Understanding Database Objects . Using the File System to Manage Applications and Databases During Backup You should not use the platform file system to copy, move, rename, or delete applications and databases. When an application or database is altered through the file system, the Analytic Services security file is unable to recognize the changes. This situation creates a mismatch between what actually exists on the hard drive and what exists according to Analytic Services. Caution: Do not move, copy, modify, or delete any of these files- ess n .ind , ess n .pag , dbname .ind , dbname .esm , dbname .tct . Doing so may result in data corruption. The only time the file system should be used to manage applications and databases is during the backup process, where the entire directory for an application or database is copied and stored elsewhere. For a comprehensive discussion of backups, see Backing Up and Restoring Data. Certain application and database files can be successfully managed through the file system: Rules files for dimension builds and data loads ( .rul ) Data load or dimension build files Calculation scripts ( .csc ) Report scripts ( .rep ) MaxL scripts ( .mxl or any extension) To copy or move an outline file ( .otl ), you must use Administration Services. For instructions, see Copying Outlines in Essbase Administration Services Online Help . Monitoring Applications Each application that is loaded is an open task or process in the operating system. On Windows platforms, the application is displayed in a command-line window. On UNIX platforms, the application server is a child process of ESSBASE . When the application starts, ESSBASE starts the esssvr process. For more information, see Starting an Application . On Windows platforms, when an application starts, a new icon is displayed in the task bar. You can double-click the icon to view the server window. Analytic Server records application-level activities in an application log. For more information, see Using Analytic Services Logs . To view application activities as they occur, use either of the following methods: Tool Instruction On Windows platforms, use the application-process window Select the command-line window that bears the name of the application. UNIX tail -f logfile Using Analytic Services to Manage Applications and Databases This section describes managing applications and databases. It contains the following sections: Viewing Applications and Databases Copying or Migrating Applications Renaming Applications Deleting Applications Copying Databases Renaming Databases Deleting Databases Viewing Applications and Databases When you start Administration Services Console, the Enterprise View tree is displayed in the navigation panel. Enterprise View is a graphical tree view of the Analytic Services environment. It displays the Administration Servers and Analytic Servers that you select. Your view of the Analytic Services environment may look different from that of other administrators. Applications and databases, and their associated objects, are represented as nodes beneath the Analytic Server node. Objects are grouped into container nodes. For example, individual applications are contained in the Applications node, and databases are contained in the Databases container node. If sample applications and databases are installed with Analytic Server, they appear in Enterprise View along with your organization's applications and databases. For more information about operating on applications and databases from Enterprise View, see About Enterprise View in Essbase Administration Services Online Help . To create a new application, see Creating Applications in the Essbase Administration Services Online Help . Copying or Migrating Applications You can copy an application to any Analytic Server to which you have appropriate access. You can copy (migrate) an entire application to another Analytic Server, or you can copy an application on the same Analytic Server. For example, you may need to migrate an entire application from a development server to a production server. Or, you may want to copy an application on the same server for testing or for backup purposes. Analytic Services copies applications differently depending on whether you are copying to the same Analytic Server or to a different Analytic Server. When you migrate applications, you can select the objects to migrate, such as calculation scripts, report scripts, rules files, custom-defined macros and functions, substitution variables, and filters. You can also specify how user and group security is migrated. Administration Services provides a Migration Wizard that helps you migrate applications. See Migration Wizard in Essbase Administration Services Online Help . To copy an application, use any of the following methods: Tool Topic Location Administration Services Copying Applications Essbase Administration Services Online Help MaxL create application as Technical Reference ESSCMD COPYAPP Technical Reference Renaming Applications When you rename an application, the application and its associated directory ( essbase\\app\\ appname ) are renamed. All objects within the application (for example, databases or calculation scripts) with the same name as the application are not renamed. Before you rename an application, see Rules for Naming Applications and Databases . To rename an application, use any of the following methods: Tool Topic Location Administration Services Renaming Applications Essbase Administration Services Online Help MaxL alter application Technical Reference ESSCMD RENAMEAPP Technical Reference Deleting Applications When you delete an application, all objects within the application are also deleted. The \\essbase\\app\\ appname directory and all files located in the directory are deleted. To delete an application, use any of the following methods: Tool Topic Location Administration Services Deleting Applications Essbase Administration Services Online Help MaxL drop application Technical Reference ESSCMD DELETEAPP Technical Reference Copying Databases You can copy a database in an application to any Analytic Server and application to which you have appropriate access. You can copy (migrate) an entire database to another Analytic Server, or you can copy a database on the same Analytic Server. For example, you may need to migrate an entire database from a development server to a production server. Or, you may want to copy a database on the same server for testing or for backup purposes. Analytic Services copies databases differently depending on whether you are copying to the same Analytic Server or to a different Analytic Server. For more information, see Copying Databases in Essbase Administration Services Online Help . Administration Services provides a Migration Wizard that helps you migrate applications and databases. See Migration Wizard in Essbase Administration Services Online Help . When you copy a database, all files associated with the database, except data files ( .pag and .ind ), are copied to the destination application. Before copying, make sure you have enough disk space to contain a full copy of the database and its related files. To copy a database, use any of the following methods: Tool Topic Location Administration Services Copying Databases Essbase Administration Services Online Help MaxL create database as Technical Reference ESSCMD COPYDB Technical Reference Renaming Databases When you rename a database, the database and its associated directory ( essbase\\app\\ appname \\ dbname ), and the outline file ( .otl ) are renamed. All other objects in the database (for example, calculation scripts) with the same name as the database are not renamed. To rename a database, use any of the following methods: Tool Topic Location Administration Services Renaming Databases Essbase Administration Services Online Help MaxL alter database Technical Reference ESSCMD RENAMEDB Technical Reference Deleting Databases When you delete a database, all objects within the database are also deleted. The \\essbase\\app\\ appname \\ dbname directory and all files located in the directory are deleted. To delete a database, use any of the following methods: Tool Topic Location Administration Services Deleting Databases Essbase Administration Services Online Help MaxL drop database Technical Reference ESSCMD DELETEDB Technical Reference Using Analytic Services to Manage Objects This section describes copying, renaming, and deleting objects, such as outlines, calculation scripts, report scripts, rules files, and data sources: Copying Objects Renaming Objects Deleting Objects Locking and Unlocking Objects For descriptions of Analytic Services database objects, see Understanding Database Objects . Caution: The only time the file system should be used to manage applications is during the backup process, where the entire directory for an application or database is copied and stored elsewhere. Copying Objects You can copy any database object, except an outline, to another application, database, server, or client location. For instructions on copying outlines, see Creating and Editing Outlines . To copy an object, use any of the following methods: Tool Topic Location Administration Services Topics on copying the specific object; for example, Copying a Rules File Essbase Administration Services Online Help MaxL alter object Technical Reference ESSCMD COPYOBJECT Technical Reference Renaming Objects You can rename any object, except an outline. An outline always has the same name as the database, so you need to rename the database to rename the outline. To rename an object, use any of the following methods: Tool Topic Location Administration Services Topics on renaming the specific object; for example, Renaming a Rules File Essbase Administration Services Online Help MaxL alter object Technical Reference ESSCMD RENAMEOBJECT Technical Reference Deleting Objects You can delete any object, except an outline. An outline is a required part of a database, so you need to delete the database to delete the outline. Tool Topic Location Administration Services Topics on deleting the specific object; for example, Deleting a Rules File Essbase Administration Services Online Help MaxL drop object Technical Reference ESSCMD DELETE command for the object to delete Technical Reference Locking and Unlocking Objects Analytic Services uses a check-out facility for database objects to ensure that only one user modifies an object at one time. This section describes how to lock and unlock objects, with the exception of outlines. For information about locking outlines, see Locking and Unlocking Outlines . Note: Locking objects is not the same as locking data blocks. The Analytic Services kernel handles locking for data blocks, but not for objects. See Data Locks for information about locking data blocks. By default, whenever you open a database object, Analytic Services prompts you to lock the object. You can change this default behavior for some objects; see Setting Analytic Services Default Options in Essbase Administration Services Online Help . When an object is locked, Analytic Services does not allow other users to save over, rename, or delete the object. You can open a locked object and edit it, but you cannot save over the existing object. If you want to save changes made to a locked object, save the modified object to a different location. You can execute and copy objects that are locked. Unlocking Objects You can unlock objects according to your permissions. In Administration Services, you can view all object locks for an Analytic Server, application, or database. To unlock an object, use any of the following methods: Tool Topic Location Administration Services Locking and Unlocking Objects Essbase Administration Services Online Help MaxL alter object Technical Reference ESSCMD UNLOCKOBJECT Technical Reference Migrating Applications Using Administration Services Using Administration Services, you can migrate applications to any Analytic Server to which you have appropriate access, regardless of platform. For example, you may need to migrate an application from a development server to a production server. When you migrate applications, you can select the objects to migrate, such as calculation scripts, report scripts, rules files, custom-defined macros and functions, substitution variables, and filters. You can also specify how user and group security is migrated. To migrate an application, see Copying Applications in the Essbase Administration Services Online Help . Porting Applications Across Platforms Analytic Services runs on multiple platforms, including Windows and UNIX. For a list of supported platforms and information on how to install and configure Analytic Services on each platform, see the Essbase Analytic Services Installation Guide . After you create an application, you may want to port the application to a server that runs a different operating system. This section describes how to port an application to another Analytic Services computer. Porting Analytic Services applications across servers involves these steps: Identifying compatible files Checking file names Transferring compatible files Reloading the database Identifying Compatible Files If you are porting an Analytic Services application to a server that uses a different operating system, you need to identify which Analytic Services files are compatible with the new operating system. The following file types are compatible between operating systems: Text files. The Analytic Services text files are calculation scripts ( .csc ) and report scripts ( .rep ), and any MaxL or ESSCMD scripts you have developed. Also, data files can be text files. Rules files. These files are binary files, but they are compatible between operating systems. Rules files have the extension .rul . Outline files. These files are binary files, but they are compatible between operating systems. Outline files have the extension .otl . The following file types are incompatible between operating systems and need to be redefined or reloaded on the new server: Database files with the extensions .db and .dbb Data files with the extension .pag Index files with the extension .ind Security files with the extension .sec Application files with the extensions .app and . apb Analytic Services Kernel files with the extension .esm Note: If you are using the Linked Reporting Objects feature, you need to relink any files or cell notes on the new server. For a comprehensive discussion of how linked reporting objects are used, see Linking Objects to Analytic Services Data. Checking File Names When transferring files to a UNIX system, you need to be aware of the case of file names. UNIX is a case-sensitive operating system, and files are recognized only if they have the correct case. For example, in certain MaxL and ESSCMD operations, you need to specify a file name, and the file name must be entered with the correct case. The Analytic Services system files use the following naming conventions on UNIX systems: Executable files have no extension and are uppercase (for example, ESSBASE , ESSCMD ). Static library files have the file extension .a and are in lowercase (for example, libessnet.a ). Shared library files have the file extension .sl on HP-UX, .so on Solaris, and .a on AIX. These file names are in lowercase (for example, libesscur.sl ). Security files have the file extension .sec and are in lowercase (for example, essbase.sec ). Message database files have the file extension .mdb and are in lowercase (for example, essbase.mdb ). Online help files have the file extension .hlp and are in lowercase (for example, esscmd.hlp ). Analytic Services files on UNIX systems are capitalized with proper case-the first letter is uppercase, and the remaining letters are lowercase. The following table gives examples of names for different file types: Table 41: File Naming Examples for UNIX File Type Example Database files Mydb.db Data files Mydb.pag Index files Mydb.ind Outline files Mydb.otl Rules files Atlanta.rul Data files to load Atlanta.txt Calculation scripts Mycalc.csc Report scripts Myrepo.rep Archive files Mydb.arc Application logs Myapp.log Note: The application name is an exception to the above rule. The application name can be in lower case. Table42 lists several examples of valid and invalid file names on UNIX systems: Table 42: Valid and Invalid File Names on UNIX Valid File Names Invalid File Names Model.csc MODEL.CSC Monthly.rep Monthly.Rep Forecast.otl forecast.otl Actuals.rul AcTuAlS.rUl My_File.txt My_File.Txt Note: Analytic Services does not allow long file names for applications, databases, calculation scripts, reports, and other database files. All file names for objects you create must conform to the Windows 8.3 convention. Transferring Compatible Files If two servers are connected, you can create the application and database directories on the new server and use either FTP (File Transfer Protocol) or Administration Services to transfer the compatible application files. If the servers are not connected, you need to redefine server information on the new server before reloading the database. Using FTP to Transfer Files Using FTP, you can transfer files directly between operating systems. You should transfer only the files that are compatible between operating systems, and you should transfer the files in binary mode. If you have files with the wrong case on a UNIX server, Administration Services can see these files but cannot open them. After you use FTP to transfer files, you should rename the files on the server to ensure that they are capitalized with proper case. Alternatively, you can use FTP to rename the file when you transfer the file: ftp&gt; put oldfile Newfile Using Administration Services to Transfer Files Using Administration Services, you can transfer files from the client computer to the server in the following ways: As part of an application migration. See Migration Wizard in the Essbase Administration Services Online Help . As part of a database migration. See Copying Databases in the Essbase Administration Services Online Help . One object at a time. See the topic for the individual object, for example, Copying Rules Files, in the Essbase Administration Services Online Help . Redefining Server Information If the server you are porting to is not connected to the existing server, you need to redefine some information on the new server. To redefine server information, follow these steps: To create users and specify their permissions, use Administration Services on the new server. For a description of methods, see Granting Permissions to Users and Groups . To create the applications and databases that you want to port, use Administration Services on the new server. For a comprehensive discussion of how to create applications and databases, see Creating Applications and Databases. Copy the outline files ( .otl ) for the databases that you want to port from the old server to the same directory location on the new server. Make sure the application is not running while you copy these files. See Creating and Editing Outlines . Copy compatible files from the old server to the new server. For lists of compatible and incompatible files, see Identifying Compatible Files . Reload the database. For a review of the reload process, see Reloading the Database . Reloading the Database Database files, such as .db , .pag , .esm , and .ind , are not compatible between operating systems. If you port an application to a server on a different operating system, you need to repopulate the database by reloading the data from a data file and a rules file (if applicable). One way you can reload is to export the data to a text file, transfer the text file to the new server, and then use the text file to load data. After the load is complete, calculate the new database.  |../dappdb.htm",
    "Improving Analytic Services Performance||You can improve Analytic Services performance with these basic techniques: Recognizing Basic Design Issues That Affect Optimization Resetting Databases to Increase Performance Using Database Settings to Customize for Maximum Performance Eliminating Fragmentation Enabling Windows 4 GB RAM Tuning Finding Additional Optimization Information Recognizing Basic Design Issues That Affect Optimization Use the following list to identify basic design issues that affect optimization outside this volume: For an introduction to basic concepts and how they relate to optimized performance, see Basic Architectural Elements. For a discussion of how to analyze a database design while it is still on paper and of how this analysis can aid optimization, see Analyzing and Planning . To understand how basic database outline issues affect performance, see Designing an Outline to Optimize Performance . Resetting Databases to Increase Performance You can periodically reset a database, and then reload it. Even if you reload a database very often, the main database files, .pag files, can grow unless you reset the database. To reset a database, use either of the following methods: Tool Topic Location MaxL alter database appname.dbname reset Technical Reference ESSCMD RESETDB Technical Reference Using Database Settings to Customize for Maximum Performance You can customize Analytic Services for maximum performance, using database settings at the database level in Administration Services, ESSCMD, or MaxL. Note: If you are migrating a database, see the Essbase Analytic Services Installation Guide for information about the default settings after migration. The following sections list performance settings and describe how to adjust them. Database Cache Settings Database Disk Volumes Settings Database Transaction Control Settings Miscellaneous Database Settings Database Cache Settings The following table describes database cache settings and lists the location of the settings in Administration Services, MaxL, and ESSCMD. Table 67: Database Cache Settings  Setting More Information Location in Administration Services, MaxL, ESSCMD Index cache size Sizing the Index Cache Administration Services: Database Properties window, Caches tab MaxL: alter database appname.dbname set index_cache_size n ESSCMD: SETDBSTATEITEM 12 Data file cache size Sizing the Data File Cache Administration Services: Database Properties window, Caches tab MaxL: alter database appname.dbname set data_file_cache_size n ESSCMD: SETDBSTATEITEM 27 Data cache size Sizing the Data Cache Administration Services: Database Properties window, Caches tab MaxL: alter database appname.dbname set data_cache_size n ESSCMD: SETDBSTATEITEM 5 Index page size Fixed size. N/A Cache memory locking Deciding Whether to Use Cache Memory Locking Administration Services: Database Properties window, Caches tab MaxL: alter database appname.dbname enable cache_pinning ESSCMD: SETDBSTATEITEM 26 For more information about these settings in Administration Services, see Setting Database Properties in Essbase Administration Services Online Help . Database Disk Volumes Settings The following table describes database disk volume settings and lists the location of the settings in Administration Services, MaxL, and ESSCMD. Table 68: Database Disk Volume Settings  Setting More Information Location in Administration Services, MaxL, ESSCMD Volume name Specifying Disk Volumes Administration Services: Database Properties window, Storage tab MaxL: alter database appname.dbname set disk volume ESSCMD: SETDBSTATEITEM 23 SETDBSTATEITEM 24 Partition size Specifying Disk Volumes Administration Services: Database Properties window, Storage tab MaxL: alter database appname.dbname set disk volume ESSCMD: SETDBSTATEITEM 23 SETDBSTATEITEM 24 File type Specifying Disk Volumes Administration Services: Database Properties window, Storage tab MaxL: alter database appname.dbname set disk volume ESSCMD: SETDBSTATEITEM 23 Maximum file size Specifying Disk Volumes Administration Services: Database Properties window, Storage tab MaxL: alter database appname.dbname set disk volume ESSCMD: SETDBSTATEITEM 23 For more information about these settings in Administration Services, see Setting Disk Volumes in Essbase Administration Services Online Help . Database Transaction Control Settings The following table describes database transaction control settings and lists the location of the settings in Administration Services, MaxL, and ESSCMD. For more information about database transaction control settings in Administration Services, see Setting Data Integrity Options in Essbase Administration Services Online Help . Table 69: Database Transaction Control Settings  Setting More Information Location in Administration Services, MaxL, ESSCMD Isolation level Understanding Isolation Levels Administration Services: Database Properties window, Transactions tab MaxL: alter database appname.dbname enable committed_mode ESSCMD: SETDBSTATEITEM 18 Commit Blocks Understanding Isolation Levels Administration Services: Database Properties window, Transactions tab MaxL: alter database appname.dbname enable committed_mode and alter database appname.dbname set implicit_commit after n blocks ESSCMD: SETDBSTATEITEM 21 Commit Rows Understanding Isolation Levels Administration Services: Database Properties window, Transactions tab MaxL: alter database appname.dbname enable committed_mode and alter database appname.dbname set implicit_commit after n rows ESSCMD: SETDBSTATEITEM 22 Wait for write access to locked data block Understanding Isolation Levels Administration Services: Database Properties window, Transactions tab MaxL: alter database appname.dbname set lock_timeout ESSCMD: SETDBSTATEITEM 20 Pre-image access Understanding Isolation Levels Administration Services: Database Properties window, Transactions tab MaxL: alter database appname.dbname enable pre_image_access ESSCMD: SETDBSTATEITEM 19 Miscellaneous Database Settings The following table describes miscellaneous database settings and lists the location of the settings in Administration Services, MaxL, and ESSCMD. Table 70: Miscellaneous Database Settings  Setting More Information Location in Administration Services, MaxL, ESSCMD Retrieval buffer size Setting the Retrieval Buffer Size Administration Services: Database Properties window, General tab MaxL: alter database appname.dbname set retrieve_buffer_size n ESSCMD: SETDBSTATEITEM 16 Retrieval sort buffer size Setting the Retrieval Sort Buffer Size Administration Services: Database Properties window, General tab MaxL: alter database appname.dbname set retrieve_sort_ buffer_size n ESSCMD: SETDBSTATEITEM 17 Data compression Data Compression Administration Services: Database Properties window, Storage tab MaxL: alter database appname.dbname enable compression and alter database appname.dbname set compression type ESSCMD: SETDBSTATEITEM 14 SETDBSTATEITEM 15 Maximum memory for trigger definitions Understanding Triggers Definitions MaxL: create or replace trigger, alter trigger display trigger, and drop trigger For more information about these settings in Administration Services, see Setting Database Properties in the Essbase Administration Services Online Help . Eliminating Fragmentation Fragmentation is unused disk space. Fragmentation is created when Analytic Services writes a data block to a new location on disk and leaves unused space in the former location of the data block. Block size increases because data from a data load or calculation is appended to the blocks; the blocks must therefore be written to the end of a data file. The Analytic Services Kernel merges adjacent fragments into increasingly larger fragments so that unused space is more likely to be re-used. In some cases, fragmentation cannot be reduced completely. Fragmentation is likely to occur with the following: Read/write databases that users are constantly updating with data Databases that execute calculations around the clock Databases that frequently update and recalculate dense members Data loads that are poorly designed Databases that contain a significant number of Dynamic Calc and Store members Databases that use an isolation level of uncommitted access with commit block set to zero If you experience performance slow-downs, you can check to see if there is too much fragmentation of the database, and if there is, you can take steps to reduce the fragmentation: Measuring Fragmentation Preventing or Removing Fragmentation Measuring Fragmentation You can measure fragmentation using the average clustering ratio or average fragmentation quotient statistic: Using the Average Fragmentation Quotient Using the Average Clustering Ratio Using the Average Fragmentation Quotient In ESSCMD, look at the Average Fragmentation Quotient that is returned when you execute GETDBSTATS command. Use this table to evaluate whether or not the level of fragmentation is likely to be causing performance problems: Database Size Fragmentation Quotient Threshold Small (up to 200 Mb) 60% or higher Medium (up to 2 Gb) 40% or higher Large (greater than 2Gb) 30% or higher Any quotient above the high end of the range indicates that reducing fragmentation may help performance, with the following qualifications: The reported value of the Fragmentation Quotient is more accurate when there are no other write transactions running on the database. For databases less than 50Mb using the Direct I/O access mode, the fragmentation quotient tends to be high. A high fragmentation quotient does not necessarily indicate a need to reduce fragmentation, because the free space is created in 8Mb chunks and all of it might not get used right away. Using the Average Clustering Ratio The average clustering ratio database statistic indicates the fragmentation level of the data ( .pag ) files. The maximum value, 1, indicates no fragmentation. To view the average clustering ratio for a database, use either of the following methods. Tool Topic Location Administration Services Viewing Fragmentation Statistics Essbase Administration Services Online Help ESSCMD GETDBSTATS Technical Reference Preventing or Removing Fragmentation You can prevent and remove fragmentation: To prevent fragmentation, optimize data loads by sorting load records based upon sparse dimension members. For a comprehensive discussion of optimizing data load by grouping sparse members, see Grouping Sparse Member Combinations . To remove fragmentation, perform an export of the database, delete all data in the database with CLEARDATA, and reload the export file. For discussion and instructions, see Export Backups . To remove fragmentation, force a dense restructure of the database. See Types of Database Restructuring . Enabling Windows 4 GB RAM Tuning Essbase supports Microsoft 4 GB RAM Tuning (4GT). 4GT enables users with extremely large databases to take advantage of a larger address space to improve performance. The total addressable limit of RAM on servers running Windows 2000 or Windows NT is 4 GB. By default, applications can access 2 GB, with the Windows kernel using the other 2 GB. For selected versions of Windows running on Intel architecture servers, Microsoft provides the 4GT feature. The 4GT feature increases the addressable limit for applications to 3 GB, reducing the potential RAM allocated to the Windows kernel from 2 GB to 1 GB. Essbase currently supports the 4GT feature on computers that use Intel-based processors with more than 2 GB of physical RAM, and that have either of the following versions of Windows: Windows 2000 Advanced Server Windows NT Server 4.0, Enterprise Edition Enabling the Windows 4GT feature may benefit users if the Essbase installation has both of the following characteristics: Essbase is configured to use direct I/O. Enabling 4GT on Essbase installations configured for buffered I/O is not recommended. The index and data caches are sized correctly and Essbase performance is consistently improved by increasing the data file cache, but further increases are bounded by the previous 2 GB addressability limitation. For information about setting cache values, see Optimizing Analytic Services Caches. Enabling 4GT To configure the computer where Essbase is installed to enable the 4GT feature, modify the boot.ini file by adding /3GB to the startup line for each boot partition that is defined for a Windows version that supports 4GT; for example: [boot loader] timeout=30 default=multi(0)disk(0)rdisk(0)partition(2)\\WIN2KADV [operating systems] multi(0)disk(0)rdisk(0)partition(2)\\WIN2KADV=Microsoft Windows 2000 Advanced Server /3GB multi(0)disk(0)rdisk(0)partition(2)\\WINNT=Windows NT Server Version 4.0 /3GB Note: This change to the boot.ini file is effective only if you are using Windows NT Server 4.0 Enterprise Edition or Windows 2000 Advanced Server. On standard Windows NT, although the /3GB flag relocates the kernel, applications are unable to access more than 2 GB. On a dual boot system, to ensure that the boot loader supporting the 4GT feature is installed, be sure that the last operating system you install is a version that supports the 4GT feature. Because the Windows kernel area is reduced, it is unlikely but conceivable that certain applications and workloads in certain environments may experience degraded performance. Testing your workload in your environment is recommended. For additional information about the Microsoft Windows 4GT feature, see www.microsoft.com . Finding Additional Optimization Information Using Database Settings to Customize for Maximum Performance provides general-purpose information and does not account for the wide variety of configuration possibilities. For more information about performance and server, application, or other settings, see these chapters: For information on optimizing performance for a particular function, see these chapters: Optimizing Data Loads Optimizing Calculations Optimizing with Intelligent Calculation Optimizing Reports and Other Types of Retrieval For detailed information on the Analytic Services Kernel, see the following chapters: Managing Database Settings Allocating Storage and Compressing Data Ensuring Data Integrity Optimizing Analytic Services Caches Estimating Disk and Memory Requirements  |../daprcset.htm",
    "Mining an Analytic Services Database||Data mining is the process of searching through an Analytic Services database for hidden relationships and patterns in a large amount of data. Using traditional query tools, you can answer many standard questions about your business, such as How profitable were root beer sales in New York in July? Data mining helps you to search through large amounts of data and come up with new questions, such as What will root beer sales look like in August? This chapter describes data mining and explains how to mine Analytic Services databases. Understanding Data Mining Essbase Analytic ServicesData Mining Framework Built-in Algorithms Accessing Data Mining Functionality Creating New Algorithms Understanding Data Mining Data mining tools can sift through data to come up with hidden relationships and patterns. You may find that people who bought root beer in July also bought ice cream in July. Then you can use this knowledge to create an advertising campaign around root beer floats. You can use data mining to tell you things about existing data, as in the root beer example. Such data mining is called descriptive. You can also use data mining to forecast future results based on past performance. For example, you can forecast sales for next year based on sales for this year. Such data mining is called predictive. Essbase Analytic ServicesData Mining Framework Data Mining Framework is a collection of features that enables the performance of data mining on Analytic Services databases. Data Mining Framework is licensed separately from Analytic Services. Note: Data Mining Framework does not currently operate on relational data, that is, hybrid analysis data. Data mining is also not supported currently for Unicode-mode applications. The process of mining an Analytic Services database includes the following tasks: Specify a build task. You implement a build task through a task template. The Mining Wizard, available with Administration Services, provides a build task template and steps you through the process of specifying a build task. You can also use MaxL statements and template files provided with Data Mining Framework. In the build task, you specify: The algorithm to use. The database to mine and a representative set of data. Parameters that determine how the algorithm is applied. Execute the build task to build, or train, a model. When you execute a build task, the specified algorithm is applied against the the specified set of data to generate a data mining model. During the training process, the algorithm discovers and describes the patterns and relationships in the data that can be used for prediction. Later, the trained model can use these patterns and relationships to generate new information from a different, but similarly structured, set of data. See Training the Model . Specify a test task to test the model. This is an optional task to verify the accuracy of the model you have built. You implement a test task through a task template using the Mining Wizard or MaxL statements. In the test task, you specify: The model to use. This is a model that you have built. A database and set of data to mine. Specify a set of data with known results or correlations. Execute the test task to generate test results. After training the model on one set of data, you execute the model against a different set of data with known results or correlations. You can compare the results generated by the model with the known results to determine the accuracy of the model. See Testing the Model . Specify an apply task. You implement an apply task through a task template using the Mining Wizard or MaxL statements. In the apply task, you specify: The model to use. This is a model that you have built. A database and set of data to mine Execute the apply task to generate result records. When you execute an apply task, the model is executed against the specified set of data to generate result records. Data Mining Framework writes results back to the Analytic Services cube. See Applying the Model . Query the result records. Query the result records to view the data mining results. The following sections describe the data mining process in more detail. Creating Data Mining Models The first step in building a data mining model is to understand the business situation or problem and choose the appropriate algorithm to use for analysis or prediction. Algorithms determine how you search through data. Data Mining Framework provides a set of powerful algorithms that can be used for a broad range of business applications. See Built-in Algorithms for a description of the available algorithms. The description of each algorithm provides information about the type of problem that it is best suited for. Note: Data Mining Framework also enables you to easily register and use new algorithms created by Hyperion or third-party vendors. For example, suppose you want to determine how sales of televisions, DVDs, and VCRs in the East region correspond to sales of cameras in the same region. You can use the regression algorithm to model sales of cameras as a function of sales of TVs, VCRs, and DVDs. The regression algorithm predicts the value of a dependent (target) variable based on the value of one or more independent (predictor) variables. Using an Algorithm All data mining algorithms require training, or learning. Training is the process of executing an algorithm against a representative set of data to discover and describe the patterns and relationships in the data that can be used for prediction. Once a model has been trained against a representative set of data, it can then be applied to a wider set of data to derive useful information. Learning can be either supervised or unsupervised. Supervised learning discovers patterns and relationships in the data by comparing the resulting data to a set of known data. Unsupervised learning discovers patterns and relationships in the data without comparing the data to a known set of data. The algorithm vendor determines the specific information that you must provide to use the algorithm. The regression algorithm employs supervised learning. Therefore, the model requires both input data and output data. To use an algorithm, you need to enter its settings, parameters and accessors. Settings are actually determined by the Data Mining Framework, and as such are the same for all algorithms, but they do influence the operation of the algorithm. For example, the framework provides a setting to define how missing values are treated by the algorithm. Parameters are specific to each algorithm and determine how the algorithm operates on the data. For example, the clustering algorithm provides a parameter to specify the maximum number of clusters to return. Accessors specify the input and output data for the algorithm. In a build task, supervised algorithms such as regression have two accessors, a predictor to define the independent or input data, and a target to define the dependent or expected output data. Unsupervised algorithms, such as clustering, have a predictor accessor only. Test and apply tasks generally have both predictor accessors to define the input and target accessors to define the output. Accessors consist of domains, which are typically MaxL DML expressions that define components of the accessor. For example, the predictor accessor for the regression algorithm contains the following domains: Predictor.Predictor Defines the member or member set combination that determines the predictor domain. Predictor.Sequence Defines the sequence to be traversed for the predictor variable. Sequence is generally a time dimension. Predictor.External Defines the scope of the predictor. It is optional. Predictor.Anchor Defines restrictions from additional dimensions. It is optional. The target accessor has the same set of domains as the predictor. You write MaxL DML expressions to define the predictor and target accessors. For example, consider this sample data mining problem: Given the number of TVs, DVDs, and VCRs sold during a particular period, in the East region, how many cameras were sold in the same period in the East? Restrict sales data to prior year actual sales. Using the regression algorithm, the predictor and target accessors to define the model for this problem are as follows: Predictor.Predictor [Television], [DVD], [VCR] Predictor.Sequence [Jan 1].Level.Members Predictor.External [East].Children Predictor.Anchor ([2001], [Actual], [Sales]) Target.Target [Camera] Target.Sequence [Jan 1].Level.Members Target.External [East].Children Target.Anchor ([2001], [Actual], [Sales]) Note: In this example, the target accessor is the same with regard to all the predictor attributes except the target domain ( [Camera] ). However, the domain expressions for different accessors are not required to be the same. The only requirement is that a predictor component (for example predictor.sequence ) and the corresponding target component ( target.sequence ) must be the same size. For each city in the East ( [East].Children ), the algorithm models camera sales as a function of TV, DVD, and VCR sales. The Data Mining Framework creates, under the same name, a family of results, or models; a separate result for each city in the East. Training the Model The final step of specifying a build task is to execute the algorithm against the data specified by the accessors to build or train the model. During the training process, the algorithm discovers and describes the patterns and relationships in the data that can be used for prediction. Internally, the algorithm represents the patterns and relationships it has discovered as a set of mathematical coefficients. Later, the trained model can use these patterns and relationships to generate new information from a different, but similarly structured, set of data. Note: If you cancel a data mining model while you are training it, the transaction is rolled back. Applying the Model After the model is trained, it is ready to use on a new set of data. To apply a model to a new set of data, you specify an apply task. In the apply task you specify a build model you trained and a set of accessors. Generally, the values are the same for the predictor and sequence domains for a build task and its related apply task. You change the external or anchor domain to apply the model to a different set of data. For example, you could change the external domain to specify a different region or country. Or you could use the anchor domain to specify a different year. In the apply task, the target result data is not known, but is to be predicted by the model. The apply task applies the model coefficients it generated to the new set of data and generates a set of output data. The Data Mining Framework writes the result data back to the Analytic Services cube. The apply task generates a result record that you can use to query the result data. Testing the Model Data mining models are built using known data to train the algorithm so it can be applied to a similar data set. To test a model, you create a test task. In the test task, you specify a model you have trained and a set of accessors. In addition to the predictor and target accessors, you specify test accessors that reference a known set of results. The test task compares the results of the trained model to the set of known results you specify. The test task determines if the results match within a specified range of expected error. If the results do not match, you can do any of the following: Verify the homogeneity of the known data. If the structure of the known data does not match the structure of the test data, the results will not match. Verify the integrity of the known data. Corrupt or incomplete data can cause the test model to fail. Verify the integrity of the test input data. Consider changing the stringency of the settings. At very least, a less stringent setting that returns a positive test gives you an idea of how closely the trained model compares to known data. See Creating or Modifying a Test Task in Essbase Administration Services Online Help for information about creating a test task. Viewing Data Mining Results Data Mining Framework writes mining results back to the Analytic Services cube. Data Mining Framework creates a result record, in XML format, that contains accessors that specify the location of the result data in the cube. You can view data mining results through the Data Mining node in Administration Services or by using MaxL statements. Preparing for Data Mining The one essential prerequisite for performing data mining is that you understand your data and the problem you are trying to solve. Data mining is a powerful tool and can yield new insights. However, if you already have a strong hunch about your data, then data mining can be particularly useful in confirming or denying your hunch, and giving you some additional insights and directions to follow. Before you mine an Analytic Services database, make sure that the database is loaded and calculated. Built-in Algorithms Hyperion supplies the following basic algorithms: Regression. Identifies dependencies between a specific value and other values. For example, multilinear regression can determine how the amount of money spent on advertising and payroll affects sales values. Clustering. Arranges items into groups with similar patterns. You use the clustering algorithm for unsupervised classification. The algorithm examines data and determines itself how to split the data into groups, or clusters, based on specific properties of the data. The input required to build the model consists of a collection of vectors with numeric coordinates. The algorithm organizes these vectors into clusters based on their proximity to each other. The basic assumption is that the clusters are relatively smaller than the distance between them, and, therefore, can be effectively represented by their respective centers. Hence the model consists of coordinates of center vectors. Sequential runs on the same training set may produce slightly different results due to the stochastic nature of the method. You specify the number of clusters to generate, but it is possible the algorithm will find fewer clusters than requested. Clusters can provide useful information about market segmentation and can be used with other predictive tools. For example, clusters can determine the kinds of users most likely to respond to an advertising campaign and then target just those users. Neural network. Generalizes and learns from data. For example, neural networks can be used to predict financial results. You can use the neural net algorithm for both prediction and classification. This algorithm is much more powerful and flexible than linear regression. For example, you can specify multiple targets as well multiple predictors. On the other hand, the model generated by the neural net algorithm is not as easy to interpret as that from linear regression. One use of neural nets is binary classification. A series of inputs (predictors) produces a set of results (targets) normalized to values between zero and one. For example, a set of behaviors results in values between 0 and 1, with 1 being risky and 0 being risk free. Values in between require interpretation; for example, 0.4 is the high end of safe and 0.6 is the low end of risky. Decision tree. Determines simple rules for making decisions. The algorithm results are the answers to a series of yes and no questions. A yes answer leads to one part of the tree and a no answer to another part of the tree. The end result is a yes or no answer. Decision trees are used for classification and prediction. For example, a decision tree can tell you to suggest ice cream to a particular customer because that customer is more likely to buy ice cream with root beer. Use the decision tree algorithm to organize a collection of data belonging to several different classes or types. In the build phase, you specify a set of data vectors and provide the class of each. In the apply phase, you provide a set of previously unknown vectors and the algorithm deduces their classes from the model. The algorithm constructs a series of simple tests or predicates to create a tree structure. To determine the class of a data vector, the algorithm takes the input data and traverses the tree from the root to the leaves performing a test at each branch. Association Rules. Discovers rules in a series of events. The typical application for this algorithm is market basket analysis: people who buy particular items also buy which other items. For example, the result of a market basket analysis might be that men who buy beer also buy diapers. You define support and confidence parameters for the algorithm. The algorithm selects sufficiently frequent subsets selected from a predefined set of items. On input it reads a sequence of item sets, and looks for an item set (or its subset), whose frequency in the whole sequence is greater than support level. Such item sets are broken into antecedent-consequent pairs, called rules. Rule confidence is the ratio of its item set frequency to the antecedent frequency in all the item sets. Rules with confidence greater than the given confidence level are added to the list of confident rules. Although the algorithm uses logical shortcuts during computations, thus avoiding the need to consider all the combinations of the item sets, whose number can be practically infinite, the speed with which the algorithm executes depends on the number of attributes to consider and the frequency with which they occur. Naive Bayes. Predicts class membership probabilities. Naive Bayes is a light-weight classification algorithm. It is fast, takes small memory and in a good number of applications behaves quite satisfactory, so you can use it first before going to the decision tree or fully fledged clustering schemes. The algorithm treats all the attributes of the case vector as if they were independent of each other. It uses a training sequence of vectors and the theoretical definition of the conditional probability to calculate the probabilities or likelihoods that an attribute with a certain value belongs to a case with a certain class. The model stores these probabilities. In the apply mode the case attributes are used to calculate the likelihood of the case for each class. Then a class with the maximal likelihood is assigned to the case. Accessing Data Mining Functionality Data Mining Framework is supported by the MaxL and Administration Services interfaces. MaxL provides a set of statements explicitly for data mining. With MaxL you can perform all data mining functions, including creating, training, testing, and applying a data mining model. Sample model templates for each of the algorithms are available through the Administration Services interface. A model template provides an outline of the accessors needed for that algorithm that you can fill in. It also sets some parameters required by the algorithm. Administration Services enables you to manage data mining models, templates, transformations, and results. It provides a mining wizard that steps you through the process of creating and training a build model, and creating and applying apply and test models. See Mining an Analytic Services Database in Essbase Administration Services Online Help . Creating New Algorithms You can create your own algorithms using Java and register them with Data Mining Framework. In order to be recognized by Data Mining Framework, an algorithm must implement certain interfaces and have a specific signature. These requirements are described in detail in the Algorithm Vendor's Guide shipped as part of the Data Mining Framework SDK. After a new algorithm is registered, it appears in the list of supplied algorithms and you can use the new algorithm to create build and apply tasks. Data Mining Framework reads the instructions for each parameter in the algorithm from the algorithm signature. The instructions appear in the Build and Apply Wizards in the panels where the user sets the algorithm parameters, just like the instructions for the supplied algorithms.  |../datamine.htm",
    "Working with Attributes||Attributes describe characteristics of data such as the size and color of products. Through attributes you can group and analyze members of dimensions based on their characteristics. This chapter describes how to create and manage attributes in an Analytic Server outline. Note: The information in this chapter is designed for block storage databases. Some of the information is not relevant to aggregate storage databases. For detailed information on the differences between aggregate and block storage, see Comparison of Aggregate and Block Storage. For information on creating aggregate storage applications, see Aggregate Storage Applications, Databases, and Outlines. This chapter contains the following topics: Process for Creating Attributes Understanding Attributes Understanding Attribute Dimensions Designing Attribute Dimensions Building Attribute Dimensions Setting Member Names in Attribute Dimensions Calculating Attribute Data You can find other information about attributes in relevant sections of this book. Information Needed More Information Defining attributes through dimension build Building Attribute Dimensions and Associating Attributes Using attributes in partitions Designing Partitioned Applications Creating and Maintaining Partitions Using attributes in report writer Developing Report Scripts Process for Creating Attributes When working with attributes in Outline Editor perform the following tasks: Create a new dimension. See Adding Dimensions and Members to an Outline . In the outline, position the attribute dimensions after all standard dimensions. Tag the dimension as an attribute dimension and set attribute dimension type as text, numeric, Boolean, or date. See Creating Attribute Dimensions . Add members to the attribute dimension. See Adding Dimensions and Members to an Outline . Associate a base dimension with the attribute dimension. See Understanding the Rules for Attribute Dimension Association . Associate members of the base dimension with members of the attribute dimension. See Understanding the Rules for Attribute Member Association . If necessary, set up the attribute calculations. See Calculating Attribute Data . Understanding Attributes You can use the Analytic Services attribute feature to retrieve and analyze data not only from the perspective of dimensions, but also in terms of characteristics, or attributes, of those dimensions. For example, you can analyze product profitability based on size or packaging, and you can make more effective conclusions by incorporating into the analysis market attributes such as the population size of each market region. Such an analysis could tell you that decaffeinated drinks sold in cans in small (less than 6,000,000-population) markets are less profitable than you anticipated. For more details, you can filter the analysis by specific attribute criteria, including minimum or maximum sales and profits of different products in similar market segments. Here are a few ways analysis by attribute provides depth and perspective, supporting better-informed decisions: You can select, aggregate, and report on data based on common features (attributes). By defining attributes as having a text, numeric, Boolean, or date type, you can filter (select) data using type-related functions such as AND, OR, and NOT operators and &lt;, &gt;, and = comparisons. You can use the numeric attribute type to group statistical values by attribute ranges; for example, population groupings such as &lt;500,000, 500,000-1,000,000, and &gt;1,000,000. Through the Attribute Calculations dimension automatically created by Analytic Services, you can view sums, counts, minimum or maximum values, and average values of attribute data. For example, when you enter Avg and Bottle into a spreadsheet, Analytic Services retrieves calculated values for average sales in bottles for all the column and row intersections on the sheet. You can perform calculations using numeric attribute values in calculation scripts and member formulas; for example, to determine profitability by ounce for products sized by the ounce. You can create crosstabs of attribute data for the same dimension, and you can pivot and drill down for detail data in spreadsheets. An attribute crosstab is a report or spreadsheet showing data consolidations across attributes of the same dimension. For example, the crosstab in Figure59 displays product packaging as columns and the product size in ounces as rows. At their intersections, you see the profit for each combination of package type and size. From this information, you can see which size-packaging combinations were most profitable in the Florida market. Figure 59: Crosstab Example Product Year Florida Profit Actual Bottle Can Pkg Type ========= ========= ========= 32 946 N/A 946 20 791 N/A 791 16 714 N/A 714 12 241 2,383 2,624 Ounces 2,692 2,383 5,075 Understanding Attribute Dimensions In the Sample Basic database, products have attributes that are characteristics of the products. For example, products have an attribute that describes their packaging. In the outline, you see these characteristics as two dimensions, the Products dimension, and the Pkg Type attribute dimension that is associated with it. An attribute dimension has the word Attribute next to its name in the outline. Figure60 shows part of the Sample Basic outline featuring the Product dimension and three attribute dimensions, Caffeinated, Ounces, and Pkg Type. Figure 60: Outline Showing Base and Attribute Dimensions In the outline, to the right of the Product dimension, the terms Caffeinated, Ounces, and Pkg Type show that these attribute dimensions are associated with the Product dimension. A standard dimension is any dimension that is not an attribute dimension. When an attribute dimension is associated with a standard dimension, the standard dimension is the base dimension for that attribute dimension. In the outline in Figure60 , the Product dimension is the base dimension for the Caffeinated, Ounces, and Pkg Type attribute dimensions. Note: Attribute dimensions and members are Dynamic Calc, so Analytic Services calculates attribute information at retrieval time. Attribute data is not stored in the database. Understanding Members of Attribute Dimensions Members of an attribute dimension are potential attributes of the members of the associated base dimension. After you associate a base dimension with an attribute dimension, you associate members of the base dimension with members of the associated attribute dimension. The Market dimension member Connecticut is associated with the 6000000 member of the Population attribute dimension. That makes 6000000 an attribute of Connecticut. In the outline, the information next to a base dimension member shows the attributes of that member. In Figure60 , next to product 100-10, Caffeinated:True, Ounces:12, Pkg Type:Can shows that product 100-10 has three attributes-product 100-10 has caffeine, it is sold in 12-ounce containers, and the containers are cans. Understanding the Rules for Base and Attribute Dimensions and Members There are several important rules regarding members of attribute dimensions and their base dimensions. You can tag only sparse dimensions as attribute dimensions. Before you can save an outline to the server, each attribute dimension must be associated with a standard, sparse dimension as its base dimension. Attribute dimensions must be the last dimensions in the outline. Attribute dimensions have a type setting-text, numeric, Boolean, or date. Text is the default setting. Although assigned at the dimension level, the type applies only to the level 0 members of the dimension. For more information, see Understanding Attribute Types . If you remove the attribute tag from a dimension, Analytic Services removes prefixes or suffixes from its member names. Prefixes and suffixes are not visible in the outline. For more information, see Setting Prefix and Suffix Formats for Member Names of Attribute Dimensions . A base dimension member can have many attributes, but only one attribute from each particular attribute dimension. For example, product 100-10 can have size and packaging attributes, but only one size and only one type of packaging. Analytic Services does not support attributes for Hybrid Analysis-enabled members. You can use attribute values in calculations in the following comparisons: &gt; (greater than) &gt;= (greater than or equal to) &lt; (less than) &lt;= (less than or equal to) = = (equal to) &lt;&gt; or != (not equal to) IN Understanding the Rules for Attribute Dimension Association When you associate an attribute dimension with a standard dimension, the standard dimension is known as the base dimension for that attribute dimension. An attribute dimension must be associated with a sparse standard dimension. A standard dimension can be a base dimension for more than one attribute dimension. An attribute dimension can be associated with only one base dimension. For example, you might have a Size attribute dimension with members Small, Medium, and Large. If you associate the Size attribute dimension with the Product dimension, you cannot also associate the Size attribute dimension with the Market dimension. If you also want to track size-related information for the Market dimension, you must create another attribute dimension with a different name, for example, MarketSize, and associate the MarketSize attribute dimension with the Market dimension. Understanding the Rules for Attribute Member Association When you associate a member of an attribute dimension with a member of a base dimension, follow these rules: You cannot associate multiple members from the same attribute dimension with the same base dimension member. For example, the Bottle and Can package types cannot both be associated with the product 100-30. You can associate members from different attribute dimensions with the same member of a base dimension. For example, a decaffeinated cola product (100-30) sold in 16 ounce bottles has three attributes-Caffeinated:False; Ounces:16; and Pkg Type:Bottle. After attributes are associated with base dimension members, if you cut or copy and paste base dimension members to another location in the outline, the attribute associations are lost. Analytic Services does not require that each member of a base dimension be associated with a member of an attribute dimension. All base dimension members associated with members of a particular attribute dimension must be at the same level. For example, in Figure61 , all Market dimension members that have Population attributes are at level 0. You cannot associate East, which is a level 1 member, with a Population attribute since the other members of the Market dimension that have Population attributes are level 0 members. Figure 61: Association of Attributes with the Same Level Members of the Market Dimension The level 0 members of attribute dimensions are the only members that you can associate with base dimension members. For example, in the Population attribute dimension, you can associate only level 0 members such as 3000000, 6000000, and 9000000, with members of the Market dimension. You cannot associate a level 1 member such as Small. The name of the level 0 member of an attribute dimension is the attribute value. The only members of attribute dimensions that have attribute values are level 0 members. You can use the higher-level members of attribute dimensions to select and group data. For example, you can use Small, the level 1 member of the Population attribute dimension, to retrieve sales in both the 3000000 and 6000000 population categories. Understanding Attribute Types Attribute dimensions have a text, numeric, Boolean, or date type that enables different functions for grouping, selecting, or calculating data. Although assigned at the dimension level, the attribute type applies only to level 0 members of the attribute dimension. The default attribute type is text. Text attributes enable the basic attribute member selection and attribute comparisons in calculations. When you perform such comparisons, Analytic Services compares characters. For example, the package type Bottle is less than the package type Can because B precedes C in the alphabet. In Sample Basic, Pkg Type is an example of a text attribute dimension. The names of level 0 members of numeric attribute dimensions are numeric values. You can include the names (values) of numeric attribute dimension members in calculations. For example, you can use the number of ounces specified in the Ounces attribute to calculate profit per ounce for each product. You can also associate numeric attributes with ranges of base dimension values; for example, to analyze product sales by market population groupings-states with 3,000,000 population or less in one group, states with a population between 3,000,001 and 6 million in another group, and so on. See Setting Up Member Names Representing Ranges of Values . All Boolean attribute dimensions in a database contain only two members. The member names must match the settings for the database; for example, True and False. If you have more than one Boolean attribute dimension, you must specify a prefix or suffix member name format to ensure unique member names; for example, Caffeinated_True and Caffeinated_False. For a discussion of how to change Boolean names, see Setting Boolean Attribute Member Names . You can use date attributes to specify the date format-month-day-year or day-month-year-and to sequence information accordingly. For a discussion of how to change date formats, see Changing the Member Names in Date Attribute Dimensions . You can use date attributes in calculations. For example, you can compare dates in a calculation that selects product sales from markets established since 10-12-1999. Analytic Services supports date attributes from January 1, 1970 through January 1, 2038. Comparing Attribute and Standard Dimensions In general, attribute dimensions and their members are similar to standard dimensions and members. You can provide aliases and member comments for attributes. Attribute dimensions can include hierarchies and you can name generations and levels. You can perform the same spreadsheet operations on attribute dimensions and members as you can on standard dimensions and members; for example, to analyze data from different perspectives, you can retrieve, pivot, and drill down in the spreadsheet. Table12 describes major differences between attribute and standard dimensions and their members. Table 12: Differences Between Attribute and Standard Dimensions  . Attribute Dimensions Standard Dimensions Storage Must be sparse. Their base dimensions must also be sparse. Can be dense or sparse Storage property Dynamic Calc only, therefore not stored in the database. The outline does not display this property. Can be Store Data, Dynamic Calc and Store, Dynamic Calc, Never Share, or Label Only Position in outline Must be the last dimensions in the outline Must be ahead of all attribute dimensions in the outline Partitions Cannot be defined along attribute dimensions, but you can use attributes to define a partition on a base dimension. Can be defined along standard dimensions. Formulas (onmembers) Cannot be associated Can be associated Shared members Not allowed Allowed Two-pass calculation member property Not available Available Two-pass calculation with run-time formula If a member formula contains a run-time dependent function associated with an attribute member name, and the member with the formula is tagged as two-pass, calculation skips the member and issues a warning message. Run-time dependent functions include the following: @CURRMBR, @PARENT, @PARENTVAL, @SPARENTVAL, @MDPARENTVAL, @ANCEST, @ANCESTVAL, @SANCESTVAL, and @MDANCESTVAL. Calculation is performed on standard members with run-time formulas and tagged two-pass. Two-pass, multiple dimensions: Calculation order Order of calculation of members tagged two-pass depends on order in outline. The last dimension is calculated last. Calculation result is not dependent on outline order for members tagged two-pass in more than one dimension. Two-pass calculation with no member formula Calculation skipped, warning message issued. Thus member intersection of two-pass tagged members and upper level members may return different results from calculation on standard dimensions. Available Dense dynamic calc members in non-existing stored blocks Calculation skips dense dimensions if they are on any non-existing stored block. To identify non-existing stored blocks, export the database or run query to find out whether block has any data. Available UDAs on members Not allowed Allowed Consolidations F or all members, calculated through the Attribute Calculations dimension members: Sum, Count, Min, Max, and Avg. Consolidation operation indicated by assigning the desired consolidation symbol to each member Member selection facilitated by Level 0 member typing Available types include text, numeric, Boolean, and date. All members treated as text. Associations Must be associated with a base dimension N/A Spreadsheet drill-downs List the base dimension data associated with the selected attribute. For example, drilling down on the attribute Glass displays sales for each product packaged in glass, where Product is the base dimension for the Pkg Type attribute dimension. List lower or sibling levels of detail in the standard dimensions. For example, drilling down on QTR1 displays a list of products and their sales for that quarter. Comparing Attributes and UDAs Attributes and UDAs both enable analysis based on characteristics of the data. Attributes provide much more capability than UDAs. Table13 compares them. Checkmarks indicate the feature supports the corresponding capability. Table 13: Comparing Attributes and UDAs  Capability Attributes Feature UDAs Feature Data Storage You can associate with sparse dimensions. You can associate with dense dimensions. . Data Retrieval You can group and retrieve consolidated totals by attribute or UDA value. For example, associate the value High Focus Item to various members of the Product dimension and use that term to retrieve totals and details for just those members. Simple More difficult to implement, requiring additional calculation scripts or commands You can categorize attributes in a hierarchy and retrieve consolidated totals by higher levels in the attribute hierarchy; for example, if each product has a specific size attribute such as 8, 12, 16, or 32, and the sizes are categorized as small, medium, and large. You can view the total sales of small products. More difficult to implement You can create crosstab views displaying aggregate totals of attributes associated with the same base dimension. You can show a crosstab of all values of each attribute dimension. You can only retrieve totals based on specific UDA values. You can use Boolean operators AND, OR, and NOT with attribute and UDA values to further refine a query. For example, you can select decaffeinated drinks from the 100 product group. Because attributes have a text, Boolean, date, or numeric type, you can use appropriate operators and functions to work with and display attribute data. For example, you can view sales totals of all products introduced after a specific date. . You can group numeric attributes into ranges of values and let the dimension building process automatically associate the base member with the appropriate range. For example, you can group sales in various regions based on ranges of their populations-less than 3 million, between 3 and 6 million, and so on. . Through the Attribute Calculations dimension, you can view aggregations of attribute values as sums, counts, minimums, maximums, and averages. . You can use an attribute in a calculation that defines a member. For example, you can use the weight of a product in ounces to define the profit per ounce member of the Measures dimension. . You can retrieve specific base members using attribute-related information. Powerful conditional and value-based selections Limited to text string matches only Data Conversion Based on the value of a UDA, you can change the sign of the data as it is loaded into the database. For example, you can reverse the sign of all members with the UDA Debit. . Calculation Scripts You can perform calculations on a member if its attribute or UDA value matches a specific value. For example, you can increase the price by 10% of all products with the attribute or UDA of Bottle. You can perform calculations on base members whose attribute value satisfies conditions that you specify. For example, you can calculate the Profit per Ounce of each base member. . Designing Attribute Dimensions Analytic Services provides more than one way to design attribute information into a database. Most often, defining characteristics of the data through attribute dimensions and their members is the best approach. The following sections discuss when to use attribute dimensions, when to use other features, and how to optimize performance when using attributes. Using Attribute Dimensions Using Alternative Design Approaches Optimizing Outline Performance Using Attribute Dimensions For the most flexibility and functionality, use attribute dimensions to define attribute data. Using attribute dimensions provides the following features: Sophisticated, flexible data retrieval You can view attribute data only when you want to, you can create meaningful summaries through crosstabs, and using type-based comparisons, you can selectively view just the data you want to see. Additional calculation functionality Not only can you perform calculations on the names of members of attribute dimensions to define members of standard dimensions, you can also access five different types of consolidations of attribute data-sums, counts, averages, minimums, and maximums. Economy and simplicity Because attribute dimensions are sparse, Dynamic Calc, they are not stored as data. Compared to using shared members, outlines using attribute dimensions contain fewer members and are easier to read. For more information about attribute features, see Understanding Attributes . Using Alternative Design Approaches In some situations, consider one of the following approaches: UDAs. Although UDAs provide less flexibility than attributes, you can use them to group and retrieve data based on its characteristics. See Comparing Attributes and UDAs . Shared members. For example, to include a seasonal analysis in the Year dimension, repeat the months as shared members under the appropriate season; Winter: Jan (shared member), Feb (shared member), and so on. A major disadvantage of using shared members is that the outline becomes very large if the categories repeat a lot of members. Standard dimensions and members. Additional standard dimensions provide flexibility, but they add storage requirements and complexity to a database. For guidelines on evaluating the impact of additional dimensions, see Analyzing and Planning . Table14 describes situations where you might consider one of these alternative approaches for managing attribute data in a database. Table 14: Considering Alternatives to Attribute Dimensions  Situation Alternative to Consider Analyze attributes of dense dimensions UDAs or shared members. Perform batch calculation of data Shared members or members of separate, standard dimensions. Define the name of a member of an attribute dimension as a value as that results from a formula Shared members or members of separate, standard dimensions Define attributes that vary over time Members of separate, standard dimensions. For example, to track product maintenance costs over a period of time, the age of the product at the time of maintenance is important. However, using the attribute feature you could associate only one age with the product. You need multiple members in a separate dimension for each time period that you want to track. Minimize retrieval time with large numbers of base-dimension members Batch calculation with shared members or members of separate, standard dimensions. Optimizing Outline Performance Outline layout and content can affect attribute calculation and query performance. For general outline design guidelines, see Designing an Outline to Optimize Performance . To optimize attribute query performance, consider the following design tips: Ensure that attribute dimensions are the only sparse Dynamic Calc dimensions in the outline. Locate sparse dimensions after dense dimensions in the outline. Place the most-queried dimensions at the beginning of the sparse dimensions and attribute dimensions at the end of the outline. In most situations, the base dimensions are the most queried dimensions. For information on optimizing calculation of outlines containing attributes, see Optimizing Calculation and Retrieval Performance . Building Attribute Dimensions To build an attribute dimension, first tag the dimension as attribute and assign the dimension a type. Then associate the attribute dimension with a base dimension. Finally, associate each level 0 member of the attribute dimension with a member of the associated base dimension. To build an attribute dimension, see Defining Attributes in the Essbase Administration Services Online Help . To view the dimension, attribute value and attribute type of a specific attribute member, use any of the following methods: Tool Topic Location Administration Services Viewing Attribute Information in Outlines Essbase Administration Services Online Help MaxL query database Technical Reference ESSCMD GETATTRINFO Technical Reference Setting Member Names in Attribute Dimensions All member names in an outline must be unique. When you use the attribute feature, Analytic Services establishes some default member names. These default names might duplicate names that already exist in the outline. You can change these system-defined names for the database and can establish other settings for members of attribute dimensions in the database. The outline does not show the full attribute names. You can see and use the full attribute names anywhere you select members, such as when you define partitions or select information to be retrieved. Define the member name settings before you define or build the attribute dimensions. Changing the settings after the attribute dimensions and members are defined could result in invalid member names. The following sections describe how to work with the names of members of attribute dimensions: Setting Prefix and Suffix Formats for Member Names of Attribute Dimensions Setting Boolean Attribute Member Names Changing the Member Names in Date Attribute Dimensions Setting Up Member Names Representing Ranges of Values Changing the Member Names of the Attribute Calculations Dimension Note: If you partition on outlines containing attribute dimensions, the name format settings of members described in this section must be identical in the source and target outlines. Setting Prefix and Suffix Formats for Member Names of Attribute Dimensions The names of members of Boolean, date, and numeric attribute dimensions are values. It is possible to encounter duplicate attribute values in different attribute dimensions. Boolean example. If you have more than one Boolean attribute dimension in an outline, the two members of each of those dimensions have the same names, by default, True and False. Date example. If you have more than one date attribute dimension, some member names in both dimensions could be the same. For example, the date that a store opens in a certain market could be the same as the date a product was introduced. Numeric example. 12 can be the attribute value for the size of a product and 12 could also be the value for the number of packing units for a product. This example results in two members with the same name-12. Because Analytic Services does not allow duplicate member names, you can define unique names by attaching a prefix or suffix to member names in Boolean, date, and numeric attribute dimensions in the outline. For example, by setting member names of attribute dimensions to include the dimension name as the suffix, attached by an underscore, the member value 12 in the Ounces attribute dimension assumes the unique, full attribute member name, 12_Ounces. By default, Analytic Services assumes that no prefix or suffix is attached to the names of members of attribute dimensions. The convention that you select applies to the level 0 member names of all numeric, Boolean, and date attribute dimensions in the outline. You can define aliases for these names if you wish to display shorter names in retrievals. To define prefix and suffix formats, see Defining a Prefix or Suffix Format for Members of Attribute Dimensions in the Essbase Administration Services Online Help . Setting Boolean Attribute Member Names When you set the dimension type of an attribute dimension as Boolean, Analytic Services automatically creates two level 0 members with the names specified for the Boolean attribute settings. The initial Boolean member names in a database are set as True and False. If you want to change these default names, for example, to Yes and No, you must define the member names for Boolean attribute dimensions before you create any Boolean attribute dimensions in the database. Before you can set an attribute dimension type as Boolean, you must delete all existing members in the dimension. To define the database setting for the names of members of Boolean attribute dimensions, see Setting Member Names for Boolean Attribute Dimensions in the Essbase Administration Services Online Help . Changing the Member Names in Date Attribute Dimensions You can change the format of members of date attribute dimensions. For example, you can use the following date formats: mm-dd-yyyy displays the month before the day; for example, October 18, 1999 is displayed as 10-18-1999. dd-mm-yyyy displays the day before the month; for example, October 18, 1999 is displayed as 18-10-1999. If you change the date member name format, the names of existing members of date attribute dimensions may be invalid. For example, if the 10-18-1999 member exists and you change the format to dd-mm-yyyy, outline verification will find this member invalid. If you change the date format, you must rebuild the date attribute dimensions. To change the names of the members in date attribute dimensions, see Setting the Member Name Format of Date Attribute Dimensions in the Essbase Administration Services Online Help . Setting Up Member Names Representing Ranges of Values Members of numeric attribute dimensions can represent single numeric values or ranges of values: Single value example: the member 12 in the Ounces attribute dimension represents the single numeric value 12; you associate this attribute with all 12-ounce products. The outline includes a separate member for each size; for example, 16, 20, and 32. Range of values example: the Population attribute dimension: Figure 62: Population Attribute Dimension and Members In this outline, the members of the Population attribute dimension represent ranges of population values in the associated Market dimension. The 3000000 member represents populations from zero through 3,000,000; the 6000000 member represents populations from 3,000,001 through 6,000,000; and so on. Each range includes values greater than the name of the preceding member up to and including the member value itself. A setting for the outline establishes that each numeric member represents the top of its range. You can also define this outline setting so that members of numeric attribute dimensions are the bottoms of the ranges that they represent. For example, if numeric members are set to define the bottoms of the ranges, the 3000000 member represents populations from 3,000,000 through 5,999,999 and the 6000000 member represents populations from 6,000,000 through 8,999,999. When you build the base dimension, Analytic Services automatically associates members of the base dimension with the appropriate attribute range. For example, if numeric members represent the tops of ranges, Analytic Services automatically associates the Connecticut market, with a population of 3,269,858, with the 6000000 member of the Population attribute dimension. In the dimension build rules file, specify the size of the range for each member of the numeric attribute dimension. In the above example, each attribute represents a range of 3,000,000. To set up ranges in numeric attribute dimensions, see Assigning Member Names to Ranges of Values in the Essbase Administration Services Online Help . Changing the Member Names of the Attribute Calculations Dimension To avoid duplicating names in an outline, you may need to change the name of the Attribute Calculations dimension or its members. For more information about this dimension, see Understanding the Attribute Calculations Dimension . Regardless of the name that you use for a member, its function remains the same. For example, the second (Count) member always counts, no matter what you name it. To change the names of the members in the Attribute Calculations dimension, see Changing Member Names of Attribute Calculations Dimensions in the Essbase Administration Services Online Help . Calculating Attribute Data Analytic Services calculates attribute data dynamically at retrieval time, using members from a system-defined dimension created specifically by Analytic Services. Using this dimension, you can apply different calculation functions, such as a sum or an average, to the same attribute. You can also perform specific calculations on members of attribute dimensions; for example, to determine profitability by ounce for products sized by the ounce. The following information assumes that you understand the concepts of attribute dimensions and Analytic Services calculations, including dynamic calculations. This section includes the following sections: Understanding the Attribute Calculations Dimension Understanding the Default Attribute Calculations Members Viewing an Attribute Calculation Example Accessing Attribute Calculations Members Using the Spreadsheet Optimizing Calculation and Retrieval Performance Using Attributes in Calculation Formulas Understanding Attribute Calculation and Shared Members Understanding the Attribute Calculations Dimension When you create the first attribute dimension in the outline, Analytic Services also creates the Attribute Calculations dimension comprising five members with the default names Sum, Count, Min (minimum), Max (maximum), and Avg (average). You can use these members in spreadsheets or in reports to dynamically calculate and report on attribute data, such as the average yearly sales of 12-ounce bottles of cola in the West. The Attribute Calculations dimension is not visible in the outline. You can see it wherever you select dimension members, such as in the Spreadsheet Add-in. The attribute calculation dimension has the following properties: System-defined. When you create the first attribute dimension in an application, Analytic Services creates the Attribute Calculations dimension and its members (Sum, Count, Min, Max, and Avg). Each member represents a type of calculation to be performed for attributes. For a discussion of calculation types, see Understanding the Default Attribute Calculations Members . Label only. Like all label only dimensions, the Attribute Calculations dimension shares the value of its first child, Sum. For more information on the label only dimension property, see Member Storage Properties . Dynamic Calc. The data in the Attribute Calculations dimension is calculated when a user requests it and is then discarded. You cannot store calculated attribute data in a database. For a comprehensive discussion on dynamic calculations, see Dynamically Calculating Data Values . Not displayed in Outline Editor. The Attribute Calculations dimension is not displayed in Outline Editor. Members from this dimension can be viewed in spreadsheets and in reports. There is no consolidation along attribute dimensions. You cannot tag members from attribute dimensions with consolidation symbols (for example, + or -) or with member formulas in order to calculate attribute data. As Dynamic Calc members, attribute calculations do not affect the batch calculation in terms of time or calculation order. To calculate attribute data at retrieval time, Analytic Services performs the following tasks: Finds the base-dimension members that are associated with the specified attribute-dimension members present in the current query Dynamically calculates the sum, count, minimum, maximum, or average for the attribute-member combination for the current query Displays the results in the spreadsheet or report Discards the calculated values-that is, the values are not stored in the database Note: Analytic Services excludes #MISSING values when calculating attribute data. For example, as shown in Figure63 , a spreadsheet user specifies two members of attribute dimensions (Ounces_16 and Bottle) and an Attribute Calculations member (Avg) in a spreadsheet report. Upon retrieval, Analytic Services dynamically calculates the average sales values of all products associated with these attributes for the current member combination (Actual-&gt;Sales-&gt;East-&gt;Qtr1): Figure 63: Retrieving an Attribute Calculations Member For information on accessing calculated attribute data, see Accessing Attribute Calculations Members Using the Spreadsheet . Understanding the Default Attribute Calculations Members The Attribute Calculations dimension contains five members used to calculate and report attribute data. These members are as follows: Sum calculates a sum, or total, of the values for a member with an attribute or combination of attributes. Supports non-additive consolidations such as multiplication, and two-pass measures. Note: The Sum member totals members based on their consolidation property or formula. For example, the Sum member uses the following formula to consolidate the profit percentages of 12-ounce products: This calculation is not the sum of all percentages for all base-dimension members with the Ounces attribute 12. The default calculation for attributes is Sum. If a spreadsheet user specifies a member of an attribute dimension in a spreadsheet but does not specify a member of the Attribute Calculations dimension, Analytic Services retrieves the sum for the specified attribute or combination of attributes. For example, in the spreadsheet view in Figure64 , the value in cell C4 represents the sum of sales values for the attributes Ounces_16 and Bottle for the current member combination (Actual-&gt;Sales-&gt;East-&gt;Qtr1), even though the Sum member is not displayed in the sheet. Figure 64: Retrieving the Default Attribute Calculations Member Count calculates the number of members with the specified attribute or combination of attributes, for which a data value exists. Count includes only those members that have data blocks in existence. To calculate a count of all members with certain attributes, regardless of whether or not they have data values, use the @COUNT function in combination with the @ATTRIBUTE function. For more information, see the Technical Reference . Avg calculates a mathematical mean, or average, of the non-missing values for an specified attribute or combination of attributes (Sum divided by Count). Min calculates the minimum data value for a specified attribute or combination of attributes. Max calculates the maximum data value for a specified attribute or combination of attributes. Note: Each of these calculations excludes #MISSING values. You can change these default member names, subject to the same naming conventions as standard members. For a discussion of Attribute Calculations member names, see Changing the Member Names of the Attribute Calculations Dimension . Viewing an Attribute Calculation Example As an example of how Analytic Services calculates attribute data, consider the following yearly sales data for the East: Table 15: Sample Attribute Data Base-Dimension Member Associated Attributes Sales Value for Attribute-Member Combination Cola Ounces_12, Can 23205 Diet Cola Ounces_12, Can 3068 Diet Cream Ounces_12, Can 1074 Grape Ounces_32, Bottle 6398 Orange Ounces_32, Bottle 3183 Strawberry Ounces_32, Bottle 5664 A spreadsheet report showing calculated attribute data might look like the following illustration: Figure 65: Sample Spreadsheet with Attribute Data As shown in the figure above, you can retrieve multiple Attribute Calculations members for attributes. For example, you can calculate Sum, Count, Avg, Min, and Max for 32-ounce bottles and cans. Accessing Attribute Calculations Members Using the Spreadsheet You can access members from the Attribute Calculations dimension in Spreadsheet Add-in. From the spreadsheet, users can view Attribute Calculations dimension members using any of the following methods: Entering members directly into a sheet Selecting members from the Query Designer Entering members as an EssCell parameter For more information on accessing calculated attribute data from the spreadsheet, see the Essbase Spreadsheet Add-in User's Guide . Optimizing Calculation and Retrieval Performance To optimize attribute calculation and retrieval performance, consider the following considerations: The calculation order for attribute calculations is the same as the order for dynamic calculations. For an outline of calculation order, see Calculation Order for Dynamic Calculation . Since Analytic Services calculates attribute data dynamically at retrieval time, attribute calculations do not affect the performance of the overall (batch) database calculation. Tagging base-dimension members as Dynamic Calc may increase retrieval time. When a query includes the Sum member and an attribute-dimension member whose associated base-member is tagged as two-pass, retrieval time may be slow. To maximize attribute retrieval performance, use any of the following techniques: Configure the outline using the tips in Optimizing Outline Performance . Drill down to the lowest level of base dimensions before retrieving data. For example, in Spreadsheet Add-in, turn on the Navigate Without Data feature, drill down to the lowest level of the base dimensions included in the report, and then retrieve data. When the members of a base dimension are associated with several attribute dimensions, consider grouping the members of the base dimension according to their attributes. For example, in the Sample Basic database, you could group all 8-ounce products. Grouping members by attribute may decrease retrieval time. Using Attributes in Calculation Formulas In addition to using the Attribute Calculations dimension to calculate attribute data, you can also use calculation formulas on members of standard or base dimensions to perform specific calculations on members of attribute dimensions; for example, to determine profitability by ounce for products sized by the ounce. You cannot associate formulas with members of attribute dimensions. Note: Some restrictions apply when using attributes in formulas associated with two-pass members. For details, see the rows about two-pass calculations in Table12 . You can use the following functions to perform specific calculations on attributes: Type of Calculation Function to Use Generate a list of all base members with a specific attribute. For example, you can generate a list of members that have the Bottle attribute, and then increase the price for those members. @ATTRIBUTE Return the value of the level 0 attribute member that is associated with the base member being calculated. From a numeric or date attribute dimension (using @ATTRIBUTEVAL) From a Boolean attribute dimension (using @ATTRIBUTEBVAL) From a text attribute dimension (using @ATTRIBUTESVAL) For example, you can return the numeric value of a size attribute (for example, 12 for the member 12 under Ounces) for the base member being calculated (for example, Cola). @ATTRIBUTEVAL @ATTRIBUTEBVAL @ATTRIBUTESVAL Convert a date string to numbers for a calculation. For example, you can use @TODATE in combination with the @ATTRIBUTEVAL function to increase overhead costs for stores opened after a certain date. @TODATE Generate a list of all base dimension members associated with attributes that satisfy the conditions that you specify. For example, you can generate a list of products that are greater than or equal to 20 ounces, and then increase the price for those products. @WITHATTR Note: For syntax information and examples for these functions, see the Technical Reference . For an additional example using @ATTRIBUTEVAL in a formula, see Calculating an Attribute Formula . Understanding Attribute Calculation and Shared Members Attribute calculations start at level 0 and stop at the first stored member. Therefore, if your outline has placed a real member in between two shared members in a an outline hierarchy, the calculation results may not include the higher shared member. For example: Member 1 (stored) Member A (stored) Member 2 (shared) Member B (stored) Member 1 (shared member whose stored member is Member 1 above) In this example, when an attribute calculation is performed, the calculation starts with level 0 Member 2, and stops when it encounters the first stored member, Member A. Therefore, Member 1 would not be included in the calculation. Avoid mixing shared and stored members to avoid unexpected results with attribute calculation. For this example, if Member 2 were not shared, or Member 1 did not have a corresponding shared member elsewhere in the outline, calculation results would be as expected.  |../dattrib.htm",
    "Backing Up and Restoring Data||This chapter describes how to back up a database and lists the Analytic Services files that are essential to restoring a database from backups. This chapter includes the following sections: Database Backups Restoration of Data from Backups Changing Frequency of Backup File Comparisons Essential Database Files If you are migrating from a previous release of Analytic Services, see the Essbase Analytic Services Installation Guide . Database Backups A key part of a database maintenance routine includes regular backups of Analytic Services data. It is important to integrate regular database backups into production server maintenance. The frequency of backups is dependent upon the volatility of the database and server environment, as well as upon the demand for quick database restores in the event of server crashes. There are two methods of backing up a database: Preparing the database for file system backup Exporting, which makes a copy of data in a text format This section tells you which files should be backed up regularly and describes each backup method. Files to Back Up You should regularly back up the server, application, and database files listed in Table65 : Table 65: Files to Back Up File Location ess n .ind \\essbase\\app \\ appname \\ dbname ess n .pag \\essbase\\app \\ appname \\ dbname dbname .esm \\essbase\\app \\ appname \\ dbname dbname .tct \\essbase\\app \\ appname \\ dbname dbname .ind \\essbase\\app \\ appname \\ dbname dbname .app \\essbase\\app dbname .db \\essbase\\app \\ appname \\ dbname x .lro \\essbase\\app \\ appname \\ dbname dbname .otl \\essbase\\app \\ appname \\ dbname essbase.sec \\essbase\\bin essbase.bak \\essbase\\bin essbase.cfg \\essbase\\bin Database object files such as: .otl .csc .rul .rep .eqd and .sel \\essbase\\app \\ appname \\ dbname ESSCMD or MaxL scripts No defined storage location It is important to back up all .ind and .pag files related to a database because a single database can have multiple .ind and .pag files. Remember, the Agent should be shut down before the essbase.sec file is backed up. For a full list and description of all Analytic Services files, see Understanding How Analytic Services Files Are Stored . File System Backup A common method of creating database backups is by doing a file system backup of the Analytic Server. You can perform the backup using the file system backup software of your choice. You can back up specific directories or files, or you can back up the entire Analytic Services directory structure. Be sure to back up data on every disk volume Analytic Services uses. For information about data storage on multiple volumes, see Specifying Disk Volumes . In most cases, backups occur after Analytic Services applications and databases, as well as the Agent, are shut down. If any Analytic Services databases must be up and running at the time of backup, follow these steps: Place the database in read-only mode. See Placing a Database in Read-Only Mode . Perform the backup. See Performing a Backup . Return the database to read-write mode. See Returning a Database to Read-Write Mode . Placing a Database in Read-Only Mode You can prepare a database for backup when the database must remain running during the backup process. Placing the database in read-only (or archive) mode protects the database from updates during the backup process. After you perform the backup using the third-party backup utility of your choice, you then return the database to read-write mode. To place a database in read-only mode, use either of the following methods: Tool Instructions For more information MaxL alter database begin archive Technical Reference ESSCMD BEGINARCHIVE Technical Reference Note: If you try to cancel the BEGINARCHIVE ESSCMD command or the alter database begin archive MaxL statement and you receive a can't cancel message, the system is most likely in the final stage of writing items to the drive and has reached the point where the operation cannot be cancelled. The begin-archive utility performs the following tasks: Commits any modified data to disk. Switches the database to read-only mode. Reopens the database files in shared, read-only mode. Creates a file containing a list of files that need to be backed up. By default, the file is called archive.lst . This file is stored in the ARBORPATH \\app\\appname\\dbname directory. If a user tries to modify data during the backup process, an error message informs the user that data is in read-only mode for backup. Begin-archive and end-archive utilities do not perform the backup; they simply protect the database during the backup process. Caution: If you back up data without using a begin-archive utility, make sure that all Analytic Services applications are closed and that all users are logged off during the backup process. Otherwise, you risk corrupting the database. Performing a Backup After putting the database in read-only mode, you are ready to perform the backup. To back up data, use a third-party backup utility to back up the files listed in archive.lst and the files listed in Files to Back Up . Alternatively, you can back up the entire Analytic Services directory structure. For information on restoring files from backup, see Restoration of Data from Backups . Returning a Database to Read-Write Mode After performing the backup, return the database to read-write mode. To return the database to read-write mode, use either of the following methods: Tool Topic Location MaxL alter database end archive Technical Reference ESSCMD ENDARCHIVE Technical Reference The end-archive utility performs the following tasks: Returns the database to read-write mode. Re-opens database files in exclusive, read-write mode. Note: You must use the end-archive utility to put the database back into read-write mode, even if you shut down and restart the database. The end-archive utility does not restart the database. Export Backups You can back up data by exporting it. Exporting data copies it to a text file that you specify; it does not compress data. The export file contains data only and does not include control, outline, or security information. You might consider exporting data for the following reasons: To transfer data across platforms To back up only a certain portion of the data; for example, level 0 blocks To create an exported file in text format, rather than binary format Note: You can export subsets of data by creating reports. For a discussion and examples of the process, see Exporting Data Using Report Scripts . Understanding the Advantages and Disadvantages of Exporting Data Using export to back up data provides the following advantages: You can use the resulting text files to load data from the source database into databases on other platforms. When loading an export file into a database, it is important that the database outline contains all the members found within the export file. If not, the load will fail. Also, if the outline changes between the time that the export file is created and reloaded (and the new outline contains all the members found within the export file), the load time might be significantly higher than if the outlines were identical. During an export, data integrity is verified because every block is checked to confirm whether corresponding page and index files match. You can reduce fragmentation in a database by exporting data into a text file, clearing all data from the database, and reloading the text file. You can export a database in column format from Administration Services or MaxL. Then, you can use a rules file to load the column-formatted file. Using column format is helpful when you need to manipulate the export file. Using export to back up data provides the following disadvantages: Because dynamic calculations are not executed at the time of the export, only stored data and data from previously calculated Dynamic Calc And Store members are included in the export. At the time of a database export, Analytic Services users cannot write to the database. Users receive an error message if they try to write to the database during an export. After an export has started, users can do read operations. Exports of large databases require considerable amounts of time, time during which users can only read the data. Exporting Data To export data, use either of the following methods: Tool Instructions For More Information Administration Services Exporting Databases Essbase Administration Services Online Help Report Writer Use a Report Writer script to export selected data. Exporting Data Using Report Scripts ESSCMD EXPORT or PAREXPORT Technical Reference MaxL export data Technical Reference Note: To improve export performance, you can export data in parallel to a specified number of files. All methods require the same basic information: The amount of data to export: All data Level 0 blocks only (blocks containing only level 0 sparse member combinations. Note that these blocks may contain data for upper level dense dimension members.) Data from input blocks only (blocks containing data from a previous data load or spreadsheet Lock &amp; Send) Whether to export data in a columnar or non-columnar format To facilitate loading the exported data into a relational database, export the data in columns. In each row, the columnar format displays a member name from every dimension. Names can be repeated from row to row. The columnar format provides a structure to the exported data, so that it can be used for further data processing by applications other than Essbase tools. In non-columnar format, sparse members identifying a data block are included only once for the block. Because the export file in non-columnar format is smaller than in columnar format, reloading a file in non-columnar format is faster. The export data file names Exporting Files Larger Than 2 GB Some file management systems do not support text files larger than 2 GB. On any operating system, if Analytic Services anticipates that an export file exceeds 2 GB, it creates two or more export files, as needed. When Analytic Services creates multiple export files, it uses the requested file name for the main file. An underscore and a sequential cardinal number are appended to the names of the additional files, starting with _1. For example, if the requested file name is expJan.txt and the exported data would exceed 4 GB, Analytic Services creates three files, naming them expJan.txt , expJan_1.txt , and expJan_2.txt . Exported data files can be reloaded in any sequence. Reloading Exported Data To reload exported data, use any of the following methods: Tool Topic Location Administration Services Performing a Data Load or Dimension Build Essbase Administration Services Online Help ESSCMD IMPORT Technical Reference MaxL import data Technical Reference When you reload data that has been exported, Analytic Services marks the data as input data. If you reload data exported from level 0 blocks or input blocks, you must recalculate the database after reloading. When you recalculate the database, Analytic Services recalculates every data block. If you export all data in a database and then reload, Analytic Services marks all blocks in the database as input blocks. Consequently, if you try to clear data, no data is cleared because the database contains no non-input blocks. When you reload data that has been exported, Analytic Services also marks the data blocks as dirty. If you had calculated the database prior to exporting it, to save time during the next calculation, you should set the status of the blocks as clean. If you had not calculated the database prior to exporting it, you do not need to set the status of the blocks as clean. To clean the status of the blocks in a database after exporting all data and reloading, you can run the following calculation script: Set ClearUpdateStatus Only; Calc All; Restoration of Data from Backups To restore a database, replace the files on disk with the corresponding files from backup. See Files to Back Up for a list of files that should be backed up on a regular basis. The application should be stopped, unless you are restoring from an export file. In that case, ensure the application is not accepting client connections. Changing Frequency of Backup File Comparisons Essbase now compares the security backup file essbase.bak to the security file essbase.sec at specified intervals instead of only when Analytic Server starts. To change the frequency of these backup file comparisons, use either of the following methods: Tool Instructions For more information Administration Services Enter the time interval in the Check for inactivity every option of the Security tab when you edit Analytic Server properties. Essbase Administration Services Online Help MaxL alter system sync security_backup Technical Reference Note: You can manually update the security backup file at any time using Administration Services. See Updating the Security Backup File in Essbase Administration Services Online Help . Review these facts before changing the interval value: In Administration Services, the same check box manages how often the security backup file is checked against the security file and how often user inactivity is checked. By default, the value is five minutes. Five minutes is the recommended setting to ensure that the security backup file is checked frequently enough to capture security changes. Five minutes is also the recommended value for the inactivity check. If you set the value to zero, the inactivity check is disabled and the essbase.bak is compared to essbase.sec every five minutes (and, as always, updated if necessary). Enter a larger value if your security file does not need to be updated frequently. Enter a smaller value if performance is not an issue. Essbase always updates the backup file if it does not match the security file when the two files are compared, regardless of which tool is used to trigger the comparison. The backup file is updated only if a difference exists between the security file essbase.sec and the security backup file essbase.bak . Caution: If Essbase stops running unexpectedly for any reason, such as a freeze or crash, or as the result of terminating a process, do not restart Analytic Server until you copy the backup file essbase.bak to the security file essbase.sec . If you do not perform the copy first, when Analytic Server starts, Essbase notes that essbase.sec is corrupt, creates an empty security file and copies it to essbase.bak , thus destroying the backup of your security information. Essential Database Files These files are all key components of an Analytic Services database: Table 66: Essential Database Files  File Description ess n .pag Analytic Services data file ess n .ind Analytic Services index file dbname .esm Analytic Services Kernel file that contains control information used for database recovery dbname .tct Transaction control table dbname .ind Free fragment file for data and index free fragments dbname .otl Outline file, which does not store data but does store all metadata for a database and defines how data is stored If there is a problem with any one of these files, the entire database becomes corrupted. The database must then be restored from backups or reloaded from exports (see Database Backups .) There have been cases in which database files have become corrupted. In such situations, the database is not able to start up on Analytic Server. Therefore, no data can be reloaded to restore the database. In these cases, the only way to restore the database is to delete all the following files: ess n .pag ess n .ind dbname .esm dbname .tct dbname .ind After the files are deleted, restart the database and reload from data files or from export files created prior to the corruption.  |../dbackup.htm",
    "Database Administrator's Guide||A tree for site navigation opens here if you enable JavaScript in your browser. Hyperion Documentation Survey &copy; 1996-2004 Hyperion Solutions Corporation. All rights reserved.  |../dbag_htmTOC.htm",
    "Database Administrator's Guide||Essbase &REG Analytic Services Database Administrator's Guide Update Contents Previous Next Print ? Information Map Summary of Contents The following list provides links to the main topics in the Database Administrator's Guide: Preface Introducing Hyperion Essbase Understanding Multidimensional Databases Quick Start for Implementing Analytic Services Basic Architectural Elements Case Study: Designing aSingle-Server, Multidimensional Database About Essbase Administration Services Creating Applications and Databases Creating and Changing Database Outlines Setting Dimension and Member Properties Working with Attributes Linking Objects to Analytic Services Data Designing and Building Currency Conversion Applications Designing Partitioned Applications Creating and Maintaining Partitions Accessing Relational Data with Hybrid Analysis Understanding Data Loading and Dimension Building Creating Rules Files Using a Rules File to Perform Operations on Records, Fields, and Data Performing and Debugging Data Loads or Dimension Builds Understanding Advanced Dimension Building Concepts Calculating Analytic Services Databases Developing Formulas Reviewing Examples of Formulas Defining Calculation Order Dynamically Calculating Data Values Calculating Time Series Data Developing Calculation Scripts Reviewing Examples of Calculation Scripts Developing Custom-Defined Calculation Macros Developing Custom-Defined Calculation Functions Understanding Report Script Basics Developing Report Scripts Mining an Analytic Services Database Copying Data Subsets and Exporting Data to Other Programs Writing MDX Queries Managing Security for Users and Applications Controlling Access to Database Cells Security Examples Analytic Services Implementation of Unicode Administering Unicode-Mode Applications Running Analytic Servers, Applications, and Databases Managing Applications and Databases Monitoring Data, Applications, and Databases Managing Database Settings Allocating Storage and Compressing Data Ensuring Data Integrity Backing Up and Restoring Data Using MaxL Data Definition Language Monitoring Performance Improving Analytic Services Performance Optimizing Analytic Services Caches Optimizing Database Restructuring Optimizing Data Loads Optimizing with Intelligent Calculation Optimizing Calculations Optimizing Reports and Other Types of Retrieval Comparison of Aggregate and Block Storage Aggregate Storage Applications, Databases, and Outlines Loading, Calculating, and Retrieving Aggregate Storage Data Managing Aggregate Storage Applications and Databases Limits Handling Errors and Troubleshooting Analytic Services Estimating Disk and Memory Requirements Using ESSCMD Glossary  |../dba_html.htm",
    "Defining Calculation Order||This chapter describes the order in which Analytic Services calculates a block storage database. You should understand the concepts of data blocks and of sparse and dense dimensions before using this information. For a review of this information, see Sparse and Dense Dimensions . You should also understand the use of levels and generations. For a review of this information, see Generations and Levels . If you use dynamic calculations, see Understanding How Dynamic Calculation Changes Calculation Order for information on the calculation order for the dynamically calculated values. Calculation order does not apply to aggregate storage databases. This chapter includes these sections: Data Storage in Data Blocks Member Calculation Order Block Calculation Order Data Block Renumbering Cell Calculation Order Calculation Passes Calculation of Shared Members Data Storage in Data Blocks Analytic Services stores data values in data blocks. Analytic Services creates a data block for each unique combination of sparse dimension members (providing that at least one data value exists for the combination). Each data block contains all the dense dimension member values for its unique combination of sparse dimension members. In the Sample Basic database, the Year, Measures, and Scenario dimensions are dense. The Product and Market dimensions are sparse. Figure 178: Dimensions from the Sample Basic Database Note: Sample Basic also contains five attribute dimensions. These dimensions are sparse, Dynamic Calc, meaning that attribute data is not stored in the database. For a comprehensive discussion of attributes, see Working with Attributes . Analytic Services creates a data block for each unique combination of members in the Product and Market dimensions (providing that at least one data value exists for the combination). For example, it creates one data block for the combination of 100-10, New York. This data block contains all the Year, Measures, and Scenario values for 100-10, New York. Figure 179: Product and Market Dimensions from the Sample Basic Database In Analytic Services, member combinations are denoted by the cross-dimensional operator. The symbol for the cross-dimensional operator is -&gt; (a hyphen followed by a greater than symbol). So 100-10, New York is written 100-10 -&gt; New York. You can categorize data blocks as follows: Input. These blocks are created by loading data to cells in a block. Input blocks can be created for (1) sparse, level 0 member combinations or (2) sparse, upper level member combinations, when at least one of the sparse members is a parent level member. Input blocks can be level 0 or upper level blocks. Noninput. These blocks are created through calculations. For example, in Sample Basic, the East -&gt; Cola block is created during a sparse calculation process (that is, the block did not exist before calculation). Level 0. These blocks are created for sparse member combinations when all of the sparse members are level 0 members. For example, in Sample Basic, New York -&gt; Cola is a level 0 block because New York and Cola are level 0 members of their respective sparse dimensions. Level 0 blocks can be input or noninput blocks; for example, a level 0 noninput block is created during an allocation process, where data is loaded at a parent level and then allocated down to level 0. Upper level. These blocks are created for sparse member combinations when at least one of the sparse members is a parent level member. Upper level blocks can be input or noninput blocks. For more information on levels and generations, see Generations and Levels . For information on how Analytic Services stores data in data blocks, see Data Blocks and the Index System . Member Calculation Order Analytic Services calculates a database at the data block level, bringing one or more blocks into memory and calculating the required values within the block. Analytic Services calculates the blocks in order, according to their block numbers. The database outline tells Analytic Services how to order the blocks. Within each block, Analytic Services calculates the values in order according to the hierarchy in the database outline. Therefore, overall, Analytic Services calculates a database based on the database outline. When you perform a default calculation (CALC ALL) on a database, Analytic Services calculates the dimensions in this order: If both a dimension tagged as accounts and a dimension tagged as time exist, and if formulas are applied to members on the accounts dimension, Analytic Services calculates as follows: The dimension tagged as accounts The dimension tagged as time Other dense dimensions (in the order they are displayed in the database outline) Other sparse dimensions (in the order they are displayed in the database outline) Otherwise, Analytic Services calculates in this order: Dense dimensions (in the order they display in the database outline) Sparse dimensions (in the order they display in the database outline) Note: Attribute dimensions, which are not included in the database consolidation, do not affect calculation order. For a comprehensive discussion of attribute dimensions, see Working with Attributes . In the Sample Basic database, the dimensions are calculated in this order: Measures, Year, Scenario, Product, and Market. You can override the default order by using a calculation script. For a comprehensive discussion of how to develop and use calculation scripts, see Developing Calculation Scripts. Understanding the Effects of Member Relationships The order of calculation within each dimension depends on the relationships between members in the database outline. Within each branch of a dimension, level 0 values are calculated first followed by their level 1, parent value. Then the level 0 values of the next branch are calculated followed by their level 1, parent value. The calculation continues in this way until all levels are calculated. Figure180 shows the Year dimension from the Sample Basic database. The calculation order is shown on the left. This example assumes that the parent members are not tagged as Dynamic Calc. For a comprehensive discussion of dynamic calculation, see Dynamically Calculating Data Values. Figure 180: Year Dimension from the Sample Basic Database Jan is the first member in the first branch. Jan has no formula so it is not calculated. The same applies to Feb and Mar, the other two members in the branch. Analytic Services calculates Qtr1 by consolidating Jan, Feb, and Mar. In this example, these members are added. Analytic Services then calculates the Qtr2 through Qtr4 branches in the same way. Finally, Analytic Services calculates the Year member by consolidating the values of Qtr1 through Qtr4. Again, in this example, these members are added. Determining Member Consolidation You can choose how Analytic Services consolidates members by applying any calculation operator (+, -, /, *, %, ~) to the members in the database outline. If an accounts member has a time balance tag (First, Last, or Average), Analytic Services consolidates it accordingly. For information on time balance calculations, see Calculating First, Last, and Average Values . If a parent member has a label only tag, Analytic Services does not calculate the parent from its children. If a member has a ~ tag, Analytic Services does not consolidate the member up to its parent. Note: If you use dynamic calculations, Analytic Services may use a different calculation order. For information on the calculation order for dynamically calculated values, see Calculation Order for Dynamic Calculation . Ordering Dimensions in the Database Outline To ensure the required calculation results, consider the calculation order of the dimensions in the database outline if you do either of these tasks: Use calculation operators to divide (/), multiply (*), or calculate percentages (%) for members in the database outline. Place formulas on members in the database outline. You do not need to consider calculation order if you use only calculation operators to add (+) and subtract (-) members in the database outline and you do not use formulas in the outline. Placing Formulas on Members in the Database Outline If you place formulas on members in the database outline, consider the calculation order of the dimensions. A formula that is attached to a member on one dimension may be overwritten by a subsequent calculation on another dimension. For example, the Sample Basic database has a Measures dimension, tagged as accounts, and a Year dimension, tagged as time. Measures is calculated first, and Year second. If you attach a formula to Margin on the Measures dimension, Analytic Services calculates the formula when it calculates the Measures dimension. Analytic Services then overwrites the formula when it consolidates the Year dimension. For detailed examples of cell calculation order, see Cell Calculation Order . Using the Calculation Operators *, /, and % If you use calculation operators to multiply (*), divide (/ ), and calculate percentages (%) for members in the database outline, consider the calculation order of the dimensions. The required calculated values may be overwritten by a subsequent calculation on another dimension. For example, the Sample Basic database has a Measures dimension, tagged as accounts, and a Year dimension, tagged as time. Measures is calculated first, and Year second. If you multiply members on the Measures dimension, the calculated results may be overwritten when Analytic Services consolidates values on the Year dimension. For detailed examples of cell calculation order, see Cell Calculation Order . When you use a multiplication (*), division (/ ), or percentage (%) operator to consolidate members, carefully order the members in the branch to achieve the required result. Figure 181: Calculation Operators in the Database Outline In the above example, assume that the user wants to divide the total of Child 2 and Child 3 by Child 1. However, if Child 1 is the first member, Analytic Services starts with Child 1, taking the value of Parent 1 (currently #MISSING) and dividing it by Child 1. The result is #MISSING. Analytic Services then adds Child 2 and Child 3. Obviously, this result is not the required one. To calculate the correct result, make Child 1 the last member in the branch. For more information on #MISSING values, see Consolidating #MISSING Values . You can apply a formula to a member on the database outline to achieve the same result. However, it is far more efficient to use these calculation operators on members as in the above example. Avoiding Forward Calculation References To obtain the calculation results you expect, ensure that the outline does not contain forward calculation references. Forward calculation references occur when the value of a calculating member is dependent on a member that Analytic Services has not yet calculated. In these cases, Analytic Services may not produce the required calculation results. For example, consider this Product dimension: Figure 182: Example Product Dimension This Product dimension has three forward calculation references. Two shared members and one non-shared member have forward calculation references: Figure 183: Example Product Dimension Showing Forward Calculation References In Outline Editor, when you verify the outline, Analytic Services identifies shared members with forward calculation references. Verifying the outline does not identify non-shared members that have forward calculation references. You can save and use an outline containing forward calculation references. To verify the outline, see Verifying Outlines in the Essbase Administration Services Online Help . Consider the five members under Diet. The members P100-20, P300-20, and P500-20 have forward calculation references: P100-20 (+) (Shared Member): Analytic Services calculates the shared member P100-20 before it calculates the real member P100-20. Because the real member P100-20 has children, Analytic Services needs to calculate the real member by adding its children before it can accurately calculate the shared member P100-20. P300-20 (+) (Shared Member): Analytic Services calculates the shared member P300-20 before it calculates the real member P300-20. Because the real member P300-20 has a formula, Analytic Services needs to calculate the real member before it can accurately calculate the shared member P300-20. P500-20 (+) (P200-20 + P300-20): The formula applied to P500-20 references members that Analytic Services has not yet calculated. One referenced member, P300-20, has its own formula, and Analytic Services needs to calculate P300-20 before it can accurately calculate P500-20. The members P200-20 and P400-20 calculate correctly, as they do not have forward calculation references. P200-20 (+) (Shared Member): P200-20 is not a forward calculation reference, even though Analytic Services calculates the shared member P200-20 before it calculates the real member P200-20. The real member P200-20 has no calculation dependencies (no children and no formula). Therefore Analytic Services does not need to calculate the real member before the shared member. Analytic Services simply takes the value of the real member. P400-20 (+) (P200-10 * 2): P400-20 is not a forward calculation reference, even though the formula that is applied to P400-20 references a member that Analytic Services has not yet calculated. The member referenced in the formula does not itself have calculation dependencies. P200-10 is the only member in the formula, and P200-10 does not itself have children or a formula. Analytic Services accurately calculates P400-20. To get accurate calculation results for P100-20, P300-20, and P500-20, change the order of members in the outline. By placing the Diet shared members after the Regular members, you ensure that Analytic Services calculates the members in the required order. Figure 184: Changed Product Dimension Without Forward Calculation References Now Analytic Services calculates as follows: The real member P100-20 before it calculates the shared member P100-20. So, P100-20 no longer has a forward calculation reference. The real member P300-20 before the shared member P300-20. So, P300-20 no longer has a forward calculation reference. The referenced member with a formula, P300-20, before the member P500-20. So, P500-20 no longer has a forward calculation reference. Block Calculation Order Analytic Services calculates blocks in the order in which the blocks are numbered. Analytic Services takes the first sparse dimension in a database outline as a starting point. It defines the sparse member combinations from this first dimension. In the Sample Basic database, Product is the first sparse dimension in the database outline. Figure 185: Dimensions in the Sample Basic Database Note: The attribute dimensions in the Sample Basic outline (not shown in the figure above), are not included in the database consolidation and do not affect block calculation order. For a comprehensive discussion of attribute dimensions, see Working with Attributes . Product has 19 members (excluding the shared members, for which Analytic Services does not create data blocks). Therefore, the first 19 data blocks in the database are numbered according to the calculation order of members in the Product dimension. Figure 186: Product Dimension from the Sample Basic Database The other sparse dimension is Market. The first 19 data blocks contain the first member to be calculated in the Market dimension, which is New York. This table shows the sparse member combinations for the first 5 of these 19 data blocks. Block # Product Member Market Member 0 Cola (100-10) New York 1 Diet Cola (100-20) New York 2 Caffeine Free Cola (100-30) New York 3 Colas (100) New York 4 Old Fashioned (200-10) New York The next member in the Market dimension is Massachusetts. Analytic Services creates the next 19 data blocks for sparse combinations of each Product member and Massachusetts. This table shows the sparse member combinations for the block numbers 19 through 23. Block # Product Member Market Member 19 Cola (100-10) Massachusetts 20 Diet Cola (100-20) Massachusetts 21 Caffeine Free Cola (100-30) Massachusetts 22 Colas (100) Massachusetts 23 Old Fashioned (200-10) Massachusetts Analytic Services continues until blocks have been created for all combinations of sparse dimension members for which at least one data value exists. Analytic Services creates a data block only if at least one value exists for the block. For example, if no data values exist for Old Fashioned Root Beer (200-10) in Massachusetts, then Analytic Services does not create a data block for 200-10 -&gt; Massachusetts. However, Analytic Services does reserve the appropriate block number for 200-10 -&gt; Massachusetts in case data is loaded for that member combination in the future. When you run a default calculation (CALC ALL) on a database, each block is processed in order, according to its block number. If you have Intelligent Calculation turned on and if the block does not need to be calculated, then Analytic Services skips the block and moves on to the next block. For a comprehensive discussion of how intelligent calculation is used to optimize performance, see Optimizing with Intelligent Calculation . Data Block Renumbering Analytic Services renumbers the data blocks when you make any of these changes: Move a sparse dimension Add a sparse dimension Change a dense dimension to a sparse dimension Move any member in a sparse dimension Delete any member in a sparse dimension Add a member to a sparse dimension Cell Calculation Order Each data block contains all the dense dimension member values for its unique combination of sparse dimension members. Each data value is contained in a cell of the data block. The order in which Analytic Services calculates the cells within each block depends on how you have configured the database. How you have configured the database defines the member calculation order of dense dimension members within each block . It also defines the calculation order of blocks that represent sparse dimension members. Use these sections to understand cell calculation order in more detail: Cell Calculation Order: Example 1 Cell Calculation Order: Example 2 Cell Calculation Order: Example 3 Cell Calculation Order: Example 4 Cell Calculation Order for Formulas on a Dense Dimension Cell Calculation Order: Example 1 Consider the simplest case in which both of these conditions are true: No dimensions have time or accounts tags. The setting for consolidating #MISSING values is turned on. For an explanation of how and why #MISSING values are consolidated, see Consolidating #MISSING Values . Market and Year are both dense dimensions. The table shows a subset of the cells in a data block. Data values have been loaded into the input cells. Analytic Services calculates the shaded cells. The numbers in bold show the calculation order for these cells. The cell with multiple consolidation paths is darkly shaded. Year -&gt; Market New York Massachusetts East Jan 112345.00 68754.00 3 Feb 135788.00 75643.00 4 Mar 112234.00 93456.00 5 Qtr1 1 2 6 As described in Member Calculation Order , Analytic Services calculates dense dimensions in the order that they display in the database outline. Assuming that the Year dimension is displayed before the Market dimension in the database outline, the Year dimension is calculated before the Market dimension. The cells are calculated in this order: Qtr1 -&gt; New York Qtr1 -&gt; Massachusetts Jan -&gt; East Feb -&gt; East Mar -&gt; East Qtr1 -&gt; East Qtr1 -&gt; East has multiple consolidation paths. It can be consolidation:missing values:effects on calculation order;consolidated on Market or on Year. When consolidated on Market, it is an consolidation of Qtr1 -&gt; New York and Qtr1 -&gt; Massachusetts. When consolidated on Year, it is an consolidation of Jan -&gt; East, Feb -&gt; East, and Mar -&gt; East. Analytic Services knows that Qtr1 -&gt; East has multiple consolidation paths. Therefore, it calculates Qtr1 -&gt; East only once and uses the consolidation path of the dimension calculated last. In the above example, this dimension is Market. The results are shown in this table: Year/Market New York Massachusetts East Jan 112345.00 68754.00 181099.00 Feb 135788.00 75643.00 211431.00 Mar 112234.00 93456.00 205690.00 Qtr1 360367.00 237853.00 598220.00 Note: Qtr1 -&gt; East has been calculated only once by consolidating the values for Qtr1. From the calculation order, you can see that if you place a member formula on Qtr1 in the database outline, Analytic Services ignores it when calculating Qtr1 -&gt; East. If you place a member formula on East in the database outline, the formula is calculated when Analytic Services consolidates Qtr1 -&gt; East on the Market consolidation path. If required, you can use a calculation script to calculate the dimensions in the order you choose. For a comprehensive discussion of how to develop and use calculation scripts, see Developing Calculation Scripts. Cell Calculation Order: Example 2 Consider a second case in which both of these conditions are true: No dimensions have time or accounts tags. The setting for consolidating #MISSING values is turned off (the default). For more information, see Consolidating #MISSING Values . Market and Year are both dense dimensions. The table shows a subset of the cells in a data block. Data values have been loaded into the input cells. Analytic Services calculates the shaded cells. The numbers in bold show the calculation order for these cells. The cell with multiple consolidation paths is darkly shaded. Year -&gt; Market New York Massachusetts East Jan 112345.00 68754.00 4 Feb 135788.00 75643.00 5 Mar 112234.00 93456.00 6 Qtr1 1 2 3/7 As described in Member Calculation Order , Analytic Services calculates dense dimensions in the order they are defined in the database outline. Assuming the Year dimension is positioned before the Market dimension in the database outline, the Year dimension is calculated before the Market dimension. The cells are calculated in this order: Qtr1 -&gt; New York Qtr1 -&gt; Massachusetts Qtr1 -&gt; East Jan -&gt; East Feb -&gt; East Mar -&gt; East Qtr1 -&gt; East In this case Qtr1 -&gt; East is calculated on both the Year and Market consolidation paths. First, it is calculated as an consolidation of Qtr1 -&gt; New York and Qtr1 -&gt; Massachusetts. Second, it is calculated as an consolidation of Jan -&gt; East, Feb -&gt; East, and Mar -&gt; East. The results are identical to the previous case. However, Qtr1 -&gt; East has been calculated twice. This fact is significant when you need to load data at parent levels. For an example in which data is loaded at the parent level, see Cell Calculation Order: Example 3 . Year/Market New York Massachusetts East Jan 112345.00 68754.00 181099.00 Feb 135788.00 75643.00 211431.00 Mar 112234.00 93456.00 205690.00 Qtr1 360367.00 237853.00 598220.00 From the calculation order, you can see that if you place a member formula on Qtr1 in the database outline, its result is overwritten when Analytic Services consolidates Qtr1 -&gt; East on the Market consolidation path. If you place a member formula on East in the database outline, the result is retained because the Market consolidation path is calculated last. Cell Calculation Order: Example 3 Consider the previous case in which both of these conditions are true: No dimensions have time or accounts tags. The setting for consolidating #MISSING values is turned off (the default). For an explanation of how and why #MISSING values are consolidated, see Consolidating #MISSING Values . Data values have been loaded at a parent levels. Market and Year are both dense dimensions. The table shows a subset of the cells in a data block. Data values have been loaded into cells at the parent level. Year -&gt; Market New York Massachusetts East Jan #MISSING #MISSING 181099.00 Feb #MISSING #MISSING 211431.00 Mar #MISSING #MISSING 205690.00 Qtr1 #MISSING #MISSING &#160; As described in Member Calculation Order , Analytic Services calculates dense dimensions in the order that they are defined in the database outline. Assuming the Year dimension is positioned before the Market dimension in the database outline, the Year dimension is calculated before the Market dimension. The cells are calculated in the same order as in Example 2. Qtr1 -&gt; East is calculated on both the Year and Market consolidation paths. Because the setting for consolidating #MISSING values is turned off, Analytic Services does not consolidate the #MISSING values. Thus, the data that is loaded at parent levels is not overwritten by the #MISSING values below it. However, if any of the child data values were not #MISSING, these values are consolidated and overwrite the parent values. For example, if Jan -&gt; New York contains 50000.00, this value overwrites the values loaded at parent levels. Analytic Services first correctly calculates the Qtr1 -&gt; East cell by consolidating Jan-&gt; East, Feb -&gt; East, and Mar -&gt; East. Second, it calculates on the Market consolidation path. However, it does not consolidate the #MISSING values in Qtr1-&gt; New York and Qtr1 -&gt; Massachusetts and so the value in Qtr1 -&gt; East is not overwritten. This table shows the results: Year/Market New York Massachusetts East Jan #MISSING #MISSING 181099.00 Feb #MISSING #MISSING 211431.00 Mar #MISSING #MISSING 205690.00 Qtr1 #MISSING #MISSING 598220.00 Analytic Services needs to calculate the Qtr1 -&gt; East cell twice in order to ensure that a value is calculated for the cell. If Qtr1 -&gt; East is calculated according to only the last consolidation path, the result is #MISSING, which is not the required result. Cell Calculation Order: Example 4 Consider a case in which all of these conditions are true: The Year dimension is tagged as time. The Measures dimension is tagged as accounts. The setting for consolidating #MISSING values is turned off (the default). For an example of how and why #MISSING values are consolidated, see Consolidating #MISSING Values . Figure187 shows the Profit branch of the Measures dimension in the Sample Basic database. This example assumes that Total Expenses is not a Dynamic Calc member. For more information on Dynamic Calc members, see Dynamically Calculating Data Values. Figure 187: Profit Branch of the Measures Dimension in the Sample Basic Database This table shows a subset of the cells in a data block. Data values have been loaded into the input cells. Analytic Services calculates the shaded cells. The numbers in bold show the calculation order for these cells. Cells with multiple consolidation paths are darkly shaded. The Marketing, Payroll, and Misc Expenses values have been loaded at the Qtr1, parent level. Measures/Year Jan Feb Mar Qtr1 Sales 31538 32069 32213 13 COGS 14160 14307 14410 14  Margin 1 4 7 10/15 Marketing #MISSING #MISSING #MISSING 15839 Payroll #MISSING #MISSING #MISSING 12168 Misc #MISSING #MISSING #MISSING 233 Total Expenses 2 5 8 11/16 Profit 3 6 9 12/17 As described in Member Calculation Order , Analytic Services calculates a dimension tagged as accounts first, followed by a dimension tagged as time. Therefore, in the above example, Measures is calculated before Year. Three cells have multiple consolidation paths: Margin -&gt; Qtr1 Total Expenses -&gt; Qtr1 Profit -&gt; Qtr1 Because the setting for consolidating #MISSING values is turned off, Analytic Services does not consolidate the #MISSING values. Thus, any data that is loaded at parent levels is not overwritten by the #MISSING values and Analytic Services calculates the three cells with multiple consolidation paths twice. The results are shown in this table. Measures -&gt; Year Jan Feb Mar Qtr1 Sales 31538 32069 32213 95820 COGS 14160 14307 14410 42877  Margin 17378 17762 17803 52943 Marketing #MISSING #MISSING #MISSING 15839 Payroll #MISSING #MISSING #MISSING 12168 Misc #MISSING #MISSING #MISSING 233 Total Expenses &#160; &#160; &#160; 28240 Profit 17378 17762 17803 52943 From the calculation order, you can see that if you place a member formula on, for example, Margin in the database outline, its result is overwritten by the consolidation on Qtr1. Cell Calculation Order for Formulas on a Dense Dimension The cell calculation order within a data block is not affected by formulas on members. When Analytic Services encounters a formula in a data block, it locks any other required data blocks, calculates the formula, and proceeds with the data block calculation. When placing a formula on a dense dimension member, carefully consider the cell calculation order. As described in the examples above, the dimension calculated last overwrites previous cell calculations for cells with multiple consolidation paths. If required, you can use a calculation script to change the order in which the dimensions are calculated. For a comprehensive discussion of how to develop and use calculation scripts, see Developing Calculation Scripts. For a comprehensive discussion of how to develop and use formulas, see Developing Formulas. Calculation Passes Whenever possible, Analytic Services calculates a database in one calculation pass through the database. Thus, it reads each of the required data blocks into memory only once, performing all relevant calculations on the data block and saving it. However, in some situations, Analytic Services needs to perform more than one calculation pass through a database. On subsequent calculation passes, Analytic Services brings data blocks back into memory, performs further calculations on them, and saves them again. When you perform a default, full calculation of a database (CALC ALL), Analytic Services attempts to calculate the database in one calculation pass. If you have dimensions that are tagged as accounts or time, Analytic Services may have to do more than one calculation pass through the database. This table shows the number of calculation passes Analytic Services performs if you have dimensions that are tagged as time or accounts, and you have at least one formula on the accounts dimension. Dimension Tagged As: Calculation Passes During each calculation pass, Analytic Services calculates based on: Accounts Time Dense or Sparse None 1 All dimensions Dense Dense 1 All dimensions Dense Sparse 2 Pass 1: Accounts and time dimensions Pass 2: Other dimensions Sparse Sparse 2 Pass 1: Accounts and time dimensions Pass 2: Other dimensions Sparse Dense 2 Pass 1: Accounts dimension Pass 2: Other dimensions If you are using formulas that are tagged as Two-Pass, Analytic Services may need to do an extra calculation pass to calculate these formulas. For a comprehensive discussion of two-pass calculations, see Using Two-Pass Calculation . When you use a calculation script to calculate a database, the number of calculation passes Analytic Services needs to perform depends upon the calculation script. For a discussion of single pass and multiple pass calculations, see Calculation Passes and Understanding Multiple-Pass Calculations . For information on grouping formulas and calculations, see Grouping Formulas and Calculations . When you calculate a database, Analytic Services automatically displays the calculation order of the dimensions for each pass through the database and tells you how many times Analytic Services has cycled through the database during the calculation. Analytic Services displays this information in the ESSCMD window and in the application log. To display the application log, see Viewing the Analytic Server and Application Logs . For each data block, Analytic Services decides whether to do a dense or a sparse calculation. The type of calculation it chooses depends on the type of values within the data block. When you run a default calculation (CALC ALL) on a database, each block is processed in order, according to its block number. Analytic Services calculates the blocks using this procedure: If you have Intelligent Calculation turned on and if the block does not need to be calculated (if it is marked as clean ), then Analytic Services skips the block and moves on to the next block. For a comprehensive discussion of intelligent calculation, see Optimizing with Intelligent Calculation . If the block needs recalculating, Analytic Services checks to see if the block is a level 0, an input, or an upper level block. For definitions of level 0, input, and upper level blocks, see Data Storage in Data Blocks . If the block is a level 0 block or an input block, Analytic Services performs a dense calculation on the block. Each cell in the block is calculated. For detailed examples of how Analytic Services calculates cells, see Cell Calculation Order . If the block is an upper level block, Analytic Services either consolidates the values or performs a sparse calculation on the data block. The sparse member combination of each upper level block contains at least one parent member. Analytic Services consolidates or calculates the block based on the parent member's dimension. For example, if the upper level block is for Product -&gt; Florida from the Sample Basic database, then Analytic Services chooses the Product dimension. If the sparse member combination for the block has more than one parent member, Analytic Services chooses the last dimension in the calculation order that includes a parent member. For example, if the block is for Product -&gt; East and you perform a default calculation on the Sample Basic database, Analytic Services chooses the Market dimension, which contains East. The Market dimension is last in the default calculation order because it is placed after the Product dimension in the database outline. For an explanation of the order in which Analytic Services calculates members, see Member Calculation Order . Based on the chosen sparse dimension, Analytic Services either consolidates the values or performs a sparse calculation on the data block: If a formula is applied to the data block member on the chosen sparse dimension, Analytic Services performs a formula calculation on the sparse dimension. Analytic Services evaluates each cell in the data block. The formula affects only the member on the sparse dimension, so overall calculation performance is not significantly affected. If the chosen sparse dimension is a default consolidation, Analytic Services consolidates the values, taking the values of the previously calculated child data blocks. Calculation of Shared Members Shared members are those that share data values with other members. For example, in the Sample Basic database, Diet Cola, Diet Root Beer, and Diet Cream are consolidated under two different parents. They are consolidated under Diet. They are also consolidated under their individual product types-Colas, Root Beer, and Cream Soda. Figure 188: Calculating Shared Members The members under the Diet parent are shared members. For a comprehensive discussion of shared members, see Understanding Shared Members . A calculation on a shared member is a calculation on the real member. If you use the FIX command to calculate a subset of a database and the subset includes a shared member, Analytic Services calculates the real member.  |../dcacaord.htm",
    "Reviewing Examples of Calculation Scripts||The examples in this chapter illustrate different types of calculation scripts, which you may want to adapt for your own use. This chapter includes the following examples: Calculating Variance Calculating Database Subsets Loading New Budget Values Calculating Product Share and Market Share Values Allocating Costs Across Products Allocating Values Within or Across Dimensions Goal Seeking Using the LOOP Command Forecasting Future Values Note: Since you do not use calculation scripts with aggregate storage databases, the information in this chapter is not relevant them. For examples that use the Intelligent Calculation commands SET UPDATECALC and SET CLEARUPDATESTATUS in calculation scripts, see Reviewing Examples That Use SET CLEARUPDATESTATUS and Reviewing Examples and Solutions for Multiple-Pass Calculations . Calculating Variance The Sample Basic database includes a calculation of the percentage of variance between Budget and Actual values. Figure 201: Calculating Variance and Variance % During a default calculation of the Sample Basic database, Analytic Services aggregates the values on the Market and Product dimensions. Percentage values do not aggregate correctly. Therefore, the Variance % formula needs to be recalculated after the default calculation. In the Sample Basic outline, Variance % is tagged as a Dynamic Calc, two-pass member. Thus, Analytic Services dynamically calculates Variance % values when they are retrieved. The dynamic calculation overwrites the incorrect values with the correctly calculated percentages. If you choose not to tag Variance % as a Dynamic Calc, two-pass member, use the following calculation script to recalculate Variance %. For a comprehensive discussion of Dynamic Calc members, see Dynamically Calculating Data Values. See Using Two-Pass Calculation for information about calculation of two-pass members. Assuming that Intelligent Calculation is turned on (the default), the following calculation script performs a default calculation and then recalculates the formula on Variance %: CALC ALL; SET UPDATECALC OFF; SET CLEARUPDATESTATUS AFTER; Variance %; Analytic Services performs the following actions: Analytic Services uses the CALC ALL command to perform a default calculation of the database. Note: Alternatively, run a default calculation of the database outline without using a calculation script. The SET UPDATECALC OFF command turns off Intelligent Calculation. The CLEARUPDATESTATUS AFTER command tells Analytic Services to mark the calculated blocks calculated by the variance formula of the calculation script as clean, even though the variance calculation is a partial calculation of the database (by default, data blocks are marked as clean only after a full calculation of the database). Analytic Services cycles through the database calculating the formula for Variance %. For information on calculating statistical variance, see the Technical Reference . For information on using a calculation script for two-pass calculations, see Choosing Two-Pass Calculation Tag or Calculation Script . For a comprehensive discussion on developing and using formulas to calculate a database, see Developing Formulas. Calculating Database Subsets In this example, based on the Sample Basic database, the Marketing managers of the regions East, West, South, and Central need to calculate their respective areas of the database. Figure 202: Market Dimension from the Sample Basic Database The marketing manager of the region East uses the following calculation script to calculate the data values for East:. Notice how @DESCENDENTS(East) is used to limit the calculations to the Eastern region. /* Calculate the Budget data values for the descendants of East */ FIX(Budget, @DESCENDANTS(East)) CALC DIM(Year, Measures, Product); ENDFIX /* Consolidate East */ FIX(Budget) @DESCENDANTS(East); ENDFIX The script calculates the Year, Measures, and Product dimensions for each child of East. Analytic Services performs the following actions: Analytic Services fixes on the Budget values of the descendants of East. The Year, Measures, and Product dimensions are calculated in one pass of the database for all Budget values of the descendants of East. Analytic Services fixes on the Budget values for all members on the other dimensions. Analytic Services aggregates the descendants of East and places the result in East. Loading New Budget Values This example calculates the Budget values of the Sample Basic database and then recalculates the Variance and Variance % members of the database: /* Calculate all Budget values */ FIX(Budget) CALC DIM(Year, Product, Market, Measures); ENDFIX /* Recalculate the Variance and Variance % formulas, which require two passes */ Variance; Variance %; Analytic Services performs the following actions: Analytic Services fixes on the Budget values. Analytic Services calculates all Budget values. The CALC DIM command is used to calculate all the dimensions except for the Scenario dimension, which contains Budget. Analytic Services calculates the formula applied to Variance in the database outline. Analytic Services calculates the formula applied to Variance % in the database outline. Calculating Product Share and Market Share Values This example, based on the Sample Basic database, calculates product share and market share values for each market and each product. The product and market share values are calculated as follows: Each member as a percentage of the total Each member as a percentage of its parent Assume that you add four members to the Measures dimension-Market Share, Product Share, Market %, and Product %. /* First consolidate the Sales values to ensure that they are accurate */ FIX(Sales) CALC DIM(Year, Market, Product); ENDFIX /* Calculate each market as a percentage of the total market for each product */ Market Share = Sales % Sales -&gt; Market; /* Calculate each product as a percentage of the total product for each market */ Product Share = Sales % Sales -&gt; Product; /* Calculate each market as a percentage of its parent for each product */ Market % = Sales % @PARENTVAL(Market, Sales); /* Calculate each product as a percentage its parent for each market */ Product % = Sales % @PARENTVAL(Product, Sales); Analytic Services performs the following actions: Analytic Services fixes on the Sales values and consolidates all the Sales values. The CALC DIM command is used to calculate the Year, Market, and Product dimensions. The Measures dimension contains the Sales member and therefore is not consolidated. The Scenario dimension is label only and therefore does not need to be consolidated. Analytic Services cycles through the database and calculates Market Share. It takes the Sales value for each product in each market for each month. It calculates this Sales value as a percentage of total Sales in all markets for each product (Sales -&gt; Market). Analytic Services calculates Product Share. It takes the Sales value for each product in each market for each month. It calculates this Sales value as a percentage of total Sales of all products in each market (Sales -&gt; Product). Analytic Services calculates Market %. It takes the Sales value for each product in each market for each month. It calculates this Sales value as a percentage of the Sales value of the parent of the current member on the Market dimension. It uses the @PARENTVAL function to obtain the Sales value of the parent on the Market dimension. Analytic Services calculates Market %. It takes the Sales value for each product in each market for each month. It calculates this Sales value as a percentage of the Sales value of the parent of the current member on the Product dimension. It uses the @PARENTVAL function to obtain the Sales value of the parent on the Product dimension. Allocating Costs Across Products The following example is based on the Sample Basic database. It allocates overhead costs to each product in each market for each month. The overhead costs are allocated based on each product's Sales value as a percentage of the total Sales for all products. Assume that you add two members to the Measures dimension-OH_Costs for the allocated overhead costs and OH_TotalCost for the total overhead costs. /* Declare a temporary array called ALLOCQ based on the Year dimension */ ARRAY ALLOCQ[Year]; /*Turn the Aggregate Missing Values setting off. If this is your system default, omit this line */ SET AGGMISSG OFF; /* Allocate the overhead costs for Actual values */ FIX(Actual) OH_Costs (ALLOCQ=Sales/Sales-&gt;Product; OH_Costs = OH_TotalCost-&gt;Product * ALLOCQ;); /* Calculate and consolidate the Measures dimension */ CALC DIM(Measures); ENDFIX Analytic Services performs these calculations: Analytic Services creates a one-dimensional array called ALLOCQ. The size of ALLOCQ is based on the number of members in the Year dimension. Analytic Services uses ALLOCQ to store the value of Sales as a percentage of total Sales temporarily for each member combination. The SET AGGMISSG OFF; command means that #MISSING values are not aggregated to their parents. Data values stored at parent levels are not overwritten. If this is your system default, you can omit this line. For information on setting the default for aggregating #MISSING values, see Consolidating #MISSING Values . Analytic Services fixes on the Actual values. Analytic Services cycles through the member combinations for Actual and calculates OH_Costs. It then takes the Sales value for each product in each market for each month. It calculates this Sales value as a percentage of total Sales for all products in each market (Sales -&gt; Product). It places the result in ALLOCQ. It then takes the total overhead costs for all products (OH_TotalCost -&gt; Product) and multiplies it by the value it has just placed in ALLOCQ. It places the result in OH_Costs. Notice that both of the equations are enclosed in parentheses ( ) and associated with the OH_Costs member, OH_Costs (equation1; equation2;). Analytic Services calculates and consolidates the Measures dimension. Allocating Values Within or Across Dimensions Using the @ALLOCATE and @MDALLOCATE functions, you can allocate values to members in the same dimension or to members in multiple dimensions. Allocating Within a Dimension The following example uses the @ALLOCATE function to allocate budgeted total expenses across expense categories for two products. The budgeted total expenses are allocated based on the actual values for the prior year. The following example is based on the Sample Basic database. Assume that you have made the following changes to Sample Basic: Added a child, Lease, under Total Expenses in the Measures dimension Added a child, PY Actual, to the Scenario dimension Removed the Dynamic Calc tag from the Total Expenses member Figure 203: Modified Measures and Scenario Dimensions from the Sample Basic Database For this example, assume that data values of 1000 and 2000 are loaded into Budget-&gt; Total Expenses for Colas and Root Beer, respectively. These values need to be allocated to each expense category, evenly spreading the values based on the non-missing children of Total Expenses from PY Actual. The allocated values need to be rounded to the nearest dollar. This calculation script defines the allocation: /* Allocate budgeted total expenses based on prior year */ /* Allocate budgeted total expenses based on prior year */ FIX(Total Expenses) Budget = @ALLOCATE(Budget-&gt;Total Expenses, @CHILDREN(Total Expenses),PY Actual,, spread,SKIPMISSING,roundAmt,0,errorsToHigh) ENDFIX This table shows the results: . Budget PY Actual Colas Marketing 334* 150 Payroll #MI #MI Lease 333 200 Misc 333 100 Total Expenses 1000 450 Root Beer Marketing 500 300 Payroll 500 200 Lease 500 200 Misc 500 400 Total Expenses 2000 1100 * Rounding errors are added to this value. See step5 for more information. Analytic Services cycles through the database, performing the following calculations: Analytic Services fixes on the children of Total Expenses. Using a FIX statement with @ALLOCATE may improve calculation performance. For Budget -&gt; Colas -&gt; Marketing, Analytic Services divides 1 by the count of non-missing values for each expense category in PY Actual -&gt; Colas for each month. In this case, 1 is divided by 3, because there are 3 non-missing expense values for Budget -&gt; Colas. Analytic Services takes the value from step 2 (.333), multiplies it by the value for Budget -&gt; Colas -&gt; Total Expenses (1000), and then rounds to the nearest dollar (333). This value is placed in Budget -&gt; Colas -&gt; Marketing. Analytic Services repeats steps 2-3 for each expense category for Budget -&gt; Colas and then for Budget -&gt; Root Beer. As specified in the calculation script, the allocated values are rounded to the nearest whole dollar. Analytic Services makes a second pass through the block to make the sum of the rounded values equal to the allocation value (for example, 1000 for Budget -&gt; Colas -&gt; Total Expenses). In this example, there is a rounding error of 1 for Budget -&gt; Colas -&gt; Total Expenses, because the expense categories add up to 999, not 1000, which is the allocation value. Because all the allocated values are identical (333), the rounding error of 1 is added to the first value in the allocation range, Budget -&gt; Colas -&gt; Marketing (thus a value of 334). Allocating Across Multiple Dimensions The following example uses the @MDALLOCATE function to allocate a loaded value for budgeted total expenses across three dimensions. The budgeted total expenses are allocated based on the actual values of the prior year. The following example is based on the Sample Basic database. Assume that you have made the following modifications: Added a child, PY Actual, to the Scenario dimension Copied data from Actual into PY Actual Cleared data from Budget For this example, a value of 750 (for Budget -&gt; Total Expenses -&gt; Product -&gt; East-&gt; Jan) needs to be allocated to each expense category for the children of product 100 across the states in the East. The allocation uses values from PY Actual to determine the percentage share that each category should receive. This calculation script defines the allocation: /* Allocate budgeted total expenses based on prior year, across 3 dimensions */ SET UPDATECALC OFF; FIX (East, 100, Total Expenses) BUDGET = @MDALLOCATE(750,3,@CHILDREN(100),@CHILDREN(Total Expenses),@CHILDREN(East),PY Actual,,share); ENDFIX This table shows the values for PY Actual: Jan PY Actual Marketing Payroll Misc Total Expenses 100-10 New York 94 51 0 145 Massachusetts 23 31 1 55 Florida 27 31 0 58 Connecticut 40 31 0 71 New Hampshire 15 31 1 47 100-20 New York 199 175 2 376 Massachusetts #MI #MI #MI #MI Florida #MI #MI #MI #MI Connecticut 26 23 0 49 New Hampshire #MI #MI #MI #MI 100-30 New York #MI #MI #MI #MI Massachusetts 26 23 0 49 Florida #MI #MI #MI #MI Connecticut #MI #MI #MI #MI New Hampshire #MI #MI #MI #MI 100 New York #MI #MI #MI #MI Massachusetts 12 22 1 35 Florida 12 22 1 35 Connecticut 94 51 0 145 New Hampshire 23 31 1 55 East 237 220 3 460 Analytic Services cycles through the database, performing these calculations: Analytic Services fixes on East, the children of 100, and Total Expenses. Using a FIX statement with @MDALLOCATE may improve calculation performance. Before performing the allocation, Analytic Services needs to determine what share of 750 (the value to be allocated) each expense category should receive, for each product-state combination. To determine the share, Analytic Services uses the shares of each expense category from PY Actual. Starting with PY Actual -&gt; 100-10 -&gt; New York, Analytic Services divides the value for the first expense category, Marketing, by the value for PY Actual-&gt; 100-10 -&gt; East -&gt; Total Expenses to calculate the percentage share of that category. For example, Analytic Services divides the value for PY Actual -&gt; 100-10 -&gt; New York -&gt; Marketing (94) by the value for PY Actual -&gt; 100-10 -&gt; East -&gt; Total Expenses (460), which yields a percentage share of approximately 20.4% for the Marketing category. Analytic Services repeats step2 for each expense category, for each product-state combination. During the allocation, Analytic Services uses the percentage shares calculated in step2 to step3 to determine what share of 750 should be allocated to each child of Total Expenses from Budget, for each product-state combination. For example, for Marketing, Analytic Services uses the 20.4% figure calculated in step2 , takes 20.4% of 750 (approximately 153), and places the allocated value in Budget -&gt; 100-10 -&gt; New York -&gt; Marketing (see the next table). Analytic Services repeats step 4 for each expense category and for each product-state combination, using the percentage shares from PY Actual calculated in step2 to step3 . Analytic Services consolidates the expense categories to yield the values for Total Expenses. This table shows the results of the allocation for Budget: Jan Budget Marketing Payroll Misc Total Expenses 100-10 New York 153.26 83.15 0 236.41 Massachusetts 37.50 50.54 1.63 89.67 Florida 44.02 50.54 0 94.56 Connecticut 65.22 50.54 0 115.76 New Hampshire 24.46 50.54 1.63 76.63 100-20 New York #MI #MI #MI #MI Massachusetts #MI #MI #MI #MI Florida 42.39 37.50 0 79.89 Connecticut #MI #MI #MI #MI New Hampshire #MI #MI #MI #MI 100-30 New York #MI #MI #MI #MI Massachusetts #MI #MI #MI #MI Florida #MI #MI #MI #MI Connecticut #MI #MI #MI #MI New Hampshire 19.57 35.87 1.63 57.07 100 New York 153.26 83.15 0 236.41 Massachusetts 37.50 50.54 1.63 89.67 Florida 86.41 88.04 0 174.46 Connecticut 65.22 50.54 0 115.76 New Hampshire 44.02 86.41 3.26 133.70 East 386.41 358.70 4.89 750 Goal Seeking Using the LOOP Command The following example is based on the Sample Basic database. However, the example assumes that no members are tagged as Dynamic Calc and that the Profit per Ounce member (under Ratios in the Scenario dimension) is not included in the calculation. For an explanation of how you calculate values dynamically and how you benefit from doing so, see Dynamic Calc members, in Dynamically Calculating Data Values. You want to know what sales value you have to reach in order to obtain a certain profit on a specific product. This example adjusts the Budget value of Sales to reach a goal of 15,000 Profit for Jan. The results are shown for product 100-10. Figure 204: Measures Dimension from the Sample Basic Database Assume that the data values before running the goal-seeking calculation script are as follows: Product, Market, Budget Jan Profit Margin Sales COGS Total Expenses Marketing Payroll Misc 12,278.50 30,195.50 49,950.00 19,755.00 17,917.00 3,515.00 14,402.00 0 Inventory Label Only member Ratios Margin % Profit % Label Only member 60.45 24.58 This calculation script produces the goal-seeking results: /* Declare the temporary variables and set their initial values*/ VAR Target = 15000, AcceptableErrorPercent = .001, AcceptableError, PriorVar, PriorTar, PctNewVarChange = .10, CurTarDiff, Slope, Quit = 0, DependencyCheck, NxtVar; /*Declare a temporary array variable called Rollback and base it on the Measures dimension */ ARRAY Rollback [Measures]; /* Fix on the appropriate member combinations and perform the goal-seeking calculation*/ FIX(Budget, Jan, Product, Market) LOOP (35, Quit) Sales (Rollback = Budget; AcceptableError = Target * (AcceptableErrorPercent); PriorVar = Sales; PriorTar = Profit; Sales = Sales + PctNewVarChange * Sales;); CALC DIM(Measures); Sales (DependencyCheck = PriorVar - PriorTar; IF(DependencyCheck &lt;&gt; 0) CurTarDiff = Profit - Target; IF(@ABS(CurTarDiff) &gt; @ABS(AcceptableError)) Slope = (Profit - PriorTar) / (Sales - PriorVar); NxtVar = Sales - (CurTarDiff / Slope); PctNewVarChange = (NxtVar - Sales) / Sales; ELSE Quit = 1; ENDIF; ELSE Budget = Rollback; Quit = 1; ENDIF;); ENDLOOP CALC DIM(Measures); ENDFIX Analytic Services performs the following calculations: It declares the required temporary variables using the VAR command. Where appropriate, the initial values are set. Analytic Services declares a one-dimensional array called Rollback. The size of Rollback is based on the number of members in the Measures dimension. Analytic Services uses Rollback to store the Budget values. Analytic Services fixes on the Jan -&gt; Budget values for all Product and Market members. The LOOP command ensures that the commands between LOOP and ENDLOOP are cycled through 35 times for each member combination . However, if the Quit variable is set to 1, then the LOOP is broken and the calculation continues after the ENDLOOP command. Analytic Services cycles through the member combinations, performing the following calculations: Analytic Services places the Budget -&gt; Sales value in the Rollback temporary array variable. It calculates the acceptable error. It multiplies the Target value (15000) by the AcceptableErrorPercent value (0.001) and places the result in the AcceptableError variable. It retains the current Sales value. It places the Sales value for the current member combination in the PriorVar temporary variable. It retains the current Profit value. It places the Profit value for the current member combination in the PriorTar temporary variable. It calculates a new Sales value. It multiplies the PctNewVarChange value (0.1) by the current Sales value, adds the current Sales value, and places the result in Sales. Analytic Services calculates and consolidates the Measures dimension. It subtracts the PriorTar value from the PriorVar value and places the result in the DependencyCheck temporary variable. The IF command checks that DependencyCheck is not 0 (zero). If DependencyCheck is not 0, then Analytic Services subtracts the Target value (15000) from the current Profit and places the result in the CurTarDiff temporary variable. The IF command checks to see if the absolute value (irrespective of the + or - sign) of CurTarDiff is greater than the absolute value of the acceptable error (AcceptableError). If it is, Analytic Services calculates the Slope, NxtVar, and PctNewVarChange temporary variables. If it is not greater than AcceptableError, Analytic Services breaks the LOOP command by setting the value of Quit to 1. The calculation continues after the ENDLOOP command. If DependencyCheck is 0, Analytic Services places the value in the Rollback array into Budget. Analytic Services breaks the LOOP command by setting the value of Quit to 1. The calculation continues after the ENDLOOP command. Analytic Services calculates and consolidates the Measures dimension. The results are shown in this table: Product, Market, Budget Jan Profit Margin Sales COGS Total Expenses Marketing Payroll Misc 15,000.00 32,917.00 52,671.50 19,755.00 17,917.00 3,515.00 14,402.00 0 Inventory Label Only member Ratios Margin % Profit % Label Only member 28.47839913 62.49489762 Forecasting Future Values The following example uses the @TREND function to forecast sales data for June through December, assuming that data currently exists only up to May. Using the linear regression forecasting method, this example produces a trend, or line, that starts with the known data values from selected previous months and continues with forecasted values based on the known values. In addition, this example demonstrates how to check the results of the trend for goodness of fit to the known data values. The following example is based on the Sample Basic database. Assume that the Measures dimension contains an additional child, ErrorLR. The goodness-of-fit results are placed in this member. This calculation script defines the forecasting: Sales (@TREND(@LIST(Jan,Mar,Apr),@LIST(1,3,4),, @RANGE(ErrorLR,@LIST(Jan,Mar,Apr)), @LIST(6,7,8,9,10,11,12), Jun:Dec,LR);); This table explains each parameter: Parameter Description @LIST(Jan,Mar,Apr) Represents the Ylist , or the members that contain the known data values. The @LIST function is needed to group the three members as a comma-delimited list and to keep the list separate from other parameters. @LIST(1,3,4) Represents the Xlist , or the underlying variable values. Since Feb and May are skipped, Analytic Services needs to number the Ylist values accordingly (1,3,4). , The extra comma after the Xlist parameter indicates that a parameter has been skipped, in this case, the weightList parameter. The default weight of 1 is used for this example. @RANGE(ErrorLR, @LIST(Jan,Mar,Apr) Represents the errorList , or the member list where results of the goodness of fit of the trend line to Ylist are placed. The values placed in errorList are the differences between the data points in Ylist and the data points on the trend line produced. The @RANGE function combines the ErrorLR member with Ylist (Jan, Mar, Apr) to produce a member list. @LIST(6,7,8,9,10,11,12) Represents the XforecastList , or the underlying variable values for which the forecast is sought. This example forecasts values consecutively for Jun through Dec, so the values are simply 6,7,8,9,10,11,12. Jun:Dec Represents the YforecastList , or the member list into which the forecast values are placed. In this example, values are forecast for Jun through Dec based on the values for Jan, Mar, and Apr. LR Specifies the Linear Regression method. This table shows the results of the calculation script: . 100 West Actual Sales ErrorLR Jan 2339 4.57 Feb 2298 #MI Mar 2313 -13.71 Apr 2332 9.14 May 2351 #MI Jun 2315.14 #MI Jul 2311.29 #MI Aug 2307.49 #MI Sep 2303.57 #MI Oct 2299.71 #MI Nov 2295.86 #MI Dec 2292 #MI Analytic Services cycles through the database, performing the following calculations: Analytic Services finds the known data values on which to base the trend (Sales for Jan, Mar, Apr), as specified for the Ylist and Xlist parameters in the calculation script. Analytic Services calculates the trend line using Linear Regression and places the results in Sales for Jun through Dec, as specified for the YforecastList parameter in the calculation script. Analytic Services calculates the goodness of fit of the trend line to the data values for Jan, Mar, and Apr and places the results in ErrorLR for those months. For example, the value in ErrorLR for Jan (4.57) means that after Analytic Services calculates the trend line, the difference between the Sales value for Jan (2339) and the Jan value on the trend line is 4.57. The ErrorLR values for Feb and May are #MISSING since these months were not part of Ylist .  |../dcacsexs.htm",
    "Developing Calculation Scripts||This chapter explains how to develop calculation scripts and how to use them to control the way Analytic Services calculates a block storage database. This chapter provides some examples of calculation scripts, which you may want to adapt for your own use. This chapter also shows you how to create and execute a simple calculation script. This chapter is not relevant to aggregate storage databases. This chapter includes the following sections: Understanding Calculation Scripts Understanding Calculation Script Syntax Planning Calculation Script Strategy Reviewing the Process for Creating Calculation Scripts For a comprehensive discussion of developing formulas, which may be used in calculation scripts or in an outline, see Developing Formulas. For more examples, see Reviewing Examples of Calculation Scripts. For information about copying, renaming, locking, and deleting calculation scripts, see Using Analytic Services to Manage Objects . Understanding Calculation Scripts A calculation script contains a series of calculation commands, equations, and formulas. You use a calculation script to define calculations other than the calculations that are defined by the database outline. Calculation scripts are text files. Using Calculation Script Editor, you can create calculation scripts by: Typing the contents of the calculation script directly into the text area of the script editor Using the user interface features of the script editor to build the script Creating the script in the text editor of your choice and pasting it into Calculation Script Editor. When you save a calculation script, it is given a .csc extension by default. If you run a calculation script from Essbase Administration Services or from Essbase Spreadsheet Services, it must have a .csc extension. However, since a calculation script is basically a text file, you can use MaxL or ESSCMD to run any text file as a calculation script. For more information about Calculation Script Editor, see About Calculation Script Editor in Essbase Administration Services Online Help . For example, the following calculation script calculates the Actual values in the Sample Basic database. FIX (Actual) CALC DIM(Year, Measures, Market, Product); ENDFIX You can use a calculation script to specify exactly how you want Analytic Services to calculate a database. For example, you can calculate part of a database or copy data values between members. You can design and run custom database calculations quickly by separating calculation logic from the database outline. Analytic Services allows you to perform a default calculation (CALC ALL) or a calculation of your own choosing that you specify in a calculation script to control how Analytic Services calculates a database. For example, you need to write a calculation script if you want to do any of the following: Use the FIX command to calculate a subset of a database. For more information, see Using the FIX Command and the Technical Reference . Change the calculation order of the dense and sparse dimensions in a database. Perform a complex calculation in a specific order or perform a calculation that requires multiple iterations through the data. For example, some two-pass calculations require a calculation script. Perform any two-pass calculation on a dimension without an accounts tag. For a comprehensive discussion of two-pass calculation, see Using Two-Pass Calculation . Perform a currency conversion. For a comprehensive discussion of currency conversion, see Designing and Building Currency Conversion Applications. Calculate member formulas that differ from formulas in the database outline. Formulas in a calculation script override formulas in the database outline. Use an API interface to create a custom calculation dynamically. Use control of flow logic in a calculation; for example, if you want to use the IF...ELSE...ENDIF or the LOOP...ENDLOOP commands. Clear or copy data from specific members. For an example of copying data, see Copying Data . Define temporary variables for use in a database calculation. For a discussion on how to declare temporary variables, see Declaring Data Variables . Force a recalculation of data blocks after you have changed a formula or an accounts property on the database outline. Control how Analytic Services uses the Intelligent Calculation feature when calculating a database. For a comprehensive discussion of intelligent calculation, see Optimizing with Intelligent Calculation. Understanding Calculation Script Syntax Analytic Services provides a flexible set of commands that you can use to control how a database is calculated. You can construct calculation scripts from commands and formulas. In Calculation Script Editor, the different elements of the script are color-coded to aid in script readability. You can enable auto-completion to help build scripts interactively as you type. For more information, see About Calculation Script Editor in Essbase Administration Services Online Help . Computation, control of flow, and data declarations are discussed in the following sections. For a full list of calculation script commands, see the Technical Reference . Understanding the Rules for Calculation Script Syntax Understanding Calculation Commands Controlling the Flow of Calculations Declaring Data Variables Specifying Global Settings for a Database Calculation Adding Comments Understanding the Rules for Calculation Script Syntax When you create a calculation script, you need to apply the following rules: End each formula or calculation script command with a semicolon (;), as shown in these examples. Example 1: CALC DIM(Product, Measures); Example 2: DATACOPY Plan TO Revised_Plan; Example 3: Market Share = Sales % Sales-&gt;Market; Example 4: IF (Sales &lt;&gt; #MISSING) Commission = Sales * .9; ELSE Commission = #MISSING; ENDIF; You do not need to end the following commands with semicolons-IF, ENDIF, ELSE, ELSEIF, FIX, ENDFIX, LOOP, and ENDLOOP. Although ending ENDIF statements with a semicolon (;) is not required, it is good practice to follow each ENDIF statement in a formula with a semicolon. Enclose a member name in double quotation marks ( ) if that member name meets any of the following conditions: Contains spaces; for example, Opening Inventory = Ending Inventory - Sales + Additions; Is the same as an operator or function name. For a list of operator and functions names, see Understanding the Rules for Naming Dimensions and Members . Includes any non-alphanumeric character; for example, hyphen (-), asterisk (*), and slash (/ ). For a complete list of special characters, see Understanding the Rules for Naming Dimensions and Members . Contains only numerals or starts with a numeral; for example, 100 or 10Prod. Begins with an ampersand (&amp;). The leading ampersand (&amp;) is reserved for substitution variables. If a member name begins with &amp;, enclose it in quotation marks. Do not enclose substitution variables in quotation marks in a calculation script. Contains a dot (.); for example, 1999.Jan or .100. If you are using an IF statement or an interdependent formula, enclose the formula in parentheses to associate it with the specified member. For example, the following formula is associated with the Commission member in the database outline: Commission (IF(Sales &lt; 100) Commission = 0; ENDIF;) End each IF statement in a formula with an ENDIF statement. For example, the previous formula contains a simple IF...ENDIF statement. If you are using an IF statement that is nested within another IF statement, end each IF with an ENDIF statement; for example: Opening Inventory (IF (@ISMBR(Budget)) IF (@ISMBR(Jan)) Opening Inventory = Jan; ELSE Opening Inventory = @PRIOR(Ending Inventory); ENDIF; ENDIF;) You do not need to end ELSE or ELSEIF statements with ENDIF statements; for example: Marketing (IF (@ISMBR(@DESCENDANTS(West)) OR @ISMBR(@DESCENDANTS(East))) Marketing = Marketing * 1.5; ELSEIF(@ISMBR(@DESCENDANTS(South))) Marketing = Marketing * .9; ELSE Marketing = Marketing * 1.1; ENDIF;) Note: If you use ELSE IF (with a space in between) rather than ELSEIF (one word) in a formula, you must supply an ENDIF for the IF statement. End each FIX statement with an ENDFIX statement; for example: FIX(Budget,@DESCENDANTS(East)) CALC DIM(Year, Measures, Product); ENDFIX When you write a calculation script, you can use the Calculation Script Editor syntax checker to check the syntax. For a brief discussion of the syntax checker, see Checking Syntax . Note: For detailed information on calculation script syntax, see the Technical Reference . Understanding Calculation Commands You can use the following calculation commands to perform a database calculation that is based on the structure and formulas in the database outline. Note: For a complete list of calculation commands and syntax, see the Technical Reference . Calculation Command The entire database, based on the outline CALC ALL A specified dimension or dimensions CALC DIM All members tagged as two-pass on the dimension tagged as accounts CALC TWOPASS The formula applied to a member in the database outline, where membername is the name of the member to which the formula is applied membername All members tagged as Average on the dimension tagged as accounts CALC AVERAGE All members tagged as First on the dimension tagged as accounts CALC FIRST All members tagged as Last on the dimension tagged as accounts CALC LAST Currency conversions CCONV Controlling the Flow of Calculations You can use the following commands to manipulate the flow of calculations. For detailed information on these commands, see the Technical Reference . Calculation Commands Calculate a subset of a database FIX...ENDFIX Specify the number of times that commands are iterated LOOP...ENDLOOP You can also use the IF and ENDIF commands to specify conditional calculations. Note: You cannot branch from one calculation script to another calculation script. Declaring Data Variables You can use the following commands to declare temporary variables and, if required, to set their initial values. Temporary variables store the results of intermediate calculations. You can also use substitution variables in a calculation script. For a discussion where, why, and how to use substitution variables, see Using Substitution Variables in Calculation Scripts . Calculation Commands Declare one-dimensional array variables ARRAY Declare a temporary variable that contains a single value VAR For detailed information on the these commands, see the Technical Reference . Values stored in temporary variables exist only while the calculation script is running. You cannot report on the values of temporary variables. Variable and array names are character strings that contain any of the following characters: Alphabetic letters: a through z Numerals: 0 through 9 Special characters: $(dollar sign), # (pound sign), and _ (underscore) Typically, arrays are used to store variables as part of a member formula. The size of the array variable is determined by the number of members in the corresponding dimension. For example, if the Scenario dimension has four members, the following command creates an array called Discount with four entries. You can use more than one array at a time. ARRAY Discount[Scenario]; Specifying Global Settings for a Database Calculation You can use the following commands to define calculation behavior. For a detailed discussion of each specific command, see the Technical Reference . Calculation Command To specify how Analytic Services treats #MISSING values during a calculation SET AGGMISSG To adjust the default calculator cache size SET CACHE To enable parallel calculation (see Using Parallel Calculation ) SET CALCPARALLEL To increase the number of dimensions used to identify tasks for parallel calculation (see Using Parallel Calculation ) SET CALCTASKDIMS To optimize the calculation of sparse dimension formulas in large database outlines (see Optimizing Formulas on Sparse Dimensions in Large Database Outlines ) SET FRMLBOTTOMUP To display messages to trace a calculation. SET MSG SET NOTICE To turn on and turn off Intelligent Calculation (see Turning Intelligent Calculation On and Off ) SET UPDATECALC To control how Analytic Services marks data blocks for the purpose of Intelligent Calculation (see Using the SET CLEARUPDATESTATUS Command ) SET CLEARUPDATESTATUS To specify the maximum number of blocks that Analytic Services can lock concurrently when calculating a sparse member formula SET LOCKBLOCK To turn on and turn off the Create Blocks on Equation setting. This setting controls creation of blocks when you assign non-constant values to members of a sparse dimension (see Non-Constant Values Assigned to Members in a Sparse Dimension SET CREATEBLOCKEQ To enable calculations on potential data blocks and save these blocks when the result is not #MISSING. SET CREATENONMISSINGBLK For currency conversions, to restrict consolidations to parents that have the same defined currency (see Calculating Databases ) SET UPTOLOCAL A SET command in a calculation script stays in effect until the next occurrence of the same SET command. Consider the following calculation script: SET MSG DETAIL; CALC DIM(Year); SET MSG SUMMARY; CALC DIM(Measures); Analytic Services displays messages at the detail level when calculating the Year dimension. However, when calculating the Measures dimension, Analytic Services displays messages at the summary level. Some SET calculation commands trigger additional passes through the database. Consider this calculation script: SET AGGMISSG ON; Qtr1; SET AGGMISSG OFF; East; Analytic Services calculates member combinations for Qtr1 with SET AGGMISSG turned on. Analytic Services then does a second calculation pass through the database and calculates member combinations for East with SET AGGMISSG turned off. For more information on the setting for consolidating missing values, see the SET AGGMISSG command in the Technical Reference . For more information on calculation passes, see Using Two-Pass Calculation . Adding Comments You can include comments to annotate calculation scripts. Analytic Services ignores these comments when it runs the calculation script. To include a comment, start the comment with /* and end the comment with */. Consider the following comment: /* This is a calculation script comment that spans two lines.*/ Planning Calculation Script Strategy You can type a calculation script directly into the text area of Calculation Script Editor, or you can use the user interface features of Calculation Script Editor to build the calculation script. Using Formulas in a Calculation Script Using a Calculation Script to Control Intelligent Calculation Grouping Formulas and Calculations Calculating a Series of Member Formulas Calculating a Series of Dimensions Using Substitution Variables in Calculation Scripts Clearing Data Copying Data Calculating a Subset of a Database Enabling Calculations on Potential Blocks Writing Calculation Scripts for Partitions Controlling Calculation Order for Partitions Using Formulas in a Calculation Script You can place member formulas in a calculation script. When you place formulas in a calculation script, they override any conflicting formulas that are applied to members in the database outline. In a calculation script, you can perform both of the following operations: Calculate a member formula on the database outline Define a formula To calculate a formula that is applied to a member in the database outline, simply use the member name followed by a semicolon (;); for example: Variance; This command calculates the formula applied to the Variance member in the database outline. To override values that result from calculating an outline, manually apply a formula that you define in a calculation script, using Calculation Script Editor or by creating a .txt file. The following formula cycles through the database, adding the values in the members Payroll, Marketing, and Misc and placing the result in the Expenses member. This formula overrides any formula placed on the Expenses member in the database outline. Expenses = Payroll + Marketing + Misc; Note: You cannot apply formulas to shared members or label only members. For more information about formulas, see Developing Formulas. Basic Equations You can use equations in a calculation script to assign value to a member, as follows: Member = mathematical expression; In this equation, Member is a member name from the database outline, and mathematical expression is any valid mathematical expression. Analytic Services evaluates the expression and assigns the value to the specified member. For example, the following formula causes Analytic Services to cycle through the database, subtracting the values in COGS from the values in Sales and placing the result in Margin: Margin = Sales - COGS; To cycle through a database means that Analytic Services takes a calculation pass through the database. For more information on calculation passes, see Using Two-Pass Calculation . The next formula cycles through the database subtracting the values in Cost from the values in Retail, calculating the resulting values as a percentage of the values in Retail, and placing the results in Markup: Markup = (Retail - Cost) % Retail; You can also use the &gt; (greater than) and &lt; (less than) logical operators in equations; for example: Sales Increase Flag = Sales-&gt;Feb &gt; Sales-&gt;Jan; If it is true that February sales are greater than January sales, Sales Increase Flag results in a 1 value; if false, the result is a 0 value. Conditional Equations When you use an IF statement as part of a member formula in a calculation script, you need to perform both of the following tasks: Associate the IF statement with a single member Enclose the IF statement in parentheses A sample IF statement is illustrated in the following example: Profit (IF (Sales &gt; 100) Profit = (Sales - COGS) * 2; ELSE Profit = (Sales - COGS) * 1.5; ENDIF;) Analytic Services cycles through the database and performs the following calculations: The IF statement checks to see if the value of Sales for the current member combination is greater than 100. If Sales is greater than 100, Analytic Services subtracts the value in COGS from the value in Sales, multiplies the difference by 2, and places the result in Profit. If Sales is less than or equal to 100, Analytic Services subtracts the value in COGS from the value in Sales, multiplies the difference by 1.5, and places the result in Profit. The whole of the IF...ENDIF statement is enclosed in parentheses and associated with the Profit member, Profit (IF(...)...) . Interdependent Formulas When you use an interdependent formula in a calculation script, the same rules apply as for the IF statement. You need to perform both of the following tasks: Associate the formula with a single member Enclose the formula in parentheses Consider the interdependent formula discussed earlier. If you place the formula in a calculation script, you enclose the whole formula in parentheses and associate it with the Opening Inventory member, as follows: Opening Inventory (IF(NOT @ISMBR (Jan))Opening Inventory = @PRIOR(Ending Inventory)); ENDIF; Ending Inventory = Opening Inventory - Sales + Additions;) Using a Calculation Script to Control Intelligent Calculation Assume that you have a formula on a sparse dimension member and the formula contains either of the following: A relationship function (for example, @PRIOR or @NEXT) A financial function (for example, @NPV or @INTEREST) Analytic Services always recalculates the data block that contains the formula, even if the data block is marked as clean for the purposes of Intelligent Calculation. For more information, see Calculating Data Blocks . For more information about Intelligent Calculation, see Optimizing with Intelligent Calculation. Grouping Formulas and Calculations You may achieve significant calculation performance improvements by carefully grouping formulas and dimensions in a calculation script. For a discussion of the appropriate use of parentheses and for examples, see Calculating a Series of Member Formulas and Calculating a Series of Dimensions . When you run a calculation script, Analytic Services automatically displays the calculation order of the dimensions for each pass through the database so that you can tell how many times Analytic Services has cycled through the database during the calculation. Analytic Services writes these information messages in the application log. The messages can also be viewed during your session in the following ways: In the Messages Panel of Administration Services Console In the standard output (command-line window) of MaxL Shell or ESSCMD To display the application log, see Viewing the Analytic Server and Application Logs . Calculating a Series of Member Formulas When you calculate formulas, avoid using parentheses unnecessarily. The following formulas cause Analytic Services to cycle through the database once, calculating both formulas in one pass: Profit = (Sales - COGS) * 1.5; Market = East + West; Similarly, the following configurations cause Analytic Services to cycle through the database only once, calculating the formulas on the members Qtr1, Qtr2, and Qtr3: Qtr1; Qtr2; Qtr3; or (Qtr1; Qtr2; Qtr3;) However, the inappropriately placed parentheses in the following example causes Analytic Services to perform two calculation passes through the database, once calculating the formulas on the members Qtr1 and Qtr2 and once calculating the formula on Qtr3: (Qtr1; Qtr2;) Qtr3; Calculating a Series of Dimensions When you calculate a series of dimensions, you can optimize performance by grouping the dimensions wherever possible. For example, the following formula causes Analytic Services to cycle through the database only once: CALC DIM(Year, Measures); However, the following syntax causes Analytic Services to cycle through the database twice, because Analytic Services cycles through once for each CALC DIM command: CALC DIM(Year); CALC DIM(Measures); Using Substitution Variables in Calculation Scripts You can use substitution variables in calculation scripts. Substitution variables are useful, for example, when you reference information or lists of members that change frequently. When you include a substitution variable in a calculation script, Analytic Services replaces the substitution variable with the value you specified for the substitution variable. You create and specify values for substitution values in Essbase Administration Services. For a comprehensive discussion of substitution variables, see Using Substitution Variables . You can create variables at the server, application, and database levels. When you use a substitution variable in a calculation script, it must be available to the calculation script. For example, if you create a substitution variable at the database level, it is only available to calculation scripts within the database. However, if you create a variable at the server level, it is available to any calculation script on the server. Add the ampersand (&amp;) character before a substitution variable in a calculation script. Analytic Services treats any string that begins with a leading ampersand as a substitution variable, replacing the variable with its assigned value before parsing the calculation script. For example, &amp;CurQtr; becomes Qtr1; if you have given the substitution variable &amp;CurQtr the value Qtr1 . Consider an example in which you want to calculate Sample Basic data for the current quarter. You can use the following calculation script to perform this calculation: FIX(&amp;CurQtr) CALC DIM(Measures, Product); ENDFIX You then define the substitution variable CurQtr as the current quarter; for example, Qtr3. Analytic Services replaces the variable CurQtr with the value Qtr3 when it runs the calculation script. Clearing Data You can use the following commands to clear data. If you want to clear an entire database, see Clearing Data in the Essbase Administration Services Online Help . Calculation Command Changes the values of the cells you specify to #MISSING. The data blocks are not removed. You can use the FIX command with the CLEARDATA command to clear a subset of a database. CLEARDATA Removes the entire contents of a block, including all the dense dimension members. Analytic Services removes the entire block, unless CLEARBLOCK is inside a FIX command on members within the block. CLEARBLOCK Removes blocks for Dynamic Calc and Store member combinations. For more information, see Dynamically Calculating Data Values. CLEARBLOCK DYNAMIC The following examples are based on the Sample Basic database. If the Scenario dimension is dense, the following example removes all the data cells that do not contain input data values and intersect with member Actual from the Scenario dimension. FIX(Actual) CLEARBLOCK NONINPUT; ENDFIX If the Scenario dimension is sparse, the following formula removes only the blocks whose Scenario dimension member is Actual. The other blocks remain: FIX(Actual) CLEARBLOCK NONINPUT; ENDFIX For example, the following formula clears all the Actual data values for Colas: CLEARDATA Actual-&gt;Colas; Copying Data You can use the DATACOPY calculation command to copy data cells from one range of members to another range of members in a database. The two ranges must be the same size. For example, in the Sample Basic database, the following formula copies Actual values to Budget values: DATACOPY Actual TO Budget; You can use the FIX command to copy a subset of values. For example, in the Sample Basic database, the following formula copies Actual values to Budget values for the month of January only: FIX (Jan) DATACOPY Actual TO Budget; ENDFIX For more information about the DATACOPY command, see the Technical Reference . For more information about the FIX command, see Using the FIX Command . Calculating a Subset of a Database To calculate a subset of a database, use either of the following methods: Create a formula using member set functions to calculate lists of members. Use the FIX...ENDFIX commands to calculate a range of values. For information about using member lists, see Calculating Lists of Members . For examples of use of the FIX command, see Using the FIX Command . Note: When you have Intelligent Calculation turned on, the newly calculated data blocks are not marked as clean after a partial calculation of a database. When you calculate a subset of a database, you can use the SET CLEARUPDATESTATUS AFTER command to ensure that the newly calculated blocks are marked as clean. Using this command ensures that Analytic Services recalculates the database as efficiently as possible using Intelligent Calculation. For a comprehensive discussion of Intelligent Calculation, see Optimizing with Intelligent Calculation. Calculating Lists of Members You can use a member set function to generate a list of members that is based on a member you specify. For example, you can use the @IDESCENDANTS function to generate a list of all the descendants of a specified member. In the Sample Basic database, @IDESCENDANTS(Total Expenses); generates the following list of members-Total Expenses, Marketing, Payroll, and Misc. When you use a member set function in a formula, Analytic Services generates a list of members before calculating the formula. For detailed information on these and other member set functions, see the Technical Reference . Using the FIX Command The FIX ... ENDFIX commands are particularly useful to calculate a carefully defined subset of the values in a database. For example, the following calculation script calculates only the Budget values for only the descendants of East (New York, Massachusetts, Florida, Connecticut, and New Hampshire) in the Sample Basic database: FIX(Budget,@DESCENDANTS(East)) CALC DIM(Year, Measures, Product); ENDFIX The next example fixes on member combinations for the children of East that have a user-defined attribute (UDA) of New Mkt. For information on defining UDAs, see Creating and Changing Database Outlines. FIX(@CHILDREN(East) AND @UDA(Market, New Mkt )) Marketing = Marketing * 1.1; ENDFIX The next example uses a wildcard match to fix on member names that end in the characters -10. In Sample Basic, this example fixes on the members 100-10, 200-10, 300-10, and 400-10. FIX(@MATCH(Product, ???-10 )) Price = Price * 1.1; ENDFIX When you use the FIX command only on a dense dimension, Analytic Services retrieves the entire block that contains the required value or values for the member or members that you specify. Thus, I/O is not affected, and the calculation performance time is improved. When you use the FIX command on a sparse dimension, Analytic Services retrieves the block for the specified sparse dimension member or members. Thus, I/O may be greatly reduced. Analytic Services cycles through the database once for each FIX command that you use on dense dimension members. When possible, combine FIX blocks to improve calculation performance. For example, the following calculation script causes Analytic Services to cycle through the database only once, calculating both the Actual and the Budget values: FIX(Actual,Budget) CALC DIM(Year, Measures); ENDFIX However, this calculation script causes Analytic Services to cycle through the database twice, once calculating the Actual data values and once calculating the data values for Budget: FIX(Actual) CALC DIM(Year, Measures); ENDFIX FIX(Budget) CALC DIM(Year, Measures); ENDFIX You cannot FIX on a subset of a dimension that you calculate within a FIX statement. For example, the following calculation script returns an error message because the CALC DIM operation calculates the entire Market dimension, although the FIX above it fixes on specific members of the Market dimension. FIX(@CHILDREN(East) AND @UDA(Market, New Mkt )) CALC DIM(Year, Measures, Product, Market); ENDFIX Note: The FIX command has some restrictions. For detailed information on the restrictions and on using the FIX command, see the Technical Reference . Enabling Calculations on Potential Blocks When you use a formula on a dense member in a dense dimension, if the resultant values are from a dense dimension and the operand or operands are from a sparse dimension, Analytic Services does not automatically create the required blocks. Consider an example from Sample Basic, in which you want to create budget sales and expense data from existing actual data. Sales and Expenses are members in the dense Measures dimension. Budget and Actual are members in the sparse Scenario dimension. FIX(Budget) (Sales = Sales-&gt;Actual * 1.1; Expenses = Expenses-&gt;Actual * .95;) ENDFIX Note that Sales and Expenses, the results of the equations, are dense dimension members, and the operand, Actual, is in a sparse dimension. Because Analytic Services executes dense member formulas only on existing data blocks, the calculation script above does not create the required data blocks and Budget data values are not calculated for blocks that do not already exist. You can solve the problem using the following techniques, each with its own advantages and disadvantages: Using DATACOPY to Copy Existing Blocks Using SET CREATENONMISSINGBLK to Calculate All Potential Blocks Using DATACOPY to Copy Existing Blocks You can use the DATACOPY command to create a new block for each existing block, and then perform calculations on the new blocks, as shown in the following example: DATACOPY Sales-&gt;Actual TO Sales-&gt;Budget; DATACOPY Expenses-&gt;Actual TO Expenses-&gt;Budget; FIX(Budget) (Sales = Sales-&gt;Actual * 1.1; Expenses = Expenses-&gt;Actual * .95;) ENDFIX Analytic Services creates blocks that contain the Budget values for each corresponding Actual block that already exists. After the DATACOPY commands are finished, the remaining part of the script changes the values. Using DATACOPY works well in the following circumstances: There is a mathematical relationship between values in existing blocks and their counterparts created by the DATACOPY. For example, in the preceding example, the Budget values can be calculated based on the existing Actual values. None of the blocks that are copied contain only #MISSING values. It is possible that blocks will be written that contain only #MISSING values. Unneeded #MISSING blocks require Analytic Services resource and processing time. Caution: DATACOPY creates the new blocks with identical values in ALL cells from the source blocks. If the formula only performs on a portion of the block, these copied cells will remain at the end of calculation, potentially resulting in unwanted values. Using SET CREATENONMISSINGBLK to Calculate All Potential Blocks If you are concerned about unwanted values, instead of using the DATACOPY approach described above, you can use the SET CREATENONMISSINGBLK ON calculation command. The SET CREATENONMISSINGBLK ON calculation command calculates all potential blocks in memory and then stores only the calculated blocks that contain data values. The following example script demonstrates using the SET CREATENONMISSINGBLK ON calculation command to create budget sales and expense data from existing actual data. Sales and Expenses are members in the dense Measures dimension. Budget and Actual are members in the sparse Scenario dimension. FIX(Budget) SET CREATENONMISSINGBLK ON (Sales = Sales-&gt;Actual * 1.1; Expenses = Expenses-&gt;Actual * .95;) ENDFIX The SET CREATENONMISSINGBLK calculation command can be useful when calculating values on dense or sparse dimensions. For additional information about this command, see the Technical Reference . Note: If the Create Blocks on Equations setting for sparse dimensions is ON, the SET CREATENONMISSINGBLK ON temporarily overrides the Create Blocks on Equations setting until a SET CREATENONMISSINGBLK OFF command is encountered or the calculation script is completed. For more information about the Create Blocks on Equations setting, see Non-Constant Values Assigned to Members in a Sparse Dimension or the SET CREATEBLOCKONEQ calculation command in the Technical Reference . The advantage to using the SET CREATENONMISSINGBLK command is that, when applied on dense members, only data cells that are affected by the member formula are saved. The disadvantage is that too many potential blocks may be materialized in memory, possibly affecting calculation performance. When you use this command, limit the number of potential blocks; for example, by using FIX to restrict the scope of the blocks to be calculated. For additional information about using the SET CREATENONMISSINGBLK ON calculation command, see the Technical Reference . Writing Calculation Scripts for Partitions A partitioned application can span multiple servers, processors, or computers. For a comprehensive discussion of partitioning, see Designing Partitioned Applications and Creating and Maintaining Partitions. You can achieve significant calculation performance improvements by partitioning applications and running separate calculations on each partition. However, when you use partitioning, you need to perform both of the following tasks: Consider carefully the performance impact on the overall database calculation. You might choose to use any of the following methods to improve performance: Redesign the overall calculation to avoid referencing remote values that are in a transparent partition in a remote database. Dynamically calculate a value in a remote database. See Dynamically Calculating Data in Partitions . Replicate a value in the database that contains the applicable formula. For example, if you are replicating quarterly data for the Eastern region, replicate only the values for Qtr1, Qtr2, Qtr3, and Qtr4, and calculate the parent Year values locally. Ensure that a referenced value is up-to-date when Analytic Services retrieves it. Choose one of the options previously discussed (redesign, dynamically calculate, or replicate) or calculate the referenced database before calculating the formula. Controlling Calculation Order for Partitions You need to calculate databases in a specific order to ensure that Analytic Services calculates the required results. For example, consider the following partitions in which you view information from the West, Central, and East databases transparently from the Corporate database. Figure 200: Calculating Partitions West, Central, and East contain only actual values. Corporate contains actual and budgeted values. Although you can view the West, Central, and East data in the Corporate database, the data exists only in the West, Central, and East databases; it is not duplicated in the Corporate database. Therefore, when Analytic Services calculates Corporate, it needs to take the latest values from West, Central, and East. To obtain the required results, you need to calculate West, Central, and East before you calculate Corporate. Reviewing the Process for Creating Calculation Scripts Use this process to create a calculation script: Create a new calculation script or open an existing calculation script. See Creating Scripts or Opening Scripts in Essbase Administration Services Online Help . Enter or edit the contents of the calculation scripts. In the Essbase Administration Services Online Help , see About Calculation Script Editor. This may include some or all of the following tasks: Associating a script with an outline Searching an outline tree for members Inserting dimensions, members, and aliases in a script from an outline tree Inserting functions and commands in a script from a tree Using syntax auto-completion Checking script syntax Executing scripts Viewing color-coded script elements Searching for text in a script Changing fonts Validate the calculation script. See Checking Syntax and Checking Script Syntax in the Essbase Administration Services Online Help . Save the calculation script. See Saving Calculation Scripts and Saving Scripts in the Essbase Administration Services Online Help . Execute the calculation script. See Executing Calculation Scripts , Checking the Results of Calculations , and Executing Calculation Scripts in the Essbase Administration Services Online Help . If necessary, perform other operations on the calculation script. In the Essbase Administration Services Online Help , see the following topics: Locking and Unlocking Objects Copying Scripts Renaming Scripts Deleting Scripts Printing Scripts For more information on calculation scripts, see Understanding Calculation Scripts . Checking Syntax Analytic Services includes a syntax checker that tells you about any syntax errors in a calculation script. For example, Analytic Services tells you if you have typed a function name incorrectly. The syntax checker cannot tell you about semantic errors in a calculation script. Semantic errors occur when a calculation script does not work as you expect. To find semantic errors, always run the calculation, and check the results to ensure they are as you expect. Analytic Services displays the syntax checker results in the messages panel in Essbase Administration Services Console. If Analytic Services finds no syntax errors, that is indicated in the messages panel. One error is displayed at a time. If Analytic Services finds one or more syntax errors, it usually displays the number of the line that includes the error and a brief description of the error. For example, if you do not include a semicolon end-of-line character at the end of a calculation script command, Analytic Services displays a message similar to the following: Error: line 1: invalid statement; expected semicolon When you reach the first or last error, Analytic Services displays the following message: No more errors To check the syntax of a calculation script in Calculation Script Editor, see Checking Script Syntax in the Essbase Administration Services Online Help . Saving Calculation Scripts Calculation scripts created using Administration Services are given a .csc extension by default. If you run a calculation script from Administration Services or from Essbase Spreadsheet Services, it must have a .csc extension. However, a calculation script is a text file, and you can use MaxL or ESSCMD to run any text file as a calculation script. A calculation script can also be a string defined in memory. You can access this string via the API on an Analytic Services client or an Analytic Server. Thus, from dialog boxes, you can dynamically create a calculation script that is based on user selections. You can save a calculation script in the following locations: As a file on a client machine. As an object on an Analytic Server. If you want other users to have access to the calculation script, save it on an Analytic Server. You can associate the script with the following objects: An application and all the databases within the application, which lets you run the script against any database in the application. Calculation scripts associated with an application are saved in the / ARBORPATH / app / ap pname directory on the Analytic Server computer. ARBORPATH is the Analytic Services install directory, and appname is the application with which you have associated the calculation script. A database, which lets you run the script against the specified database. Calculation scripts associated with a database are saved in the / ARBORPATH / app / ap pname / dbname directory on the Analytic Server computer. ARBORPATH is the Analytic Services install directory, appname is the application containing the database, and dbname is the database with which you have associated the calculation script. To save a calculation script using Calculation Script Editor, see Saving Scripts in Essbase Administration Services Online Help . Executing Calculation Scripts Before you can execute a calculation script in Administration Services, you must save it as an object on the Analytic Server, on a client computer, or on a network. See Saving Calculation Scripts . When you use Administration Services to execute a calculation script, you can execute the calculation in the background so that you can continue working as the calculation processes. You can then check the status of the background process to see when the calculation has completed. For more information, see Executing Calculation Scripts in Essbase Administration Services Online Help . To execute a calculation script, use any of the following methods: Tool Topic Location Administration Services Executing Calculation Scripts Essbase Administration Services Online Help MaxL execute calculation Technical Reference ESSCMD RUNCALC Technical Reference Essbase Spreadsheet Add-in ESSBASE &gt; CALCULATION Essbase Spreadsheet Add-in User's Guide Essbase Spreadsheet Services Calculating with a Script Essbase Spreadsheet Services Online Help Checking the Results of Calculations After you execute a calculation script, you can check the results of the calculation in the Spreadsheet Add-in or other appropriate tool. When you execute a calculation using Administration Services or Spreadsheet Services, you can view the calculation messages in the application log. When you use ESSCMD to execute a calculation script, you can view the messages in the ESSCMD window. When you use MaxL or ESSCMD to execute a calculation script, Analytic Services displays the messages to the standard output (command-line window), depending on the level of messages you have set to display in MaxL Shell or ESSCMD. To display the application log, see Viewing the Analytic Server and Application Logs . Analytic Services provides the following information: The calculation order of the dimensions for each pass through the database The total calculation time You can use these messages to understand how the calculation is performed and to tune it for the next calculation. To display more detailed information, you can use the SET MSG SUMMARY, SET MSG DETAIL, and SET NOTICE commands in a calculation script. For more information, see Specifying Global Settings for a Database Calculation . Copying Calculation Scripts You can copy calculation scripts to applications and databases on any Analytic Server, according to your permissions. You can also copy scripts across servers as part of application migration. To copy a calculation script, use any of the following methods: Tool Topic Location Administration Services Copying Scripts Essbase Administration Services Online Help MaxL create calculation as Technical Reference ESSCMD COPYOBJECT Technical Reference  |../dcadevcs.htm",
    "Developing Formulas||This chapter explains how to develop and use formulas to calculate a database. It provides detailed examples of formulas, which you may want to adapt for your own use. For more examples, see Reviewing Examples of Formulas. The information in this chapter does not apply to aggregate storage outlines. For information about developing formulas in MDX for aggregate storage outline members, see Developing Formulas on Aggregate Storage Outlines . This chapter includes the following topics: Understanding Formulas Understanding Formula Calculation Understanding Formula Syntax Reviewing the Process for Creating Formulas Displaying Formulas Composing Formulas Estimating Disk Size for a Calculation Using Formulas in Partitions Using formulas can have significant implications for calculation performance. After reading this chapter, use the information in Optimizing Calculations to design and create formulas optimized for performance. For information on using formulas with Hybrid Analysis, see Using Formulas with Hybrid Analysis . Understanding Formulas Formulas calculate relationships between members in a database outline. You can use formulas in two ways: Apply them to members in the database outline. Use this method if you do not need to control database calculations carefully for accuracy or performance. This method limits formula size to less than 64 kilobytes. For instructions, see Composing Formulas . Place them in a calculation script. Use this method if you need to control database calculations carefully. For more information, see Using Formulas in a Calculation Script . The following figure shows the Measures dimension from the Sample Basic database. The Margin %, Profit %, and Profit per Ounce members are calculated using the formulas applied to them. Figure 173: Calculation of Margin %, Profit %, and Profit per Ounce Analytic Services provides a comprehensive set of operators and functions, which you can use to construct formula calculations on a database. The rest of this section provides a description of the elements you can place in a formula, and provides basic information about formula calculation and syntax: Operators Functions Dimension and Member Names Constant Values Non-Constant Values Operators The following table shows the types of operators you can use in formulas: Table 23: Descriptions of Operator Types Operator Type Description Mathematical Perform common arithmetic operations. For example, you can add, subtract, multiply, or divide values. For a complete list of the mathematical operators, see the Technical Reference . Conditional Control the flow of formula executions based on the results of conditional tests. For example, you can use an IF statement to test for a specified condition. For a list of the conditional operators, see the Technical Reference . For information on writing conditional formulas, see Conditional Tests . Cross-dimensional Point to the data values of specific member combinations. For example, point to the sales value for a specific product in a specific region. For examples of how to use the cross-dimensional operator, see Working with Member Combinations across Dimensions . For information about using operators with #MISSING, zero, and other values, see the Analytic Services Functions section in the Technical Reference . Functions Functions are predefined routines that perform specialized calculations and return sets of members or data values. The following table shows the types of functions you can use in formulas. For detailed examples of formulas, see Reviewing Examples of Formulas. Table 24: Descriptions of Function Types  Function Type Description Boolean Provide a conditional test by returning either a TRUE (1) or FALSE (0) value. For example, you can use the @ISMBR function to determine whether the current member is one that you specify. Mathematical Perform specialized mathematical calculations. For example, you can use the @AVG function to return the average value of a list of members. Relationship Look up data values within a database during a calculation. For example, you can use the @ANCESTVAL function to return the ancestor values of a specified member combination. Range Declare a range of members as an argument to another function or command. For example, you can use the @SUMRANGE function to return the sum of all members that lie within a specified range. Financial Perform specialized financial calculations. For example, you can use the @INTEREST function to calculate simple interest or the @PTD function to calculate period-to-date values. Member Set Generate a list of members that is based on a specified member. For example, you can use the @ICHILDREN function to return a specified member and its children. Allocation Allocate values that are input at a parent level across child members. You can allocate values within the same dimension or across multiple dimensions. For example, you can use the @ALLOCATE function to allocate sales values that are input at a parent level to the children of the parent; the allocation of each child is determined by its share of the sales of the previous year. Forecasting Manipulate data for the purposes of smoothing or interpolating data, or calculating future values. For example, you can use the @TREND function to calculate future values that are based on curve-fitting to historical values. Statistical Calculate advanced statistics. For example, you can use the @RANK function to calculate the rank of a specified member or a specified value in a data set. Date and Time Use date and time characteristics in calculation formulas. For example, you can use the @TODATE function to convert date strings to numbers that can be used in calculation formulas. Miscellaneous This type provides two different kinds of functionality: You can specify calculation modes that Analytic Services is to use to calculate a formula-cell, block, bottom-up, and top-down You can manipulate character strings for member and dimension names; for example, to generate member names by adding a character prefix to a name or removing a suffix from a name, or by passing the name as a string. Custom-Defined Functions This type enables you to perform functions that you develop for calculation operations. These custom-developed functions are written in the Java programming language and are called by the Analytic Services calculator framework as external functions. For a complete list of operators, functions, and syntax, see the Technical Reference . Note: Abbreviations of functions are not supported. Some commands may work in an abbreviated form, but if there is another function with a similar name, Analytic Services may use the wrong function. Use the complete function name to ensure correct results. Dimension and Member Names You can include dimension and member names in a formula, as illustrated in the following example: Scenario 100-10 Feb Constant Values You can assign a constant value to a member: California = 120; In this formula, California is a member in a sparse dimension and 120 is a constant value. Analytic Services automatically creates all possible data blocks for California and assigns the value 120 to all data cells. Many thousands of data blocks may be created. To assign constants in a sparse dimension to only those intersections that require a value, use FIX as described in Constant Values Assigned to Members in a Sparse Dimension . Non-Constant Values If you assign anything other than a constant to a member in a sparse dimension, and no data block exists for that member, new blocks may not be created unless Analytic Services is enabled to create blocks on equations. For example, to create blocks for West that didn't exist prior to running the calculation, you need to enable Create Blocks on Equations for this formula: West = California + 120; You can enable Create Blocks on Equations at the database level whereby blocks are always created, or you can control block creation within calculation scripts. To enable the Create Blocks on Equations feature for all calculation scripts for a specific database, use any of the following methods: Tool Topic Location Administration Services Enabling Create Blocks on Equations Essbase Administration Services Online Help MaxL alter database Technical Reference ESSCMD SETDBSTATE Technical Reference Because unnecessary blocks can be created when Create Blocks on Equations is enabled at the application or database level, calculation performance can be affected. To control block creation within a calculation script, use the SET CREATEBLOCKEQ ON OFF calculation command as described in Non-Constant Values Assigned to Members in a Sparse Dimension . Understanding Formula Calculation For formulas applied to members in a database outline, Analytic Services calculates formulas when you do the following: Run a default (CALC ALL) calculation of a database. Run a calculation script that calculates the member containing the formula; for example, a CALC DIM of the dimension containing the member, or the member itself. For information about how to develop calculation scripts and how to use them to control how Analytic Services calculates a database, see Developing Calculation Scripts. For a formula in a calculation script, Analytic Services calculates the formula when it occurs in the calculation script. If a formula is associated with a dynamically calculated member, Analytic Services calculates the formula when the user requests the data values. In a calculation script, you cannot calculate a dynamically calculated member or make a dynamically calculated member the target of a formula calculation. For an explanation of how you calculate data values dynamically and how you benefit from doing so, see Dynamically Calculating Data Values. Using dynamically calculated members in a formula on a database outline or in a calculation script can significantly affect calculation performance. Performance is affected because Analytic Services has to interrupt the regular calculation to perform the dynamic calculation. You cannot use substitution variables in formulas that you apply to the database outline. For an explanation of how substitution variables can be used, see Using Substitution Variables . Understanding Formula Syntax When you create member formulas, make sure the formulas follow these rules: End each statement in the formula with a semicolon (;). For example, Margin % Sales; Enclose a member name in double quotation marks ( ) if the member name meets any of the following conditions: Contains spaces; for example, Opening Inventory = Ending Inventory - Sales + Additions; Is the same as an operator or function name. See the Technical Reference for a list of operators and functions. Includes any non-alphanumeric character; for example, hyphens (-), asterisks (*), and slashes (/). Is all numeric or starts with one or more numerals; for example, 100 or 10Prod For a complete list of member names that must be enclosed in quotation marks, see Understanding the Rules for Naming Dimensions and Members . End each IF statement in a formula with an ENDIF statement. For example, the following formula contains a simple IF... ENDIF statement. You can apply this formula to the Commission member in a database outline: IF(Sales &lt; 100) Commission = 0; ENDIF; If you are using an IF statement nested within another IF statement, end each IF with an ENDIF, as illustrated in the following example: Opening Inventory (IF (@ISMBR(Budget)) IF (@ISMBR(Jan)) Opening Inventory = Jan; ELSE Opening Inventory = @PRIOR(Ending Inventory); ENDIF; ENDIF;) You do not need to end ELSE or ELSEIF statements with ENDIFs, as illustrated in the following example: IF (@ISMBR(@DESCENDANTS(West)) OR @ISMBR(@DESCENDANTS(East) Marketing = Marketing * 1.5; ELSEIF(@ISMBR(@DESCENDANTS(South))) Marketing = Marketing * .9; ELSE Marketing = Marketing * 1.1; ENDIF; Note: If you use ELSE IF (with a space in between) rather than ELSEIF (one word) in a formula, you must supply an ENDIF for the IF statement. Although ending ENDIF statements with a semicolon (;) is not required, it is good practice to follow each ENDIF statement in a formula with a semicolon. When writing formulas, you can check the syntax using the Formula Editor syntax checker. For a comprehensive discussion, including examples, of the main types of formulas, see Checking Formula Syntax . For detailed information on syntax for Analytic Services functions and commands, see the Technical Reference . Reviewing the Process for Creating Formulas You use Formula Editor to create formulas. Formula Editor is a tab in the Member Properties dialog box in Outline Editor. You can type the formulas directly into the formula text area, or you can use the Formula Editor user interface features to create the formula. Formulas are plain text. If required, you can create a formula in the text editor of your choice and paste it into Formula Editor. To create a formula, follow this process: In Outline Editor, select the member to which to apply the formula. Open Formula Editor. For more information, see Creating and Editing Formulas in Outlines in the Essbase Administration Services Online Help . Enter the formula text. For more information on entering the formula text in the Formula Editor, see Creating and Editing Formulas in Outlines in the Essbase Administration Services Online Help . For more information about composing the formula itself, see Composing Formulas . Check the formula syntax. For more information, see Checking Formula Syntax . Save the formula. For more information, see Creating and Editing Formulas in Outlines in the Essbase Administration Services Online Help . Save the outline. For more information, see Saving Outlines in the Essbase Administration Services Online Help . Displaying Formulas To display an existing formula, use any of the following methods: Tool Topic Location Administration Services Creating and Editing Formulas in Outlines Essbase Administration Services Online Help ESSCMD GETMBRCALC Technical Reference MaxL query database Technical Reference Composing Formulas The following sections discuss and give examples of the main types of formulas: Basic Equations Conditional Tests Examples of Conditional Tests Value-Related Formulas Member-Related Formulas Formulas That Use Various Types of Functions For detailed examples of formulas, see Reviewing Examples of Formulas. Before writing formulas, review the guidelines in Understanding Formula Syntax . Basic Equations You can apply a mathematical operation to a formula to create a basic equation. For example, you can apply the following formula to the Margin member in Sample Basic. Sales - COGS; In a calculation script, you define basic equations as follows: Member = mathematical operation; where Member is a member name from the database outline and mathematical operation is any valid mathematical operation, as illustrated in the following example: Margin = Sales - COGS; Whether the example equation is in the database outline or in a calculation script, Analytic Services cycles through the database subtracting the values in COGS from the values in Sales and placing the results in Margin. As another example, you can apply the following formula to a Markup member: (Retail - Cost) % Retail; In a calculation script, this formula is as follows: Markup = (Retail - Cost) % Retail; In this example, Analytic Services cycles through the database subtracting the values in Cost from the values in Retail, calculating the resulting values as a percentage of the values in Retail, and placing the result in Markup. For an explanation of the nature of multidimensional calculations, see About Multidimensional Calculation Concepts Conditional Tests You can define formulas that use a conditional test or a series of conditional tests to control the flow of calculation. The IF and ENDIF commands define a conditional block . The formulas between the IF and the ENDIF commands are executed only if the test returns TRUE (1). You can use the ELSE and ELSEIF commands to specify alternative actions if the test returns FALSE (0). The formulas following each ELSE command are executed only if the previous test returns FALSE (0). Conditions following each ELSEIF command are tested only if the previous IF command returns FALSE (0). For information about and examples of the syntax of the IF and ENDIF commands, see Understanding Formula Syntax . When you use a conditional formula in a calculation script, you must enclose it in parentheses and associate it with a member in the database outline, as shown in the examples in this section. In conjunction with an IF command, you can use functions that return TRUE or FALSE (1 or 0, respectively) based on the result of a conditional test. These functions are known as Boolean functions . You use Boolean functions to determine which formula to use. The decision is based on the characteristics of the current member combination. For example, you might want to restrict a certain calculation to the members in the Product dimension that contain input data. In this case, you preface the calculation with an IF test based on @ISLEV(Product,0). If one of the function parameters is a cross-dimensional member, such as @ISMBR(Sales-&gt;Budget), all of the parts of the cross-dimensional member must match the properties of the current cell to return a value of TRUE (1). You can use the following Boolean functions to specify conditions. Information You Need To Find Use This Function The current member has a specified accounts tag (for example, an Expense tag) @ISACCTYPE The current member is an ancestor of the specified member @ISANCEST The current member is an ancestor of the specified member, or the specified member itself @ISIANCEST The current member is a child of the specified member @ISCHILD The current member is a child of the specified member, or the specified member itself @ISICHILD The current member is a descendant of the specified member @ISDESC The current member is a descendant of the specified member, or the specified member itself @ISIDESC The current member of the specified dimension is in the generation specified @ISGEN The current member of the specified dimension is in the level specified @ISLEV The current member matches any of the specified members @ISMBR The current member is the parent of the specified member @ISPARENT The current member is the parent of the specified member, or the specified member itself @ISIPARENT The current member (of the same dimension as the specified member) is in the same generation as the specified member @ISSAMEGEN The current member (of the same dimension as the specified member) is in the same level as the specified member @ISSAMELEV The current member is a sibling of the specified member @ISSIBLING The current member is a sibling of the specified member, or the specified member itself @ISISIBLING A specified UDA (user-defined attribute) exists for the current member of the specified dimension @ISUDA When you place formulas on the database outline, you can use only the IF, ELSE, ELSEIF, and ENDIF commands and Boolean functions to control the flow of the calculations. You can use additional control commands in a calculation script. For information about how to develop calculation scripts and how to use them to control how Analytic Services calculates a database, see Developing Calculation Scripts. For information on individual Analytic Services functions and calculation commands, see the Technical Reference . Examples of Conditional Tests You can apply the following formula to a Commission member in the database outline. In the first example, the formula calculates commission at 1% of sales if the sales are greater than 500000: IF(Sales &gt; 500000) Commission = Sales * .01; ENDIF; If you place the formula in a calculation script, you need to associate the formula with the Commission member as follows: Commission(IF(Sales &gt; 500000) Commission = Sales * .01; ENDIF;) Analytic Services cycles through the database, performing these calculations: The IF statement checks to see if the value of Sales for the current member combination is greater than 500000. If Sales is greater than 500000, Analytic Services multiplies the value in Sales by 0.01 and places the result in Commission. In the next example, the formula tests the ancestry of the current member and then applies the appropriate Payroll calculation formula. IF(@ISIDESC(East) OR @ISIDESC(West)) Payroll = Sales * .15; ELSEIF(@ISIDESC(Central)) Payroll = Sales * .11; ELSE Payroll = Sales * .10; ENDIF; If you place the formula in a calculation script, you need to associate the formula with the Payroll member as follows: Payroll(IF(@ISIDESC(East) OR @ISIDESC(West)) Payroll = Sales * .15; ELSEIF(@ISIDESC(Central)) Payroll = Sales * .11; ELSE Payroll = Sales * .10; ENDIF;) Analytic Services cycles through the database, performing the following calculations: The IF statement uses the @ISIDESC function to check if the current member on the Market dimension is a descendant of either East or West. If the current member on the Market dimension is a descendant of East or West, Analytic Services multiplies the value in Sales by 0.15 and moves on to the next member combination. If the current member is not a descendant of East or West, the ELSEIF statement uses the @ISIDESC function to check if the current member is a descendant of Central. If the current member on the Market dimension is a descendant of Central, Analytic Services multiplies the value in Sales by 0.11 and moves on to the next member combination. If the current member is not a descendant of East, West, or Central, Analytic Services multiplies the value in Sales by 0.10 and moves on to the next member combination. For information on the nature of multidimensional calculations, see About Multidimensional Calculation Concepts . For information on the @ISIDESC function, see the Technical Reference . Value-Related Formulas Use this section to find information about formulas related to values: Using Interdependent Values Calculating Variances or Percentage Variances Between Actual and Budget Values Allocating Values Using Member Relationships to Look Up Values Using Substitution Variables Using Interdependent Values Analytic Services optimizes calculation performance by calculating formulas for a range of members in the same dimension at the same time. However, some formulas require values from members of the same dimension, and Analytic Services may not yet have calculated the required values. A good example is that of cash flow, in which the opening inventory is dependent on the ending inventory from the previous month. In Sample Basic, the Opening Inventory and Ending Inventory values need to be calculated on a month-by-month basis. . Jan Feb Mar Opening Inventory 100 120 110 Sales 50 70 100 Addition 70 60 150 Ending Inventory 120 110 160 Assuming that the Opening Inventory value for January is loaded into the database, the required calculation is as follows: 1. January Ending = January Opening - Sales + Additions 2. February Opening = January Ending 3. February Ending = February Opening - Sales + Additions 4. March Opening = February Ending 5. March Ending = March Opening - Sales + Additions You can calculate the required results by applying interdependent, multiple equations to a single member in the database outline. The following formula, applied to the Opening Inventory member in the database outline, calculates the correct values: IF(NOT @ISMBR (Jan)) Opening Inventory = @PRIOR(Ending Inventory); ENDIF; Ending Inventory = Opening Inventory - Sales + Additions; If you place the formula in a calculation script, you need to associate the formula with the Opening Inventory member as follows: Opening Inventory (IF(NOT @ISMBR (Jan)) Opening Inventory = @PRIOR(Ending Inventory); ENDIF; Ending Inventory = Opening Inventory - Sales + Additions;) Analytic Services cycles through the months, performing the following calculations: The IF statement and @ISMBR function check that the current member on the Year dimension is not Jan. This step is necessary because the Opening Inventory value for Jan is an input value. If the current month is not Jan, the @PRIOR function obtains the value for the Ending Inventory for the previous month. This value is then allocated to the Opening Inventory of the current month. The Ending Inventory is calculated for the current month. Note: To calculate the correct results, it is necessary to place the above formula on a single member, Opening Inventory. If you place the formulas for Opening Inventory and Ending Inventory on their separate members, Analytic Services calculates Opening Inventory for all months and then Ending Inventory for all months. This organization means that the value of the Ending Inventory of the previous month is not available when Opening Inventory is calculated. Calculating Variances or Percentage Variances Between Actual and Budget Values You can use the @VAR and @VARPER functions to calculate a variance or percentage variance between budget and actual values. You may want the variance to be positive or negative, depending on whether you are calculating variance for members on the accounts dimension that are expense or non-expense items: Expense items. You want Analytic Services to show a positive variance if the actual values are lower than the budget values. For example, you want Analytic Services to show a positive variance if actual costs are lower than budgeted costs. Non-expense items. You want Analytic Services to show a negative variance if the actual values are lower than the budget values. For example, you want Analytic Services to show a negative variance if actual sales are lower than budgeted sales. By default, Analytic Services assumes that members are non-expense items and calculates the variance accordingly. To tell Analytic Services that a member is an expense item, use this procedure: In Outline Editor, select the member. The member must be on the dimension tagged as accounts. Open Formula Editor. See Creating and Editing Formulas in Outlines in the Essbase Administration Services Online Help . Tag the member as an expense item. See Setting Variance Reporting Properties . When you use the @VAR or @VARPER functions, Analytic Services shows a positive variance if the actual values are lower than the budget values. For example, in Sample Basic, the children of Total Expenses are expense items. The Variance and Variance % members of the Scenario dimension calculate the variance between the Actual and Budget values. Figure 174: Sample Basic Showing Expense Items Allocating Values You can allocate values that are input at the parent level across child members in the same dimension or in different dimensions by using the following allocation functions. Allocated Values Function To Use Values from a member, cross-dimensional member, or value across a member list within the same dimension. The allocation is based on a variety of specified criteria. @ALLOCATE Values from a member, cross-dimensional member, or value across multiple dimensions. The allocation is based on a variety of specified criteria. @MDALLOCATE Note: For examples of calculation scripts using the @ALLOCATE and @MDALLOCATE functions, see Allocating Values Within or Across Dimensions and the Technical Reference . Forecasting Values You can manipulate data for the purposes of smoothing data, interpolating data, or calculating future values by using the following forecasting functions. Data Manipulation Function To Use To apply a moving average to a data set and replace each term in the list with a trailing average. This function modifies the data set for smoothing purposes. @MOVAVG To apply a moving maximum to a data set and replace each term in the list with a trailing maximum. This function modifies the data set for smoothing purposes. @MOVMAX To apply a moving median to a data set and replace each term in the list with a trailing median. This function modifies the data set for smoothing purposes. @MOVMED To apply a moving minimum to a data set and replace each term in the list with a trailing minimum. This function modifies the data set for smoothing purposes. @MOVMIN To apply a moving sum to a data set and replace each term with a trailing sum. This function modifies the data set for smoothing purposes. @MOVSUM To apply a moving sum to a data set and replace each term with a trailing sum. Specify how to assign values to members before you reach the number to sum. This function modifies the data set for smoothing purposes. @MOVSUMX To apply a smoothing spline to a set of data points. A spline is a mathematical curve that is used to smooth or interpolate data. @SPLINE To calculate future values and base the calculation on curve-fitting to historical values. @TREND For information about specific Analytic Services functions, see the Technical Reference . Using Member Relationships to Look Up Values You can use the member combination that Analytic Services is currently calculating to look up specific values. These functions are referred to as relationship functions. Look-up Value Function To Use The ancestor values of the specified member combination @ANCESTVAL The numeric value of the attribute from the specified numeric or date attribute dimension associated with the current member @ATTRIBUTEVAL The text value of the attribute from the specified text attribute dimension associated with the current member @ATTRIBUTESVAL The value (TRUE or FALSE) of the attribute from the specified Boolean attribute dimension associated with the current member @ATTRIBUTEBVAL The generation number of the current member combination for the specified dimension @CURGEN The level number of the current member combination for the specified dimension @CURLEV The generation number of the specified member @GEN The level number of the specified member @LEV The ancestor values of the specified member combination across multiple dimensions @MDANCESTVAL The shared ancestor values of the specified member combination @SANCESTVAL The parent values of the specified member combination @PARENTVAL The parent values of the specified member combination across multiple dimensions @MDPARENTVAL The shared parent values of the specified member combination @SPARENTVAL A data value from another database to be used for calculation of a value from the current database @XREF For information about specific Analytic Services functions, see the Technical Reference . Using Substitution Variables Substitution variables act as placeholders for information that changes regularly; for example, time period information. You can use substitution variables in formulas that you include in a calculation script. You cannot use substitution variables in formulas that you apply to the database outline. When you run a calculation script, Analytic Services replaces the substitution variable with the value you have assigned to it. You can create and assign values to substitution variables using Essbase Administration Services or ESSCMD. You can set substitution variables at the server, application, and database levels. Analytic Services must be able to access the substitution variable from the application and database on which you are running the calculation script. For information on creating and assigning values to substitution variables, see Using Substitution Variables . To use a substitution variable in a calculation script, type an ampersand ( &amp; ) followed by the substitution variable name. Analytic Services treats any text string preceded by &amp; as a substitution variable. For example, assume that the substitution variable UpToCurr is defined as Jan:Jun. You can use the following @ISMBR function as part of a conditional test in a calculation script: @ISMBR(&amp;UpToCurr) Before Analytic Services runs the calculation script, it replaces the substitution variable, as follows: @ISMBR(Jan:Jun) Member-Related Formulas This section provides information you need to create formulas that refer to members: Specifying Member Lists and Ranges Generating Member Lists Manipulating Member Names Working with Member Combinations across Dimensions Specifying Member Lists and Ranges In some functions you may need to specify more than one member, or you may need to specify a range of members. For example, the @ISMBR function tests to see if a member that is currently being calculated matches any of a list or range of specified members. You can specify members using the following syntax: Member List or Range Syntax A single member The member name. For example: Mar2001 A list of members A comma-delimited (,) list of member names. For example: Mar2001, Apr2001, May2001 A range of all members at the same level, between and including the two defining members The two defining member names separated by a colon (:). For example: Jan2000:Dec2000 A range of all members in the same generation, between and including the two defining members The two defining member names separated by two colons (::). For example: Q1_2000::Q4_2000 A function-generated list of members or a range of members For a list of member list contents and corresponding functions, see Generating Member Lists . A combination of ranges and list Separate each range, list, and function with a comma (,). For example: Q1_97::Q4_98, FY99, FY2000 or @SIBLINGS(Dept01), Dept65:Dept73, Total_Dept If you do not specify a list of members or a range of members in a function that requires either, Analytic Services uses the level 0 members of the dimension tagged as time. If no dimension is tagged as time, Analytic Services displays an error message. Generating Member Lists You can generate member lists that are based on a specified member by using the these member set functions. Contents of Member List Function All ancestors of the specified member, including ancestors of the specified member as a shared member. This function does not include the specified member. @ALLANCESTORS All ancestors of the specified member, including ancestors of the specified member as a shared member. This function includes the specified member. @IALLANCESTORS The ancestor of the specified member at the specified generation or level. @ANCEST All ancestors of the specified member (optionally up to the specified generation or level) but not the specified member. @ANCESTORS All ancestors of the specified member (optionally up to the specified generation or level) including the specified member. @IANCESTORS All children of the specified member, but not including the specified member. @CHILDREN All children of the specified member, including the specified member. @ICHILDREN The current member being calculated for the specified dimension. @CURRMBR All descendants of the specified member (optionally up to the specified generation or level), but not the specified member nor descendants of shared members. @DESCENDANTS All descendants of the specified member (optionally up to the specified generation or level), including the specified member, but not descendants of shared members. @IDESCENDANTS All descendants of the specified member (optionally up to the specified generation or level), including descendants of shared members, but not the specified member. @RDESCENDANTS All descendants of the specified member (optionally up to the specified generation or level), including the specified member and descendants of shared members. @IRDESCENDANTS All members of the specified generation in the specified dimension. @GENMBRS All members of the specified level in the specified dimension. @LEVMBRS All siblings of the specified member, but not the specified member. @SIBLINGS All siblings of the specified member, including the specified member. @ISIBLINGS All siblings that precede the specified member in the database outline, but not the specified member. @LSIBLINGS All siblings that follow the specified member in the database outline, but not the specified member. @RSIBLINGS All siblings that precede the specified member in the database outline, including the specified member. @ILSIBLINGS All siblings that follow the specified member in the database outline, including the specified member. @IRSIBLINGS Separate lists of members to be processed by functions that require multiple list arguments. @LIST The member with the name that is provided as a character string. @MEMBER A merged list of two member lists to be processed by another function. @MERGE A member list that crosses the specified member from one dimension with the specified member range from another dimension. @RANGE A member list the identifies all shared members among the specified members. @SHARE A member list that identifies the range of members using the level of the arguments, determining the cross product of all members in the range, and pruning the set to include only the range requested. @XRANGE A list of members from which some members have been removed. @REMOVE All members that match the specified wildcard selection. @MATCH The parent of the current member being calculated in the specified dimension. @PARENT All members of the specified generation or level that are above or below the specified member. @RELATIVE All members that have a common (UDA) user-defined attribute defined on Analytic Server. @UDA All base-dimension members that are associated with the specified attribute-dimension member. @ATTRIBUTE All base members that are associated with attributes that satisfy the specified conditions. @WITHATTR For information about specific Analytic Services functions, see the Technical Reference . Manipulating Member Names You can work with member names as character strings by using the following functions: Character String Manipulation Function To Use To create a character string that is the result of appending a member name or specified character string to another member name or character string @CONCATENATE To return a member name as a string @NAME To return a substring of characters from another character string or from a member name @SUBSTRING Working with Member Combinations across Dimensions Use the cross-dimensional operator to point to data values of specific member combinations. Create the cross-dimensional operator using a hyphen (-) and a greater than symbol (&gt;). Do not leave spaces in between the cross-dimensional operator and the member names. For example, in this simplified illustration, the shaded data value is Sales -&gt; Jan -&gt; Actual. Figure 175: Defining a Single Data Value by Using the Cross-Dimensional Operator The following example illustrates how to use the cross-dimensional operator. This example allocates miscellaneous expenses to each product in each market. The value of Misc_Expenses for all products in all markets is known. The formula allocates a percentage of the total Misc_Expenses value to each Product -&gt; Market combination. The allocation is based on the value of Sales for each product in each market. Misc_Expenses = Misc_Expenses-&gt;Market-&gt;Product * (Sales/(Sales-&gt;Market-&gt;Product)); Analytic Services cycles through the database, performing these calculations: Analytic Services divides the Sales value for the current member combination by the total Sales value for all markets and all products (Sales -&gt; Market -&gt; Product). It multiplies the value calculated in step 1 by the Misc_Expenses value for all markets and all products (Misc_Expenses -&gt; Market -&gt; Product). It allocates the result to Misc_Expenses for the current member combination. Consider carefully how you use the cross-dimensional operator, as it can have significant performance implications. For information about optimizing and the cross-dimensional operator, see Using Cross-Dimensional Operators (-&gt;) . Formulas That Use Various Types of Functions Use this section to find information about formulas that use other types of formulas: Mathematical Operations Statistical Functions Range Functions Financial Functions Date and Time Functions Calculation Mode Functions Custom-Defined Functions Mathematical Operations You can perform many mathematical operations in formulas by using the following mathematical functions. Operation Function To return the absolute value of an expression @ABS To return the average value of the values in the specified member list @AVG To return the value of e (the base of natural logarithms) raised to power of the specified expression @EXP To return the factorial of an expression @FACTORIAL To return the next lowest integer value of a member or expression @INT To return the natural logarithm of a specified expression @LN To return the logarithm to a specified base of a specified expression @LOG To return the base-10 logarithm of a specified expression @LOG10 To return the maximum value among the expressions in the specified member list @MAX To return the maximum value among the expressions in the specified member list, with the ability to skip zero and #MISSING values @MAXS To return the minimum value among the expressions in the specified member list @MIN To return the minimum value among the expressions in the specified member list, with the ability to skip zero and #MISSING values @MINS To return the modulus produced by the division of two specified members @MOD To return the value of the specified member raised to the specified power @POWER To return the remainder value of an expression @REMAINDER To return the member or expression rounded to the specified number of decimal places @ROUND To return the summation of values of all specified members @SUM To return the truncated value of an expression @TRUNCATE To return the variance (difference) between two specified members. See Calculating Variances or Percentage Variances Between Actual and Budget Values . @VAR To return the percentage variance (difference) between two specified members. See Calculating Variances or Percentage Variances Between Actual and Budget Values . @VARPER For information about specific Analytic Services functions, see the Technical Reference . Statistical Functions You can use these statistical functions to calculate advanced statistics in Analytic Services. Calculated Value Function to Use The correlation coefficient between two parallel data sets @CORRELATION The number of values in the specified data set @COUNT The median, or middle number, in the specified data set @MEDIAN The mode, or the most frequently occurring value, in the specified data set @MODE The rank of the specified member or value in the specified data set @RANK The standard deviation, based upon a sample, of the specified members @STDEV The standard deviation, based upon the entire population, of the specified members @STDEVP The standard deviation, crossed with a range of members, of the specified members @STDEVRANGE The variance, based upon a sample, of the specified data set @VARIANCE The variance, based upon the entire population, of the specified data set @VARIANCEP For information about specific Analytic Services functions, see the Technical Reference . Range Functions You can execute a function for a range of members by using these range functions. Calculation Function to Use The average value of a member across a range of members @AVGRANGE A range of members that is based on the relative position of the member combination Analytic Services is currently calculating. @CURRMBRRANGE The maximum value of a member across a range of members @MAXRANGE The maximum value of a member across a range of members, with the ability to skip zero and #MISSING values @MAXSRANGE The next or n th member in a range of members, retaining all other members identical to the current member across multiple dimensions @MDSHIFT The minimum value of a member across a range of members @MINRANGE The minimum value of a member across a range of members, with the ability to skip zero and #MISSING values @MINSRANGE The next or n th member in a range of members. @NEXT The next or n th member in a range of members, with the option to skip #MISSING , zero, or both values. @NEXTS The previous or n th previous member in a range of members @PRIOR The previous or n th previous member in a range of members, with the option to skip #MISSING, zero, or both values. @PRIORS The next or n th member in a range of members, retaining all other members identical to the current member and in the specified dimension @SHIFT In some cases, @SHIFTPLUS or @SHIFTMINUS. The summation of values of all specified members across a range of members @SUMRANGE For information about specific Analytic Services functions, see the Technical Reference . Financial Functions You can include financial calculations in formulas by using these financial functions. Calculation Function To Use An accumulation of values up to the specified member @ACCUM The proceeds of a compound interest calculation @COMPOUND A series of values that represent the compound growth of the specified member across a range of members @COMPOUNDGROWTH Depreciation for a specific period, calculated using the declining balance method. @DECLINE A value discounted by the specified rate, from the first period of the range to the period in which the amount to discount is found @DISCOUNT A series of values that represents the linear growth of the specified value @GROWTH The simple interest for a specified member at a specified rate @INTEREST The internal rate of return on a cash flow @IRR The Net Present Value of an investment (based on a series of payments and incomes) @NPV The period-to-date values of members in the dimension tagged as time @PTD The amount per period that an asset in the current period may be depreciated (calculated across a range of periods). The depreciation method used is straight-line depreciation. @SLN The amount per period that an asset in the current period may be depreciated (calculated across a range of periods). The depreciation method used is sum of the year's digits. @SYD For information about specific Analytic Services functions, see the Technical Reference . Date and Time Functions You can use dates with other functions by using this date function. Date Conversion Function To Use Convert date strings to numbers that can be used in calculation formulas @TODATE Calculation Mode Functions You can specify which calculation mode that Analytic Services uses to calculate a formula by using @CALCMODE. Specification Function To Use To specify that Analytic Services uses cell, block, bottom-up, and top-down calculation modes to calculate a formula. @CALCMODE Note: You can also use the configuration setting CALCMODE to set calculation modes to BLOCK or BOTTOMUP at the database, application, or server level. For details, see the Technical Reference , under essbase.cfg Settings for CALCMODE or Analytic Services Functions for @CALCMODE. Custom-Defined Functions Custom-defined functions are calculation functions that you create to perform calculations not otherwise supported by the Analytic Services calculation scripting language. You can use custom-defined functions in formulas and calculation scripts. These custom-developed functions are written in the Java programming language and registered on the Analytic Server. The Analytic Services calculator framework calls them as external functions. Custom-defined functions are displayed in the functions tree in Calculation Script Editor. From this tree, you can select a custom-defined function to insert into a formula. For a detailed explanation of how to develop and use custom-defined functions, see Developing Custom-Defined Calculation Functions. Checking Formula Syntax Analytic Services includes Analytic Server-based formula syntax checking that tells you about syntax errors in formulas. For example, Analytic Services tells you if you have mistyped a function name. Unknown names can be validated against a list of custom-defined macro and function names. If you are not connected to a server or the application associated with the outline, Analytic Services may connect you to validate unknown names. A syntax checker cannot tell you about semantic errors in a formula. Semantic errors occur when a formula does not work as you expect. To find semantic errors, run the calculation and check the results to ensure that they are as you expect. Analytic Services displays the syntax checker results at the bottom of the Formula Editor. If Analytic Services finds no syntax errors, it displays the No errors message. If Analytic Services finds one or more syntax errors, it displays the number of the line that includes the error and a brief description of the error. For example, if you do not include a semicolon end-of-line character at the end of a formula, Analytic Services displays a message similar to the message shown in Figure176 . Figure 176: Formula Editor Syntax Checker, Syntax Error Message Error: line 1: invalid statement; expected semicolon If a formula passes validation in Formula Editor or Outline Editor, but Analytic Server detects semantic errors when the outline is saved, check the following: The incorrect formula is saved as part of the outline, even though it contains errors. Analytic Server writes a message in the application log that indicates what the error is and displays the incorrect formula. Analytic Server writes an error message to the comment field of the member associated with the incorrect formula. The message indicates that the incorrect formula was not loaded. You can view this comment in Outline Editor by closing and reopening the outline. If you do not correct the member formula, and a calculation that includes that member is run, the formula is ignored during the calculation. After you have corrected the formula and saved the outline, the message in the member comment is deleted. You can view the updated comment when you reopen the outline. To check formula syntax, see Creating and Editing Formulas in Outlines in the Essbase Administration Services Online Help . Estimating Disk Size for a Calculation You can estimate the disk size required for a single CALC ALL given either a full data load or a partial data load. For more information, see Estimating Calculation Affects on Database Size . To estimate disk size for a calculation, see ESTIMATEFULLDBSIZE in the Technical Reference . Using Formulas in Partitions An Analytic Services partition can span multiple Analytic Servers, processors, or computers. For a comprehensive discussion of partitioning, see Designing Partitioned Applications and Creating and Maintaining Partitions . You can use formulas in partitioning, just as you use formulas on your local database. However, if a formula you use in one database references a value from another database, Analytic Services has to retrieve the data from the other database when calculating the formula. In this case, you need to ensure that the referenced values are up-to-date and to consider carefully the performance impact on the overall database calculation. For a discussion of how various options affect performance, see Writing Calculation Scripts for Partitions . With transparent partitions, you need to consider carefully how you use formulas on the data target. For a detailed example of the relationship between member formulas and transparent partitioning, see Transparent Partitions and Member Formulas . For a discussion of the performance implications, see Performance Considerations for Transparent Partition Calculations .  |../dcadevfo.htm",
    "Dynamically Calculating Data Values||This chapter explains how you calculate data values dynamically in block storage databases and how you benefit from doing so. Dynamically calculating some of the values in a database can significantly improve the performance of an overall database calculation. This chapter is not relevant to aggregate storage databases. The information in this chapter assumes that you are familiar with the concepts of member combinations, dense and sparse dimensions, and data blocks. For a comprehensive discussion of these concepts, see Understanding Multidimensional Databases. This chapter includes the following sections: Understanding Dynamic Calculation Benefitting from Dynamic Calculation Using Dynamic Calculation Choosing Values to Calculate Dynamically Understanding How Dynamic Calculation Changes Calculation Order Reducing the Impact on Retrieval Time Using Dynamic Calculations with Standard Procedures Creating Dynamic Calc and Dynamic Calc and Store Members Restructuring Databases Dynamically Calculating Data in Partitions Understanding Dynamic Calculation When you design the overall database calculation, it may be more efficient to calculate some member combinations when you retrieve their data, instead of pre-calculating the member combinations during a batch database calculation. In Analytic Services, you can define a member to have a dynamic calculation . This definition tells Analytic Services to calculate a data value for the member as users request it. Dynamic calculation shortens batch database calculation time, but may increase retrieval time for the dynamically calculated data values. See Reducing the Impact on Retrieval Time for information on how to analyze and manage the effect of dynamic calculation. In Analytic Services you specify dynamic calculations on a per-member basis. You can define a member in the database outline as one of two types of a dynamically calculated member: Dynamic Calc Dynamic Calc and Store Use the rest of this section to gain a basic understanding of dynamic calculation: Understanding Dynamic Calc Members Understanding Dynamic Calc and Store Members Retrieving the Parent Value of Dynamically Calculated Child Values Understanding Dynamic Calc Members For a member that is tagged as Dynamic Calc, Analytic Services does not calculate its data value during a batch database calculation; for example, during a CALC ALL. Instead, Analytic Services calculates the data value upon retrieval; for example, when you retrieve the data into Spreadsheet Add-in or Spreadsheet Services. Specifically, Analytic Services calculates a data value dynamically when you request the data value in either of two ways: By retrieving the data value into Spreadsheet Add-in or Spreadsheet Services By running a report script that displays the data value Analytic Services does not store the calculated value; it recalculates the value for each subsequent retrieval. Understanding Dynamic Calc and Store Members Analytic Services calculates the data value for a member that is tagged as Dynamic Calc and Store when you retrieve the data, in the same way as for a Dynamic Calc member. For a Dynamic Calc and Store member, however, Analytic Services stores the data value that is calculated dynamically. Subsequent retrievals of that data value do not require recalculation, unless Analytic Services detects that the value needs recalculating. Recalculation of Data When Analytic Services detects that the data value for a Dynamic Calc and Store member needs recalculating, it places an indicator on the data block that contains the value, so that Analytic Services knows to recalculate the block on the next retrieval of the data value. Analytic Services places the indicator on the data block containing the value and not on the data value itself. In other words, Analytic Services tracks Dynamic Calc and Store members at the data block level. For detailed information on data blocks, see Data Blocks and the Index System . If the data block needs recalculating, Analytic Services detects the need and places an indicator on the data block when any of the following occur: You perform a batch calculation. You restructure the database. You use the CLEARBLOCK DYNAMIC calculation command. For more information on the CLEARBLOCK command, see the Technical Reference . Analytic Services recalculates the indicated data blocks when you next retrieve the data value. Effect of Updated Values on Recalculation Analytic Services does not detect that a data block needs recalculating and does not place an indicator on the data block when you update the data; that is, updated blocks are recalculated only during the next batch calculation. Consider the following two scenarios: You do a data load. You do a Lock and Send from Spreadsheet Services. If you load data into the children of a Dynamic Calc and Store member, and the member is a consolidation of its child members, Analytic Services does not know to recalculate the Dynamic Calc and Store member during the next retrieval. The parent member is recalculated only during the next batch calculation. After loading data, you need to perform a batch calculation of the database or use the CLEARBLOCK DYNAMIC calculation command to ensure that the Dynamic Calc and Store members are recalculated. For more information on the CLEARBLOCK command, see the Technical Reference . Retrieving the Parent Value of Dynamically Calculated Child Values If you retrieve a parent value that is calculated from Dynamic Calc or Dynamic Calc and Store child members, Analytic Services must dynamically calculate the child member combinations before calculating the parent value. Analytic Services does not store the child values, even if they are Dynamic Calc and Store members. For example, assume that Market is a parent member and that East and West are Dynamic Calc and Store child members that consolidate up to Market. When you retrieve a data value for Market, Analytic Services calculates East and West, even though you have not specifically retrieved them. However, Analytic Services does not store the values of East or West. Benefitting from Dynamic Calculation Dynamically calculating some database values can significantly improve the performance of an overall database calculation. Calculating some data values dynamically, achieves the following advantages: It reduces the batch calculation time of the database because Analytic Services has fewer member combinations to calculate. It reduces disk usage because Analytic Services stores fewer calculated data values. Database size and index size are reduced. It reduces database restructure time. For example, adding or deleting a Dynamic Calc member in a dense dimension does not change the data block size, and so Analytic Services does not need to restructure the database for such additions and deletions. For an explanation of the relationship between the use of Dynamic Calc members and database restructures, see Restructuring Databases . It reduces the time that is required to back up the database. Because database size is reduced, Analytic Services takes less time to perform a backup. Data values that Analytic Services calculates dynamically can take longer to retrieve. You can estimate the retrieval time for dynamically calculated members. For information on how to analyze and manage the effect of dynamic calculation, see Reducing the Impact on Retrieval Time . Using Dynamic Calculation You can tag any member as Dynamic Calc or Dynamic Calc and Store, except the following: Level 0 members that do not have a formula Label-Only members Shared members Which members you choose to calculate dynamically depends on the database structure and on the balance between (1) the need for reduced calculation time and disk usage and (2) the need for speedy data retrieval for users. For guidelines on choosing which members to calculate dynamically, see Choosing Values to Calculate Dynamically . Outline Editor shows which members are Dynamic Calc and which members are Dynamic Calc and Store. Figure 189: Sample Basic Outline Showing Dynamic Calc Members In Spreadsheet Add-in or Spreadsheet Services, users can display visual cues to distinguish dynamically calculated values. For more information, see the Spreadsheet online help. When developing spreadsheets that include dynamically calculated values, spreadsheet designers may want to use the spreadsheet Navigate Without Data option, so that Analytic Services does not dynamically calculate and store values while test spreadsheets are being built. Choosing Values to Calculate Dynamically Dynamically calculating some data values decreases calculation time, lowers disk usage, and reduces database restructure time, but increases retrieval time for dynamically calculated data values. Use the guidelines described in the following sections when deciding which members to calculate dynamically: Dense Members and Dynamic Calculation Sparse Members and Dynamic Calculation Two-Pass Members and Dynamic Calculation Parent-Child Relationships and Dynamic Calculation Calculation Scripts and Dynamic Calculation Formulas and Dynamically Calculated Members Dynamically Calculated Children Choosing Between Dynamic Calc and Dynamic Calc and Store Dense Members and Dynamic Calculation Consider making the following changes to members of dense dimensions: Tag upper level members of dense dimensions as Dynamic Calc. Try tagging level 0 members of dense dimensions with simple formulas as Dynamic Calc, and assess the increase in retrieval time. Do not tag members of dense dimensions as Dynamic Calc and Store. Simple formulas are formulas that do not require Analytic Services to perform an expensive calculation. Formulas containing, for example, financial functions or cross-dimensional operators (-&gt;) are complex formulas. Sparse Members and Dynamic Calculation Consider making the following changes to members of sparse dimensions: Tag some upper level members of sparse dimensions that have six or fewer children as Dynamic Calc or Dynamic Calc and Store. Tag sparse-dimension members with complex formulas as Dynamic Calc or Dynamic Calc and Store. A complex formula requires Analytic Services to perform an expensive calculation. For example, any formula that contains a financial function is a complex formula. For a discussion of complex formulas (definition, guidelines for use, and effect on performance), see Using Complex Formulas . Tag upper level members in a dimension that you frequently restructure as Dynamic Calc or Dynamic Calc and Store. Do not tag upper level, sparse-dimension members that have 20 or more descendants as Dynamic Calc or Dynamic Calc and Store. For recommendations in regard to use of Dynamic Calc and Dynamic Calc And Store, see Choosing Between Dynamic Calc and Dynamic Calc and Store . Two-Pass Members and Dynamic Calculation To reduce the amount of time needed to perform batch calculations, tag two-pass members as Dynamic Calc. You can tag any Dynamic Calc or Dynamic Calc and Store member as two-pass, even if the member is not on an accounts dimension. For a comprehensive discussion of two-pass calculation, see Using Two-Pass Calculation . For details about the interaction of members tagged as two-pass and attribute members, see Comparing Attribute and Standard Dimensions . Parent-Child Relationships and Dynamic Calculation If a parent member has a single child member and you tag the child as Dynamic Calc, you must tag the parent as Dynamic Calc. Similarly, if you tag the child as Dynamic Calc and Store, you must tag the parent as Dynamic Calc and Store. However, if a parent member has a single child member and the parent is a Dynamic Calc or Dynamic Calc and Store member, you do not have to tag the child as Dynamic Calc or Dynamic Calc and Store. Calculation Scripts and Dynamic Calculation When Analytic Services calculates, for example, a CALC ALL or CALC DIM statement in a calculation script, it bypasses the calculation of Dynamic Calc and Dynamic Calc and Store members. Similarly, if a member set function (for example, @CHILDREN or @SIBLINGS) is used to specify the list of members to calculate, Analytic Services bypasses the calculation of any Dynamic Calc or Dynamic Calc and Store members in the resulting list. If you specify a Dynamic Calc or Dynamic Calc and Store member explicitly in a calculation script, the calculation script fails. You cannot do a calculation script calculation of a Dynamic Calc or Dynamic Calc and Store member. If you want to use a calculation script to calculate a member explicitly, do not tag the member as Dynamic Calc. For example, the following calculation script is valid only if Qtr1 is not a Dynamic Calc member: FIX (East, Colas) Qtr1; ENDFIX Formulas and Dynamically Calculated Members You can include a dynamically calculated member in a formula when you apply the formula to the database outline. For example, if Qtr1 is a Dynamic Calc member, you can place the following formula on Qtr1 in the database outline: Qtr1 = Jan + Feb; You cannot make a dynamically calculated member the target of a formula calculation in a calculation script; Analytic Services does not reserve memory space for a dynamically calculated value and, therefore, cannot assign a value to it. For example, if Qtr1 is a Dynamic Calc or Dynamic Calc and Store member, Analytic Services displays a syntax error if you include the following formula in a calculation script: Qtr1 = Jan + Feb; However, if Qtr1 is a Dynamic Calc or Dynamic Calc and Store member and Year is neither Dynamic Calc nor Dynamic Calc and Store, you can use the following formula in a calculation script: Year = Qtr1 + Qtr2; This formula is valid because Analytic Services is not assigning a value to the dynamically calculated member. Note: When you reference a dynamically calculated member in a formula in the database outline or in a calculation script, Analytic Services interrupts the regular calculation to do the dynamic calculation. This interruption can significantly lower calculation performance. Dynamically Calculated Children If the calculation of a member depends on the calculation of Dynamic Calc or Dynamic Calc and Store child members, Analytic Services has to calculate the child members first during the batch database calculation in order to calculate the parent. Therefore, there is no reduction in regular calculation time. This requirement applies to members of sparse dimensions and members of dense dimensions. For example, consider the following outline: Figure 190: Sample Basic Outline, Showing Qtr1 as a Dynamic Calc Member Qtr1 is a Dynamic Calc member. Its children, Jan, Feb, and Mar, are not dynamic members, and its parent, Year, is not a dynamic member. When Analytic Services calculates Year during a batch database calculation, it must consolidate the values of its children, including Qtr1. Therefore, it must take the additional time to calculate Qtr1 even though Qtr1 is a Dynamic Calc member. Choosing Between Dynamic Calc and Dynamic Calc and Store In most cases you can optimize calculation performance and lower disk usage by using Dynamic Calc members instead of Dynamic Calc and Store members. However, in specific situations, using Dynamic Calc and Store members is optimal: Recommendations for Sparse Dimension Members Recommendations for Members with Specific Characteristics Recommendations for Dense Dimension Members Recommendations for Data with Many Concurrent Users Recommendations for Sparse Dimension Members In most cases, when you want to calculate a sparse dimension member dynamically, tag the member as Dynamic Calc instead of Dynamic Calc and Store. When Analytic Services calculates data values for a member combination that includes a Dynamic Calc member, Analytic Services calculates only the requested values of the relevant data block. These values can be a subset of the data block. However, when Analytic Services calculates data values for a member combination that includes a Dynamic Calc and Store member, Analytic Services needs to calculate and store the whole data block, even if the requested data values are a subset of the data block. Thus, the calculation takes longer and the initial retrieval time is greater. Analytic Services stores only the data blocks that contain the requested data values. If Analytic Services needs to calculate any intermediate data blocks in order to calculate the requested data blocks, it does not store the intermediate blocks. Calculating the intermediate data blocks can significantly increase the initial retrieval time. For example, in the Sample Basic database, Market and Product are the sparse dimensions. Assume that Market and the children of Market are Dynamic Calc and Store members. When a user retrieves the data value for the member combination Market -&gt; Cola -&gt; Jan -&gt; Actual -&gt; Sales, Analytic Services calculates and stores the Market -&gt; Cola data block. In order to calculate and store Market -&gt; Cola, Analytic Services calculates the intermediate data blocks-East-&gt; Cola, West -&gt; Cola, South -&gt; Cola, and Central -&gt; Cola. Analytic Services does not store these intermediate data blocks. Recommendations for Members with Specific Characteristics Using Dynamic Calc and Store may slow initial retrieval; however, subsequent retrievals are faster than for Dynamic Calc members. Use Dynamic Calc and Store instead of Dynamic Calc for the following members: An upper-level sparse dimension member with children on a remote database. Analytic Services needs to retrieve the value from the remote database, which increases retrieval time. For a detailed explanation of this situation, see Dynamically Calculating Data in Partitions . A sparse dimension member with a complex formula. A complex formula requires Analytic Services to perform an expensive calculation. For example, any formula that contains a financial function or a cross-dimensional member is a complex formula. If users frequently retrieve an upper level member of a sparse dimension, speedy retrieval time is very important. For example, in the Sample Basic database, if most users retrieve data at the Market level, you probably want to tag Market as Dynamic Calc and Store and its children as Dynamic Calc. Figure 191: Sample Basic Outline, Market is Dynamic Calc and Store Member Recommendations for Dense Dimension Members Use Dynamic Calc members for dense dimension members. Defining members as Dynamic Calc and Store on a dense dimension provides only a small decrease in retrieval time and in batch calculation time. In addition, database size (disk usage) does not decrease significantly because Analytic Services reserves space in the data block for the data values of the member. Recommendations for Data with Many Concurrent Users Use Dynamic Calc members for data with concurrent users. If many users are concurrently retrieving Analytic Services data, the initial retrieval time for Dynamic Calc and Store members can be significantly higher than for Dynamic Calc members. Dynamic Calc and Store member retrieval time increases as the number of concurrent user retrievals increases. However, Dynamic Calc member retrieval time does not increase as concurrent user retrievals increase. If many users are concurrently accessing data, you may see significantly lower retrieval times if you use Dynamic Calc members instead of Dynamic Calc and Store members. Understanding How Dynamic Calculation Changes Calculation Order Using dynamically calculated data values changes the order in which Analytic Services calculates the values and can have implications for the way you administer a database: Calculation Order for Dynamic Calculation Calculation Order for Dynamically Calculating Two-Pass Members Calculation Order for Asymmetric Data Calculation Order for Dynamic Calculation When Analytic Services dynamically calculates data values, it calculates the data in an order that is different from the batch database calculation order. For detailed information on calculation order when dynamic calculation is not used, see Defining Calculation Order. During batch calculations, Analytic Services calculates the database in this order: Dimension tagged as accounts Dimension tagged as time Other dense dimensions (in the order they appear in the database outline) Other sparse dimensions (in the order they appear in the database outline) Two-pass calculations For dynamically calculated values, on retrieval, Analytic Services calculates the values by calculating the database in the following order: Sparse dimensions If the dimension tagged as time is sparse and the database outline uses time series data, Analytic Services bases the sparse calculation on the time dimension. Otherwise, Analytic Services bases the calculation on the dimension that it normally uses for a batch calculation. Dense dimensions Dimension tagged as accounts, if dense Dimension tagged as time, if dense Time series calculations Remaining dense dimensions Two-pass calculations Attributes Note: If your data retrieval uses attribute members, the last step in the calculation order is the summation of the attributes. However, the use of attribute members in your query causes Analytic Services to disregard the value of the Time Balance member in the dynamic calculations. During retrievals that do not use attributes, the value of the Time Balance member is applied to the calculations.The difference in calculation procedure between the use and non-use of attribute members generates different results for any upper level time members that are dynamically calculated. During retrievals that do not use attributes, these dynamically calculated members are calculated in the last step and, therefore, apply the time balance functionality properly. However, during retrievals that do use attributes the summation of the attribute is the last step applied. The difference in calculation order produces two different, predictable results for upper level time members that are dynamically calculated. Calculation Order for Dynamically Calculating Two-Pass Members Consider the following information to ensure that Analytic Services produces the required calculation result when it dynamically calculates data values for members that are tagged as two-pass. For a comprehensive discussion of two-pass calculations, see Using Two-Pass Calculation . If more than one Dynamic Calc or Dynamic Calc and Store dense dimension member is tagged as two-pass, Analytic Services performs the dynamic calculation in the first pass, and then calculates the two-pass members in the following order: Two-pass members in the accounts dimension, if any exist. Two-pass members in the time dimension, if any exist. Two-pass members in the remaining dense dimensions in the order in which the dimensions appear in the outline. For example, in the Sample Basic database, assume the following: Margin% in the dense Measures dimension (the dimension tagged as accounts) is tagged as both Dynamic Calc and two-pass. Variance in the dense Scenario dimension is tagged as both Dynamic Calc and two-pass. Analytic Services calculates the accounts dimension member first. So, Analytic Services calculates Margin% (from the Measures dimension) and then calculates Variance (from the Scenario dimension). If Scenario is a sparse dimension, Analytic Services calculates Variance first, following the regular calculation order for dynamic calculations. For a description of calculation order for dynamic calculations, see Calculation Order for Dynamic Calculation . Analytic Services then calculates Margin%. This calculation order does not produce the required result because Analytic Services needs to calculate Margin % -&gt; Variance using the formula on Margin %, and not the formula on Variance. You can avoid this problem by making Scenario a dense dimension. This problem does not occur if the Measures dimension (the accounts dimension) is sparse, because Analytic Services still calculates Margin% first. Calculation Order for Asymmetric Data Because the calculation order used for dynamic calculations differs from the calculation order used for batch database calculations, in some database outlines you may get different calculation results if you tag certain members as Dynamic Calc or Dynamic Calc and Store. These differences happen when Analytic Services dynamically calculates asymmetric data. Symmetric data calculations produce the same results no matter which dimension is calculated. Asymmetric data calculations calculate differently along different dimensions. Table 25: Example of a Symmetric Calculation Time -&gt; Accounts Jan Feb Mar Qtr1 Sales 100 200 300 600 COGS 50 100 150 300 Profit (Sales - COGS) 50 100 150 300 The calculation for Qtr1-&gt; Profit produces the same result whether you calculate along the dimension tagged as time or the dimension tagged as accounts. Calculating along the time dimension, add the values for Jan, Feb, and Mar: 50+100+150=300 Calculating along the accounts dimension, subtract Qtr1 -&gt; COGS from Qtr1 -&gt; Sales: 600-300=300 Table 26: Example of an Asymmetric Calculation Market -&gt; Accounts New York Florida Connecticut East UnitsSold 10 20 20 50 Price 5 5 5 15 Sales (Price * UnitsSold) 50 100 100 250 The calculation for East -&gt; Sales produces the correct result when you calculate along the Market dimension, but produces an incorrect result when you calculate along the accounts dimension. Calculating along the Market dimension, adding the values for New York, Florida, and Connecticut produces the correct results: 50+100+100=250 Calculating along the accounts dimension, multiplying the value East -&gt; Price by the value East -&gt; UnitsSold produces incorrect results: 15 * 50=750 In this outline, East is a sparse dimension, and Accounts is a dense dimension: If East and Sales are tagged as Dynamic Calc, then Analytic Services calculates a different result than it does if East and Sales are not tagged as Dynamic Calc. If East and Sales are not Dynamic Calc members, Analytic Services produces the correct result by calculating as follows: The dense Accounts dimension, calculating the values for UnitsSold, Price, and Sales for New York, Florida, and Connecticut. The sparse East dimension, by aggregating the calculated values for UnitsSold, Price, and Sales for New York, Florida, and Connecticut to obtain the Sales values for East. If East and Sales are Dynamic Calc members, Analytic Services produces an incorrect result by calculating as follows: The sparse East dimension, by aggregating the values for UnitsSold, Price, and Sales for New York, Florida, and Connecticut to obtain the values for East. The values for East -&gt; Sales, by taking the aggregated values in the East data blocks and performing a formula calculation with these values to obtain the value for Sales. To avoid this problem and ensure that you obtain the required results, do not tag the Sales member as Dynamic Calc or Dynamic Calc and Store. Reducing the Impact on Retrieval Time The increase in retrieval time when you dynamically calculate a member of a dense dimension is not significant unless the member contains a complex formula. The increase in retrieval time may be significant when you tag members of sparse dimensions as Dynamic Calc or Dynamic Calc and Store. The following sections discuss ways you can analyze and manage the effect of Dynamic Calc members on a database: Displaying a Retrieval Factor Displaying a Summary of Dynamically Calculated Members Increasing Retrieval Buffer Size Using Dynamic Calculator Caches Note: For a list of functions that have the most significant effect on query retrieval, see Choosing Between Member Set Functions and Performance for details. Displaying a Retrieval Factor To help you estimate any increase in retrieval time, Analytic Services calculates a retrieval factor for a database outline when you save the outline. Analytic Services calculates this retrieval factor based on the dynamically calculated data block that is the most expensive for Analytic Services to calculate. The retrieval factor takes into account only aggregations. It does not consider the retrieval impact of formulas. The retrieval factor is the number of data blocks that Analytic Services must retrieve from disk or from the database in order to calculate the most expensive block. If the database has Dynamic Calc or Dynamic Calc and Store members in dense dimensions only (no Dynamic Calc or Dynamic Calc and Store members in sparse dimensions), the retrieval factor is 1. An outline with a high retrieval factor (for example, greater than 2000) can cause long delays when users retrieve data. However, the actual impact on retrieval time also depends on how many dynamically calculated data values a user retrieves. The retrieval factor is only an indicator. In some applications, using Dynamic Calc members may reduce retrieval time because the database size and index size are reduced. Analytic Services displays the retrieval factor value in the application log. To view an estimated retrieval factor, see Viewing the Analytic Server and Application Logs . A message similar to this sample indicates a retrieval factor: [Wed Sep 20 20:04:13 2000] Local/Sample\/\//Info (1012710) Essbase needs to retrieve [1] Essbase kernel blocks in order to calculate the top dynamically-calculated block. This message tells you that Analytic Services needs to retrieve one block in order to calculate the most expensive dynamically calculated data block. Displaying a Summary of Dynamically Calculated Members When you add Dynamic Calc or Dynamic Calc and Store members to a database outline and save the outline, Analytic Services provides a summary of how many members are tagged as Dynamic Calc and Dynamic Calc and Store. Analytic Services displays the summary in the application log. To view a summary of dynamically calculated members, see Viewing the Analytic Server and Application Logs . A message similar to this sample is displayed: [Wed Sep 20 20:04:13 2000]Local/Sample\/\//Info(1007125) The number of Dynamic Calc Non-Store Members = [ 8 6 0 0 2] [Wed Sep 20 20:04:13 2000]Local/Sample\/\//Info(1007126) The number of Dynamic Calc Store Members = [ 0 0 0 0 0] This message tells you that there are eight Dynamic Calc members in the first dimension of the database outline, six in the second dimension, and two in the fifth dimension. Dynamic Time Series members are included in this count. This example does not include Dynamic Calc and Store members. Increasing Retrieval Buffer Size When you retrieve data into Spreadsheet Services or use Report Writer to retrieve data, Analytic Services uses the retrieval buffer to optimize the retrieval. Analytic Services processes the data in sections. Increasing the retrieval buffer size can significantly reduce retrieval time because Analytic Services can process larger sections of data at one time. By default, the retrieval buffer size is 10 KB. However, you may speed up retrieval time if you set the retrieval buffer size greater than 10 KB. For information about sizing the retrieval buffer, see Setting the Retrieval Buffer Size . Use any of the following methods to set the retrieval buffer size: Tool Topic Location Administration Services Setting the Size of Retrieval Buffers Essbase Administration Services Online Help MaxL alter database Technical Reference ESSCMD SETDBSTATEITEM Technical Reference Using Dynamic Calculator Caches By default, when Analytic Services calculates a Dynamic Calc member in a dense dimension (for example, for a query), it writes all blocks needed for the calculation into an area in memory called the dynamic calculator cache. When Analytic Services writes these blocks into the dynamic calculator cache, it expands them to include all Dynamic Calc members in the dense dimensions. Using the Analytic Services dynamic calculator cache enables centralized control of memory usage for dynamic calculations. Managing data blocks in the dynamic calculator cache also reduces the overall memory space requirement and can improve performance by reducing the number of calls to the operating system to do memory allocations. Note: The dynamic calculator cache and the calculator cache use different approaches to optimizing calculation performance. For details about sizing and reviewing dynamic calculator cache usage, see Sizing the Calculator Cache . Reviewing Dynamic Calculator Cache Usage Analytic Services writes two messages to the application log for each data retrieval. As shown in the example in Figure192 , the first message describes the total amount of time required for the retrieval. Figure 192: Application Log Example of Memory Usage for Data Blocks Containing Dynamic Calc Members [Thu Aug 03 14:33:00 2000]Local/Sample/Basic/aspen/Info(1001065) Regular Extractor Elapsed Time : [0.531] seconds [Thu Aug 03 14:33:00 2000]Local/Sample/Basic/aspen/Info(1001401) Regular Extractor Big Blocks Allocs -- Dyn.Calc.Cache : [30] non-Dyn.Calc.Cache : [0] If a dynamic calculator cache is used, a second message displays the number of blocks calculated within the data calculator cache (Dyn.Calc.Cache: [ n ]) and the number of blocks calculated in memory outside dynamic calculator cache (non-Dyn.Calc.Cache: [ n ]). To determine if the dynamic calculator cache is being used effectively, review both of these messages and consider what your settings are in the essbase.cfg file. For example, if the message indicates that blocks were calculated outside as well as in a dynamic calculator cache, you may need to increase the DYNCALCCACHEMAXSIZE setting. If the specified maximum size is all that you can afford for all dynamic calculator caches on the server and if using memory outside the calculator cache to complete dynamically calculated retrievals results in unacceptable delays (for example, because of swapping or paging activity), set DYNCALCCACHEWAITFORBLK to TRUE. You can use the GETPERFSTATS command in ESSCMD to view a summary of dynamic calculator cache activity. See the Technical Reference for information about GETPERFSTATS. Using Dynamic Calculations with Standard Procedures Using dynamic calculations with standard Analytic Services procedures affects these processes: Clearing data and data blocks You can use the CLEARBLOCK DYNAMIC command to remove data blocks for Dynamic Calc and Store member combinations. You can use the CLEARDATA command to mark Dynamic Calc and Store data blocks, so that Analytic Services knows to recalculate the blocks. The CLEARDATA command has no effect on data values for Dynamic Calc members. Copying data You cannot copy data to a dynamically calculated data value. You cannot specify a Dynamic Calc or Dynamic Calc and Store member as the target for the DATACOPY calculation command. Converting currencies You cannot specify a Dynamic Calc or Dynamic Calc and Store member as the target for the CCONV command. Loading data When you load data, Analytic Services does not load data into member combinations that contain a Dynamic Calc or Dynamic Calc and Store member. Analytic Services skips these members during data load. Analytic Services does not display an error message. To place data into Dynamic Calc and Dynamic Calc and Store members, after loading data, you need to ensure that Analytic Services recalculates Dynamic Calc and Store members. For an explanation of how to ensure that Analytic Services recalculates Dynamic Calc and Store members, see Effect of Updated Values on Recalculation . Exporting data Analytic Services does not calculate dynamically calculated values before exporting data. Analytic Services does not export values for Dynamic Calc members. Analytic Services exports values for Dynamic Calc and Store members only if a calculated value exists in the database from a previous user retrieval of the data. Reporting data Analytic Services cannot use the SPARSE data extraction method for dynamically calculated members. The SPARSE data extraction method optimizes performance when a high proportion of the reported data rows are #MISSING. For more information, see the &lt;SPARSE command in the Technical Reference . Including dynamic members in calculation scripts When calculating a database, Analytic Services skips the calculation of any Dynamic Calc or Dynamic Calc and Store members. Analytic Services displays an error message if you attempt to do a member calculation of a Dynamic Calc or Dynamic Calc and Store member in a calculation script. For an explanation of the relationship of Dynamic Calc and Dynamic Calc and Store members and calculation passes, see Calculation Scripts and Dynamic Calculation . Creating Dynamic Calc and Dynamic Calc and Store Members To create Dynamic Calc and Dynamic Calc and Store members using Outline Editor, see Setting Member Storage Properties in Essbase Administration Services Online Help . To create Dynamic Calc and Dynamic Calc and Store members during a dimension build, in the dimension build data file, use the property X for Dynamic Calc and the property V for Dynamic Calc and Store. For information on how to place X and V in the data source, see Using the Data Source to Set Member Properties . Restructuring Databases When you add a Dynamic Calc member to a dense dimension, Analytic Services does not reserve space in the data block for the member's values. Therefore, Analytic Services does not need to restructure the database. However, when you add a Dynamic Calc and Store member to a dense dimension, Analytic Services does reserve space in the relevant data blocks for the member's values and therefore needs to restructure the database. When you add a Dynamic Calc or a Dynamic Calc and Store member to a sparse dimension, Analytic Services updates the index, but does not change the relevant data blocks. For information on managing the database index, see Index Manager . Analytic Services can save changes to the database outline significantly faster if it does not have to restructure the database. In the following cases, Analytic Services does not restructure the database. Analytic Services only has to save the database outline, which is very fast. Analytic Services does not restructure the database or change the index when you do any of the following: Add, delete, or move a dense dimension Dynamic Calc member. (But Analytic Services does restructure the database if the member is Dynamic Calc and Store.) Change the storage property of a dense dimension member from Dynamic Calc and Store member to a non-dynamic storage property Change the storage property of a sparse dimension Dynamic Calc or Dynamic Calc and Store member to a non-dynamic storage property Rename any Dynamic Calc or Dynamic Calc and Store member In the following cases, Analytic Services does not restructure the database, but does have to restructure the database index. Restructuring the index is significantly faster than restructuring the database. Analytic Services restructures only the database index when you do either of the following: Add, delete, or move sparse dimension Dynamic Calc or Dynamic Calc and Store members Change the storage property of a dense dimension member from a non-dynamic value to Dynamic Calc and Store However, Analytic Services does restructure the database when you do any of the following: Add, delete, or move a dense dimension Dynamic Calc and Store member. (But Analytic Services does not restructure the database if the member is Dynamic Calc.) Change a dense dimension Dynamic Calc and Store member to a Dynamic Calc member Change a dense dimension Dynamic Calc member to a Dynamic Calc and Store member Change the storage property of a non-dynamic member in a dense dimension to Dynamic Calc Change the storage property of a dense dimension from Dynamic Calc member to a non-dynamic value Change the storage property of a non-dynamic member in a sparse dimension Dynamic Calc or Dynamic Calc and Store For detailed information on the types of database restructuring, see Types of Database Restructuring . Dynamically Calculating Data in Partitions You can define Dynamic Calc and Dynamic Calc and Store members in transparent, replicated, or linked regions of the partitions. For a comprehensive discussion of partitions, see Designing Partitioned Applications . For example, you might want to tag an upper level, sparse dimension member with children that are on a remote database (transparent database partition) as Dynamic Calc and Store. Because Analytic Services needs to retrieve the child values from the other database, retrieval time is increased. You can use Dynamic Calc instead of Dynamic Calc and Store; however, the impact on subsequent retrieval time might be too great. For example, assume that the local database is the Corporate database, which has transparent partitions to the regional data for East, West, South, and Central. You can tag the parent member Market as Dynamic Calc and Store. In a transparent partition, the definition on the remote database takes precedence over any definition on the local database. For example, if a member is tagged as Dynamic Calc in the local database but not in the remote database, Analytic Services retrieves the value from the remote database and does not do the local calculation. If you are using a replicated partition, then you might want to use Dynamic Calc members instead of Dynamic Calc and Store members. When calculating replicated data, Analytic Services does not retrieve the child blocks from the remote database, and therefore the impact on retrieval time is not great. Note: When Analytic Services replicates data, it checks the time stamp on each source data block and each corresponding target data block. If the source data block is more recent, Analytic Services replicates the data in the data block. However, for dynamically calculated data, data blocks and time stamps do not exist. Therefore Analytic Services always replicates dynamically calculated data.  |../dcadynca.htm",
    "Reviewing Examples of Formulas||This chapter provides detailed examples of formulas, which you may want to adapt for your own use. For examples of using formulas in calculation scripts, see Reviewing Examples of Calculation Scripts. The information in this chapter does not apply to aggregate storage outlines. For information about developing formulas in MDX for aggregate storage outline members, see Developing Formulas on Aggregate Storage Outlines . This chapter includes the following sections: Calculating Period-to-Date Values Calculating Rolling Values Calculating Monthly Asset Movements Testing for #MISSING Values Calculating an Attribute Formula Calculating Period-to-Date Values If the outline includes a dimension tagged as accounts, you can use the @PTD function to calculate period-to-date values. You can also use Dynamic Time Series members to calculate period-to-date values. For an explanation of how to calculate time series data, see Calculating Time Series Data. For example, the following figure shows the Inventory branch of the Measures dimension from the Sample Basic database. Figure 177: Inventory Branch from Sample Basic Outline Inventory (~) (Label Only) Opening Inventory (+) (TB First) (Expense Reporting) IF(NOT @ISMBR(Jan)) Additions (~) (Expense Reporting) Ending Inventory (~) (TB Last) (Expense Reporting) To calculate period-to-date values for the year and for the current quarter, add two members to the Year dimension, QTD for quarter-to-date and YTD for year-to-date: QTD (~) @PTD(Apr:May) YTD (~) @PTD(Jan:May); For example, assuming that the current month is May, you would add this formula to the QTD member: @PTD(Apr:May); And you would add this formula on the YTD member: @PTD(Jan:May); Analytic Services sums the values for the range of months as appropriate. However, Opening Inventory has a time balance tag, First, and Ending Inventory has a time balance tag, Last. Analytic Services takes these values and treats them accordingly. For more information on time balance tags, see Calculating First, Last, and Average Values . The following table provides an example of the calculation results for the members in the Inventory branch and for the Sales member: Measures -&gt; Time Jan Feb Mar Apr May QTD YTD Opening Inventory 100 110 120 110 140 110 100 Additions 110 120 100 160 180 340 670 Sales 100 110 110 130 190 320 640 Ending Inventory 110 120 110 140 130 130 130 The values for Sales and Additions have been summed. Opening Inventory has a First tag. For QTD, Analytic Services takes the first value in the current quarter, which is Apr. For YTD, Analytic Services takes the first value in the year, which is Jan. Ending Inventory has a Last tag. For QTD, Analytic Services takes the last value in the current quarter, which is May. For YTD, Analytic Services takes the last value in the year, which is also May. Calculating Rolling Values You can use the @AVGRANGE function to calculate rolling averages and the @ACCUM function to calculate rolling year-to-date values. For example, assume that a database contains monthly Sales data values and that the database outline includes the members AVG_Sales and YTD_Sales. You would add this formula to the AVG_Sales member: @AVGRANGE(SKIPNONE, Sales, @CURRMBRRANGE(Year, LEV, 0, , 0)); And you would add this formula on the YTD_Sales member: @ACCUM(Sales); Analytic Services calculates the average Sales values across the months in the dimension tagged as time. The SKIPNONE parameter means that all values are included, even #MISSING values. Analytic Services places the results in AVG_Sales. For an explanation of how Analytic Services calculates #MISSING values, see Consolidating #MISSING Values . This table shows the results when Analytic Services calculates the cumulative Sales values and places the results in YTD_Sales: Measures -&gt; Time Jan Feb Mar Qtr1 Sales 100 200 300 600 AVG_Sales 100 150 200 #MISSING YTD_Sales 100 300 600 #MISSING The values for AVG_Sales are averages of the months-to-date. For example, AVG_Sales -&gt; Mar is an average of Sales for Jan, Feb, and Mar. The values for YTD_Sales are the cumulative values up to the current month. So YTD_Sales -&gt; Feb is the sum of Sales -&gt; Jan and Sales -&gt; Feb. Calculating Monthly Asset Movements You can use the @PRIOR function to calculate values based on a previous month's value. For example, assume that a database contains assets data values that are stored on a month-by-month basis. You can calculate the difference between the assets values of successive months (the asset movement) by subtracting the previous month's value from the present month's value. Assume these three members manage the asset values for the database: Assets for the monthly asset values Asset_MVNT for the asset movement values Opening_Balance for the asset value at the beginning of the year For Jan, the Asset_MVNT value is calculated by subtracting the Opening_Balance value from the Jan value. You would add this formula on the Asset_MVNT member: IF(@ISMBR(Jan)) Asset_MVNT = Assets - Opening_Balance; ELSE Asset_MVNT = Assets - @PRIOR(Assets); ENDIF; This table shows the results when Analytic Services calculates the difference between the values of assets in successive months: Assets -&gt; Time Opening_Balance Jan Feb Mar Assets 1200 1400 1300 1800 Asset_MVNT . 200 -100 500 Analytic Services cycles through the months, performing these calculations: The IF statement and @ISMBR function check to see if the current member on the Year dimension is Jan. This check is necessary because the Asset_MVNT value for Jan cannot be calculated by subtracting the previous month's value. If the current member on the Year dimension is Jan, Analytic Services subtracts the Opening_Balance from the Jan -&gt; Assets value and places the result in Jan -&gt; Asset_MVNT. If the current member on the Year dimension is not Jan, the @PRIOR function obtains the value for the previous month's assets. Analytic Services subtracts the previous month's assets from the current month's assets. It places the result in the current month's Asset_MVNT value. Testing for #MISSING Values You can test for #MISSING values in a database. For an explanation of how Analytic Services calculates #MISSING values, see Consolidating #MISSING Values . Assume that a database outline contains a member called Commission. Commission is paid at 10% of sales when the Sales value for the current member combination is not #MISSING. When applied to a Commission member in the database outline, the following formula calculates Commission: IF(Sales &lt;&gt; #MISSING) Commission = Sales * .1; ELSE Commission = #MISSING; ENDIF; If you place the formula in a calculation script, you need to associate it with the commission member as follows: Commission(IF(Sales &lt;&gt; #MISSING) Commission = Sales * .1; ELSE Commission = #MISSING; ENDIF;); Analytic Services cycles through the database, performing the following calculations: The IF statement checks to see if the value of the Sales member for the current member combination is not #MISSING. If Sales is not #MISSING, Analytic Services multiplies the value in the Sales member by 0.1 and places the result in the Commission member. If Sales is #MISSING, Analytic Services places #MISSING in the Commission member. Calculating an Attribute Formula You can perform specific calculations on attribute-dimension members in a database. Note: For a comprehensive discussion of attribute calculations, see Calculating Attribute Data . For example, to calculate profitability by ounce for products sized in ounces, you can use the @ATTRIBUTEVAL function in a calculation formula. In the Sample Basic database, the Ratios branch of the Measures dimension contains a member called Profit per Ounce. The formula on this member is: Profit/@ATTRIBUTEVAL(@NAME(Ounces)); Analytic Services cycles through the Products dimension, performing the following calculations: For each base member that is associated with a member from the Ounces attribute dimension, the @ATTRIBUTEVAL function returns the numeric attribute value (for example, 12 for the member 12 under Ounces). Note: The @NAME function is required to process the string Ounces before passing it to the @ATTRIBUTEVAL function. Analytic Services then divides Profit by the result of @ATTRIBUTEVAL to yield Profit per Ounce. Note: For an explanation of the functions that you use to perform calculations on attributes in formulas, see Using Attributes in Calculation Formulas . For more information about the @ATTRIBUTEVAL function, see the Technical Reference .  |../dcafoexs.htm",
    "Calculating Analytic Services Databases||This chapter explains the basic concept of multidimensional database calculation and provides information about how to calculate an Analytic Services block storage database. This chapter includes the following sections: About Database Calculation About Multidimensional Calculation Concepts Setting the Default Calculation Calculating Databases Parallel and Serial Calculation Security Considerations Note: Most computers represent numbers in binary, and therefore can only represent real numbers approximately. Because binary computers cannot hold an infinite number of bits after a decimal point, numeric fractions such as one third (0.3333...), cannot be expressed as a decimal with a terminating point. Fractions with a denominator of the power of two (for example, 0.50) or ten (0.10) are the only real numbers that can be represented exactly. For details, see IEEE Standard 754 for Floating-Point Representation (IEEE, 1985). For information about calculating aggregate storage databases see Calculating Aggregate Storage Databases . About Database Calculation A database contains two types of values. It contains the values that you enter, which are called input data , and the values that are calculated from the input data. Consider the following examples: You enter regional sales figures for a variety of products. You calculate the total sales for each product. You enter the budget and actual values for the cost of goods sold for several products in several regions. You calculate the variance between budget and actual values for each product in each region. The database contains regional sales figures and prices for all products. You calculate what happens to total profit if you increase the price of one product in one region by 5%. Small differences in the precision of cell values may occur between calculations run on different platforms, due to operating system math library differences. Analytic Services offers two ways that you can calculate a database: Outline calculation Calculation script calculation Which way you choose depends on the type of calculation that you want to do. Outline Calculation Outline calculation is the simplest method of calculation. Analytic Services bases the calculation of the database on the relationships between members in the database outline and on any formulas that are associated with members in the outline. For example, Figure166 shows the relationships between the members of the Market dimension in the Sample Basic database. The values for New York, Massachusetts, Florida, Connecticut, and New Hampshire are added to calculate the value for East. The values for East, West, South, and Central are added to calculate the total value for Market. Figure 166: Relationship Between Members of the Market Dimension Figure167 shows the Scenario dimension from the Sample Basic database. The Variance and Variance % members are calculated by using the formulas attached to them. Figure 167: Calculation of Variance and Variance % It may be more efficient to calculate some member combinations when you retrieve the data, instead of calculating the member combinations during the regular database calculation. You can use dynamic calculations to calculate data at retrieval time. For a comprehensive discussion of dynamic calculation, see Dynamically Calculating Data Values. Calculation Script Calculation Calculation script calculation is the second method of calculation. Using a calculation script, you can choose exactly how to calculate a database. For example, you can calculate part of a database or copy data values between members. A calculation script contains a series of calculation commands, equations, and formulas. For example, the following calculation script increases the actual marketing expenses in the New York region by 5%. FIX (Actual, New York) Marketing = Marketing *1.05; ENDFIX; For a comprehensive discussion of calculation scripts, see Developing Calculation Scripts. About Multidimensional Calculation Concepts For an illustration of the nature of multidimensional calculations, consider the following, simplified database: Figure 168: Calculating a Multidimensional Database The database has three dimensions-Accounts, Time, and Scenario. The Accounts dimension has four members: Sales and COGS are input values. Margin = Sales - COGS. Margin% = Margin % Sales (Margin as a percentage of Sales). The Time dimension has four quarters. The example displays only the members in Qtr1-Jan, Feb, and Mar. The Scenario dimension has two child members-Budget for budget values and Actual for actual values. An intersection of members (one member on each dimension) represents a data value. Our example has three dimensions; therefore, the dimensions and data values in the database can be represented as a cube, as shown in Figure169 : Figure 169: Three-Dimensional Database As shown in Figure170 , when you refer to Sales, you are referring to a slice of the database containing eight Sales values. Figure 170: Sales, Actual, Budget Slice of the Database As shown in Figure171 , when you refer to Actual Sales, you are referring to four Sales values: Figure 171: Actual, Sales Slice of the Database To refer to a specific data value in a multidimensional database, you need to specify each member on each dimension. A data value is stored in a single cell in the database. In Figure172 , the cell containing the data value for Sales, Jan, Actual is shaded. In Analytic Services, member combinations are denoted by a cross-dimensional operator. The symbol for the cross-dimensional operator is -&gt;. So Sales, Jan, Actual is written Sales-&gt;Jan-&gt;Actual. Figure 172: Sales, Jan, Actual Slice of the Database When Analytic Services calculates the formula Margin% = Margin % Sales, it takes each Margin value and calculates it as a percentage of its corresponding Sales value. Analytic Services cycles through the database and calculates Margin% as follows: Margin -&gt; Jan -&gt; Actual as a percentage of Sales -&gt; Jan -&gt; Actual. The result is placed in Margin% -&gt; Jan -&gt; Actual. Margin -&gt; Feb -&gt; Actual as a percentage of Sales -&gt; Feb -&gt; Actual. The result is placed in Margin% -&gt; Feb -&gt; Actual. Margin -&gt; Mar -&gt; Actual as a percentage of Sales -&gt; Mar -&gt; Actual. The result is placed in Margin% -&gt; Mar -&gt; Actual. Margin -&gt; Qtr1 -&gt; Actual as a percentage of Sales -&gt; Qtr1 -&gt; Actual. The result is placed in Margin% -&gt; Qtr1 -&gt; Actual. Margin -&gt; Jan -&gt; Budget as a percentage of Sales -&gt; Jan -&gt; Budget. The result is placed in Margin% -&gt; Jan -&gt; Budget. Analytic Services continues cycling through the database until it has calculated Margin% for every combination of members in the database. For a comprehensive discussion of how Analytic Services calculates a database, see Defining Calculation Order. Setting the Default Calculation By default, the calculation for a database is a CALC ALL of the database outline. CALC ALL consolidates all dimensions and members and calculates all formulas in the outline. However, you can specify any calculation script as the default database calculation. Thus, you can assign a frequently-used script to the database rather than loading the script each time you want to perform its calculation. Also, if you want a calculation script to work with calculation settings defined at the database level, you must set the calculation script as the default calculation. Use any of the following methods to set the default calculation: Tool Topic Location Administration Services Setting the Default Calculation Essbase Administration Services Online Help MaxL alter database Technical Reference ESSCMD SETDEFAULTCALCFILE Technical Reference Calculating Databases If you have Calculation permissions, you can calculate a database. When you use Essbase Administration Services to calculate a database, you can execute the calculation in the background so that you can continue working as the calculation processes. You can then check the status of the background process to see when the calculation is complete. For instructions, see Calculating Block Storage Databases in Essbase Administration Services Online Help . Use any of the following methods to calculate a database: Tool Topic Location Administration Services Calculating Block Storage Databases Essbase Administration Services Online Help MaxL execute calculation Technical Reference ESSCMD CALC, CALCDEFAULT, and CALCLINE Technical Reference Spreadsheet Add-in Calculating a Database Spreadsheet Add-in Online Help Canceling Calculations To stop a calculation before Analytic Services completes it, click the Cancel button while the calculation is running. When you cancel a calculation, Analytic Services performs one of the following operations: Reverts all values to their previous state Retains any values calculated before the cancellation How Analytic Services handles the cancellation depends on the Analytic Services Kernel Isolation Level settings. For a description of these settings, see Understanding Isolation Levels . Parallel and Serial Calculation Analytic Services now supports parallel calculation in addition to serial calculation. Serial calculation, the default, means that all steps in a calculation run on a single thread. Each task is completed before the next is started. Parallel calculation means that the Analytic Services calculator can analyze a calculation, and, if appropriate, assign tasks to multiple CPUs (up to 4). For a comprehensive discussion of parallel calculation, including how to determine whether Analytic Server should use parallel calculation, see Using Parallel Calculation . Security Considerations In order to calculate a database, you must have Calculate permissions for the database outline. If you have calculate permissions, you can calculate any value in the database. With calculate permissions, you can calculate a value even if a security filter denies you read and update permissions. Careful consideration should be given to providing users with calculate permissions. For information on providing users with calculate permissions and on security filters, see Managing Security for Users and Applications.  |../dcaintro.htm",
    "Optimizing Calculations||This chapter provides information on how to optimize the performance of Analytic Services calculations in block storage databases: Designing for Calculation Performance Monitoring and Tracing Calculations Using Simulated Calculations to Estimate Calculation Time Estimating Calculation Affects on Database Size Using Parallel Calculation Using Formulas Using Bottom-Up Calculation Managing Caches to Improve Performance Working with the Block Locking System Managing Concurrent Access for Users Using Two-Pass Calculation Choosing Between Member Set Functions and Performance Consolidating #MISSING Values Removing #MISSING Blocks Identifying Additional Calculation Optimization Issues In addition, the information provided in the following chapters will help you in your efforts to optimize database calculations: Designing Partitioned Applications Dynamically Calculating Data Values Developing Calculation Scripts Optimizing with Intelligent Calculation Designing for Calculation Performance You can configure a database to optimize calculation performance. The best configuration for the site depends on the nature and size of the database. Use the information in the following topics as guidelines only: Block Size and Block Density Order of Sparse Dimensions Incremental Data Loading Database Outlines with Two or More Flat Dimensions Formulas and Calculation Scripts Block Size and Block Density A data block size of 8Kb to 100Kb provides optimal performance in most cases. If data blocks are much smaller than 8Kb, the index is usually very large, forcing Analytic Services to write to and retrieve the index from disk. This process slows down calculation. If data blocks are much larger than 100Kb, Intelligent Calculation does not work effectively. For a comprehensive discussion of how intelligent calculation aids performance, see Optimizing with Intelligent Calculation. To optimize calculation performance and data storage, you need to balance data block density and data block size. You can create balance by rearranging the dense and sparse dimension configuration of the database. Therefore, keep these suggestions in mind: Keep data block size between 8 Kb and 100 Kb with as high a block density as possible. Run test calculations of the most promising configurations of a database that contains representative data. Check the results to determine the configuration that produces the best calculation performance. You can view information about a database, including the potential and actual number of data blocks and the data block size. To view data block information, use either of the following methods: Tool Topic Location Administration Services Checking Data Block Statistics Essbase Administration Services Online Help ESSCMD GETDBINFO Technical Reference Order of Sparse Dimensions You may improve calculation performance by changing the order of standard (not attribute) sparse dimensions in the database outline. Order standard sparse dimensions by the number of members they contain, placing the dimension that contains the fewest members first. This arrangement provides a number of possible improvements, depending on the site: The calculator cache functions more effectively, providing approximately a 10% performance improvement if you have a database outline with a very large dimension (for example, a dimension containing 1000 members). Parallel calculation, if enabled, is more likely to be used if the standard sparse dimension with the most members is the last standard sparse dimension in the outline. Incremental Data Loading Many companies load data incrementally. For example, a company may load data each month for that month. To optimize calculation performance when you load data incrementally, make the dimension tagged as time a sparse dimension. If the time dimension is sparse, the database contains a data block for each time period. When you load data by time period, Analytic Services accesses fewer data blocks because fewer blocks contain the relevant time period. Thus, if you have Intelligent Calculation enabled, only the data blocks marked as dirty are recalculated. For example, if you load data for March, only the data blocks for March are updated. The data blocks for January and February do not change. With Intelligent Calculation enabled, Analytic Services recalculates only the data blocks for March and the dependent parents of March. However, making the time dimension sparse when it is naturally dense may significantly increase the size of the index, creating possibly slower performance due to more physical I/O activity to accommodate the large index. If the dimension tagged as time is dense, you still receive some benefit from Intelligent Calculation when you do a partial data load for a sparse dimension. For example, if Product is sparse and you load data for one product, Analytic Services recalculates only the blocks affected by the partial load, even though time is dense and Intelligent Calculation is enabled. Database Outlines with Two or More Flat Dimensions Calculation performance may be affected if a database outline has two or more flat dimensions. A flat dimension has very few parents and each parent has many thousands of children; in other words, flat dimensions have many members and few levels. You can improve performance for outlines with two or more flat dimensions by adding intermediate levels to the database outline. Formulas and Calculation Scripts You may achieve significant improvements in calculation performance by carefully grouping formulas and dimensions in a calculation script. In this way, you can ensure that Analytic Services cycles through the data blocks in the database as few times as possible during a calculation. Order commands in calculation scripts to make the database calculation as simple as possible. Consider applying all formulas to the database outline and using a default calculation (CALC ALL). This method may improve calculation performance. For detailed information about developing calculation scripts, see Developing Calculation Scripts. For detailed information about multiple calculation passes, see Calculation Passes . Monitoring and Tracing Calculations You can display information in the application log about how Analytic Services is calculating the database by using the following commands in a calculation script: SET MSG SUMMARY and SET MSG DETAIL SET NOTICE SET MSG SUMMARY and SET MSG DETAIL You can use the SET MSG SUMMARY and SET MSG DETAIL calculation commands in a calculation script to do the following: Display calculation settings, for example, whether completion notice messages are enabled Provide statistics on the number of data blocks created, read, and written Provide statistics on the number of data cells calculated The SET MSG DETAIL command also provides a detailed information message every time Analytic Services calculates a data block. SET MSG DETAIL is useful for reviewing the calculation order of data blocks and for testing intelligent recalculations. Caution: Because the SET MSG DETAIL command causes a high processing overhead, use it only during test calculations. SET MSG SUMMARY causes a processing overhead of approximately 1% to 5%, depending on database size, and is therefore appropriate for all calculations. SET NOTICE You can use the SET NOTICE calculation command in a calculation script to display calculation completion notices that tell you what percentage of the database has been calculated. You can use the SET MSG SUMMARY command with the SET NOTICE command to show calculation progress between completion notices. Completion notices do not significantly reduce calculation performance, except when used with a very small database. Using Simulated Calculations to Estimate Calculation Time You can simulate a calculation using SET MSG ONLY in a calculation script. A simulated calculation produces results that help you analyze the performance of a real calculation that is based on the same data and outline. By running a simulated calculation with a command like SET NOTICE HIGH, you can mark the relative amount of time each sparse dimension takes to complete. Then, by performing a real calculation on one or more dimensions, you can estimate how long the full calculation will take, because the time a simulated calculation takes to run is proportional to the time that the actual calculation takes to run. For example, if the calculation starts at 9:50:00 AM and the first notice is time-stamped at 09:50:10 AM, and the second is time-stamped at 09:50:20 AM, you know that each of part of the calculation took ten seconds. If you then run a real calculation on only the first portion and note that it took 30 seconds to run, you know that the other portion will also take 30 seconds. If there were only two messages total, then you would know that the real calculation will take approximately 60 seconds (20 /10 * 30 = 60 seconds). In this manner, you can use a simulated calculation to estimate the length of time it takes a calculation to run. Use the following topics to learn how to perform a simulated calculation and how to use a simulated calculation to estimate calculation time: Performing a Simulated Calculation Estimating Calculation Time Factors Affecting Estimate Accuracy Changing the Outline Based on Results Performing a Simulated Calculation Before you can estimate calculation time, you must perform a simulated calculation on a data model that is based on your actual database. To perform a simulated calculation, use this procedure: Create a data model that uses all dimensions and all levels of detail about which you want information. Load all data. This procedure calculates only data loaded in the database. Create a calculation script with these entries: SET MSG ONLY; SET NOTICE HIGH; CALC ALL; If you are using dynamic calculations on dense dimensions, substitute the CALC ALL command with the specific dimensions that you need to calculate, for example CALC DIM EAST. Note: If you try to validate the script, Analytic Services reports an error. You can disregard the error. Run the script. Find the first sparse calculation message in the application log and note the time in the message. Note the time for each subsequent message. Calculate the dense dimensions of the model that are not being dynamically calculated: CALC DIM ( DENSE_DIM1 , DENSE_DIM2 , ...); Calculate the sparse dimensions of the model: CALC DIM (SPARSEDIM1, SPARSEDIM2, ...); Project the intervals at which notices will occur, and then verify against sparse calculation results. You can then estimate how long a calculation will take. Estimating Calculation Time After you perform a simulated calculation, you record the results and use them to estimate actual calculation time. To estimate the total time required for a calculation, use the following process: Note the times of all the intervals between application log messages generated by SET NOTICE HIGH. See Table82 for an example. Use the following calculation to estimate the time for a real calculation: Total time required for simulated calculation, divided by the first simulated calculation notice interval, multiplied by the first real calculation time interval. Table 82: Sample Intervals Between Log Messages  Calculation Notice Number Simulated Calculation Time Interval Sparse dimension Calculation Interval 1 7 seconds 45 seconds 2 5 seconds &#160; 3 6 seconds &#160; 4 3 seconds &#160; 5 4 seconds &#160; 6 2 seconds &#160; 7 6 seconds &#160; 8 4 seconds &#160; 9 3 seconds &#160; 10 3 seconds &#160; Total calculation time 43 seconds &#160; In this example, 43 / 7 * 45 = 276.4 seconds, so the real calculation should take 276.4 seconds. Factors Affecting Estimate Accuracy The simulated calculation should return a time accurate to about 5%, excluding the following issues: Variations Due to a Chain of Influences Variations Due to Outline Structure When these factors are present, this estimating technique more closely predicts calculation time when Analytic Services reaches about 30 to 40 percent of the simulated calculations (30 to 40 percent of the messages generated by SET NOTICE HIGH). For more information about the SET NOTICE calculation command and the related CALCNOTICE configuration setting, see the Technical Reference . Variations Due to a Chain of Influences Using SET MSG ONLY as a calculation-time estimating technique should be validated against later CALCNOTICE intervals. The results of this estimating technique vary because of the following chain of influences: Blocks differ in block density through the real consolidation process, therefore The rate at which Analytic Services writes blocks to the disk differs, therefore The rate at which blocks are processed in the cache differs, therefore Actual results may differ from the predicted calculation time. Variations Due to Outline Structure Another factor that can make actual results diverge significantly from predicted is the outline structure. Calculations based on CALCNOTICE intervals assume evenly balanced processing time throughout the outline. Factors that can skew this balance include the following situations: The model contains 1 or 2 sparse dimensions that are very large in relation to the other sparse dimensions. Larger dimensions have member configurations that result in 2 or more shared rollups. Changing the Outline Based on Results Once you have estimated and analyzed a simulated calculation, you can make changes in the outline to improve performance. From top to bottom in the outline, order sparse dimensions to create the fewest percentage increases in upper blocks: Level 0 blocks following full model load 100,000 Upper level blocks after consolidating only sparse dimension 1:1,000,000 Upper level blocks after consolidating only sparse dimension 2:3,000,000 Upper level blocks after consolidating only sparse dimension 3:10,000,000 Upper level blocks after consolidating only sparse dimension 4:300,000 Upper level blocks after consolidating only sparse dimension 5:5,700,000 For example: #4 (members = 10,000, 4 levels) #1 (members = 500, 2 levels) #2 (members = 100, 4 levels) #5 (members = 10,000, 4 levels) #3 (members = 20, flat) Use the simulated calculation to generate the upper block count. These numbers may be accurate despite actual dimension sizes as noted next to the items above. Caution: The largest count of members is not always a good predictor. Estimating Calculation Affects on Database Size Given the current number of blocks in a database, you can estimate the number of blocks that will be produced by a CALC ALL. To estimate the database size resulting from a calculation, use the following process (example uses interactive mode): Load data and issue a CALC ALL command and note the average block size. Start the MaxL shell, log into Analytic Services, and start an application and database. essmsh login username password ; alter system load application appname ; alter application appname load database dbname ; Providing the application and database name, enter the following MaxL statement and note the value that is returned for the number of blocks. query database application.dbname get estimated size; Multiply the number of blocks by the average size of the blocks in the database. Results are accurate to a precision of plus or minus 10%. Be aware of the following conditions when you query Analytic Services for an estimate of the full size of a database: You must perform this query after a CALC ALL. Any other calculation will not produce accurate results. You can obtain accurate results with formulas only if they are on sparse dimensions. Estimates on databases that have formulas on dense dimensions are not accurate. You cannot obtain accurate results with top down calculations on any member in combination with a lock on data (committed access). If you need to estimate partitions, you must query Analytic Services for a database size estimate on every partition and add the results. If you query for the size of only the source database, the estimate includes only the data on the source database server. Using Parallel Calculation This topic discusses parallel calculation and enables you to decide whether parallel calculation improves performance for your site. This topic also outlines the process for enabling parallel calculation: Parallel Calculation Checking Current Parallel Calculation Settings Enabling Parallel Calculation Identifying Additional Tasks for Parallel Calculation Monitoring Parallel Calculation Parallel Calculation Analytic Services provides two ways of invoking a calculation: The calculation may be implicitly specified by the outline itself. The calculation may be explicitly specified by a calculation script that you create. The script contains formulas and calculation instructions. Regardless of how a calculation is triggered, Analytic Services can execute the calculation in one of two modes: Serial calculation is the default. With serial calculation, each calculation pass is scheduled to run on a single processor. If invoked from a calculation script, the calculations are executed sequentially in the order that they appear in the calculation script. Parallel calculation breaks each calculation pass into sub-tasks. The sub-tasks that can run independently of each other are scheduled to run simultaneously on up to four threads. Each thread may be on a different processor. To change from the default serial calculation to parallel calculation, use either of the following methods: Change at most two configuration settings and restart the server. Add an instruction to the calculation script. See Enabling Parallel Calculation for detailed instructions. The following topics discuss the details of parallel calculation: Analytic Services Analysis of Feasibility Parallel Calculation Guidelines Relationship Between Parallel Calculation and Other Analytic Services Features Analytic Services Analysis of Feasibility Analytic Services evaluates whether using parallel calculation is possible before each calculation pass for which you have enabled parallel calculation. Analytic Services analyzes the outline and the calculation requested for each calculation pass. Remember that a single calculation may require more than one pass. A number of situations may create the need for more than one pass, including dynamic calculation, the presence of a member tagged as two-pass, or calculations that create certain kinds of inter-dependencies. For a comprehensive discussion of calculation passes, see Calculation Passes . If Analytic Services determines that parallel calculation is possible, Analytic Services splits the calculation into smaller tasks that are independent of each other. During the calculation, Analytic Services performs the smaller tasks simultaneously. However, Analytic Services uses serial calculation even if parallel calculation is enabled if there are complex interdependencies between formulas that participate in the pass. Such interdependencies render parallel calculation impossible. Parallel Calculation Guidelines Outline structure and application design determine whether enabling parallel calculation can improve calculation performance. Before you enable parallel calculation, review the following guidelines. If you do not adhere to the guidelines, you may not receive the full benefit of parallel calculation: Use the uncommitted access isolation level. Parallel calculation is not supported if you use the committed access isolation level. For more information, see Uncommitted Access . One or more formulas present in a calculation may prevent Essbase from using parallel calculation even if it is enabled. For a description of formulas that may force serial calculation regardless of parallel calculation settings, see Formula Limitations . Calculation tasks are usually generated along the last sparse dimension of an outline. Order the sparse dimensions in an outline from smallest to largest, based on actual size of the dimension as reported by the ESSCMD command GETDBSTATS. This ordering recommendation is consistent with recommendations for optimizing calculator cache size and consistent with other outline recommendations. For a description of situations that may need to use additional dimensions (more than the last sparse dimension) and for instructions on how to increase the number of sparse dimensions used, see Identifying Additional Tasks for Parallel Calculation . Parallel calculation is effective on non-partitioned applications and these partitioned applications: Replicated partitions Linked partitions Transparent partitions if the calculation occurs at the target database. The number of sparse dimensions specified by CALCTASKDIMS in the essbase.cfg file or by SET CALCTASKDIMS in a calculation script must be set at 1 (the default value). See Transparent Partition Limitations for details about the limitations imposed by the use of parallel calculation with transparent partitions, and see Identifying Additional Tasks for Parallel Calculation for details about using CALCTASKDIMS or SET CALCTASKDIMS. If you have selected incremental restructuring for a database and you have made outline changes that are pending a restructure, do not use parallel calculation. Unpredictable results may occur. Relationship Between Parallel Calculation and Other Analytic Services Features The following topics discuss the relationship between parallel calculation and other Analytic Services functionality: Retrieval Performance Formula Limitations Calculator Cache Transparent Partition Limitations Restructuring Limitation Commit Threshold Adjustments Isolation Level Limitation Retrieval Performance Placing the largest sparse dimension at the end of the outline for maximum parallel calculation performance may slow retrieval performance. See Optimizing Query Performance for outline design guidelines for optimizing retrieval. Formula Limitations The presence of some formulas may force serial calculation. The following formula placements are likely to force serial calculation: A formula on a dense member, including all stored members and any Dynamic Calc members upon which a stored member may be dependent, that causes a dependence on a member of the dimension that is used to identify tasks for parallel calculation. A formula that contains references to variables declared in a calculation script that uses @VAR, @ARRAY, or @XREF. A member formula that causes a circular dependence. For example, member A has a formula referring to member B, and member B has a formula referring to member C, and member C has a formula referring to member A. A formula on a dense or sparse member with a dependency on a member or members from the dimension used to identify tasks for parallel processing. If you need to use a formula that might prevent parallel calculation, you can either mark the member of the formula as Dynamic Calc or exclude it from the scope of the calculation. To check if a formula is preventing parallel calculation, check the application log. See Monitoring Parallel Calculation for details about the relevant error messages. Calculator Cache At the start of a calculation pass, Analytic Services checks the calculator cache size and the degree of parallelism and then uses the calculator cache bitmap option appropriate for maximum performance. Therefore, the bitmap option used for parallel calculation may be different from the one used for serial calculation. For example, assume Essbase performs a serial calculation and uses multiple bitmaps and a single anchoring dimension. Without explicit change of the calculator cache size, Analytic Services might perform a parallel calculation might using only a single bitmap and a single anchoring dimension. You can determine the calculator cache mode that controls the bitmap options by checking the application log at the start of each calculation pass for an entry similar to the following: Multiple bitmap mode calculator cache memory usage has a limit of [50000] bitmaps. When using parallel calculation in multiple bitmap mode, you may encounter high memory usage. If you encounter this situation, you can use the configuration setting PARCALCMULTIPLEBITMAPMEMOPT to optimize memory use in multiple bitmap mode. This setting can be used together with, or separately from, MULTIPLEBITMAPMEMCHECK. To enable PARCALCMULTIPLEBITMAPMEMOPT, add this line to your essbase.cfg file: PARCALCMULTIPLEBITMAPMEMOPT TRUE For a comprehensive discussion of calculator cache and calculator cache bitmaps, see Sizing the Calculator Cache . Transparent Partition Limitations Parallel calculation with transparent partitions has the following limitations: You cannot use parallel calculation across transparent partitions unless the calculation occurs at the target. You must set CALCTASKDIMS or SET CALCTASKDIMS to 1 (the default) so that there is only one anchoring dimension. You must increase the calculator cache so that multiple bitmaps can be used. You can identify the calculator cache mode that controls the bitmap options by checking the application log at the start of each calculation pass for an entry similar to the following: Multiple bitmap mode calculator cache memory usage has a limit of [50000] bitmaps. For a comprehensive discussion of sizing the calculator cache, see Sizing the Calculator Cache . Restructuring Limitation Do not use parallel calculation if you have selected incremental restructuring. Parallel calculation does not support incremental restructuring. Commit Threshold Adjustments Essbase checks the commit threshold specified by the database setting Number of blocks before internal commit. If the setting requires less than 10 MB of data be written before an internal commit, then Essbase automatically increases the commit threshold for the duration of the calculation pass to 10 MB. If the setting is greater than 10 MB, Analytic Services uses the setting value. Analytic Services writes a message to the application log noting the temporary increase if it occurs. If you can allocate more than 10 MB extra disk space for calculation, consider increasing the commit threshold value, that is, the number of blocks before a commit, to a very large number for better performance. To view the current threshold, use any of the following methods: Tool Topic Location Administration Services Setting Data Integrity Options Essbase Administration Services Online Help MaxL display database dbs_name Technical Reference ESSCMD GETDBINFO: Number of blocks modified before internal commit Technical Reference To modify the commit threshold, use any of the following methods: Tool Topic Location Administration Services Setting Data Integrity Options Essbase Administration Services Online Help MaxL alter database dbs_name set implicit_commit after n blocks Technical Reference , list of MaxL statements ESSCMD SETDBSTATEITEM 21 Example of Specifying Isolation Level Settings with ESSCMD For a discussion of commit thresholds, see Uncommitted Access . Isolation Level Limitation You must use uncommitted mode for parallel calculation. To set the isolation level to uncommitted mode, use any of the following methods: Tool Topic Location Administration Services Setting Data Integrity Options Essbase Administration Services Online Help MaxL alter database dbs_name disable committed_mode Technical Reference , list of MaxL statements ESSCMD SETDBSTATEITEM 18 Example of Specifying Isolation Level Settings with ESSCMD See Uncommitted Access for a description of how uncommitted mode works. Checking Current Parallel Calculation Settings You can check either the server configuration file or the calculation script that you plan to use to see if parallel calculation is enabled. To check if parallel calculation has already been enabled in the server configuration file: Open the server essbase.cfg file with a text editor. Search for the parameter CALCPARALLEL, and check its specified value. The number of threads that can simultaneously perform tasks to complete a calculation is specified by the value 1-4. See the Technical Reference for details. To check if a calculation script sets parallel calculation, look for the SET CALCPARALLEL command. Review the script carefully, as the script may enable or disable parallel calculation more than once. Enabling Parallel Calculation To use parallel calculation, enable it at the server level, application level, or database level using either of these methods: Add or edit the appropriate configuration settings to the essbase.cfg file. For instructions, see CALCPARALLEL and CALCTASKDIMS in the configuration settings section of the Technical Reference . Add the appropriate calculation commands to a calculation script. For instructions, see SET CALCPARALLEL and SET CALCTASKDIMS in the calculator commands section of the Technical Reference . Parallel calculation settings use standard precedence rules: The database setting takes precedence over the application setting The application setting takes precedence over the server setting. Setting parallel calculation at the server level enables it for all calculations performed on all applications and databases on the server. You can disable parallel calculation for individual applications or databases by setting parallel calculation at the server level in the configuration file and then adding application-specific or database-specific entries in a calculation script. Caution: Be sure to read all of this chapter before attempting to enable parallel calculation. To enable parallel calculation, use the following process: If you plan to enable parallel calculation in the configuration file, check the current status to see if an entry already exists; use the process described in Checking Current Parallel Calculation Settings . Add or modify CALCPARALLEL to the essbase.cfg file on the server, or add SET CALCPARALLEL to a calculation script. If needed, enable Analytic Services to use more than the one sparse dimension to identify tasks for parallel calculation; use the process described in Identifying Additional Tasks for Parallel Calculation . If you added entries to the configuration file, restart the server. Run the calculation. Hyperion recommends that you set the value of CALCPARALLEL to be one less than the number of processors available for calculation. This extra processor can then be used by either the operating system or by the Essbase process responsible for writing out dirty blocks from the cache. Tip: You can combine the use of CALCPARALLEL and SET CALCPARALLEL if the site requires it. For example, you can set CALCPARALLEL as off at the server level, and use a calculation script to enable and disable parallel calculation as often as needed. Identifying Additional Tasks for Parallel Calculation By default, Analytic Services uses the last sparse dimension in an outline to identify tasks that can be performed concurrently. But the distribution of data may cause one or more tasks to be empty, that is, there are no blocks to be calculated in the part of the database identified by a task. This situation can lead to uneven load balancing, thus reducing the effectiveness of parallel calculation. To resolve this situation, you can enable Analytic Services to use additional sparse dimensions in the identification of tasks for parallel calculation. For example, if you have a FIX statement on a member of the last sparse dimension, you can include the next-to-last sparse dimension from the outline as well. Because each unique member combination of these two dimensions is identified as a potential task, more and smaller tasks are created, increasing the opportunities for parallel processing and providing better load balancing. To increase the number of sparse dimensions used to identify tasks for parallel calculation, use the following process: If you are not sure, verify if parallel calculation is already enabled. See Checking Current Parallel Calculation Settings for instructions. Without CALCPARALLEL (or SET CALCPARALLEL in a calculation script), CALTASKDIMS has no effect. Add or modify CALCTASKDIMS in the essbase.cfg file on the server, or use the calculation script command SET CALCTASKDIMS at the top of the script. See the Technical Reference for instructions. If you add or modify CALCTASKDIMS in the essbase.cfg file on the server, restart Analytic Services. If you are using a calculation script, run the script. Note: In some cases, Analytic Services uses a lower number of dimensions to identify tasks than is specified by CALCTASKDIMS or SET CALCTASKDIMS. See the Technical Reference for a detailed explanation. Monitoring Parallel Calculation You can view events related to parallel calculation in the application log: To view the application log, see Viewing Logs in Essbase Administration Services Online Help . For each calculation pass, Analytic Services writes several types of information to the application log to support parallel calculation: If you have enabled parallel calculation and Analytic Services has determined that parallel calculation can be performed, Analytic Services writes a message in the application log: Calculating in parallel with n threads In this message, n represents the number of concurrent tasks specified in CALCPARALLEL or SETCALCPARALLEL. For each formula that prevents parallel calculation (forces serial calculation), Analytic Services writes a message to the application log: Formula on mbr memberName prevents calculation from running in parallel. In the message, memberName represents the name of the member where the relevant formula exists. You can look in the application log for such messages and consider tagging the relevant member or members as Dynamic Calc if possible so they do not feature in the calculation pass. Analytic Services writes a message to the application log specifying the number of tasks that can be executed concurrently at any one time (based on the data, not the value of CALCPARALLEL or SETCALCPARALLEL): Calculation task schedule [576,35,14,3,2,1] The example message indicates that 576 tasks can be executed concurrently. After the 576 tasks complete, 35 more can be performed concurrently, and so on. The benefit of parallel calculation is greatest in the first few steps, and then taper off because there are fewer and fewer tasks being performed concurrently. The degree of parallelism depends on the number of tasks shown in the task schedule. The greater the number, the more tasks that can run in parallel, and thus the greater the performance gains. Analytic Services writes a message to the application log indicating how many of the tasks are empty (contain no calculations): [Tue Nov 27 12:30:44 2001]Local/CCDemo/Finance/essexer/ Info(1012681) Empty tasks [91,1,0,0] In the example log message, Analytic Services indicates that 91 of the tasks at level zero were empty. If the ratio of empty tasks to the tasks specified in the task schedule is greater than 50, parallelism may not be giving you improved performance, because of the high sparsity in the data model. You can change dense/sparse assignments to reduce the number of empty tasks, and increase the performance gains from parallel calculation. Using Formulas You may achieve significant improvements in calculation performance by careful use of formulas in the database outline. For example, you may achieve improved calculation performance by placing formulas on members in the database outline instead of placing the formulas in a calculation script. For a comprehensive discussion of how to develop formulas, see Developing Formulas. For discussion of how to handle formula issues that affect performance, see the following topics: Consolidating Using Simple Formulas Using Complex Formulas Optimizing Formulas on Sparse Dimensions in Large Database Outlines Constant Values Assigned to Members in a Sparse Dimension Using Cross-Dimensional Operators (-&gt;) Bottom-Up and Top-Down Calculation Consolidating Using the database outline to roll up values is always more efficient than using a formula to calculate values. For example, consider the consolidation on the Sample Basic database outline shown in Figure244 . Figure 244: Consolidation on Sample Basic Outline Using outline consolidation is more efficient than applying the following formula to the 100 member: 100-10 + 100-20 + 100-30 Using Simple Formulas If you use a simple formula and block size is not unusually large, you can place the formula on a member of either a sparse or a dense dimension without significantly affecting calculation performance. The bigger the block size, the more impact simple formulas have on calculation performance. For a discussion of the relationship between block size and calculation performance, see Block Size and Block Density . A simple formula is, for example, a ratio or a percentage. A simple formula meets all of the following requirements: Does not reference values from a different dimension (sparse or dense). For example, a simple formula cannot reference Product-&gt;Jan. Does not use range functions. For example, a simple formula cannot use @AVGRANGE, @MAXRANGE, @MINRANGE, or @SUMRANGE. Does not use relationship or financial functions. For example, a simple formula cannot use @ANCESTVAL, @NEXT, @PARENTVAL, @SHIFT, @ACCUM, or @GROWTH. For a complete list of relationship and financial functions, see the Technical Reference . For information on how formulas affect calculation performance, see Bottom-Up and Top-Down Calculation . Using Complex Formulas If you use a complex formula, you can improve performance by applying the following guidelines: If possible, apply the formula to a member in a dense dimension. Use the FIX command in a calculation script to calculate only required data blocks. For an example of the use of FIX, see Using the FIX Command . Increase the density of the database (ratio of existing data blocks to possible data blocks). For a discussion of balance between block size and block density, see Block Size and Block Density . A complex formula is a formula that meets any of the following requirements: References a member or members in a different dimension (sparse or dense); for example, Product-&gt;Jan. Uses one or more range functions, for example, @AVGRANGE, @MAXRANGE, @MINRANGE, or @SUMRANGE. Uses relationship or financial functions; for example, @ANCESTVAL, @NEXT, @PARENTVAL, @SHIFT, @ACCUM, or @GROWTH. For a complete list of relationship and financial functions, see the Technical Reference . When applied to sparse dimension members, complex formulas create more calculation overhead and therefore slow performance. This problem occurs because the presence of complex formulas requires Essbase to perform calculations on all possible as well as all existing data blocks related to the member with the complex formula. The presence of a relationship or financial function on a sparse dimension member causes Essbase to perform calculations on all blocks, possible as well as existing, increasing the overhead even more. Thus, a complex formula that includes a relationship or financial function creates a greater overhead increase than does a complex formula that does not include a relationship or financial function. For a comprehensive discussion about how complex formulas affect calculation performance, see Bottom-Up and Top-Down Calculation . Two examples illustrate complex formula overhead: If a database has 90 existing data blocks and 100 potential data blocks, the overhead for complex formulas is not very large, not more than ten extra blocks to read and possibly write values to. If a database has 10 existing data blocks and 100 potential data blocks, the overhead is as much as ten times what it would be without the complex formula (depending on the particular outline structure and other factors), as many as 90 extra blocks to read and possibly write to. In all cases, the lower the ratio of existing data blocks to possible data blocks, the higher the calculation performance overhead and the slower the performance. Optimizing Formulas on Sparse Dimensions in Large Database Outlines You can use the SET FRMLBOTTOMUP calculation command to optimize the calculation of formulas in sparse dimensions in large database outlines. With this command, you can force a bottom-up calculation on sparse member formulas that would otherwise be calculated top-down. For a review of methods and a caution, see Forcing a Bottom-Up Calculation . Forcing a bottom-up calculation on a top-down formula enables efficient use of the CALC ALL and CALC DIM commands. For technical details, review the discussions of the SET FRMLBOTTOMUP calculation command and the CALCOPTFRMLBOTTOMUP configuration setting in the Technical Reference . Constant Values Assigned to Members in a Sparse Dimension If you assign a constant to a member in a sparse dimension, Analytic Services automatically creates a data block for every combination of sparse dimension members that contains the member. For example, assume that a member or a calculation script formula contains the following expression: California = 120; In this formula, California is a member in a sparse dimension and 120 is a constant value. Analytic Services automatically creates all possible data blocks for California and assigns the value 120 to all data cells. Many thousands of data blocks may be created. To improve performance, create a formula that does not create unnecessary values. To assign constants in a sparse dimension to only those intersections that require a value, use FIX in a manner similar to the following example: FIX(Colas,Misc,Actual) California = 120; ENDFIX In this example, Colas is a member of the sparse dimension, Product; Actual is a member of the dense dimension, Scenario; and Misc is a member of the dense dimension, Measures. The value 120 is assigned to any intersection of California (in the Market dimension), Actual (in the Scenario dimension), Misc (in the Measures dimension), Colas (in the Product dimension), and any member in the Year dimension, because a specific member of Year is not specified in the script. Because Sample Basic includes only two sparse dimensions, this example affects only one block. If there were additional sparse dimensions, Essbase would ensure that there are data blocks for all combinations of the sparse dimensions with California and Colas, creating new blocks if they do not exist. Within the new blocks, Analytic Services sets Measures and Scenario values (other than those assigned the value 120) to #MISSING. Non-Constant Values Assigned to Members in a Sparse Dimension If you assign non-constant values to members of a sparse dimension, new blocks are created based on the Create Blocks on Equations setting. The Create Blocks on Equations setting is defined at the database level, as a database property. Within calculation scripts you can temporarily override the Create Blocks on Equations setting. (For basic information about this setting, see Non-Constant Values .) Consider the effects of the following calculation when West has no value and the Create Blocks on Equations setting is ON. West = California + 120; Unneeded blocks may be created for all sparse-member intersections with West, even if the corresponding block value is #MISSING for all of the children of West. Especially in a large database, creation and processing of unneeded blocks requires additional processing time. To control creation of blocks when you assign non-constant values to members of a sparse dimension, use the SET CREATEBLOCKONEQ ON OFF command. The following script includes calculations with this setting off and on. FIX (Colas); SET CREATEBLOCKONEQ OFF West = California + 120; SET CREATEBLOCKONEQ ON East = New York + 100; ENDFIX Because the Create Block on Equation setting is disabled at the beginning, West blocks are created only when values exist for the children of West. Later, because the Create Block on Equation setting is enabled, all blocks for East are created. Note: Use of SET CREATEBLOCKONEQ affects only creation of blocks during the execution of the calculation script that contains this command. This command does not change the overall database Create Blocks on Equations setting. For details regarding use of SET CREATEBLOCKEQ ON OFF in calculation scripts, see the Technical Reference . Using Cross-Dimensional Operators (-&gt;) Use caution when using a cross-dimensional operator (-&gt;) in the following situations: On the Left Side of an Equation In Equations in a Dense Dimension On the Left Side of an Equation For faster calculation script performance, use FIX in the calculation script to qualify the use of a formula instead of using a formula that includes a cross-dimensional operator on the left side of an equation. For example, assume that you want to increase the Jan -&gt; Sales values in Sample Basic by 5%. To improve performance by calculating only the relevant combinations of members, use the FIX command in a calculation script: FIX(Jan) Sales = Sales * .05; ENDFIX With the FIX command, Analytic Services calculates the formula only for specified member combinations, in this example, for combinations that include Jan. Compare this technique to using the slower cross-dimensional operator approach. For the previous example, you place the following formula on the Sales member in the database outline: Sales(Sales -&gt; Jan = Sales -&gt; Jan * .05;) As Analytic Services cycles through the database, it calculates the formula for every member combination that includes a member from the dimension tagged as time (Jan, Feb, Mar, etc.), even though only January combinations need to be calculated. For detailed information on calculation scripts and the FIX command, see Using the FIX Command and the Technical Reference . In Equations in a Dense Dimension When you use a cross-dimensional operator in an equation in a dense dimension, Analytic Services does not automatically create the required blocks if both of these conditions apply: Resultant values are from a dense dimension. The operand or operands are from a sparse dimension. You can use the following techniques to create the blocks and avoid the performance issue. Ensure that the results members are from a sparse dimension, not from a dense dimension. In this example, the results member Budget is from a sparse dimension: FIX(Sales) Budget = Actual * 1.1; ENDFIX FIX(Expenses) Budget = Actual * .95; ENDFIX Use the DATACOPY calculation command to create and then calculate the required blocks. See Using DATACOPY to Copy Existing Blocks for more and example and more information about using this command for this purpose. Use a member formula that contains the dense member equations: FIX(Sales, Expenses) Budget (Sales = Sales -&gt; Actual * 1.1; Expenses = Expenses -&gt; Actual * .95;) ENDFIX Using Bottom-Up Calculation A top-down calculation is less efficient than a bottom-up calculation because more blocks are calculated than is necessary. Although a top-down calculation is less efficient than a bottom-up calculation, top-down calculations are necessary in some cases to ensure that calculation results are correct. Use the following topics to determine whether bottom-up and top-down calculation is more appropriate for a particular situation: Bottom-Up and Top-Down Calculation Forcing a Bottom-Up Calculation Bottom-Up and Top-Down Calculation Analytic Services uses one of two calculation methods to do a full calculation of a database outline-bottom-up calculation or top-down calculation. By default, Analytic Services does a bottom-up calculation of a database. For a bottom-up calculation, Analytic Services determines which data blocks need to be calculated before it calculates the database. Analytic Services then calculates only the blocks that need to be calculated. The calculation begins with the existing block with the lowest block number and works up through each block in number order until the existing block with the highest block number is reached. For a detailed explanation of block calculation order, see Block Calculation Order . If the database outline contains a complex member formula, Analytic Services performs a top-down calculation for the relevant member. Use the following information to learn more about simple and complex formula interactions with bottom-up and top-down calculation: Bottom-Up Calculations and Simple Formulas Top-Down Calculations and Complex Formulas Bottom-Up Calculations and Simple Formulas For simple formulas, Analytic Services does a bottom-up calculation to determine which blocks need to be calculated prior to running the full calculation. For example, for a simple formula on a member (such as A = B + C), A is calculated only if B or C exists in the database. That is, the dependency of the formula on B and C is known before the calculation is started. Top-Down Calculations and Complex Formulas Before starting a calculation, Analytic Services searches the database outline and marks complex formulas that require top-down calculation; for example, a member formula that contains a cross-dimensional reference. When Analytic Services reaches a member with a top-down formula, it does a top-down calculation for the member. When a formula on a member is complex, all possible blocks for the member must be examined to see if an existing block needs to be changed or a new block needs to be created; it is difficult to determine the dependency that blocks may have on other blocks prior to the start of the calculation. The top-down method slows calculation performance because Analytic Services must search for appropriate blocks to calculate in order to execute the formula. When a formula is compiled, if the formula is to be calculated top-down, Analytic Services logs a message in the application log file. Consider the following complex formula: A = B -&gt; D + C -&gt; D To calculate the formula, Analytic Services must examine every possible combination of A to see whether B -&gt; D or C -&gt; D exists. For descriptions and examples of complex formulas, see Using Complex Formulas . Forcing a Bottom-Up Calculation If it is appropriate for the site, you can force a bottom-up calculation on a top-down formula. To force a bottom-up calculation, use any of the following methods: Method Topic Where Discussed Location Calculation function @CALCMODE in a formula Technical Reference Calculation script command SET FRMLBOTTOMUP Technical Reference essbase.cfg file setting CALCOPTFRMLBOTTOMUP or CALCMODE Technical Reference Forcing a bottom-up calculation on a formula ordinarily increases performance time. If the formula contains complex functions (for example, range functions) or if the formula's dependencies are not straightforward, a bottom-up calculation may produce results that differ from the results of a top-down calculation. Caution: Before changing the setting CALCOPTFRMLBOTTOMUP or using the calculation script command SET FRMLBOTTOMUP in a production environment, check the validity of calculation results by comparing, relative to the same data, the results of a bottom-up calculation and the results of a top-down calculation. Managing Caches to Improve Performance The following section describes the caches that are used with block storage databases. For information about the aggregate storage cache, see Managing the Aggregate Storage Cache . When calculating a database, Analytic Services uses approximately 30 bytes of memory per member in the database outline. So if the database has 5,000 members, Analytic Services needs approximately 150K of memory to calculate the database. Note: When you run concurrent calculations, each calculation uses separate memory space. For example, if you are running two calculation scripts concurrently, Analytic Services requires 60 bytes per member: 30 bytes per member per script. Concurrent calculations use the same memory caches. You can avoid excess memory use by combining calculation scripts. You can obtain good performance by using parallel calculation with a single calculation script. For a comprehensive discussion of parallel calculation, see Using Parallel Calculation . Analytic Services uses memory to optimize calculation performance, especially for large calculations. The amount of memory used is not controllable, except by altering the size of the database outline. However, you can ensure that the memory cache sizes enable Analytic Services to optimize the calculation. Analytic Services uses memory caches to coordinate memory usage: The calculator cache. Ensure that the calculator cache is large enough to optimize calculation performance. The dynamic calculator cache The index cache. If the database is large, the default index cache is not large enough to provide optimum calculation performance. The data cache. The data file cache. Note: When you calculate a database for the first time, the size of the calculator cache is particularly significant for calculation performance. If possible, ensure that the calculator cache is large enough for Essbase to use the optimal calculator cache option. For a comprehensive discussion of cache sizing, see Sizing Caches . Make sure that you read the entire topic before making any changes. Working with the Block Locking System When a block is calculated, Analytic Services locks the block and all blocks that contain the children of the block. Analytic Services calculates the block and then releases both the block and the blocks containing the children. By default, Analytic Services locks up to 100 blocks concurrently when calculating a block. This number of block locks is sufficient for most database calculations. If you are calculating a formula in a sparse dimension, Analytic Services works most efficiently if it can lock all required child blocks concurrently. Therefore, when calculating a formula in a sparse dimension, you may want to set a lock number higher than 100 if you are consolidating very large numbers of children (for example, more than 100 children). By increasing the number, you ensure that Analytic Services can lock all required blocks, and therefore, performance is not impaired. Analytic Services locking behavior depends on the isolation level setting. For a detailed explanation of locking behavior, see Locking Under Committed Access and Locking Under Uncommitted Access . Note: For consolidations in a sparse dimension, block locking is not a consideration because Analytic Services does not need to lock all blocks containing children concurrently. Using SET LOCKBLOCK and CALCLOCKBLOCK You can use the SET LOCKBLOCK command in a calculation script along with the CALCLOCKBLOCK setting in the essbase.cfg file to specify the maximum number of blocks that Analytic Services can lock concurrently when calculating a block. If you do not modify the default setting and the default 100 blocks is not sufficient during calculation, the calculation may be require more time than expected. Managing Concurrent Access for Users Analytic Services uses the block locking system to manage concurrent access to users. This system ensures that only one user at a time can update or calculate a particular data block. How Analytic Services handles locking blocks and committing data depends on the isolation level setting. When Analytic Services calculates a data block, it creates an exclusive lock. Thus, no other user can update or calculate the data block. However, other users can have read-only access to the block. When Analytic Services finishes the calculation, it releases the block. Other users can then update the block if they have the appropriate security access. When a user is updating a data block, the block is locked. If a database calculation requires a data block that is being updated by another user, the calculation waits for one of the following: For the data block to be released if the isolation level setting is Uncommitted Access. For the calculation to complete if the isolation level setting is Committed Access. Analytic Services does not provide a message to say that the calculation is waiting for the data block to be released. You can prevent calculation delays caused by waiting for locked blocks by using Analytic Services security options to do either of the following: Deny access to other users Disconnect users from Analytic Services For detailed information about and instructions for the security options, see Disconnecting Users and Terminating Requests and Managing Passwords and User Names . For information on how Analytic Services handles locks and transactions, see Understanding How Analytic Services Handles Transactions and Data Locks . Note: When Analytic Services locks a block for calculation, it does not put an exclusive lock on the dependent child blocks. Thus, another user can update values in the child blocks. If necessary, you can use the above security options to prevent such updates. Using Two-Pass Calculation You can improve performance significantly by tagging an accounts dimension member as two-pass in the database outline, if it is appropriate for the application. The combination of data and calculation needs may require the use of a calculation script to calculate a formula twice, instead of two-pass tagging, to preserve accuracy. Use these sections to understand more about two-pass calculation, and decide whether you can tag an accounts dimension member as two-pass to improve performance or whether you must use a calculation script to calculate a formula twice. This section also provides information about how to enable two-pass calculation or create a calculation script for two-pass calculation: Understanding Two-Pass Calculation Reviewing a Two-Pass Calculation Example Understanding the Interaction of Two-Pass Calculation and Intelligent Calculation Choosing Two-Pass Calculation Tag or Calculation Script Enabling Two-Pass on Default Calculations Creating Calculation Scripts for Two-Pass and Intelligent Calculation For information about the interaction of two-pass calculation and attribute members, see Table12 . Understanding Two-Pass Calculation You can use a two-pass calculation on member formulas that need to be calculated twice to produce the correct value. Whenever possible, Analytic Services calculates two-pass formulas at the data block level, calculating the two-pass formulas at the same time as the main calculation. Thus, Analytic Services does not need to do an extra calculation pass through the database. However, in some situations, Analytic Services needs an extra calculation pass through the database. How Analytic Services calculates the two-pass formulas depends on whether there is a dimension tagged as time as well as a dimension tagged as accounts. It also depends on the dense-sparse configuration of the time and account dimensions. Reviewing a Two-Pass Calculation Example For example, consider this calculation required for Profit%: Profit % = Profit % Sales Assume that the following table shows a subset of a data block with Measures and Year as dense dimensions. Measures is tagged as accounts, and Year is tagged as time. The AGGMISSG setting is turned off (the default). Data values have been loaded into the input cells. Analytic Services calculates the shaded cells. The numbers in bold show the calculation order for the cells. Cells with multiple consolidation paths are darkly shaded. Measures -&gt; Year Jan Feb Mar Qtr1 Profit 75 50 120 5 Sales 150 200 240 6 Profit% 1 2 3 4/ 7 Note: For detailed information on how cell calculation order depends on database configuration, see Cell Calculation Order . Analytic Services uses this calculation order: Analytic Services calculates the formula Profit % Sales for Profit % -&gt; Jan, Profit % -&gt; Feb, Profit % -&gt; Mar, and Profit % -&gt; Qtr1 (1, 2, 3, 4 above). Analytic Services calculates Profit -&gt; Qtr1 and Sales -&gt; Qtr1 by adding the values for Jan, Feb, and Mar (5, 6 above). Analytic Services calculates Profit % -&gt; Qtr1 by adding the values for Profit% -&gt; Jan, Profit % -&gt; Feb, and Profit % -&gt; Mar (7 above). This addition of percentages produces the value %125, not the correct result. Measures/Year Jan Feb Mar Qtr1 Profit 75 50 120 245 (5) Sales 150 200 240 590 (6) Profit% 50% (1) 25% (2) 50% (3) 0% (4) 125% (7) If you tag Profit % as two-pass in the database outline, Analytic Services uses the Profit % Sales formula to recalculate the Profit % values and produce the correct results. Measures/Year Jan Feb Mar Qtr1 Profit 75 50 120 245 (5) Sales 150 200 240 590 (6) Profit% 50% (1) 25% (2) 50% (3) 0% (4) 125% (7) 42% (8) For detailed information about multiple calculation passes, see Calculation Passes . Understanding the Interaction of Two-Pass Calculation and Intelligent Calculation Two scenarios are described in detail in the following sections. If you are using Intelligent Calculation, use the scenario that matches the configuration of the database; each scenario tells you how to ensure that Analytic Services calculates two-pass formulas accurately. These scenarios require that you understand the concepts of Intelligent Calculation. For a comprehensive discussion, see Optimizing with Intelligent Calculation. Scenario A Scenario A demonstrates two key approaches: No Extra Calculation Pass for Two-Pass Formulas All Data Blocks Marked As Clean In this scenario, you place formulas in the outline and then, as appropriate, tag specific formulas as two-pass for best performance. No Extra Calculation Pass for Two-Pass Formulas Analytic Services calculates the two-pass formulas while it is calculating the data block. Thus, Analytic Services does not need to do an extra calculation pass through the database. All Data Blocks Marked As Clean After the calculation, all data blocks are marked as clean for the purposes of Intelligent Calculation. When you tag a member formula as two-pass in the outline, Analytic Services does the two-pass calculation while each data block is being calculated. However, when you repeat a formula in a calculation script, Analytic Services has to read the data blocks and write them to memory in order to recalculate the formula. Scenario B Scenario B illustrates two key approaches: Extra Calculation Pass for Two-Pass Formulas Data Blocks for Two-pass Formulas Not Marked As Clean In this scenario, you create a calculation script to perform the formula calculation for best performance. Extra Calculation Pass for Two-Pass Formulas Analytic Services calculates the database and then does an extra calculation pass to calculate the two-pass formulas. Even though all data blocks are marked as clean after the first database calculation, Analytic Services ignores the clean status on the blocks that are relevant to the two-pass formula and recalculates these blocks. Data Blocks for Two-pass Formulas Not Marked As Clean After the first calculation, Analytic Services has marked all the data blocks as clean for the purposes of Intelligent Calculation. In a second calculation pass through the database, Analytic Services recalculates the required data blocks for the two-pass formulas. However, because the second calculation is a partial calculation of the database, Analytic Services does not mark the recalculated blocks as clean. When you recalculate the database with Intelligent Calculation turned on, these data blocks may be recalculated unnecessarily. If the database configuration allows Analytic Services to use Scenario B, consider using a calculation script to perform two-pass formula calculations. If you use a calculation script, Analytic Services still does an extra calculation pass through the database; however, you can ensure that Analytic Services has marked all the data blocks as clean after the calculation. For a review of methods, see Creating Calculation Scripts for Two-Pass and Intelligent Calculation . Choosing Two-Pass Calculation Tag or Calculation Script Even though tagging an accounts member as two-pass may bring performance benefits, some applications cannot use this method. Check these qualifications to see whether you should apply a two-pass tag or create a calculation script that performs a calculation twice for best performance and accuracy: You can tag a member as two-pass if it is in a dimension tagged as accounts. When you perform a default calculation on the database, Analytic Services automatically recalculates any formulas tagged as two-pass if they are in the dimension tagged as accounts in the database outline. You can tag a member as two-pass if it is a Dynamic Calc or Dynamic Calc and Store member of any dimension. For a comprehensive discussion of dynamic calculation, see Dynamically Calculating Data Values. You may need to use a calculation script to calculate a two-pass formula to obtain accurate results, even if the two-pass tag would provide performance benefits. For a review of methods, see Creating Calculation Scripts for Two-Pass and Intelligent Calculation . Use a calculation script instead of the two-pass tag to ensure efficient use of Intelligent Calculation. For a detailed explanation of two scenarios, see Understanding the Interaction of Two-Pass Calculation and Intelligent Calculation . You need to use a calculation script to calculate a formula twice if the database configuration means that Analytic Services uses Scenario A, as described in Scenario A , and if the formula references values from another data block. You may want to use a calculation script to calculate two-pass formulas if the database configuration means that Analytic Services uses Scenario B, as described in Scenario B . Enabling Two-Pass on Default Calculations A database setting enables two-pass calculation in default calculations. When you perform a default calculation on a database with two-pass calculation enabled (the default setting), Analytic Services automatically attempts to calculate any formulas tagged as two-pass in the dimension tagged as accounts in the database outline. This is true even if you have customized the default calculation script. To perform a default calculation, use any of the following methods: Tool Topic Location Administration Services Calculating Block Storage Databases Essbase Administration Services Online Help MaxL execute calculation Technical Reference ESSCMD CALCDEFAULT Technical Reference To enable two-pass calculation, use any of the following methods: Tool Topic Location Administration Services Using Two-Pass on a Default Calculation Essbase Administration Services Online Help MaxL alter database Technical Reference ESSCMD SETDBSTATE Technical Reference Creating Calculation Scripts for Two-Pass and Intelligent Calculation Use these methods to create calculation scripts to perform two-pass calculations with Intelligent Calculation, so that the calculation is accurate and as fast as possible: Before the calculation script command that recalculates a two-pass formula, add the SET UPDATECALC OFF command to disable Intelligent Calculation. If you have Intelligent Calculation enabled (the default), Analytic Services calculates only the data blocks that are not marked as clean, but when you perform a default calculation of the database with Intelligent Calculation enabled, all data blocks are marked as clean, so Analytic Services does not perform the two-pass formula recalculation. When you use a calculation script, Analytic Services does not automatically recalculate two-pass formulas. Use the CALC TWOPASS command. If you have changed the default calculation from the default CALC ALL and Intelligent Calculation is enabled, the data blocks may not be marked as clean after the first calculation. For more information, see Optimizing with Intelligent Calculation. You can check the default calculation setting by selecting the database, right-clicking and selecting Set &gt; Default calculation in Administration Services. To obtain the performance benefits of Intelligent Calculation when performing the first, full calculation of the database, use one of these methods, depending on the calculation needs and outline structure: Intelligent Calculation with a Large Index Intelligent Calculation with a Small Index Intelligent Calculation Turned Off for a Two-Pass Formula These three options all use the following example situation: The outline has a dimension tagged as accounts, and it is a dense dimension. You want to calculate sales for each product as a percentage of sales for all products. Assume this formula should calculate the dimension: Sales % Sales -&gt; Product When Analytic Services calculates the data block for each product, it has not yet calculated the value Sales-&gt;Product, so the results for the sales of each product as a percentage of total sales are incorrect. Intelligent Calculation with a Large Index If the index is quite large and you want the benefit of using Intelligent Calculation, you can use any of the following options for the best performance: Use a Calculation Script Use a Calculation Script and the Two-Pass Tag Use a Client and a Calculation Script All three of these options perform the same tasks: Enable Intelligent Calculation. Calculate the full database and marks the data blocks as clean. Disable Intelligent Calculation. Mark the recalculated blocks as clean, even though this calculation is a partial calculation of the database. If you do not use the command SET CLEARUPDATESTATUS AFTER, Analytic Services marks data blocks as clean only after a full calculation of the database. Analytic Services cycles through the database calculating only the formula for the relevant member (Share of Sales in our example), or calculating all formulas tagged as two-pass in the database outline. Use a Calculation Script Use this model to create a calculation script that performs a full calculation of the database with Intelligent Calculation enabled: SET UPDATECALC ON; CALC ALL; SET UPDATECALC OFF; SET CLEARUPDATESTATUS AFTER; Share of Sales = Sales % Sales -&gt; Product; Use a Calculation Script and the Two-Pass Tag Use this procedure to tag a member as two-pass, and use a calculation script to calculate first the full database, then the two-pass member: Place a formula in the database outline and tag it as two-pass. Place the formula on the appropriate member in the dimension tagged as accounts, in our example, Share of Sales. Create a calculation script that performs a full database calculation and then a two-pass calculation: SET UPDATECALC ON; CALC ALL; SET UPDATECALC OFF; SET CLEARUPDATESTATUS AFTER; CALC TWOPASS; Use a Client and a Calculation Script Use this procedure to perform a default calculation from a client and then use a calculation script to perform the formula calculation: Enable Intelligent Calculation if this default has been changed. Perform a full calculation, using any of the tools listed in Table83 . Use a calculation script similar to this example to disable Intelligent Calculation and calculate the formula: SET UPDATECALC OFF; SET CLEARUPDATESTATUS AFTER; Share of Sales = Sales % Sales -&gt; Product; or: SET UPDATECALC OFF; SET CLEARUPDATESTATUS AFTER; CALC TWOPASS; Table 83: Methods for Performing a Full Calculation Tool Topic Location Administration Services Calculating Databases Essbase Administration Services Online Help MaxL execute calculation Technical Reference ESSCMD CALCDEFAULT Technical Reference For a comprehensive discussion of Intelligent Calculation, see Optimizing with Intelligent Calculation. For detailed information on developing formulas and calculation scripts, see Developing Formulas and Developing Calculation Scripts. Intelligent Calculation with a Small Index If the index is small and you want the benefit of using Intelligent Calculation, use this procedure: Create a calculation script to calculate the database, but tell Analytic Services not to mark the calculated data blocks as clean Mark all data blocks as clean, and do not recalculate the data blocks. SET CLEARUPDATESTATUS OFF; CALC ALL; CALC TWOPASS; SET CLEARUPDATESTATUS ONLY; CALC ALL; With the example script, Analytic Services performs these tasks: The SET CLEARUPDATESTATUS OFF command tells Analytic Services not to mark the calculated data blocks as clean. The first CALC ALL command causes Analytic Services to cycle through the database calculating all dirty data blocks. Analytic Services does not mark the calculated data blocks as clean. Analytic Services does not automatically recalculate the formulas tagged as two-pass in the database outline. The CALC TWOPASS command causes Analytic Services to cycle through the database recalculating the formulas that are tagged as two-pass in the dimension tagged as accounts in the database outline. Analytic Services recalculates the formulas because the required data blocks are not marked as clean by the previous CALC ALL. Analytic Services does not mark the recalculated data blocks as clean. The SET CLEARUPDATESTATUS ONLY command tells Analytic Services to mark the data blocks as clean but not to calculate the data blocks. This command disables calculation. The last CALC ALL command causes Analytic Services to cycle through the database and mark all the data blocks as clean. Analytic Services searches through the index and marks the data blocks as clean. It does not calculate the data blocks. Intelligent Calculation Turned Off for a Two-Pass Formula Create a calculation script that performs these tasks: Disables Intelligent Calculation. Performs a full calculation. Repeats the two-pass formula: SET UPDATECALC OFF; CALC ALL; Share of Sales = Sales % Sales -&gt; Product; Choosing Between Member Set Functions and Performance Queries and calculations which reference a member that has been tagged as Dynamic Calc or Dynamic Calc and Store may be significantly slower than queries and calculations involving the same members, if the member has formulas involving any of these functions: @CURRMBR @PARENT @SPARENTVAL @ANCEST @SANCESTVAL If you are experiencing slow performance, you may wish to either remove the dynamic calculation tag or remove these functions from the attached formula. Consolidating #MISSING Values If no data value exists for a combination of dimension members, Analytic Services gives the combination a value of #MISSING. Analytic Services treats #MISSING values and zero (0) values differently. Understanding #MISSING calculation This table shows how Analytic Services calculates #MISSING values. In this table, X represents any number: Table 84: How Analytic Services Treats #MISSING Values (Continued) Calculation/Operation Result X + #MISSING X X - #MISSING #MISSING - X X -X X * #MISSING #MISSING X / #MISSING #MISSING / X X / 0 #MISSING #MISSING #MISSING X % #MISSING #MISSING % X X % 0 #MISSING #MISSING #MISSING X == #MISSING FALSE, unless X is #MISSING X != #MISSING X &lt; &gt; #MISSING TRUE, unless X is #MISSING TRUE, unless X is #MISSING (X &lt;= #MISSING) (X &lt;= 0) (X &gt;= #MISSING) (X &gt;= 0) or (X == #MISSING) (X &gt; #MISSING) (X &gt; 0) (X &lt; #MISSING) (X &lt; 0) X AND #MISSING: Y AND #MISSING, where Y represents any nonzero value #MISSING 0 AND #MISSING #MISSING AND #MISSING 0 #MISSING X OR #MISSING: Y OR #MISSING, where Y represents any nonzero value 0 OR #MISSING #MISSING OR #MISSING 1 #MISSING #MISSING IF (#MISSING) IF (0) f (#MISSING) #MISSING for any Analytic Services function of one variable f (X) #MISSING for any X not in the domain of f and any Analytic Services function of more than one variable (except where specifically noted) By default, Analytic Services does not roll up #MISSING values. However, if you always load data at level 0 and never at parent levels, then you should enable the setting for consolidating #MISSING values. Use of this setting provides a calculation performance improvement of between 1% and 30%. The performance improvement varies, depending on database size and configuration. Caution: The default, not consolidating #MISSING values, must be in effect if you load data at parent, rather than child, levels, if any child member combinations have #MISSING values. If all child member combinations have any other values, including zero (0), then Analytic Services rolls up the child values and overwrites the parent values correctly, so you can safely change the default. Changing Consolidation for Performance To consolidate, enable the setting for consolidating #MISSING values by using one of the methods described above. The degree of performance improvement you achieve depends on the ratio between upper level blocks and input blocks in the database. To change the way Analytic Services consolidates #MISSING values, use any of the following methods: Tool Topic Location Administration Services Aggregating Missing Values During Calculation Essbase Administration Services Online Help Calculation script SET AGGMISSG Technical Reference MaxL alter database Technical Reference ESSCMD SETDBSTATEITEM Technical Reference Note: If you enable the setting for consolidating #MISSING values, the cell calculation order within a data block changes. For more information, see Cell Calculation Order . When the setting for consolidating #MISSING values is disabled, note that the performance overhead is particularly high in the following two situations: When you have a low ratio of calculated data blocks to input data blocks When you load many data values at parent levels on sparse dimensions; for example, in the Sample Basic database, if you load many data values into East in a sparse Market dimension In these situations, the performance overhead is between 10% and 30%. If calculation performance is critical, you may want to reconsider the database configuration or reconsider how you load data. For a detailed explanation of how Analytic Services calculates #MISSING values, see Consolidating #MISSING Values . Removing #MISSING Blocks CLEARDATA changes the value of cells in a block to #MISSING. It does not remove the data blocks. These extra blocks can slow performance. If the #MISSING blocks are slowing performance, perform either of these tasks: Use the CLEARBLOCK command to remove the data blocks. Export the data and import it again. For a review of methods, see Exporting Data and Reloading Exported Data . Identifying Additional Calculation Optimization Issues The relationship between calculation and performance is also described in the following chapters: In Dynamically Calculating Data Values, see the following topics: Benefitting from Dynamic Calculation Choosing Between Dynamic Calc and Dynamic Calc and Store Reducing the Impact on Retrieval Time Dynamically Calculating Data in Partitions In Developing Calculation Scripts, see the following topics: Specifying Global Settings for a Database Calculation Writing Calculation Scripts for Partitions For the relationship of two-pass calculation and the SET CLEARUPDATESTATUS command, see the Technical Reference . When you convert currencies using the CCONV command, the resulting data blocks are marked as dirty for the purposes of Intelligent Calculation. This means that Analytic Services recalculates all the converted blocks when you recalculate the database. For a comprehensive discussion of Intelligent Calculation, see Optimizing with Intelligent Calculation.  |../dcaoptcs.htm",
    "Optimizing with Intelligent Calculation||This chapter provides information on how to use Intelligent Calculation to optimize the performance of Analytic Services calculations. This chapter includes the following sections: Introducing Intelligent Calculation Using Intelligent Calculation Using the SET CLEARUPDATESTATUS Command Calculating Data Blocks Understanding the Effects of Intelligent Calculation For information on using other methods to optimize database calculations, see the following chapters: Designing Partitioned Applications Dynamically Calculating Data Values Optimizing Calculations Introducing Intelligent Calculation When you do a full calculation of a database, Analytic Services tracks which data blocks it has calculated. If you then load a subset of data, on subsequent calculations, you can choose to calculate only those data blocks that Analytic Services has not yet calculated but need calculation, and those calculated blocks that require recalculation because of the new data. This process is called Intelligent Calculation. By default, Intelligent Calculation is turned on. You can change this default setting in the essbase.cfg file. For more information about the essbase.cfg file, see the Technical Reference . You can also turn Intelligent Calculation on or off in a calculation script. For a brief explanation, see Turning Intelligent Calculation On and Off . Benefits of Intelligent Calculation Intelligent Calculation is designed to provide significant calculation performance benefits for these types of calculations: For a full calculation of a database (CALC ALL) For a calculation script that calculates all members in one CALC DIM command. For database calculations that cannot use Intelligent Calculation for the full calculation, you may be able to use Intelligent Calculation for part of the calculation. For example, consider a case in which you calculate a database by doing a default consolidation and then an allocation of data. To significantly improve calculation performance in this case, enable Intelligent Calculation for the default consolidation and then disable Intelligent Calculation for the allocation. Assuming that Intelligent Calculation is turned on (the default), create a calculation script to perform these steps for a partial Intelligent Calculation: Enable Intelligent Calculation if the default has been changed Use CALC ALL to calculate the database Use the SET UPDATECALC command to disable Intelligent Calculation for the next step Allocate data Optionally, enable Intelligent Calculation again Intelligent Calculation and Data Block Status To provide Intelligent Calculation, Analytic Services checks the status of the data blocks in a database. Data blocks have a calculation status of either clean or dirty. Analytic Services marks a data block as clean after certain calculations. When Intelligent Calculation is enabled, Analytic Services calculates only dirty blocks and their dependent parents. Disabling Intelligent Calculation means that Analytic Services calculates all data blocks, regardless of whether they are marked as clean or dirty. Use these topics to understand clean and dirty status, and to learn how to manage clean and dirty status for Intelligent Calculation: Marking Blocks As Clean Marking Blocks as Dirty Maintaining Clean and Dirty Status Marking Blocks As Clean Analytic Services marks data blocks as clean in these types of calculations: A full calculation (CALC ALL) of a database, the default calculation for a database. A calculation script that calculates all the dimensions in one CALC DIM statement. For example, the following calculation script calculates all members in the Sample Basic database: CALC DIM(Measures, Product, Market, Year, Scenario); Compare this calculation script to a calculation script that calculates all the members with two CALC DIM statements: CALC DIM(Measures, Product); CALC DIM(Market, Year, Scenario); Using two CALC DIM statements causes Analytic Services to do at least two calculation passes through the database. In this calculation, Analytic Services does not, by default, mark the data blocks as clean. Because Intelligent Calculation depends on accurate clean and dirty status, you must manage these markers carefully. For an example, see Maintaining Clean and Dirty Status . Analytic Services marks calculated data blocks as clean only in situations described above, unless you use the SET CLEARUPDATESTATUS command in a calculation script. For a comprehensive discussion of using the command, see Using the SET CLEARUPDATESTATUS Command . Marking Blocks as Dirty Analytic Services marks a data block as dirty in the following situations: Calculating the data block for a partial calculation of the database only if SET CLEARUPDATESTATUS AFTER is not part of the partial calculation command in the calculation script Loading data into the data block Restructuring the database (for example, by adding a member to a dense dimension) Copying data to the data block, for example using DATACOPY Maintaining Clean and Dirty Status If you want to use Intelligent Calculation when calculating a subset of a database or when performing multiple calculation passes through a database, consider carefully the implications of how Analytic Services marks data blocks as clean. When using Intelligent Calculation, you must accurately maintain the clean and dirty status of the data blocks to ensure that Analytic Services recalculates the database as efficiently as possible. For example, when you calculate a subset of a database, the newly calculated data blocks are not marked as clean by default. You can ensure that the newly calculated blocks are marked as clean by using the SET CLEARUPDATESTATUS AFTER command in a calculation script. To ensure accurate calculation results, review the information in Using the SET CLEARUPDATESTATUS Command and the Technical Reference (Calculation Commands List: CLEARUPDATESTATUS) before creating the calculation script. Limitations of Intelligent Calculation Consider the following limitations when using Intelligent Calculation: Intelligent Calculation works on a data block level and not on a cell level. For example, if you load a data value into one cell of a data block, the whole data block is marked as dirty. Changing a formula on the database outline or changing an accounts property on the database outline does not cause Analytic Services to restructure the database. Therefore, Analytic Services does not mark the affected blocks as dirty. You must recalculate the appropriate data blocks. For a review of methods, see Changing Formulas and Accounts Properties . Whenever possible, Analytic Services calculates formulas that are tagged as two pass and in the dimension tagged as accounts as part of the main calculation of a database. However, you may need to use a calculation script to calculate some formulas twice. When you use a calculation script, disable Intelligent Calculation before recalculating formulas. When SET CREATENONMISSINGBLK is set to ON in a calculation script, Intelligent Calculation is turned off and affected blocks are calculated, regardless if they are marked clean or dirty. Using Intelligent Calculation This section provides information on turning Intelligent Calculation on and off and on using Intelligent Calculation with different types of calculations: Turning Intelligent Calculation On and Off Using Intelligent Calculation for a Default, Full Calculation Using Intelligent Calculation for a Calculation Script, Partial Calculation Turning Intelligent Calculation On and Off By default, Intelligent Calculation is turned on. You can change the default by using the UPDATECALC setting in the essbase.cfg file. You can turn Intelligent Calculation on and off for the duration of a calculation script by using the SET UPDATECALC command in a calculation script. Enabling Intelligent Calculation means that Analytic Services calculates only dirty blocks and their dependent parents. Disabling Intelligent Calculation means that Analytic Services calculates all data blocks, regardless of whether they are marked as clean or dirty. For detailed information on these commands and on the essbase.cfg file, see the Technical Reference . Using Intelligent Calculation for a Default, Full Calculation Intelligent Calculation provides significant performance benefits when you do a full calculation (CALC ALL) of a database. If you do a full calculation of a database, leave Intelligent Calculation turned on (the default) to take advantage of the performance benefits that it provides. Unless you have changed the default, a full calculation (CALC ALL) is the default calculation for a database. To check the current calculation setting, see Setting the Default Calculation in the Essbase Administration Services Online Help . Caution: When using Intelligent Calculation, note the information in Limitations of Intelligent Calculation . Calculating for the First Time When you do a full calculation of a database for the first time, Analytic Services calculates every existing block. The performance is the same whether you have Intelligent Calculation turned on or off. Recalculating When you do a full recalculation of a database with Intelligent Calculation turned on, Analytic Services checks each block to see if it is marked as clean or dirty. For an explanation of clean and dirty, see Intelligent Calculation and Data Block Status . Checking the data blocks has a 5% to 10% performance overhead. During most recalculations, this small performance overhead is insignificant when compared to the performance gained by enabling Intelligent Calculation. However, if you recalculate a database in which more than approximately 80% of the values have changed, the overhead of Intelligent Calculation may outweigh the benefits. In this case, disable Intelligent Calculation. Using Intelligent Calculation for a Calculation Script, Partial Calculation Analytic Services marks a data block as clean when it calculates the data block on a full calculation (CALC ALL) or when it calculates all dimensions in one CALC DIM command. For a description of the types of calculations for which data blocks are marked clean, see Marking Blocks As Clean . In any other calculations, Analytic Services does not mark calculated data blocks as clean, unless you use the SET CLEARUPDATESTATUS command in a calculation script. For example, if you calculate a subset of a database or calculate a database in two calculation passes, Analytic Services does not mark the calculated blocks as clean, unless you use the SET CLEARUPDATESTATUS command. The following calculation scripts do not cause Analytic Services to mark the calculated data blocks as clean: FIX(New York) CALC DIM(Product, Measures); ENDFIX CALC DIM(Measures, Product); CALC DIM(Market, Year, Scenario); Be sure to use SET CLEARUPDATESTATUS to avoid unnecessary recalculations. Using the SET CLEARUPDATESTATUS Command In some cases, Analytic Services does not mark calculated blocks as clean; for example, if you calculate a subset of a database or calculate a database in two calculation passes. To manually mark data blocks as clean for purposes of Intelligent Calculation, use the SET CLEARUPDATESTATUS command in a calculation script. Use these sections to understand the command SET CLEARUPDATESTATUS, choose a setting, and for instructions about how to use the command: Understanding SET CLEARUPDATESTATUS Choosing a SET CLEARUPDATESTATUS Setting Reviewing Examples That Use SET CLEARUPDATESTATUS For a comprehensive discussion of the relationship between Intelligent Calculation and data block status, see Intelligent Calculation and Data Block Status . Understanding SET CLEARUPDATESTATUS The SET CLEARUPDATESTATUS command has three parameters-AFTER, ONLY, and OFF. SET CLEARUPDATESTATUS AFTER; Analytic Services marks calculated data blocks as clean, even if it is calculating a subset of a database. SET CLEARUPDATESTATUS ONLY; Analytic Services marks the specified data blocks as clean but does not calculate the data blocks. This parameter provides the same result as AFTER, but without calculation. SET CLEARUPDATESTATUS OFF; Analytic Services calculates the data blocks but does not mark the calculated data blocks as clean. Data blocks are not marked as clean, even on a full calculation (CALC ALL) of a database. The existing clean or dirty status of the calculated data blocks remains unchanged. Choosing a SET CLEARUPDATESTATUS Setting When you use the SET CLEARUPDATESTATUS command to mark calculated data blocks as clean, be aware of these recommendations before selecting the parameter (AFTER, ONLY, OFF): Only calculated data blocks are marked as clean. Do not use the SET CLEARUPDATESTATUS AFTER command with concurrent calculations unless you are certain that the concurrent calculations do not need to calculate the same data block or blocks. If concurrent calculations attempt to calculate the same data blocks, with Intelligent Calculation enabled, Analytic Services does not recalculate the data blocks if the data blocks are already marked as clean by the other concurrent calculation. For an example, see Handling Concurrent Calculations . When Analytic Services calculates data blocks on a first calculation pass through a database, it marks the data blocks as clean. If you try to calculate the same data blocks on a subsequent pass with Intelligent Calculation enabled, Analytic Services does not recalculate the data blocks because they are already marked as clean. Reviewing Examples That Use SET CLEARUPDATESTATUS Assume a scenario using the Sample Basic database: The sparse dimensions are Market and Product. New York is a member on the sparse Market dimension. Intelligent Calculation is turned on (the default). These three examples show different ways of using SET CLEARUPDATESTATUS: Example 1: CLEARUPDATESTATUS AFTER Example 2: CLEARUPDATESTATUS ONLY Example 3: CLEARUPDATESTATUS OFF Example 1: CLEARUPDATESTATUS AFTER SET CLEARUPDATESTATUS AFTER; FIX(New York) CALC DIM(Product); ENDFIX In this example, Analytic Services searches for dirty parent data blocks for New York (for example New York -&gt; Colas, in which Colas is a parent member). It calculates these dirty blocks and marks them as clean. (The calculation is based on the Product dimension.) Analytic Services does not mark the level 0 data blocks as clean because they are not calculated. For information on level 0 blocks, see Defining Calculation Order. Example 2: CLEARUPDATESTATUS ONLY SET CLEARUPDATESTATUS ONLY; FIX(New York) CALC DIM(Product); ENDFIX Analytic Services searches for dirty parent data blocks for New York (for example New York -&gt; Colas, in which Colas is a parent member on the Product dimension). Analytic Services marks the dirty parent data blocks as clean, but does not calculate the data blocks. Analytic Services does not mark the level 0 data blocks as clean because they are not calculated. For example, if New York -&gt; 100-10 (a level 0 block) is dirty, it remains dirty. Example 3: CLEARUPDATESTATUS OFF SET CLEARUPDATESTATUS OFF; CALC ALL; CALC TWOPASS; SET CLEARUPDATESTATUS ONLY; CALC ALL; In this example, Analytic Services first calculates all the dirty data blocks in the database. The calculated data blocks remain dirty. Analytic Services does not mark them as clean. Analytic Services then calculates the members tagged as two pass that are in the dimension tagged as accounts. Because the data blocks are still marked as dirty, Analytic Services recalculates them. Again, it does not mark the calculated data blocks as clean. Analytic Services then searches for all the dirty blocks in the database and marks them as clean. It does not calculate the blocks, even though a CALC ALL command is used. Calculating Data Blocks Analytic Services creates a data block for each unique combination of sparse dimension members, provided that at least one data value exists for the combination. Each data block represents all dense dimension member values for that unique combination of sparse dimension members. For example, in the Sample Basic database, the Market and Product dimensions are sparse. Therefore, the data block New York -&gt; Colas represents all the member values on the Year, Measures, and Scenario dimensions for the sparse combination New York -&gt; Colas. These sections provide information about conditions that affect performance with Intelligent Calculation: Calculating Dense Dimensions Calculating Sparse Dimensions Handling Concurrent Calculations Understanding Multiple-Pass Calculations These sections assumes that you are familiar with the concepts of upper level, level 0, and input data blocks. For explanations of these terms, to describe roles and relationships, and for an explanation of how Analytic Services creates data blocks, see Data Storage in Data Blocks . Calculating Dense Dimensions When you calculate a dense dimension and do not use a FIX command, Analytic Services calculates at least some of the data values in every data block in the database. For example, the following calculation script is based on the Sample Basic database: SET CLEARUPDATESTATUS AFTER; CALC DIM(Year); This script calculates the Year dimension, which is a dense dimension. Because Year is dense, every data block in the database includes members of the Year dimension. Therefore, Analytic Services calculates data values in every data block. Because the script uses the SET CLEARUPDATESTATUS AFTER command, Analytic Services marks all the data blocks as clean. Calculating Sparse Dimensions When you calculate a sparse dimension, Analytic Services may not need to calculate every data block in the database. For example, the following calculation script is based on Sample Basic: SET CLEARUPDATESTATUS AFTER; CALC DIM(Product); This script calculates the Product dimension, which is a sparse dimension. Because Product is sparse, a data block exists for each member on the Product dimension. For example, one data block exists for New York -&gt; Colas and another for New York -&gt; 100-10. Level 0 Effects The data block New York -&gt; 100-10 is a level 0 block, it does not represent a parent member on either sparse dimension (Market or Product). The data values for New York -&gt; 100-10 are input values; they are loaded into the database. Therefore, Analytic Services does not need to calculate this data block. Nor does Analytic Services mark the data block for New York -&gt; 100-10 as clean, even though the script uses the SET CLEARUPDATESTATUS AFTER command. Note: Analytic Services does calculate level 0 data blocks if a corresponding sparse, level 0 member has a formula applied to it. If you load data into a database, the level 0 data blocks into which you load data are marked as dirty. If you subsequently calculate only a sparse dimension or dimensions, the level 0 blocks remain dirty, because Analytic Services does not calculate them. Therefore, when you recalculate only a sparse dimension or dimensions, Analytic Services recalculates all upper-level data blocks because the upper-level blocks are marked as dirty if their child blocks are dirty, even though the upper level blocks were originally clean. Upper Level Effects Colas is a parent level member on the Product dimension. Analytic Services needs to calculate values for Colas, so Analytic Services calculates this data block. Because the script uses the SET CLEARUPDATESTATUS AFTER command, Analytic Services marks the data block as clean. When Analytic Services calculates a sparse dimension, it recalculates an upper level data block if the block is dependent on one or more dirty child blocks. Unnecessary Calculation You can avoid unnecessary calculation by ensuring that you calculate at least one dense dimension. When you calculate a dense dimension and do not use the FIX command, data values are calculated in every data block, including the level 0 blocks. So the level 0 blocks are marked as clean. Handling Concurrent Calculations If concurrent calculations attempt to calculate the same data blocks and Intelligent Calculation is turned on, Analytic Services may not recalculate the data blocks because they are already marked as clean. Do not use the SET CLEARUPDATESTATUS AFTER command with concurrent calculations unless you are certain that the concurrent calculations do not calculate the same data block or blocks. Consider the following example, which is based on the Sample Basic database. Actual and Budget are members of the dense Scenario dimension. Because Scenario is dense, each data block in the database contains both Actual and Budget values. SET CLEARUPDATESTATUS AFTER; FIX(New York, Actual) CALC DIM(Product, Year); ENDFIX If User One runs the above calculation script, Analytic Services calculates the Actual values for all data blocks that represent New York. Analytic Services marks the calculated data blocks as clean, even though not all the data values in each calculated block have been calculated. For example, the Budget values have not yet been calculated. SET CLEARUPDATESTATUS AFTER; FIX(New York, Budget) CALC DIM(Product, Year); ENDFIX If User Two runs the calculation script above to calculate the Budget values for New York, Analytic Services does not recalculate the specified data blocks, because they are already marked as clean. The calculation results for Budget are not correct. One way to solve this problem is to make the Scenario dimension sparse; then the Actual and Budget values are in different data blocks, for example, New York -&gt; Colas -&gt; Actual and New York -&gt; Colas -&gt; Budget. In this case, the second calculation script correctly calculates Budget data block. Understanding Multiple-Pass Calculations Whenever possible, Analytic Services calculates a database in one calculation pass through the database. For an explanation of why and how multiple calculation passes are performed, see Calculation Passes . When you use a calculation script to calculate a database, the number of calculation passes that Analytic Services performs depends upon the calculation script. For detailed information about the relationship between calculation passes and Intelligent Calculation, see Intelligent Calculation and Data Block Status . For information about grouping formulas and calculations, see Grouping Formulas and Calculations . For example, assume Analytic Services calculates data blocks on a first calculation pass through a database and then marks them as clean. If you then attempt to calculate the same data blocks on a subsequent pass and Intelligent Calculation enabled, Analytic Services does not recalculate the data blocks because they are already marked as clean. Reviewing Examples and Solutions for Multiple-Pass Calculations These examples describe situations in which you obtain incorrect calculation results, and provide a solution you can implement to obtain correct results: Example 1: Intelligent Calculation and Two Pass Example 2: SET CLEARUPDATESTATUS and FIX Example 3: SET CLEARUPDATESTATUS and Two CALC DIM Commands The examples are based on the Sample Basic database and assume that Intelligent Calculation is turned on. Example 1: Intelligent Calculation and Two Pass This calculation script does a default calculation and then a two-pass calculation: CALC ALL; CALC TWOPASS; Error Analytic Services calculates the dirty data blocks in the database and marks all the data blocks as clean. Analytic Services then needs to recalculate the members tagged as two pass in the dimension tagged as accounts. However, Analytic Services does not recalculate the specified data blocks because they are already marked as clean. The calculation results are not correct. Solution You can calculate the correct results by disabling Intelligent Calculation for the two pass calculation. Example 2: SET CLEARUPDATESTATUS and FIX This calculation script calculates data values for New York. The calculation is based on the Product dimension: SET CLEARUPDATESTATUS AFTER; FIX(New York) CALC DIM(Product); ENDFIX CALC TWOPASS; Error Analytic Services performs the following processes: Analytic Services cycles through the database calculating the dirty data blocks that represent New York. The calculation is based on the Product dimension. Thus, Analytic Services calculates only the blocks that represent a parent member on the Product dimension (for example, New York -&gt; Colas, New York -&gt; Root Beer, and New York -&gt; Fruit Soda), and then only calculates the aggregations and formulas for the Product dimension. Because the SET CLEARUPDATESTATUS AFTER command is used, Analytic Services marks the calculated data blocks as clean, even though not all data values in each calculated block have been calculated. Analytic Services should recalculate the members tagged as two pass in the dimension tagged as accounts. However, some of these data blocks are already marked as clean from the calculation in step2 . Analytic Services does not recalculate the data blocks that are already marked as clean. The calculation results are not correct. Solution You can calculate the correct results by disabling Intelligent Calculation for the two pass calculation. Example 3: SET CLEARUPDATESTATUS and Two CALC DIM Commands This calculation script bases the database calculation on the Product and Year dimensions. Because two CALC DIM commands are used, Analytic Services does two calculation passes through the database: SET CLEARUPDATESTATUS AFTER; CALC DIM(Product); CALC DIM(Year); Error Analytic Services performs the following processes: Analytic Services cycles through the database calculating the dirty data blocks. The calculation is based on the Product dimension, as in Example 2. Because the SET CLEARUPDATESTATUS AFTER command is used, Analytic Services marks the calculated data blocks as clean, even though not all data values in each calculated block have been calculated. Analytic Services should recalculate the data blocks. The recalculation is based on the Year dimension. However, as a result of the calculation in step2 , some of the data blocks are already marked as clean. Analytic Services does not recalculate the data blocks that are already marked as clean. The calculation results are not correct. Solution You can calculate the correct results by using one CALC DIM command to calculate both the Product and Year dimensions. Analytic Services then calculates both dimensions in one calculation pass through the database. The following calculation script calculates the correct results: SET CLEARUPDATESTATUS AFTER; CALC DIM(Product, Year); Note: When you calculate several dimensions in one CALC DIM command, Analytic Services calculates the dimensions in the default calculation order and not in the order in which you list them in the command. For a description of default calculation order, see Member Calculation Order . Example 4: Two Separate Calculation Scripts This example calculates data values for New York but calculates based on two different dimensions using two separate calculation scripts. The first calculation script calculates the Product dimension: SET CLEARUPDATESTATUS AFTER; FIX(New York) CALC DIM(Product); ENDFIX Analytic Services calculates the data blocks that include New York. The calculation is based on the Product dimension. Thus, Analytic Services calculates only the dirty blocks that include a parent member on the Product dimension (for example, New York -&gt; Colas, New York -&gt; Root Beer, and New York -&gt; Fruit Soda), and even then only calculates the aggregations and formulas for the Product dimension. Because of the CLEARUPDATESTATUS AFTER command, Analytic Services marks the calculated data blocks as clean, even though not all data values in each calculated block have been calculated. The second calculation script calculates the Year dimension: SET CLEARUPDATESTATUS AFTER; FIX(New York) CALC DIM(Year); ENDFIX Analytic Services calculates the data blocks that represent New York. The calculation is based on the Year dimension, which is a dense dimension. Thus, Analytic Services should calculate all data blocks that include New York, although within each block, Analytic Services calculates only the aggregations and formulas for the Year dimension. Error As a result of the first calculation, some of the data blocks for New York are already marked as clean. Analytic Services does not recalculate these data blocks with the second calculation script because the data blocks are already marked as clean. The calculation results are not correct. Solution You can calculate the correct results by telling Analytic Services not to mark the calculated data blocks as clean. The following calculation script calculates the correct results: SET CLEARUPDATESTATUS OFF; FIX(New York) CALC DIM(Product); ENDFIX SET CLEARUPDATESTATUS AFTER; FIX(New York) CALC DIM(Year); ENDFIX The SET CLEARUPDATESTATUS OFF command. With it, Analytic Services calculates dirty data blocks, but does not to mark them as clean, unlike the SET CLEARUPDATESTATUS AFTER command. This solution assumes that the data blocks are not already marked as clean from a previous partial calculation of the database. You can ensure that all data blocks are calculated, irrespective of their clean or dirty status, by disabling Intelligent Calculation. The following calculation script calculates all specified data blocks, irrespective of their clean or dirty status: SET UPDATECALC OFF; FIX(New York) CALC DIM(Year, Product); ENDFIX Because you have not used the SET CLEARUPDATESTATUS AFTER command, Analytic Services does not mark calculated data blocks as clean. Understanding the Effects of Intelligent Calculation Using Intelligent Calculation may have implications for the way you administer a database. This section discusses the implications of each of the following actions: Changing Formulas and Accounts Properties Using Relationship and Financial Functions Restructuring Databases Copying and Clearing Data Converting Currencies Changing Formulas and Accounts Properties Neither changing a formula in the database outline nor changing an accounts property in the database outline causes Analytic Services to restructure the database. Thus, data blocks affected by such a change are not marked as dirty. For example, if you change a time balance tag in the dimension tagged as accounts, Analytic Services does not restructure the database and does not mark the affected blocks as dirty. When you subsequently run a default calculation with Intelligent Calculation turned on, the changes are not calculated. To recalculate the appropriate data blocks, use a calculation script to perform any of the following tasks: Disable Intelligent Calculation and calculate the member formula that has changed. Disable Intelligent Calculation and use the FIX command to calculate the appropriate subset of a database. Disable Intelligent Calculation and perform a default CALC ALL on a database. Using Relationship and Financial Functions If you use relationship functions (for example, @PRIOR or @NEXT) or financial functions (for example, @ACCUM, @NPV, or @INTEREST) in a formula on a sparse dimension or a dense dimension, Analytic Services always recalculates the data block that contains the formula. For detailed information on specific relationship functions and financial functions, see the Technical Reference . Restructuring Databases When you restructure a database (for example, by adding a member to a dense dimension), all data blocks potentially need recalculating. Therefore, Analytic Services marks all data blocks as dirty. When you calculate the restructured database, all blocks are calculated. Note: Changing a formula in the database outline or changing an accounts property in the database outline does not cause Analytic Services to restructure the database. You must recalculate the appropriate data blocks. For more information, see Changing Formulas and Accounts Properties . Copying and Clearing Data When you copy values to a data block by using the DATACOPY command, the resulting data block is marked as dirty. Analytic Services calculates the block when you recalculate a database. When you clear data values by using the CLEARDATA and CLEARBLOCK commands, Analytic Services clears all the blocks regardless of whether they are marked as clean or dirty. Converting Currencies When you convert currencies using the CCONV command, the resulting data blocks are marked as dirty. Analytic Services calculates all converted blocks when you recalculate a database.  |../dcaoptic.htm",
    "Calculating Time Series Data||This chapter explains how to calculate time series data in block storage databases. For example, you can do inventory tracking by calculating the first and last values for a specific time period. You can also calculate period-to-date values. This chapter pertains to block storage databases. For block storage databases, time series calculations assume that you have Dynamic Time Series members defined in the outline. Dynamic Time Series members are not supported for aggregate storage database outlines. However, you can perform time series calculations and queries on aggregate storage databases using the MDX PeriodsToDate function. For more information, see the MDX section of the Technical Reference . This chapter includes the following sections: Calculating First, Last, and Average Values Calculating Period-to-Date Values Using Dynamic Time Series Members in Partitions Calculating First, Last, and Average Values Using time balance and variance reporting tags on the dimension tagged as accounts, you can tell Analytic Services how to perform time balance calculations on accounts data. Analytic Services usually calculates a parent in the dimension tagged as time by consolidating or calculating the formulas on the parent's children. However, you can use accounts tags, such as time balance and variance reporting tags, to consolidate a different kind of value. For example, if you tag a parent member in the accounts dimension with a time balance property of First, Analytic Services calculates the member by consolidating the value of the member's first child. For example, in the Sample Basic database, the Opening Inventory member in the Measures dimension (the accounts dimension) has a time balance property of First. This member represents the inventory at the beginning of the time period. If the time period is Qtr1, Opening Inventory represents the inventory available at the beginning of Jan (the first member in the Qtr1 branch). To use accounts tags, you must have a dimension tagged as accounts and a dimension tagged as time. You use the First, Last, and Average tags (time balance properties) and the Expense tag (variance reporting property) only on members of a dimension tagged as accounts. The dimensions you tag as time and accounts can be either dense or sparse dimensions. Note: If you are using Intelligent Calculation, changing accounts tags in the database outline does not cause Analytic Services to restructure the database. You may have to tell Analytic Services explicitly to recalculate the required data values. For a discussion of how and why to perform a recalculation, see Changing Formulas and Accounts Properties . Specifying Accounts and Time Dimensions When you tag a dimension as accounts, Analytic Services knows that the dimension contains members with accounts tags. When you tag a dimension as time, Analytic Services knows that this dimension is the one on which to base the time periods for the accounts tags. In the Sample Basic database, the Measures dimension is tagged as accounts, and the Year dimension is tagged as time. Figure 193: Sample Basic Outline Showing Accounts and Time Tags For information on tagging accounts and time dimensions, see Creating a Time Dimension and Creating an Accounts Dimension . Reporting the Last Value for Each Time Period For an accounts dimension member, you can tell Analytic Services to move the last value for each time period up to the next level. To report the last value for each time period, set the member's time balance property as Last. (In the database outline, the TB Last tag is displayed.) For example, in the Sample Basic database, the accounts member Ending Inventory consolidates the value for the last month in each quarter and uses that value for that month's parent. For example, the value for Qtr1 is the same as the value for Mar. Figure 194: Sample Basic Outline Showing Last Tag For information on tagging an accounts member as Last, see Setting Time Balance Properties . By default, Analytic Services does not skip #MISSING or zero (0) values when calculating a parent value. You can choose to skip these values. For a discussion of how and why to skip #MISSING values, see Skipping #MISSING and Zero Values . Reporting the First Value for Each Time Period For an accounts dimension member, you can tell Analytic Services to move the first value for each time period up to the next level. To report the first value for each time period, set the member's time balance property as First. (The tag displays as TB First in the database outline.) For example, in the Sample Basic database, the accounts member Opening Inventory consolidates the value of the first month in each quarter and uses that value for that month's parent. For example, the value for Qtr1 is the same as the value for Jan. Figure 195: Sample Basic Outline Showing First Tag For information on tagging an accounts member as First, see Setting Time Balance Properties . By default, Analytic Services does not skip #MISSING or zero (0) values when calculating a parent value. You can choose to skip these values. For a discussion of how and why to skip #MISSING values, see Skipping #MISSING and Zero Values . Reporting the Average Value for Each Time Period For an accounts dimension member, you can tell Analytic Services to average values across time periods and consolidate the average up to the next level. For example, you can tell Analytic Services to average the values for Jan, Feb, and Mar and then use that value for the Qtr1 value. To report the average value for each time period, set the member's time balance property as Average. For information on tagging an accounts member as Average, see Setting Time Balance Properties . By default, Analytic Services does not skip #MISSING or zero (0) values when it calculates a parent value. Thus, when it calculates the average, Analytic Services aggregates the child values and divides by the number of children, regardless of whether the children have #MISSING or zero values. You can tell Analytic Services to skip #MISSING and zero values. For a discussion of how and why to skip #MISSING values, see Skipping #MISSING and Zero Values . Skipping #MISSING and Zero Values You can tell Analytic Services how to treat #MISSING and zero (0) values when doing time balance calculations. A #MISSING value is a marker in Analytic Services that indicates that the data in this location does not exist, does not contain any meaningful value, or was never entered. By default, Analytic Services does not skip #MISSING or 0 (zero) values when calculating a parent value. You can override this default by setting a skip property. For a discussion of how skip properties work, see Setting Skip Properties . For example, if you tag an accounts dimension member as Last and Skip Missing, then Analytic Services consolidates the last non-missing child to the parent. Consider the following example: Accounts -&gt; Time Jan Feb Mar Qtr1 Accounts Member ( Last, Skip Missing ) 60 70 #MI 70 Tagging an account as Average and Skip Missing may produce different results from tagging that account as Average and Skip None. A calculation performed with Average and Skip None produces correct results because no data is skipped. But because grandparents with children are consolidated by summing the averages, results of a calculation on an account with Average and Skip Missing is incorrect unless you use Dynamic Calc or Two Pass tags. Considering the Effects of First, Last, and Average Tags The following table shows how Analytic Services consolidates the time dimension based on the time balance (TB) First, Last, and Average tags on accounts dimension members. Accounts -&gt; Time Jan Feb Mar Qtr1 Accounts Member1 11 12 13 36 Value of Jan+Feb+Mar Accounts Member2 ( TBFirst ) 20 25 21 20 Value of Jan Accounts Member3 ( TBLast ) 25 21 30 30 Value of Mar Accounts Member4 ( TBAverage ) 20 30 28 26 Average of Jan, Feb, Mar Placing Formulas on Time and Accounts Dimensions If you place a member formula on a time or accounts dimension, it may be overwritten by a time balance calculation. Consider the following example from Sample Basic, in which Opening Inventory is tagged as First: Measures -&gt; Year Jan Feb Mar Qtr1 Opening Inventory: First 30000 28000 27000 30000 Because Opening Inventory is tagged as First, Analytic Services calculates Opening Inventory for Qtr1 by taking the Opening Inventory for Jan value. Any member formula that is placed on Qtr1 in the database outline is overwritten by this time balance calculation. Calculating Period-to-Date Values You can calculate period-to-date values for data. For example, you can calculate the sales values for the current quarter up to the current month. If the current month is May, using a standard calendar quarter, the quarter total is the total of the values for April and May. In Analytic Services, you can calculate period-to-date values in two ways: During a batch calculation, using the @PTD function Dynamically, when a user requests the values, using Dynamic Time Series members This section explains how to use Dynamic Time Series members to dynamically calculate period-to-date values. Using Dynamic Time Series members is the most efficient method in almost all cases. For an example using the @PTD function to calculate period-to-date values, see Calculating Period-to-Date Values . Using Dynamic Time Series Members In order to calculate period-to-date values dynamically, you need to use a Dynamic Time Series member for a period on the dimension tagged as time. See Specifying Accounts and Time Dimensions . You do not create the Dynamic Time Series member directly in the database outline. Instead, you enable a predefined Dynamic Time Series member and associate it with an appropriate generation number. This procedure creates a Dynamic Time Series member for you. For example, if you want to calculate quarter-to-date values, you enable the Q-T-D member and associate it with the generation to which you want to apply the Dynamic Time Series member. In Sample Basic, the generation containing quarters is generation number 2, which contains the Qtr1, Qtr2, Qtr3, and Qtr4 members. Analytic Services creates a Dynamic Time Series member called Q-T-D and associates it with generation 2. The Q-T-D member calculates monthly values up to the current month in the quarter. For a brief discussion, see Enabling Dynamic Time Series Members . Figure 196: Sample Basic Outline Showing Time Dimension Dynamic Time Series members are not displayed as members in the database outline. Instead, Analytic Services lists the currently active Dynamic Time Series members in a comment on the time dimension. In the following outline, H-T-D (history-to-date) and Q-T-D (quarter-to-date) are active. H-T-D is associated with generation 1; Q-T-D is associated with generation 2. Figure 197: Sample Basic Outline Showing Dynamic Time Series Analytic Services provides eight predefined Dynamic Time Series members: H-T-D Y-T-D S-T-D P-T-D Q-T-D M-T-D W-T-D D-T-D History-to-date Year-to-date Season-to-date Period-to-date Quarter-to-date Month-to-date Week-to-date Day-to-date These eight members provide up to eight levels of period-to-date reporting. How many members you use and which members you use depends on the data and the database outline. For example, if the database contains hourly, daily, weekly, monthly, quarterly, and yearly data, you might want to report day-to date (D-T-D), week-to-date (W-T-D), month-to-date (M-T-D), quarter-to-date (Q-T-D), and year-to-date (Y-T-D) information. If the database contains monthly data for the past 5 years, you might want to report year-to-date (Y-T-D) and history-to-date (H-T-D) information, up to a specific year. If the database tracks data for seasonal time periods, you might want to report period-to-date (P-T-D) or season-to-date (S-T-D) information. You can associate a Dynamic Time Series member with any generation in the time dimension except the highest generation number, irrespective of the data. For example, if you choose, you can use the P-T-D member to report quarter-to-date information. You cannot associate Dynamic Time Series members with level 0 members of the time dimension. Note: We recommend you avoid assigning time balance properties (First, Last, Average, Skip Missing) to members set for dynamic calculations if you plan to use these members in Dynamic Time Series calculations. Doing so may retrieve incorrect values for the parent members in your accounts dimension. Enabling Dynamic Time Series Members To use Dynamic Time Series members, you need to enable them. If required, you can specify aliases for Dynamic Time Series members. For a brief discussion, see Specifying Alias Names for Dynamic Time Series Members . To enable Dynamic Time Series members, see Enabling Dynamic Time Series Members in the Essbase Administration Services Online Help . Note: The number of generations displayed depends on the number of generations in the time dimension. You cannot associate Dynamic Time Series members with the highest generation (level 0 members). After you enable Dynamic Time Series members in the database outline, Analytic Services adds a comment to the dimension tagged as time. Figure198 shows the Sample Basic database with H-T-D and Q-T-D defined. Figure 198: Sample Basic Outline Showing Dynamic Time Series Members Year Time (Active Dynamic Time Series Members: H-T-D, Q-T-D) (Dynamic Calc) Disabling Dynamic Time Series Members To disable a Dynamic Time Series member, tell Analytic Services not to use the predefined member. To disable Dynamic Time Series members, see Disabling Dynamic Time Series Members in the Essbase Administration Services Online Help . Specifying Alias Names for Dynamic Time Series Members You can specify alias names for predefined Dynamic Time Series members, such as QtrToDate, for the Q-T-D Dynamic Time Series member. You can then use the alias names to retrieve the Dynamic Time Series members in Spreadsheet Services, Spreadsheet Add-in, or in a report. You can create up to eight alias names for each Dynamic Time Series member. Analytic Services saves each alias name in the Dynamic Time Series alias table that you specify. To create aliases for Dynamic Time Series members, see Creating Aliases for Dynamic Time Series Members in the Essbase Administration Services Online Help . For information on specifying and displaying alias names, see Setting Aliases . Applying Predefined Generation Names to Dynamic Time Series Members When you enable a Dynamic Time Series member and associate it with a generation number, Analytic Services creates a predefined generation name for that generation number. For information on creating generation names, see Naming Generations and Levels . To display generation and level names, see Naming Generations and Levels in the Essbase Administration Services Online Help . The following table shows the Dynamic Time Series members and their corresponding generation names: Member Generation Name Member Generation Name H-T-D History Q-T-D Quarter Y-T-D Year M-T-D Month S-T-D Season W-T-D Week P-T-D Period D-T-D Day These member and generation names are reserved for use by Analytic Services. If you use one of these generation names to create a generation name on the time dimension, Analytic Services automatically creates and enables the corresponding Dynamic Time Series member for you. For example, in Sample Basic, you can create a generation name called Quarter for generation number 2. Quarter contains quarterly data in the members Qtr1, Qtr2, and so on. When you create the generation name Quarter, Analytic Services creates and enables a Dynamic Time Series member called Q-T-D. Retrieving Period-to-Date Values When you retrieve a Dynamic Time Series member, you need to tell Analytic Services the time period up to which you want to calculate the period-to-date value. This time period is known as the latest time period and must be a level 0 member on the time dimension. Use the following methods to specify the latest time period: For a specific member, in Spreadsheet Services or Spreadsheet Add-in, specify the latest period member name. Place that name after the Dynamic Time Series member or alias name. For example, Q-T-D(May) returns the quarter-to-date value by adding values for April and May. For a retrieval, use one of the following methods to specify the latest time period: Use the &lt;LATEST command in Report Writer. Specify the Latest Time Period option in the Essbase Options dialog box in Spreadsheet Add-in or the Essbase Spreadsheet Preferences Dialog Box in Spreadsheet Services. For more information, see the relevant spreadsheet online help. The member-specific setting-for example, Q-T-D(May)-takes precedence over the &lt;LATEST or Latest Time Series option setting. The following example shows Sample Basic data. Q-T-D(May) displays the period-to-date value for May that is obtained by adding the values for Apr and May (8644 + 8929 = 17573). Figure 199: Spreadsheet Showing Period-To-Date Value for May Using Dynamic Time Series Members in Partitions If Dynamic Time Series members are part of the shared area between databases, define the Dynamic Time Series members in both databases, just as you would for regular members. For example, if the partition definition includes Qtr1, Qtr2, Qtr3, Qtr4, and the Dynamic Time Series member Q-T-D, define the Q-T-D member in both the source database and the target database. If a Dynamic Time Series member is not part of the shared area between databases, Analytic Services gets the data for that member from the source database. You do not need to define the Dynamic Time Series member in both databases. However, this configuration is generally less efficient than including the Dynamic Time Series member in the partition definition. For a comprehensive discussion of partitioning, see Creating and Maintaining Partitions.  |../dcatimse.htm",
    "Developing Custom-Defined Calculation Functions||This chapter explains how to develop custom-defined functions and use them in Analytic Services formulas and calculation scripts. Custom-defined functions are written in the Java TM programming language and enable you to create calculation functions not otherwise supported by the Analytic Services calculation scripting language. Analytic Services does not provide tools for creating Java classes and archives. This chapter assumes that you have a compatible version of the Java Development Kit (JDK) and a text editor installed on the computer you use to develop custom-defined functions. For information on compatible versions of Java, see the Essbase Analytic Services Installation Guide . For additional examples of custom-defined functions, see the Technical Reference . Use these sections to create and use custom-defined functions: Viewing Custom-Defined Functions Creating Custom-Defined Functions Using Registered Custom-Defined Functions Updating Custom-Defined Functions Removing Custom-Defined Functions Considering How Custom-Defined Functions Affect Performance and Memory Note: The information in this chapter is not relevant to aggregate storage databases. Viewing Custom-Defined Functions You can view custom-defined functions to determine whether a function has been registered successfully and whether it is registered locally or globally. No custom-defined functions are displayed until they have been created and registered. Analytic Services does not supply sample custom-defined functions. To view a custom-defined function, use either of the following methods: Tool Topic Location Administration Services Viewing Custom-Defined Functions Essbase Administration Services Online Help MaxL display function Technical Reference For example, use the following MaxL statement to view the custom-defined functions in the Sample application and any registered global functions: display function Sample; The display function statement lists global functions without an application name to indicate that they are global. If the application contains a function with the same name as a global function, only the local function is listed. Creating Custom-Defined Functions There are several steps required to create a custom-defined function: Learn the requirements for custom-defined functions. See the following sections for more information: Understanding Java Requirements for Custom-Defined Functions Understanding Method Requirements for Custom-Defined Functions Understanding Security and Custom-Defined Functions Understanding Scope and Custom-Defined Functions Naming Custom-Defined Functions Write a public Java class that contains at least one public, static method to be used as a custom-defined function. For instructions, see Creating and Compiling the Java Class . Install the Java class created in step 2. For instructions, see Installing Java Classes on Analytic Server . Register the custom-defined function as a local or global function. For instructions, see Registering Custom-Defined Functions . Understanding Java Requirements for Custom-Defined Functions The basis of a custom-defined function is a Java class and method created by a database administrator or Java programmer to perform a particular type of calculation. Creating and testing these Java classes and methods is the first step toward creating a custom-defined function. You can create more than one method in a class for use as a custom-defined function. In general, it is recommended that you create all the methods you want to use as custom-defined functions in a single class. However, if you want to add new custom-defined functions that are not going to be used across all applications on the Analytic Server, create them in a new class and add them to the Analytic Server in a separate .jar file. When creating multiple Java classes that contain methods for use as custom-defined functions, verify that each class name is unique. Duplicate class names cause methods in the duplicate class not to be recognized, and you cannot register those methods as custom-defined functions. After creating the Java classes and methods for custom-defined functions, test them using test programs in Java. When you are satisfied with the output of the methods, install them on Analytic Server and register them in a single test application. Do not register functions globally for testing, because registering functions globally makes it more difficult to update them if you find problems. Understanding Method Requirements for Custom-Defined Functions Methods in custom-defined functions can have any combination of the following supported data types as input parameters: Table 27: Data Types Allowed As Input Parameters Type Type boolean byte char java.lang.String short, int, long com.hyperion.essbase.calculator.CalcBoolean float, double arrays of any of these types CalcBoolean is an Analytic Services-specific data type that can include three values-TRUE, FALSE, and #MISSING. For more information about the other listed data types, see the documentation for the Java Development Kit. The method return data type can be void or any of the preceding data types. Returned data types are converted to Analytic Services-specific data types. Strings are mapped to a string type. Boolean values are mapped to the CalcBoolean data type. All other values are mapped to a double type. Note: Double variables returned with infinite or Not-a-Number values are not supported by Analytic Services. If these values are returned from a Java program, they may not be recorded or displayed correctly in Analytic Services. Double variables should be checked for infinite or Not-a-Number values and set to finite values before being returned to Analytic Services. For more information, see the entry for the class, Double, in the documentation for the Java Development Kit. For additional examples of Java custom-defined functions, see the MaxL statement create function in the Technical Reference . Understanding Security and Custom-Defined Functions Analytic Services requires that you have these security permissions: To create, delete, and manage local (application-wide) custom-defined functions, you must have security permission of application designer or higher. To create, delete, and manage global (server-wide) custom-defined functions, you must have security permission of supervisor. Understanding Scope and Custom-Defined Functions Custom-defined functions are registered as either local (application-wide) or global (Analytic Server-wide) in scope. When you register a local custom-defined function, it is available only in the application in which it was registered. When you register a global custom-defined function, it is available to all applications on the Analytic Server on which it was registered. When developing and testing custom-defined functions, make sure to register and test new functions locally within a test application. You should never register custom-defined functions globally until you have thoroughly tested them and are ready to use them as part of a production environment. Naming Custom-Defined Functions When you register a custom-defined function in Analytic Services, you give the function a name. This name is used in calculation scripts and formulas and is distinct from the Java class and method name used by the function. Remember these requirements when you create function names: Custom-defined function names must start with an @ symbol; for example, @MYFUNCTION. The rest of a function name can contain letters, numbers, and the following symbols: @, #, $, and _. Function names cannot contain spaces. The names of custom-defined functions which are called only by custom-defined macros should start with @_ to distinguish them from general use functions and macros. Custom-defined functions must have unique names. Function names must be different from each other, from the names of custom-defined macros, and from the names of existing calculation functions. If an Analytic Services application contains a local function that has the same name as a global function, the local function is used for calculation. For information about and instructions for registering custom-defined functions, see Registering Custom-Defined Functions . Creating and Compiling the Java Class To create a Java class for a custom-defined function, use this procedure: Start a text editor and create a Java class. For example, open a text editor and create this class: public class CalcFunc public static double sum (double[] data) int i, n = data.length; double sum = 0.0d; for (i=0; i&lt;n; i++) double d = data [i]; sum = sum + d;  return sum; Save the Java class as a .java file; for example, CalcFunc.java . Compile the Java class using the JDK javac tool. At the operating system command prompt, move to the directory containing the class you want to compile and use the javac tool. For example, to compile the CalcFunc.java class, type this command: &gt;javac CalcFunc.java Resolve any compiling errors and repeat steps 2 and 3 until the compiler creates a new .class file; for example, CalcFunc.class . Installing Java Classes on Analytic Server When you install Java classes on Analytic Server, you must first compile the classes into a Java Archive ( .jar ) file, and then copy the .jar file to a specific location on the computer running Analytic Server. Note: You must either stop and restart Analytic Services applications or stop and restart Analytic Server when you install new .jar files. To create a .jar file from a .class file and install it on an Analytic Server: At the operating system command prompt, move to the directory containing the class you want to add to a .jar file and use the JDK jar tool. To add CalcFunc.class to a .jar file, type this command: &gt;jar cf CalcFunc.jar CalcFunc.class Copy the .jar file to one of the following locations on the computer running Analytic Server: The ARBORPATH \\java\\udf\\ directory. This location is recommended for .jar files containing global custom-defined functions. If this directory does not exist, create the directory. The ARBORPATH \\ app\\ AppName \\udf\\ directory where AppName is the name of the application where the local custom-defined function will be used. If this directory does not exist, create the directory. Use this location if you want the code in the .jar file to only be used with a specific application. If the .jar file is placed in another location, you must modify the CLASSPATH variable to include the full path and file name for the .jar file. If the functions will only be used by specific applications, restart those applications in Analytic Services. Otherwise, restart Analytic Server. Registering Custom-Defined Functions After you have compiled the Java classes for custom-defined functions into .jar files and installed the .jar files on Analytic Server, you must register the custom-defined functions before you can use them in calculation scripts and formulas. For rules about naming custom-defined functions, see Naming Custom-Defined Functions . When you register a global custom-defined function, all Analytic Services applications on the Analytic Server can use it. Be sure you test custom-defined functions in a single application (and register them only in that application) before making them global functions. Use the same process for updating the catalog of functions as you do for updating the catalog of macros. After you register a custom-defined function, see Refreshing the Catalog of Custom-Defined Macros . Caution: Do not register global functions for testing, because registering them globally makes it more difficult to change them if you find problems. To register a custom-defined function, use either of the following methods: Tool Topic Location Administration Services Creating Custom-Defined Functions Essbase Administration Services Online Help MaxL create function Technical Reference To register a custom-defined function with local scope, include the application name as a prefix. For example, use the following MaxL statement to register the local custom-defined function in the class CalcFunc from Creating and Compiling the Java Class to be used within the Sample application: create function Sample.'@JSUM' as 'CalcFunc.sum' spec '@JSUM(memberRange)' comment 'adds list of input members'; To register a custom-defined function with global scope, do not include the application name as a prefix. For example, use the following MaxL statement to register as a global function the custom-defined function in the class CalcFunc from Creating and Compiling the Java Class : create function '@JSUM' as 'CalcFunc.sum'; spec '@JSUM(memberRange)' comment 'adds list of input members'; The AppName . prefix is not included in the name of the function. The lack of a prefix makes a function global. Note: Specifying input parameters for the Java method is optional. If you do not specify input parameters, Analytic Services reads them from the method definition in the Java code. However, if you are registering two or more custom-defined functions with the same method name but with different parameter sets, you must register each version of the function separately, specifying the parameters for each version of the function. Using Registered Custom-Defined Functions After registering custom-defined functions, you can use them like native Analytic Services calculation commands. Functions you registered locally-using the AppName. prefix on the function name-are only available for use in calculation scripts or formulas within the application in which they were registered. If you registered the custom-defined functions globally, then the functions are available to all calculation scripts and formulas on the Analytic Server where the functions are registered. For information and instructions for registering custom-defined functions, see Registering Custom-Defined Functions . To use a registered custom-defined function: Create a new calculation script or formula, or open an existing calculation script or formula. If the custom-defined function was registered locally-within a specific application-then you must use a calculation script or formula within that application. If the custom-defined function was registered globally, then you can use any calculation script or formula on Analytic Server. Add the custom-defined function to a new or existing calculation script or formula. To use the custom-defined function shown earlier in this chapter, use this calculation script: New York = @JSUM(@LIST(2.3, 4.5, 6.6, 1000.34)); Use this calculation script with the Sample Basic sample database, or replace New York with the name of a member in a test database. Save the calculation script or formula, and then run it as usual. For a comprehensive discussion of creating and running calculation scripts, see Developing Calculation Scripts. For a comprehensive discussion of creating and running formulas, see Developing Formulas. Updating Custom-Defined Functions When you update a custom-defined function, there are two major issues to consider: Is the function registered locally or globally? Have the class name, method name, or input parameters changed in the Java code for the custom-defined function? The answers to these questions determine the procedure for updating the custom-defined function. For a review of methods to determine whether a custom-defined function is local or global, see Viewing Custom-Defined Functions . To update a custom-defined function, in most cases, you must replace the .jar file that contains the code for the function, and then re-register the function. However, if the signature of the custom-defined function-the Java class name, method name and input parameters-have not changed and the function has only one set of input parameters (it is not an overloaded method), you can simply replace the .jar file that contains the function. In either situation, you must stop and restart the Analytic Services application or Analytic Server where the custom-defined function is registered, depending on whether it is a local or global function. Note: The following procedure is effective only if the signature of the custom-defined function-the Java class name, method name, and input parameters for the custom-defined function-has not changed. To update a custom-defined function whose signature has not changed: Make the changes to the Java class for the custom-defined function and use Java test programs to test its output. Compile the Java classes and encapsulate them in a .jar file, using the same name as the previous .jar file. Make sure to include any other classes and methods for custom-defined functions that were included in the previous .jar file. Perform one of the following steps: If the function is registered locally, shut down the application in which it was registered. If the function is registered globally, shut down all running applications. Copy the new .jar file to Analytic Server over the existing .jar file with the same name. Restart the applications you shut down in step 3. Updating Local Custom-Defined Functions Local custom-defined functions are registered with an AppName. prefix on the function name and can be used only within the application where they were registered. To update a local custom-defined function, you must stop and restart the Analytic Services application where the function is registered. To update a local custom-defined function: Make the changes to the Java class for the custom-defined function and use Java test programs to test its output. Compile the Java classes and encapsulate them in a .jar file, using the same name as the previous .jar file. Make sure to include any other classes and methods for custom-defined functions that were included in the previous .jar file. Perform one of the following steps: If the .jar file contains local custom-defined functions only, shut down any Analytic Services applications that use these functions. If the .jar file contains any global custom-defined functions, shut down all Analytic Services applications. If you are unsure as to which Analytic Services applications use which functions in the .jar file you are replacing, shut down all Analytic Services applications. Copy the new .jar file to Analytic Server over the existing .jar file with the same name. Use MaxL or Essbase Administration Services to replace the custom-defined function. In MaxL, use the create or replace function statement to replace the custom-defined function; for example, type this statement: create or replace function sample.'@JSUM' as 'CalcFunc.sum'; In Essbase Administration Services, see Editing Custom-Defined Functions in Essbase Administration Services Online Help . Updating Global Custom-Defined Functions Global custom-defined functions are registered without an AppName. prefix on the function name and are available in any application running on the Analytic Server where they are registered. To update a global custom-defined function, you must stop and restart all applications on Analytic Server. Global custom-defined functions can be used in calculation scripts and formulas across Analytic Server, so you should verify that no calculation scripts or formulas are using a global custom-defined function before updating it. Caution: Only a database administrator should update global custom-defined functions. To update a global custom-defined function: Make the changes to the Java class for the custom-defined function and use Java test programs to test its output. Compile the Java classes and encapsulate them in a .jar file, using the same name as the previous .jar file. Make sure to include any other classes and methods for custom-defined functions that were included in the previous .jar file. Shut down all running Analytic Services applications. Copy the new .jar file to Analytic Server over the existing .jar file with the same name. Use MaxL or Essbase Administration Services to replace the custom-defined function. In MaxL, use the create or replace function statement to replace the custom-defined function; for example, type this statement: create or replace function '@JSUM' as 'CalcFunc.sum'; In Essbase Administration Services, see Editing Custom-Defined Functions in Essbase Administration Services Online Help . Removing Custom-Defined Functions When removing a custom-defined function, you must first determine whether the function is registered locally or globally to identify the security permissions required: To remove a custom-defined function with global scope, you must have supervisor permission. To remove a custom-defined function with local scope, you must have application designer permission for the application, or any wider permission. Before removing custom-defined functions, you should verify that no calculation scripts or formulas are using them. Global custom-defined functions can be used in calculation scripts and formulas across Analytic Server, so you must verify that no calculation scripts or formulas on Analytic Server are using a global custom-defined function before removing it. For a review of methods to determine whether a custom-defined function is local or global, see Viewing Custom-Defined Functions . Removing Local Custom-Defined Functions Local custom-defined functions are registered with an AppName. prefix on the function name and can only be used within the application where they are registered. When you remove a local custom-defined function, be sure to stop and restart the Analytic Services application where the function is registered to update the catalog. To remove a custom-defined function, use either of the following methods: Tool Topic Location Administration Services Deleting Custom-Defined Functions Essbase Administration Services Online Help MaxL drop function Technical Reference For example, use the following MaxL statement to remove the @JSUM function from the Sample application: drop function Sample.'@JSUM'; Removing Global Custom-Defined Functions Global custom-defined functions are registered without an AppName. prefix on the function name and are available in any application running on Analytic Server where they are registered. Be sure to stop and restart all running Analytic Services applications when you remove a global custom-defined function. Global custom-defined functions can be used in calculation scripts and formulas across Analytic Server, so you should verify that no calculation scripts or formulas are using a global custom-defined function before removing it. Caution: Only a database administrator with supervisor permission can remove global custom-defined functions. Removal of global custom-defined functions should only be performed when no users are accessing Analytic Services databases and no calculation routines are being performed. To remove a global custom-defined function, use either of the following methods: Tool Topic Location Administration Services Deleting Custom-Defined Functions Essbase Administration Services Online Help MaxL drop function Technical Reference For example, use the following MaxL statement to remove the global @JSUM function: drop function '@JSUM'; Copying Custom-Defined Functions You can copy custom-defined functions to any Analytic Server and application to which you have appropriate access. To copy a custom-defined macro, use either of the following methods: Tool Topic Location Administration Services Copying Custom-Defined Functions Essbase Administration Services Online Help MaxL create function Technical Reference Considering How Custom-Defined Functions Affect Performance and Memory The ability to create and run custom-defined functions is provided as an extension to the Analytic Services calculator framework. When you use custom-defined functions, consider how their use affects memory resources and calculator performance. Performance Considerations Because custom-defined functions are implemented as an extension of the Analytic Services calculator framework, you can expect custom-defined functions to operate less efficiently than functions that are native to the Analytic Services calculator framework. In tests using a simple addition function running in the Java Runtime Environment 1.3 on the Windows NT 4.0 platform, the Java function ran 1.8 times (about 80%) slower than a similar addition function performed by native Analytic Services calculation commands. To optimize performance, limit use of custom-defined functions to calculations that you cannot perform with native Analytic Services calculation commands, particularly in applications where calculation speed is a critical consideration. Memory Considerations Use of the Java Virtual Machine (JVM) and Java API for XML Parsing has an initial effect on the memory required to run Analytic Services. The memory required to run these additional components is documented in the memory requirements for Analytic Services. For more information about memory requirements, see the Essbase Analytic Services Installation Guide . Beyond these start-up memory requirements, the Java programs you develop for custom-defined functions sometimes require additional memory. When started, the JVM for Win32 operating systems immediately allocates 2 MB of memory for programs. This allocation is increased according to the requirements of the programs that are then run by the JVM. The default upper limit of memory allocation for the JVM on Win32 operating systems is 64 MB. If the execution of a Java program exceeds the default upper limit of memory allocation for the JVM, the JVM generates an error. For more information about JVM memory management and memory allocation details for other operating systems, see the Java Development Kit documentation. Considering the default memory requirements of the JVM and the limitations of the hardware on which you run servers, carefully monitor your use of memory. In particular, developers of custom-defined functions should be careful not to exceed memory limits of the JVM when creating large objects within custom-defined functions.  |../dcaudfs.htm",
    "Developing Custom-Defined Calculation Macros||This chapter explains how to develop custom-defined macros and how to use them in calculation scripts and formulas. Custom-defined macros are written with calculator functions and special macro functions. Macros enable you to combine multiple calculation functions into a single function. For more details about the macro language syntax and rules, and examples of the use of the macro language, see the Technical Reference . This chapter includes the following sections: Understanding Custom-Defined Macros Viewing Custom-Defined Macros Creating Custom-Defined Macros Using Custom-Defined Macros Updating Custom-Defined Macros Removing Custom-Defined Macros Note: The information in this chapter is not relevant to aggregate storage databases. Understanding Custom-Defined Macros Custom-defined macros use an internal macro language that enables you to combine calculation functions and operate on multiple input parameters. When developing and testing custom-defined macros, make sure to create and test new macros locally within a test application. You should register custom-defined macros globally only after you have tested them and are ready to use them as part of a production environment. Analytic Services requires that you have a security level of database designer or higher to create and manage custom-defined macros. Viewing Custom-Defined Macros View a custom-defined macro to determine whether a macro has been successfully created or whether a custom-defined macro is local or global. To view a custom-defined macro, use either of the following methods: Tool Topic Location Administration Services Viewing Custom-Defined Macros Essbase Administration Services Online Help MaxL display macro Technical Reference Creating Custom-Defined Macros When you create a custom-defined macro, Analytic Services records the macro definition and stores it for future use. Create the macro once, and then you can use it in formulas and calculation scripts until the macro is updated or removed from the catalog of macros. Use these sections to understand more about creating custom-defined macros and to find instructions for creating them: Understanding Scope Naming Custom-Defined Macros Creating Macros Refreshing the Catalog of Custom-Defined Macros Understanding Scope You can create custom-defined macros locally or globally. When you create a local custom-defined macro, the macro is only available in the application in which it was created. When you create a global custom-defined macro, the macro is available to all applications on the server where it was created. When you create a global custom-defined macro, all Analytic Services applications can use it. Be sure you test custom-defined macros in a single application (and create them only in that application) before making them global macros. Caution: When testing macros, do not create the macros as global (using a macro name without the AppName. prefix), because global macros are difficult to update. For information about the methods for updating custom-defined macros, see Updating Custom-Defined Macros . For rules about naming custom-defined macros, see Naming Custom-Defined Macros . Naming Custom-Defined Macros Remember these requirements when you create macro names: The names of custom-defined macro must start with an @ symbol; for example, @MYMACRO. The rest of a macro name can contain letters, numbers, and the following symbols: @, #, $, and _. Macro names can not contain spaces. The names of custom-defined macros which are only called by other macros should start with @_ to distinguish them from general use macros and functions. Macros must have unique names. Macro names must be different from each other, from the names of custom-defined functions, and from the names of existing calculation functions. If an application contains a local macro that has the same name as a global macro, the local macro takes precedence and is used for calculation. Creating Macros To create a custom-defined macro, use either of the following methods: Tool Topic Location Administration Services Creating Custom-Defined Macros Essbase Administration Services Online Help MaxL create macro Technical Reference Be sure to add the application name plus a period (.) as a prefix before the name of the local macro. In this example, Sample is the prefix for the local macro name. This prefix assigns the macro to an application, so the macro is only available within that application. For example, use the following MaxL statement to create a local macro named @COUNTRANGE used only in the Sample application: create macro Sample.'@COUNTRANGE'(Any) AS '@COUNT(SKIPMISSING, @RANGE(@@S))' spec '@COUNTRANGE(MemberRange)' comment 'counts all non-missing values'; For example, use the following MaxL statement to create a global macro named @COUNTRANGE: create macro'@COUNTRANGE'(Any) AS '@COUNT(SKIPMISSING, @RANGE(@@S))' spec '@COUNTRANGE(MemberRange)' comment 'counts all non-missing values'; Refreshing the Catalog of Custom-Defined Macros To refresh the catalog of custom-defined macros for all applications on a server, restart the server. To refresh the catalog of custom-defined macros for a single application, use the refresh custom definitions MaxL statement. For example, use the following MaxL statement to refresh the catalog of custom-defined macros for the Sample application: refresh custom definition on application sample; Using Custom-Defined Macros After creating custom-defined macros, you can use them like native calculation commands. Local macros-created using the AppName. prefix on the macro name-are only available for use in calculation scripts or formulas within the application in which they were created. Global macros-created without the AppName. prefix-are available to all calculation scripts and formulas on the server where they were created. For a comprehensive discussion of creating custom-defined macros, see Creating Custom-Defined Macros . To use a custom-defined macro follow these steps: Create a new calculation script or formula, or open an existing calculation script or formula. If the custom-defined macro was registered locally-within a specific application-you must use a calculation script or formula within that application. If the custom-defined macro was registered globally, you can use any calculation script or formula on any application on the server. Add the custom-defined macro to a new or existing calculation script or formula. To use the custom-defined macro shown earlier in this chapter, type the following calculation script: CountMbr = @COUNTRANGE(Sales, Jan:Dec); Use this calculation script with the Sample Basic database, or replace Sales, Jan:Dec with a range of members in a test database. Save the calculation script or formula, and then run it as usual. For information about creating and running calculation scripts, see Developing Calculation Scripts. For information about creating and running formulas, see Developing Formulas. Updating Custom-Defined Macros When you update a custom-defined macro, you must determine whether the macro is registered locally or globally. Local custom-defined macros are created using an AppName. prefix in the macro name and can be used only within the application where they were created. For a review of the methods used to determine whether a custom-defined macro is local or global, see Viewing Custom-Defined Macros . For a review of the methods used to update the catalog of macros after you change a custom-defined macro, see Refreshing the Catalog of Custom-Defined Macros . To update a custom-defined macro, use either of the following methods: Tool Topic Location Administration Services Editing Custom-Defined Macros Essbase Administration Services Online Help MaxL create or replace macro Technical Reference For example, use the following MaxL statement to change the local macro @COUNTRANGE which is used only in the Sample application: create or replace macro Sample.'@COUNTRANGE'(Any) as '@COUNT(SKIPMISSING, @RANGE(@@S))'; For example, use the following MaxL statement to change the global macro @COUNTRANGE: create or replace macro '@COUNTRANGE'(Any) as '@COUNT(SKIPMISSING, @RANGE(@@S))'; Copying Custom-Defined Macros You can copy custom-defined macros to any Analytic Server and application to which you have appropriate access. To copy a custom-defined macro, use either of the following methods: Tool Topic Location Administration Services Copying Custom-Defined Macros Essbase Administration Services Online Help MaxL create macro Technical Reference Removing Custom-Defined Macros When removing a custom-defined macro, you must first determine whether the macro is registered locally or globally. The procedure for removing global custom-defined macros is more complex than that for removing local custom-defined macros and should only be performed by a database administrator. For a review of methods used to determine whether a custom-defined macro is local or global, see Viewing Custom-Defined Macros . Before removing custom-defined macros, verify that no calculation scripts or formulas are using them. Global custom-defined macros can be used in calculation scripts and formulas across a server, so verify that no calculation scripts or formulas on the server are using a global custom-defined macro before removing it. For a review of methods used to update the catalog of macros after you remove a custom-defined macro, see Refreshing the Catalog of Custom-Defined Macros . To remove a custom-defined macro, use either of the following methods: Tool Topic Location Administration Services Deleting Custom-Defined Macros Essbase Administration Services Online Help MaxL drop macro Technical Reference For example, use the following MaxL statement to remove the local macro @COUNTRANGE which is used only in the Sample application: drop macro Sample.'@COUNTRANGE'; For example, use the following MaxL statement to remove the global macro @COUNTRANGE: drop macro '@COUNTRANGE';  |../dcaudms.htm",
    "Designing and Building Currency Conversion Applications||You use the Analytic Services currency conversion feature to translate financial data from one currency into another currency. Currency conversion facilitates comparisons among countries, and enables consolidation of financial data from locations that use different currencies. This feature can be licensed as an add-on to Analytic Server. For example, consider an organization that analyzes profitability data from the UK, reported in pounds, and from Japan, reported in yen. Comparing local currency profitability figures side-by-side in a spreadsheet is meaningless. To understand the relative contribution of each country, you need to convert pounds into yen, yen into pounds, or both figures into another currency. As another example, reporting total profitability for North America requires standardization of the local currency values that constitute the North America total. Assuming that the United States, Mexico, and Canada consolidate into Total North America, the profitability total is meaningless if data is kept in local currencies. The Total North America sum is meaningful only if local currencies are converted to a common currency prior to consolidation. The Analytic Services installation includes the option to install the Sample currency application, which consists of two databases, Interntl and Xchgrate. If you do not have access to these databases, contact your Analytic Services administrator. For information about installing Sample currency applications, see the Essbase Analytic Services Installation Guide . Note: The information in this chapter is not relevant to aggregate storage databases. For detailed information on the differences between aggregate and block storage, see Comparison of Aggregate and Block Storage. This chapter contains the following topics: About the Sample Currency Application Structure of Currency Applications Conversion Methods Building Currency Conversion Applications and Performing Conversions About the Sample Currency Application The Sample currency application builds on the business scenario introduced in Case Study: Designing aSingle-Server, Multidimensional Database, as the Beverage Company (TBC) expands its business outside the United States. TBC adds the following markets: Three locations in Canada: Toronto, Vancouver, and Montreal Four locations in Europe: the UK, Germany, Switzerland, and Sweden In addition, TBC adds a new member, US, which is a consolidation of data from the United States regions: East, West, South, and Central. Data for each TBC market location is captured in local currency. U.S. dollar values are derived by applying exchange rates to local values. TBC needs to analyze actual data in two ways: Actuals are converted at actual exchange rates. Actuals are converted at budget exchange rates to analyze variances due to exchange rates. After all actuals are processed, budget data is converted with budget exchange rates. The TBC currency application consists of the main database (Interntl) and the currency database (Xchgrate). On Analytic Server, the databases are in the Sample application. If you do not have access to the databases, contact your Analytic Services administrator. For information about installing Sample currency applications, see the Essbase Analytic Services Installation Guide . Structure of Currency Applications In a business application requiring currency conversion, the main database is divided into at least two slices. One slice handles input of the local data, and another slice holds a copy of the input data converted to a common currency. Analytic Services holds the exchange rates required for currency conversion in a separate currency database . The currency database outline, which is automatically generated by Analytic Services from the main database after you assign the necessary tags, typically maps a given conversion ratio onto a section of the main database. After the currency database is generated, it can be edited just like any other Analytic Services database. The relationship between the main database and the currency database is illustrated in Figure66 . Figure 66: Currency Application Databases Main Database To enable Analytic Services to generate the currency database outline automatically, you modify dimensions and members in the main database outline. In the Sample currency application, the main database is Interntl. The main database outline can contain from 3 to n dimensions. At a minimum, the main database must contain the following dimensions: A dimension tagged as time. Tagging a dimension as time generates a dimension in the currency database that is identical to the time dimension in the main database. In the Sample Interntl database, the dimension tagged as time is Year. A dimension tagged as accounts. Tagging a dimension as accounts and assigning currency categories to its members creates a dimension in the currency database that contains members for each of the individual currency categories. Category assignment enables the application of different exchange rates to various accounts or measures. In the Sample Interntl database, the dimension tagged as accounts is Measures. Each descendant of a member inherits the currency category tag of its ancestor. A member or sub-branch of members can also have its own category. For example, profit and loss (P&amp;L) accounts may use exchange rates that differ from the rates used with balance sheet accounts. In addition, some accounts may not require conversion. For example, in the Sample Interntl database, members such as Margin% and Profit% require no conversion. You tag members not to be converted as No Conversion. The No Conversion tag is not inherited. A market-related dimension tagged as country. Tagging a dimension as country and assigning currency names to individual countries creates a member in the currency database for each currency. In the Sample Interntl database, the Market dimension is tagged as country. The currency name for this dimension is USD (U.S. dollars), because all local currencies must be converted to USD, the company's common currency. Because multiple members can have the same currency name, the number of currency names is typically less than the total number of members in the dimension. As shown in Table18 , the Sample Interntl database uses only six currency names for the 15 members in the Market dimension. Each of the children of the member Europe use a different currency and, therefore, must be assigned an individual currency name. However, the US dimension and its four regional members all use the same currency. The same is true of the Canada member and its three city members. When the children of a given member share a single currency, you need to define a currency name for only the parent member. Table 18: Interntl Database Currency Names  Dimensions and Members Currency Name Market - Country US East West South Central USD (U.S. dollar) Canada Toronto Vancouver Montreal CND (Canadian dollar) Europe UK Germany Switzerland Sweden &#160; GBP (British pound) EUR (Euro) CHF (Swiss franc) SEK (Swedish krona) When preparing a main database outline for currency conversion, you can create an optional currency partition to tell Analytic Services which slice of the database holds local currency data and which slice of the database holds data to be converted. The dimension that you tag as currency partition contains members for both local currency values and converted values. Local currency data is converted to common currency data using currency conversion calculation scripts. In the Sample Interntl database, the Scenario dimension is the currency partition dimension. For instructions on how to use currency partition dimensions, see Keeping Local and Converted Values . Note: A currency conversion partition applies only to the currency conversion option. It is not related to the Partitioning option that enables data to be shared between databases by using a replicated, linked, or transparent partition. The Essbase Spreadsheet Add-in User's Guide provides examples of ad hoc currency reporting capabilities. Report scripts enable the creation of reports that convert data when the report is displayed, as discussed under Converting Currencies in Report Scripts . Note: For a list of methods used to create the main database outline, see Creating Main Database Outlines . Currency Database By assigning currency tags to members in the main database outline, you enable Analytic Services to generate the currency database automatically. In the Sample currency application, the currency database is Xchgrate. A currency database always consists of the following three dimensions, with an optional fourth dimension: A dimension tagged as time, which is typically the same as the dimension tagged as time in the main database. This allows the currency database to track currency fluctuations over time and to accurately convert various time slices of the main database. In the Sample Xchgrate database, the dimension tagged as time is Year. Each member of the time dimension in the main database must be defined in the currency database. Values by time period in the main database are usually converted to the exchange rates of their respective time period from the currency database (although you can convert data values against the exchange rate of any period). A dimension tagged as country, which contains the names of currencies relevant to the markets (or countries) defined in the main database. Each currency name defined in the main database must also exist in the currency database. The currency names define the country-to-exchange rate mapping when conversion occurs. In the Sample Xchgrate database, the country dimension is CurName. CurName contains the following currency names: Table 19: Xchgrate Database Currency Names Dimension and Members Alias Name CurName - Country USD CND GBP EUR CHF SEK &#160; US dollar Canadian dollar British pound Euro Swiss franc Swedish krona A dimension tagged as accounts, which enables the application of various rates to members of the dimension tagged as accounts in the main database. The categories defined for the accounts dimension in the main database are used to form the members in the accounts dimension of the currency database. For example, it may be necessary to convert Gross Profit and Net Profit using one category of rates, while other accounts use a different set of rates. In the Sample Xchgrate database, the dimension tagged as accounts is CurCategory, and the account categories included are P&amp;L (Profit &amp; Loss) and B/S (Balance Sheet). A currency database typically includes an optional currency type dimension, which enables different scenarios for currency conversion. Typically, an application has different exchange rates for different scenarios, such as actual, budget, and forecast. To convert data between scenarios, simply select which type of rate to use. The currency type dimension is created when you generate the currency outline and is not directly mapped to the main database. Therefore, member names in this dimension are not required to match member names of the main database. In the Sample Xchgrate database, the currency type dimension is CurType. CurType includes actual and budget scenarios. Note: For information about creating the currency database outline, see Building Currency Conversion Applications and Performing Conversions . Conversion Methods Different currency applications have different conversion requirements. Analytic Services supports two conversion methods: Overwriting local values with converted values. Some applications require only converted values to be stored in the main database. Local values are entered and the conversion operation overwrites local values with common currency values. This method assumes that there is no requirement for reporting or analyzing local currencies. Because this operation overwrites data, you must load local values and recalculate the data each time you perform a conversion. This method is useful only when you want to perform a single (not an ongoing) conversion. Keeping local and converted values. Most applications require data to be stored in both local and common currency (converted) values. This method permits reporting and analyzing local data. In addition, data modifications and recalculations are easier to control. To use this method, you must define a currency partition (see Main Database ). Either of these two methods may require a currency conversion to be applied at report time. Report time conversion enables analysis of various exchange rate scenarios without actually storing data in the database. The currency conversion module enables performance of ad hoc conversions. You perform ad hoc conversions by using Spreadsheet Add-in, as discussed in the Essbase Spreadsheet Add-in User's Guide , or by using a report script, as discussed under Converting Currencies in Report Scripts . Building Currency Conversion Applications and Performing Conversions To build a currency conversion application and perform conversions, use the following process: Create or open the main database outline. See Creating Main Database Outlines . Prepare the main database outline for currency conversion. See Preparing Main Database Outlines . Generate the currency database outline. See Generating Currency Database Outlines . Link the main and currency databases. See Linking Main and Currency Databases . Convert currency values. See Converting Currency Values . Track currency conversions. See Tracking Currency Conversions . If necessary, troubleshoot currency conversion. See Troubleshooting Currency Conversion . Creating Main Database Outlines To create a main database outline, you need to create or open an Analytic Services database outline, modify the outline as needed, and then save the outline for use in the currency conversion application. To create a new outline or open an existing outline, use any of the following methods: Tool Topic Location Administration Services Opening and Editing Outlines Essbase Administration Services Online Help MaxL create database Technical Reference ESSCMD CREATEDB Technical Reference Preparing Main Database Outlines After you create or open the main database outline, you need to modify dimensions and members to enable Analytic Services to generate the currency database outline automatically. For more information, see Main Database . To prepare a main database outline, see Preparing the Main Database Outline for Currency Conversion in Essbase Administration Services Online Help . Generating Currency Database Outlines After you verify and save the main database outline, you can generate the currency outline. The currency outline contains dimensions, members, currency names, and currency categories previously defined in the main database outline. The currency database outline is basically structured and ready to use after being generated but may require additions to make it complete. To generate a currency database outline, see Generating a Currency Database Outline in Essbase Administration Services Online Help . Linking Main and Currency Databases To perform a currency conversion calculation, Analytic Services must recognize a link between the main and currency databases. Generating a currency outline does not automatically link a main database with a currency database. When you link the databases, you specify the conversion calculation method and the default currency type member. To link main and currency databases, see Linking a Database to a Currency Database in Essbase Administration Services Online Help . Converting Currency Values After you create a currency conversion application, you convert data values from a local currency to a common, converted currency by using the CCONV command in calculation scripts. For example, you might convert data from a variety of currencies into USD (U.S. dollars). You can convert the data values back to the original, local currencies by using the CCONV TOLOCALRATE command. You can convert all or part of the main database using the rates defined in the currency database. You can overwrite local values with converted values, or you can keep both local and converted values in the main database, depending on your tracking and reporting needs. Note: When running a currency conversion, ensure that the data being converted is not simultaneously being updated by other user activities (for example, a calculation, data load, or currency conversion against the same currency partition). Concurrent activity on the data being converted may produce incorrect results. Analytic Services does not display a warning message in this situation. Note: When you convert currencies using the CCONV command, the resulting data blocks are marked as dirty for the purposes of Intelligent Calculation. Thus, Analytic Services recalculates all converted blocks when you recalculate the database. To see sample currency conversion calculation scripts, see the Technical Reference . Overwriting Local Values with Converted Values If you want to overwrite local values, you do not need to create a currency partition dimension in the main database. Use the CCONV command in a calculation script to convert all data in the database: The following calculation script converts the values in the database to USD: CCONV USD; CALC ALL; If required, you can specify a currency name that contains the required exchange rate. The following calculation script converts the values in the database to USD, using the exchange rate for Jan as defined in the currency database: CCONV Jan-&gt;USD; CALC ALL; The CALC ALL command is required in the examples shown because the CCONV command only converts currencies. It does not consolidate or calculate members in the database. The following calculation script uses the Act xchg rate to convert the converted values back to their original local currency values: CCONV TOLOCALRATE Act xchg ; CALC ALL; Note: You cannot use the FIX command unless you are using a currency partition dimension and the CCTRACK setting is TRUE in the essbase.cfg file. Keeping Local and Converted Values You can keep both local and converted values in a database. In the main database you need to define the members that store the local and the converted values. You define the members by creating a currency partition dimension (see Main Database ). The currency partition dimension has two partitions, one for local values and one for converted values. To create a calculation script that copies local data to a converted partition and calculates the data, use the following process: Use the DATACOPY command to copy data from the local to the converted partition. Use the FIX command to calculate only the converted partition and use the CCONV command to convert the data. Note: When using a currency partition dimension, you must FIX on a member of the dimension to use the CCONV command. Use the CALC command to recalculate the database. The following example is based on the Sample Interntl database and the corresponding Sample Xchgrate currency database. Figure67 shows the currency partition from the Sample Interntl database. Figure 67: Calculating Local and Converted Currency Conversions The following calculation script performs three currency conversions for Actual, Budget, and Actual @ Bud Xchg data values: /* Copy data from the local partition to the master partition (for converted values) */ DATACOPY Act TO Actual; DATACOPY Bud TO Budget; /* Convert the Actual data values using the Act xchg rate */ FIX(Actual) CCONV Act xchg-&gt;US$; ENDFIX /* Convert the Budget data values using the Bud xchg rate */ FIX(Budget) CCONV Bud xchg-&gt;US$; ENDFIX /* Convert the Actual @ Bud XChg data values using the Bud xchg rate */ FIX(Actual @ Bud XChg) CCONV Bud xchg-&gt;US$; ENDFIX /* Recalculate the database */ CALC ALL; CALC TWOPASS; The following calculation script converts the Actual and Budget values back to their original local currency values: FIX(Actual) CCONV TOLOCALRATE Act xchg; ENDFIX FIX(Budget) CCONV TOLOCALRATE Bud xchg; ENDFIX CALC ALL; Note: When you convert currencies using the CCONV command, the resulting data blocks are marked as dirty for the purposes of Intelligent Calculation. Thus, Analytic Services recalculates all converted blocks when you recalculate the database. Calculating Databases If you execute a CALC ALL command to consolidate the database after running a conversion, meaningful total-level data is generated in the converted base rate partition, but the local rate partition contains a meaningless consolidation of local currency values. To prevent meaningless consolidation, use the calculation command SET UPTOLOCAL, which restricts consolidations to parents with the same defined currency. For example, all cities in the US use dollars as the unit of currency. Therefore, all children of US consolidate to US. Consolidation stops at the country level, however, because North America contains countries that use other currencies. Converting Currencies in Report Scripts You can convert currencies in report scripts, using the CURRENCY command to set the output currency and the currency type. For the syntax and definitions of Report Writer commands, see the Technical Reference . Note: Analytic Services cannot perform on the fly currency conversions across transparent databases. If you have two transparent partition databases that are calculated using different conversions, you cannot perform currency conversions in reports. The following Sample report contains first quarter Budget Sales for colas, using the January exchange rate for the Peseta currency. Illinois Sales Budget JanFebMar ======================== 100-10333 100-20222 100-30#Missing#Missing#Missing 100555 Currency: Jan-&gt;Peseta-&gt;Act xchg Currency: Jan-&gt;Peseta-&gt;Act xchg Illinois Sales Budget JanFebMar ======== ======== ======== 100-10333 100-20222 100-30#Missing#Missing#Missing 100555 Use the following script to create the Sample currency conversion report: &lt;Page (Market, Measures, Scenario) SupCurHeading Illinois Sales Budget &lt;Column (Year) &lt;children Qtr1 &lt;Currency Jan-&gt;Peseta-&gt;Act xchg &lt;Ichildren Colas ! CurHeading Illinois Sales Budget &lt;Column (Year) &lt;children Qtr1 ! Tracking Currency Conversions You can use the CCTRACK setting in the essbase.cfg file to control whether Analytic Services tracks the currency partitions that have been converted and the exchange rates that have been used for the conversions. Tracking currency conversions has the following advantages: Enables conversion to occur at report time through Spreadsheet Add-in or Report Writer Enables conversion of a converted currency back to its original, local rate through use of the CCONV TOLOCALRATE command Prevents data inaccuracies due to accidental reconversion of data during a currency calculation. By default CCTRACK is turned on. Analytic Services tracks which currency partitions have been converted and which have not. The tracking is done at the currency partition level: a database with two partitions has two flags, each of which can be either converted or unconverted. Analytic Services does not store a flag for member combinations within a partition. When CCTRACK is turned on, the following restrictions apply: If you are using currency partitions, you can use a FIX statement with the CCONV command only on currency partition members. For example, in the Sample Basic database, the following example is valid: FIX(Actual) CCONV Act xchg-&gt;US$; ENDFIX] If you are not using currency partitions, you must use CCONV with a FIX statement. Reasons to Turn Off CCTRACK For increased efficiency when converting currency data between currency partitions, you may want to turn off CCTRACK. For example, you load data for the current month into the local partition, use the DATACOPY command to copy the entire currency partition that contains the updated data, and then run the conversion on the currency partition. Note: Always do a partial data load to the local partition and use the DATACOPY command to copy the entire currency partition to the converted partition before running the currency conversion. Updating data directly into the converted partition causes incorrect results. Methods for Turning Off CCTRACK You can turn off CCTRACK in three ways: Use the SET CCTRACKCALC ON OFF command in a calculation script to turn off CCTRACK temporarily. You can use this command at calculation time to provide increased flexibility and efficiency during currency conversion. Use the CLEARCCTRACK calculation command to clear the internal exchange rate tables created by CCTRACK. You can use the command inside a FIX statement to clear the exchange rates for a currency partition. Use the command after a data load to reset the exchange rate tables so they are ready for future currency conversion calculations. Set CCTRACK to FALSE in the essbase.cfg file. Setting CCTRACK to False turns off the tracking system and has the following results: The CCONV command assumes that data is unconverted (is in local currency). If you accidentally run the CCONV command multiple times on the same data, the resulting data is inaccurate. Similarly, the currency report options assume that the data is unconverted (is in local currency). If the data has already been converted in the database, it is reconverted at report time, resulting in inaccurate data. The restrictions on using the FIX and DATACOPY commands in currency conversions do not apply. Note: When running a currency conversion, ensure that the data being converted is not simultaneously being updated by other user activities (for example, a calculation, data load, or currency conversion against the same currency partition). Concurrent activity on the data being converted may produce incorrect results. Analytic Services does not display a warning message in this situation. Troubleshooting Currency Conversion For information about how to troubleshoot currency conversions, see Troubleshooting Currency Conversion in Essbase Administration Services Online Help .  |../dcurrapp.htm",
    "Optimizing Data Loads||Loading a large data source into an Analytic Services database can take hours. You can speed up the data loading process by improving two areas: Minimizing the time spent reading and parsing the data source Minimizing the time spent reading and writing to the database This chapter contains the following sections: Understanding Data Loads Grouping Sparse Member Combinations Positioning Data in the Same Order As the Outline Loading from Analytic Server Making the Data Source As Small As Possible Making Source Fields As Small As Possible Managing Parallel Data Load Processing Understanding Data Loads This section is not relevant to aggregate storage databases. To optimize data load performance, you must think in terms of database structure. Analytic Services loads data block by block. For each unique combination of sparse dimension members, one data block contains the data for all the dense dimension combinations, assuming there is at least one cell containing data. For faster access to block locations, Analytic Services uses an index . Each entry in the index corresponds to one data block. For further explanation of how sparse and dense dimensions affect database structure, see Sparse and Dense Dimensions , Selection of Sparse and Dense Dimensions , and Dense and Sparse Selection Scenarios . When Analytic Services loads a data source, Analytic Services processes the data in three main stages: Input stage: Analytic Services reads a portion of the data source. Preparation stage: Analytic Services arranges the data in preparation for putting it into blocks. Write stage: Analytic Services puts the data into blocks in memory and then writes the blocks to disk, finding the correct block on the disk by using the index, which is composed of pointers based on sparse intersections. This process is repeated until all data is loaded. By using one or more processing threads in each stage, Analytic Services can perform some processes in parallel. For a description of the parallel data load process, see Managing Parallel Data Load Processing . All examples in this chapter assume that you are familiar with the discussions about data sources in Data Sources . Grouping Sparse Member Combinations This section is not relevant to aggregate storage databases. The most effective strategy to improve performance is to minimize the number of disk I/Os that Analytic Services must perform while reading or writing to the database. Because Analytic Services loads data block by block, organizing the source data to correspond to the physical block organization reduces the number of physical disk I/Os that Analytic Services must perform. Arrange the data source so that records with the same unique combination of sparse dimensions are grouped together. This arrangement corresponds to blocks in the database. The examples in this chapter illustrate various ways you can organize the data following this strategy. These examples use a subset of the Sample Basic database, as shown in Table80 . Table 80: Dimensions and Values for Examples Sparse, Non attribute Dimensions Dense Dimensions Scenario (Budget, Actual) Measures (Sales, Margin, COG, Profit) Product (Cola, Root Beer) Year (Jan, Feb) Market (Florida, Ohio) &#160; Note: Because you do not load data into attribute dimensions, they are not relevant to this discussion even though they are sparse. First, consider the data shown in Figure238 . Because it is not grouped by sparse-dimension member combinations, this data has not been sorted for optimization. As Analytic Services reads each record, it must deal with different members of the sparse dimensions. Figure 238: Non-Optimized Sequence of Source Data Jan Actual Cola Ohio Sales 25 Budget Root Beer Florida Sales 28 Actual Root Beer Ohio Sales 18 Budget Cola Florida Sales 30 This data loads slowly because Analytic Services accesses four different blocks instead of one. From the same Sample Basic database, Figure239 shows different records sorted by a unique combination of sparse-dimension members: Actual -&gt; Cola -&gt; Ohio. Analytic Services accesses only one block to load these four records. Figure 239: Optimally-Organized Source Data Actual Cola Ohio Jan Sales 25 Actual Cola Ohio Jan Margin 18 Actual Cola Ohio Jan COGS 20 Actual Cola Ohio Jan Profit 5 You can use a data source that loads more than one cell per record. Make sure that records are grouped together by unique sparse-dimension member combinations, then order the records so that the dimension in the record for which you provide multiple values is a dense dimension. Figure240 uses a header record to identify the members of the Measures dimension, which is a dense dimension. The data is sorted first by members of the dense dimension Year and grouped hierarchically by members of the other dimensions. Multiple values for the Measures dimension are provided on each record. Figure 240: Source Data Sorted and Grouped by Dense Dimensions Sales Margin COG Profit Jan Actual Cola Ohio 25 18 20 5 Jan Actual Cola Florida 30 19 20 10 Jan Actual Root Beer Ohio 18 12 10 8 Jan Actual Root Beer Florida 28 18 20 8 The heading and first data line in this example provide the same data shown in four lines in Figure239 . For detailed information, including examples, about arranging data in source files before loading, see Data Sources That Do Not Need a Rules File . Making the Data Source As Small As Possible Make the data source as small as possible. The fewer fields that Analytic Services reads in the data source, the less time is needed to read and load the data. Group the data into ranges. Eliminating redundancy in the data source reduces the number of fields that Analytic Services must read before loading data values. Figure241 shows a file that is not organized in ranges. It includes unneeded repetition of fields. All values are Profit values. Profit needs to be included only at the beginning of the group of data applicable to it. This example contains 33 fields that Analytic Services must read in order to load the data values properly. Figure 241: Data Source Without Ranges Profit Jan New York Cola 4 Jan New York Diet Cola 3 Jan Ohio Cola 8 Jan Ohio Diet Cola 7 Feb New York Cola 6 Feb New York Diet Cola 8 Feb Ohio Cola 7 Feb Ohio Diet Cola 9 Figure242 shows the same file optimized by grouping members in ranges. By eliminating redundancy, this example contains only 23 fields that Analytic Services must read in order to load the data values properly. Figure 242: Data Source Organized in Ranges Profit Jan New York Cola 4 Diet Cola 3 Ohio Cola 8 Diet Cola 7 Feb New York Cola 6 Diet Cola 8 Ohio Cola 7 Diet Cola 9 Analytic Services assigns the first value, 4, to Jan-&gt;New York-&gt;Cola; it assigns the next value, 3, to Jan-&gt;New York-&gt;Diet Cola and so on. Although sorted efficiently, the data in Figure240 still shows a lot of repetition that can slow down the load process. You can further optimize this data by grouping the data into ranges. The optimized data source shown in Figure243 eliminates the redundant fields, thereby reducing processing time. Figure 243: Source Data Sorted and Grouped in Ranges Sales Margin COG Profit Jan Actual Cola Ohio 25 18 20 5 Florida 30 19 20 10 Root Beer Ohio 18 12 10 8 Florida 28 18 20 8 For information about and examples of organizing source data into ranges, see Formatting Ranges of Member Fields . Making Source Fields As Small As Possible Making fields in a data source smaller enables Analytic Services to read and load the data in less time. Make the fields in the data source as small as possible by performing the following tasks: Removing excess white space in the data source. For example, use tabs instead of blank spaces. Rounding off computer-generated numbers to the precision you need. For example, if the data value has nine decimal points and you only care about two, round the number to two decimal points. Using #MI instead of #MISSING. Positioning Data in the Same Order As the Outline This section is not relevant to aggregate storage databases. The index is organized in the same order as the sparse dimensions in the outline. To further optimize the data source, with the sparse data combinations in the data source grouped together, arrange the data so that sparse dimensions are in the same order as the outline. Analytic Services pages portions of the index in and out of memory as requested by the data load or other operations. Arranging the source data to match the order of entries in the index speeds up the data load because it requires less paging of the index. Less paging results in fewer I/O operations. Analytic Services uses the index cache size to determine how much of the index can be paged into memory. Adjusting the size of the index cache may also improve data load performance. Note: If the index cache size is large enough to hold the entire index in memory, positioning data in the same order as the outline does not affect the speed of data loads. For detailed information about setting the index cache size, see Sizing the Index Cache . Loading from Analytic Server Loading the data source from the Analytic Server computer is faster than loading from a client computer. To load a data source from the server, move the data source to the server computer and then start the load. Loading data from the server improves performance because the data does not have to be transported over the network from the client computer to the server computer. Managing Parallel Data Load Processing The methods described earlier in this chapter give you the most substantial data load performance enhancements. If you have not done so, you also need to carefully evaluate your processor speed and memory requirements and upgrade your computers to meet these requirements. Another method to speed up data loads is to work with the Analytic Services parallel data load feature to optimize use of processor resources. The parallel data load feature recognizes opportunities to process data load tasks at the same time. Although some opportunities present themselves on single-processor computers, many more opportunities are available on multiple-processor computers. To enable you to fine tune processor use for specific application and database situations, Analytic Services provides three essbase.cfg settings: DLTHREADSPREPARE, DLTHREADSWRITE, and DLSINGLETHREADPERSTAGE. Understanding Parallel Data Load Processing When Analytic Services loads a data source, it works with a portion of data at a time, in stages. Analytic Services looks at each stage as a task and uses separate processing threads in memory to perform each task. One form of parallel processing occurs when one thread takes advantage of processor resources that are left idle during the wait time of another thread. For example, while a thread performs I/O processing, it must wait for the slower hardware to perform its task. While this thread waits, another thread can use the idle processor resource. Processing staged tasks in parallel can improve processor efficiency by minimizing idle time. When computers have multiple processors, Analytic Services can perform an additional form of parallel processing. When a data load stage completes its work on a portion of data, it can pass the work to the next stage and start work immediately on another portion of data. Processing threads perform their tasks simultaneously on the different processors, providing even faster throughput. Optimizing Parallel Data Load Processing Even though Analytic Services uses parallel processing to optimize processor resources across the data load stages, there are still times when processor resources can be idle. To take advantage of these idle times, Analytic Services can further divide up record processing in the preparation and write stages. To tailor parallel processing to your situation, you can use the DLTHREADSPREPARE and DLTHREADSWRITE essbase.cfg settings to tell Analytic Services to use additional threads during these stages. Setting Parallel Data Load Settings As shown in Table81 , Analytic Services provides three essbase.cfg settings that enable you to manage parallel data load processing. You can specify setting values that apply to all applications on a given Analytic Server or you can specify settings multiple times with different values for different applications and databases. Table 81: Parallel Data Load essbase.cfg Settings  Setting Description DLTHREADSPREPARE Specifies how many threads Analytic Services may use during the data load stage that codifies and organizes the data in preparation to being written to blocks in memory DLTHREADSWRITE Specifies how many threads Analytic Services may use during the data load stage that writes data to the disk. High values may require allocation of additional cache. For an explanation of the relationship between DLTHREADSWRITE and data cache size, see Implications in Sizing the Data Cache . Note: For aggregate storage databases, Analytic Server uses one thread with aggregate storage cache. The DLTHREADSWRITE setting is ignored. DLSINGLETHREADPERSTAGE Specifies that Analytic Services use a single thread per stage, ignoring the values in the DLTHREADSPREPARE and DLTHREADSWRITE settings Only when the DLSINGLETHREADPERSTAGE setting is set to FALSE for the specific application and database being loaded does the data load process use the thread values specified in the DLTHREADSPREPARE and DLTHREADSWRITE settings. See the Technical Reference for details about these settings and their parameters. Implications in Sizing the Data Cache For block storage databases, Analytic Server allocates the data cache memory area to hold uncompressed data blocks. Each thread specified by the DLTHREADSWRITE setting uses an area in the data cache equal to the size of an expanded block. Depending on the size of the block, the number of threads, and how much data cache is used by other concurrent operations during a data load, it may be possible to need more data cache than is available. In such circumstances, decrease the number of threads or increase the size of the data cache. To change the data cache size, see Changing the Data Cache Size . Testing Different Thread Values While processing data loads, you can view processor activity. Different operating systems provide different tools for viewing processor activity. For example, the Task Manager in Windows/NT and Windows/2000 enables you to view processor and memory usage and processes. Among the tools available on UNIX are top and vmstat. You can also use third-party tools to view and analyze system utilization. To assess system usage during data load processing; Start with the default parallel data load processing thread values whereby Analytic Services uses a single thread per stage. Perform and time the data load. Monitor the entire process, identifying the stages during which the processor may be idle. Alter the essbase.cfg settings that are described in Setting Parallel Data Load Settings . Repeat the last three steps until you find values that provide the best performance.  |../ddldebug.htm",
    "Using a Rules File to Perform Operations on Records, Fields, and Data||This chapter describes how to edit a rules file to perform operations on records, fields, and data before loading the database. For a comprehensive discussion of data sources and rules files, see Understanding Data Loading and Dimension Building. For a comprehensive discussion of the process of creating a rules file, see Creating Rules Files. This chapter contains the following sections about record operations: Selecting Records Rejecting Records Combining Multiple Select and Reject Criteria Setting the Records Displayed Defining Header Records This chapter contains the following sections about field operations: Ignoring Fields Arranging Fields Changing Field Names This chapter contains the following sections about data operations: Defining a Column as a Data Field Adding to and Subtracting from Existing Values Clearing Existing Data Values Scaling Data Values Flipping Field Signs Performing Operations on Records You can perform operations at the record level. For example, you can reject certain records before they are loaded into the database. This section contains the following sections: Selecting Records Rejecting Records Combining Multiple Select and Reject Criteria Setting the Records Displayed Defining Header Records Selecting Records You can specify which records Analytic Services loads into the database or uses to build dimensions by setting selection criteria. Selection criteria are string and number conditions that must be met by one or more fields within a record before Analytic Services loads the record. If a field or fields in the record do not meet the selection criteria, Analytic Services does not load the record. You can define one or more selection criteria. For example, to load only 2003 Budget data from a data source, create a selection criterion to load only records in which the first field is Budget and the second field is 2003. To select a record, see Selecting Records in the Essbase Administration Services Online Help . Note: If you define selection criteria on more than one field, you can specify how Analytic Services combines the criteria. For a brief discussion, see Combining Multiple Select and Reject Criteria . Rejecting Records You can specify which records Analytic Services ignores by setting rejection criteria. Rejection criteria are string and number conditions that, when met by one or more fields within a record, cause Analytic Services to reject the record. You can define one or more rejection criteria. If no field in the record meets the rejection criteria, Analytic Services loads the record. For example, to reject Actual data from a data source and load only Budget data, create a rejection criterion to reject records in which the first field is Actual. To reject a record, see Rejecting Records in the Essbase Administration Services Online Help . Note: If you define rejection criteria on more than one field, you can specify how Analytic Services should combine the criteria. For a brief discussion, see Combining Multiple Select and Reject Criteria . Combining Multiple Select and Reject Criteria When you define select and reject criteria on multiple fields, you can specify how Analytic Services combines the rules across fields, that is, whether the criteria are connected logically with AND or with OR. If you select And from the Boolean group, the fields must match all of the criteria. If you select Or from the Boolean group, the fields must match only one of the criteria. The global Boolean setting applies to all select or reject operations in the rules file, for both data load and dimension build fields. Note: If selection and rejection criteria apply to the same record (that is, you try to select and reject the same record), the record is rejected. To determine how to combine select and reject criteria on multiple fields, see Combining Selection and Rejection Criteria in the Essbase Administration Services Online Help . Setting the Records Displayed You can specify the number of records that Analytic Services displays in Data Prep Editor. You can also specify the first record in Data Prep Editor. Analytic Services skips all preceding records and, in Data Preparation Editor, begin the display with the record number you chose as first. For example, if you enter 5 as the starting record, Analytic Services does not display records 1 through 4. Note: Analytic Services treats header records the same as data records when counting the records to skip. To set the records displayed, see Setting the Records Displayed in the Essbase Administration Services Online Help . Defining Header Records Data sources can contain data records and header records. Data records contain member fields and data fields. Header records describe the contents of the data source and describe how to load values from the data source to the database. Rules files contain records that translate the data of the data source to map it to the database. As part of that information, rules files can also contain header records. For example, the Sample Basic database has a dimension for Year. If several data sources arrive with monthly numbers from different regions, the month itself might not be specified in the data sources. You must set header information to specify the month. You can create a header record using either of the following methods: You can define header information in the rules file. Rules file headers are used only during data loading or dimension building and do not change the data source. Header information set in a rules file is not used if the rules file also points to header records in the data source. You can define header information in the data source by using a text editor or spreadsheet and then pointing to the header records in the rules file. Placing header information in the data source makes it possible to use the same rules file for multiple data sources with different formats, because the data source format is specified in the data source header and not in the rules file. When you add one or more headers to the data source, you must also specify the location of the headers in the data source in the rules file. The rules file then tells Analytic Services to read the header information as a header record and not a data record. You can also specify which type of header information is in which header record. Header information defined in the data source takes precedence over header information defined in the rules file. To define a header in the rules file, see Setting Headers in the Rules File in the Essbase Administration Services Online Help . To define a header in the data source, see Setting Headers in the Data Source in the Essbase Administration Services Online Help . Data Source Headers You can dynamically build dimensions by adding header information to the top record of the data source and by specifying the location of the header record in the rules file. Figure105 contains an example of a header record. Figure 105: Header Record The header record lists field definitions for each field. The field definition includes the field type, the field number, and the dimension name into which to load the fields. The format of a header record is illustrated in Figure106 : Figure 106: Header Record with Three Field Definitions If the file delimiter is a comma, enclose each field definition in quotation marks ( ). After you set the header information in the data source, you must specify the location of the header information in the rules file. If a rules file refers to header information in a data source, Analytic Services uses the information in the data source-rather than the information in the rules file-to determine field types and dimensions. Valid Data Source Header Field Types Valid field types must be in capital letters and are as follows: GEN, DUPGEN, and DUPGENALIAS LEVEL, DUPLEVEL, and DUPLEVELALIAS PARENT, CHILD PROPERTY ALIAS FORMULA CURNAME CURCAT UDA ATTRPARENT The name of an attribute dimension, such as CAFFEINATED For each field type that you set, you must also enter a field number. When the field type is the name of an attribute dimension, the field number cannot be greater than 9. For a brief discussion and references to pertinent topics, see Setting Field Type Information . Performing Operations on Fields You can perform operations at the field level, for example, moving a field to a new position in the record. This section contains the following sections: Ignoring Fields Ignoring Strings Arranging Fields Mapping Fields Changing Field Names Ignoring Fields You can ignore all fields of a specified column of the data source. The fields still exist in the data source, but they are not loaded into the Analytic Services database. If the data source contains fields that you do not want to load into the database, tell Analytic Services to ignore those fields. For example, the Sample Basic database has five standard dimensions: Year, Product, Market, Measures, and Scenario. If the data source has an extra field, such as Salesperson, that is not a member of any dimension, ignore the Salesperson field. To ignore all fields in a column, see Ignoring Fields in the Essbase Administration Services Online Help . Ignoring Strings You can ignore any field in the data source that matches a string called a token . When you ignore fields based on string values, the fields are ignored everywhere they appear in the data source, not just in a particular column. Consider, for example, a data source that is a computer generated report in text format. Special ASCII characters might be used to create horizontal lines between pages or boxes around headings. These special characters can be defined as tokens to be ignored. To ignore all instances of a string, see Ignoring Fields Based on String Matches in the Essbase Administration Services Online Help . Arranging Fields You can set the order of the fields in the rules file to be different from the order of the fields in the data source.The data source is unchanged. The following sections describe: Moving Fields Joining Fields Creating a New Field by Joining Fields Copying Fields Splitting Fields Creating Additional Text Fields Undoing Field Operations Note: To undo a single operation, select Edit &gt; Undo. To undo one or more field operations, see Undoing Field Operations in the Essbase Administration Services Online Help . Moving Fields You can move fields to a different location using a rules file. For example, a field might be the first field in the data source, but you want to move it to be the third field during the data load or dimension build. In some instances, moved fields may appear to merge. Merging may occur if the data file has a structure similar to the following: 1&lt;tab&gt;2&lt;tab&gt;3 1&lt;tab&gt;2&lt;tab&gt;(null) If you move a field that contains empty cells and the moved field becomes the last field in the record, the field may merge with the field to its left. To prevent merging, replace the empty cell with a delimiter. To move fields, see Moving Fields in the Essbase Administration Services Online Help . Note: To undo a move, see Undoing Field Operations in the Essbase Administration Services Online Help . Joining Fields You can join multiple fields into one field. The new field is given the name of the first field in the join. For example, if you receive a data source with separate fields for product number (100) and product family (-10), you must join the fields (100-10) before you load them into the Sample Basic database. Before you join fields, move the fields to join into the order in which you want to join them. If you do not know how to move fields, see Moving Fields in the Essbase Administration Services Online Help . To join fields, see Joining Fields in the Essbase Administration Services Online Help . Note: To undo a join, see Undoing Field Operations in the Essbase Administration Services Online Help . Creating a New Field by Joining Fields You can join two or more fields by placing the joined fields into a new field. This procedure leaves the original fields intact. Creating a new field is useful if you need to concatenate fields of the data source to create a member. For example, if you receive a data source with separate fields for product number (100) and product family (-10), you must join the fields (100-10) before you load them into the Sample Basic database. But suppose that you want the 100 and -10 fields to exist in the data source after the join; that is, you want the data source to contain three fields: 100, -10, and 100-10. To do this, create the new field using a join. Before you join fields, move the fields to join into the order in which you want to join them. If you do not know how to move fields, see Moving Fields . To create a new field by joining existing fields, see Creating a New Field Using Joins in the Essbase Administration Services Online Help . Note: To undo a creating using join operation, see Undoing Field Operations in the Essbase Administration Services Online Help . Copying Fields You can create a copy of a field while leaving the original field intact. For example, assume that, during a single dimension build, you want to define a multilevel attribute dimension and associate attributes with members of a base dimension. To accomplish this task, you need to copy some of the fields. For more information about attribute dimensions, see Working with Multilevel Attribute Dimensions . To copy a field, select one field and then create a new field using a join. To create a new field by joining existing fields, see Creating a New Field Using Joins in the Essbase Administration Services Online Help . Note: To undo a copy, see Undoing Field Operations in the Essbase Administration Services Online Help . Splitting Fields You can split a field into two fields. For example, if a data source for the Sample Basic database has a field containing UPC100-10-1, you can split the UPC out of the field and ignore it. Then only 100-10-1, that is, the product number, is loaded. To ignore a field, see Ignoring Fields . To split a field, see Splitting Fields in the Essbase Administration Services Online Help . Note: To undo a split, see Undoing Field Operations in the Essbase Administration Services Online Help . Creating Additional Text Fields You can create a text field between two existing fields. You might create a text field to insert text between fields that are to be joined. For example, if you have two fields, one containing 100 and one containing 10-1, you can insert a text field with a dash between the two fields and then join the three fields to create the 100-10-1 member of the Product dimension. To create a new field and populate it with text, see Creating a New Field Using Text in the Essbase Administration Services Online Help . Note: To undo a field you created using text, see Undoing Field Operations in the Essbase Administration Services Online Help . Undoing Field Operations You can undo the last field operation that you performed, such as move, split, join, create using text, or create using join by using the Edit &gt; Undo command. You can also undo field operations even if you have performed other actions. Undoing field operations is sequential; you must undo field operations from the last operation to the first operation. To undo one or more field operations, see Undoing Field Operations in the Essbase Administration Services Online Help . Mapping Fields This section applies to data load only. If you are performing a dimension build, skip this section. You use a rules file to map data source fields to Analytic Services member names during a data load. You can map fields in a data source directly to fields in the Analytic Services database during a data load by specifying which field in the data source maps to which member or member combination in the Analytic Services database. The data source is not changed. Note: When you open a SQL data source, the fields default to the SQL data source column names. If the SQL column names and the Analytic Services dimension names are the same, you do not have to map the column names. To map fields, see Mapping Field Names in the Essbase Administration Services Online Help . Changing Field Names To load a data source, you must specify how the fields of the data source map to the dimensions and members of the database. Rules files can translate fields of the data source so that the fields match member names each time the data source is loaded. This process does not change the data source. The rules file does the following: Maps member fields of the data source to dimensions and members of the database Maps data fields of the data source to member names or member combinations (such as Jan, Actual) of the database This section contains the following sections that describe how to change field names in the data source to map members and data values to the database. Replacing Text Strings Replacing an Empty Field with Text Changing the Case of Fields Dropping Leading and Trailing Spaces Converting Spaces to Underscores Adding Prefixes or Suffixes to Field Values Replacing Text Strings You can replace text strings so that the fields map to Analytic Services member names during a data load or dimension build. The data source is not changed. For example, if the data source abbreviates New York to NY, you can have the rules file replace each NY with New York during the data load or the dimension build. For instructions on how to replace an empty field with text, see Replacing an Empty Field with Text . To replace a text string, see Replacing Field Names in the Essbase Administration Services Online Help . Replacing an Empty Field with Text You may want to replace empty fields in a column with text. If, for example, empty fields in the column represent default values, you can insert the default values or insert #MI to represent missing values. To replace an empty field with text, see Replacing an Empty Field with Text in Essbase Administration Services Online Help . Changing the Case of Fields You can change the case of a field so the field maps to Analytic Services member names during a data load or dimension build. The data source is not changed. For example, if the data source capitalizes a field that is in lower case in the database, you could change the field to lower case; for example, JAN to jan. To change the case of values in a field, see Changing Case of Fields in the Essbase Administration Services Online Help . Dropping Leading and Trailing Spaces You can drop leading and trailing spaces from around fields of the data source. A field value containing leading or trailing spaces does not map toamember name, even if the name within the spaces is an exact match. By default, Analytic Services drops leading and trailing spaces. To drop spaces around a field, see Dropping Spaces Around Fields in the Essbase Administration Services Online Help . Converting Spaces to Underscores You can convert spaces in fields of the data source to underscores to make the field values match the member names of the database. To change spaces to underscores, see Converting Spaces to Underscores in the Essbase Administration Services Online Help . Adding Prefixes or Suffixes to Field Values You can add prefixes and suffixes to each field value of the data source. For example, you can add 2002 as the prefix to all member names in the Year dimension. To prefix or suffix values to a field, see Adding Prefixes and Suffixes in the Essbase Administration Services Online Help . Performing Operations on Data This section applies to data load only. If you are performing a dimension build, skip this section. You can perform operations on the data in a field, for example, moving a field to a new position in the record. This section contains the following sections: Defining a Column as a Data Field Adding to and Subtracting from Existing Values Clearing Existing Data Values Scaling Data Values Flipping Field Signs Defining a Column as a Data Field This section applies to data load only. If you are performing a dimension build, skip this section. If each record in the data source contains a column for every dimension and one data column, you must define the data column as a data field. In Figure107 , for example, the column with the data values must be defined as a data field. Figure 107: Data Field Market, Product, Year, Measures, Scenario Texas 100-10 Jan Sales Actual 42 Texas 100-20 Jan Sales Actual 82 Texas 100-10 Jan Sales Actual 37 You can define only one field in a record as a data field. To define a data field, see Defining a Column as a Data Field in the Essbase Administration Services Online Help . Adding to and Subtracting from Existing Values This section is for data load only. If you are performing a dimension build, skip this section. By default, Analytic Services overwrites the existing values of the database with the values of the data source, but you can determine how newly loaded data values affect existing data values. You can use incoming data values to add to or subtract from existing database values. For example, if you load weekly values, you can add them to create monthly values in the database. Using this option makes it more difficult to recover if the database crashes while loading data, although Analytic Services lists the number of the last row committed in the application log. For a discussion of the application log, see Contents of the Application Log . To prevent difficult recoveries if you are adding to or subtracting from existing data values and the database shuts down abnormally, as a Database Transaction setting, set the Commit Row value as 0. This setting causes Analytic Services to view the entire load as a single transaction and to commit the data only when the load is complete. For more information, see Understanding Isolation Levels . To add to existing data values, see Adding to Data Values in the Essbase Administration Services Online Help . To subtract from existing data values, see Subtracting from Data Values in the Essbase Administration Services Online Help . Clearing Existing Data Values This section is for data load only. If you are performing a dimension build, skip this section. You can clear existing data values from the database before you load new values. By default, Analytic Services overwrites the existing values of the database with the new values of the data source. If you are adding and subtracting data values, however, Analytic Services adds or subtracts the new data values to and from the existing values. Before adding or subtracting new values, make sure that the existing values are correct. Before loading the first set of values into the database, you must make sure that there is no existing value. For example, assume that the Sales figures for January are calculated by adding the values for each week in January: January Sales = Week 1 Sales + Week 2 Sales + Week 3 Sales + Week 4 Sales When you load Week 1 Sales, clear the database value for January Monthly Sales. If there is an existing value, Analytic Services performs the following calculation: January Sales = Existing Value + Week 1 Sales + Week 2 Sales + Week 3 Sales + Week 4 Sales You can also clear data from fields that are not part of the data load. For example, if a data source contains data for January, February, and March and you want to load only the March data, you can clear the January and February data. Note: If you are using transparent partitions, clear the values using the steps that you use to clear data from a local database. To clear existing values, see Clearing Existing Data Values in the Essbase Administration Services Online Help . Scaling Data Values This section is for data load only. If you are performing a dimension build, skip this section. You can scale data values if the values of the data source are not in the same scale as the values of the database. For example, assume the real value of sales was $5,460. If the Sales data source tracks the values in hundreds, the value is 54.6. If the Analytic Services database tracks the real value, you need to multiply the value coming in from the Sales data source (54.6) by 100 to have the value display correctly in the Analytic Services database (as 5460). To scale data values, see Scaling Data Values in the Essbase Administration Services Online Help . Flipping Field Signs This section is for data load only. If you are performing a dimension build, skip this section. You can reverse or flip the value of a data field by flipping its sign. Sign flips are based on the UDAs (user-defined attributes) of the outline. When loading data into the accounts dimension, for example, you can specify that any record whose accounts member has a UDA of Expense change from a plus sign to a minus sign. See Creating UDAs for more information on user-defined attributes. To reverse a field sign, see Flipping Signs in the Essbase Administration Services Online Help .  |../ddlfield.htm",
    "Understanding Data Loading and Dimension Building||An Analytic Services database contains dimensions, members, and data values. You can add data values, that is, numbers, to an Analytic Services database from a data source, such as a spreadsheet or a SQL database. This process is called loading data. If the data source is not perfectly formatted, you need a rules file to load the data values. You can add dimensions and members to an Analytic Services database manually, by using Outline Editor. You can also load dimensions and members into a database by using a data source and a rules file. This process is called building dimensions. This chapter describes the components involved in loading data values and loading dimensions and members-data sources and rules files. This chapter contains the following sections: Process for Data Loading and Dimension Building Data Sources Rules Files Situations That Do and Do Not Need a Rules File Data Sources That Do Not Need a Rules File Security and Multiple-User Considerations Some rules file options and data source requirements vary for aggregate storage databases. See Preparing Aggregate Storage Databases for information about aggregate storage differences. Process for Data Loading and Dimension Building To load data values or dimensions and members into an Analytic Services database, follow these steps: Set up the data source. If you are not using a rules file, you must set up the data source outside Analytic Services. For information on data sources, see Data Sources . If necessary, set up the rules file. For a definition and discussion of rules files, see Rules Files . Perform the data load or dimension build. For a comprehensive discussion of how to load data and members, see Performing and Debugging Data Loads or Dimension Builds. Data Sources Data sources contain the information that you want to load into the Analytic Services database. A data source can contain data values; information about members, such as member names, member aliases, formulas and consolidation properties; generation and level names; currency name and category; data storage properties; attributes; and UDAs (user-defined attributes). The following sections describe the components of any kind of data source. Supported Data Sources Items in a Data Source Valid Dimension Fields Valid Member Fields Valid Data Fields Valid Delimiters Valid Formatting Characters Supported Data Sources Analytic Services supports the following types of data sources: Text files (flat files) from text backups or external sources. SQL data sources (non-Unicode only). Analytic Services export files. Export files do not need a rules file to load. Microsoft Excel files with the .XLS extension, Version 4.0 and higher. Microsoft Excel files, Version 5.0 and higher. Load as client objects or files in the file system. Spreadsheet audit log files. Note: If you are using Administration Services Console to load data or build an outline, spreadsheet files are not supported if the Administration Server is installed on a computer with a UNIX operating system. Items in a Data Source As illustrated in Figure85 , a data source is composed of records, fields, and field delimiters. A record is a structured row of related fields. A field is an individual value. A delimiter indicates that a field is complete and that the next item in the record is another field. Analytic Services reads data sources starting at the top and proceeding from left to right. Figure 85: Records and Fields As illustrated in Figure86 , data sources can contain dimension fields, member fields, member combination fields, and data fields. Figure 86: Kinds of Fields Dimension fields identify the dimensions of the database, such as Market. Use dimension fields to tell Analytic Services the order of the dimensions in the data source. In Figure86 , for example, the dimension fields are Market, Product, Year, Measures, and Scenario. Fields in the Market column, such as Texas, are members of the Market dimension, and fields in the Product column, such as 100-10, are members of the Product dimension. Although you can set dimension fields in the data source, usually you define dimension fields in the rules file. Member fields identify the members or member combinations of the specified dimensions. Use member fields to tell Analytic Services to which members to map new data values, or which members to add to the outline. In Figure86 , for example, Texas, 100-10, Jan, Sales, and Actual are all member fields. Data fields contain the numeric data values that are loaded into the intersections of the members of the database. Each data value must map to a dimension intersection. In Figure86 , for example, 42 is the data value that corresponds to the intersection of Texas, 100-10, Jan, Sales, and Actual. You can specify information in the header and in an individual record. In Figure87 , for example, 100 is the data value that corresponds to the intersection of Jan, Actual, Cola, East, Sales and 200 is the data value that corresponds to the intersection of Jan, Actual, Cola, West, Sales. Figure 87: Assigning Data Fields in Headers Jan,ActualColaEastSales100 ColaWestSales200 ColaSouthSales300 Data fields are used only for data loading; dimension builds ignore data fields. The following sections describe each item in a data source: Valid Dimension Fields Valid Member Fields Valid Data Fields Valid Delimiters Valid Formatting Characters Valid Dimension Fields In a data load, every dimension in the Analytic Services database must be specified in the either the data source or the rules file. If the data source does not identify every dimension in the database, you must identify the missing dimensions in a rules file. For example, the Sample Basic database has a dimension for Year. If several data sources arrive with monthly numbers from different regions, the month itself may not be specified in the data sources. You must specify the month in the data source header or the rules file. For information on setting header records, see Defining Header Records . A dimension field must contain a valid dimension name. If you are not performing a dimension build, the dimension must already exist in the database. If you are performing a dimension build, the dimension name can be new, but the new name must be specified in the rules file. Valid Member Fields A member field can contain the name of a valid member or an alias. In Figure86 , for example, Texas and Ohio are valid members of the Market dimension. Analytic Services must know how to map each member field of the data source to a member of the database. In order to be valid, a member field must meet the following criteria: The member field must contain a valid member name or member property. For a discussion of member properties, see Using the Data Source to Set Member Properties . If you are not performing a dimension build, the member must already exist in the outline. If you are performing a dimension build, the member can be new. Either the data source or the rules file must specify which dimension each member field maps to. A member field can map to a single member name, such as Jan (which is a member of the Year dimension), or to a member combination, such as Jan, Actual (which are members of the Year and Scenario dimensions). Member names that contain the same character as the file delimiter must be surrounded by double quotation marks. For example, if the data source is delimited by spaces, make sure that a member containing spaces, such as New York, is surrounded by double quotation marks. If you are performing a data load without a rules file, member names containing some other characters must also be surrounded by quotation marks. For a list of the relevant characters, see Data Sources That Do Not Need a Rules File . Note: While processing each record in a data source for a data load, Analytic Services does not check to ensure a member specified in a member field belongs to the dimension specified for the dimension field. Analytic Services loads the data value to the data cell identified by the member combination in the record. In Figure86 , for example, if the second records reversed Jan and Sales (Texas, '100-10', Sales, Jan, Actual, 42), Analytic Services would load 42 to the correct data cell. Valid Data Fields If you are performing a dimension build, you can skip this section. Data fields are ignored during a dimension build. Either the data source or the rules file must contain enough information for Analytic Services to determine where to put each data value. A data field contains the data value for its intersection in the database. In Figure86 , for example, 42 is a data field. It is the dollar sales of 100-10 (Cola) in Texas in January. In a data field, Analytic Services accepts numbers and their modifiers, with no spaces or separators between them, and the text strings #MI and #MISSING. Valid Modifiers Examples Currency symbols: Dollar $ Euro Yen  $12 is a valid value. $ 12 is not a valid value because there is a space between the dollar sign and the 12. Parentheses around numbers to indicate a negative number (12) Minus sign before numbers. Minus signs after numbers are not valid. -12 Decimal point 12.3 Large numbers with or without commas Both 1,345,218 and 1345218 are valid values. #MI or #MISSING to represent missing or unknown values You must insert #MI or #MISSING into any data field that has no value. If you do not, the data source may not load correctly. For instructions on how to replace a blank field with #MI or #MISSING, see Replacing an Empty Field with Text . If the data source contains a member field for every dimension and one field that contains data values, you must define the field that contains data values as a data field in the rules file. To read Figure88 into the Sample Basic database, for example, define the last field as a data field. Figure 88: Setting Data Fields JanColaEastSalesActual100 FebColaEastSalesActual200 To define a data field, see Defining a Column as a Data Field in Essbase Administration Services Online Help . If there is no value in the data field (or the value is #MISSING), Analytic Services does not change the existing data value in the database. Analytic Services does not replace current values with empty values. Note: If the data source contains blank fields for data values, replace them with #MI or #MISSING. Otherwise, the data may not load correctly. For instructions on how to replace a blank field wi th #MI or #MISSING, se e Replacing an Empty Field with Text . Valid Delimiters You must separate fields from each other with delimiters. If you are loading data without a rules file, you must uses spaces to delimit fields. If you are using a rules file, delimiters can be any of the following: Tabs (Tabs are the default delimiter expected by Analytic Services.) Spaces New lines Carriage returns Commas Extra Delimiters Without a Rules File In data sources that are loaded without a rules file, Analytic Services ignores extra delimiters. In Figure89 , for example, the fields are separated by spaces. Analytic Services ignores the extra spaces between the fields. Figure 89: File Delimiters EastColaActualJanSales10 EastColaActualFebSales21 EastColaActualMarSales30 Extra Delimiters with a Rules File In data sources that are loaded with a rules file, Analytic Services reads extra delimiters as empty fields. For example, if you try to use a rules file to load the file in Figure90 into the Sample Basic database, the load fails. Analytic Services reads the extra comma between East and Cola in the first record as an extra field. Analytic Services then puts Cola into Field 3. In the next record, however, Cola is in Field 2. Analytic Services expects Cola to be in Field 3 and stops the data load. Figure 90: File Delimiters East,,Cola,Actual,Jan,Sales,10 East,Cola,Actual,Feb,Sales,21 East,Cola,Actual,Mar,Sales,30 To solve the problem, delete the extra delimiter from the data source. Valid Formatting Characters Analytic Services views some characters in the data source as formatting characters only. For that reason, Analytic Services ignores the following characters: == Two or more equal signs, such as for double underlining -- Two or more minus signs, such as for single underlining _ _ Two or more underscores == Two or more IBM PC graphic double underlines (ASCII character 205) _ _ Two or more IBM PC graphic single underlines (ASCII character 196) Ignored fields do not affect the data load or dimension build. For example, Analytic Services ignores the equal signs in Figure91 and loads the other fields normally. Figure 91: Ignoring Formatting Characters During Loading EastActual100-10 SalesMarketing ============== Jan108 Feb2116 Rules Files Rules are a set of operations that Analytic Services performs on data values or on dimensions and members when it processes a data source. Use rules to map data values to an Analytic Services database or to map dimensions and members to an Analytic Services outline. Figure 92: Loading Data Sources Through Rules Files Rules are stored in rules files. A rules file tells Analytic Services which build method to use, specifies whether data values or members are sorted or in random order, and tells Analytic Services how to transform data values or members before loading them. It is best to create a separate rules file for each dimension. Analytic Services reads the data values or members in the data source, changes them based on the rules in the rules file, and loads the changed data values into the database and the changed members into the outline. Analytic Services does not change the data source. You can re-use a rules file with any data source that requires the same set of rules. After you create a dimension build rules file, you may want to automate the process of updating dimensions. Using ESSCMD. Situations That Do and Do Not Need a Rules File You need a rules file if the data source does not map perfectly to the database or if you are performing any of the following tasks: Loading data from a SQL data source Building dimensions Adding new dimensions and members to the database Changing existing dimensions and members in the database Changing the data in any way, including the following: Ignoring fields or strings in the data source Changing the order of fields by moving, joining, splitting, or creating fields Mapping the data in the data source to the database by changing strings Changing the data values in the data source by scaling data values or by adding data values to existing data values in the data source Setting header records for missing values Rejecting an invalid record and continuing the data load You do not need a rules file if you are performing a data load and the data source maps perfectly to the database. For a description of a data source that maps perfectly, see Data Sources That Do Not Need a Rules File . Note: If you are using a rules file, each record in the rules file must have the same number of fields. See Dealing with Missing Fields in a Data Source . Data Sources That Do Not Need a Rules File If you are performing a dimension build, skip this section. You cannot perform a dimension build without a rules file. If a data source contains all information required to load the data values in it into the database, you can load the data source directly. This kind of load is called a free-form data load. To load a data value successfully, Analytic Services must encounter one member from each dimension before encountering the data value. For example, in Figure86 , Analytic Services loads the data value 42 into the database with the members Texas, 100-10, Jan, Sales, and Actual. If Analytic Services encounters a data value before a member of each dimension is specified, it stops loading the data source. To map perfectly, a data source must contain all of the following and nothing other than the following: One or more valid members from each dimension. A member name must be enclosed in quotation marks if it contains any of the following: Spaces Numeric characters (0-9) Dashes (minus signs, hyphens) Plus signs &amp; (ampersands) If you are performing a data load without a rules file, when Analytic Services encounters an invalid member field, it stops the data load. Analytic Services loads all fields read before the invalid field into the database, resulting in a partial load of the data values. For information on continuing the load, see Loading Dimension Build and Data Load Error Logs . One or more valid data values. For examples of valid values, see Valid Data Fields . If the data source contains blank fields for data values, replace the blank fields with #MI or #MISSING. Otherwise, the data values may not load correctly. Valid delimiters. For a list of valid delimiters, see Valid Delimiters . The fields in the data source must be formatted in an order that Analytic Services understands. The simplest way to format a record is to include a member from each dimension and a data field, as illustrated in Figure93 : Figure 93: Sample Free-Form Data Source Sales 100-10 Ohio Jan Actual 25 Sales 100-20 Ohio Jan Actual 25 Sales 100-30 Ohio Jan Actual 25 If the data source is not correctly formatted, it will not load. You can edit the data source using a text editor and fix the problem. If you find that you must perform many edits (such as moving several fields and records), it might be easier to use a rules file to load the data source. For a definition and discussion of rules files, see Rules Files . The following sections describe more complicated ways to format free-form data sources: Formatting Ranges of Member Fields Formatting Columns Formatting Ranges of Member Fields If you are performing a dimension build, skip this section. You cannot perform a dimension build without a rules file. You can express member names as ranges within a dimension. For example, Sales and COGS form a range in the Measures dimension. Ranges of member names can handle a series of values. A data source can contain ranges from more than one dimension at a time. In Figure94 , for example, Jan and Feb form a range in the Year dimension and Sales and COGS form a range in the Measures dimension. Figure 94: Multiple Ranges of Member Names Actual Texas SalesCOGS JanFebJanFeb 100-1098892619 100-2087782332 In Figure94 , Sales is defined for the first two columns and COGS for the last two columns. The following sections describe additional types of ranges: Setting Ranges Automatically Handling Out of Range Data Values Interpreting Duplicate Members in a Range Reading Multiple Ranges Setting Ranges Automatically If you are performing a dimension build, skip this section. You cannot perform a dimension build without a rules file. When Analytic Services encounters two or more members from the same dimension with no intervening data fields, it sets up a range for that dimension. The range stays in effect until Analytic Services encounters another member name from the same dimension, at which point Analytic Services replaces the range with the new member or new member range. Figure95 , for example, contains a range of Jan to Feb in the Year dimension. It remains in effect until Analytic Services encounters another member name, such as Mar. When Analytic Services encounters Mar, the range changes to Jan, Feb, Mar. Figure 95: Ranges of Member Names Texas Sales JanFebMar Actual100-10988958 100-208778115 Handling Out of Range Data Values If you are performing a dimension build, skip this section. You cannot perform a dimension build without a rules file. When Analytic Services encounters a member range, it assumes that there is a corresponding range of data values. If the data values are not in the member range, the data load stops. Analytic Services loads any data fields read before the invalid field into the database, resulting in a partial load of the data. Figure96 , for example, contains more data fields than member fields in the defined range of members. The data load stops when it reaches the 10 data field. Analytic Services loads the 100 and 120 data fields into the database. Figure 96: Extra Data Values Cola ActualEast JanFeb Sales10012010 COGS303432 For information on restarting the load, see Loading Dimension Build and Data Load Error Logs . Interpreting Duplicate Members in a Range If you are performing a dimension build, skip this section. You cannot perform a dimension build without a rules file. Be sure to structure ranges in the source data so that Analytic Services interprets them correctly. If the a member appears more than once in a range, Analytic Services ignores the duplicates. The file in Figure97 contains two ranges: Actual to Budget and Sales to COGS. It also contains duplicate members. Figure 97: Duplicate Members in a Range Cola East Actual Budget Actual Budget Sales Sales COGS COGS Jan 108 110 49 50 Feb 102 120 57 60 Analytic Services ignores the duplicate members. The members that Analytic Services ignores have a line through them in the following example: Figure 98: Ignored Duplicate Members Cola East Actual Budget Actual Budget Sales Sales COGS COGS Jan 108 110 49 50 Feb 102 120 57 60 For Actual, the first member of the first range, Analytic Services maps data values to each member of the second range (Sales and COGS). Analytic Services then proceeds to the next value of the first range, Budget, similarly mapping values to each member of the second range. As a result, Analytic Services interprets the file as shown in Figure99 . Figure 99: How Analytic Services Interprets the File in Figure97 Cola East Actual Budget Sales COGS Sales COGS Jan 108 110 49 50 Feb 102 120 57 60 Reading Multiple Ranges If you are performing a dimension build, skip this section. You cannot perform a dimension build without a rules file. As Analytic Services scans a file, it processes the most recently encountered range first when identifying a range of data values. In Figure99 , for example, there are two ranges: Actual and Budget and Sales and COGS. While reading the file from left to right and top to bottom, Analytic Services encounters the Actual and Budget range first and the Sales and COGS range second. Because the Sales and COGS range is encountered second, Analytic Services puts data fields in the Sales and COGS part of the database first. Formatting Columns If you are performing a dimension build, skip this section. You cannot perform a dimension build without a rules file. Files can contain columns of fields. Columns can be symmetric or asymmetric. Symmetric columns have the same number of members under them. Asymmetric columns have different numbers of members under them. Analytic Services supports loading data from both types of columns. Symmetric Columns If you are performing a dimension build, skip this section. You cannot perform a dimension build without a rules file. Symmetric columns have the same number of members under them. In Figure100 , for example, each dimension column has one column of members under it. For example, Product has one column under it (100-10 and 100-10) and Market has one column under it (Texas and Ohio). Figure 100: Symmetric Columns ProductMeasuresMarketYearScenario 100-10SalesTexasJanActual112 100-10SalesOhioJanActual145 The columns in the following file are also symmetric, because Jan and Feb have the same number of members under them: Figure 101: Groups of Symmetric Columns Jan Feb Actual Budget Actual Budget 100-10 Sales Texas 112 110 243 215 100-10 Sales Ohio 145 120 81 102 Asymmetric Columns If you are performing a dimension build, skip this section. You cannot perform a dimension build without a rules file. Columns can also be asymmetric. In Figure102 , the Jan and Feb columns are asymmetric because Jan has two columns under it (Actual and Budget) and Feb has only one column under it (Budget): Figure 102: Valid Groups of Asymmetric Columns Jan Jan Feb Actual Budget Budget 100-10 Sales Texas 112 110 243 100-10 Sales Ohio 145 120 81 If a file contains asymmetric columns, you must label each column with the appropriate member name. The file in Figure103 , for example, is not valid because the column labels are incomplete. The Jan label must appear over both the Actual and Budget columns. Figure 103: Invalid Asymmetric Columns Jan Feb Actual Budget Budget 100-10 Sales Texas 112 110 243 100-10 Sales Ohio 145 120 81 This file in Figure104 is valid because the Jan label is now over both Actual and Budget. It is clear to Analytic Services that both of those columns map to Jan. Figure 104: Valid Asymmetric Columns Jan Jan Feb Actual Budget Budget 100-10 Sales Texas 112 110 243 100-10 Sales Ohio 145 120 81 Security and Multiple-User Considerations Analytic Services supports concurrent multiple users reading and updating the database. Thus, users can use the database while you are dynamically building dimensions, loading data, or calculating the database. In a multi-user environment, Analytic Services protects data by using the security system described in Managing Security for Users and Applications . Security Issues Th e security system prevents unauthorized users from changing the database. Only users with write access to a database can load data values or add dimensions and members to the database. Write access can be provided globally or by using filters. Multi-User Data Load Issues You can load data values while multiple users are connected to a database. Analytic Services uses a block locking scheme for handling multi-user issues. When you load data values, Analytic Services does the following: Locks the block it is loading into so that no one can write to the block. See Ensuring Data Integrity for information on Analytic Services transaction settings, such as identifying whether other users get read-only access to the locked block or noting how long Analytic Services waits for a locked block to be released. Updates the block. See Data Locks for information on whether Analytic Services unlocks a block when its update is complete or waits for the entire data load to complete before unlocking the block. Multi-User Dimension Build Issues You cannot build dimensions while other users are reading or writing to the database. After you build dimensions, Analytic Services restructures the outline and locks the database for the duration of the restructure operation.  |../ddlintro.htm",
    "Performing and Debugging Data Loads or Dimension Builds||This chapter describes how to load data or members from one or more external data sources to an Analytic Server. You can load data without updating the outline, you can update the outline without loading data, or you can load data and build dimensions simultaneously. For information about setting up data sources and rules files, see Understanding Data Loading and Dimension Building and Creating Rules Files. This chapter contains the following sections: Prerequisites for Data Loads and Dimension Builds Performing Data Loads or Dimension Builds Stopping Data Loads or Dimension Builds Reviewing the Tips for Loading Data and Building Dimensions Debugging Data Loads and Dimension Builds Prerequisites for Data Loads and Dimension Builds Before you start to load data or build dimensions, make sure that you have the following items in place: An Analytic Services database. A connection to the appropriate Analytic Server. One or more valid data sources. For a comprehensive discussion of data sources, see Data Sources . If you are not using a rules file, a data source correctly formatted for free-form data loading, see Data Sources That Do Not Need a Rules File . If you are using a rules file, for a definition and discussion of rules files, see Rules Files . Performing Data Loads or Dimension Builds When you start to load data or build dimensions, you must first select one or more valid data sources that contain the data to load or dimensions to build. For a list of types of valid data sources, see Supported Data Sources . Make sure you are connected to the Analytic Server before you specify the data sources. For a comprehensive discussion of how to optimize a data load, see Optimizing Data Loads. When you use Administration Services to perform a data load or dimension build for a block storage database, you can execute the load or build in the background so that you can continue working as the load or build processes. You can then check the status of the background process to see when the load or build has completed. For more information, see Performing a Data Load or Dimension Build in Essbase Administration Services Online Help . Note: If you are loading data into a transparent partition, follow the same steps as for loading data into a local database. To load data or build dimensions, use any of the following methods: Tool Topic Location Administration Services Performing a Data Load or Dimension Build Essbase Administration Services Online Help MaxL For data loading: import data For dimension building: import dimensions Technical Reference ESSCMD For data loading: IMPORT For dimension building: BUILDDIM Technical Reference Stopping Data Loads or Dimension Builds You can stop a data load or dimension build before it completes. You should not stop a data load or dimension build unless you are very sure that stopping is necessary. If a data load or dimension build process is terminated, Analytic Services displays the file name as partially loaded. If you initiate a data load or dimension build from a client and terminate the data load or dimension build from the server, it could take some time before the client responds to the termination request. Because Analytic Services reads the source file until all source data is read, the amount of time depends on the size of the file and the amount of source data that Analytic Services has processed. If the process is terminated from the machine that initiated it, the termination is immediate. Note: If you are adding to or subtracting from data values during a data load to a block storage database, use the Committed Isolation Level setting, if possible. If the data load is terminated, this setting rolls the data load back to its previous state. For a description of the operation of each isolation level setting, see Understanding Isolation Levels . If you stop a data load that is adding to or subtracting from data values, see Recovering from an Analytic Server Crash to identify the recovery procedure. To stop a data load or dimension build before it completes, use any of the following methods: Tool Topic Location Administration Services Disconnecting User Sessions and Requests Essbase Administration Services Online Help MaxL alter system kill request Technical Reference Reviewing the Tips for Loading Data and Building Dimensions This section lists tips for data loading and dimension building. It contains the following sections Determining Where to Load Data Loading Data Using a Spreadsheet Dealing with Missing Fields in a Data Source Loading a Subset of Records from a Data Source Determining Where to Load Data Skip this section if you are building dimensions or working with an aggregate storage database. If you load data into a parent member, when you calculate the database, the consolidation of the children's data values can overwrite the parent data value. To prevent overwriting, be aware of the following: If possible, do not load data directly into a parent. If you must load data into a parent member, make sure that Analytic Services knows not to consolidate #MISSING values from the children of the parent into the parent, as directed in the following table: To set the consolidation, use any of the following methods: Tool Topic Location Administration Services Aggregating Missing Values During Calculation Essbase Administration Services Online Help Calculation Script SET AGGMISSG Technical Reference MaxL alter database Technical Reference ESSCMD SETDBSTATEITEM Technical Reference The methods in this table work only if the child values are empty (#MISSING). If the children have data values, the data values overwrite the data values of the parent. For a discussion of how Analytic Services calculates #MISSING values, see Consolidating #MISSING Values . Note: You cannot load data into Dynamic Calc, Dynamic Calc and Store, or attribute members. For example, if Year is a Dynamic Calc member, you cannot load data into it. Instead, load data into Qtr1, Qtr2, Qtr3, and Qtr4, which are not Dynamic Calc members. Loading Data Using a Spreadsheet Skip this section if you are building dimensions. If you use a spreadsheet to load data, see the Essbase Administration Services Online Help and search for spreadsheet in the index. Dealing with Missing Fields in a Data Source Each record in the data source must have the same number of fields to perform a data load or dimension build. If fields are missing, the data load or dimension build processes incorrectly. For example, the file in Figure108 is invalid, because there is no value under Apr. To fix the file, insert #MISSING or #MI into the missing field. For instructions, see Replacing an Empty Field with Text . Figure 108: Missing Fields Actual Ohio Sales Cola Jan Feb Mar Apr 10 15 20 Figure109 is valid because #MI replaces the missing field. Figure 109: Valid Missing Fields Actual Ohio Sales Cola Jan Feb Mar Apr 10 15 20 #MI If a rules file has extra blank fields, join the empty fields with the field next to them. For a brief discussion, see Joining Fields . Loading a Subset of Records from a Data Source You can load a subset of records in a data source during a data load or a dimension build. For example, you can load records 250 to 500 without loading the other records of the data source. To load a subset of records: Using a text editing tool, number the records in the data source. Set the rules file to ignore the column containing the record number. For a brief discussion, see Ignoring Fields . Define a rejection criterion that rejects all records except those that you want to load. For example, reject all records for which the ignored column is less than 250 or greater than 500. For a brief discussion, see Rejecting Records . Note: You cannot reject more records than the error log can hold. By default, the limit is 1000, but you can change it by setting DATAERRORLIMIT in the essbase.cfg file. See the Technical Reference for more information. Debugging Data Loads and Dimension Builds If you try to load a data source into Analytic Server, but it does not load correctly, check the following: Are you connected to the appropriate application and database? Are you trying to load the correct data source? If you can answer both of the above questions with a yes, something is probably wrong. Use the following sections to determine what the problem is and to correct the problem. Verifying That Analytic Server Is Available Verifying That the Data Source Is Available Checking Error Logs Recovering from an Analytic Server Crash Resolving Problems with Data Loaded Incorrectly Creating Rejection Criteria for End of File Markers Understanding How Analytic Services Processes a Rules File Understanding how Analytic Services Processes Invalid Fields During a Data Load When you correct the problems, you can reload the records that did not load by reloading the error log. For more information, see Loading Dimension Build and Data Load Error Logs . Verifying That Analytic Server Is Available To help identify if the problem is with Analytic Services and not with the server or network, try to access the server without using Analytic Services. Check the following: Is the server machine running? Try to connect to it without using Analytic Services. If you cannot, check with your system administrator. Is Analytic Server running? Check with your Analytic Services administrator. Can the client machine connect to the server machine? Try to connect to the server machine from the client machine without using Analytic Services. Verifying That the Data Source Is Available If Analytic Services cannot open the data source that you want to load, check the following: Is the data source already open? The data source will already be open if a user is editing the data source. Analytic Services can load only data sources that are not locked by another user or application. Does the data source have the correct file extension? All text files must have a file extension of .TXT . All rules files must have a file extension of .RUL . Is the data source name and the path name correct? Check for misspellings. Is the data source in the specified location? Check to make sure that no one has moved or deleted the data source. If you are using a SQL data source, is the connection information (such as the user name, password, and database name) correct? If you are using a SQL data source, can you connect to the SQL data source without using Analytic Services? Checking Error Logs If a data load or dimension build fails, the error log can be a valuable debugging tool. See Understanding and Viewing Dimension Build and Data Load Error Logs in for more information about error logs. If there is no error log, check the following: Did the person running the data load set up an error log? Click Help in the Data Load dialog box for information on setting up an error log. By default, when you use a rules file, Analytic Services creates an error log. Are you sure that the data source and Analytic Server are available? See Verifying That Analytic Server Is Available and Verifying That the Data Source Is Available for lists of items to check. Did the Analytic Server crash during the data load? If so, you probably received a time-out error on the client. If the server crashed, see Recovering from an Analytic Server Crash to identify a recovery procedure. Check the application log. For a review of log information, see Analytic Server and Application Logs . If the error log exists but is empty, Analytic Services does not think that an error occurred during loading. Check the following: Does the rules file contain selection or rejection criteria that rejected every record in the data source? See Selecting Records and Rejecting Records for a discussion of how to set selection and rejection criteria. Is the rules file correct? Does the rules file validate properly? See Requirements for Valid Data Load Rules Files and Requirements for Valid Dimension Build Rules Files for a discussion of causes of non validation. Recovering from an Analytic Server Crash If the server crashes while you are loading data, Analytic Services sends you a time-out error. The recovery procedures that you need to perform depend on the type of load you are performing and the Isolation Level setting: If you are overwriting the values of the data source, reload the data source when the server is running again. If you are adding to or subtracting from existing values in the data source and the Isolation Level transaction setting is Committed, reload the data source when the server is running again. If you are adding to or subtracting from existing values in the data source and the Isolation Level is Uncommitted, determine how much data Analytic Services loaded before the crash: Compare the values of the data source with the values of the database. If the values that you are adding to or subtracting from have not changed, reload the data source. If the values that you are adding to or subtracting from have changed, clear the values that loaded and reload the previous data sources. If, for example, you derive monthly sales figures by adding the sales figures for each week as they are loaded, clear the sales figures from the database and re-load the sales figures for each week up to the current week. For a description of Isolation Level settings, see Understanding Isolation Levels . Resolving Problems with Data Loaded Incorrectly If the data source loads without error, but the data in the database is wrong, check the following: Are you sure that you loaded the correct data source? If so, check the data source again to make sure that it contains the correct values. Are there any blank fields in the data source? You must insert #MI or #MISSING into a data field that has no value. Otherwise, the data source may not load correctly. To replace a blank field with #MI or #MISSING using a rules file, see Replacing an Empty Field with Text . Is the data source formatted correctly? Are all ranges set up properly? Is the data clean? For example, as it processes the data source, Analytic Services recognizes member names and knows the dimensions they belong to. If a data source record inadvertently includes a member from a dimension for which there is a member named in the header record, the new member name replaces the header record member for that dimension. Consider the following example data source: JanActualTexasSales 100-1051.7 100-20102.5 100-20335.0 Florida96.7 200-20276.0 200-20113.1 200-10167.0 Analytic Services recognizes Florida to be a member of the Market dimension. The values in the last four records are interpreted as Florida values instead of Texas values. Are there any implicitly shared members that you were unaware of? Implicit shares happen when a parent and child share the same data value. This situation occurs if a parent has only one child or only one child rolls up into the parent. For a definition and discussion of implied sharing, see Understanding Implied Sharing . Did you add incoming data to existing data instead of replacing incoming data with existing data? For a discussion of the adding and subtracting process, see Adding to and Subtracting from Existing Values . Have you selected or rejected any records that you did not intend to select or reject? For a brief discussion of selecting and rejecting, see Selecting Records and Rejecting Records . If the sign is reversed (for example, a minus sign instead of a plus sign), did you perform any sign flips on UDAs (user-defined attributes)? For a discussion of the sign flipping process, see Flipping Field Signs . Did you clear data combinations that you did not intend to clear? For a discussion of the process of clearing data, see Clearing Existing Data Values . Did you scale the incoming values incorrectly? For examples of scaling data, see Scaling Data Values . Are all member and alias names less than 79 characters long? Note: You can check data by exporting it, by running a report on it, or by using a spreadsheet. If doing exports and reports, see Developing Report Scripts and Using ESSCMD. If using a spreadsheet, see the Essbase Spreadsheet Add-in User's Guide . Creating Rejection Criteria for End of File Markers A SQL data source may have an end of file marker made up of special characters that cause a data load or dimension build to fail. To fix this problem, define a rejection criterion to reject the problem record. Find the end of file marker in the SQL data source. Determine how to search for it using the Analytic Services search command. This task may be difficult as the end of file marker may be composed of one or more special characters. To ignore all instances of a string, see Ignoring Fields Based on String Matches in the Essbase Administration Services Online Help . Define a rejection criterion that rejects the end of file marker. See Rejecting Records in the Essbase Administration Services Online Help . Understanding How Analytic Services Processes a Rules File Sometimes, you can track down problems with dimension builds by understanding how Analytic Services initializes the rules file and processes the data source. Analytic Services performs the following steps to initialize a rules file: Validates the rules file against the associated outline. Validates the dimensions. This process includes ensuring that the build method and field types are compatible and that each dimension name is unique. Member names must be either unique or shared. Adds new dimensions defined in the rules file to the outline. Reads header records specified in the data source. Then Analytic Services performs the following operations on each record of the data source during a data load or dimension build: Sets the file delimiters for all records. Applies field operations to the data in the order that the operations are defined in the rules file. Field operations include joins, moves, splits, and creating fields using text and joins. To see the order in which field operations are defined in the rules file, see Undoing Field Operations . The dialog box displayed lists all the field operations in order. Analytic Services applies all properties for each field, applying all properties to field1 before proceeding to field2. Analytic Services applies field properties in the following order: Ignores fields set to be ignored during data load. Ignores fields set to be ignored during dimension build. Flags the data field. Applies field names. Applies field generations. Performs all replaces in the order that they are defined in the rules file. Drops leading and trailing spaces. Converts spaces to underscores. Applies suffix and prefix operations. Scales data values. Converts text to lowercase. Converts text to uppercase. Adds members or member information, or both, to the outline. If you chose to skip lines, Analytic Services skips the number of lines that you specified; otherwise, Analytic Services proceeds to the first record. Analytic Services performs selection or rejection criteria in the order that the criteria are defined in the rules file. Analytic Services loads or rejects individual records of the data source based on the specified criteria. Understanding how Analytic Services Processes Invalid Fields During a Data Load The following sections describe how Analytic Services processes invalid fields during a data load. Missing Dimension or Member Fields Unknown Member Fields Invalid Data Fields Missing Dimension or Member Fields If you are using a rules file for the data load, skip this section. It applies only to data loaded without a rules file. In a free-form data load, if a dimension or member field is missing, Analytic Services uses the value that it used previously for that dimension or member field. If there is no previous value, Analytic Services aborts the data load. For example, when you load Figure110 into the Sample Basic database, Analytic Services maps the Ohio member field into the Market dimension for all records, including the records that have Root Beer and Diet Cola in the Product dimension. Figure 110: Valid Missing Members Jan Sales Actual Ohio Cola 25 Root Beer 50 Diet Cola 19 Analytic Services stops the data load if no prior record contains a value for the missing member field. If you try to load Figure111 into the Sample Basic database, for example, the data load stops, because the Market dimension (Ohio, in Figure110 ) is not specified. Figure 111: Invalid Missing Members Jan Sales Actual Cola 25 Root Beer 50 Diet Cola 19 For information on restarting the load, see Loading Dimension Build and Data Load Error Logs . Unknown Member Fields If you are performing a data load and Analytic Services encounters an unknown member name, Analytic Services rejects the entire record. If there is a prior record with a member name for the missing member field, Analytic Services continues to the next record. If there is no prior record, the data load stops. For example, when you load Figure112 into the Sample Basic database, Analytic Services rejects the record containing Ginger Ale because it is not a valid member name. Analytic Services loads the records containing Cola, Root Beer, and Cream Soda. If Ginger Ale were in the first record, however, the data load would stop. Figure 112: Unknown Members Jan, Sales, Actual Ohio Cola 2 Root Beer 12 Ginger Ale 15 Cream Soda 11 Note: If you are performing a dimension build, you can add the new member to the database. See Performing Data Loads or Dimension Builds . For information on restarting the load, see Loading Dimension Build and Data Load Error Logs . Invalid Data Fields If you are performing a data load, when Analytic Services encounters an invalid data field, it stops the data load. Analytic Services loads all fields read before the invalid field into the database, resulting in a partial load of the data. In the following file, for example, Analytic Services stops the data load when it encounters the 15- data value. Analytic Services loads the Jan and Feb Sales records, but not the Mar and Apr Sales records. Figure 113: Invalid Data Field East Cola Actual Sales Jan $10 Feb $21 Mar $15- Apr $16 For information on continuing the load, see Loading Dimension Build and Data Load Error Logs .  |../ddlload.htm",
    "About Essbase Administration Services||Essbase Administration Services is the cross-platform administration tool for Essbase Analytic Services, replacing Application Manager. Administration Services consists of a Java middle-tier server, called Administration Server, and a Java client console, called Administration Services Console. Administration Services Console is the graphical user interface that enables administrators to manage the Analytic Services environment from a single navigation tree, called Enterprise View. The console provides wizards, editors, and other tools to help administrators view, manage, and maintain a unique set of Essbase Analytic Servers. The console includes a data preview grid that enables you to preview data without having to switch from the console to another program. Essbase Administration Services provides its own set of documentation, including an installation guide, a context-sensitive online help system, a developer's guide, a Java API Reference, and a readme. To view documentation, first start Administration Server and then launch the Essbase Administration Services Information Map ( eas\\doc_launcher.htm under the Essbase Administration Services installation directory). For information about release compatibility, platform support and system requirements, and installation instructions, see Essbase Administration Services Installation Guide . For procedural instructions for using Administration Services to manage Essbase, see Essbase Administration Services Online Help . Administration Services Architecture Administration Services works with Analytic Servers in a three-tiered system that consists of a client user interface, a middle-tier server, and one or more Analytic Servers. The middle tier coordinates interactions and resources between the user interface and Analytic Servers. The three tiers may or may not be on the same computer or platform. The three tiers include the following components, as illustrated below: Figure 45: Administration Services Architecture Client tier (Administration Services Console): A Java-based client console provides a user interface to manage the Analytic Services environment. Middle tier (Administration Server): A Java-based server maintains communication, session, and security information for connections to Analytic Servers. Database tier (Analytic Server): One or more Analytic Servers store and process multidimensional database information. Analytic Servers are installed separately from Administration Services. Note: For information about which platforms are supported for the client and middle tier components, see Essbase Administration Services Installation Guide . Deploying Administration Services Administration Services can be deployed in a variety of scenarios. For example, you can install Analytic Server on a computer running UNIX and install Administration Server and Administration Services Console on a computer running Windows. You can also install Administration Server and Administration Services Console on separate computers and platforms. The middle tier Administration Server also supports the substitution of certain third-party products within the existing framework (for example, application servers and relational databases). For complete information about deployment scenarios and guidelines, see Essbase Administration Services Installation Guide . Starting Administration Services To start Administration Services, first start Administration Server, and then start Administration Services Console. For instructions, see Starting Administration Services in Essbase Administration Services Installation Guide . If you have enabled an Analytic Server for remote start, you can start that Analytic Server remotely from Enterprise View in Administration Services Console. To enable this functionality, you need to configure and start the Remote Start Service on the Analytic Server machine. For instructions, see Starting Analytic Server Remotely from Administration Services Console . About Administration Services Users Existing Analytic Services users cannot use Administration Services until they have also been created as users on Administration Server. You can use the User Setup Wizard to step you through the process of creating Administration Server users and associating them with the appropriate Analytic Servers. You do not to create spreadsheet users on the Administration Server. To create Administration Services users, see User Setup Wizard in Essbase Administration Services Online Help . Connecting to Administration Services In Administration Services, connections to individual Analytic Servers are handled by the middle tier Administration Server. When you start Administration Services, you are automatically connected to each Analytic Server you have added to Enterprise View (if Analytic Server is started). For information about how Analytic Server connections are established, see About Analytic Services Connections and Ports in Essbase Administration Services Online Help . You can connect to different releases of Analytic Server simultaneously from Administration Services Console. Your Administration Services username and password may be different than your Analytic Server username and password. If you do not know your Administration Services username and password, see your Administration Services administrator for more information. After your initial connection to Administration Services, you can use the User Setup Wizard to create Administration Services users and add Analytic Servers to each user's Enterprise View. For more information, see Connecting to Administration Services in Essbase Administration Services Online Help . Adding Administration Servers to Enterprise View Each time you connect to Administration Services, the Administration Servers you have chosen are displayed in Enterprise View, which is the navigation tree in the left navigation panel. Each user can populate Enterprise View with a unique set of Administration Servers. You can use the following methods to add Analytic Servers to Enterprise View: To add Administration Servers to Enterprise View, see Adding Administration Servers to Enterprise View in Essbase Administration Services Online Help . Adding Analytic Servers to Enterprise View Each time you connect to Administration Services, the Analytic Servers you have chosen are displayed in Enterprise View, which is the navigation tree in the left navigation panel. Each user can populate Enterprise View with a unique set of Analytic Servers. You can use the following methods to add Analytic Servers to Enterprise View: In Enterprise View, right-click the Essbase Analytic Servers node, and select Add Analytic Server. Select Wizards &gt; User Setup and follow the steps in the wizard. For an existing user, edit the user's properties. You can also create custom views of the Enterprise View tree in separate tabs in the navigation panel. For more information, see About Custom Views in Essbase Administration Services Online Help . To add Analytic Servers to Enterprise View, see Adding Analytic Servers to Enterprise View in Essbase Administration Services Online Help . About Analytic Server Connections and Ports The number of ports available for an Analytic Server represents the number of licensed concurrent connections. Analytic Services provides one reserve port for the system administrator. A system administrator uses the reserve port to log out one or more users when all other ports are in use. For more information about Analytic Services ports, see Running Analytic Servers, Applications, and Databases. In Administration Services, a port is in use only when an Analytic Server connection is established. For information about how connections (ports) are established and released, see About Analytic Services Connections and Ports in Essbase Administration Services Online Help . About Administration Server The middle tier Administration Server provides business logic to support cross-server operations, persistence of user preferences, and access to Analytic Servers. A system administrator creates users on Administration Server, and then Administration Server manages their connections to Analytic Services. In Enterprise View, the node name for Administration Server is the same as the server computer name. Administration Server has several configurable communication ports. These ports are different from Analytic Server ports. If one of the default communication ports is in use by another application, you need to specify another port value in order to run Administration Server. Note: If you change the value for the Administration Server port, you must specify the new port value when you log in to the Administration Services Console. To change a default port value, see Specifying Communication Ports for Administration Server in Essbase Administration Services Online Help .  |../deas.htm",
    "Basic Architectural Elements||In this chapter, you will learn how Essbase Analytic Services improves performance by reducing storage space and speeding up data retrieval for multidimensional databases. Note: The information in this chapter is designed for block storage databases. Some of the information is not relevant to aggregate storage databases. For detailed information on the differences between aggregate and block storage, see Comparison of Aggregate and Block Storage. This chapter contains the following sections: Attribute Dimensions and Standard Dimensions Sparse and Dense Dimensions Data Blocks and the Index System Selection of Sparse and Dense Dimensions Dense and Sparse Selection Scenarios The Analytic Services Solution Attribute Dimensions and Standard Dimensions Analytic Services has two types of dimensions: attribute dimensions and standard dimensions (non-attribute dimensions). This chapter primarily considers standard dimensions because Analytic Services does not allocate storage for attribute dimension members. Instead it dynamically calculates the members when the user requests data associated with them. An attribute dimension is a special type of dimension that is associated with a standard dimension. For comprehensive discussion of attribute dimensions, see Working with Attributes. Sparse and Dense Dimensions Most data sets of multidimensional applications have two characteristics: Data is not smoothly and uniformly distributed. Data does not exist for the majority of member combinations. For example, all products may not be sold in all areas of the country. Analytic Services maximizes performance by dividing the standard dimensions of an application into two types: dense dimensions and sparse dimensions . This division allows Analytic Services to cope with data that is not smoothly distributed, without losing the advantages of matrix-style access to the data. Analytic Services speeds up data retrieval while minimizing the memory and disk requirements. Most multidimensional databases are inherently sparse: they lack data values for the majority of member combinations. A sparse dimension is a dimension with a low percentage of available data positions filled. For example, the Sample Basic database shown in Figure23 includes the Year, Product, Market, Measures, and Scenario dimensions. Product represents the product units, Market represents the geographical regions in which the products are sold, and Measures represents the accounts data. Because not every product is sold in every market, Market and Product are chosen as sparse dimensions. Most multidimensional databases also contain dense dimensions. A dense dimension is a dimension with a high probability that one or more data points is occupied in every combination of dimensions. For example, in the Sample Basic database, accounts data exists for almost all products in all markets, so Measures is chosen as a dense dimension. Year and Scenario are also chosen as dense dimensions. Year represents time in months, and Scenario represents whether the accounts values are budget or actual values. Note: Caffeinated, Intro Date, Ounces, and Pkg Type are attribute dimensions that are associated with the Product dimension. Population is an attribute dimension that is associated with the Market dimension. Members of attribute dimensions describe characteristics of the members of the dimensions with which they are associated. For example, each product has a size in ounces. Attribute dimensions are always sparse dimensions and must be associated with a sparse standard dimension. Analytic Services does not store the data for attribute dimensions, Analytic Services dynamically calculates the data when a user retrieves it. For a comprehensive discussion about attribute dimensions, see Working with Attributes. Figure 23: Sample Basic Database Outline Data Blocks and the Index System Analytic Services uses two types of internal structures to store and access data: data blocks and the index system. Analytic Services creates a data block for each unique combination of sparse standard dimension members (providing that at least one data value exists for the sparse dimension member combination). The data block represents all the dense dimension members for its combination of sparse dimension members. Analytic Services creates an index entry for each data block. The index represents the combinations of sparse standard dimension members. It contains an entry for each unique combination of sparse standard dimension members for which at least one data value exists. For example, in the Sample Basic database outline shown in Figure24 , Product and Market are sparse dimensions. Figure 24: Product and Market Dimensions from the Sample Basic Database If data exists for Caffeine Free Cola in New York, then Analytic Services creates a data block and an index entry for the sparse member combination of Caffeine Free Cola (100-30)-&gt;New York. If Caffeine Free Cola is not sold in Florida, then Analytic Services does not create a data block or an index entry for the sparse member combination of Caffeine Free Cola (100-30)-&gt;Florida. The data block Caffeine Free Cola (100-30)-&gt;New York represents all the Year, Measures, and Scenario dimensions for Caffeine Free Cola (100-30)-&gt;New York. Each unique data value can be considered to exist in a cell in a data block. When Analytic Services searches for a data value, it uses the index to locate the appropriate data block as shown in Figure25 . Then, within the data block, it locates the cell containing the data value. The index entry provides a pointer to the data block. The index handles sparse data efficiently because it includes only pointers to existing data blocks. Figure 25: Simplified Index and Data Blocks Figure26 shows part of a data block for the Sample Basic database. Each dimension of the block represents a dense dimension in the Sample Basic database: Time, Measures, and Scenario. A data block exists for each unique combination of members of the Product and Market sparse dimensions (providing that at least one data value exists for the combination). Figure 26: Part of a Data Block for the Sample Basic Database Each data block is a multidimensional array that contains a fixed, ordered location for each possible combination of dense dimension members. Accessing a cell in the block does not involve sequential or index searches. The search is almost instantaneous, resulting in optimal retrieval and calculation speed. Analytic Services orders the cells in a data block according to the order of the members in the dense dimensions of the database outline. A (Dense) a1 a2 B (Dense) b1 b11 b12 b2 b21 b22 C (Dense) c1 c2 c3 D (Sparse) d1 d2 d21 d22 E (Sparse) e1 e2 e3 The block in Figure27 represents the three dense dimensions from within the combination of the sparse members d22 and e3 in the preceding database outline. In Analytic Services, member combinations are denoted by the cross-dimensional operator. The symbol for the cross-dimensional operator is -&gt;. So d22, e3 is written d22-&gt;e3. A, b21, c3 is written A-&gt;b21-&gt;c3. Figure 27: Data Block Representing Dense Dimensions for d22-&gt;e3 Analytic Services creates a data block for every unique combination of the members of the sparse dimensions D and E (providing that at least one data value exists for the combination). Data blocks, such as the one shown in Figure27 , may include cells that do not contain data values. A data block is created if at least one data value exists in the block. Analytic Services compresses data blocks with missing values on disk, expanding each block fully as it brings the block into memory. Data compression is optional, but is enabled by default. For more information, see Data Compression . By carefully selecting dense and sparse standard dimensions, you can ensure that data blocks do not contain many empty cells. In Analytic Services, empty cells are known as missing or #MISSING data. You can also minimize disk storage requirements and maximize performance. Selection of Sparse and Dense Dimensions In most data sets, existing data tends to follow predictable patterns of density and sparsity. If you match patterns correctly, you can store the existing data in a reasonable number of fairly dense data blocks, rather than in many highly sparse data blocks. When you add a dimension to an outline in Outline Editor, Analytic Services automatically sets the dimension as sparse. To help you determine whether dimensions should be dense or sparse, Analytic Services provides an automatic configuration feature. To select automatic configuration of dense and sparse dimensions use the following method: Tool Topic Location Administration Services Outline Editor - Properties Tab, Auto configure option Setting Dimensions as Dense or Sparse Essbase Administration Services Online Help If you select automatic configuration, you cannot manually set the sparse or dense property for each dimension. Turn off automatic configuration to set the sparse and dense property manually. Attribute dimensions are always sparse dimensions. Keep in mind that you can associate attribute dimensions only with sparse standard dimensions. Note: The automatic configuration of dense and sparse dimensions provides only an estimate. It cannot take into account the nature of the data you will load into your database or multiple user considerations. Determining the Sparse-Dense Configuration for Sample Basic Consider the Sample Basic database that is shipped with Analytic Services. The Sample Basic database represents data for The Beverage Company (TBC). TBC does not sell every product in every market; therefore, the data set is reasonably sparse. Data values do not exist for many combinations of members in the Product and Market dimensions. For example, if Caffeine Free Cola is not sold in Florida, then data values do not exist for the combination Caffeine Free Cola (100-30)-&gt;Florida. So, Product and Market are sparse dimensions. Therefore, if no data values exist for a specific combination of members in these dimensions, Analytic Services does not create a data block for the combination. However, consider combinations of members in the Year, Measures, and Scenario dimensions. Data values almost always exist for some member combinations on these dimensions. For example, data values exist for the member combination Sales-&gt;January-&gt;Actual because at least some products are sold in January. Thus, Year and, similarly, Measures and Scenario are dense dimensions. The sparse-dense configuration of the standard dimensions in the Sample Basic database may be summarized as follows: The sparse standard dimension are Product and Market. The dense standard dimensions are Year, Measures, and Scenario. Analytic Services creates a data block for each unique combination of members in the Product and Market dimensions. Each data block represents data from the dense dimensions. The data blocks are likely to have few empty cells. For example, consider the sparse member combination Caffeine Free Cola (100-30), New York, illustrated by Figure28 : If accounts data (represented by the Measures dimension) exists for this combination for January, it probably exists for February and for all members in the Year dimension. If a data value exists for one member on the Measures dimension, then it is likely that other accounts data values exist for other members in the Measures dimension. If Actual accounts data values exist, then it is likely that Budget accounts data values exist. Figure 28: Dense Data Block for Sample Basic Database Dense and Sparse Selection Scenarios The following scenarios show how a database is affected when you select different dense and sparse standard dimensions. Assume that these scenarios are based on typical databases with at least seven dimensions and several hundred members: Scenario 1: All Sparse Standard Dimensions Scenario 2: All Dense Standard Dimensions Scenario 3: Dense and Sparse Standard Dimensions Scenario 4: A Typical Multidimensional Problem Scenario 1: All Sparse Standard Dimensions If you make all dimensions sparse, Analytic Services creates data blocks that consist of single data cells that contain single data values. An index entry is created for each data block and, therefore, in this scenario, for each existing data value. This configuration produces a huge index that requires a large amount of memory. The more index entries, the longer Analytic Services searches to find a specific block. Figure 29: Database with All Sparse Standard Dimensions Scenario 2: All Dense Standard Dimensions If you make all dimensions dense, as shown in Figure30 , Analytic Services creates one index entry and one very large, very sparse block. In most applications, this configuration requires thousands of times more storage than other configurations. Analytic Services needs to load the entire block into memory when it searches for a data value, which requires enormous amounts of memory. Figure 30: Database with All Dense Standard Dimensions Scenario 3: Dense and Sparse Standard Dimensions Based upon your knowledge of your company's data, you have identified all your sparse and dense standard dimensions. Ideally, you have approximately equal numbers of sparse and dense standard dimensions. If not, you are probably working with a non-typical data set and you need to do more tuning to define the dimensions. Analytic Services creates dense blocks that can fit into memory easily and creates a relatively small index as shown in Figure31 . Your database runs efficiently using minimal resources. Figure 31: An Ideal Configuration with Combination of Dense and Sparse Dimensions Scenario 4: A Typical Multidimensional Problem Consider a database with four standard dimensions: Time, Accounts, Region, and Product. In the following example, Time and Accounts are dense dimensions, and Region and Product are sparse dimensions. The two-dimensional data blocks shown in Figure32 represent data values from the dense dimensions: Time and Accounts. The members in the Time dimension are J, F, M, and Q1. The members in the Accounts dimension are Rev, Exp, and Net. Figure 32: Two-dimensional Data Block for Time and Accounts Analytic Services creates data blocks for combinations of members in the sparse standard dimensions (providing at least one data value exists for the member combination). The sparse dimensions are Region and Product. The members of the Region dimension are East, West, South, and Total US. The members in the Product dimension are Product A, Product B, Product C, and Total Product. Figure33 shows 11 data blocks. No data values exist for Product A in the West and South, for Product B in the East and West, and for Product C in the East. Therefore, Analytic Services has not created data blocks for these member combinations. The data blocks that Analytic Services has created have very few empty cells. Figure 33: Data Blocks Created for Sparse Members on Region and Product This example effectively concentrates all the sparseness into the index and concentrates all the data into fully utilized blocks. This configuration provides efficient data storage and retrieval. Now consider a reversal of the dense and sparse dimension selections. In the following example, Region and Product are dense dimensions, and Time and Accounts are sparse dimensions. As shown in Figure34 , the two-dimensional data blocks represent data values from the dense dimensions: Region and Product. Figure 34: Two-Dimensional Data Block for Region and Product Analytic Services creates data blocks for combinations of members in the sparse standard dimensions (providing at least one data value exists for the member combination). The sparse standard dimensions are Time and Accounts. Figure35 shows 12 data blocks. Data values exist for all combinations of members in the Time and Accounts dimensions; therefore, Analytic Services creates data blocks for all the member combinations. Because data values do not exist for all products in all regions, the data blocks have many empty cells. Data blocks with many empty cells store data inefficiently. Figure 35: Data Blocks Created for Sparse Members on Time and Accounts The Analytic Services Solution When you create an optimized Analytic Services database, you need to consider carefully the following questions: How does your company use the data? How do you plan to build and order the dimensions? Which data compression scheme will you use? How do you want to create and order calculations? For more information on: Planning the development of your multidimensional database, see Case Study: Designing aSingle-Server, Multidimensional Database. Selecting dense and sparse dimensions, see Sparse and Dense Dimensions . Loading data, see Understanding Data Loading and Dimension Building. Compressing data and optimizing your database, see Data Compression . Calculating your database, see Calculating Analytic Services Databases.  |../dinarch.htm",
    "Understanding Multidimensional Databases||Essbase Analytic Services contains multidimensional databases that support analysis and management reporting applications. This chapter discusses multidimensional concepts and terminology. Note: The information in this chapter is designed for block storage databases. Some of the information is not relevant to aggregate storage databases. For detailed information on the differences between aggregate and block storage, see Comparison of Aggregate and Block Storage. This chapter contains the following topics: OLAP and Multidimensional Databases Dimensions and Members Data Storage OLAP and Multidimensional Databases Online analytical processing (OLAP) is a multidimensional, multi-user, client-server computing environment for users who need to analyze enterprise data. OLAP applications span a variety of organizational functions. Finance departments use OLAP for applications such as budgeting, activity-based costing (allocations), financial performance analysis, and financial modeling. Sales departments use OLAP for sales analysis and forecasting. Among other applications, marketing departments use OLAP for market research analysis, sales forecasting, promotions analysis, customer analysis, and market/customer segmentation. Typical manufacturing OLAP applications include production planning and defect analysis. Important to all of the applications mentioned in the previous paragraph is the ability to provide managers with the information they need to make effective decisions about an organization's strategic directions. A successful OLAP application provides information as needed, that is, it provides just-in-time information for effective decision-making. Providing just-in-time information requires more than a base level of detailed data. Just-in-time information is computed data that usually reflects complex relationships and is often calculated on the fly. Analyzing and modeling complex relationships are practical only if response times are consistently short. In addition, because the nature of data relationships may not be known in advance, the data model must be flexible. A truly flexible data model ensures that OLAP systems can respond to changing business requirements as needed for effective decision making. Although OLAP applications are found in widely divergent functional areas, they all require the following key features: Multidimensional views of data Calculation-intensive capabilities Time intelligence Key to OLAP systems are multidimensional databases. Multidimensional databases not only consolidate and calculate data; they also provide retrieval and calculation of a variety of data subsets. A multidimensional database supports multiple views of data sets for users who need to analyze the relationships between data categories. For example, a marketing analyst might want answers to the following questions: How did Product A sell last month? How does this figure compare to sales in the same month over the last five years? How did the product sell by branch, region, and territory? Did this product sell better in particular regions? Are there regional trends? Did customers return Product A last year? Were the returns due to product defects? Did the company manufacture the products in a specific plant? Did commissions and pricing affect how salespeople sold the product? Did particular salespeople do a better job of selling the product? With a multidimensional database, the number of data views is limited only by the database outline, the structure that defines all elements of the database. Users can pivot the data to see information from a different viewpoint, drill down to find more detailed information, or drill up to see an overview. Dimensions and Members This section introduces the concepts of outlines, dimensions and members within a multidimensional database. If you understand dimensions and members, you are well on your way to understanding the power of a multidimensional database. A dimension represents the highest consolidation level in the database outline. The database outline presents dimensions and members in a tree structure to indicate a consolidation relationship. For example, in Figure2 , Time is a dimension and Qtr1 is a member. Analytic Services has two types of dimensions: standard dimensions and attribute dimensions . Standard dimensions represent the core components of a business plan and often relate to departmental functions. Typical standard dimensions are Time, Accounts, Product Line, Market, and Division. Dimensions change less frequently than members. Attribute dimensions are a special type of dimension that are associated with standard dimensions. Through attribute dimensions, you group and analyze members of standard dimensions based on the member attributes (characteristics). For example, you can compare the profitability of non-caffeinated products that are packaged in glass to the profitability of non-caffeinated products that are packaged in cans. Members are the individual components of a dimension. For example, Product A, Product B, and Product C might be members of the Product dimension. Each member has a unique name. A dimension can contain an unlimited number of members. Analytic Services can store the data associated with a member (referred to as a stored member in this chapter) or it can dynamically calculate the data when a user retrieves it. Outline Hierarchies All Analytic Services database development begins with creating a database outline. A database outline accomplishes the following: Defines the structural relationships between members in an Analytic Services database Organizes all the data in the database Defines the consolidations and mathematical relationships between items Analytic Services uses the concept of members to represent data hierarchies. Each dimension consists of one or more members. The members, in turn, may consist of other members. When you create a dimension, you tell Analytic Services how to consolidate the values of its individual members. Within the tree structure of the database outline, a consolidation is a group of members in a branch of the tree. For example, many businesses summarize their data monthly, roll up the monthly data to obtain quarterly figures, and roll up the quarterly data to obtain annual figures. Businesses may also summarize data by zip code, by city, state, and country. Any dimension can be used to consolidate data for reporting purposes. In the Sample Basic database included with Analytic Server, for example, the Year dimension consists of five members: Qtr1, Qtr2, Qtr3, and Qtr4, each storing data for an individual quarter, plus Year, storing summary data for the entire year. Qtr1 consists of four members: Jan, Feb, and Mar, each storing data for an individual month, plus Qtr1, storing summary data for the entire quarter. Likewise, Qtr2, Qtr3, and Qtr4 consist of the members that represent the individual months plus the member that stores the quarterly totals. The database outline in Figure2 uses a hierarchical structure to represent the data consolidations and relationships in Qtr1. Figure 2: Hierarchical Structure Some dimensions consist of relatively few members, while others may have hundreds or even thousands of members. Analytic Services does not limit the number of members within a dimension and enables the addition of new members as needed. Dimension and Member Relationships Analytic Services uses the terms defined in the following sections to describe a database outline. These terms are used throughout Analytic Services documentation. Analytic Services uses hierarchical and family history terms to describe the roles and relationships of the members in an outline. You can describe the position of the members of the branches in Figure3 in several ways. Figure 3: Member Generation and Level Numbers Parents, Children, and Siblings Figure3 illustrates the following parent, child, and sibling relationships: A parent is a member that has a branch below it. For example, Margin is a parent member for Sales and Cost of Goods Sold. A child is a member that has a parent above it. For example, Sales and Cost of Goods Sold are children of the parent Margin. Siblings are child members of the same immediate parent, at the same generation. For example, Sales and Cost of Goods Sold are siblings (they both have the parent Margin), but Marketing (at the same branch level) is not a sibling because its parent is Total Expenses. Descendants and Ancestors Figure3 illustrates the following descendant and ancestral relationships: Descendants are all members in branches below a parent. For example, Profit, Inventory, and Ratios are descendants of Measures. The children of Profit, Inventory, and Ratios are also descendants of Measures. Ancestors are all members in branches above a member. For example, Margin, Profit, and Measures are ancestors of Sales. Roots and Leaves Figure3 illustrates the following root and leaf member relationships: The root is the top member in a branch. Measures is the root for Profit, Inventory, Ratios, and the children of Profit, Inventory, and Ratios. Leaf members have no children. They are also referred to as detail members, level 0 members, and leaf nodes. For example, Opening Inventory, Additions, and Ending Inventory are leaf members. Generations and Levels Figure3 illustrates the following generations levels: Generation refers to a consolidation level within a dimension. A root branch of the tree is generation 1. Generation numbers increase as you count from the root toward the leaf member. In Figure3 , Measures is generation 1, Profit is generation 2, and Margin is generation 3. All siblings of each level belong to the same generation; for example, both Inventory and Ratios are generation 2. Figure4 shows part of the Product dimension with its generations numbered. Figure 4: Generations Level also refers to a branch within a dimension; however, levels reverse the numerical ordering that Analytic Services uses for generations. The levels count up from the leaf member toward the root. The root level number varies depending on the depth of the branch. In the example in Figure3 , Sales and Cost of Goods Sold are level 0. All other leaf members are also level 0. Margin is level 1, and Profit is level 2. Notice that the level number of Measures varies depending on the branch. For the Ratios branch, Measures is level 2. For the Total Expenses branch, Measures is level 3. Figure5 shows part of the Product dimension with its levels numbered. Figure 5: Levels Generation and Level Names To make your reports easier to maintain, you can assign a name to a generation or level and then use the name as a shorthand for all members in that generation or level. Because changes to an outline are automatically reflected in a report, when you use generation and level names, you do not need to change the report if a member name is changed or deleted from the database outline. Standard Dimensions and Attribute Dimensions Analytic Services has two types of dimensions: standard dimensions and attribute dimensions. This chapter primarily considers standard dimensions because Analytic Services does not allocate storage for attribute dimension members. Instead it dynamically calculates the members when the user requests data associated with them. An attribute dimension is a special type of dimension that is associated with a standard dimension. For comprehensive discussion of attribute dimensions, see Working with Attributes. Sparse and Dense Dimensions Most data sets of multidimensional applications have two characteristics: Data is not smoothly and uniformly distributed. Data does not exist for the majority of member combinations. For example, all products may not be sold in all areas of the country. Analytic Services maximizes performance by dividing the standard dimensions of an application into two types: dense dimensions and sparse dimensions . This division allows Analytic Services to cope with data that is not smoothly distributed. Analytic Services speeds up data retrieval while minimizing the memory and disk requirements. Most multidimensional databases are inherently sparse: they lack data values for the majority of member combinations. A sparse dimension is a dimension with a low percentage of available data positions filled. For example, the Sample Basic database shown in Figure6 includes the Year, Product, Market, Measures, and Scenario dimensions. Product represents the product units, Market represents the geographical regions in which the products are sold, and Measures represents the accounts data. Because not every product is sold in every market, Market and Product are chosen as sparse dimensions. Most multidimensional databases also contain dense dimensions. A dense dimension is a dimension with a high probability that one or more data points is occupied in every combination of dimensions. For example, in the Sample Basic database, accounts data exists for almost all products in all markets, so Measures is chosen as a dense dimension. Year and Scenario are also chosen as dense dimensions. Year represents time in months, and Scenario represents whether the accounts values are budget or actual values. In Sample Basic Database Outline , Caffeinated, Intro Date, Ounces, and Pkg Type are attribute dimensions that are associated with the Product dimension. Population is an attribute dimension that is associated with the Market dimension. Members of attribute dimensions describe characteristics of the members of the dimensions with which they are associated. For example, each product has a size in ounces. Attribute dimensions are always sparse dimensions and must be associated with a sparse standard dimension. Analytic Services does not store the data for attribute dimensions, Analytic Services dynamically calculates the data when a user retrieves it. For a comprehensive discussion about attribute dimensions, see Working with Attributes. Figure 6: Sample Basic Database Outline Selection of Dense and Sparse Dimensions In most data sets, existing data tends to follow predictable patterns of density and sparsity. If you match patterns correctly, you can store the existing data in a reasonable number of fairly dense data blocks, rather than in many highly sparse data blocks. Analytic Services can make recommendations for the sparse-dense configuration of dimensions based on the following factors: The time and accounts tags on dimensions The probable size of the data blocks Characteristics that you attribute to the dimensions in this dialog box You can apply a recommended configuration or you can turn off automatic configuration and manually set the sparse or dense property for each dimension. Attribute dimensions are always sparse dimensions. Keep in mind that you can associate attribute dimensions only with sparse standard dimensions. Note: The automatic configuration of dense and sparse dimensions provides only an estimate. It cannot take into account the nature of the data you will load into your database or multiple user considerations. Dense-Sparse Configuration for Sample Basic Consider the Sample Basic database that is provided with Analytic Services. The Sample Basic database represents data for The Beverage Company (TBC). TBC does not sell every product in every market; therefore, the data set is reasonably sparse. Data values do not exist for many combinations of members in the Product and Market dimensions. For example, if Caffeine Free Cola is not sold in Florida, then data values do not exist for the combination Caffeine Free Cola (100-30)-&gt;Florida. However, consider combinations of members in the Year, Measures, and Scenario dimensions. Data values almost always exist for some member combinations on these dimensions. For example, data values exist for the member combination Sales-&gt;January-&gt;Actual because at least some products are sold in January. The sparse-dense configuration of the standard dimensions in the Sample Basic database may be summarized as follows: The sparse standard dimension are Product and Market. The dense standard dimensions are Year, Measures, and Scenario. Analytic Services creates a data block for each unique combination of members in the Product and Market dimensions (for more information on data blocks, see Data Storage ). Each data block represents data from the dense dimensions. The data blocks are likely to have few empty cells. For example, consider the sparse member combination Caffeine Free Cola (100-30), New York, illustrated by Figure7 : If accounts data (represented by the Measures dimension) exists for this combination for January, it probably exists for February and for all members in the Year dimension. If a data value exists for one member on the Measures dimension, then it is likely that other accounts data values exist for other members in the Measures dimension. If Actual accounts data values exist, then it is likely that Budget accounts data values exist. Figure 7: Dense Data Block for Sample Basic Database Dense and Sparse Selection Scenario Consider a database with four standard dimensions: Time, Accounts, Region, and Product. In the following example, Time and Accounts are dense dimensions, and Region and Product are sparse dimensions. The two-dimensional data blocks shown in Figure8 represent data values from the dense dimensions: Time and Accounts. The members in the Time dimension are J, F, M, and Q1. The members in the Accounts dimension are Rev, Exp, and Net. Figure 8: Two-dimensional Data Block for Time and Accounts Analytic Services creates data blocks for combinations of members in the sparse standard dimensions (providing at least one data value exists for the member combination). The sparse dimensions are Region and Product. The members of the Region dimension are East, West, South, and Total US. The members in the Product dimension are Product A, Product B, Product C, and Total Product. Figure9 shows 11 data blocks. No data values exist for Product A in the West and South, for Product B in the East and West, and for Product C in the East. Therefore, Analytic Services has not created data blocks for these member combinations. The data blocks that Analytic Services has created have very few empty cells. Figure 9: Data Blocks Created for Sparse Members on Region and Product This example effectively concentrates all the sparseness into the index and concentrates all the data into fully utilized blocks. This configuration provides efficient data storage and retrieval. Now consider a reversal of the dense and sparse dimension selections. In the following example, Region and Product are dense dimensions, and Time and Accounts are sparse dimensions. As shown in Figure10 , the two-dimensional data blocks represent data values from the dense dimensions: Region and Product. Figure 10: Two-Dimensional Data Block for Region and Product Analytic Services creates data blocks for combinations of members in the sparse standard dimensions (providing at least one data value exists for the member combination). The sparse standard dimensions are Time and Accounts. Figure11 shows 12 data blocks. Data values exist for all combinations of members in the Time and Accounts dimensions; therefore, Analytic Services creates data blocks for all the member combinations. Because data values do not exist for all products in all regions, the data blocks have many empty cells. Data blocks with many empty cells store data inefficiently. Figure 11: Data Blocks Created for Sparse Members on Time and Accounts Data Storage This topic describes how data is stored in a multidimensional database. Each data value is stored in a single cell in the database. You refer to a particular data value by specifying its coordinates along each standard dimension. Note: Analytic Services does not store data for attribute dimensions. Analytic Services dynamically calculates attribute dimension data when a user retrieves the data. Consider the simplified database shown in Figure12 . Figure 12: A Multidimensional Database Outline This database has three dimensions: Accounts, Time, and Scenario: The Accounts dimension has four members: Sales, COGS, Margin, and Margin%. The Time dimension has four quarter members, and Qtr1 has three month members Note: Figure13 shows only Qtr1 and its members. The Scenario dimension has two child members: Budget for budget values and Actual for actual values. Data Values The intersection of one member from one dimension with one member from each of the other dimensions represents a data value. The example in Figure13 has three dimensions; thus, the dimensions and data values in the database can be represented in a cube. Figure 13: Three-Dimensional Database The shaded cells in Figure14 illustrate that when you specify Sales, you are specifying the portion of the database containing eight Sales values. Figure 14: Sales Slice of the Database Slicing a database amounts to fixing one or more dimensions at a constant value while allowing the other dimensions to vary. When you specify Actual Sales, you are specifying the four Sales values where Actual and Sales intersect as shown by the shaded area in Figure15 . Figure 15: Actual, Sales Slice of the Database A data value is stored in a single cell in the database. To refer to a specific data value in a multidimensional database, you specify its member on each dimension. In Figure16 , the cell containing the data value for Sales, Jan, Actual is shaded. The data value can also be expressed using the cross-dimensional operator (-&gt;) as Sales-&gt;Actual-&gt;Jan. Figure 16: Sales-&gt; Jan-&gt; Actual Slice of the Database Data Blocks and the Index System Analytic Services uses two types of internal structures to store and access data: data blocks and the index system. Analytic Services creates a data block for each unique combination of sparse standard dimension members (providing that at least one data value exists for the sparse dimension member combination). The data block represents all the dense dimension members for its combination of sparse dimension members. Analytic Services creates an index entry for each data block. The index represents the combinations of sparse standard dimension members. It contains an entry for each unique combination of sparse standard dimension members for which at least one data value exists. For example, in the Sample Basic database outline shown in Figure17 , Product and Market are sparse dimensions. Figure 17: Product and Market Dimensions from the Sample Basic Database If data exists for Caffeine Free Cola in New York, then Analytic Services creates a data block and an index entry for the sparse member combination of Caffeine Free Cola (100-30)-&gt;New York. If Caffeine Free Cola is not sold in Florida, then Analytic Services does not create a data block or an index entry for the sparse member combination of Caffeine Free Cola (100-30)-&gt;Florida. The data block Caffeine Free Cola (100-30)-&gt;New York represents all the Year, Measures, and Scenario dimensions for Caffeine Free Cola (100-30)-&gt;New York. Each unique data value can be considered to exist in a cell in a data block. When Analytic Services searches for a data value, it uses the index to locate the appropriate data block.Then, within the data block, it locates the cell containing the data value. The index entry provides a pointer to the data block. The index handles sparse data efficiently because it includes only pointers to existing data blocks. Figure18 shows part of a data block for the Sample Basic database. Each dimension of the block represents a dense dimension in the Sample Basic database: Time, Measures, and Scenario. A data block exists for each unique combination of members of the Product and Market sparse dimensions (providing that at least one data value exists for the combination). Figure 18: Part of a Data Block for the Sample Basic Database Each data block is a multidimensional array that contains a fixed, ordered location for each possible combination of dense dimension members. Accessing a cell in the block does not involve sequential or index searches. The search is almost instantaneous, resulting in optimal retrieval and calculation speed. Analytic Services orders the cells in a data block according to the order of the members in the dense dimensions of the database outline. A (Dense) a1 a2 B (Dense) b1 b11 b12 b2 b21 b22 C (Dense) c1 c2 c3 D (Sparse) d1 d2 d21 d22 E (Sparse) e1 e2 e3 The block in Figure19 represents the three dense dimensions from within the combination of the sparse members d22 and e3 in the preceding database outline. In Analytic Services, member combinations are denoted by the cross-dimensional operator. The symbol for the cross-dimensional operator is -&gt;. So d22, e3 is written d22-&gt;e3. A, b21, c3 is written A-&gt;b21-&gt;c3. Figure 19: Data Block Representing Dense Dimensions for d22-&gt;e3 Analytic Services creates a data block for every unique combination of the members of the sparse dimensions D and E (providing that at least one data value exists for the combination). Data blocks, such as the one shown in Figure19 , may include cells that do not contain data values. A data block is created if at least one data value exists in the block. Analytic Services compresses data blocks with missing values on disk, expanding each block fully as it brings the block into memory. Data compression is optional, but is enabled by default. For more information, see Data Compression . By carefully selecting dense and sparse standard dimensions, you can ensure that data blocks do not contain many empty cells, minimizing disk storage requirements and improving performance. Multiple Data Views A multidimensional database supports multiple views of data sets for users who need to analyze the relationships between data categories. Slicing the database in different ways gives you different perspectives of the data. The slice of January in Figure20 , for example, examines all data values for which the Year dimension is fixed at Jan. Figure 20: Data for January The slice in Figure21 shows data for the month of February: Figure 21: Data for February The slice in Figure22 shows data for profit margin: Figure 22: Data for Profit Margin  |../dinconc.htm",
    "Case Study: Designing aSingle-Server, Multidimensional Database||To implement a multidimensional database, first you install Essbase Analytic Services, and then you design and create an application and databases. You analyze data sources and define requirements very carefully and then decide whether a single-server approach or a partitioned, distributed approach best serves your needs. For criteria that you can review to decide whether to partition an application, see Deciding Whether to Partition a Database . Using a case study, this chapter provides an overview of the database planning process and discusses working rules that you can follow to design a single-server, multidimensional database solution for your organization. For detailed information about building applications and databases, see Creating Applications and Databases. Note: The information in this chapter is designed for block storage databases. Some of the information is not relevant to aggregate storage databases. For detailed information on the differences between aggregate and block storage, see Comparison of Aggregate and Block Storage. This chapter includes the following topics: Process for Designing a Database Case Study: The Beverage Company Analyzing and Planning Drafting Outlines Checking System Requirements Loading Test Data Defining Calculations Defining Reports Verifying the Design Process for Designing a Database As illustrated in Figure36 , designing an application is a cyclic process that moves from a planning stage to a verification stage. Figure 36: The Database Design Cycle The database design process includes the following basic steps: Analyze business needs and design a plan. The application and database that you create must satisfy the information needs of your users and your organization. Therefore, you identify source data, define user information access needs, review security considerations, and design a database model. See Analyzing and Planning . Draft a database outline. The outline determines the structure of the database-what information is stored and how different pieces of information relate to one another. See Drafting Outlines . Check system requirements. How you meet system requirements and define system parameters affects the efficiency and performance of the database. See Checking System Requirements . Load test data into the database. After an outline and a security plan are in place, you load the database with test data to enable the later steps of the process. See Loading Test Data . Define calculations. You test outline consolidations and write and test formulas and calculation scripts for specialized calculations. See Defining Calculations . Define reports. Users access data through print and online reports and spreadsheets or on the World Wide Web. If you plan to provide predefined reports to users, you design report layouts and run reports. See Defining Reports . Verify with users. You want to ensure that the database satisfies your user goals. You must solicit and carefully consider the opinions of users. See Verifying the Design . Repeat the process. To fine-tune the design, you repeat steps 1 through 7. Case Study: The Beverage Company This chapter bases the database planning process on the needs of a fictitious company called The Beverage Company (TBC) and uses TBC as an example to demonstrate how to build an Analytic Services database. The examples follow a variation of the Sample Basic application that is included with the Analytic Services installation. TBC manufactures, markets, and distributes soft drink products internationally. Analysts at TBC prepare budget forecasts and compare performance to budget forecasts on a monthly basis. The financial measures that analysts track are profit and loss and inventory. TBC uses spreadsheet packages to prepare budget data and perform variance reporting. Because TBC plans and tracks a variety of products over several markets, the process of deriving and analyzing data is tedious. Last month, analysts spent most of their time entering and rekeying data and preparing reports. TBC has determined that Analytic Services is the best tool for creating a centralized repository for financial data. The data repository will reside on a server that is accessible to analysts throughout the organization. Users will have access to the server and will be able to load data from various sources and retrieve data as needed. TBC has a variety of users, so TBC expects that different users will have different security levels for accessing data. Analyzing and Planning The design and operation of an Analytic Services multidimensional database plays a key role in achieving a well-tuned system that enables you to analyze business information efficiently. Given the size and performance volatility of multidimensional databases, developing an optimized database is critical. A detailed plan that outlines data sources, user needs, and prospective database elements can save you development and implementation time. The planning and analysis phase involves three tasks: Analyzing Source Data Identifying User Requirements Planning for Security in a Multiple User Environment Creating Database Models When designing a multidimensional application, consider these factors: How information flows within the company-who uses what data for what purposes The types of reporting the company does-what types of data must be included in the outline to serve user reporting needs Note: The best practices recommendation is to define only one database per application. There are several reasons for this recommendation, including enhanced memory usage and ease of database administration. Applications that use the optional Analytic Services currency conversion module are an exception to this recommendation. Currency conversion applications generally consist of a main database and a separate currency database (see Designing and Building Currency Conversion Applications ). Analyzing Source Data First, you need to evaluate the source data that you want to include in the database. Think about where the data resides and how often you plan to update the database with the data. This up-front research saves time when you create the database outline and load data into the Analytic Services database. Determine the scope of the database. If an organization has thousands of product families containing hundreds of thousands of products, you may want to store data values only for product families. Interview members from each user department to find out what data they process, how they process data today, and how they want to process data in the future. Carefully define reporting and analysis needs. How do users want to view and analyze data? How much detail should the database contain? Does the data support the desired analysis and reporting goals? If not, what additional data do you need and where can you find the needed data? Determine the location of the current data. Where does each department currently store data? Is data in a form that Analytic Services can use? Do departments store data in a DB2 database on an IBM mainframe, in a relational database on a UNIX-based server, or in a PC-based database or spreadsheet? Who updates the database and how frequently? Do the individuals who need to update data have access to the data? Make sure that the data is ready to load into Analytic Services. Does data come from a single source or from multiple sources? Is data in a format that Analytic Services can import? For a list of valid data sources that you can import into Analytic Services, see Data Sources . Is all data that you want to use readily available? Identifying User Requirements Be sure to discuss information needs with users. Review the information they use and the reports they must generate for review by others. Determine the following requirements. What types of analysis do users require? What summary and detail levels of information do users need? Do some users require access to information that other users should not see? Planning for Security in a Multiple User Environment The time to think about the type of security permissions you plan to issue for an Analytic Services database is when you consider user information needs. End your analysis with a list of users and permissions. Use this checklist to plan for security: Who are the users and what permissions should they have? Who should have load data permissions? Which users can be grouped, and as a group, given similar permissions? See Managing Security for Users and Applications for information about assigning user permissions. Creating Database Models You are now ready to create a model of the database on paper. To build the model, identify the perspectives and views that are important to your business. These views translate into the dimensions of the database model. Most businesses choose to analyze the following areas: Time periods Accounting measures Scenarios Products Distribution channels Geographical regions Business units Use the following topics to help you gather information and make decisions: Identifying Analysis Objectives Determining Dimensions and Members Analyzing Database Design Identifying Analysis Objectives After you identify the major areas of information in a business, the next step in designing an Analytic Services database is deciding how the database enables data analysis: If analyzing by time, which time periods are needed? Does the analysis need to include only the current year or multiple years? Does the analysis need to include quarterly and monthly data? Does the analysis need to include data by season? If analyzing by geographical region, how do you define the regions? Do you define regions by sales territories? Do you define regions by geographical boundaries such as states and cities? If analyzing by product line, do you need to review data for each specific product? Can you summarize data into product classes? Regardless of the business area, you need to determine the perspective and detail needed in the analysis. Each business area that you analyze provides a different view of the data. Determining Dimensions and Members You can represent each of the business views as a separate standard dimension in the database. If you need to analyze a business area by classification or attribute, such as by the size or color of products, you can use attribute dimensions to represent the classification views. The dimensions that you choose determine what types of analysis you can perform on the data. With Analytic Services, you can use as many dimensions as you need for analysis. A typical Analytic Services database contains at least seven standard dimensions (non-attribute dimensions) and many more attribute dimensions. When you have an idea of what dimensions and members you need, review the following topics and develop a tentative database design: Relationships Among Dimensions Example Dimension-Member Structure Checklist for Determining Dimensions and Members After you determine the dimensions of the database model, choose the elements or items within the perspective of each dimension. These elements become the members of their respective dimensions. For example, a perspective of time may include the time periods that you want to analyze, such as quarters, and within quarters, months. Each quarter and month becomes a member of the dimension that you create for time. Quarters and months represent a two-level hierarchy of members and their children. Months within a quarter consolidate to a total for each quarter. Relationships Among Dimensions Next, consider the relationships among the business areas. The structure of an Analytic Services database makes it easy for users to analyze information from many different perspectives. A financial analyst, for example, may ask the following questions: What are sales for a particular month? How does this figure compare to sales in the same month over the last five years? By what percentage is profit margin increasing? How close are actual values to budgeted values? In other words, the analyst may want to examine information from three different perspectives-time, account, and scenario. The sample database shown in Figure37 represents these three perspectives as three dimensions, with one dimension represented along each of the three axes: A time dimension, which consists of the individual months Jan, Feb, and Mar and the total for Qtr1, is displayed along the X-axis. An accounts dimension, which consists of accounting figures such as Sales, COGS, Margin, and Margin%, is displayed along the Y-axis. Another dimension which provides a different point of view, such as Budget for budget values and Actual for actual values, is displayed along the Z-axis. Figure 37: Cube Representing Three Database Dimensions The cells within the cube, where the members intersect, contain the data relevant to all three intersecting members; for example, the actual sales in January. Example Dimension-Member Structure Table2 shows a summary of the TBC business areas that the planner determined would be dimensions. The dimensions represent the major business areas to be analyzed. The planner created three columns, with the dimensions in the left column and members in the two right columns. The members in column 3 are subcategories of the members in column 2. In some cases, members in column 3 are divided into another level of subcategories; for example, the Margin of the Measures dimension is divided into Sales and COGS. Table 2: TBC Sample Dimensions  Dimensions Members Child Members Year Qtr1 Jan, Feb, Mar Qtr2 Apr, May, Jun Qtr3 Jul, Aug, Sep Qtr4 Oct, Nov, Dec Measures Profit Margin: Sales, COGS Total Expenses: Marketing, Payroll, Miscellaneous Inventory Opening Inventory, Additions, Ending Inventory Ratios Margin %, Profit %, Profit per Ounce Product Colas (100) Cola (100-10), Diet Cola (100-20), Caffeine Free Cola (100-30) Root Beer (200) Old Fashioned (200-10), Diet Root Beer (200-20), Sarsaparilla (200-30), Birch Beer (200-40) Cream Soda (300) Dark Cream (300-10), Vanilla Cream (300-20), Diet Cream Soda (300-30) Fruit Soda (400) Grape (400-10), Orange (400-20), Strawberry (400-30) Market East Connecticut, Florida, Massachusetts, New Hampshire, New York West California, Nevada, Oregon, Utah, Washington South Louisiana, New Mexico, Oklahoma, Texas Central Colorado, Illinois, Iowa, Missouri, Ohio, Wisconsin Scenario Actual &#160; Budget &#160; Variance &#160; Variance % &#160; In addition the planner added two attribute dimensions to enable product analysis based on size and packaging: Table 3: TBC Sample Attribute Dimensions Dimensions Members Child Members Ounces Large Small 64, 32, 20 16, 12 Pkg Type Bottle Can &#160; Checklist for Determining Dimensions and Members Use the following checklist when determining the dimensions and members of your model database: What are the candidates for dimensions? Do any of the dimensions classify or describe other dimensions? These dimensions are candidates for attribute dimensions. Do users want to qualify their view of a dimension? The categories by which they qualify a dimension are candidates for attribute dimensions. What are the candidates for members? How many levels does the data require? How does the data consolidate? Analyzing Database Design While the initial dimension design is still on paper, you should review the design according to a set of guidelines. The guidelines help you to fine-tune the database and leverage the multidimensional technology. The guidelines are processes or questions that help you achieve an efficient design and meet consolidation and calculation goals. Keep in mind that the number of members needed to describe a potential data point should determine the number of dimensions. As you analyze the design, if you are not sure that you should delete a dimension, keep it and apply more analysis rules until you feel confident about deleting or keeping it. Use the information in the following topics to analyze and, as needed, to improve your database design: Dense and Sparse Dimensions Standard and Attribute Dimensions Dimension Combinations Repetition in Outlines Interdimensional Irrelevance Reasons to Split Databases Checklist to Analyze the Database Design Dense and Sparse Dimensions You need to decide which dimensions are sparse and which dense. These decisions affect performance. For a basic introduction, see Sparse and Dense Dimensions . For a comprehensive discussion of storage and performance, see Designing an Outline to Optimize Performance . Standard and Attribute Dimensions For simplicity, the examples in this topic show alternative arrangements for what was initially designed as two dimensions. You can apply the same logic to all combinations of dimensions. Consider the design for a company that sells products to multiple customers over multiple markets; the markets are unique to each customer: Cust A Cust B Cust C New York 100 N/A N/A Illinois N/A 150 N/A California N/A N/A 30 Cust A is only in New York, Cust B is only in Illinois, and Cust C is only in California. The company can define the data in one standard dimension: Market New York Cust A Illinois Cust B California Cust C However, if you look at a larger sampling of data, you may see that there can be many customers in each market. Cust A and Cust E are in New York; Cust B, Cust M, and Cust P are in Illinois; Cust C and Cust F are in California. In this situation, the company typically defines the large dimension, Customer, as a standard dimension and the smaller dimension, Market, as an attribute dimension. The company associates the members of the Market dimension as attributes of the members of the Customer dimension. The members of the Market dimension describe locations of the customers. Customer (Standard dimension) Cust A (Attribute:New York) Cust B (Attribute:Illinois) Cust C (Attribute:California) Cust E (Attribute:New York) Cust F (Attribute:California) Cust M (Attribute:Illinois) Cust P (Attribute:Illinois) Market (Attribute dimension) New York Illinois California Consider another situation. Again, the company sells products to multiple customers over multiple markets. This time, the company can ship to a customer that has locations in different markets: Cust A Cust B Cust C New York 100 75 N/A Illinois N/A 150 N/A California 150 N/A 30 Cust A is in New York and California. Cust B is in New York and Illinois. Cust C is only in California. Using an attribute dimension does not work in this situation; a customer member cannot have more than one attribute member. Therefore, the company designs the data in two standard dimensions: Customer Cust A Cust B Cust C Market New York Illinois California Dimension Combinations Break each combination of two dimensions into a two-dimensional matrix. For example, proposed dimensions at TBC (as listed in Table2 ) include the following combinations: Year across Measures Year across Product Year across Market Year across Scenario Measures across Product Measures across Market Measures across Scenario Market across Product Market across Scenario Scenario across Product Ounces across Pkg Type As attribute dimensions associated with the Product dimension, Ounces and Pkg Type can be considered with the Product dimension. To help visualize each dimension, you can draw a matrix and include a few of the first generation members. Figure38 shows a simplified set of matrixes for three dimensions. Figure 38: Analyzing Dimensional Relationships For each combination of dimensions, ask three questions: Does it add analytic value? Does it add utility for reporting? Does it avoid an excess of unused combinations? For each combination, the answers to the questions help determine if the combination is valid for the database. Ideally, the answers to all questions should be yes. If all answers are not yes, you should consider rearranging the data into dimensions that are more meaningful. As you work through this process, be sure to discuss information needs with users. Repetition in Outlines The repetition of elements in an outline often indicates a need to split dimensions. Here is an example of repetition and a solution: Repetition No Repetition Accounts Budget Profit Margin Sales COGS Expenses Actual Profit Margin Sales COGS Expenses Accounts Profit Margin Sales COGS Expenses Scenario Budget Actual Separating Budget and Actual and placing them into another dimension simplifies the outline and provides a simpler view of the budget and actual figures of the other dimensions in the database. The left column of this table uses shared members in the Diet dimension to analyze diet beverages. You can avoid the repetition of the left column and simplify the design of the outline by creating a Diet attribute dimension, as shown in the second example. Repetition No Repetition Product 100 (Alias: Colas) 100-10 (Alias: Cola) 100-20 (Alias: Diet Cola) 200 (Alias: Root Beer) 200-20 (Alias: Diet Root Beer) 200-30 (Alias: Birch Beer) 300 (Alias Cream Soda) 300-10 (Alias: Dark Cream) 300-20 (Alias: Diet Cream) Diet (Alias: Diet Drinks) 100-20 (Alias: Diet Cola) 200-20 (Alias: Diet Root Beer)   300-20 (Alias: Diet Cream) Product (Diet) 100 (Alias: Colas) 100-10 (Alias: Cola) (Diet: False) 100-20 (Alias: Diet Cola) (Diet: True) 200 (Alias: Root Beer) 200-20 (Alias: Diet Root Beer) (Diet: True) 200-30 (Alias: Birch Beer) (Diet: False) 300 (Alias Cream Soda) 300-10 (Alias: Dark Cream) (Diet: False) 300-20 (Alias: Diet Cream) (Diet: True) Diet Attribute (Type: Boolean) True False Attribute dimensions also provide additional analytic capabilities. For a review of the advantages of using attribute dimensions, see Designing Attribute Dimensions . Interdimensional Irrelevance Interdimensional irrelevance occurs when many members of a dimension are irrelevant across other dimensions. Analytic Services defines irrelevant data as data that Analytic Services stores only at the summary (dimension) level. In such a situation, you may be able to remove a dimension from the database and add its members to another dimension or split the model into separate databases. For example, TBC considered analyzing salaries as a member of the Measures dimension. But salary information often proves to be irrelevant in the context of a corporate database. Most salaries are confidential and apply to specific individuals. The individual and the salary typically represent one cell, with no reason to intersect with any other dimension. TBC considered separating employees into a separate dimension. Table4 shows an example of how TBC analyzed the proposed Employee dimension for interdimensional irrelevance. Members of the proposed Employee dimension are compared with members of the Measures dimension. Only the Salary measure is relevant to individual employees. Table 4: Interdimensional Irrelevance Example  Joe Smith Mary Jones Mike Garcia All Employees Revenue &#160; &#160; &#160; x Variable Costs &#160; &#160; &#160; x COGS &#160; &#160; &#160; x Advertising &#160; &#160; &#160; x Salaries x x x x Fixed Costs &#160; &#160; &#160; x Expenses &#160; &#160; &#160; x Profit &#160; &#160; &#160; x Reasons to Split Databases As discussed in the previous topic, Interdimensional Irrelevance , TBC agreed that, in context with other dimensions, individual employees were irrelevant. They also agreed that adding an Employee dimension substantially increased database storage needs. Consequently, they decided to create a separate Human Resources (HR) database. The new HR database contains a group of related dimensions and includes salaries, benefits, insurance, and 401(k) plans. There are many reasons for splitting a database; for example, suppose that a company maintains an organizational database that contains several international subsidiaries located in several time zones. Each subsidiary relies on time-sensitive financial calculations. You may want to split the database for groups of subsidiaries in the same time zone to ensure that financial calculations are timely. You can also use a partitioned application to separate information by subsidiary. Checklist to Analyze the Database Design Use the following checklist to analyze the database design: Have you minimized the number of dimensions? For each dimensional combination, did you ask: Does it add analytic value? Does it add utility for reporting? Does it avoid an excess of unused combinations? Did you avoid repetition in the outline? Did you avoid interdimensional irrelevance? Did you split the databases as necessary? Drafting Outlines At this point, you can create the application and database and build the first draft of the outline in Analytic Services. The draft defines all dimensions, members, and consolidations. Use the outline to design consolidation requirements and identify where you need formulas and calculation scripts. Note: Before you create a database and build its outline, you must create an Analytic Services application to contain it. The TBC planners issued the following draft for a database outline. In this plan, the bold words are the dimensions-Year, Measures, Product, Market, Scenario, Pkg Type, and Ounces. Observe how TBC anticipated consolidations, calculations and formulas, and reporting requirements. The planners also used product codes rather than product names to describe products. Year. TBC needs to collect data monthly and summarize the monthly data by quarter and year. Monthly data, stored in members such as Jan, Feb, and Mar, consolidates to quarters. Quarterly data, stored in members such as Qtr1 and Qtr2, consolidates to Year. Measures. Sales, Cost of Goods Sold, Marketing, Payroll, Miscellaneous, Opening Inventory, Additions, and Ending Inventory are standard measures. Analytic Services can calculate Margin, Total Expenses, Profit, Total Inventory, Profit %, Margin %, and Profit per Ounce from these measures. TBC needs to calculate Measures on a monthly, quarterly, and yearly basis. Product. The Product codes are 100-10, 100-20, 100-30, 200-10, 200-20, 200-30, 200-40, 300-10, 300-20, 300-30, 400-10, 400-20, and 400-30. Each product consolidates to its respective family (100, 200, 300, and 400). Each consolidation allows TBC to analyze by size and package, because each product is associated with members of the Ounces and Pkg Type attribute dimensions. Market. Several states make up a region, and four regions make up a market. The states are Connecticut, Florida, Massachusetts, New Hampshire, New York, California, Nevada, Oregon, Utah, Washington, Louisiana, New Mexico, Oklahoma, Texas, Colorado, Illinois, Iowa, Missouri, Ohio, and Wisconsin. Each state consolidates into its respective region-East, West, South, or Central. Each region consolidates into Market. Scenario. TBC derives and tracks budget data versus actual data. Managers must monitor and track budgets and actuals, as well as the variance and variance percentage between them. Pkg Type. TBC wants to see the effect that product packaging has on sales and profit. Establishing the Pkg Type attribute dimension enables users to analyze product information based on whether a product is packaged in bottles or cans. Ounces. TBC sells products in different sizes in ounces in different market areas. Establishing the Ounces attribute dimension helps users to monitor which sizes sell better in which markets. The following topics present a review of the basics of dimension and member properties and a discussion of how outline design affects performance: Dimension and Member Properties Dimension Types Member Storage Properties Checklist for Dimension and Member Properties Designing an Outline to Optimize Performance Dimension and Member Properties An outline is comprised of dimensions and members. Dimensions and members have specific properties that provide access to built-in functionality. The properties of dimensions and members define the roles of the dimensions and members in the design of the multidimensional structure. These properties include the following: Dimension types and attribute associations. See Dimension Types . Data storage properties. See Member Storage Properties . Consolidation operators. See Consolidation of Dimensions and Members . Formulas. See Formulas and Functions . For a complete list of dimension and member properties, see Setting Dimension and Member Properties. Dimension Types A dimension type is a property that Analytic Services provides that adds special functionality to a dimension. The most commonly used dimension types are time, accounts, and attribute. This topic uses dimensions of the TBC database to illustrate dimension types. Figure 39: TBC Dimensions and Related Properties Database:Design Year (Type: time) Measures (Type: accounts) Product Market Scenario Pkg Type (Type: attribute) Ounces (Type: attribute) Table5 defines each Analytic Services dimension type. Table 5: Dimension Types  Dimension Types Description None Specifies no particular dimension type. Time Defines the time periods for which you report and update data. You can tag only one dimension as time. The time dimension enables several accounts dimension functions, such as first and last time balances. Accounts Contains items that you want to measure, such as profit and inventory, and makes Analytic Services built-in accounting functionality available. Only one dimension can be defined as accounts. For discussion of two forms of account dimension calculation, see Accounts Dimension Calculations . Attribute Contains members that can be used to classify members of another, associated dimension. For example, the Pkg Type attribute dimension contains a member for each type of packaging, such as bottle or can, that applies to members of the Product dimension. Country Contains data about where business activities take place. In a country dimension, you can specify the type of currency used in each member. For example, Canada has three markets-Vancouver, Toronto, and Montreal. They use the same currency type, Canadian dollars. Currency partition Separates local currency members from the base currency defined in the application. This dimension type is used only in the main database and is only for currency conversion applications. The base currency for analysis may be US dollars, and the local currency members may contain values that are based on the currency type of their region. Member Storage Properties With Analytic Services, you can specify data storage properties for members; data storage properties define where and when consolidations are stored. For example, by default, members are tagged as store data. Analytic Services sums the values of store data members and stores the result at the parent level. You can change the default logic for each member by changing the data storage property tag for the member. For example, you can change a store data member to label only member. Members with the label only tag, for example, do not have data associated with them. Table6 describes Analytic Services data storage properties. Table 6: Analytic Services Data Storage Properties  Storage Properties Effects on Members Store data The member stores data. Store data is the default storage property. Dynamic Calc The data associated with the member is not calculated until requested by a user. The calculated data is not stored; it is discarded after the request is completed. Dynamic Calc and Store The data associated with the member is not calculated until it is requested by a user. The calculated data is then stored. Shared member The data associated with the member comes from another member with the same name. Never share The data associated with the member is duplicated with its parent or child if an implied shared relationship exists. Label only Although a label only member has no data associated with it, it can still display a value. The label only tag groups members and eases navigation and reporting. Typically, label only members are not calculated. For example, in the Measures dimension, the member Ratios has three children, Margin%, Profit%, and Profit per Ounce. The member Ratios defines a category of members. When consolidated, Margin%, Profit%, and Profit per Ounce do not roll up to a meaningful figure for Ratios. Hence, Ratios is tagged as label only. Checklist for Dimension and Member Properties Can you identify a time dimension? Can you identify an accounts dimension? Does the data include foreign currencies? If so, did you identify a currency partition dimension? Can you identify qualities or characteristics of dimensions that should be defined as separate attribute dimensions? What members require special data storage properties? Designing an Outline to Optimize Performance When you design an outline, you must position attribute dimensions at the end of the outline. You should position dense dimensions before sparse dimensions. The position of dimensions in an outline and the storage properties of dimensions can affect two areas of performance-how quickly calculations are run and how long it takes users to retrieve information. Use the following topics to understand performance optimization basics: Optimizing Query Performance Optimizing Calculation Performance Meeting the Needs of Both Calculation and Retrieval Optimizing Query Performance To optimize query performance, use the following guidelines when you design an outline: If the outline contains attribute dimensions, make sure that the attribute dimensions are the only sparse Dynamic Calc dimensions in the outline. In the outline, place the most queried sparse dimensions before the less queried sparse dimensions. The outline shown in Figure40 is designed for optimum query performance: Figure 40: Designing an Outline for Optimized Query Times Because the outline contains attribute dimensions, the storage property for standard dimensions and all standard dimensions members is set as store data. As the most-queried sparse dimension, the Product dimension is the first of the sparse dimensions. Base dimensions are typically queried more than other dimensions. Optimizing Calculation Performance To optimize calculation performance, order the sparse dimensions in the outline by their number of members, starting with the dimension that contains the fewest members. For information about factors that affect calculation performance, see Designing for Calculation Performance . The outline shown in Figure41 is designed for optimum calculation performance: Figure 41: Designing an Outline for Optimized Calculation Times The smallest standard dimension that is sparse, Market, is the first of the sparse dimensions in the outline. The largest standard dimension that is sparse, Product, is immediately above the first attribute dimension. If the outline did not contain attribute dimensions, the Product dimension would be at the end of the outline. Meeting the Needs of Both Calculation and Retrieval Even though they contain the same dimensions, the example outlines of Figure40 and Figure41 are different. To determine the best outline sequence for a situation, you must prioritize the data retrieval requirements of the users against the time needed to run calculations on the database. How often do you expect to update and recalculate the database? What is the nature of user queries? What is the expected volume of user queries? A possible workaround is initially to position the dimensions in the outline to optimize calculation. After you run the calculations, you can manually resequence the dimensions to optimize retrieval. When you save the outline after you reposition its dimensions, choose to restructure the database by index only. Before you run calculations again, remember to resequence the dimensions in the outline to optimize calculation. Checking System Requirements After you determine the approximate number of dimensions and members in your Analytic Services database, you are ready to determine the system requirements for the database. Make sure that you have enough disk space. See Determining Disk Space Requirements . Make sure that you have enough memory. See Estimating Memory Requirements . Make sure that your caches are set correctly. See Optimizing Analytic Services Caches. Loading Test Data Before you can test calculations, consolidations, and reports, you need data in the database. During the design process, loading mocked-up data or a subset of real data provides flexibility and shortens the time required to test and analyze results. Detailed instructions for loading data are in the following chapters: Understanding Data Loading and Dimension Building Creating Rules Files Using a Rules File to Perform Operations on Records, Fields, and Data Performing and Debugging Data Loads or Dimension Builds Understanding Advanced Dimension Building Concepts After you run your preliminary test, if you are satisfied with your database design, test the loading of the complete set of real data with which you will populate the final database, using the test rules files if possible. This final test may reveal problems with the source data that you did not anticipate during earlier phases of the database design process. Defining Calculations Calculations are essential to derive certain types of data. Data that is derived from a calculation is called calculated data ; basic noncalculated data is called input data . The following topics use the Product and Measures dimensions of the TBC application to illustrate several types of common calculations that are found in many Analytic Services databases: Consolidation of Dimensions and Members Tags and Operators on Example Measures Dimension Accounts Dimension Calculations Formulas and Functions Dynamic Calculations Two-Pass Calculations For details on Analytic Services calculations, see the following chapters: Calculating Analytic Services Databases Developing Custom-Defined Calculation Functions Optimizing with Intelligent Calculation Consolidation of Dimensions and Members When you define members of standard dimensions, Analytic Services automatically tags the members with the addition (+) consolidator, meaning that during consolidation members are added. As appropriate, you can change a member consolidation property to one of the following operators: -, *, /, %, and ~ (no consolidation). Consolidation is the most frequently used calculation in Analytic Services. This topic uses the Product dimension to illustrate consolidations. The TBC application has several consolidation paths: Individual products roll up to product families, and product families consolidate into Product. The TBC outline also requires multiple consolidation paths; some products must consolidate in multiple categories. States roll up to regions, and regions consolidate into Market. Months roll up into quarters, and quarters consolidate into Year. The following topics discuss consolidation in greater detail: Effect of Position and Operator on Consolidation Consolidation of Shared Members Checklist for Consolidation Consolidation operators define how Analytic Services rolls up data for each member in a branch to the parent. For example, using the default operator (+), Analytic Services adds 100-10, 100-20, and 100-30 and stores the result in their parent, 100, as shown in Figure42 . Figure 42: TBC Product Dimension The Product dimension contains mostly (+), operators, which indicate that each group of members is added and rolled up to the parent. Diet has a tilde (~), which indicates that Analytic Services does not include the Diet member in the consolidation to the parent, Product. The Diet member consists entirely of members that are shared or duplicated. The TBC product management group wants to be able to isolate Diet drinks in reports, so TBC created a separate Diet member that does not impact overall consolidation. The following topics discuss consolidation in more detail: Effect of Position and Operator on Consolidation Consolidation of Shared Members Checklist for Consolidation Effect of Position and Operator on Consolidation Analytic Services calculates the data of a branch in top-down order. For example, if you have, in order, two members tagged with an addition symbol(+) and a third member tagged with a multiplication symbol (*). Analytic Services adds the first two and multiplies the sum by the third. Be aware that Analytic Services always begins with the top member when it consolidates, so the order and the labels of the members is very important. For an example of how Analytic Services applies operators, see Calculating Members with Different Operators . Table7 shows the Analytic Services consolidation operators. Table 7: Consolidation Operations  Operator Description + The default operator. When a member has the + operator, Analytic Services adds the member to the result of previous calculations performed on members of the branch. - When a member has the - operator, Analytic Services multiplies the member by -1 and then adds the product to the result of previous calculations performed on members of the branch. * When a member has the * operator, Analytic Services multiplies the member by the result of previous calculations performed on members of the branch. / When a member has the / operator, Analytic Services divides the member into the result of previous calculations performed on members of the branch. % When a member has the % operator, Analytic Services divides the member into the sum of previous calculations performed on members of the branch. The result is multiplied by 100. ~ When a member has the ~ operator, Analytic Services does not use it in the consolidation to its parent. Consolidation of Shared Members Shared members also affect consolidation paths. The shared member concept enables two members with the same name to share the same data. The shared member stores a pointer to data contained in the other member, so Analytic Services stores the data only once. Shared members must be in the same dimension. Data can be shared by two or more members. Checklist for Consolidation Use the following checklist to help define consolidation: Have you identified the consolidations in the outline? Did you tag each member with the proper consolidation operator? Did you specify a shared member tag for designated members? Would shared members be more efficient if designed within an attribute dimension (other than shared)? Tags and Operators on Example Measures Dimension The Measures dimension is the most complex dimension in the TBC outline because it uses both time and accounts data. It also contains formulas and special tags to help Analytic Services calculate the outline. This topic discusses the formulas and tags that TBC included in the Measures dimension (the dimension tagged as accounts). Take a moment to look closely at the Measures dimension tags defined by TBC (in Figure43 ). Many of the properties of the Measures dimension are discussed in previous topics of this chapter: positive (+), negative (-), and tilde (~) consolidation operators as well as accounts and label only tags: Figure 43: TBC Measures Dimension The Inventory and Ratios member names assist the user in data navigation and do not contain data and, therefore, receive a label only tag. The Measures dimension itself has a label only tag. Some members of Measures have a Dynamic Calc tag. Dynamic calculations are discussed in Dynamic Calculations . Some members of Measures have a time balance tag (TB First or TB Last). Time balance tags are discussed in Setting Time Balance Properties . Accounts Dimension Calculations This topic discusses two forms of calculations for a dimension tagged as accounts: Time Balance Properties Variance Reporting Time Balance Properties Note the two tags in the Measures dimension of Table9 -TB first and TB last. These tags, called time balance tags or properties, provide instructions to Analytic Services about how to calculate the data in a dimension tagged as accounts. To use the tags, you must have a dimension tagged as accounts and a dimension tagged as time. The first, last, average, and expense tags are available exclusively for use with accounts dimension members. In the TBC Measures dimension, Opening Inventory data represents the inventory that TBC carries at the beginning of each month. The quarterly value for Opening Inventory is equal to the Opening value for the quarter. Opening Inventory requires the time balance tag, TB first. Ending Inventory data represents the inventory that TBC carries at the end of each month. The quarterly value for Ending Inventory is equal to the ending value for the quarter. Ending Inventory requires the time balance tag, TB last. Table8 shows the time balance tags for the accounts dimension. Table 8: Accounts Member Tags  Tags Description Time Balance Last The value for the last child member is carried to the parent. For example, March is carried to Qtr1. Time Balance First The value for the first child is carried to the parent. For example, Jan is carried to Qtr1. Table9 shows how consolidation in the time dimension is affected by time balance properties in the accounts dimension; details are shown only for first quarter: Table 9: TBC Consolidations Affected by Time Balance Properties Accounts -&gt; Time Jan Feb Mar Qtr1 Year Accounts Member1 11 12 13 36 Qtr1 + Qtr2 + Qtr3 + Qtr4 Accounts Member2 (TB First) 20 25 21 20 20 Accounts Member3 (TB Last) 25 21 30 30 Value of Qtr4 Normally, the calculation of a parent in the time dimension is based on the consolidation and formulas of children of the parent. However, if a member in an accounts branch is marked as TB First, then any parent in the time dimension matches the member marked as TB First. For examples of the use of time balance tags, see Setting Time Balance Properties . Variance Reporting One of the TBC Analytic Services requirements is the ability to perform variance reporting on actual versus budget data. The variance reporting calculation requires that any item that represents an expense to the company must have an expense reporting tag. Inventory members, Total Expense members, and the COGS member each receive an expense reporting tag for variance reporting. Analytic Services provides two variance reporting properties-expense and non-expense. The default is non-expense. Variance reporting properties define how Analytic Services calculates the difference between actual and budget data in members with the @VAR or @VARPER function in their member formulas. When you tag a member as expense, the @VAR function calculates Budget-Actual. For example, if the budgeted amount is $100 and the actual amount is $110, the variance is -10. Without the expense reporting tag, the @VAR function calculates Actual-Budget. For example, if the budgeted amount is $100 and the actual amount is $110, the variance is 10. Formulas and Functions You can define formulas to calculate relationships between members in the database outline. You can either apply the formulas to members in the outline, or you can place the formulas in a calculation script. This topic explains how TBC optimized the performance of its database by using formulas. Functions are predefined routines that perform specialized calculations and return sets of members or sets of data values. Formulas are composed of operators and functions, as well as dimension names, member names, and numeric constants. Analytic Services supports the following operators: Mathematical operators that perform arithmetic operations Conditional operators that build logical conditions into calculations Cross-dimensional operators that point to data values of specific database member combinations The Analytic Services functions include over 100 predefined routines to extend the calculation capabilities of Analytic Services. Analytic Services supports the following functions: Boolean functions, which provide a conditional test by returning a TRUE or FALSE value Mathematical functions, which perform specialized mathematical calculations Relationship functions, which look up data values within a database during a calculation based on the position of the current member. Range functions, which declare a range of members as an argument to another function or to a command Financial functions, which perform specialized financial calculations Member set functions, which are based on a specified member and which generate lists of members Allocation functions, which allocate values that are input at a parent level across child members Forecasting functions, which manipulate data for the purpose of smoothing data, interpolating data, or calculating future values Statistical functions, which calculate advanced statistics Date and time functions, which use date and time characteristics in calculation formulas Calculation mode functions, which specify the calculation mode that Analytic Services uses to calculate a formula The Measures dimension uses the following formulas: Margin = Sales - COGS Total Expenses = Marketing + Payroll + Miscellaneous Profit = Margin - Total Expenses Profit % = Profit % Sales Margin % = Margin % Sales Profit per Ounce = Profit / @ATTRIBUTEVAL(@NAME(Ounces)) Analytic Services uses consolidation operators to calculate the Margin, Total Expenses, and Profit members. The Margin% formula uses a % operator, which means express Margin as a percentage of Sales. The Profit% formula uses the same % operator. The Profit per Ounce formula uses a division operator (/) and a function (@ATTRIBUTEVAL) to calculate profitability by ounce for products sized in ounces. Note: In the Profit per Ounce formula, the @NAME function is also used to process the string Ounces for the @ATTRIBUTEVAL function. For a complete list of operators, functions, and syntax, see the Technical Reference. For a comprehensive discussion of how to use formulas, see Developing Formulas . Dynamic Calculations When you design the overall database calculation, you may want to define a member as a Dynamic Calc member. When you tag a member as Dynamic Calc, Analytic Services calculates the combinations of that member when you retrieve the data, instead of pre-calculating the member combinations during the regular database calculation. Dynamic calculations shorten regular database calculation time but may increase retrieval time for dynamically calculated data values. As shown in Figure44 , the TBC Measures dimension contains several members that are tagged as Dynamic Calc-Profit, Margin, Total Expenses, Margin %, and Profit%. Figure 44: TBC Measures Dimension, Dynamic Calc Tags When an overall database calculation is performed, the Dynamic Calc members and their corresponding formulas are not calculated. Rather, the members are calculated when a user requests them, for example, from Spreadsheet Add-in. Analytic Services does not store the calculated values; it recalculates the values for any subsequent retrieval. However, you can choose to store dynamically calculated values after the first retrieval. To decide when to calculate data values dynamically, consider your priorities in the following areas: Optimum regular calculation time (batch calculation) Low disk space usage Reduced database restructure time Speedy data retrieval for users Reduced backup time For a comprehensive discussion of dynamic calculation, see Dynamically Calculating Data Values . Two-Pass Calculations In the TBC database, both Margin % and Profit % contain the label two-pass. This default label indicates that some member formulas need to be calculated twice to produce the desired value. The two-pass property works only on members of the dimension tagged as accounts and on members tagged as Dynamic Calc and Dynamic Calc and Store. The following examples illustrate why Profit % (based on the formula Profit%Sales) has a two-pass tag. Analytic Services loads data into the system as follows: Measures -&gt; Year Jan Feb Mar Qtr1 Profit 100 100 100 . Sales 1000 1000 1000 . Profit % . . . . Analytic Services calculates Measures first. The data then looks as follows: Measures -&gt; Year Jan Feb Mar Qtr1 Profit 100 100 100 . Sales 1000 1000 1000 . Profit % 10% 10% 10% &#160; Next, Analytic Services calculates the Year dimension. The data rolls up across the dimension. Measures -&gt; Year Jan Feb Mar Qtr1 Profit 100 100 100 300 Sales 1000 1000 1000 3000 Profit % 10% 10% 10% 30% The result in Profit % -&gt; Qtr1 of 30% is not correct. However, because TBC tagged Profit% as two-pass calculation, Analytic Services recalculates profit percent at each occurrence of the member Profit %. The data is then correct and is displayed as follows: Measures -&gt; Year Jan Feb Mar Qtr1 Profit 100 100 100 300 Sales 1000 1000 1000 3000 Profit % 10% 10% 10% 10% Checklist for Calculations Use the following checklist when you define a calculation: Does the default calculation logic achieve accurate results? Which members require formulas? Which members require time balance tags? Which members require variance reporting? Which members require two-pass calculation? Which members can be tagged as Dynamic Calc? Note: The triggers feature provided by Analytic Services enables efficient monitoring of data changes in a database. For more information, see Understanding Triggers Definitions . Triggers is licensed separately from Analytic Services. Defining Reports To be sure the design meets user information requirements, you need to view data as users view it. Users typically view data through spreadsheets, printed reports, or reports published on the Web. There are many tools available through Hyperion and Hyperion partners for producing the reporting systems that users use. Analytic Services provides several tools that can help you during the design process to display and format data quickly and to test whether the database design meets user needs. You can use Administration Services Console Report Script Editor to write report scripts quickly. Those familiar with spreadsheets can use the Spreadsheet Add-in or Spreadsheet Services (Spreadsheet Services requires Deployment Services). During the design phase, check for the following things: Grouping and sequencing of data. Do the intersections enabled by the design provide the data that users need? Levels of totals. What consolidation levels are required by, for example, a Spreadsheet Add-in user who drills down and up through the hierarchy of the outline design? Attribute reporting. Does the database design facilitate an analysis that is based on the characteristics or attributes of specific dimensions or members? For example, do you need to compare sales by specific combinations of size and packaging, such as comparing the sales of 16-ounce bottled colas with the sales of 32-ounce bottled colas? If you provide predesigned reports for users, now is the time to use the appropriate tool to create those reports against the test data. The reports that you design should provide information that meets your original objectives. The reports should be easy to use. They should provide the right combinations of data and the right amount of data. Reports with too many columns and rows are very hard to use. It may be better to create a number of different reports instead of one or two all-inclusive reports. Verifying the Design After you analyze the data and create a preliminary design, you need to check all aspects of the design with the users. You should have already checked to see if the database satisfies the users' analysis and reporting needs. Make sure that you check with the users to ensure that the database satisfies all of their goals. Do the calculations give them the information they need? Are they able to generate reports quickly? Are they satisfied with consolidation times? In short, ask users if the database works for them. Near the end of the design cycle, you need to test with real data. Does the outline build correctly? Does all data load? If the database fails in any area, repeat the steps of the design cycle to identify the cause of the problem. Analytic Services provides several sources of information to help you isolate problems. Sources include application and Analytic Server logs, exception logs, and database information accessible from Administration Services. Look at documentation topics relevant to your problem; for example, topics about security, calculations, reports, or general error messages. You can also use the index of this guide to find help for solving problems. Look up such terms as troubleshooting, logs, optimizing, performance, recovery, resources, errors, and warnings. Most likely, you will need to repeat one or more steps of the design process to arrive at the ideal database solution.  |../dindesin.htm",
    " Introducing Hyperion Essbase||Introducing Hyperion Essbase This chapter provides an architectural overview of the product components and introduces the key features of Essbase products, including: Essbase Analytic Services Essbase Deployment Services Essbase Administration Services Essbase Spreadsheet Services Essbase Integration Services Essbase products provide companies with the ability to deliver critical business information to the right people when they need it. With Essbase, companies quickly leverage and integrate data from multiple existing data sources and distribute filtered information to end-user communities in the format that best meets the users' needs. Users interact and intuitively explore data in real-time and along familiar business dimensions, enabling them to perform speed-of-thought analytics. This chapter contains the following sections: Key Features Essbase Product Components Key Features Essbase products provide the analytic solution that integrates data from multiple sources and meets the needs of users across an enterprise. Essbase products enable the quick and easy implementation of solutions, add value to previously inaccessible data, and transform data into actionable information. Integration with Existing Infrastructure Essbase products integrate with your existing business intelligence infrastructure. Essbase products meet the enterprise analytic demands of users for critical business information with a minimum of information technology (IT) overhead and thus enable organizations to realize maximum return on their existing IT investments: Provides an extensible architecture Supports a comprehensive range of data sources, hardware and operating system platforms, access interfaces, and development languages Enables analytic applications to be deployed across a local or wide area network and across an intranet or Internet Data Integration Essbase products enable organizations to leverage data in their data warehouses, legacy systems, online transaction processing (OLTP) systems, enterprise resource planning (ERP) systems, e-business systems, customer relationship management (CRM) applications, Web log files and other external data sources. For database integration, Essbase Integration Services provides a suite of graphical tools, data integration services, and a metadata catalog that tie into relational databases or data warehouse environments (including SAP BW). Ease of Server and Database Administration Essbase products provide a cross-platform administration console. The console gives you detailed control over the Essbase environment: You can manage multiple servers and databases. You can use MaxL, a syntactical language command shell with a PERL extension module, to automate batch maintenance. Mission Critical Applications in Web-based Environments A middle-tier framework extends the power of Essbase products by creating a Web-enabled, distributed platform for Essbase applications hence serving the analysis needs of large numbers of users in Web-based environments. Essbase Deployment Services provide connection pooling, clustering, and failover support, which extend the scalability and reliability of the platform and support mission-critical applications in a 24 x 7 environment. Powerful Querying Large communities of business users can interact with data in real time, analyzing business performance at the speed of thought. Using Essbase products you can organize and present data along familiar business dimensions, thus enabling users to view and explore the data intuitively and to turn the data into actionable information. Calculations Essbase Analytic Services includes powerful calculation features for demanding analytic requirements. A rich library of functions makes it easy to define advanced and sophisticated business logic and relationships. Analytic Services gives users the flexibility to build, customize and extend the calculator through custom-defined macros and functions, as well as the ability to span calculations across databases. On multiprocessor systems, a database administrator can configure a single calculation request to use multiple threads to accomplish the calculation, providing enhanced calculation speed. Aggregate storage databases provide an alternative to block storage databases, and enable dramatic improvements in database aggregation time for certain types of applications. Write-Back and Security Analytic Services provides unique multi-user read and write capabilities, including data update and multi-user recalculation. Business users with front-end tools can write data back to a server and recalculate the data on a server using calculation scripts - key functionality to support sophisticated modeling and planning applications. The robust, multi-level security model provides server-, database-, and cell-level security. Full control of data access, views, and write capabilities are managed through administration. Integration with external authentication systems, such as Lightweight Directory Access Protocol (LDAP), allows the quick creation of security models and reduces the time and the cost of application development and maintenance. Ease of Development Analytic Services offers many key advantages to help users develop effective multi-dimensional applications. Users can: Design and manage applications using a graphical interface to control most server functions. Quickly add dimensions, change calculations, and modify hierarchies to reflect new business developments. In addition, the dynamic dimension builder automatically defines and dynamically loads large amounts of data, including data from spreadsheets, flat files, and supported relational database tables directly into a database. Define key calculations without having to write a program. Define security for individuals and groups and customize views and retrieval procedures for each user without writing a program. For information about supported applications, operating systems, and networking protocols, see the Essbase Analytic Services Installation Guide . Essbase Product Components Essbase products incorporate powerful architectural features to handle a wide range of analytic applications across large multi-user environments. Figure1 provides a high-level view of the information flow between the source data and the product components. Figure 1: High-level Information Flow Between Product Components Note: For information on Hyperion Objects, Hyperion Analyzer, and Hyperion Application Link (HAL) visit our website at www.hyperion.com . Analytic Services Analytic Services-a multi-threaded OLAP database software that takes advantage of symmetric multi processing hardware platforms-is based upon Web-deployable, thin-client architecture. The server acts as a shared resource, handling all data storage, caching, calculations, and data security. The Analytic Server client needs only to retrieve and view data that resides on a server. All Analytic Services application components, including database outlines and calculation scripts, application control, and multi-dimensional database information, reside on a server. With Analytic Services you can configure server disk storage to span multiple disk drives, enabling you to store large databases. Analytic Services requires a server to run a multi-threaded operating system so a server can efficiently manage multiple, simultaneous requests. A server also runs a server agent process that acts as a traffic coordinator for all user requests to applications.Aggregate storage databases-using a new storage kernel for multidimensional databases-provide an alternative to block storage databases, and enable dramatic increases in database dimensionality. Using aggregate storage, Analytic Services serves a wide range of analytic needs-financial analysis, planning, budgeting, sales analysis, marketing analysis, supply chain analysis, profitability analytics-all from a single analytic infrastructure. MaxL-a multidimensional database access language that is part of Analytic Server-provides a flexible way to automate Analytic Services administration and maintenance tasks. See dev.hyperion.com or the Essbase Analytic Services Installation Guide for information on the supported operating systems, and for specific information about server configuration requirements. Administration Services Administration Services-the database and system administrators' interface to Analytic Services-provides a single-point-of-access console to multiple Analytic Servers. Using Administration Services you can design, develop, maintain, and manage multiple Analytic Servers, applications, and databases. You can preview data from within the console, without having to open a client application such as Spreadsheet Add-in. You can also use custom Java plug-ins to leverage and extend key functionality. Deployment Services Deployment Services allows multiple instances of Analytic Server to run on multiple machines, while serving the user as one logical unit and removing and single point of failure. Deployment Services enables database clustering with load balancing and fail-over capabilities. Spreadsheet Products and Hyperion Analyzer Hyperion Analyzer, Spreadsheet Services, and Spreadsheet Add-in-the business users' interface to Analytic Services-provide interactive analysis and delivery of corporate information to diverse user communities. Hyperion Analyzer, Spreadsheet Services, and Spreadsheet Add-in provide out-of-the-box solutions and easy-to-use personalization and visualization tools allow you to create intuitive, Web-based analysis and reporting from ERP systems, relational, multidimensional and other data sources. Integration Services Integration Services-an optional product component-provides a metadata-driven environment to bridge the gap between data stored in Analytic Services databases and detailed data stored in relational databases. The Hybrid Analysis feature gives business users more detail for decision-making and IT managers more modularity in designing and maintaining large-scale analytic applications. Hybrid Analysis allows portions of Analytic Services databases to be stored in a relational database. This relational stored data is mapped to the appropriate Analytic Services hierarchies. HAL (Hyperion Application Link) is an application integration and business process automation tool that allows bi-directional information exchange between transaction processing applications, desktop applications, and Hyperion Business Performance Management applications. Application Programming Interface (API) Analytic Services API-the developers' interface to Analytic Services-allows you to create customized applications. The API Reference provides a complete listing of API functions, platforms, and supported compilers. Developer Products Essbase developer products enable the rapid creation, management and deployment of tailored enterprise analytic applications-with or without programming knowledge. The products (for example, Application Builder, and Hyperion Objects) provide a comprehensive set of application programming interfaces, drag and drop components and services. Data Mining Data Mining-an optional product component of Analytic Services-shows you hidden relationships and patterns in your data, enabling you to make better business decisions. Using Data Mining you can plug in various data mining algorithms, build models, and then apply them to existing Analytic Services applications and databases.  |../dinolap.htm",
    "Quick Start for Implementing Analytic Services||The table in this chapter provides process steps to help you get up and running with Analytic Services. The table also tells you where you can find more information about each step. Unless otherwise specified, the chapters refer to the Essbase Analytic Services Database Administrator's Guide . Note: The information in this chapter is designed for block storage databases. Some of the information is not relevant to aggregate storage databases. For detailed information on the differences between aggregate and block storage, see Comparison of Aggregate and Block Storage. Note: This chapter assumes that you are a new Analytic Services user. If you are migrating from a previous version of Analytic Services, see the Essbase Analytic Services Installation Guide for important migration information. Table 1: A Process Map  Process Step Reference Learn the fundamentals of Analytic Services and distributed OLAP. Introducing Hyperion Essbase Understanding Multidimensional Databases Basic Architectural Elements Creating Applications and Databases Working with Attributes Designing Partitioned Applications Attend an Analytic Services training class; contact your software provider for details. Assess your needs and requirements. Have a clear idea of your data analysis needs and of what types of calculations and reports you want to run. Your budget, forecasting, and other financial reports with notes on how you want to improve them Analyze your data from a multidimensional perspective. Consider the following: Where are your data sources? What type is the data? Is it detailed, relational data or is it higher-level, hierarchical data that can be used for analysis? In what format is the data? How will you access the data? If you need to access relational data, you may need SQL Interface or Integration Services (a separately purchasable product). Understanding Multidimensional Databases Essbase Analytic Services SQL Interface Guide ODBC drivers documentation Essbase Integration Services documentation Install Analytic Services. Decide what components you want to install. Be aware that the license your company purchased might not include all options. Essbase Analytic Services Installation Guide Design your application and database. Identify business and user requirements, including security. Identify source data and determine the scope of the Analytic Services database. Choose whether to leave lowest-level member data in a relational database and access with Hybrid Analysis, or to load all data. Define standard dimensions and designate sparse and dense storage. Identify any need for attribute dimensions. Identify any need for currency conversion applications that track data in different currencies. Define calculations needed for outline dimensions and members. Identify any need to monitor data changes in the database. You monitor data changes using the Analytic Services triggers feature (licensed separately). Case Study: Designing aSingle-Server, Multidimensional Database Estimate the size of your database, check disk space, and ensure that the sizes of the index, data files, and data caches in memory are adequate. Limits Create an application and a database. Creating Applications and Databases Design a currency application. Designing and Building Currency Conversion Applications Build an outline for your database. Creating and Changing Database Outlines Assign alias names to your members. Setting Dimension and Member Properties Build the dimensions. Decide whether your data loads will introduce new members into the outline. If so, consider dynamically building your dimensions using a rules file and a data source. If not, set up regular data loads. Understanding Data Loading and Dimension Building Creating Rules Files Load your data. You can load data these ways: Free-form With a rules file With Hybrid Analysis Understanding Data Loading and Dimension Building Creating Rules Files Using a Rules File to Perform Operations on Records, Fields, and Data Performing and Debugging Data Loads or Dimension Builds Understanding Advanced Dimension Building Concepts Calculate your database. Decide on a type of calculation: outline or calculation script, or a combination of both. Ensure that relationships between members and member consolidations in the database outline are correct. Consider whether tagging some members as Dynamic Calc or whether using Intelligent Calculation will improve calculation efficiency. Consider which members you need to tag as two-pass calculation to ensure correct calculation results. Calculating Analytic Services Databases Developing Formulas Reviewing Examples of Formulas Defining Calculation Order Dynamically Calculating Data Values Calculating Time Series Data Developing Calculation Scripts Reviewing Examples of Calculation Scripts Developing Custom-Defined Calculation Macros Developing Custom-Defined Calculation Functions Learn about dynamic calculations and how they can greatly improve performance. Dynamically Calculating Data Values View data with Spreadsheet Add-in, other Hyperion tools, or third-party tools. For Spreadsheet Add-in, see the Essbase Spreadsheet Add-in User's Guide For other tools, see the documentation for that particular tool For a list of tools, visit the Hyperion site: http:\/\/www.hyperion.com Learn about Partitioning. Think about whether your data can benefit from being decentralized into connected databases. Designing Partitioned Applications Creating and Maintaining Partitions Link files or cell notes to data cells. Linking Objects to Analytic Services Data Copy or export data subsets. Copying Data Subsets and Exporting Data to Other Programs Back up and restore your data. Backing Up and Restoring Data Allocate storage and specify Analytic Services kernel settings for your database. Data compression: Specify data compression on disk and the compression scheme. Cache sizes: You can specify the index, data file, and data cache sizes. To prevent a slow-down of the operating system, ensure that the sum of index and data cache sizes for all the active databases on the server is not more than two-thirds of the system's RAM. Cache memory locking : You can lock the memory that is used for the index, data file, and data caches into physical memory. Disk volumes: You can specify the storage location of Analytic Services index files and data files, specify the appropriate disk volume names and configuration parameters. Isolation level: Specify either committed access or uncommitted access. Managing Database Settings Allocating Storage and Compressing Data Generate a report. Choose a type of report: structured or free-form. Plan the elements of the report, such as page layout, number of columns, identity of members, format of data values, and content of titles. For a structured report, create page, column, and row headings (unnecessary for a free-form report). Create and test a report script, use Administration Services' Report Script Editor or any other text editor. Save the report on OLAP Server or on a client computer. Understanding Report Script Basics Developing Report Scripts Copying Data Subsets and Exporting Data to Other Programs Mining an Analytic Services Database Fine-tune your database performance and storage settings. Managing Database Settings Allocating Storage and Compressing Data Monitoring Performance Automate routine operations by using MaxL or ESSCMD. Using MaxL Data Definition Language Using ESSCMD Design security for your database. Create a security plan for your environment based on database security needs. Create users and groups and assign them administrative or data-access permissions, if necessary. Define common data access permissions at the scope of the server, applications, databases, or data-cell levels. To define global application or database permissions, select the relevant application or application and database and adjust the settings. Managing Security for Users and Applications Controlling Access to Database Cells Security Examples Maintain your applications. Running Analytic Servers, Applications, and Databases Managing Applications and Databases Monitoring Data, Applications, and Databases Managing Database Settings Allocating Storage and Compressing Data Ensuring Data Integrity Backing Up and Restoring Data Analyze and improve performance and troubleshoot errors if they occur. Ensure that block size is not excessively large. Set the correct size for the index, data file, data, and calculator caches. Validate the database to ensure data integrity. Consider using partitioning to distribute data across multiple cubes for better scalability and performance. Ensure that disk space is adequate to allow the application to grow over time. Archive data from OLAP Server on a regular basis. Enable logging for spreadsheet update to ensure that log files are updated after archiving. If sorting on retrievals, increase the size of the retrieval sort buffer. Monitoring Performance Improving Analytic Services Performance Optimizing Analytic Services Caches Optimizing Database Restructuring Optimizing Data Loads Optimizing Calculations Optimizing with Intelligent Calculation Optimizing Reports and Other Types of Retrieval  |../dinstart.htm",
    "Monitoring Data, Applications, and Databases||This chapter provides information on using triggers to monitor data changes in a database and detailed information on using logs to monitor server, application and database activities. This chapter includes the following topics: Monitoring Data Changes Using Triggers Using Analytic Services Logs Monitoring Data Changes Using Triggers The triggers feature provided by Essbase Analytic Services enables efficient monitoring of data changes in a database. If data breaks rules specified in a trigger, Analytic Services can log relevant information in a file, or, for some triggers, can send an e-mail alert (to a user or system administrator). For example, you might want to notify the sales manager if, in the Western region, sales for a month fall below sales for the equivalent month in the previous year. There are two types of triggers: on-update triggers and after-update triggers. On-update triggers are activated during the update process, when the block containing the data referenced by the trigger is brought into memory. After-update triggers are activated after the update transaction is complete. Note: On-update triggers are supported only on block storage databases. This topic contains the following subtopics: Administering Triggers Effect of Triggers on Performance and Memory Usage Trigger Examples Administering Triggers To administer triggers, a user must have Database Designer security privilege. Analytic Services monitors and potentially activates triggers during the following activities: Data load Calculation Lock and send from Essbase Spreadsheet Add-in (does not apply to aggregate storage databases) Analytic Services does not activate triggers during a database restructure. To create, change, display, and delete triggers, use any of the following methods: Tool Topic Location Administration Services Creating Triggers Editing Triggers Viewing Triggers Enabling and Disabling Triggers Viewing Trigger Spool Files Deleting Triggers Essbase Administration Services Online Help MaxL create trigger create or replace trigger alter trigger display trigger drop trigger Technical Reference You can see information on enabled and disabled triggers in the application log file when you start Essbase Analytic Server. Creating On-Update Triggers When creating on-update triggers, consider the following information: You must use a symmetric WHERE clause when defining the area specification for a trigger. See the MDX documentation in the MaxL section of the Technical Reference . To enable Analytic Services to send e-mail alerts, you must have Java Virtual Machine (JVM) installed on your system. Note: E-mails related to Unicode-mode applications are encoded in UTF-8 and require a UTF-8-capable e-mail reader. You cannot define a trigger that requires data from the following Analytic Services features: Dynamic Calc Hybrid analysis Partitioning You can specify whether all trigger data values are stored in the spool file or whether only the most current values are stored (for example, use the a log_value parameter on the MaxL create trigger statement or create and replace trigger statement). If the log_value parameter is set to ON, both the new value and old value are logged to the spool file. If the log_value parameter is set to OFF, values are not logged to the spool file. The log_value parameter is active only for data load and lock-and-send activities. Consider data security when sending e-mail alerts. When Analytic Services activates a trigger and sends an e-mail, it cannot check whether the e-mail recipient is authorized to see the data referenced by the trigger condition. Avoid referencing a sparse dimension member in a trigger condition. When Analytic Services executes a trigger on one data block, it has to read another data block that may or may not be updated. Depending on the state of the second block, Analytic Services may activate the trigger in error. The following example is based on the Sample Basic database. Assume that East and West are sparse dimensions and that the following statement defines the trigger condition: FIX (East, West, Sales, Jan, Actual, Cola) IF ((Sales-&gt;East + Sales-&gt;West) &gt; 20) EMAIL sales@hyperion.com Assume that the following Sales data values are stored for East and West: Sales-&gt;East = 5 Sales-&gt;West = 6 Now assume that a user does a lock and send request to update the data values: Sales-&gt;East = 15 Sales-&gt;West = 3 When Sales-&gt;East is updated to 15, temporarily the database contains the following values: Sales-&gt;East = 15 Sales-&gt;West = 6 So Analytic Services activates the trigger because 15+6 &gt; 20. Subsequently Analytic Services updates Sales-&gt;West to 3. Now the data does not meet the trigger condition because 15+3 &lt; 20. However, Analytic Services has already activated the trigger. When a data load is followed by a calculation, if both the loaded data and the calculated data meet the trigger condition, Analytic Services activates the trigger twice, once on the data load and once on the calculation. Creating After-Update Triggers When creating after-update triggers, consider the following information: You must use a symmetric WHERE clause when defining the area specification for a trigger. See the MDX documentation in the MaxL section of the Technical Reference . After-update triggers send information to a spool file.The most recent value is logged to the spool file. E-mail alerts are not supported. You cannot define a trigger that requires data from the Analytic Services hybrid analysis feature. Effect of Triggers on Performance and Memory Usage Depending on the number of enabled triggers in a database, there may be a small decrease in performance of calculation and data load. You can control the maximum amount of memory used by the triggers feature by specifying the TRIGMAXMEMSIZE configuration setting in the essbase.cfg file. By default, TRIGMAXMEMSIZE is set to 4096 bytes. Choosing to log information in a file, rather than sending e-mail, may improve calculation and data load performance by reducing network traffic. Trigger Examples The following examples are based on the Sample Basic database. Note: You cannot define a trigger that requires data from hybrid analysis members. You cannot define an on-update trigger that requires data from Dynamic Calc members or from members from another partition. Example 1, Tracking Sales for January Example 1 tracks the Actual, Sales value for the following month, product, and region: January (Year dimension member Jan) Colas (Product dimension member 100) Eastern region (Market dimension member East) When the member being calculated is Jan and when the Actual, Sales value of Colas for January exceeds 20, the example sends an e-mail to two e-mail accounts. create trigger Sample.Basic.Trigger_Jan_20 where (Jan,Sales,[100],East,Actual) when Jan &gt; 20 and is(Year.currentmember,Jan) then mail ([Docs.Company.com],[trgsales@company.com], [inventory@company.com], [Mail sent by trigger_Jan_20]) end; Example 2, Tracking Sales for Quarter 1 Example 2 tracks the Actual, Sales value for the following months, product, and region: January, February, and March (the children of Year dimension member Qtr1) Colas (Product dimension member 100) Eastern region (Market dimension member East) When the member being calculated is Jan, Feb, or Mar and when the Actual, Sales value of Colas for the month January, February, or March exceeds 20, the example logs an entry in the file Trigger_Jan_Sales_20, Trigger_Feb_Sales_20, or Trigger_Mar_Sales_20. On subsequent trigger activations, both old and new log values are retained in the log files. create or replace trigger Sample.Basic.Trigger_Qtr1_Sales log_value on Where (crossjoin(Qtr1.children, (Measures.Sales, [100], East, Scenario.Actual) )) When Year.Jan &gt; 20 and is(Year.currentmember, Jan) then spool Trigger_Jan_Sales_20 When Year.Feb &gt; 20 and is(Year.currentmember, Feb) then spool Trigger_Feb_Sales_20 When Year.Mar &gt; 20 and is(Year.currentmember, Mar) then spool Trigger_Mar_Sales_20 end; Example 3, Tracking Inventory Level Example 3 tracks the inventory level for the following product, region, and months: Colas (product 100) Eastern region (market East) January, February, and March (the children of Qtr1) The trigger is activated after the update action is complete. If the inventory of Colas in the eastern region falls below 500,000, the example logs an entry in the file Inventory_East. create after update trigger Sample.Basic.Inventory_east where (crossjoin ( children([Qtr1]) , ([Market].[East], [Product].[100], [Inventory].[Ending Inventory]) )) when [Ending Inventory] &lt; 500000 then spool Inventory_East end; Using Analytic Services Logs This topic describes the logs that Analytic Server creates to record information about server, application, and database activities. Table43 briefly describes each log: Table 43: Summary of Logs Type of Log Location of Log Information Included Analytic Server log ARBORPATH \\essbase.log Server activities and errors Application log ARBORPATH \\app\\ application_name \\ application_name .log Application activities and errors Query log ARBORPATH \\app\\ appname \\ dbname \\ dbname 00001.qlg Query patterns of Essbase database retrievals Outline change log ARBORPATH \\app\\ application_name \\ database_name \\ database_name .olg Changes to the outline Exception log One of these locations: ARBORPATH \\log00001.xcp ARBORPATH \\app\\log00001.xcp ARBORPATH \\app\\ application_name \\ log00001.xcp ARBORPATH \\app\\ application_name \\ database_name \\log00001.xcp Errors that result when Analytic Server stops abnormally Dimension build and data load error logs One of these locations (See Table54 ): ARBORPATH \\client\\dataload.err ARBORPATH \\app\\ application_name \\ application_name .log Errors from a dimension build or a data load This topic describes the information written to a log and explains how you can use that information to maintain, tune, or troubleshoot Analytic Server. This topic includes the following subtopics: Analytic Server and Application Logs Using Analytic Server and Application Logs Using Application Log to Monitor Memory Use Implementing Query Logs Understanding and Using the Outline Change Log Understanding and Using Exception Logs Understanding and Using Dimension Build and Data Load Error Logs For information about Essbase Administration Services logs, see About the Administration Server Log in Essbase Administration Services Online Help . Analytic Server and Application Logs Analytic Server writes activities that occur in Analytic Server and application logs. The Analytic Server log is a text file in the ARBORPATH directory named essbase.log . In a standard installation, for example, the Analytic Server log is hyperion\\essbase\\essbase.log . Each application on Analytic Server has its own application log. An application log is a text file in the ARBORPATH\\ app \\application_name directory named application_name .log . For the Sample Basic database, for example, the application log is hyperion\\essbase\\app\\sample\\sample.log . Information in application logs can help you to pinpoint where and why an error occurred. The following topics describe Analytic Server and application logs: Contents of the Analytic Server Log Analytic Server Log Example Contents of the Application Log Example of an Application Log Analytic Server and Application Log Message Categories For information about the actions that you can perform on server and application logs, see Using Analytic Server and Application Logs . For information on viewing or analyzing logs using Administration Services, see About Log Viewer or About Log Analyzer in Essbase Administration Services Online Help . For information about specific error messages, see the Error Messages Guide in \\docs\\errmsgs in the Analytic Services installation. Contents of the Analytic Server Log Analytic Server writes activities that occur on Analytic Server in ARBORPATH \\essbase.log . Use essbase.log to find out more about the activities on Analytic Server. These are some of the activities that you can assess: Who performed an operation When an operation was performed Errors that occurred when an operation was performed or attempted Table44 lists the types of actions logged and the information included in the log message. For information about specific error messages, see the Error Messages Guide in \\docs\\errmsgs in the Essbase installation. Table 44: Contents of the Analytic Server Log (essbase.log)  Type of Action Information Included Actions performed at the Analytic Server level, such as logging on Analytic Server or setting security Username Date and time If changing permissions-user and group information and IP address of user If logging on-the time and date the user last logged on If logging off-the length of time the user was logged on If creating or changing an application or database-request to create or open the object; load, connect, and start the application or database to be created; and lock of the object to be created or changed If creating, changing, or viewing an application or database-requests to list applications and databases and requests to retrieve access information Shut down or start up requests Requests to retrieve and delete the Analytic Server log Actions performed at the application level, such as viewing application settings or viewing and changing custom-defined macros, custom-defined functions, and substitution variables Username Date and time Requests to retrieve operating system resources, license information, and system-wide configuration Retrieving and setting global values If altering substitution variables-request to list and set substitution variables If altering custom-defined macros-request to list and delete custom-defined macros Requests to retrieve and delete the application log Actions performed at the database level, such as creating rules files, outlines, reports, or calculation scripts username Date and time Requests to retrieve client settings, user, and group information Requests to list applications and databases Requests to retrieve access information Requests to lock objects Returning objects Analytic Server Log Example Figure219 shows examples of entries written to essbase.log when Analytic Server starts. First, the Sample application and the Basic database are loaded. The log includes information about the time the application and database are loaded, the process ID assigned to the application by the operating system, and the startup of the security authentication module. Note: You can use the process ID to stop the application improperly if you are unable to perform a normal shutdown. See Stopping an Application Improperly . Figure 219: Startup Messages in the Analytic Server Log [Tue Nov 06 07:54:16 2001]Local/ESSBASE0\/\//Info(1054014) Database Basic loaded [Tue Nov 06 07:54:16 2001]Local/ESSBASE0\/\//Info(1051061) Application Sample loaded - connection established [Tue Nov 06 07:54:16 2001]Local/ESSBASE0\/\//Info(1054027) Application [Sample] started with process id [1300] [Tue Nov 06 07:54:18 2001]Local/ESSBASE0\/\//Info(1054014) Database Basic loaded [Tue Nov 06 07:54:23 2001]Local/ESSBASE0\/\//Info(1051134) External Authentication Module: [LDAP] enabled [Tue Nov 06 07:54:23 2001]Local/ESSBASE0\/\//Info(1051051) Hyperion Essbase Analytic Server - started Figure220 shows a single error. The admin user tried to rename an application using a name that already exists on Analytic Server. The log includes information about the username, the time of the error, and the operation that failed and caused the error. Figure 220: Error Messages in the Analytic Server Log [Tue Nov 06 08:00:04 2001]Local/ESSBASE0\/\//Info(1051001) Received client request: Rename Application (from user admin) [Tue Nov 06 08:00:04 2001]Local/ESSBASE0\/\//Error(1051031) Application Testing already exists [Tue Nov 06 08:00:04 2001]Local/ESSBASE0\/\//Warning(1051003) Error 1051031 processing request [Rename Application] - disconnecting Finally, Figure221 shows a shutdown. The log includes information about the name of the application shut down and the time of the shutdown. Figure 221: Shut Down Messages in the Analytic Server Log [Tue Nov 06 08:00:46 2001]Local/ESSBASE0\/\//Info(1054005) Shutting down application Sample [Tue Nov 06 08:00:52 2001]Local/ESSBASE0\/\//Info(1051052) Hyperion Essbase Analytic Server - finished Contents of the Application Log Analytic Server writes application activities that occur, such as calculations, on the server in ARBORPATH \\app\\ application_name \\ application_name .log . For the Sample Basic database, for example, the application log is hyperion\\essbase\\app\\sample\\sample.log . For information about specific error messages, see the Error Messages Guide in \\docs\\errmsgs in the Essbase installation. Use application_name .log to find out more about the activities in an application. These are some of the activities you can assess: Who performed a specific operation When an operation was performed Errors that occurred when an operation was performed or attempted Information about dimensions and members to aid in optimization The name of an object used to execute an operation (such as a calc script or load file used to perform a calculation or a data load) if the object resides on an instance of Analytic Services Table45 lists the types of actions logged and the information included in the log message. Table 45: Contents of the Application Log (application_name.log)  Type of Action Information Included Actions performed at the database level, such as loading data, clearing data, or calculating data username Date and time Application and database name and time If starting application-loading Java modules, and reading and writing database and application information If loading databases-information about dimension sizes, dynamic calculation members, blocks, cache sizes, index page size, and I/O information If starting databases-application and database setup information, including reading free space information, writing database parameters, retrieving state information, writing application and database definition information, retrieving database volumes, and writing database mapping If loading-the load command, parallel data load information, cells updated, elapsed load time, and the name of the rules file and data file Note: Analytic Services supplies the load rule name only if the client making the request (for example, Administration Services) is at the same release level as Analytic Services; for example, Release 7.0. If calculating-the name of the calculation script used to perform the calculation If reporting-the name of the report script Actions performed at the outline level, such as restructuring username Date and time Information about dimension sizes, dynamic calculation members, blocks, cache sizes, index page size, I/O information, and restructure elapsed time Actions performed at the spreadsheet level, such as lock and send username Date and time Action performed Example of an Application Log The following topics show example entries in the application log, including a standard startup and shutdown, and an example of the messages logged when an error occurs. Example 1: Startup Messages in the Application Log Example 2: Errors in the Application Log Example 3: Shutdown Messages in the Application Log Example 1: Startup Messages in the Application Log Figure222 shows all the entries written to application_name .log when Analytic Server starts. The log includes information such as the time the application starts, when application and database information is read and written, when the application is ready for login requests, and when the database is loaded. Figure 222: Initials Startup Messages in the Application Log [Tue Nov 06 08:47:14 2001]Local/Sample\/\//Info(1002035) Starting Essbase Server - Application [Sample] [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1200480) Loaded and initialized JVM module [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1019008) Reading Application Definition For [Sample] [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1019009) Reading Database Definition For [Basic] [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1019021) Reading Database Mapping For [Sample] [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1019010) Writing Application Definition For [Sample] [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1019011) Writing Database Definition For [Basic] [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1019022) Writing Database Mapping For [Sample] [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1013202) Waiting for Login Requests [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1013205) Received Command [Load Database] [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1019018) Writing Parameters For Database [Basic] [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1019017) Reading Parameters For Database [Basic] After Analytic Server starts, Analytic Server writes information about the dimensions and members in the outline, such as the dimension sizes and dynamic calculation information, to the application log: Figure 223: Database Outline Messages in the Application Log [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1019012) Reading Outline For Database [Basic] [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1007043) Declared Dimension Sizes = [20 17 23 25 5 3 5 3 15 8 6 ] [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1007042) Actual Dimension Sizes = [20 14 20 25 4 3 5 3 15 8 5 ] [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1007125) The number of Dynamic Calc Non-Store Members = [8 6 0 0 2 ] [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1007126) The number of Dynamic Calc Store Members = [0 0 0 0 0 ] Next, Analytic Server writes information about the blocks in the database, including the block size, the number of declared and possible blocks, and the number of blocks needed to perform calculations (you can use this information to estimate the retrieval performance for members of sparse dimensions tagged as Dynamic Calc) to the application log: Figure 224: Block-Related Messages in the Application Log [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1007127) The logical block size is [1120] [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1010008) Maximum Declared Blocks is [575] with data block size of [1700] [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1010007) Maximum Actual Possible Blocks is [500] with data block size of [192] [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1200481) Formula for member [Opening Inventory] will be executed in [CELL] mode [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1012710) Essbase needs to retrieve [1] Essbase Kernel blocks in order to calculate the top dynamically-calculated block. Next, Analytic Server writes information about the caches set for each database to the application log, as illustrated in Figure225 . Figure 225: Cache Messages in the Application Log [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1012736) The Dyn.Calc.Cache for database [Basic] can hold a maximum of [2340] blocks. [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1012737) The Dyn.Calc.Cache for database [Basic], when full, will result in [allocation from non-Dyn.Calc.Cache memory]. [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1019018) Writing Parameters For Database [Basic] [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1019017) Reading Parameters For Database [Basic] [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1070013) Index cache size ==&gt; [1048576] bytes, [1024] index pages. [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1070014) Index page size ==&gt; [8192] bytes. [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1070081) Using buffered I/O for the index and data files. [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1070083) Using waited I/O for the index and data files. [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1019019) Reading Data File Free Space Information For Database [Basic]... [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1006025) Data cache size ==&gt; [3145728] bytes, [2048] data pages [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1006026) Data file cache size ==&gt; [0] bytes, [0] data file pages The final messages logged at startup refer to general database information: Figure 226: General Database Messages in the Application Log [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1013205) Received Command [Get Database Volumes] [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1013205) Received Command [Set Database State] [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1019018) Writing Parameters For Database [Basic] [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1019018) Writing Parameters For Database [Basic] [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1013205) Received Command [Get Database State] [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1013205) Received Command [Get Database Info] [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1013205) Received Command [SetApplicationState] [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1019010) Writing Application Definition For [Sample] [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1019011) Writing Database Definition For [Basic] [Tue Nov 06 08:47:15 2001]Local/Sample\/\//Info(1019022) Writing Database Mapping For [Sample] Example 2: Errors in the Application Log The following example shows a single error. An unknown member was found in the data load file; the presence of an unknown member caused the load to fail. First, you see the request for the data load, then the error message, and, finally, information messages describing the data values changed by the data load and the data load elapsed time. [Tue Nov 06 08:49:52 2001]Local/Sample\/\//Info(1013210) User [admin] set active on database [Basic] [Tue Nov 06 08:49:52 2001] Local/Sample/Basic/admin/Info(1013091) Received Command [DataLoad] from user [admin] [Tue Nov 06 08:49:52 2001] Local/Sample/Basic/admin/Info(1003040) Parallel dataload enabled: [1] block prepare threads, [1] block write threads. [Tue Nov 06 08:49:52 2001] Local/Sample/Basic/admin/Error(1003000) Unknown Item [500-10] in Data Load, [0] Records Completed [Tue Nov 06 08:49:52 2001] Local/Sample/Basic/admin/Warning(1003035) No data values modified by load of this data file [Tue Nov 06 08:49:52 2001] Local/Sample/Basic/admin/Info(1003024) Data Load Elapsed Time : [0.11] seconds [Tue Nov 06 08:49:52 2001] Local/Sample/Basic/admin/Info(1019018) Writing Parameters For Database [Basic] Example 3: Shutdown Messages in the Application Log The following messages are logged when Analytic Server performs a normal shut down. First information about the database is retrieved, then the database is unloaded, free space information is written, and the server shuts down. [Tue Nov 06 08:50:26 2001]Local/Sample\/\//Info(1013214) Clear Active on User [admin] Instance [1] [Tue Nov 06 08:50:34 2001]Local/Sample\/\//Info(1013205) Received Command [Get Database Info] [Tue Nov 06 08:50:34 2001]Local/Sample\/\//Info(1013205) Received Command [Get Database State] [Tue Nov 06 08:50:34 2001]Local/Sample\/\//Info(1013205) Received Command [Get Database Volumes] [Tue Nov 06 08:50:34 2001]Local/Sample\/\//Info(1013205) Received Command [Get Database State] [Tue Nov 06 08:50:34 2001]Local/Sample\/\//Info(1013205) Received Command [Get Database Volumes] [Tue Nov 06 08:50:34 2001]Local/Sample\/\//Info(1013205) Received Command [Unload Database] [Tue Nov 06 08:50:34 2001]Local/Sample\/\//Info(1019018) Writing Parameters For Database [Basic] [Tue Nov 06 08:50:34 2001]Local/Sample\/\//Info(1019020) Writing Free Space Information For Database [Basic] [Tue Nov 06 08:50:34 2001]Local/Sample\/\//Info(1013207) RECEIVED SHUTDOWN COMMAND - SERVER TERMINATING Analytic Server and Application Log Message Categories Table46 provides error message categories for each error number range that is shown in the first column. When you receive an error message, use this table to identify the Analytic Services component to which the error is related. For information about specific error messages, see the Error Messages Guide in \\docs\\errmsgs\\erhelp.htm in the Essbase installation. Table 46: Error Message Categories  Error Message Number Range Component That Generated the Error 1001000-1001999 Report Writer 1002000-1002999 General server 1003000-1003999 Data load 1004000-1004999 General server 1005000-1005999 Backup, export, or validate 1006000-1006999 Data cache 1007000-1007999 Outline restructure 1008000-1008999 System calls, portable layer, ASD, or Agent 1009000-1009999 Restoring ASCII data 1010000-1010999 Internal (block numbering) 1011000-1011999 Internal (utilities) 1012000-1012999 Calculator 1013000-1013999 Requestor 1014000-1014999 Lock manager 1015000-1015999 Alias table 1016000-1016999 Report Writer 1017000-1017999 Currency 1018000-1018999 Not currently used 1019000-1019999 Database objects 1020000-102999 Spreadsheet extractor 1021000-1021999 SQL Interface 1022000-1022999 Security 1023000-1023999 Partitioning 1024000-1024999 Query Extractor 1030000-1030999 Application Programming Interface (API) 1040000-1040999 General network 1041000-1041999 Network-Named Pipes 1042000-1042999 Network-TCP 1043000-1049999 Not currently used 1050000-1055999 Agent 1056000-1059999 Not currently used 1060000-1060999 Outline API 106100-1069999 Not currently used 1070000-1070999 Index manager 1071000-1079999 Not currently used 1080000-1080099 Transaction manager 1081000-1089999 Not currently used 1090000-1099999 Rules file processing 1010000-1019999 Not currently used 1100000-1100999 Not currently used 1110000-1119999 Hyperion Web Gateway (HWG) 1120000-1129999 Grid API 1130000-1139999 Miscellaneous 1140000-1149999 Linked Reporting Objects (LRO) 1150000-1159999 Outline synchronization 1160000-1169999 Outline change records 1170000-1179999 Attributes 1180000-1189999 Showcase 1190000-1199999 Enterprise Integration Services 1200000-1200999 Calculator framework Using Analytic Server and Application Logs The following topics describe the actions you can perform on server and application logs. Setting the Type of Analytic Server Messages Logged Setting the Type of Application Messages Logged Viewing the Analytic Server and Application Logs Clearing the Analytic Server and Application Logs Immediately Clearing the Analytic Server and Application Logs Upon Restart Setting Delimiters in the Analytic Server and Application Logs Analyzing Logs with Log Analyzer For a comprehensive discussion of server and application logs, see Analytic Server and Application Logs . For information about specific error messages, see the Error Messages Guide in \\docs\\errmsgs\\erhelp.htm in the Essbase installation. You can also view logs using Administration Services. For more information, see About Log Viewer in Essbase Administration Services Online Help . Setting the Type of Analytic Server Messages Logged By default, the Analytic Server log, ARBORPATH \\essbase.log , lists the following types of messages: Information messages, such as notification of a user action or information about an application or database In the following example, the admin user logged out. [Sun Oct 21 16:00:55 2001]Local/ESSBASE0\/\//Info(1051037) Logging out user admin, active for 144 minutes Warning messages, such as a notification that an operation was not completed Warnings often follow errors. In the following example, the rename operation did not complete due to a previous error in the log. [Fri Nov 02 13:38:14 2001]Local/ESSBASE0\/\//Warning(1051003) Error 1051031 processing request [Rename Application] - disconnecting Error messages, such as trying to perform an action that Analytic Server cannot perform. In the following example, the rename operation failed because the application name already existed. [Fri Nov 02 13:38:14 2001]Local/ESSBASE0\/\//Error(1051031) Application Testing already exists This table lists the settings that you specify in the essbase.cfg file to determine what types of messages Analytic Server writes to the Analytic Server log. If you change an essbase.cfg setting, restart Analytic Server to apply the change. Setting Definition For More Information AGENTLOGMESSAGELEVEL An essbase.cfg setting that determines whether Analytic Server writes all messages, warning messages, or error messages to the Analytic Server log Technical Reference PORTUSAGELOGINTERVAL An essbase.cfg setting that specifies how often to check the number of ports in use. Technical Reference Setting the Type of Application Messages Logged By default, the application log, ARBORPATH \\app\\ application_name \\ application_name .log , lists the following types of messages: Information messages that detail routine actions that Analytic Server performs In the following example, Analytic Server writes the amount of time elapsed during a data load to the application log: [Fri Nov 02 13:04:15 2001] Local/Sample/Basic/admin/Info(1003024) Data Load Elapsed Time : [3.014] seconds Warning messages that list conditions that are not deemed serious by Analytic Server In the following example, Analytic Server writes a statement that no data values were changed during a data load to the application log: [Fri Nov 02 12:43:44 2001] Local/Sample/Basic/admin/Warning(1003035) No data values modified by load of this data file Error messages that describe errors that occurred while performing the task Error messages can range from serious, such as a file not loading correctly, to very serious, such as a disk space error that causes Analytic Server to crash. In the following example, Analytic Server writes a statement to the application log indicating that a data value was encountered before all dimensions in the outline were specified: [Fri Nov 02 12:53:32 2001] Local/Sample/Basic/admin/Error(1003007) Data Value [678] Encountered Before All Dimensions Selected, [2] Records Completed This table lists settings that you specify in the essbase.cfg file and a command that you can use in a calculation script to determine what types of messages Analytic Server writes to the application log. If you change an essbase.cfg setting, restart Analytic Server to apply the change. Table 47: Setting Messages in the Application Log  Setting Definition For More Information LOGMESSAGELEVEL An essbase.cfg setting that determines whether Analytic Server writes all messages, warning messages, or error messages to the application log Technical Reference TIMINGMESSAGES An essbase.cfg setting that determines whether Analytic Server writes the duration of each spreadsheet and report query to the application log Technical Reference SSLUNKNOWN An essbase.cfg setting that determines whether Analytic Server writes error messages when it encounters an unknown member name during a spreadsheet operation to the application log Technical Reference SET MSG A calculation script setting that determines whether Analytic Server writes the following items to the application log during the duration of the calculation script: A summary of calculation statistics Detailed calculation statistics All messages, warning messages, error messages, or no messages Technical Reference Viewing the Analytic Server and Application Logs When you view a log, you are viewing a snapshot. To view an updated version of a log, close and reopen the log. You can choose to view a log from a specific date to the present or to view the entire log. You must have Supervisor permissions to view Analytic Server logs, and you must have at least Application Designer permissions to view application logs. To view a server or application log, use either of the following methods: Tool Topic Location Administration Services Viewing Logs Essbase Administration Services Online Help Any text editor &#160; (See the documentation for the text editor.) Clearing the Analytic Server and Application Logs Immediately The server and application logs use disk space on the server. Occasionally, you may need to clear entries from a log before it grows too large. Clearing the server log removes all entries in the log, but does not remove the server log itself. Clearing the application log removes all the entries in the application log and deletes the application log itself. Be sure to back up each log before you clear it. You must have Supervisor permissions to clear server and application logs. To clear a server or application log immediately, use any of the following methods: Tool Topic Location Administration Services Deleting Logs Essbase Administration Services Online Help MaxL To clear the Analytic Server log: alter system clear logfile; To clear the application log: alter application application_name clear logfile; Technical Reference ESSCMD To clear the server log: DELETELOG ; To delete the application log: DELETELOG application_name ; Technical Reference Note: To clear a server or application log each time the server or application restarts, see Clearing the Analytic Server and Application Logs Upon Restart . To conserve space by limiting the items logged in the Analytic Server log or application log, see Setting the Type of Analytic Server Messages Logged or Setting the Type of Application Messages Logged . Clearing the Analytic Server and Application Logs Upon Restart By default, Analytic Server appends messages to the end of the server and application logs. As described in Table48 , you can set Analytic Server to clear the Analytic Server log each time the server is restarted or the application log each time the application is restarted. If you change the essbase.cfg file, restart Analytic Server to apply the change. Table 48: Clearing the Server and Application Logs upon Restart Setting Description For More Information CLEARLOGFILE An essbase.cfg setting that, when set to TRUE, clears the Analytic Server log each time Analytic Server restarts and the application log each time the application restarts Technical Reference Note: To clear a server or application log without restarting the server or application, see Clearing the Analytic Server and Application Logs Immediately . To conserve space by limiting the items logged in the Analytic Server log or application log, see Setting the Type of Analytic Server Messages Logged or Setting the Type of Application Messages Logged . Setting Delimiters in the Analytic Server and Application Logs You can change the symbol used to delimit log entries for server and application logs. Changing the delimiter also affects messages logged in the server console window. By default, Analytic Server uses spaces to delimit fields in a log, as in the following example: [Thu May 10 20:14:46 2001]Local/ESSBASE0\/\//Info(1051051) Hyperion Essbase Analytic Server - started You can also use tildes, carets, colons, ampersands, or asterisks to delimit the entries in the server and application logs. If possible, choose a delimiter that does not occur frequently in the data, application, or database. The following example shows a log entry delimited by tildes (~): Thu~May~10~20:16:13~2001~Local~ESSBASE0~~~Info~(1051051)~ \\\\ Hyperion Essbase Analytic Server - started Note: If you set delimiters to anything other than spaces, you can no longer sort the log entries by date in Log Viewer. This table lists settings that you specify in the essbase.cfg file to determine the delimiters that Analytic Server uses in the server and application logs. If you change an essbase.cfg setting, restart Analytic Server to apply the change. Setting Description For More Information DELIMITEDMSG An essbase.cfg setting that, when set to TRUE, adds a tilde (~) between each field in the server and application logs To specify a different delimiter, use the DELIMITER setting. Technical Reference DELIMITER An essbase.cfg setting that specifies the delimiter used between each field in the server and application logs Analytic Server enables you to use the following characters as log delimiters: tilde (~), the default delimiter; caret (^); colon (:); ampersand (&amp;); and asterisk (*). The DELIMTER setting only works when DELIMITEDMSG is set to TRUE. Technical Reference Analyzing Logs with Log Analyzer You can use Log Analyzer to filter, search, and analyze Analytic Server logs and application logs. Based on filters you choose or create, you can view robust graphical charts for a log. An auto-refresh option enables you to monitor log information dynamically. To use Log Analyzer, see About Log Analyzer in Essbase Administration Services Online Help . Using Application Log to Monitor Memory Use Essbase enables memory management by providing controls on the maximum amount of memory an application can use. Essbase also writes messages to an application log as soon as the application's memory use exceeds 90% of the limit that you set. After the limit is met 100%, Analytic Server stops the application. To enable Analytic Server to manage application memory use: Create a new memory configuration file, config.mem , containing the MEMORYLIMIT setting, or edit an existing memory configuration file. Save the memory configuration file in the ARBORPATH /bin directory. Start the application. You must restart an application after you change its memory configuration file because the application reads the memory configuration file only once during start up. Monitor the log. When 90% of the value in the memory configuration file is reached, Analytic Server writes the following warning message to the application log: Application is using [ n ] bytes of memory. It is more than 90 percent of the limit set in the memory config file. If the application uses 100% of the memory as limited by the memory configuration file, Analytic Server writes the following error message to the application log and stops the application: Application is using [n] bytes of memory, and is requesting a new memory block of [n] bytes. The memory has exceeded the limit. When the 90% warning messages are displayed in the log, the database administrator may wish to take corrective action: Increase the memory limit in the relevant memory configuration file and restart the application if more memory is available. Examine cache sizes and reduce the size if possible. If neither of these actions is possible or resolves the memory problem, work loads or applications may require additional adjustments or tuning. For more information about the memory configuration file and MEMORYLIMIT setting, see the Technical Reference . Implementing Query Logs Query logging provides a way for Essbase administrators to track query patterns of an Essbase database. The query log file tracks all queries performed against the database regardless of whether the query originated from Spreadsheet Add-in or Report Writer. Query logging can track members, generation or level numbers of members belonging to specific generations or levels, and Hybrid Analysis members. Query logging also offers the flexibility to exclude logging of certain dimensions and members belonging to generations or levels. Because the query log file output is an XML document, you can import the log file to any XML-enabled tool to view the log. For details about the query log file structure, refer to querylog.dtd in the ARBORPATH /bin directory. To enable query logging, create a query configuration file (distinct from the essbase.cfg file) and add to the file the configuration settings that control how query logging is performed. In the ARBORPATH \\App\\ appname \\ dbname directory of Essbase, create a query log configuration file. The configuration file must be named dbname.cfg , where dbname matches the name of the database. For example, the query log configuration file for Sample Basic is basic.cfg . The output query log file is located at, by default, ARBORPATH \\App\\ appname \\ dbname 00001.qlg . For more information about query logging and how to set up the query log configuration file, see the Technical Reference . Understanding and Using the Outline Change Log You can set Analytic Server to create an outline change log that saves outline modification information to a text file. You can review the outline change log at any time to see all the changes that have been made to an outline since the log was first created. This information helps you to roll back an outline to a previous version. The outline change log is a text file in the ARBORPATH \\app\\ application_name \\ database_name directory named database_name .olg . For the Sample Basic database, for example, the outline change log is hyperion\\essbase\\app\\sample\\basic\\basic.olg . The following topics describe the outline change log and the actions that you can perform on it. Understanding the Contents of the Outline Change Log Reviewing an Example of an Outline Change Log Creating Outline Change Logs Viewing Outline Change Logs Setting the Size of the Outline Change Log Understanding the Contents of the Outline Change Log You can set Analytic Server to write changes to the outline to ARBORPATH \\app\\ application_name \\database_name\\ database_name .olg . This table lists the types of actions written to the outline change log and the information included in the log message. Table 49: Outline Change Log Contents  Type of Change Information Included Add a dimension Name of dimension Type of dimension (dense or sparse) Dimension tag (if any) Name of left sibling of dimension (if any) Level number of dimension Generation number of dimension Delete a dimension Name of dimension Update a dimension Name of dimension Dimension tag Type of dimension (dense or sparse) Level name changes (if applicable) Generation name changes (if applicable) Rename a dimension Old name of dimension New name of dimension Move a dimension to a new position Name of dimension Old location, including left sibling of dimension New location, including left sibling of dimension Add a member to a dimension Name of new member or members Unary calculation symbol for member Level number of member Generation number of member Status of member (Store, Share) Member alias (if applicable) Account type of member (if applicable) User-defined attributes of member (if applicable) Calculation formula for member (if applicable) Update a member of a dimension Name of member updated Member properties that were updated Rename a member of a dimension Old name of member New name of member Move a member of a dimension to a new position Name of member moved New location Names of parent and left sibling in new location The outline change log program reads outline information from left to right. If you are looking at an outline, the left sibling is the sibling directly above (to the left of) the newly added dimension or member. This rule does not apply if the immediately preceding dimension or member is a parent . If a newly added (or moved) member is the first child of its parent or if the member is the first dimension in the outline, the outline change log identifies the old location of the dimension or member as None. Reviewing an Example of an Outline Change Log When a user makes and saves changes to an outline, Analytic Services writes the change information into the outline change log as a group of entries. Each group of entries begins and ends with identifying information so that you can easily identify each revision, from newest to oldest. Figure227 shows one record, indicating that since the outline change log was started, the outline was modified once. First, the outline change log lists the beginning of the change, including the application and database changed; the time of the change; and the user making the change. Next, the outline change log lists the change-a member named 100-50 was added to 100 member of the Product dimension. Finally, the outline log lists the end of the change, including the application and database changed; the time of the change; and the user making the change. Figure 227: Sample Outline Change Log [Begin Outline Change for Sample/Basic, Sat Nov 03 12:49:31 2001, By admin] Number of member changes for dimension Product : 1 Added new member 100-50 to 100 : Left sibling - 100-40 Status - Store Data Added alias Cherry Cola to alias table Default Unary calc symbol - Add Level Number - 0 Generation Number - 3 [End Outline Change for Sample/Basic, Sat Nov 03 12:49:32 2001, By admin] Creating Outline Change Logs By default, Analytic Server does not create an outline change log. Table50 lists the setting that you specify in the essbase.cfg file to create an outline change log. If you change an essbase.cfg setting, restart Analytic Server to apply the change. Table 50: Creating an Outline Change Log Using essbase.cfg Setting Description For More Information OUTLINECHANGELOG An essbase.cfg setting that, when set to TRUE, creates an outline change log Technical Reference Note: During a restructure, Analytic Services holds outline change information in memory until all updates have been made to the outline change log. Turning on the outline change log may, therefore, affect restructure performance. Conditions Affecting Database Restructuring discusses other conditions that affect restructure performance. Viewing Outline Change Logs Because the outline change log is an ASCII text file, you can view it by opening it in any text editor. The outline change log is located in the ARBORPATH \\app\\ application_name \\ database_name directory and is named database_name .olg . For the Sample Basic database, for example, the outline change log is located in hyperion\\essbase\\app\\sample\\basic\\ basic.olg . Setting the Size of the Outline Change Log The default size for the outline change log is 64,000 bytes. When the log reaches this size, Analytic Services copies the contents of database_name .olg to a new file with the .olb extension. For example, when basic.olg reaches 64,000 bytes the contents are copied to basic.olb . After this copy, basic.olg is cleared. New log entries are written to basic.olg . Each time the outline change log reaches its maximum file size, Analytic Services writes over the existing database_name .olb with the current database_name . olg . Retrieve information from database_name .olb before database_name . olg fills up. The default, minimum, and maximum file sizes for the database_name .olb file are the same as the corresponding defaults specified for the database_name .olg file. For example, if you change the maximum size of the outline change log to 2MB, you automatically set the .olb file to the same maximum size. Table51 lists the setting that you specify in the essbase.cfg file to set the size of the database_name .olg file. If you change an essbase.cfg setting, restart Analytic Server to apply the change. Table 51: Setting the Outline Change Log Size Using essbase.cfg Setting Instructions For More Information OUTLINECHANGELOGFILESIZE An essbase.cfg setting that determines the size of the outline change log, database_name .olg Technical Reference Understanding and Using Exception Logs When an Analytic Server, an application, or a database shuts down abnormally, Analytic Server sometimes creates an exception log as a text file named log0000 n .xcp . The following topics describe the server, application, and database exception logs and the actions that you can perform on them. Understanding the Contents of Exception Logs Reviewing an Example of an Exception Log Viewing Exception Logs Overwriting or Retaining Existing Logs Understanding the Contents of Exception Logs If an Analytic Server, an application, or a database shuts down abnormally and cannot restart, Analytic Server generates an exception log to help troubleshoot the problem. The location of the exception log depends on the component that shut down abnormally and the amount of information that Analytic Server had available at the time of the abnormal shutdown. Table53 describes the location of the exception log for each type of abnormal shutdown. This table lists the sections of the exception log and the information included in each section. If Analytic Server could not retrieve all the information before the shutdown finished, some of the later sections may be blank. Table 52: Contents of the Exception Log (log00001.xcp)  Section of Log Information Included General information Date and time Application and database name Location of exception log Process type Use this information to determine which component shut down abnormally, and when it shut down. Machine registers and stack information General registers Floating point registers Hex registers Stack trace Stack dump Hyperion Technical Support can examine this section of the log to assist in determining why an abnormal shutdown may have occurred. Application-wide configuration Server and application name Elapsed application time; that is, how long the application was running List of modules Use this information to determine if the application shut down quickly and that all modules are correct. More information about modules is in the system-wide configuration section of the exception log. Operating system resources System date and time Elapsed operating system time; that is, how long the operating system was running Resource information, including CPU type, memory information, swap information, and drive information Use this information to see if it is an operating system problem, such as a lack of memory. System-wide configuration Elapsed Essbase time; that is, how long Essbase was running Essbase release information Network information Environment variables Module information, including module name and release Use this information to make sure that the release is the same for Essbase and each module, and the environment variables are set correctly. essbase.cfg values Values of all settings in the essbase.cfg file Use this information to make sure that Analytic Server is configured correctly. License information Serial number and license expiration date Number of ports purchased and ports in use Essbase options enabled Other Hyperion products enabled Use this information to make sure that the correct options of Essbase are installed and that you have purchased enough ports. Client request activity Server name Application name Thread information, including the number of threads Request information Detailed information about each thread, including the action it is performing, the database, username, start time, and end time Use this information to see how heavy the load on the server was, based on client requests. File information Page file size Index file size Use this information to determine whether the page file or the index is too large. Database information Use this information to make sure that the database is set up correctly. Database statistics Use this information to view dimension information and to see characteristics of data blocks in the database. Reviewing an Example of an Exception Log The following example is of an exception log. The first section of the log lists general information about the application and database. In this example, the Analytic Server shut down: ----- Exception Error Log Begin ----- Current Date &amp; Time: Sat Nov 24 13:25:13 2001 Process Type: Server Application Name: Sample Database Name: Basic Exception Log File: C:\\HYPERION\\ESSBASE\\log00001.xcp Current Thread Id: 1116 Exception Code: 0xC0000005=Access Violation Exception Flags: 0x00000000=Continuable Exception Address: 0x002D2249 Exception Parameters: 2 Exception Parameter 0: 0x00000000=Read Violation Exception Parameter 1: 0x0000220A (Virtual Address) The next section of the log lists register and stack trace information. Hyperion Technical Support can examine this section of the log to assist in determining why an abnormal shutdown may have occurred. ----- Machine Registers ----- General Registers: EAX=0x00000000 EBX=0x01358008 ECX=0x00002200 Control Registers: CS =0x0000001B EIP=0x002D2249 Flg=0x00010202 Segment Registers: DS =0x00000023 ES =0x00000023 FS =0x00000038 Floating Point Registers: CWD=0xFFFF027F SWD=0xFFFF0000 TWD=0xFFFFFFFF Register Area (Hex): 00 00 00 00 00 00 00 00 00 00 ...continued hexadecimal listings... Debug Registers: DR0=0x2F75C73B DR1=0x75E07D39 DR2=0x1475FF16 DR3=0x00000000 DR6=0x0000E00B DR7=0x00000000 ----- Stack ----- Stack Trace: 0: 0x002D2249 1: 0x002D202D ...continued stack trace listings... Stack Dump (Hex): (Stack dump truncated from 1397 to 1024 bytes.) 0x0012EA2C: 00000000 01358008 01358008 FFFFFFFF 0x0012EA3C: 00002200 002D728C 0012EC6C 002D202D ...continued stack dump listings... The following section of the log lists application information: ----- Application-Wide Configuration ----- Server Name: ASPEN Application Name: Sample Elapsed App Time: 00:00:01:28 Module Count: 6 Module 0: 0x00241000 = C:\\HYPERION\\ESSBASE\\BIN\\ESSSEC.DLL Module 1: 0x002C1000 = C:\\HYPERION\\ESSBASE\\BIN\\ESSNET.DLL ...continued module listings... The following section of the log lists operating system information. You can determine how much memory is available, how much swap space is used, and how much memory is available on each drive: ----- Operating System Resources ----- System Date &amp; Time: Sat Nov 24 13:25:13 2001 Elapsed OS Time: 02:03:03:10 OS Name &amp; Version: Windows NT 5.00 CPU Count: 1 CPU Type: Pentium Total Physical Memory: 327024 KB (334872576) Free Physical Memory: 155760 KB (159498240) Used Physical Memory: 171264 KB (175374336) Swap Flags: Enabled: Y Disabled: N File Found: Y Denied: N Swap file(s): C:\\pagefile.sys Total Swap Space: 467192 KB (478404608) Free Swap Space: 421528 KB (431644672) Used Swap Space: 45664 KB (46759936) Total Drives: 5 Current Drive: 3 Drive 1: Drive Name: C Volume Label: Drive Type: Fixed File System: NTFS Total Drive Space: 11778448 KB Free Drive Space: 8592548 KB Used Drive Space: 3185900 KB ...continued drive listings... The following section of the log lists system configuration information, such as paths or essbase.cfg settings: ----- System-Wide Configuration ----- Elapsed Essbase Time: 00:00:01:33 Essbase Version: 6.2.0 Essbase Description: Ess62P0B128 Network Type: Windows Sockets Environment Variable: ARBORPATH = C:\\HYPERION\\ESSBASE Environment Variable: ARBORMSGPATH = C:\\HYPERION\\ESSBASE\\bin Module Count: 13 Module 0: Module Name: C:\\HYPERION\\ESSBASE\\BIN\\ESSUTL.DLL Module Version: 6.2.0.1 Module Description: Ess62P0B128.1 Module Use Count: 5 ...continued module listings... ----- ESSBASE.CFG Configuration Values ----- Configuration Value: JvmModuleLocation = C:\\Hyperion\\Essbase\\java\\jre13\\bin\\hotspot\\jvm.dll Configuration Value: AuthenticationModule = LDAP essldap.dll x Configuration Value: OUTLINECHANGELOG = TRUE The following section of the log lists license information (such as a serial number), the Essbase options (such as ports purchased), and Hyperion products purchased (such as Enterprise Integration Services): ----- License Information ----- Serial Number: xxx License Expiry Date: Port Count: 10 Ports In Use Count: 0 Limited Use Version: N Read-Only SS: N ...continued Essbase options and Hyperion product listings... The following section of the log lists client activity, such as using Administration Services to view databases or using the Spreadsheet Add-in to view databases: ----- Client Request Activity ----- Server Name: ASPEN Application Name: Sample Total Request Threads: 5 Avail Request Threads: 6 Total Requests: 56 Average Requests: 48.000000 Weighted Average: 7.440000 Statistics Per Minute: Current Requests: 48 Minimum Requests: 48.000000 Maximum Requests: 48.000000 Thread Count: 5 Thread Id 1444: Request Name: List Objects Database Name: Basic User Name: admin Start Time: Sat Nov 24 13:24:37 2001 End Time: Sat Nov 24 13:24:37 2001 ...continued thread listings... ----- Exception Error Log End ----- Viewing Exception Logs Because the exception change log is an ASCII text file, you can view it by opening it in any text editor. The location of the exception log depends on the component that shut down abnormally and the amount of information that Analytic Server had available at the time of the abnormal shutdown. This table describes the location of the exception log. Table 53: Location of the Exception Log Component That Shut Down Location of the Exception Log Analytic Server The log is in the ARBORPATH directory; for example, d:\\essbase\\log00001.xcp Application If the application name is unknown, the log is in the ARBORPATH \\app directory; for example, d:\\essbase\\app\\log00001.xcp If the application name is known, the log is in the application directory; for example, if the Sample application shut down abnormally, d:\\essbase\\app\\Sample\\log00001.xcp Database If the database name is unknown, the log is in the application directory; for example, if the Basic database shut down abnormally: d:\\essbase\\app\\sample\\log00001.xcp . If the database name is known, the log is in the database directory; for example, if the Basic database shut down abnormally, d:\\essbase\\app\\sample\\basic\\log00001.xcp Overwriting or Retaining Existing Logs By default, Analytic Server creates one or more new exception logs each time it shuts down abnormally. Subsequent exception logs are numbered sequentially; for example, if log00001.xcp exists, the next log is named log00002.xcp , the next is log00003.xcp , and so on. You can change a setting in the essbase.cfg file to overwrite the existing exception log instead of creating a new log. If you change an essbase.cfg setting, restart Analytic Server to apply the change. Hyperion recommends that you use the default setting of FALSE. An abnormal shutdown may create multiple exception logs and the first log created during the shutdown is often the most descriptive. Use this table for more information about creating new exception logs: Setting Description For More Information EXCEPTIONLOG OVERWRITE An essbase.cfg setting that, when set to FALSE, creates a new exception log. When set to TRUE, Analytic Server overwrites the existing exception log. Technical Reference Understanding and Using Dimension Build and Data Load Error Logs Analytic Server writes errors that occur during a dimension build or data load in error logs. The log that Analytic Server chooses for errors depends on the operation that you perform, such as a dimension build or a data load, and how you perform it, such as using Administration Services, or MaxL. The following topics describe the location of dimension build and data load errors and the actions that you can perform on dimension build and data load error logs: Understanding and Viewing Dimension Build and Data Load Error Logs Reviewing an Example of a Dimension Build and Data Load Error Log Setting the Maximum Number of Errors Loading Dimension Build and Data Load Error Logs Understanding and Viewing Dimension Build and Data Load Error Logs The dataload.err log contains errors that occurred during a dimension build or a data load. The logs also contain the records that failed to load. After you fix the errors, you can reload the logs. For instructions, see Loading Dimension Build and Data Load Error Logs . Analytic Server writes errors that occur during a dimension build or data load to the following error logs: Table 54: Location of Dimension Build and Data Load Errors Operation Location of Error Log Dimension build ARBORPATH \\client\\dataload.err Data load with a rules file ARBORPATH \\client\\dataload.err Data load without a rules file ARBORPATH \\app\\ application_name \\ application_name .log Note: If the data load or dimension build fails and there is no error log, see Checking Error Logs for a description of possible causes. To set the location and file name of dimension build and data load error logs, see Performing a Data Load or Dimension Build for Block Storage Databases or Performing a Data Load or Dimension Build for Aggregate Storage Databases in the Essbase Administration Services Online Help . To view the dimension build and data load error logs, open them in any text editor. Reviewing an Example of a Dimension Build and Data Load Error Log Figure228 shows an entry in a data load log. The 500 member did not exist in the outline, so no data was loaded to it. Figure 228: Error Message in the Data Load Log \\\\ Member 500 Not Found In Database 500 500-10 500-10-10 To solve this problem, you can perform either of the following actions and then restart the load: Perform a dimension build to create the missing member. For references to instructions, see Performing Data Loads or Dimension Builds . Add the missing member in Outline Editor. For a discussion of rules and for instructions, see Adding Dimensions and Members to an Outline . Figure229 shows an entry in a dimension build log. The 600-20 member is not the parent of the 600 member. Make sure that you use the correct rules file with the correct text file. The record looks like it is for a level (bottom-up) build, but the error message indicates that Analytic Server is trying to perform a generation (top-down) build. When you correct the problem, restart the dimension build. Figure 229: Error Message in the Dimension Build Log \\\\Record #2 - Incorrect Parent [600-20] For Member [600] (3307) 600-20-10 600-20 600 Setting the Maximum Number of Errors The default size of the dataload.err files is 1,000 records. When the log reaches this size, Analytic Server does not write any other errors that it encounters to the log. The dimension build or data load, however, continues. Any subsequent errors are lost. You can set Analytic Server to write 1 to 65,000 records in the dataload.err files. If you change the essbase.cfg file, restart Analytic Server to apply the change. Table 55: Setting the Number of Error Records Setting Description For More Information DATAERRORLIMIT An essbase.cfg setting that determines the number of records logged in the dataload.err log Technical Reference Loading Dimension Build and Data Load Error Logs If the dimension build or data load fails, you must determine whether the Isolation Level transaction setting is Committed or Uncommitted. If the Isolation Level transaction setting is Committed, you must restart the data load from the beginning. If the Isolation Level is Uncommitted, you can load only the records that failed by loading the error log. Only reloading the failed records is much faster than reloading every record, including those records that succeeded during the first load. To reload the error log, perform the following steps: If you load from the server, change the file extension from .err to .txt . For example, change the dataload.err file to dataload.txt . If you load from the client, you can leave the .err extension. Fix the problem that caused the dimension build or data load to fail. Fixing the problem might involve changing the outline, the text in the error log, or the rules file. Check to see if the following conditions are true: Can you validate the rules file? See Validating, Saving, and Printing . Is the data source available? See Verifying That the Data Source Is Available . Is the server available? See Verifying That Analytic Server Is Available . Load the error log using the appropriate rules file. For more information, see Understanding Data Loading and Dimension Building.  |../dlogs.htm",
    "Using MaxL Data Definition Language||This chapter describes MaxL DDL, the data definition language for Analytic Services. MaxL is a flexible way to automate Analytic Services administration and maintenance tasks. MaxL DDL improves upon ESSCMD in that it is a multi-dimensional access language for Analytic Services. Using MaxL, you execute Analytic Services operations using a language-like interface, rather than a series of commands with complicated arguments. MaxL scripts can be developed flexibly to accommodate many uses, and the language is easy to learn. MaxL includes a Perl module that enables you to embed its statements in Perl programs. This chapter contains the following sections: The MaxL DDL Language discusses core language elements. The MaxL Shell describes how to use the shell interface. The MaxL Perl Module describes the optional Perl interface. For comprehensive coverage of MaxL syntax, see the MaxL DDL section of the Technical Reference . The MaxL DDL Language The MaxL data definition language is an interface for making administrative requests to Analytic Services using statements . Using MaxL, you can easily automate administrative operations on Analytic Services databases. You can write MaxL scripts with variables to make them customizable and re-usable. In order for Analytic Services to receive and parse MaxL statements, you must pass them to the Analytic Server using either the MaxL Shell ( essmsh ), Administration Services, or a customized Perl program that uses the MaxL Perl Module. Use this section to learn more about the language: Overview of Statements Components of Statements Analysis of Statements Overview of Statements All MaxL DDL scripts and interactive sessions consist of a login and a sequence of statements. Each statement is terminated by a semicolon. Statements consist of grammatical sequences of keywords and variables. A statement looks similar to an English sentence; for example, create or replace user &lt;user-name&gt; identified by &lt;password&gt;; MaxL statements always begin with a verb, such as create or alter . Verbs indicate what type of operation you want to perform. After the verb, you specify an object. Objects, such as database or user , indicate the Analytic Services elements you are working with. After the object specification, the rest of the statement is for giving more details about the action you wish to perform. This is done using a grammatically correct sequence of statement-parts, or tokens . To get an overall picture of the grammar requirements and the verb-object structure of MaxL statements, see the MaxL DDL section of the Technical Reference . Components of Statements The MaxL parser recognizes and requires an ordered presentation of tokens , and these are the components of statements. A token is a space-delimited sequence of valid characters that is recognized by MaxL as a single readable unit. Tokens can be any of the following: Keywords Names Strings Numbers Keywords Keywords are the reserved words that make up the MaxL vocabulary. These include verbs, objects, and other words needed to construct statements. Keywords in MaxL are independent of your data: conversely, all other MaxL tokens (names, for example) must be defined by you. The MaxL parser expects to see MaxL keywords and other tokens in their correct grammatical order, as diagrammed in the MaxL DDL section of the Technical Reference . In the following sample syntax diagram from the Technical Reference , only the lower-cased words in the diagram represent keywords. The other elements are placeholders for names or values that you provide. Figure 234: Example of MaxL Syntax Diagram: Alter Filter Note: Keywords are not case-sensitive; the use of lower case for keywords is a documentation convention. For more information about how to interpret the diagrams, see How to Read MaxL Railroad Diagrams in the online Technical Reference . Names Names in MaxL are used to uniquely identify databases and database objects, such as users, applications, or filters. Rules for Names Unless you enclose a MaxL name within single quotation marks, a MaxL name is a string that must begin with an alphabetic character or the underscore. Names that are not enclosed in quotation marks may contain only alphabetic characters, numbers, and the underscore. When enclosed in single quotation marks, a name may contain white space and any of the following special characters: .,;:%$'*+-=&lt;&gt;[] ()?!/\\ ~`#&amp;@^ Note: Any name that is also a MaxL keyword must be enclosed in single quotation marks. For a list of keywords, see the Reserved Words List in the MaxL DDL section of the Technical Reference . Examples: The following application names do not require single quotation marks: Orange Orange22 _Orange The following application names do require single quotation marks: Orange County (contains a space) 22Orange (begins with a number) variable (is a MaxL keyword) Types of Names Some Analytic Services objects have single names, and some require compound names known as doubles and triples , which express the nesting of namespaces. The three possible ways to name Analytic Services objects are with a singleton name, a double, or a triple. A singleton name is a name that can be meaningful in a system-wide context: the object to which it refers may be global to Analytic Services, or, for whatever reason, it needs no application or database context to be specified. For example, an application has a singleton name because it does not need to be considered in the context of another application or a database. A double is two names connected by a period, and a triple is three names connected by two periods. Doubles and triples show the inherited namespace of the named entity. For example, a database is usually identified using two names. The first name identifies the application in which the database resides. The second name is the database's own name. Therefore, a database name could look like this: Sample.Basic Database objects, such as filters, are usually identified using triple names: the first two names identify the application and database, and the third name is the object's own name. Therefore, a filter name could look like this: sample.basic.filter3 . The following table shows what type of name is required for the most common objects, and provides an example of the name used in a statement. Object Name Example User singleton create user Fiona identified by 'password'; Group singleton alter user Fiona add to group Managers ; Host singleton drop replicated partition Samppart.Company from Sampeast.East at EastHost ; Application singleton create application ' &amp;New App '; Database double display database ' &amp;New App ' .testdb ; Calculation triple drop calculation Sample.basic. ' alloc.csc '; Filter triple display filter row sample.basic.filter1 ; Function (local) double drop function sample.'@COVARIANCE' ; Function (global) singleton create function ' @JSUM' a s 'CalcFnc.sum'; Location alias triple drop location alias Main.Sales.EasternDB ; Role singleton grant designer on database Sample.basic to Fiona; Substitution variable singleton alter system add variable Current_month ; alter system set variable Current_month July; Disk volume singleton to define, triple to display alter database AP.main1 add disk volume G ; alter database AP.main1 set disk volume G partition_size 200mb; display disk volume sample.basic.C ; Strings Strings are used in MaxL statements to represent the text of comments, member expressions, calculation scripts, and file references. Strings can begin with any valid character. As with names, strings containing whitespace or special characters must be enclosed in single quotation marks. See Rules for Names for a list of valid special characters. The following table shows examples of statement elements that are strings: Type of String Example Password create user Fiona identified by sunflower ; Comment alter group Financial comment ' Reports due July 31 '; Member expression create filter sample.basic.filt1 read on ' Sales, @ATTRIBUTE(Bottle) '; create or replace replicated partition sampeast.east area ' @IDESC(East), @IDESC(Qtr1) ' to samppart.company mapped globally ' (Eastern Region) ' to ' (East) '; Body of a calculation execute calculation ' Variance=@VAR(Actual, Budget); Variance %=@VARPER(Actual, Budget); ' on Sample.basic; File reference spool on to ' /homes/fiona/out.txt '; Numbers You use numbers in MaxL statements to change certain database settings in Analytic Services. For example, you can change cache and buffer sizes, or set system-wide intervals such as the number of days elapsing before users are required to change their passwords. To change numeric settings, you can use positive integers, positive real numbers, and zero. Decimals and scientific notation are permitted. Examples: 1000 2.2 645e-2 For size settings, units must follow the number. Spaces in between numbers and units are optional. Units are case-insensitive, and may include the following: B/b (bytes), KB/kb (kilobytes), MB/mb (megabytes), GB/gb (gigabytes), and TB/tb (terabytes). If no units are given, bytes are assumed. Examples: 1000 b 5.5GB 645e-2 mb 145 KB 2,000e-3TB Analysis of Statements This section helps you review what you have learned about statements by illustrating some MaxL statements and their components, in template form. In the diagrams, lower-cased words are keywords, and words in upper-case are intended to be replaced with the appropriate values, as shown in the example following each illustration. Altering a Database Figure 235: MaxL statement to change data file cache size Example: alter database Sample.Basic set data_file_cache_size 32768KB; Granting a Permission Figure 236: MaxL statement to grant application permissions to a user Example: grant designer on application Sample to Fiona; Creating a Calculation Figure 237: MaxL statement to create a stored calculation Example: create calculation sample.basic.varcalc 'Variance=@VAR(Actual, Budget); Variance %=@VARPER(Actual, Budget);' ; The MaxL Shell This section shows you how to get started using the most of the features of the MaxL Shell. For more complete information and examples, see the MaxL DDL &gt; MaxL Shell section of the Technical Reference . This section contains the following topics: Starting the MaxL Shell Logging In to Analytic Services Command Shell Features Stopping the MaxL Shell This section does not discuss the Administration Services MaxL Script Editor. If you are using MaxL Script Editor, you can skip the rest of this chapter and refer instead to the Essbase Administration Services Online Help . Starting the MaxL Shell The MaxL Shell can be invoked to take input in any of the following ways: Interactively, from the keyboard From a MaxL script file (statements are read from the file specified on the command line) From standard input that is piped to the MaxL Shell from the output of another program The MaxL Shell also accepts any number of command-line arguments at invocation time. These can be used with positional parameters to represent any name, or a password. This topic contains the following sections: Starting the Shell for Interactive Input Starting the Shell for File Input Starting the Shell for Programmatic Input Starting the Shell for Interactive Input To enter MaxL statements interactively at the command line, simply invoke the shell at your operating-system prompt. Text you type is indicated by bold text. For example, essmsh Analytic Services MaxL Shell Release 7.0.0 (c) Copyright 2000-2003 Hyperion Solutions Corporation. All rights reserved. To enter MaxL statements interactively after logging in at invocation time, use the-l flag. For example, essmsh -l Admin password Analytic Services MaxL Shell Release 7.0.0 (c) Copyright 2000-2003 Hyperion Solutions Corporation. All rights reserved. 49 - User logged in: [Admin]. To enter MaxL statements interactively and also supply command-line arguments to represent variables you will use in your interactive session, use the -a flag. For example, essmsh -a Admin password Sample Basic Analytic Services MaxL Shell Version 7.0.0 (c) Copyright 2000-2003 Hyperion Solutions Corporation. All rights reserved. login $1 $2; 49 - User logged in: [admin]. alter database $3.$4 enable aggregate_missing; 72 - Database altered: ['sample'.'basic']. In the above example, $1, $2, $3, and $4 are positional parameter variables: they represent whatever arguments were entered after essmsh at invocation time, in the order they were entered. Starting the Shell for File Input To invoke the MaxL Shell to take input from a MaxL script file, type essmsh followed by the name of a MaxL script in the current directory, or, the full path and file name of a MaxL script in another directory. If you provide only a file name, the MaxL Shell assumes that the file is in the current directory (the directory the operating-system command prompt was in when essmsh was invoked). In the following invocation example, the file maxlscript.msh must be in C:\\ . C:\\&gt; essmsh maxlscript.msh If the MaxL script is not in the current directory, provide a path to the MaxL script. You can use absolute paths or relative paths. For example, $ essmsh ../hyperion/essbase/test.msh Note: MaxL scripts are not required to have any particular file extension, or any file extension at all. This document uses .msh . In UNIX shells, you should place single quotation marks around the path to avoid file-reading errors. In a Windows command prompt, if the path to the script contains a space, you may have to use double quotation marks around the entire path and file name to avoid file-reading errors. Starting the Shell for Programmatic Input To invoke the MaxL Shell to take input from the standard output of another program or process, use the -i flag. For example, program.sh essmsh -i The shell script program.sh may generate MaxL statements as output. The shell script's output is piped to essmsh -i , which uses that output as its input. This allows for efficient co-execution of scripts. Windows Example Using -i Invocation The following Windows batch script generates a login statement and a MaxL display statement as its output. The -i flag enables that output to be used by essmsh , the MaxL Shell, as input. echo login admin password on localhost; display privilege user; essmsh -i User Admin is logged in, all user privileges are displayed, and the MaxL session is terminated. UNIX Example Using -i Invocation The following portion of a shell script ensures that there are no applications on the system, by testing whether the display application statement returns zero applications. if [ $(echo display application; essmsh -l admin password -i 2&gt;&amp;1 awk '/Records returned/ print $7 ' ) != [0]. ] then print This test requires that there be no applications. print Quitting. exit 2 fi Here is how the above example works: MaxL grammar is piped to a MaxL Shell invocation and login, as the output of the UNIX echo command. The results of the MaxL session are tested by awk for pattern-matching with the MaxL status message you would get if you entered display application on an empty system: Records returned: [0] . Awk matches the string 'Records returned: ' , and then it checks to see if that is equal to '[0].' If $7 (a variable representing the fifth token awk finds in the status string) is equal to '[0].' , then there are no applications on the system; otherwise, $7 would equal '[1].' or whatever number of applications exist on the system. For more information and examples on invocation options, see the MaxL DDL &gt; MaxL Shell section of the Technical Reference . Invocation information is also contained in the essmsh man page. To view the man page, enter essmsh -h more at the operating-system command prompt. Logging In to Analytic Services The MaxL language interpreter requires a connection to an Analytic Services session before it can begin parsing MaxL statements. Use the MaxL Shell to establish the connection to Analytic Services. To log in to Analytic Services after the command shell has been started, use the shell's login grammar. Text you type is indicated by bold text. For example, essmsh Analytic Services MaxL Shell Release 7.0.0 (c) Copyright 2000-2003 Hyperion Solutions Corporation. All rights reserved. MAXL&gt; login Fiona identified by sunflower on hostname; If a host name is not specified, localhost is assumed. To log in when you invoke the shell, use the -l option. To log in to a server besides localhost at invocation time, use the -s option. To set a message level, use -m. For example, essmsh -l fiona sunflower -s myHost -m error Note: You can log out and change users without quitting the shell. For more information about MaxL Shell invocation options, see the MaxL DDL&gt; MaxL Shell section of the Technical Reference . Command Shell Features The MaxL Shell includes command-line argument processing, environment variable processing, nesting of MaxL scripts, and shell escapes. These features offer the flexibility needed to create a highly automated Analytic Services production environment. For complete information on the syntax and usage of all MaxL Shell features, see the MaxL DDL &gt; MaxL Shell section of the Technical Reference . Nesting MaxL Scripts As a database administrator, you may wish to save your separate automated tasks in several MaxL scripts, rather than executing many operations from a single script. Putting the pieces together is a simple task if you know how to reference one MaxL script from another. To reference or include other MaxL scripts within the current MaxL session, use the following MaxL Shell syntax: msh &lt;scriptfile&gt;; Spooling Output to a File You can create a log file of all or part of a MaxL session and its associated messages by spooling output to a file. To record a MaxL session, complete the following tasks: Log in to Analytic Services. For example, login fiona sunflower; Begin spooling output, using spool on to &lt;filename&gt; . For example, spool on to 'c:\\\\output\\\\display.txt'; Enter as many MaxL statements as you want recorded. Stop spooling output, using spool off ; MaxL statements and their output are logged to the output file when you issue the spool command, either in an interactive session or in a script. However, MaxL Shell commands and output are logged only if you spool during an interactive session. The MaxL Shell commands and output are ignored in log files created from script sessions. Additionally, output from any operating-system commands you may have included is ignored in the log files of both interactive and script sessions. Including Operating-System Commands You can issue operating-system commands directly from a MaxL session. The operating-system output becomes part of the MaxL Shell output. When the operating system finishes executing commands, it returns control to essmsh . To escape to the operating system from within a MaxL session, use shell . For example, try running the UNIX date command from a MaxL script. shell date; To escape to ESSCMD from within a MaxL session: shell esscmd '../scripts/test.scr'; Using Variables to Customize MaxL Scripts In the MaxL Shell, you can use variables as placeholders for any data that is subject to change or that you refer to often; for example, the name of a computer, user names, or passwords. You can use variables in MaxL scripts and during interactive sessions. Using variables in MaxL scripts eliminates the need to create customized scripts for each user, database, or host. Variables can be environment variables (for example, $ARBORPATH , which references the Analytic Services installation directory), positional parameters (for example, $1, $2, and so on), and locally defined shell variables. A variable always begins with a $ (dollar sign) when you reference it. For more information about using variables in the MaxL Shell, see the MaxL DDL&gt; MaxL Shell section of the Technical Reference . Stopping the MaxL Shell You can log out of a MaxL session, or log in as another user, without quitting the shell. You should include a logout statement at the end of MaxL scripts. It is not necessary to exit at the end of MaxL script files, or after a session using stream-oriented input from another program's output. To log out without exiting the MaxL Shell, enter logout; To exit from the MaxL Shell after using interactive mode, enter exit; The MaxL Perl Module With the aid of the MaxL Perl Module (Essbase.pm), you can embed the MaxL language within Perl programs, offering more programmatic control than is available in the shell. Essbase.pm, located in the Perlmod directory, enables beginning or advanced Perl programmers to wrap MaxL statements in Perl scripts. In this way, database administration with MaxL becomes as efficient and flexible as your Perl programs are. Using Perl with MaxL enables you to take advantage of these and other programmatic features while you administer Analytic Services databases: Conditional testing Inter-process communication Message handling E-mail notification Web scripting The Perl Module ( Essbase.pm ), contains methods that enable you to pass MaxL statements by means of Perl. These methods are: connect () , which establishes a connection to Analytic Services do () , which tells Perl to execute the enclosed MaxL statement pop_msg () , which navigates through the stack of returned MaxL messages fetch_col () , fetch_desc () , and fetch_row () , which retrieve information from MaxL display output tables disconnect () , which terminates the connection to Analytic Services To make the Perl methods available to Analytic Services, you must include a reference to Essbase.pm in your Perl program. Place the following line at the top of each Perl script: use Essbase; Perl is not difficult to learn, especially if you have prior knowledge of UNIX shells or other programming languages. To download Perl and learn more about Perl, visit the Comprehensive Perl Archive Network Web site at http:\/\/www.cpan.org/. For information and examples about installing and using the MaxL Perl Module, see the MaxL DDL section of the Technical Reference , and also the README file located in the PERLMOD directory of your Analytic Services installation.  |../dmaxlddl.htm",
    "Writing MDX Queries||This chapter describes MDX, the data manipulation language for Analytic Services. MDX is a joint specification of the XML for Analysis founding members. For more information about XML for Analysis, please visit http:\/\/www.xmla.org . For more details on the syntax and grammar of MDX, refer to the MaxL section of the Technical Reference . The goal of this chapter is to familiarize you with MDX and develop simple queries based on the Sample Basic database. To complete the exercises in this chapter, use the MaxL Shell. Before continuing, please start Analytic Services, and log in to the MaxL Shell. Additionally, be prepared to use a text editor to create the sample queries as presented in this chapter. Note: You can use the MDX Script Editor in Administration Services Console instead of the MaxL Shell. However, the instructions in this chapter use the MaxL Shell. This chapter contains the following sections: Understanding Elements of a Query Using Functions to Build Sets Working with Levels and Generations Using a Slicer Axis to Set Query Point-of-View Common Relationship Functions Performing Set Operations Creating and Using Named Sets and Calculated Members Using Iterative Functions Working With Missing Data Querying for Properties Understanding Elements of a Query In this section you will create a template to use as a basis for developing simple queries. Most queries can be built upon the following grammatical framework: SELECT ON COLUMNS FROM Sample.Basic SELECT in line 1 is the keyword that begins the main body of all MDX statements. The curly braces in line 2 are a placeholder for a set . In the above query, the set is empty, but the curly braces remain as a placeholder. Exercise 1: Creating a Query Template To complete this exercise, Create a folder to store sample queries which can be run against the Sample Basic database. For example, create a folder called queries under the Essbase\\Apps\\Sample\\Basic directory of the Analytic Services installation. Using a text editor, type the following code into a blank file: SELECT ON COLUMNS FROM Sample.Basic Save the file as qry_blank.txt to your queries folder. Note: If you are using the MDX Script Editor in Administration Services instead of a text editor, save the query as qry_blank.MDX from the editor instead. Introduction to Sets and Tuples A set is an ordered collection of one or more tuples that have the same dimensionality (see Rules for Specifying Sets for an explanation of dimensionality). A tuple is a way to refer to a member or a member combination from any number of dimensions. For example, in the Sample Basic database, Jan is a tuple, and so is (Jan, Sales), and so is ([Jan],[Sales],[Cola],[Utah],[Actual]). The member name can be specified in the following ways: By specifying the actual name or the alias; for example, Cola , Actual , COGS , and [100] . If the member name starts with number or contains spaces, it should be within braces; for example, [100] . Braces are recommended for all member names, for clarity and code readability. For attribute members, the long name (qualified to uniquely identify the member) should be used; for example, [Ounces_12] instead of just [12] . By specifying dimension name or any one of the ancestor member names as a prefix to the member name; for example, [Product].[100-10] and [Diet].[100-10] This is a recommended practice for all member names, as it eliminates ambiguity and enables you to refer accurately to shared members. Note: Use no more than one ancestor in the member name qualification. Analytic Services returns an error if multiple ancestors are included. For example, [Market].[New York] is a valid name for New York, and so is [East].[New York] . However, [Market].[East].[New York] returns an error. By specifying the name of a calculated member defined in the WITH section. Recall that the curly braces in line 2 of your query template are a placeholder for a set. In this exercise, we will add a set to the query and run it. Exercise 2: Running Your First Query To complete this exercise, Open qry_blank.txt . Recalling that a set can be as simple as one tuple, let us add Jan as a set to the query template. We must retain the curly braces, because these are required for all set specifications (except for sets that are produced by a function call). Type Jan inside the curly braces in line 2, as shown: SELECT Jan ON COLUMNS FROM Sample.Basic Save the query as ex2.txt . Make sure that Analytic Services is started (the essbase.exe process is running). In order for Analytic Services to receive MDX statements, you must pass the statements to Analytic Services using either the MaxL Shell or MDX Script Editor in Administration Services. The examples in this chapter use the MaxL Shell. Start the MaxL Shell and log in with a valid user name and password. For example, essmsh -l admin passwd Copy and paste the entire SELECT query into the MaxL Shell, but do not press the Enter key yet. Type a semicolon at the end, anywhere after Basic but before pressing the Enter key. The semicolon is not part of MDX syntax requirements, but it is required by MaxL Shell to indicate the end of a statement that is ready to execute. Note: If you are using the MDX Script Editor in Administration Services, do not terminate with a semicolon. Press the Enter key. You should see results similar to the following. Jan 8024 Rules for Specifying Sets As described in the previous section, a set is an ordered collection of one or more tuples. For example, in the following query, [100-10] is a set consisting of one tuple. SELECT [100-10] ON COLUMNS FROM Sample.Basic In the following query, ([100-10], [Actual]) is a also a set consisting of one tuple, though in this case, the tuple is not a single member name. Rather, ([100-10], [Actual]) represents a tuple consisting of members from two different dimensions, Product and Scenario. SELECT ([100-10] , [Actual]) ON COLUMNS FROM Sample.Basic When a set has more than one tuple, the following rule applies: In each tuple of the set, members must represent the same dimensions as do the members of other tuples of the set. Additionally, the dimensions must be represented in the same order. In other words, each tuple of the set must have the same dimensionality . For example, the following set consists of two tuples of the same dimensionality. (West, Feb), (East, Mar) The following set breaks the dimensionality rule because Feb and Sales are from different dimensions. (West, Feb), (East, Sales) The following set breaks the dimensionality rule because although the two tuples contain the same dimensions, the order of dimensions is reversed in the second tuple. (West, Feb), (Mar, East) A set can also be a collection of sets, and it can also be empty (containing no tuples). A set must be enclosed in curly brackets except in some cases where the set is represented by an MDX function which returns a set. Introduction to Axis Specifications An axis is a specification determining the layout of query results from a database. Axes fit into MDX queries as follows: SELECT &lt;axis&gt; [, &lt;axis&gt; ...] FROM &lt;database&gt; There must be at least one axis specified in any MDX query. Up to 64 axes may be specified, beginning with AXIS(0) and continuing with AXIS(1)...AXIS(63). It is uncommon to use more than three axes. The order of axes