/*rexx                                                               */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* Format a the Regs on last entry to the Interrupt Router            */

signal on halt name haltexit

arg isf .

if isf='' then do
   address df 'cmd output ln fpOldStack'
   o=output.0-1
   if pos('fpOldStack',output.o)>0 then,
      address df 'cmd output dd fpoldstack l2'
   else exit 0
end /* do */
else address df 'cmd output dd' isf 'l2'

o=output.0-1
parse var output.o . iesp iss .
address df 'cmd output dw' iss':'iesp 'l28'
o=output.0-5
parse var output.o . w0 w1 w2 w3 w4 w5 w6 w7 .
curint=w1||w0
gs=w2
fs=w4
es=w6
o=o+1
parse var output.o . w0 w1 w2 w3 w4 w5 w6 w7 .
ds=w0
edi=w3||w2
esi=w5||w4
ebp=w7||w6
o=o+1
parse var output.o . w0 w1 w2 w3 w4 w5 w6 w7 .
ebx=w3||w2
edx=w5||w4
ecx=w7||w6
o=o+1
parse var output.o . w0 w1 w2 w3 w4 w5 w6 w7 .
eax=w1||w0
eip=w7||w6
o=o+1
parse var output.o . w0 w1 w2 w3 w4 w5 w6 w7 .
cs=w0
eflags=w3||w2
esp=w5||w4
ss=w6
say 'Registers at time of last interrupt'
say 'previrq='curint 'isf='iss':'iesp
say 'eax='eax 'ebx='ebx 'ecx='ecx 'edx='edx 'esi='esi 'edi='edi
say 'eip='eip 'esp='esp 'ebp='ebp fmtflags(eflags)
say 'cs='cs 'ss='ss 'ds='ds 'es='es 'fs='fs 'gs='gs
address df 'cmd output u' cs':'eip 'l1'
o=output.0-1
say output.o


haltexit: exit 0

fmtflags: procedure
parse arg flags

fl=''
if length(flags)=8 then do
   eflgs=x2c(left(flags,4))
   flags=right(flags,4)
   if bitand(eflgs,'0000'x)='0001'x then fl=fl 'rf'
   else fl=fl '--'
   if bitand(eflgs,'0002'x)='0002'x then fl=fl 'vm'
   else fl=fl '--'
   if bitand(eflgs,'0004'x)='0004'x then fl=fl 'ac'
   else fl=fl '--'
end /* do */
flags=x2c(flags)
if bitand(flags,'4000'x)='4000'x then fl=fl 'nt'
else fl=fl '--'
if bitand(flags,'0800'x)='0800'x then fl=fl 'ov'
else fl=fl 'nv'
if bitand(flags,'0400'x)='0400'x then fl=fl 'dn'
else fl=fl 'up'
if bitand(flags,'0200'x)='0200'x then fl=fl 'ei'
else fl=fl 'di'
if bitand(flags,'0080'x)='0080'x then fl=fl 'ng'
else fl=fl 'pl'
if bitand(flags,'0040'x)='0040'x then fl=fl 'zr'
else fl=fl 'nz'
if bitand(flags,'0010'x)='0010'x then fl=fl 'ac'
else fl=fl 'na'
if bitand(flags,'0004'x)='0004'x then fl=fl 'pe'
else fl=fl 'po'
if bitand(flags,'0001'x)='0001'x then fl=fl 'cy'
else fl=fl 'nc'
iopl='iopl='left(c2x(bitand(flags,'3000'x)),1)
fl=iopl||fl
return fl
