/*rexx                                                               */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* Format a PM32-bit MQ */
/* 9/5/97 fixed possible acidental exponential comparison */
signal on halt name haltexit

arg mq .

if mq='' then do
   say 'MQ <hmq|pmq>'
   exit 0
end /* do */

mq='%'strip(mq,'l','%')

pmver=pmver()
if '#'pmver='#00000084' then call fmtmq(mq)
else if '#'pmver='#00000080' then call fmtmq1(mq)
else say 'PM version not supported'

haltexit: exit 0


pmver: procedure
magic_offset=value('DF_PMVER',,'OS2ENVIRONMENT')
say 'Warning: PMMERGE symbols assumed and current slot is a PM thread/app.'
say ''
if magic_offset='' then do
   address df "cmd output s %(dw(pmqshell)) l100 'S' 'T' "
   o=output.0-1
   magic=word(output.o,1)
   address df 'cmd output ?' magic '- %(dw(pmqshell))'
   o=output.0-1
   magic_offset=substr(output.o,2)
   x=value('DF_PMVER',magic_offset,'OS2ENVIRONMENT')
end
return magic_offset


fmtmq: procedure
arg mq .

say ' '
address df 'cmd output dd' mq 'L2c'
o=output.0-11
parse var output.o addr d0 d1 d2 d3 .
say '+000 Next                        ' d0
esz=right(d1,4)
msgs=left(d1,4)
say '+004 Q Entry size                ' esz
say '+006 Msgs queued                 ' msgs
say '+008 Queue depth                 ' d2
say '+00c pQTop                       ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+010 pQBottom                    ' d0
say '+014 pQRead                      ' d1
say '+018 pQWrite                     ' d2
say '+01c Wake mask                   ' right(d3,4)
say '+01e Change bits                 ' left(d3,4)
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+020 Wake bits                   ' right(d0,4)
say '+022 QS bits                     ' left(d0,4)
say '+024 Pid                         ' d1
say '+028 Tid                         ' d2
say '+02c SGid                        ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+030 Input Semaphore handle      ' d0
say '+034 Time of last msg            ' d1
say '+038 Possition of last msg       ' '('d2','d3')'
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+040 id Last msg                 ' d0
say '+044 Sent SMS                    ' d1
say '+048 Current (received) SMS      ' d2
say '+04c flags                       ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+050 rg pwnd Sem Msg (0)         ' d0
say '+050 rg pwnd Sem Msg (1)         ' d1
say '+050 rg pwnd Sem Msg (2)         ' d2
say '+050 rg pwnd Sem Msg (3)         ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+060 rg Sem Msg     (0)          ' d0
say '+064 rg Sem Msg     (1)          ' d1
say '+068 rg Sem Msg     (2)          ' d2
say '+06c rg Sem Msg     (3)          ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+070 Ready timer count           ' d0
say '+074 pHeap                       ' d1
say '+078 hAccel                      ' d2
say '+07c Cache entries               ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
if '#'d2<>'#00000000' then do
   address df 'cmd out .lm' d2
   x=out.0-1
   modname=word(out.x,4)
end /* do */
else modname=''
say '+080 pCharacter xlate table      ' d0
say '+084 Magic                       ' right(d1,4)
say '+088 Module handle               ' d2 modname
say '+08c pWND last window filter     ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+090 pWND Queue Procedure Window ' d0
say '+094 Shutdown byte               ' right(d1,2)
say '+095 Timer byte offset           ' substr(d1,5,2)
say '+096 Last wake mask              ' left(d1,4)
say '+098 No. of updated regions      ' right(d2,4)
say '+09c SMS receive list            ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
if '#'d1<>'#00000000' then do
   address df 'cmd out .p' d1
   x=out.0-1
   owner=word(out.x,13)
end /* do */
else owner=''
say '+0a0 Application capabilities    ' d0
say '+0a4 Thread slot number          ' d1 owner
return


fmtmq1: procedure
arg mq .

say ' '
address df 'cmd output dd' mq 'L29'
o=output.0-11
parse var output.o addr d0 d1 d2 d3 .
say '+000 Next                        ' d0
say '+004 Q Entry size                ' d1
say '+008 Msgs queued                 ' d2
say '+00c Queue depth                 ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+010 Wake mask                   ' right(d0,4)
say '+012 Change bits                 ' left(d0,4)
say '+014 Wake bits                   ' right(d1,4)
say '+016 QS bits                     ' left(d1,4)
say '+018 Pid                         ' d2
say '+01c Tid                         ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+020 First queued msg            ' d0
say '+024 Last queued msg             ' d1
say '+028 SGid                        ' d2
say '+02c Input Semaphore handle      ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+030 Time of last msg            ' d0
say '+034 Possition of last msg       ' '('d1','d2')'
say '+03c Sent SMS                    ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+040 Current (received) SMS      ' d0
say '+044 flags                       ' d1
say '+048 rg pwnd Sem Msg (0)         ' d2
say '+04c rg pwnd Sem Msg (1)         ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+050 rg pwnd Sem Msg (2)         ' d0
say '+054 rg pwnd Sem Msg (3)         ' d1
say '+058 rg Sem Msg     (0)          ' d2
say '+05c rg Sem Msg     (1)          ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+060 rg Sem Msg     (2)          ' d0
say '+064 rg Sem Msg     (3)          ' d1
say '+068 Bad Window pWnd             ' d2
say '+06c Bad Queue?                  ' right(d3,2)
say '+06d Ready timer count           ' substr(d3,5,2)
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+070 pHeap                       ' d0
say '+074 hAccel                      ' d1
say '+078 Cache entries               ' d2
say '+07c pCharacter xlate table      ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+080 Magic                       ' right(d0,4)
if '#'d1<>'#00000000' then do
   address df 'cmd out .lm' d1
   x=out.0-1
   modname=word(out.x,4)
end /* do */
else modname=''
say '+084 Module handle               ' d1 modname
say '+088 pWND last window filter     ' d2
say '+08c pWND Queue Procedure Window ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+090 Shutdown byte               ' right(d0,2)
say '+091 Timer byte offset           ' substr(d0,5,2)
say '+092 Last wake mask              ' left(d0,4)
say '+094 No. of updated regions      ' right(d1,4)
say '+098 SMS receive list            ' d2
say '+09c Application capabilities    ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
if '#'d0<>'#00000000' then do
   address df 'cmd out .p' d0
   x=out.0-1
   owner=word(out.x,13)
end /* do */
else owner=''
say '+0a0 Thread slot number          ' d0 owner
return

