/*.im seciuo*/
/* IBM Internal Use Only.                                            */
/*.im coibm*/
/* (C) Copyright IBM Corp. 1993                                      */
/* (C) Copyright IBM Information Solutions 1993                      */
/*                                                                   */
/*rexx*/
/*Author: Richard Moore / Dieter Damm                Version: 1.0    */
/* format named pipe data buffer                                     */
/* 1 required parameter: adr (sel:offs)                              */
/*                                                                   */
/* 10/01/97 if user types ?, spit out help                           */
/*                                                                   */

trace 'o'
numeric digits 12

arg adr

if (adr='?' |,
   adr='/?' |,
   adr=' '  |,
   adr=''   |, 
   adr='/h' |,
   adr='/H') then do
   say
   say "Format Named Pipe buffer structure (NPB)"
   say " "
   say 'Syntax: %NPB sel:offs '
   say ' '
   exit 0
end  /* Do */

position=pos(':',adr)
if pos=0 then do
  say' Invalid sel:ofs given'
  exit 0
end
say ' '
sel=substr(adr,1,position-1)
ofs=right(adr,length(adr)-position)
address df 'cmd output dl 'sel
o=output.0-1
linaddr=substr(word(output.o,3),5,8)
linaddr=x2d(linaddr)+x2d(ofs)
linaddr='%'d2x(linaddr)
say linaddr

call format "npb_selector     ","+00",linaddr,"W","selector of buffer"
call format "npb_first         ","+02",linaddr,"W","base of buffer   "
call format "npb_in            ","+04",linaddr,"W","next free byte in buffer "
call format "npb_out           ","+06",linaddr,"W","next byte of data in buffer"
call format "npb_last          ","+08",linaddr,"W","end+1 of buffer"
call format "npb_rdlck         ","+0a",linaddr,"W","read lock semaphore"
call format "npb_wtlck         ","+0c",linaddr,"W","write lock semaphore"
call format "npb_rdsem         ","+0e",linaddr,"W","read sync semaphore"
call format "npb_wtsem         ","+10",linaddr,"W","write sync semaphore"
call format "npb_rdcnt         ","+12",linaddr,"B","count of readers of buffer"
call format "npb_wtcnt         ","+13",linaddr,"B","count of writers of buffer"
call format "npb_data          ","+14",linaddr,"W","size of data left in pipe"
exit



/*.im getstor*/
/*.ifdef gblgetstor*/
/*.endif*/
/*.se gblgetstor=1*/
getstor: procedure
arg address,size,format
select
   when size='B' then cmd="DB" address "L1"
   when size='W' then cmd="DW" address "L1"
   when size="D" then cmd="DD" address "L1"

otherwise cmd="DB" address "L1"
end  /* select */
address df "cmd output" cmd
if rc<>0 then return 'df error' rc
else do
    if substr(output.3,1,1)='#' then do
       parse var output.2 . stor .
       select
          when format="C" then return x2c(stor)
          when format="N" then return x2d(stor)
          when format="X" then return stor
       otherwise return stor
       end  /* select */
    end  /* Do */
    else return output.3
end


format: procedure
parse arg name,offset,base,type,desc
value=getstor(base||offset,type)
desc=strip(desc,"B"," ")
name=strip(name,"B"," ")
if desc='' then text=offset name":"
else text=offset name"," desc":"
tl=length(text)
vl=length(value)
pad=70-tl-vl
if pad>0 then text=left(text,pad+tl," ")
say text value
return value
