/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* search for all Windows WND/MQ/CLS structures */
/* 9/5/97 fixed possible acidental exponential comparison */

signal on halt name haltexit
numeric digits 18
trace 'o'

arg parms

args=''
opts=''
do while parms<>''
   parse var parms parm parms
   if left(parm,1)='/' then opts=opts||substr(parm,2)
   else args=args parm
end /* do */

if pos('?',opts)>0 | word(args,1)='?' then do
   call helpmsg
   exit 0
end /* do */

if words(args)>0 then do
   say 'Invalid parameters'
   call helpmsg
   exit 0
end /* do */

fcls=0=1
fmq=0=1

if pos('C',opts)>0 then fcls=0=0
if pos('Q',opts)>0 then fmq=0=0


if wininit() then exit 8

/* first enumerate list of all tasks */

isTDB.=0=1
tdbowner.=''
nexttdb=value('DF_WHEADTDB',,'OS2ENVIRONMENT')
do while '#'nexttdb<>'#0000'
   isTDB.nexttdb=0=0
   address df 'cmd output da #'nexttdb':f2 l9'
   o=output.0-1
   tdbowner.nexttdb=word(output.o,2)
   nexttdb=getwords('#'nexttdb':0',1)
end /* do */

/* now locate USER.EXE heap selector */

uheap=userheap()

/* now scan arena records looking for USER allocations */
/* we are trying to find a Msg Q. They are usually 120 */
/* bytes long, +2 is the task number, +1 is the next mq*/
/* +26 is the hwnd and +36 is the windows version      */
/* we will match on task and version a check for a     */
/* non-zero hwnd that's in range of the heap. We only  */
/* need to locate the first of these to find a valid   */
/* hwnd.                                               */

wver=value('DF_WWINVER',,'OS2ENVIRONMENT')
huser=value('DF_WHUSER',,'OS2ENVIRONMENT')
pgheap=value('DF_WPGLOBALHEAP',,'OS2ENVIRONMENT')

/* scan the arena records */

arfirst=getdwords('#'pgheap':6',1)
arlast =getdwords('#'pgheap':a',1)

arnext=arfirst
quit=0=1
found=0=1
do while quit
   address df 'cmd output dd #'pgheap':'arnext 'l8'
   o1=output.0-2
   o2=output.0-1
   ar1=output.o1
   ar2=output.o2
   parse var ar1 . next prev addr size .
   parse var ar2 . ho fl lrup lrun .
   own=left(ho,4)
   hndl=right(ho,4)
   scnt=left(fl,2)
   flgs=substr(fl,3,2)
   lock=substr(fl,5,2)
   cnt=right(fl,2)
   if '#'huser='#'own then do
      task=getwords('#'hndl':2',1)
      if isTDB.task then do
         ver=getwords('#'hndl':36',1)
         if '#'ver='#'wver then do
            hwnd=getwords('#'hndl':26',1)
            if 'x'hwnd <> 'x0000' then do
               found=0=0
               quit=0=0
            end /* do */
         end /* do */
      end /* do */
   end /* do */
   if x2d(arnext)=x2d(next) then quit=0=0
   else arnext=next
end /* do */
if found then do
   say 'Unable to find any MQs'
   exit 0
end /* do */

/* now chain back through the parent hierarchy to the head of the tree */

do until 'x'hwnd='x0000'
   hhwnd=hwnd
   hwnd=getwords('#'uheap':'hwnd'+4',1)
end /* do */

/* hwnd should now be the parent of all windows */
/* Now enumerate the window tree */

call wndtree(hhwnd)

/* done! */

haltexit: exit 0


wndtree: procedure expose uheap tdbowner. fcls fmq
parse arg hwnd
nc=fmtwnd(hwnd)
parse var nc next child .
do while ('x'next<>'x0000')
   next=nextwnd(next)
end /* do */
if 'x'child<>'x0000' then call wndtree(child)
return

nextwnd: procedure expose uheap tdbowner. fcls fmq
parse arg hwnd
nc=fmtwnd(hwnd)
parse var nc next child .
if 'x'child<>'x0000' then call wndtree(child)
return next

fmtwnd:procedure expose uheap tdbowner. fcls fmq
parse arg hwnd
address df 'cmd output dw #'uheap':'hwnd 'l12'
o=output.0-3
parse var output.o . nx ch pa ow .
o=o+1
parse var output.o . . . . . hq . cl .
o=o+1
parse var output.o . po ps .
say 'hwnd='hwnd 'Next='nx 'Child='ch 'Parent='pa 'Owner='ow 'hq='hq 'Proc='ps':'po
if fmq then call fmtmq hq
if fcls then do while 'x'cl<>'x0000'
   cl=fmtcls(cl)
end /* do */
return nx ch

fmtcls: procedure expose uheap tdbowner. fcls fmq
parse arg cls
address df 'cmd output dw #'uheap':'cls 'l12'
o=output.0-3
parse var output.o . nx .  .  .  .  .  po ps .
o=o+1
parse var output.o addr .  .  hm .  .  .  mo ms .
if 'x'ms<>'x0000' then do
   address df 'cmd menu da' ms':'mo
   x=menu.0-1
   menuname='Menu='word(menu.x,2)
end /* do */
else menuname=''
o=o+1
parse var output.o addr co cs .
if 'x'cs<>'x0000' then do
   address df 'cmd menu da' cs':'co
   x=menu.0-1
   classname='Class='word(menu.x,2)
end /* do */
else classname=''

say '   Cls='cls 'Next='nx 'Proc='ps':'po 'hExe='hm menuname classname
return nx

fmtmq: procedure expose uheap tdbowner. fcls fmq
parse arg hq

address df 'cmd output dw' hq':0 L20'
o=output.0-4
parse var output.o addr nx tk . mq .
o=o+3
parse var output.o addr .  .  .  .  sq sl sn .
say '   hq='hq 'Next='nx 'Task='tk 'QMsgs='mq 'SenderQ='sq 'SendList='sl 'SendNext='sn tdbowner.tk
return

helpmsg: procedure

say " List the entire Windows Window Strcuture Tree"
say " Optionally format each Message Queue for each Window"
say " Optionally format the Class List for each Window"
say " "
say " Syntax:"
say " %WWNDLST <options>"
say ""
say " where:"
say "          <options> may be any of the following:"
say ""
say "                    /c - format the Class List for each Window"
say "                    /q - format the Message Queue header for each Window"
say ""
return


getwords: procedure
arg address,length
address df "cmd output DW" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DW "address"+"i*2"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor
getdwords: procedure
arg address,length
address df "cmd output DD" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DD "address"+"i*4"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor

userheap: procedure
huser=value('DF_WHUSER',,'OS2ENVIRONMENT')
segs=getwords('#'huser':1c',1)
segtab=getwords('#'huser':22',1)
hoff=((x2d(segs)-1)*10)+8+x2d(segtab)
return c2x(bitor(x2c(getwords('#'huser':'hoff't',1)),'0001'x))


wininit: procedure expose nothing

address df 'cmd output .p#'
o=output.0-1
if pos('*vdm',output.o)=0 then do
   say 'Current thread slot is not a VDM'
   return 0=1
end  /* Do */

vdm_slot=substr(output.o,2,4)
init_slot=value('DF_WWINVDM',,'OS2ENVIRONMENT')
if 'x'init_slot='x'vdm_slot then do
   /* just need to reset to vars that change in case we are under the kdb */
   dsel=value('DF_WKDSEL',,'OS2ENVIRONMENT')
   address df 'cmd output dw #'dsel':220  l8' /* make sure we use protmode addressing */
   o=output.0-1
   parse var output.o . tp hp . ht ct .
   otp=value('DF_WTOPPDB',tp,'OS2ENVIRONMENT')
   ohp=value('DF_WHEADPDB',hp,'OS2ENVIRONMENT')
   oht=value('DF_WHEADTDB',ht,'OS2ENVIRONMENT')
   oct=value('DF_WCURTDB',ct,'OS2ENVIRONMENT')   /* bug fix - was DF_WHCURTDB */
   if '#'otp<>'#'tp | '#'ohp<>'#'hp | '#'oht<>'#'ht | '#'oct<>'#'ct then,
      t=value('DF_WDEFTDB',ct,'OS2ENVIRONMENT')
   return 0=0
end /* do */
else do
   say 'Searching for WINDOWS kernel data segment'
   found=0=1
   do i = 1 to 8192
      sel=d2x((i*8)+7)
      if i//64 = 0 then do
         say 'Kernel data segment not found before' sel'. Continuing search'
      end /* do */
      address df 'cmd output dl' sel 'l1'
      o=output.0-1
      if word(output.o,2)='Code' then do
         x=getwords('#'sel':0',1)
         if x='f4cc' then do
            dsel=right(d2x(((i+3)*8)+7),4,'0')
            if translate(getwords('#'sel':30',1))=dsel then do
               say 'Windows Kernel Data Segment selector:' dsel
               x=value('DF_WKDSEL',dsel,'OS2ENVIRONMENT')
               x=value('DF_WWINVDM',vdm_slot,'OS2ENVIRONMENT')
               found=0=0
               leave
            end  /* Do */
         end  /* Do */
      end  /* Do */
   end /* do */

   if found then return 0=1

   say 'Initialising global variables'
   dseg='#'dsel':218' /* set starting address */
   doff=0             /* set current offset from this address */

   x=winsetvar('hGlobalHeap','w')
   x=winsetvar('pGlobalHeap','w')
   x=winsetvar('hExeHead','w')
   x=winsetvar('hExeSweep','w')
   x=winsetvar('TopPDB','w')
   x=winsetvar('headPDB','w')
   x=winsetvar('topsizePDB','w')
   x=winsetvar('headTDB','w')
   x=winsetvar('curTDB','w')
   x=winsetvar('loadTDB','w')
   x=winsetvar('lockTDB','w')
   x=winsetvar('SelTableLen','w')
   x=winsetvar('SelTableStart','d')
   x=winsetvar('hBmDPMI','d')
   x=winsetvar('winVer','w')
   x=winsetvar('fwinx','w')
   x=winsetvar('f8087','w')
   x=winsetvar('PHTcount','w')
   x=winsetvar('hGDI','w')
   x=winsetvar('hUser','w')
   x=winsetvar('hShell','w')
   x=winsetvar('flMDepth','w')
   x=winsetvar('wdefrip','w')
   x=winsetvar('num_tasks','b')
   x=winsetvar('InScheduler','b')
   x=winsetvar('graphics','b')
   /* spare byte */
   doff=doff+1
   x=winsetvar('fastfp','b')
   x=winsetvar('MaxCodeSwapArea','w')
   x=winsetvar('SelLowHeap','w')
   x=winsetvar('cpLowHeap','w')
   x=winsetvar('SelHighHeap','w')
   x=winsetvar('SelWoaPDB','w')
   x=winsetvar('sel_alias_array','w')
   x=winsetvar('temp_sel','w')
   x=winsetvar('dressed_for_success','D')
   x=winsetvar('InDos','d')
   x=winsetvar('pSftLink','d')
   x=winsetvar('lpWinSftLink','d')
   x=winsetvar('pFileTable','d')
   x=winsetvar('FileEntrySize','w')
   x=winsetvar('curDTA','d')
   x=winsetvar('cur_dos_PDB','w')
   x=winsetvar('Win_PDB','w')
   x=winsetvar('cur_drive_owner','w')
   x=winsetvar('fBreak','b')
   x=winsetvar('LastDriveSwapped','b')
   x=winsetvar('DOS_version','b')
   x=winsetvar('DOS_revision','b')
   x=winsetvar('fInt21','b')
   x=winsetvar('fNovell','b')
   x=winsetvar('fPadCode','b')
   x=winsetvar('CurDOSDrive','b')
   x=winsetvar('DOSDrives','b')

   t=value('DF_WCURTDB',,'OS2ENVIRONMENT')
   t=value('DF_WDEFTDB',t,'OS2ENVIRONMENT')

end /* do */

return 0=0

winsetvar: procedure expose dseg doff dsel
arg vname,type
type=translate(type)
if type='B' then do
   x=getbytes(dseg'+'doff't',1)
   doff=doff+1
end  /* Do */
else if type ='W' then do
   x=getwords(dseg'+'doff't',1)
   doff=doff+2
end  /* Do */
else if type ='D' then do
   x=getdwords(dseg'+'doff't',1)
   doff=doff+4
end  /* Do */
y=value('DF_W'vname,x,'OS2ENVIRONMENT')

return 0

getbytes: procedure
arg address,length
address df "cmd output DB" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DB "address"+"i"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor



