 /********************************************************************/
 /*                                                                  */
 /*  PL/I Include file: BSEXCPT.CPY                                  */
 /*                                                                  */
 /*  NAME - BSEXCPT.CPY                                              */
 /*                                                                  */
 /*  DESCRIPTION                                                     */
 /*    OS/2 base PL/I include file.                                  */
 /*                                                                  */
 /*    (C) Copyright IBM Corp. 1992. All Rights Reserved.            */
 /*    US Government Users Restricted Rights-- Use, duplication or   */
 /*    disclosure restricted by GSA ADP Schedule Contract with       */
 /*    IBM Corp.                                                     */
 /*                                                                  */
 /*  DISCLAIMER OF WARRANTIES                                        */
 /*    The following enclosed code is sample code created by IBM   */
 /*    Corporation. This sample code is not part of any standard     */
 /*    IBM product and is provided to you solely for the purpose of  */
 /*    assisting you in the development of your applications.  The   */
 /*    code is provided "AS IS", without warranty of any kind.       */
 /*    IBM shall not be liable for any damages arising out of your   */
 /*    use of the sample code, even if IBM has been advised of the   */
 /*    possibility of such damages.                                  */
 /*                                                                  */
 /********************************************************************/
 /*==================================================================*/
 /* Function: This file provides constants and data structure        */
 /*      definitions required by application programs to use 32 bit  */
 /*      thread exceptions management facility.                      */
 /*==================================================================*/
 %if IBMC__='Y' %then %do;
   %if CHKHDR__='Y' %then %do;
   %end;
 %end;
 %if BSEXCPT__='Y' %then %do;
   %BSEXCPT__='Y';
   dcl XCPT_CONTINUE_SEARCH fixed bin(31) value('00_00_00_00'xn);
   dcl XCPT_CONTINUE_EXECUTION fixed bin(31) value('FF_FF_FF_FF'xn);
   dcl XCPT_CONTINUE_STOP fixed bin(31) value('00_71_66_68'xn);
   dcl EH_NONCONTINUABLE fixed bin(31) value('00_00_00_01'xn);
   dcl EH_UNWINDING fixed bin(31) value('00_00_00_10'xn);
   dcl EH_EXIT_UNWIND fixed bin(31) value('00_00_01_00'xn);
   dcl EH_STACK_INVALID fixed bin(31) value('00_00_10_00'xn);
   dcl EH_NESTED_CALL fixed bin(31) value('00_01_00_00'xn);
   %dcl UNWIND_ALL char;
    %UNWIND_ALL=0;
 /*******************************************************************/
 /* Exception values are 32 bit values layed out as follows:        */
 /*                                                                 */
 /* 3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1                     */
 /* 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0  */
 /* +---+-+-------------------------+-------------------------------+*/
 /* |Sev|C|       Facility          |               Code            |*/
 /* +---+-+-------------------------+-------------------------------+*/
 /*                                                                 */
 /* where                                                           */
 /*                                                                 */
 /*     Sev - is the severity code                                  */
 /*         00 - Success                                            */
 /*         01 - Informational                                      */
 /*         10 - Warning                                            */
 /*         11 - Error                                              */
 /*                                                                 */
 /*     C - is the Customer code flag                               */
 /*                                                                 */
 /*     Facility - is the facility code                             */
 /*                                                                 */
 /*     Code - is the facility's status code                        */
 /*                                                                 */
 /*  Exceptions specific to OS/2 2.0 (e.g. XCPT_SIGNAL) will        */
 /*  be marked                                                      */
 /*  with a facility code of 1.                                     */
 /*                                                                 */
 /*  System defined exceptions have a facility code of zero.        */
 /*                                                                 */
 /*  Each exception may also have several pieces of additional      */
 /*  information.                                                   */
 /*  These are stored in the ExceptionInfo fields of the            */
 /*  ExceptionReportRecord. They are documented here with           */
 /*  the exceptions                                                 */
 /*  only for ease of reference.                                    */
 /*******************************************************************/

   dcl XCPT_FATAL_EXCEPTION fixed bin(31) value('C0_00_00_00'xn);
   dcl XCPT_SEVERITY_CODE fixed bin(31) value('C0_00_00_00'xn);
   dcl XCPT_CUSTOMER_CODE fixed bin(31) value('20_00_00_00'xn);
   dcl XCPT_FACILITY_CODE fixed bin(31) value('1F_FF_00_00'xn);
   dcl XCPT_EXCEPTION_CODE fixed bin(31) value('00_00_FF_FF'xn);
   dcl XCPT_UNKNOWN_ACCESS fixed bin(31) value('00_00_00_00'xn);
   dcl XCPT_READ_ACCESS fixed bin(31) value('00_00_00_01'xn);
   dcl XCPT_WRITE_ACCESS fixed bin(31) value('00_00_00_00'xn);
   dcl XCPT_EXECUTE_ACCESS fixed bin(31) value('00_00_00_04'xn);
   dcl XCPT_SPACE_ACCESS fixed bin(31) value('00_00_00_08'xn);
   dcl XCPT_LIMIT_ACCESS fixed bin(31) value('00_00_00_10'xn);
   dcl XCPT_DATA_UNKNOWN fixed bin(31) value('FF_FF_FF_FF'xn);
   %dcl XCPT_SIGNAL_INTR char;
   %XCPT_SIGNAL_INTR=1;
   %dcl XCPT_SIGNAL_KILLPROC char;
   %XCPT_SIGNAL_KILLPROC=3;
   %dcl XCPT_SIGNAL_BREAK char;
   %XCPT_SIGNAL_BREAK=4;
   dcl XCPT_GUARD_PAGE_VIOLATION fixed bin(31) value('80_00_00_01'xn);
   dcl XCPT_UNABLE_TO_GROW_STACK fixed bin(31) value('80_01_00_01'xn);
   dcl XCPT_DATATYPE_MISALIGNMENT fixed bin(31) value('C0_00_00_9E'xn);
   dcl XCPT_BREAKPOINT fixed bin(31) value('C0_00_00_9F'xn);
   dcl XCPT_SINGLE_STEP fixed bin(31) value('C0_00_00_A0'xn);
   dcl XCPT_ACCESS_VIOLATION fixed bin(31) value('C0_00_00_05'xn);
   dcl XCPT_ILLEGAL_INSTRUCTION fixed bin(31) value('C0_00_00_1C'xn);
   dcl XCPT_FLOAT_DENORMAL_OPERAND fixed bin(31) value('C0_00_00_94'xn);
   dcl XCPT_FLOAT_DIVIDE_BY_ZERO fixed bin(31) value('C0_00_00_95'xn);
   dcl XCPT_FLOAT_INEXACT_RESULT fixed bin(31) value('C0_00_00_96'xn);
   dcl XCPT_FLOAT_INVALID_OPERATION fixed bin(31)
                                    value('C0_00_00_97'xn);
   dcl XCPT_FLOAT_OVERFLOW fixed bin(31) value('C0_00_00_98'xn);
   dcl XCPT_FLOAT_STACK_CHECK fixed bin(31) value('C0_00_00_99'xn);
   dcl XCPT_FLOAT_UNDERFLOW fixed bin(31) value('C0_00_00_9A'xn);
   dcl XCPT_INTEGER_DIVIDE_BY_ZERO fixed bin(31) value('C0_00_00_9B'xn);
   dcl XCPT_INTEGER_OVERFLOW fixed bin(31) value('C0_00_00_9C'xn);
   dcl XCPT_PRIVILEGED_INSTRUCTION fixed bin(31) value('C0_00_00_9D'xn);
   dcl XCPT_IN_PAGE_ERROR fixed bin(31) value('C0_00_00_06'xn);
   dcl XCPT_PROCESS_TERMINATE fixed bin(31) value('C0_01_00_01'xn);
   dcl XCPT_ASYNC_PROCESS_TERMINATE fixed bin(31)
                                    value('C0_01_00_02'xn);
   dcl XCPT_NONCONTINUABLE_EXCEPTION fixed bin(31)
                                     value('C0_00_00_24'xn);
   dcl XCPT_INVALID_DISPOSITION fixed bin(31) value('C0_00_00_25'xn);
   dcl XCPT_INVALID_LOCK_SEQUENCE fixed bin(31) value('C0_00_00_1D'xn);
   dcl XCPT_ARRAY_BOUNDS_EXCEEDED fixed bin(31) value('C0_00_00_93'xn);
   dcl XCPT_B1NPX_ERRATA_02 fixed bin(31) value('C0_01_00_04'xn);
   dcl XCPT_UNWIND fixed bin(31) value('C0_00_00_26'xn);
   dcl XCPT_BAD_STACK fixed bin(31) value('C0_00_00_27'xn);
   dcl XCPT_INVALID_UNWIND_TARGET fixed bin(31) value('C0_00_00_28'xn);
   dcl XCPT_SIGNAL fixed bin(31) value('C0_01_00_03'xn);
   dcl CONTEXT_CONTROL fixed bin(31) value('00_00_00_01'xn);
   dcl CONTEXT_INTEGER fixed bin(31) value('00_00_00_02'xn);
   dcl CONTEXT_SEGMENTS fixed bin(31) value('00_00_00_04'xn);
   dcl CONTEXT_FLOATING_POINT fixed bin(31) value('00_00_00_08'xn);
   dcl CONTEXT_FULL fixed bin(31) value('00_00_00_0F'xn);
   %dcl fpreg char;
   %fpreg='char(stg(#fpreg))';
   dcl 1 #fpreg based(null()) unaligned,
         2 losig ULONG,
         2 hisig ULONG,
         2 signexp USHORT;
   %dcl CONTEXT char;
   %CONTEXT='char(stg(#CONTEXT))';
   dcl 1 #CONTEXT based(null()) unaligned,
         2 ContextFlags ULONG,
         2 ctx_env(7) ULONG,
         2 ctx_stack(8) FPREG,
         2 ctx_SegGs ULONG,
         2 ctx_SegFs ULONG,
         2 ctx_SegEs ULONG,
         2 ctx_SegDs ULONG,
         2 ctx_RegEdi ULONG,
         2 ctx_RegEsi ULONG,
         2 ctx_RegEax ULONG,
         2 ctx_RegEbx ULONG,
         2 ctx_RegEcx ULONG,
         2 ctx_RegEdx ULONG,
         2 ctx_RegEbp ULONG,
         2 ctx_RegEip ULONG,
         2 ctx_SegCs ULONG,
         2 ctx_EFlags ULONG,
         2 ctx_RegEsp ULONG,
         2 ctx_SegSs ULONG;
   dcl 1 CONTEXTRECORD like #CONTEXT;
   %dcl PCONTEXTRECORD char;
   %PCONTEXTRECORD='pointer';
   %dcl EXCEPTION_MAXIMUM_PARAMETERS char;
   %EXCEPTION_MAXIMUM_PARAMETERS=4;
   %dcl EXCEPTIONREPORTRECORD char;
   %EXCEPTIONREPORTRECORD='char(stg(#EXCEPTIONREPORTRECORD))';
   dcl 1 #EXCEPTIONREPORTRECORD based(null()) unaligned,
         2 ExceptionNum ULONG,
         2 fHandlerFlags ULONG,
         2 NestedExceptionReportRecord pointer,
         2 ExceptionAddress PVOID,
         2 cParameters ULONG,
         2 ExceptionInfo(EXCEPTION_MAXIMUM_PARAMETERS) ULONG;
   %dcl PEXCEPTIONREPORTRECORD char;
   %PEXCEPTIONREPORTRECORD='pointer';
   %dcl EXCEPTIONREGISTRATIONRECORD char;
   %EXCEPTIONREGISTRATIONRECORD
       ='char(stg(#EXCEPTIONREGISTRATIONRECORD))';
   %dcl PEXCEPTIONREGISTRATIONRECORD char;
   %PEXCEPTIONREGISTRATIONRECORD='pointer';
 %end;
 %if IBMC__='Y' %then %do;
   %if CHKHDR__='Y' %then %do;
   %end;
 %end;
