 /********************************************************************/
 /*                                                                  */
 /*  PL/I Include file: PMHELP.CPY                                   */
 /*                                                                  */
 /*  NAME - PMHELP.CPY                                               */
 /*                                                                  */
 /*  DESCRIPTION                                                     */
 /*    Presentation Manager PL/I include file.                       */
 /*                                                                  */
 /*    (C) Copyright IBM Corp. 1992. All Rights Reserved.            */
 /*    US Government Users Restricted Rights-- Use, duplication or   */
 /*    disclosure restricted by GSA ADP Schedule Contract with       */
 /*    IBM Corp.                                                     */
 /*                                                                  */
 /*  DISCLAIMER OF WARRANTIES                                        */
 /*    The following enclosed code is sample code created by IBM   */
 /*    Corporation. This sample code is not part of any standard     */
 /*    IBM product and is provided to you solely for the purpose of  */
 /*    assisting you in the development of your applications.  The   */
 /*    code is provided "AS IS", without warranty of any kind.       */
 /*    IBM shall not be liable for any damages arising out of your   */
 /*    use of the sample code, even if IBM has been advised of the   */
 /*    possibility of such damages.                                  */
 /*                                                                  */
 /********************************************************************/
 /*==================================================================*/
 /*                                                                  */
 /* The following symbols are used in this file for conditional      */
 /* sections.                                                        */
 /*                                                                  */
 /*   #define:                To include:                            */
 /*                                                                  */
 /*   INCL_WINHELP            Help manager structures and APIs       */
 /*   INCL_DDF                Dynamic Data Formatting APIs           */
 /*                                                                  */
 /*==================================================================*/
 %if IBMC__='Y' %then %do;
   %if CHKHDR__='Y' %then %do;
   %end;
 %end;
 %if PMHELP_INCLUDED='Y' %then %do;
   %PMHELP_INCLUDED='Y';
   %dcl HELPSUBTABLE char;
   %HELPSUBTABLE=USHORT;
   %dcl PHELPSUBTABLE char;
   %PHELPSUBTABLE='pointer';
   %dcl HELPTABLE char;
   %HELPTABLE='char(stg(#HELPTABLE))';
   dcl 1 #HELPTABLE based(null()) unaligned,
         2 idAppWindow USHORT,
         2 phstHelpSubTable PHELPSUBTABLE,
         2 idExtPanel USHORT;
   %dcl PHELPTABLE char;
   %PHELPTABLE='pointer';
   %dcl HELPINIT char;
   %HELPINIT='char(stg(#HELPINIT))';
   dcl 1 #HELPINIT based(null()) unaligned,
         2 cb ULONG,
         2 ulReturnCode ULONG,
         2 pszTutorialName PSZ,
         2 phtHelpTable PHELPTABLE,
         2 hmodHelpTableModule HMODULE,
         2 hmodAccelActionBarModule HMODULE,
         2 idAccelTable ULONG,
         2 idActionBar ULONG,
         2 pszHelpWindowTitle PSZ,
         2 fShowPanelId ULONG,
         2 pszHelpLibraryName PSZ;
   %dcl PHELPINIT char;
   %PHELPINIT='pointer';

   dcl HWND_PARENT pointer value(ptrvalue(0));

   %dcl HM_RESOURCEID char;
   %HM_RESOURCEID=0;
   %dcl HM_PANELNAME char;
   %HM_PANELNAME=1;
   %dcl HMPANELTYPE_NUMBER char;
   %HMPANELTYPE_NUMBER=0;
   %dcl HMPANELTYPE_NAME char;
   %HMPANELTYPE_NAME=1;

   dcl CMIC_HIDE_PANEL_ID fixed bin(16) value('00_00'xn);
   dcl CMIC_SHOW_PANEL_ID fixed bin(16) value('00_01'xn);
   dcl CMIC_TOGGLE_PANEL_ID fixed bin(16) value('00_02'xn);

   dcl WinDestroyHelpInstance entry (
          HWND)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinCreateHelpInstance entry (
          HAB,
          PHELPINIT)
          returns(optional byvalue HWND)
          APIENTRY;
   dcl WinAssociateHelpInstance entry (
          HWND,
          HWND)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinQueryHelpInstance entry (
          HWND)
          returns(optional byvalue HWND)
          APIENTRY;
   dcl WinLoadHelpTable entry (
          HWND,
          ULONG,
          HMODULE)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinCreateHelpTable entry (
          HWND,
          PHELPTABLE)
          returns(optional byvalue BOOL)
          APIENTRY;

   dcl HM_MSG_BASE fixed bin(16) value('02_20'xn);

   dcl HM_DISMISS_WINDOW fixed bin(16) value('02_21'xn);
   dcl HM_DISPLAY_HELP fixed bin(16) value('02_22'xn);
   dcl HM_EXT_HELP     fixed bin(16) value('02_23'xn);
   dcl HM_GENERAL_HELP fixed bin(16) value('02_23'xn);
   dcl HM_SET_ACTIVE_WINDOW fixed bin(16) value('02_24'xn);
   dcl HM_LOAD_HELP_TABLE fixed bin(16) value('02_25'xn);
   dcl HM_CREATE_HELP_TABLE fixed bin(16) value('02_26'xn);
   dcl HM_SET_HELP_WINDOW_TITLE fixed bin(16) value('02_27'xn);
   dcl HM_SET_SHOW_PANEL_ID fixed bin(16) value('02_28'xn);
   dcl HM_REPLACE_HELP_FOR_HELP fixed bin(16) value('02_29'xn);
   dcl HM_REPLACE_USING_HELP fixed bin(16) value('02_29'xn);
   dcl HM_HELP_INDEX fixed bin(16) value('02_2A'xn);
   dcl HM_HELP_CONTENTS fixed bin(16) value('02_2B'xn);
   dcl HM_KEYS_HELP fixed bin(16) value('02_2C'xn);
   dcl HM_SET_HELP_LIBRARY_NAME fixed bin(16) value('02_2D'xn);
   dcl HM_SET_OBJCOM_WINDOW fixed bin(16) value('02_38'xn);
   dcl HM_UPDATE_OBJCOM_WINDOW_CHAIN fixed bin(16) value('02_39'xn);
   dcl HM_QUERY_DDF_DATA fixed bin(16) value('02_3A'xn);
   dcl HM_INVALIDATE_DDF_DATA fixed bin(16) value('02_3B'xn);
   dcl HM_QUERY fixed bin(16) value('02_3C'xn);
   dcl HM_SET_COVERPAGE_SIZE fixed bin(16) value('02_3D'xn);

   dcl HMQW_COVERPAGE fixed bin(16) value('00_01'xn);
   dcl HMQW_INDEX fixed bin(16) value('00_02'xn);
   dcl HMQW_TOC fixed bin(16) value('00_03'xn);
   dcl HMQW_SEARCH fixed bin(16) value('00_04'xn);
   dcl HMQW_VIEWPAGES fixed bin(16) value('00_05'xn);
   dcl HMQW_LIBRARY fixed bin(16) value('00_06'xn);
   dcl HMQW_VIEWPORT fixed bin(16) value('00_07'xn);
   dcl HMQW_OBJCOM_WINDOW fixed bin(16) value('00_08'xn);
   dcl HMQW_INSTANCE fixed bin(16) value('00_09'xn);
   dcl HMQW_ACTIVEVIEWPORT fixed bin(16) value('00_0A'xn);
   dcl CONTROL_SELECTED fixed bin(16) value('00_0B'xn);
   dcl HMQW_GROUP_VIEWPORT fixed bin(16) value('00_F1'xn);
   dcl HMQW_RES_VIEWPORT fixed bin(16) value('00_F2'xn);
   dcl USERDATA fixed bin(16) value('00_F3'xn);

   %dcl HMQVP_NUMBER char;
   %HMQVP_NUMBER=1;
   %dcl HMQVP_NAME char;
   %HMQVP_NAME=2;
   %dcl HMQVP_GROUP char;
   %HMQVP_GROUP=3;

   dcl CTRL_PREVIOUS_ID fixed bin(16) value('00_01'xn);
   dcl CTRL_SEARCH_ID fixed bin(16) value('00_02'xn);
   dcl CTRL_PRINT_ID fixed bin(16) value('00_03'xn);
   dcl CTRL_INDEX_ID fixed bin(16) value('00_04'xn);
   dcl CTRL_CONTENTS_ID fixed bin(16) value('00_05'xn);
   dcl CTRL_BACK_ID fixed bin(16) value('00_06'xn);
   dcl CTRL_FORWARD_ID fixed bin(16) value('00_07'xn);
   dcl CTRL_TUTORIAL_ID fixed bin(16) value('00_FF'xn);
   dcl CTRL_USER_ID_BASE fixed bin(16) value(257);

   dcl HM_ERROR fixed bin(16) value('02_2E'xn);
   dcl HM_HELPSUBITEM_NOT_FOUND fixed bin(16) value('02_2F'xn);
   dcl HM_QUERY_KEYS_HELP fixed bin(16) value('02_30'xn);
   dcl HM_TUTORIAL fixed bin(16) value('02_31'xn);
   dcl HM_EXT_HELP_UNDEFINED fixed bin(16) value('02_32'xn);
   dcl HM_GENERAL_HELP_UNDEFINED fixed bin(16) value('02_32'xn);
   dcl HM_ACTIONBAR_COMMAND fixed bin(16) value('02_33'xn);
   dcl HM_INFORM fixed bin(16) value('02_34'xn);
   dcl HM_NOTIFY fixed bin(16) value('02_42'xn);
   dcl HM_SET_USERDATA fixed bin(16) value('02_43'xn);
   dcl HM_CONTROL fixed bin(16) value('02_44'xn);

   dcl OPEN_COVERPAGE fixed bin(16) value('00_01'xn);
   dcl OPEN_PAGE fixed bin(16) value('00_02'xn);
   dcl SWAP_PAGE fixed bin(16) value('00_03'xn);
   dcl OPEN_TOC fixed bin(16) value('00_04'xn);
   dcl OPEN_INDEX fixed bin(16) value('00_05'xn);
   dcl OPEN_HISTORY fixed bin(16) value('00_06'xn);
   dcl OPEN_SEARCH_HIT_LIST fixed bin(16) value('00_07'xn);
   dcl OPEN_LIBRARY fixed bin(16) value('00_08'xn);
   dcl HELP_REQUESTED fixed bin(16) value('00_09'xn);
   dcl HMERR_NO_FRAME_WND_IN_CHAIN fixed bin(31) value('00_00_10_01'xn);
   dcl HMERR_INVALID_ASSOC_APP_WND fixed bin(31) value('00_00_10_02'xn);
   dcl HMERR_INVALID_ASSOC_HELP_INST fixed bin(31)
                                       value('00_00_10_03'xn);
   dcl HMERR_INVALID_DESTROY_HELP_INST fixed bin(31)
                                       value('00_00_10_04'xn);
   dcl HMERR_NO_HELP_INST_IN_CHAIN fixed bin(31) value('00_00_10_05'xn);
   dcl HMERR_INVALID_HELP_INSTANCE_HDL fixed bin(31)
                                       value('00_00_10_06'xn);
   dcl HMERR_INVALID_QUERY_APP_WND fixed bin(31)
                                       value('00_00_10_07'xn);
   dcl HMERR_HELP_INST_CALLED_INVALID fixed bin(31)
                                       value('00_00_10_08'xn);
   dcl HMERR_HELPTABLE_UNDEFINE fixed bin(31) value('00_00_10_09'xn);
   dcl HMERR_HELP_INSTANCE_UNDEFINE fixed bin(31)
                                       value('00_00_10_0A'xn);
   dcl HMERR_HELPITEM_NOT_FOUND fixed bin(31) value('00_00_10_0B'xn);
   dcl HMERR_INVALID_HELPSUBITEM_SIZE fixed bin(31)
                                       value('00_00_10_0C'xn);
   dcl HMERR_HELPSUBITEM_NOT_FOUND fixed bin(31) value('00_00_10_0D'xn);
   dcl HMERR_INDEX_NOT_FOUND fixed bin(31) value('00_00_20_01'xn);
   dcl HMERR_CONTENT_NOT_FOUND fixed bin(31) value('00_00_20_02'xn);
   dcl HMERR_OPEN_LIB_FILE fixed bin(31) value('00_00_20_03'xn);
   dcl HMERR_READ_LIB_FILE fixed bin(31) value('00_00_20_04'xn);
   dcl HMERR_CLOSE_LIB_FILE fixed bin(31) value('00_00_20_05'xn);
   dcl HMERR_INVALID_LIB_FILE fixed bin(31) value('00_00_20_06'xn);
   dcl HMERR_NO_MEMORY fixed bin(31) value('00_00_20_07'xn);
   dcl HMERR_ALLOCATE_SEGMENT fixed bin(31) value('00_00_20_08'xn);
   dcl HMERR_FREE_MEMORY fixed bin(31) value('00_00_20_09'xn);
   dcl HMERR_PANEL_NOT_FOUND fixed bin(31) value('00_00_20_10'xn);
   dcl HMERR_DATABASE_NOT_OPEN fixed bin(31) value('00_00_20_11'xn);
   dcl HMERR_LOAD_DLL fixed bin(31) value('00_00_20_12'xn);

   %dcl ACVP char;
   %ACVP='char(stg(#ACVP))';
   dcl 1 #ACVP based(null()) unaligned,
         2 cb ULONG,
         2 ACVP_hAB HAB,
         2 ACVP_hmq HMQ,
         2 ObjectID ULONG,
         2 hWndParent HWND,
         2 hWndOwner HWND,
         2 hWndACVP HWND;
   %if PMDDF_H='Y' %then %do;
     %PMDDF_H='Y';
   %end;
   %if INCL_DDF='Y' %then %do;
     %dcl HDDF char;
     %HDDF='pointer';
     %dcl REFERENCE_BY_ID char;
     %REFERENCE_BY_ID=0;
     %dcl REFERENCE_BY_RES char;
     %REFERENCE_BY_RES=1;
     %dcl HMBT_NONE char;
     %HMBT_NONE=1;
     %dcl HMBT_ALL char;
     %HMBT_ALL=2;
     %dcl HMBT_FIT char;
     %HMBT_FIT=3;
     %dcl HMLS_SINGLELINE char;
     %HMLS_SINGLELINE=1;
     %dcl HMLS_DOUBLELINE char;
     %HMLS_DOUBLELINE=2;

     dcl ART_RUNIN bit(8) value('00_01_00_00'b);
     dcl ART_LEFT bit(8) value('00_00_00_01'b);
     dcl ART_RIGHT bit(8) value('00_00_00_10'b);
     dcl ART_CENTER bit(8) value('00_00_01_00'b);

     %dcl CLR_UNCHANGED char;
     %CLR_UNCHANGED=-6;
     dcl DdfInitialize entry (
            HWND,
            ULONG,
            ULONG)
            returns(optional byvalue HDDF)
            APIENTRY;
     dcl DdfPara entry (
            HDDF)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl DdfSetFormat entry (
            HDDF,
            ULONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl DdfSetTextAlign entry (
            HDDF,
            ULONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl DdfSetColor entry (
            HDDF,
            COLOR,
            COLOR)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl DdfInform entry (
            HDDF,
            PSZ,
            ULONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl DdfSetFontStyle entry (
            HDDF,
            ULONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl DdfHyperText entry (
            HDDF,
            PSZ,
            PSZ,
            ULONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl DdfBeginList entry (
            HDDF,
            ULONG,
            ULONG,
            ULONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl DdfListItem entry (
            HDDF,
            PSZ,
            PSZ)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl DdfEndList entry (
            HDDF)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl DdfMetafile entry (
            HDDF,
            HMF,
            PRECTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl DdfText entry (
            HDDF,
            PSZ)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl DdfSetFont entry (
            HDDF,
            PSZ,
            ULONG,
            ULONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl DdfBitmap entry (
            HDDF,
            HBITMAP,
            ULONG)
            returns(optional byvalue BOOL)
            APIENTRY;

     dcl HMERR_DDF_MEMORY fixed bin(16) value('30_01'xn);
     dcl HMERR_DDF_ALIGN_TYPE fixed bin(16) value('30_02'xn);
     dcl HMERR_DDF_BACKCOLOR fixed bin(16) value('30_03'xn);
     dcl HMERR_DDF_FORECOLOR fixed bin(16) value('30_04'xn);
     dcl HMERR_DDF_FONTSTYLE fixed bin(16) value('30_05'xn);
     dcl HMERR_DDF_REFTYPE fixed bin(16) value('30_06'xn);
     dcl HMERR_DDF_LIST_UNCLOSED fixed bin(16) value('30_07'xn);
     dcl HMERR_DDF_LIST_UNINITIALIZED fixed bin(16) value('30_08'xn);
     dcl HMERR_DDF_LIST_BREAKTYPE fixed bin(16) value('30_09'xn);
     dcl HMERR_DDF_LIST_SPACING fixed bin(16) value('30_0A'xn);
     dcl HMERR_DDF_HINSTANCE fixed bin(16) value('30_0B'xn);
     dcl HMERR_DDF_EXCEED_MAX_LENGTH fixed bin(16) value('30_0C'xn);
     dcl HMERR_DDF_EXCEED_MAX_INC fixed bin(16) value('30_0D'xn);
     dcl HMERR_DDF_INVALID_DDF fixed bin(16) value('30_0E'xn);
     dcl HMERR_DDF_FORMAT_TYPE fixed bin(16) value('30_0F'xn);
     dcl HMERR_DDF_INVALID_PARM fixed bin(16) value('30_10'xn);
     dcl HMERR_DDF_INVALID_FONT fixed bin(16) value('30_11'xn);
     dcl HMERR_DDF_SEVERE fixed bin(16) value('30_12'xn);
   %end;
 %end;
 %if IBMC__='Y' %then %do;
   %if CHKHDR__='Y' %then %do;
   %end;
 %end;
