/*
*********************************************************************

SAMPLE NAME:  viewExit.c

USAGE:        User Exit, see <family dir>\config\UserExit for details

COMPILATION:  cc -o viewExit viewExit.c

ENVIRONMENT VARIABLES:
                       none

DESCRIPTION:  This sample user exit displays the parameter list passed to
              a user exit from a TeamConnection command.  This is the
              C program sample, there are equivalent samples for REXX and ksh.

*********************************************************************
*             IBM TeamConnection for OS/2
*                     Version 2 Release 0
*
*                       5622-717
*    (C) Copyright, IBM Corp., 1996. All Rights Reserved.
*             Licensed Materials - Property of IBM
*
*         US Government Users Restricted Rights
*     - Use, duplication or disclosure restricted by
*         GSA ADP Schedule Contract with IBM Corp.
*
*              IBM is a registered trademark of
*        International Business Machines Corporation
*********************************************************************
*
*           NOTICE TO USERS OF THE SOURCE CODE EXAMPLES
*
* INTERNATIONAL BUSINESS MACHINES CORPORATION PROVIDES THE SOURCE CODE
* EXAMPLES, BOTH INDIVIDUALLY AND AS ONE OR MORE GROUPS, "AS IS" WITHOUT
* WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
* PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE
* OF THE SOURCE CODE EXAMPLES, BOTH INDIVIDUALLY AND AS ONE OR MORE GROUPS,
* IS WITH YOU.  SHOULD ANY PART OF THE SOURCE CODE EXAMPLES PROVE
* DEFECTIVE, YOU (AND NOT IBM OR AN AUTHORIZED DEALER) ASSUME THE ENTIRE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
*********************************************************************
*/
#include <stdio.h>
#include <string.h>
#include <sys/types.h>

extern int errno;

/* This is based on a limit used for actions in TeamC */
#define maxParmName 40

/*-----------------------------------------------------------------------------\
|  envGetFromEnvFile:                                                          |
|  - Read each entry to environment file                                       |
|  - Read binary:                                                              |
|    size of parameter, parameter string, size of value, value string          |
|  - Minimal error checking to simplify example                                |
|  Note:  This routine is condensed from the sample program teamcenv.c         |
\-----------------------------------------------------------------------------*/
int envGetFromEnvFile(char *envFileName)
{
   FILE *envFile;

   int nNameLength;
   int nValueLength;
   char parameterName[maxParmName+1]; /* allow for maximum in TeamC (15 + NULL) */
   char parameterValue[16001]; /* allow for max in TeamC 16000 for remarks + NULL */

   /* Open temporary file */
   envFile = fopen(envFileName, "rb");
   if (envFile == NULL)
   {
       fprintf(stderr,"teamcenv: Error, could not open file \"%s\"\n",
          envFileName);
       return 1;
   }

   /* Dump all attributes */
      printf("\
Parameter                                Value\n\
=======================================  ======================================\n");
   fread(&nNameLength, sizeof(int), 1, envFile);
   fread(parameterName, sizeof(char), nNameLength, envFile);
   *(parameterName+nNameLength)='\0';
   fread(&nValueLength, sizeof(int), 1, envFile);
   fread(parameterValue, sizeof(char), nValueLength, envFile);
   *(parameterValue+nValueLength)='\0';

   while (!feof(envFile))
   {
      strncat(parameterName, "                                       ",
         (maxParmName - strlen(parameterName)));
      *(parameterName+maxParmName) = '\0';
      printf("%s %s\n", parameterName, parameterValue);
      fread(&nNameLength, sizeof(int), 1, envFile);
      *(parameterName+nNameLength)='\0';
      fread(parameterName, sizeof(char), nNameLength, envFile);
      fread(&nValueLength, sizeof(int), 1, envFile);
      fread(parameterValue, sizeof(char), nValueLength, envFile);
      *(parameterValue+nValueLength)='\0';
   }

   fclose(envFile);
   return 0;
}


/*-----------------------------------------------------------------------------\
|  main:                                                                       |
|  - Print standard set of arguments at beginning of parameter list:           |
|    UEprogram, UEparameter and EnvFile                                        |
|  - Print rest of arguments; the positional parameters                        |
|  - If EnvFile is not NULL, print the contents of the EnvFile                 |
\-----------------------------------------------------------------------------*/
int main(int argc, char *argv[])
{
   int i,n;

   /* Compute the number of action parameters passed at definition     */
   int totalParms = argc - 3;

   /* Display the name of the command.                                 */
   /* It is not necessary to parse name.                               */
   printf("UEProgram:               %s\n", argv[0]);

   /* Display parameter list.                                          */
   if (strlen(argv[1]) != 0)
      printf("UEParameters string:     %s\n", argv[1]);
   else
      printf("UEParameters string is NULL\n");

   /* Display parameter env file.                                      */
   if (strlen(argv[2]) != 0)
      printf("EnvFile name:            %s\n", argv[2]);
   else
      printf("No environment file; string is NULL\n");

   /* Display parameter list.                                          */
   for (i = 3; i < argc; i++)
   {
      n = strlen(argv[i]);
      if (n == 0)
         printf("Action Parameter [%d] is NULL\n", i-2);
      else
      {
         printf("Action Parameter [%d]:    %s\n", i-2, argv[i]);

         /* Ellipses in data, checking for end (i.e. truncation)       */
         /* - Each parameter limited to 400 bytes in OS/2, Windows     */
         /*   and Windows NT, and 16000 bytes in Unix                  */
         /* - Total command string limited to 1024 bytes in OS/2,      */
         /*   Windows and Windows NT, and 32000 bytes in Unix          */
         /* - compute address of last 3 characters then compare        */
         if (strcmp(((argv[i])+n-3), "...") == 0)
         {
            printf("                         parameter %d string was \
truncated!\n", (i-1));
            /* If last parameter truncated, then entire list truncated */
            if (i == (argc - 1))
               printf("Parameter list was truncated!\n");
         }
      }
   }
   printf("Total action parameters: %d\n", totalParms);

   /* Print contents of parameter env file.                            */
   if (strlen(argv[2]) != 0)
   {
      printf("Printing contents of Environment File\n");
      envGetFromEnvFile(argv[2]);
   }

   return (0);
}

/* End of File */
