/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.accessibility.Accessible;
import com.sun.java.accessibility.AccessibleComponent;
import com.sun.java.accessibility.AccessibleContext;
import com.sun.java.accessibility.AccessibleRole;
import com.sun.java.accessibility.AccessibleStateSet;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.SwingGraphics;
import com.sun.java.swing.SwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;

public class CellRendererPane
extends Container
implements Accessible {
    protected AccessibleContext accessibleContext;

    public CellRendererPane() {
        this.setLayout(null);
        this.setVisible(false);
    }

    public void invalidate() {
    }

    public void paint(Graphics graphics) {
    }

    public void update(Graphics graphics) {
    }

    protected void addImpl(Component component, Object object, int n) {
        if (component.getParent() == this) {
            return;
        }
        super.addImpl(component, object, n);
    }

    public void paintComponent(Graphics graphics, Component component, Container container, int n, int n2, int n3, int n4, boolean bl) {
        if (component == null) {
            if (container != null) {
                Color color = graphics.getColor();
                graphics.setColor(container.getBackground());
                graphics.fillRect(n, n2, n3, n4);
                graphics.setColor(color);
            }
            return;
        }
        if (component.getParent() != this) {
            this.add(component);
        }
        component.setBounds(n, n2, n3, n4);
        if (bl) {
            component.validate();
        }
        boolean bl2 = false;
        if (component instanceof JComponent && ((JComponent)component).isDoubleBuffered()) {
            bl2 = true;
            ((JComponent)component).setDoubleBuffered(false);
        }
        Graphics graphics2 = SwingGraphics.createGraphics(graphics, n, n2, n3, n4);
        try {
            component.paint(graphics2);
        }
        finally {
            Object var12_12 = null;
            graphics2.dispose();
        }
        if (component instanceof JComponent && bl2) {
            ((JComponent)component).setDoubleBuffered(true);
        }
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            jComponent.setDoubleBuffered(bl2);
        }
        component.setBounds(-n3, -n4, 0, 0);
    }

    public void paintComponent(Graphics graphics, Component component, Container container, int n, int n2, int n3, int n4) {
        this.paintComponent(graphics, component, container, n, n2, n3, n4, false);
    }

    public void paintComponent(Graphics graphics, Component component, Container container, Rectangle rectangle) {
        this.paintComponent(graphics, component, container, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.removeAll();
        objectOutputStream.defaultWriteObject();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleCellRendererPane();
        }
        return this.accessibleContext;
    }

    protected class AccessibleCellRendererPane
    extends AccessibleContext
    implements Serializable,
    AccessibleComponent {
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return SwingUtilities.getAccessibleStateSet(CellRendererPane.this);
        }

        public Accessible getAccessibleParent() {
            Container container = CellRendererPane.this.getParent();
            if (container instanceof Accessible) {
                return (Accessible)((Object)container);
            }
            return null;
        }

        public int getAccessibleIndexInParent() {
            return SwingUtilities.getAccessibleIndexInParent(CellRendererPane.this);
        }

        public int getAccessibleChildrenCount() {
            return SwingUtilities.getAccessibleChildrenCount(CellRendererPane.this);
        }

        public Accessible getAccessibleChild(int n) {
            return SwingUtilities.getAccessibleChild(CellRendererPane.this, n);
        }

        public Locale getLocale() {
            return CellRendererPane.this.getLocale();
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public Color getBackground() {
            return CellRendererPane.this.getBackground();
        }

        public void setBackground(Color color) {
            CellRendererPane.this.setBackground(color);
        }

        public Color getForeground() {
            return CellRendererPane.this.getForeground();
        }

        public void setForeground(Color color) {
            CellRendererPane.this.setForeground(color);
        }

        public Cursor getCursor() {
            return CellRendererPane.this.getCursor();
        }

        public void setCursor(Cursor cursor) {
            CellRendererPane.this.setCursor(cursor);
        }

        public Font getFont() {
            return CellRendererPane.this.getFont();
        }

        public void setFont(Font font) {
            ((Component)CellRendererPane.this).setFont(font);
        }

        public FontMetrics getFontMetrics(Font font) {
            return CellRendererPane.this.getFontMetrics(font);
        }

        public boolean isEnabled() {
            return CellRendererPane.this.isEnabled();
        }

        public void setEnabled(boolean bl) {
            CellRendererPane.this.setEnabled(bl);
        }

        public boolean isVisible() {
            return CellRendererPane.this.isVisible();
        }

        public void setVisible(boolean bl) {
            CellRendererPane.this.setVisible(bl);
        }

        public boolean isShowing() {
            return CellRendererPane.this.isShowing();
        }

        public boolean contains(Point point) {
            return CellRendererPane.this.contains(point);
        }

        public Point getLocationOnScreen() {
            return CellRendererPane.this.getLocationOnScreen();
        }

        public Point getLocation() {
            return CellRendererPane.this.getLocation();
        }

        public void setLocation(Point point) {
            CellRendererPane.this.setLocation(point);
        }

        public Rectangle getBounds() {
            return CellRendererPane.this.getBounds();
        }

        public void setBounds(Rectangle rectangle) {
            CellRendererPane.this.setBounds(rectangle);
        }

        public Dimension getSize() {
            return CellRendererPane.this.getSize();
        }

        public void setSize(Dimension dimension) {
            CellRendererPane.this.setSize(dimension);
        }

        public Accessible getAccessibleAt(Point point) {
            return SwingUtilities.getAccessibleAt(CellRendererPane.this, point);
        }

        public boolean isFocusTraversable() {
            return CellRendererPane.this.isFocusTraversable();
        }

        public void requestFocus() {
            CellRendererPane.this.requestFocus();
        }

        public void addFocusListener(FocusListener focusListener) {
            CellRendererPane.this.addFocusListener(focusListener);
        }

        public void removeFocusListener(FocusListener focusListener) {
            CellRendererPane.this.removeFocusListener(focusListener);
        }

        AccessibleCellRendererPane() {
            CellRendererPane.this = CellRendererPane.this;
        }
    }
}

