/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.DefaultDesktopManager;
import com.sun.java.swing.JInternalFrame;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.util.Vector;

public class WindowsDesktopManager
extends DefaultDesktopManager
implements Serializable {
    JInternalFrame currentFrame;
    Vector childFrames = new Vector(1);

    public void closeFrame(JInternalFrame jInternalFrame) {
        this.activateNextFrame();
        this.childFrames.removeElement(jInternalFrame);
        super.closeFrame(jInternalFrame);
    }

    public void activateFrame(JInternalFrame jInternalFrame) {
        try {
            super.activateFrame(jInternalFrame);
            if (this.childFrames.indexOf(jInternalFrame) == -1) {
                this.childFrames.addElement(jInternalFrame);
            }
            if (this.currentFrame != null && jInternalFrame != this.currentFrame) {
                if (this.currentFrame.isMaximum()) {
                    this.currentFrame.setMaximum(false);
                    jInternalFrame.setMaximum(true);
                }
                if (this.currentFrame.isSelected()) {
                    this.currentFrame.setSelected(false);
                }
            }
            if (!jInternalFrame.isSelected()) {
                jInternalFrame.setSelected(true);
            }
            this.currentFrame = jInternalFrame;
            return;
        }
        catch (PropertyVetoException propertyVetoException) {
            return;
        }
    }

    private void switchFrame(boolean bl) {
        int n;
        if (this.currentFrame == null) {
            return;
        }
        int n2 = this.childFrames.size();
        if (n2 <= 1) {
            return;
        }
        int n3 = this.childFrames.indexOf(this.currentFrame);
        if (n3 == -1) {
            return;
        }
        if (bl) {
            n = n3 + 1;
            if (n == n2) {
                n = 0;
            }
        } else {
            n = n3 - 1;
            if (n == -1) {
                n = n2 - 1;
            }
        }
        JInternalFrame jInternalFrame = (JInternalFrame)this.childFrames.elementAt(n);
        this.activateFrame(jInternalFrame);
        this.currentFrame = jInternalFrame;
    }

    public void activateNextFrame() {
        this.switchFrame(true);
    }

    public void activatePreviousFrame() {
        this.switchFrame(false);
    }
}

