/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcmerge;

import com.ibm.vatc.reuse.awt.ButtonPanel;
import com.ibm.vatc.reuse.awt.EButton;
import com.ibm.vatc.reuse.awt.GridTools;
import com.ibm.vatc.reuse.awt.ImageButton;
import com.ibm.vatc.tcmerge.DiffInfoCommon;
import com.ibm.vatc.tcmerge.MakeViews;
import com.ibm.vatc.tcmerge.MergeGui;
import com.ibm.vatc.tcmerge.StringTools;
import com.ibm.vatc.tcmerge.TCMergeException;
import com.ibm.vatc.tcmerge.TCMergeHelp;
import com.ibm.vatc.tcmerge.TextComposite;
import com.ibm.vatc.tcmerge.TextRefOutput;
import com.ibm.vatc.tcmerge.UndoInfo;
import com.ibm.vatc.tcmerge.WarningDialog;
import com.ibm.vatc.tcmerge.tcmerge;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;

class EditLineDialog
extends Dialog {
    Frame parentFrame;
    TextField lineNumberTextField;
    TextField lineDataTextField;
    int currentLineNumber;
    int startLineNumber;
    int endLineNumber;
    MergeGui mergeGui;
    MakeViews makeViews;
    Vector tableComposite;
    Vector tableOutput;
    Vector diffTableOutput;
    Vector tableEdit;
    Vector changes;
    String lineData;
    boolean modalOn;
    boolean firstFocus;
    static /* synthetic */ Class class$com$ibm$vatc$tcmerge$EditLineDialog;

    public EditLineDialog(MergeGui mergeGui, int n, int n2, int n3) {
        super(mergeGui, tcmerge.locResource.getString("ITEM_EDIT_CURR_DIFF"), true);
        this.parentFrame = mergeGui;
        this.mergeGui = mergeGui;
        this.startLineNumber = n;
        this.currentLineNumber = n2;
        this.endLineNumber = n3;
        this.makeViews = mergeGui.getMakeViews();
        this.tableComposite = this.makeViews.getTableComposite();
        this.diffTableOutput = this.makeViews.getDiffTableOutput();
        this.tableOutput = this.makeViews.getTableOutput();
        this.tableEdit = this.makeViews.getTableEdit();
        this.createDialog();
    }

    public void editNewBlock(int n, int n2, int n3) {
        this.startLineNumber = n;
        this.currentLineNumber = n2;
        this.endLineNumber = n3;
        this.changes = new Vector();
        ((TextComponent)this.lineNumberTextField).setText(new Integer(n2 + 1).toString());
        this.lineData = this.retrieveString(n2);
        ((TextComponent)this.lineDataTextField).setText(this.lineData);
    }

    private String retrieveString(int n) {
        String string;
        Object object;
        ChangedText changedText = new ChangedText(n, "");
        int n2 = this.changes.indexOf(changedText);
        if (n2 == -1) {
            object = (TextRefOutput)this.tableOutput.elementAt(n);
            if ((((TextRefOutput)object).flag & 8) != 0) {
                string = (String)this.tableEdit.elementAt(((TextRefOutput)object).textRef);
            } else if (((TextRefOutput)object).textRef == -3) {
                string = "";
            } else if (((TextRefOutput)object).textRef == -2) {
                string = tcmerge.locResource.getString("STR_LINE_WILL_NOT_BE_SAVED");
            } else if (((TextRefOutput)object).textRef == -1) {
                string = "";
            } else {
                TextComposite textComposite = (TextComposite)this.tableComposite.elementAt(((TextRefOutput)object).textRef);
                string = textComposite.text;
            }
        } else {
            changedText = (ChangedText)this.changes.elementAt(n2);
            string = changedText.newText;
        }
        object = StringTools.stripChar(string, '\t');
        return object;
    }

    private void editedText(int n, String string) {
        ChangedText changedText = new ChangedText(n, string);
        int n2 = this.changes.indexOf(changedText);
        if (n2 == -1) {
            this.changes.addElement(changedText);
            return;
        }
        this.changes.setElementAt(changedText, n2);
    }

    private void applyChanges() {
        Object object;
        UndoInfo undoInfo = new UndoInfo();
        undoInfo.diffNumber = this.mergeGui.getViewParam().getCurrentDiff();
        DiffInfoCommon diffInfoCommon = (DiffInfoCommon)this.diffTableOutput.elementAt(undoInfo.diffNumber);
        int n = diffInfoCommon.getStartBlock();
        int n2 = diffInfoCommon.getEndBlock();
        int n3 = n;
        while (n3 <= n2) {
            TextRefOutput textRefOutput = (TextRefOutput)this.tableOutput.elementAt(n3);
            object = new TextRefOutput();
            ((TextRefOutput)object).textRef = textRefOutput.textRef;
            ((TextRefOutput)object).flag = textRefOutput.flag;
            undoInfo.diffTextRef.addElement(object);
            ++n3;
        }
        this.makeViews.addUndoInfo(undoInfo);
        int n4 = 0;
        object = this.changes.elements();
        while (object.hasMoreElements()) {
            ChangedText changedText = (ChangedText)object.nextElement();
            this.tableEdit.addElement(changedText.newText);
            int n5 = this.tableEdit.size() - 1;
            TextRefOutput textRefOutput = (TextRefOutput)this.tableOutput.elementAt(changedText.ref);
            textRefOutput.textRef = n5;
            textRefOutput.flag = (byte)(textRefOutput.flag & 0xF);
            textRefOutput.flag = (byte)(textRefOutput.flag | 8);
            this.mergeGui.getViewParam().setOutputSaved(false);
            this.mergeGui.setOutputViewTitle();
            ++n4;
        }
        this.changes = new Vector();
        this.mergeGui.getOutputView().repaint();
    }

    private void createDialog() {
        this.modalOn = false;
        this.firstFocus = true;
        this.changes = new Vector();
        DialogListener dialogListener = new DialogListener();
        this.addWindowListener(dialogListener);
        KeyboardListener keyboardListener = new KeyboardListener();
        this.addKeyListener(keyboardListener);
        ((Component)this).setSize(360, 190);
        this.setResizable(false);
        this.setLayout(new GridBagLayout());
        GridTools.constrain(this, new Label(tcmerge.locResource.getString("STR_LINE")), 2, 2, 1, 1);
        this.lineNumberTextField = new TextField(new Integer(this.currentLineNumber + 1).toString(), 5);
        this.lineNumberTextField.addKeyListener(keyboardListener);
        this.lineNumberTextField.addKeyListener(new TextFieldKeyListener("Go To"));
        GridTools.constrain(this, this.lineNumberTextField, 3, 2, 1, 1);
        EButton eButton = new EButton(tcmerge.locResource.getString("STR_GO_TO"));
        eButton.setActionCommand("Go To");
        eButton.addActionListener(new ButtonListener());
        eButton.addKeyListener(keyboardListener);
        GridTools.constrain(this, eButton, 5, 2, 1, 1);
        Panel panel = new Panel();
        Toolkit.getDefaultToolkit();
        Image image = Toolkit.getDefaultToolkit().getImage((class$com$ibm$vatc$tcmerge$EditLineDialog != null ? class$com$ibm$vatc$tcmerge$EditLineDialog : (class$com$ibm$vatc$tcmerge$EditLineDialog = EditLineDialog.class$("com.ibm.vatc.tcmerge.EditLineDialog"))).getResource("leftArr.gif"));
        Image image2 = Toolkit.getDefaultToolkit().getImage((class$com$ibm$vatc$tcmerge$EditLineDialog != null ? class$com$ibm$vatc$tcmerge$EditLineDialog : (class$com$ibm$vatc$tcmerge$EditLineDialog = EditLineDialog.class$("com.ibm.vatc.tcmerge.EditLineDialog"))).getResource("rightArr.gif"));
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        mediaTracker.addImage(image2, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("java.lang.InterruptedException caught in EditLineDialog.createDialog");
        }
        ImageButton imageButton = new ImageButton(image);
        imageButton.addMouseListener(new ImageButtonListener("leftArrow"));
        panel.add(imageButton);
        imageButton = new ImageButton(image2);
        imageButton.addMouseListener(new ImageButtonListener("rightArrow"));
        panel.add(imageButton);
        panel.addKeyListener(keyboardListener);
        GridTools.constrain(this, panel, 7, 2, 1, 1);
        this.lineData = this.retrieveString(this.currentLineNumber);
        this.lineDataTextField = new TextField(this.lineData, 38);
        this.lineDataTextField.addKeyListener(keyboardListener);
        GridTools.constrain(this, this.lineDataTextField, 2, 4, 6, 1);
        String[][] stringArray = new String[][]{{tcmerge.locResource.getString("STR_OK"), "OK"}, {tcmerge.locResource.getString("STR_CANCEL"), "Cancel"}, {tcmerge.locResource.getString("STR_APPLY"), "Apply"}, {tcmerge.locResource.getString("STR_HELP"), "Help"}};
        ButtonPanel buttonPanel = new ButtonPanel(stringArray, new ButtonListener());
        buttonPanel.addKeyListener(keyboardListener);
        GridTools.constrain(this, buttonPanel, 2, 6, 6, 1, 0, 0, 13, 0);
        Canvas canvas = new Canvas();
        canvas.setSize(15, 25);
        GridTools.constrain(this, canvas, 4, 5, 1, 1);
        Canvas canvas2 = new Canvas();
        canvas2.setSize(30, 15);
        GridTools.constrain(this, canvas2, 6, 3, 1, 1);
        Canvas canvas3 = new Canvas();
        canvas3.setSize(15, 15);
        GridTools.constrain(this, canvas3, 1, 1, 1, 1);
        Canvas canvas4 = new Canvas();
        canvas4.setSize(15, 15);
        GridTools.constrain(this, canvas4, 8, 7, 1, 1);
        this.pack();
        Dimension dimension = this.parentFrame.getSize();
        Dimension dimension2 = this.getSize();
        Point point = this.parentFrame.getLocationOnScreen();
        ((Component)this).setLocation(point.x + 30, point.y + (dimension.height - dimension2.height) / 2);
    }

    public void goToEvent() {
        try {
            String string = this.lineNumberTextField.getText();
            string = StringTools.stripChar(string, ' ');
            try {
                Integer n = new Integer(string);
                if (n - 1 < this.startLineNumber || n - 1 > this.endLineNumber) {
                    throw new TCMergeException(7, string, new Integer(this.startLineNumber + 1).toString(), new Integer(this.endLineNumber + 1).toString());
                }
                String string2 = this.lineDataTextField.getText();
                if (!this.lineData.equals(string2)) {
                    this.editedText(this.currentLineNumber, string2);
                }
                this.currentLineNumber = n - 1;
                this.lineData = this.retrieveString(this.currentLineNumber);
                ((TextComponent)this.lineDataTextField).setText(this.lineData);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                throw new TCMergeException(7, string, new Integer(this.startLineNumber + 1).toString(), new Integer(this.endLineNumber + 1).toString());
            }
        }
        catch (TCMergeException tCMergeException) {
            WarningDialog warningDialog = new WarningDialog(this.parentFrame, tCMergeException.toString());
            this.modalOn = true;
            warningDialog.show();
            this.modalOn = false;
            warningDialog.dispose();
            ((TextComponent)this.lineNumberTextField).setText(new Integer(this.currentLineNumber + 1).toString());
            return;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    final /* synthetic */ void access$0(int n, String string) {
        this.editedText(n, string);
    }

    final /* synthetic */ String access$1(int n) {
        return this.retrieveString(n);
    }

    final /* synthetic */ void access$2() {
        this.applyChanges();
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
            EditLineDialog.this = EditLineDialog.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Go To")) {
                if (EditLineDialog.this.modalOn) {
                    return;
                }
                EditLineDialog.this.goToEvent();
                return;
            }
            if (string.equals("OK")) {
                if (EditLineDialog.this.modalOn) {
                    return;
                }
                String string2 = EditLineDialog.this.lineDataTextField.getText();
                if (!EditLineDialog.this.lineData.equals(string2)) {
                    EditLineDialog.this.access$0(EditLineDialog.this.currentLineNumber, string2);
                }
                EditLineDialog.this.access$2();
                ((Component)EditLineDialog.this).setVisible(false);
                return;
            }
            if (string.equals("Cancel")) {
                if (EditLineDialog.this.modalOn) {
                    return;
                }
                ((Component)EditLineDialog.this).setVisible(false);
                return;
            }
            if (string.equals("Apply")) {
                if (EditLineDialog.this.modalOn) {
                    return;
                }
                String string3 = EditLineDialog.this.lineDataTextField.getText();
                if (!EditLineDialog.this.lineData.equals(string3)) {
                    EditLineDialog.this.access$0(EditLineDialog.this.currentLineNumber, string3);
                }
                EditLineDialog.this.access$2();
                return;
            }
            if (string.equals("Help")) {
                TCMergeHelp.showHelp(EditLineDialog.this.parentFrame, "HDRHDI0300");
            }
        }
    }

    class ImageButtonListener
    extends MouseAdapter {
        String action;

        ImageButtonListener(String string) {
            EditLineDialog.this = EditLineDialog.this;
            this.action = string;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            String string = EditLineDialog.this.lineDataTextField.getText();
            if (!EditLineDialog.this.lineData.equals(string)) {
                EditLineDialog.this.access$0(EditLineDialog.this.currentLineNumber, string);
            }
            EditLineDialog.this.currentLineNumber = this.action.equals("leftArrow") ? (EditLineDialog.this.currentLineNumber == EditLineDialog.this.startLineNumber ? EditLineDialog.this.endLineNumber : --EditLineDialog.this.currentLineNumber) : (EditLineDialog.this.currentLineNumber == EditLineDialog.this.endLineNumber ? EditLineDialog.this.startLineNumber : ++EditLineDialog.this.currentLineNumber);
            EditLineDialog.this.lineData = EditLineDialog.this.access$1(EditLineDialog.this.currentLineNumber);
            ((TextComponent)EditLineDialog.this.lineDataTextField).setText(EditLineDialog.this.lineData);
            ((TextComponent)EditLineDialog.this.lineNumberTextField).setText(new Integer(EditLineDialog.this.currentLineNumber + 1).toString());
        }
    }

    class DialogListener
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            EditLineDialog.this.firstFocus = true;
            if (EditLineDialog.this.modalOn) {
                return;
            }
            ((Component)EditLineDialog.this).setVisible(false);
        }

        public void windowActivated(WindowEvent windowEvent) {
            if (EditLineDialog.this.firstFocus) {
                EditLineDialog.this.lineNumberTextField.requestFocus();
                EditLineDialog.this.firstFocus = false;
            }
        }

        DialogListener() {
            EditLineDialog.this = EditLineDialog.this;
        }
    }

    class KeyboardListener
    extends KeyAdapter {
        KeyboardListener() {
            EditLineDialog.this = EditLineDialog.this;
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27) {
                if (EditLineDialog.this.modalOn) {
                    return;
                }
                ((Component)EditLineDialog.this).setVisible(false);
            }
        }
    }

    class TextFieldKeyListener
    extends KeyAdapter {
        String action;

        TextFieldKeyListener(String string) {
            EditLineDialog.this = EditLineDialog.this;
            this.action = string;
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10 && this.action.equals("Go To")) {
                if (EditLineDialog.this.modalOn) {
                    return;
                }
                EditLineDialog.this.goToEvent();
            }
        }
    }

    class ChangedText {
        public int ref;
        public String newText;

        ChangedText(int n, String string) {
            EditLineDialog.this = EditLineDialog.this;
            this.ref = n;
            this.newText = string;
        }

        public boolean equals(Object object) {
            return this.toString().equals(object.toString());
        }

        public String toString() {
            return new Integer(this.ref).toString();
        }
    }
}

