/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.accessibility.Accessible;
import com.sun.java.accessibility.AccessibleContext;
import com.sun.java.accessibility.AccessibleRole;
import com.sun.java.accessibility.AccessibleSelection;
import com.sun.java.accessibility.AccessibleState;
import com.sun.java.swing.Action;
import com.sun.java.swing.ButtonModel;
import com.sun.java.swing.DefaultButtonModel;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JMenuBar;
import com.sun.java.swing.JMenuItem;
import com.sun.java.swing.JPopupMenu;
import com.sun.java.swing.JSeparator;
import com.sun.java.swing.KeyStroke;
import com.sun.java.swing.MenuElement;
import com.sun.java.swing.MenuSelectionManager;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import com.sun.java.swing.event.MenuEvent;
import com.sun.java.swing.event.MenuListener;
import com.sun.java.swing.event.PopupMenuEvent;
import com.sun.java.swing.event.PopupMenuListener;
import com.sun.java.swing.plaf.MenuUI;
import com.sun.java.swing.plaf.PopupMenuUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Vector;

public class JMenu
extends JMenuItem
implements Accessible,
MenuElement {
    private JPopupMenu popupMenu;
    private ChangeListener menuChangeListener;
    private MenuEvent menuEvent;
    private int delay;
    protected WinListener popupListener;
    static /* synthetic */ Class class$com$sun$java$swing$event$MenuListener;

    public JMenu() {
        this("");
    }

    public JMenu(String string) {
        this.init(string, null);
        this.updateUI();
    }

    public JMenu(String string, boolean bl) {
        this(string);
    }

    public void setUI(MenuUI menuUI) {
        super.setUI(menuUI);
    }

    public void updateUI() {
        this.setUI((MenuUI)UIManager.getUI(this));
        if (this.popupMenu != null) {
            this.popupMenu.setUI((PopupMenuUI)UIManager.getUI(this.popupMenu));
        }
    }

    public String getUIClassID() {
        return "MenuUI";
    }

    public void setModel(ButtonModel buttonModel) {
        ButtonModel buttonModel2 = this.getModel();
        super.setModel(buttonModel);
        if (buttonModel2 != null) {
            buttonModel2.removeChangeListener(this.menuChangeListener);
            this.menuChangeListener = null;
        }
        this.model = buttonModel;
        if (buttonModel != null) {
            this.menuChangeListener = this.createMenuChangeListener();
            buttonModel.addChangeListener(this.menuChangeListener);
        }
    }

    public boolean isSelected() {
        return this.getModel().isSelected();
    }

    public void setSelected(boolean bl) {
        ButtonModel buttonModel = this.getModel();
        boolean bl2 = buttonModel.isSelected();
        if (this.accessibleContext != null && bl2 != bl) {
            if (bl) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.SELECTED);
            } else {
                this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.SELECTED, null);
            }
        }
        if (bl != buttonModel.isSelected()) {
            this.getModel().setSelected(bl);
        }
    }

    public boolean isPopupMenuVisible() {
        this.ensurePopupMenuCreated();
        return this.popupMenu.isVisible();
    }

    public void setPopupMenuVisible(boolean bl) {
        boolean bl2 = this.isPopupMenuVisible();
        if (bl != bl2) {
            this.ensurePopupMenuCreated();
            int n = 0;
            int n2 = 0;
            if (bl && this.isShowing()) {
                Container container = this.getParent();
                Dimension dimension = this.getSize();
                if (container instanceof JPopupMenu) {
                    n = dimension.width;
                    n2 = 0;
                } else {
                    n = 0;
                    n2 = dimension.height;
                }
                this.popupMenu.show(this, n, n2);
                return;
            }
            this.popupMenu.setVisible(false);
        }
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Delay must be a positive integer");
        }
        this.delay = n;
    }

    private void ensurePopupMenuCreated() {
        if (this.popupMenu == null) {
            JMenu jMenu = this;
            this.popupMenu = new JPopupMenu();
            this.popupMenu.setInvoker(this);
            this.popupListener = this.createWinListener(this.popupMenu);
            this.popupMenu.addPopupMenuListener(new 1(jMenu));
        }
    }

    public void setMenuLocation(int n, int n2) {
        this.popupMenu.setLocation(n, n2);
    }

    public JMenuItem add(JMenuItem jMenuItem) {
        AccessibleContext accessibleContext = jMenuItem.getAccessibleContext();
        accessibleContext.setAccessibleParent(this);
        this.ensurePopupMenuCreated();
        return this.popupMenu.add(jMenuItem);
    }

    public Component add(Component component) {
        AccessibleContext accessibleContext = ((JComponent)component).getAccessibleContext();
        accessibleContext.setAccessibleParent(this);
        this.ensurePopupMenuCreated();
        this.popupMenu.add(component);
        return component;
    }

    public void add(String string) {
        this.add(new JMenuItem(string));
    }

    public JMenuItem add(Action action) {
        JMenuItem jMenuItem = new JMenuItem((String)action.getValue("Name"), (Icon)action.getValue("SmallIcon"));
        jMenuItem.setHorizontalTextPosition(4);
        jMenuItem.setVerticalTextPosition(0);
        jMenuItem.setEnabled(action.isEnabled());
        jMenuItem.addActionListener(action);
        this.add(jMenuItem);
        PropertyChangeListener propertyChangeListener = this.createActionChangeListener(jMenuItem);
        action.addPropertyChangeListener(propertyChangeListener);
        return jMenuItem;
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem jMenuItem) {
        return new ActionChangedListener(jMenuItem);
    }

    public void addSeparator() {
        this.ensurePopupMenuCreated();
        this.popupMenu.addSeparator();
    }

    public void insert(String string, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        this.popupMenu.insert(new JMenuItem(string), n);
    }

    public JMenuItem insert(JMenuItem jMenuItem, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        AccessibleContext accessibleContext = jMenuItem.getAccessibleContext();
        accessibleContext.setAccessibleParent(this);
        this.ensurePopupMenuCreated();
        this.popupMenu.insert(jMenuItem, n);
        return jMenuItem;
    }

    public JMenuItem insert(Action action, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        JMenuItem jMenuItem = new JMenuItem((String)action.getValue("Name"));
        jMenuItem.addActionListener(action);
        this.popupMenu.insert(jMenuItem, n);
        action.addPropertyChangeListener(new ActionChangedListener(jMenuItem));
        return jMenuItem;
    }

    public void insertSeparator(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        this.popupMenu.insert(new JSeparator(), n);
    }

    public JMenuItem getItem(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        Component component = this.getMenuComponent(n);
        if (component instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)component;
            return jMenuItem;
        }
        return this;
    }

    public int getItemCount() {
        return this.getMenuComponentCount();
    }

    public boolean isTearOff() {
        throw new Error("boolean isTearOff() {} not yet implemented");
    }

    public void remove(JMenuItem jMenuItem) {
        this.popupMenu.remove(jMenuItem);
    }

    public void remove(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.popupMenu.remove(n);
    }

    public void removeAll() {
        int n = this.getMenuComponentCount();
        int n2 = 0;
        while (n2 < n) {
            this.remove(0);
            ++n2;
        }
    }

    public int getMenuComponentCount() {
        int n = 0;
        if (this.popupMenu != null) {
            n = this.popupMenu.getComponentCount();
        }
        return n;
    }

    public Component getMenuComponent(int n) {
        if (this.popupMenu != null) {
            return this.popupMenu.getComponent(n);
        }
        return null;
    }

    public Component[] getMenuComponents() {
        if (this.popupMenu != null) {
            return this.popupMenu.getComponents();
        }
        return new Component[0];
    }

    public String paramString() {
        String string = ", JMenu";
        return String.valueOf(super.paramString()) + string;
    }

    public boolean isTopLevelMenu() {
        return this.getParent() instanceof JMenuBar;
    }

    public boolean isMenuComponent(Component component) {
        JPopupMenu jPopupMenu;
        if (component == this) {
            return true;
        }
        if (component instanceof JPopupMenu && (jPopupMenu = (JPopupMenu)component) == this.getPopupMenu()) {
            return true;
        }
        int n = this.getMenuComponentCount();
        Component[] componentArray = this.getMenuComponents();
        int n2 = 0;
        while (n2 < n) {
            JMenu jMenu;
            Component component2 = componentArray[n2];
            if (component2 == component) {
                return true;
            }
            if (component2 instanceof JMenu && (jMenu = (JMenu)component2).isMenuComponent(component)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private Point translateToPopupMenu(Point point) {
        return this.translateToPopupMenu(point.x, point.y);
    }

    private Point translateToPopupMenu(int n, int n2) {
        int n3;
        int n4;
        if (this.getParent() instanceof JPopupMenu) {
            n4 = n - this.getSize().width;
            n3 = n2;
        } else {
            n4 = n;
            n3 = n2 - this.getSize().height;
        }
        return new Point(n4, n3);
    }

    public JPopupMenu getPopupMenu() {
        this.ensurePopupMenuCreated();
        return this.popupMenu;
    }

    public void addMenuListener(MenuListener menuListener) {
        this.listenerList.add(class$com$sun$java$swing$event$MenuListener != null ? class$com$sun$java$swing$event$MenuListener : (class$com$sun$java$swing$event$MenuListener = JComponent.class$("com.sun.java.swing.event.MenuListener")), menuListener);
    }

    public void removeMenuListener(MenuListener menuListener) {
        this.listenerList.remove(class$com$sun$java$swing$event$MenuListener != null ? class$com$sun$java$swing$event$MenuListener : (class$com$sun$java$swing$event$MenuListener = JComponent.class$("com.sun.java.swing.event.MenuListener")), menuListener);
    }

    protected void fireMenuSelected() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$java$swing$event$MenuListener != null ? class$com$sun$java$swing$event$MenuListener : JComponent.class$("com.sun.java.swing.event.MenuListener"))) {
                if (objectArray[n + 1] == null) {
                    throw new Error(String.valueOf(this.getText()) + " has a NULL Listener!! " + n);
                }
                if (this.menuEvent == null) {
                    this.menuEvent = new MenuEvent(this);
                }
                ((MenuListener)objectArray[n + 1]).menuSelected(this.menuEvent);
            }
            n -= 2;
        }
    }

    protected void fireMenuDeselected() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$java$swing$event$MenuListener != null ? class$com$sun$java$swing$event$MenuListener : JComponent.class$("com.sun.java.swing.event.MenuListener"))) {
                if (objectArray[n + 1] == null) {
                    System.out.println(String.valueOf(this.getText()) + " has a NULL Listener!! " + n);
                } else {
                    if (this.menuEvent == null) {
                        this.menuEvent = new MenuEvent(this);
                    }
                    ((MenuListener)objectArray[n + 1]).menuDeselected(this.menuEvent);
                }
            }
            n -= 2;
        }
    }

    private ChangeListener createMenuChangeListener() {
        return new MenuChangeListener();
    }

    protected WinListener createWinListener(JPopupMenu jPopupMenu) {
        return new WinListener(jPopupMenu);
    }

    public void processMouseEvent(MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
        ((MenuUI)this.getUI()).processMouseEvent(this, mouseEvent, menuElementArray, menuSelectionManager);
    }

    public void processKeyEvent(KeyEvent keyEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
        ((MenuUI)this.getUI()).processKeyEvent(this, keyEvent, menuElementArray, menuSelectionManager);
    }

    public void menuSelectionChanged(boolean bl) {
        this.setSelected(bl);
    }

    public MenuElement[] getSubElements() {
        if (this.popupMenu == null) {
            return new MenuElement[0];
        }
        MenuElement[] menuElementArray = new MenuElement[]{this.popupMenu};
        return menuElementArray;
    }

    public Component getComponent() {
        return this;
    }

    public void setAccelerator(KeyStroke keyStroke) {
        throw new Error("setAccelerator() is not defined for JMenu.  Use setMnemonic() instead.");
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
        if (keyEvent.isConsumed()) {
            return;
        }
        super.processKeyEvent(keyEvent);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJMenu();
        }
        return this.accessibleContext;
    }

    private final class 1
    implements PopupMenuListener {
        private final /* synthetic */ JMenu val$thisMenu;

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            ((MenuUI)JMenu.this.getUI()).menuCanceled(this.val$thisMenu);
        }

        /* synthetic */ 1(JMenu jMenu2) {
            this.val$thisMenu = jMenu2;
        }
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        JMenuItem menuItem;

        ActionChangedListener(JMenuItem jMenuItem) {
            JMenu.this = JMenu.this;
            this.menuItem = jMenuItem;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getPropertyName().equals("Name")) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                this.menuItem.setText(string2);
                return;
            }
            if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.menuItem.setEnabled(bl);
                return;
            }
            if (propertyChangeEvent.getPropertyName().equals("SmallIcon")) {
                Icon icon = (Icon)propertyChangeEvent.getNewValue();
                this.menuItem.setIcon(icon);
                this.menuItem.invalidate();
                this.menuItem.repaint();
            }
        }
    }

    class MenuChangeListener
    implements ChangeListener,
    Serializable {
        boolean isSelected = false;

        public void stateChanged(ChangeEvent changeEvent) {
            DefaultButtonModel defaultButtonModel = (DefaultButtonModel)changeEvent.getSource();
            boolean bl = defaultButtonModel.isSelected();
            if (bl != this.isSelected) {
                if (bl) {
                    JMenu.this.fireMenuSelected();
                } else {
                    JMenu.this.fireMenuDeselected();
                }
                this.isSelected = bl;
            }
        }

        MenuChangeListener() {
            JMenu.this = JMenu.this;
        }
    }

    protected class WinListener
    extends WindowAdapter
    implements Serializable {
        JPopupMenu popupMenu;

        public WinListener(JPopupMenu jPopupMenu) {
            JMenu.this = JMenu.this;
            this.popupMenu = jPopupMenu;
        }

        public void windowClosing(WindowEvent windowEvent) {
            JMenu.this.setSelected(false);
        }
    }

    protected class AccessibleJMenu
    extends JMenuItem.AccessibleJMenuItem
    implements AccessibleSelection {
        public int getAccessibleChildrenCount() {
            Component[] componentArray = JMenu.this.getMenuComponents();
            int n = 0;
            int n2 = 0;
            while (n2 < componentArray.length) {
                if (componentArray[n2] instanceof Accessible) {
                    ++n;
                }
                ++n2;
            }
            return n;
        }

        public Accessible getAccessibleChild(int n) {
            Component[] componentArray = JMenu.this.getMenuComponents();
            int n2 = 0;
            int n3 = 0;
            while (n3 < componentArray.length) {
                if (componentArray[n3] instanceof Accessible) {
                    if (n2 == n) {
                        if (componentArray[n3] instanceof JComponent) {
                            AccessibleContext accessibleContext = ((Accessible)((Object)componentArray[n3])).getAccessibleContext();
                            accessibleContext.setAccessibleParent(JMenu.this);
                        }
                        return (Accessible)((Object)componentArray[n3]);
                    }
                    ++n2;
                }
                ++n3;
            }
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public int getAccessibleSelectionCount() {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray != null) {
                int n = 0;
                while (n < menuElementArray.length) {
                    if (menuElementArray[n] == JMenu.this && n + 1 < menuElementArray.length) {
                        return 1;
                    }
                    ++n;
                }
            }
            return 0;
        }

        public Accessible getAccessibleSelection(int n) {
            if (n < 0 || n >= JMenu.this.getItemCount()) {
                return null;
            }
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray != null) {
                int n2 = 0;
                while (n2 < menuElementArray.length) {
                    if (menuElementArray[n2] == JMenu.this) {
                        while (++n2 < menuElementArray.length) {
                            if (!(menuElementArray[n2] instanceof JMenuItem)) continue;
                            return (Accessible)((Object)menuElementArray[n2]);
                        }
                    }
                    ++n2;
                }
            }
            return null;
        }

        public boolean isAccessibleChildSelected(int n) {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray != null) {
                JMenuItem jMenuItem = JMenu.this.getItem(n);
                int n2 = 0;
                while (n2 <= menuElementArray.length) {
                    if (menuElementArray[n2] == jMenuItem) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }

        private MenuElement[] buildMenuElementArray(JMenu jMenu) {
            Vector<JComponent> vector = new Vector<JComponent>();
            Component component = jMenu.getPopupMenu();
            while (true) {
                if (component instanceof JPopupMenu) {
                    JPopupMenu jPopupMenu = component;
                    vector.insertElementAt(jPopupMenu, 0);
                    component = jPopupMenu.getInvoker();
                    continue;
                }
                if (component instanceof JMenu) {
                    JMenu jMenu2 = (JMenu)component;
                    vector.insertElementAt(jMenu2, 0);
                    component = jMenu2.getParent();
                    continue;
                }
                if (component instanceof JMenuBar) break;
            }
            JMenuBar jMenuBar = (JMenuBar)component;
            vector.insertElementAt(jMenuBar, 0);
            Object[] objectArray = new MenuElement[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }

        public void addAccessibleSelection(int n) {
            if (n < 0 || n >= JMenu.this.getItemCount()) {
                return;
            }
            JMenuItem jMenuItem = JMenu.this.getItem(n);
            if (jMenuItem != null) {
                if (jMenuItem instanceof JMenu) {
                    MenuElement[] menuElementArray = this.buildMenuElementArray((JMenu)jMenuItem);
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
                    return;
                }
                jMenuItem.doClick();
                MenuSelectionManager.defaultManager().setSelectedPath(null);
            }
        }

        public void removeAccessibleSelection(int n) {
            if (n < 0 || n >= JMenu.this.getItemCount()) {
                return;
            }
            JMenuItem jMenuItem = JMenu.this.getItem(n);
            if (jMenuItem != null && jMenuItem instanceof JMenu && ((JMenu)jMenuItem).isSelected()) {
                MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 1];
                int n2 = 0;
                while (n2 < menuElementArray.length - 1) {
                    menuElementArray2[n2] = menuElementArray[n2];
                    ++n2;
                }
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
            }
        }

        public void clearAccessibleSelection() {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray != null) {
                int n = 0;
                while (n < menuElementArray.length) {
                    if (menuElementArray[n] == JMenu.this) {
                        MenuElement[] menuElementArray2 = new MenuElement[n + 1];
                        System.arraycopy(menuElementArray, 0, menuElementArray2, 0, n);
                        menuElementArray2[n] = JMenu.this.getPopupMenu();
                        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
                    }
                    ++n;
                }
            }
        }

        public void selectAllAccessibleSelection() {
        }

        AccessibleJMenu() {
            super(JMenu.this);
            JMenu.this = JMenu.this;
        }
    }
}

