/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.event.TreeModelEvent;
import com.sun.java.swing.event.TreeModelListener;
import com.sun.java.swing.event.TreeSelectionEvent;
import com.sun.java.swing.event.TreeSelectionListener;
import com.sun.java.swing.plaf.TreeUI;
import com.sun.java.swing.plaf.basic.AbstractTreePath;
import com.sun.java.swing.plaf.basic.LargeTreeModelNode;
import com.sun.java.swing.plaf.basic.VisibleTreeNode;
import com.sun.java.swing.tree.DefaultMutableTreeNode;
import com.sun.java.swing.tree.RowMapper;
import com.sun.java.swing.tree.TreeModel;
import com.sun.java.swing.tree.TreeNode;
import com.sun.java.swing.tree.TreePath;
import com.sun.java.swing.tree.TreeSelectionModel;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public abstract class AbstractTreeUI
extends TreeUI
implements Serializable,
TreeModelListener,
RowMapper,
TreeSelectionListener {
    protected transient TreeModel treeModel;
    protected boolean rootVisible;
    protected VisibleTreeNode treeCacheRoot;
    protected Vector visibleNodes = new Vector();
    protected boolean updateNodeSizes;
    protected int rowHeight = 16;
    protected boolean showsRootHandles;
    protected TreeSelectionModel treeSelectionModel;
    protected LargeTreeModelNode largeRoot;
    protected boolean largeModel;
    protected int largeRowCount;

    public void setModel(TreeModel treeModel) {
        TreeModel treeModel2 = this.treeModel;
        if (treeModel != treeModel2) {
            if (treeModel2 != null) {
                treeModel2.removeTreeModelListener(this);
            }
            this.treeModel = treeModel;
            if (this.treeModel != null) {
                this.treeModel.addTreeModelListener(this);
            }
            this.rebuild();
        }
    }

    public TreeModel getModel() {
        return this.treeModel;
    }

    public void setLargeModel(boolean bl) {
        if (this.largeModel != bl) {
            this.largeModel = bl;
            if (bl && this.rowHeight <= 0) {
                this.rowHeight = 16;
            }
            this.rebuild();
        }
    }

    public boolean isLargeModel() {
        return this.largeModel;
    }

    public void setRootVisible(boolean bl) {
        if (bl != this.rootVisible) {
            this.rootVisible = bl;
            if (this.treeModel != null) {
                if (!this.largeModel) {
                    if (this.rootVisible) {
                        this.treeCacheRoot.updatePreferredSize(0);
                        this.visibleNodes.insertElementAt(this.treeCacheRoot, 0);
                    } else if (this.visibleNodes.size() > 0) {
                        this.visibleNodes.removeElementAt(0);
                        if (this.treeSelectionModel != null) {
                            this.treeSelectionModel.removeSelectionPath(this.treeCacheRoot.getTreePath());
                        }
                    }
                    if (this.treeSelectionModel != null) {
                        this.treeSelectionModel.resetRowSelection();
                    }
                    if (this.getRowCount() > 0) {
                        this.getNode(0).setYOrigin(0);
                    }
                    this.updateYLocationsFrom(0);
                    this.visibleNodesChanged();
                    return;
                }
                this.largeRowCount = this.rootVisible ? ++this.largeRowCount : --this.largeRowCount;
                if (this.treeSelectionModel != null) {
                    this.treeSelectionModel.clearSelection();
                }
                this.visibleNodesChanged();
            }
        }
    }

    public boolean isRootVisible() {
        return this.rootVisible;
    }

    public void setShowsRootHandles(boolean bl) {
        if (this.showsRootHandles != bl) {
            this.showsRootHandles = bl;
            this.visibleNodesChanged();
        }
    }

    public boolean getShowsRootHandles() {
        return this.showsRootHandles;
    }

    public void setRowHeight(int n) {
        if (n != this.rowHeight) {
            if (!this.largeModel) {
                this.rowHeight = n;
                if (!this.isFixedRowHeight() && this.visibleNodes.size() > 0) {
                    this.updateNodeSizes(true);
                } else if (this.isFixedRowHeight()) {
                    int n2 = this.getRowCount() - 1;
                    while (n2 >= 0) {
                        this.getNode((int)n2).getPreferredSize().height = n;
                        --n2;
                    }
                }
                this.visibleNodesChanged();
                return;
            }
            if (n <= 0) {
                throw new IllegalArgumentException("AbstractTreeUI.setRowHeight() row height must be > 0 for large models");
            }
            this.rowHeight = n;
            this.visibleNodesChanged();
        }
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public boolean isFixedRowHeight() {
        return this.rowHeight > 0;
    }

    public abstract int getXOriginOfNode(VisibleTreeNode var1);

    public abstract Dimension getSizeOfNode(VisibleTreeNode var1, int var2);

    protected abstract Rectangle getLargeBoundsOf(LargeTreeModelNode var1, int var2, Object var3);

    public abstract void visibleNodesChanged();

    protected abstract void pathWasExpanded(TreePath var1);

    protected abstract void pathWasCollapsed(TreePath var1);

    protected boolean isAbstractTreePath(TreePath treePath, boolean bl, boolean bl2) {
        if (treePath != null && treePath instanceof AbstractTreePath) {
            AbstractTreePath abstractTreePath = (AbstractTreePath)treePath;
            if (abstractTreePath.node == null || abstractTreePath.getUI() == this) {
                if (abstractTreePath.node == null || !abstractTreePath.node.isValid) {
                    abstractTreePath.node = this.getNodeForPath(treePath.getPath(), false, bl2);
                    if (abstractTreePath.node == null) {
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    protected VisibleTreeNode getNodeForTreePath(TreePath treePath, boolean bl, boolean bl2) {
        if (this.isAbstractTreePath(treePath, bl, bl2)) {
            VisibleTreeNode visibleTreeNode = ((AbstractTreePath)treePath).node;
            if (visibleTreeNode == null) {
                return null;
            }
            if (bl && !visibleTreeNode.isVisible()) {
                return null;
            }
            return visibleTreeNode;
        }
        if (treePath != null) {
            return this.getNodeForPath(treePath.getPath(), bl, bl2);
        }
        return null;
    }

    protected VisibleTreeNode[] getNodesForTreePath(TreePath treePath, boolean bl, boolean bl2) {
        if (this.isAbstractTreePath(treePath, bl, bl2)) {
            VisibleTreeNode visibleTreeNode = ((AbstractTreePath)treePath).node;
            if (visibleTreeNode == null) {
                return null;
            }
            if (bl && !visibleTreeNode.isVisible()) {
                return null;
            }
            TreeNode[] treeNodeArray = visibleTreeNode.getPath();
            VisibleTreeNode[] visibleTreeNodeArray = new VisibleTreeNode[treeNodeArray.length];
            System.arraycopy(treeNodeArray, 0, visibleTreeNodeArray, 0, treeNodeArray.length);
            return visibleTreeNodeArray;
        }
        if (treePath != null) {
            return this.getNodesForPath(treePath.getPath(), bl, bl2);
        }
        return null;
    }

    protected TreePath ensurePathIsAbstract(TreePath treePath, VisibleTreeNode visibleTreeNode) {
        if (treePath != null && !(treePath instanceof AbstractTreePath)) {
            return new AbstractTreePath(treePath.getPath(), visibleTreeNode);
        }
        return treePath;
    }

    public VisibleTreeNode getNodeForPath(Object[] objectArray, boolean bl, boolean bl2) {
        VisibleTreeNode[] visibleTreeNodeArray = this.getNodesForPath(objectArray, bl, bl2);
        if (visibleTreeNodeArray != null && visibleTreeNodeArray.length > 0) {
            return visibleTreeNodeArray[visibleTreeNodeArray.length - 1];
        }
        return null;
    }

    public VisibleTreeNode[] getNodesForPath(Object[] objectArray, boolean bl, boolean bl2) {
        if (objectArray != null && objectArray.length > 0 && this.treeModel != null) {
            if (!this.treeCacheRoot.getValue().equals(objectArray[0])) {
                return null;
            }
            VisibleTreeNode visibleTreeNode = this.treeCacheRoot;
            int n = 1;
            if (bl && objectArray.length > 1 && !visibleTreeNode.isExpanded()) {
                return null;
            }
            VisibleTreeNode[] visibleTreeNodeArray = new VisibleTreeNode[objectArray.length];
            visibleTreeNodeArray[0] = visibleTreeNode;
            while (visibleTreeNode != null && n < objectArray.length) {
                VisibleTreeNode visibleTreeNode2 = null;
                Enumeration enumeration = visibleTreeNode.getLoadedChildren(bl2);
                while (enumeration.hasMoreElements() && visibleTreeNode2 == null) {
                    visibleTreeNode2 = (VisibleTreeNode)enumeration.nextElement();
                    if (visibleTreeNode2.getValue().equals(objectArray[n])) continue;
                    visibleTreeNode2 = null;
                }
                visibleTreeNodeArray[n] = visibleTreeNode = visibleTreeNode2;
                if (visibleTreeNode == null || !bl || ++n >= objectArray.length || visibleTreeNode.isExpanded()) continue;
                visibleTreeNode = null;
            }
            if (visibleTreeNode != null) {
                return visibleTreeNodeArray;
            }
            return null;
        }
        return null;
    }

    protected void updateYLocationsFrom(int n) {
        if (n >= 0 && n < this.getRowCount()) {
            VisibleTreeNode visibleTreeNode = this.getNode(n);
            int n2 = visibleTreeNode.getYOrigin() + visibleTreeNode.getPreferredSize().height;
            int n3 = n + 1;
            int n4 = this.visibleNodes.size();
            while (n3 < n4) {
                visibleTreeNode = (VisibleTreeNode)this.visibleNodes.elementAt(n3);
                visibleTreeNode.setYOrigin(n2);
                n2 += visibleTreeNode.getPreferredSize().height;
                ++n3;
            }
        }
    }

    public synchronized void treeNodesChanged(TreeModelEvent treeModelEvent) {
        if (treeModelEvent != null) {
            if (this.largeModel) {
                this.visibleNodesChanged();
                return;
            }
            int[] nArray = treeModelEvent.getChildIndices();
            VisibleTreeNode visibleTreeNode = this.getNodeForPath(treeModelEvent.getPath(), false, false);
            if (visibleTreeNode != null) {
                int n;
                Object object = visibleTreeNode.getValue();
                visibleTreeNode.updatePreferredSize();
                if (nArray != null) {
                    n = 0;
                    while (n < nArray.length) {
                        try {
                            VisibleTreeNode visibleTreeNode2 = (VisibleTreeNode)visibleTreeNode.getChildAt(nArray[n]);
                            visibleTreeNode2.setUserObject(this.treeModel.getChild(object, nArray[n]));
                            visibleTreeNode2.updatePreferredSize();
                        }
                        catch (Exception exception) {}
                        ++n;
                    }
                }
                if (!this.isFixedRowHeight() && (n = visibleTreeNode.getRow()) != -1) {
                    this.updateYLocationsFrom(n);
                }
                this.visibleNodesChanged();
            }
        }
    }

    protected VisibleTreeNode createNodeAt(VisibleTreeNode visibleTreeNode, int n) {
        boolean bl;
        VisibleTreeNode visibleTreeNode2;
        try {
            Object object = this.treeModel.getChild(visibleTreeNode.getValue(), n);
            visibleTreeNode2 = this.createNodeForValue(object, -1);
            visibleTreeNode.insert(visibleTreeNode2, n);
        }
        catch (Exception exception) {
            visibleTreeNode2 = null;
        }
        boolean bl2 = bl = visibleTreeNode == this.treeCacheRoot;
        if (visibleTreeNode2 != null && visibleTreeNode.isExpanded() && (visibleTreeNode.getRow() != -1 || bl)) {
            int n2;
            if (n == 0) {
                n2 = bl && !this.isRootVisible() ? 0 : visibleTreeNode.getRow() + 1;
            } else if (n == visibleTreeNode.getChildCount()) {
                n2 = visibleTreeNode.getLastVisibleNode().getRow() + 1;
            } else {
                VisibleTreeNode visibleTreeNode3 = (VisibleTreeNode)visibleTreeNode.getChildAt(n - 1);
                n2 = visibleTreeNode3.getLastVisibleNode().getRow() + 1;
            }
            this.visibleNodes.insertElementAt(visibleTreeNode2, n2);
        }
        return visibleTreeNode2;
    }

    public synchronized void treeNodesInserted(TreeModelEvent treeModelEvent) {
        if (treeModelEvent != null && !this.largeModel) {
            int[] nArray = treeModelEvent.getChildIndices();
            VisibleTreeNode visibleTreeNode = this.getNodeForPath(treeModelEvent.getPath(), false, false);
            if (visibleTreeNode != null && nArray != null && nArray.length > 0) {
                if (visibleTreeNode.hasBeenExpanded()) {
                    Object object = visibleTreeNode.getValue();
                    boolean bl = visibleTreeNode == this.treeCacheRoot && !this.rootVisible || visibleTreeNode.getRow() != -1 && visibleTreeNode.isExpanded();
                    int n = 0;
                    while (n < nArray.length) {
                        VisibleTreeNode visibleTreeNode2 = this.createNodeAt(visibleTreeNode, nArray[n]);
                        ++n;
                    }
                    if (this.treeSelectionModel != null) {
                        this.treeSelectionModel.resetRowSelection();
                    }
                    if (!this.isFixedRowHeight() && bl) {
                        if (visibleTreeNode == this.treeCacheRoot) {
                            this.updateYLocationsFrom(0);
                        } else {
                            this.updateYLocationsFrom(visibleTreeNode.getRow());
                        }
                        this.visibleNodesChanged();
                        return;
                    }
                    if (bl) {
                        this.visibleNodesChanged();
                        return;
                    }
                } else {
                    visibleTreeNode.modelChildCountChanged();
                }
                return;
            }
        } else if (treeModelEvent != null) {
            int n;
            LargeTreeModelNode largeTreeModelNode = this.getLargeTreeModelNodeForPath(treeModelEvent.getPath(), false, false);
            int[] nArray = treeModelEvent.getChildIndices();
            if (largeTreeModelNode != null && nArray != null && (n = nArray.length) > 0) {
                boolean bl = largeTreeModelNode.isVisible() && largeTreeModelNode.isExpanded();
                int n2 = 0;
                while (n2 < n) {
                    largeTreeModelNode.childInsertedAtModelIndex(nArray[n2]);
                    if (bl) {
                        ++this.largeRowCount;
                    }
                    ++n2;
                }
                if (bl && this.treeSelectionModel != null) {
                    this.treeSelectionModel.resetRowSelection();
                }
                if (bl) {
                    this.visibleNodesChanged();
                    return;
                }
                largeTreeModelNode.modelChildCountChanged();
            }
        }
    }

    public synchronized void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        if (treeModelEvent != null && !this.largeModel) {
            int[] nArray = treeModelEvent.getChildIndices();
            VisibleTreeNode visibleTreeNode = this.getNodeForPath(treeModelEvent.getPath(), false, false);
            if (visibleTreeNode != null && nArray != null && nArray.length > 0) {
                if (visibleTreeNode.hasBeenExpanded()) {
                    boolean bl = visibleTreeNode == this.treeCacheRoot && !this.rootVisible || visibleTreeNode.getRow() != -1 && visibleTreeNode.isExpanded();
                    int n = nArray.length - 1;
                    while (n >= 0) {
                        try {
                            int n2;
                            VisibleTreeNode visibleTreeNode2 = (VisibleTreeNode)visibleTreeNode.getChildAt(nArray[n]);
                            if (visibleTreeNode2.isExpanded()) {
                                visibleTreeNode2.collapse(false);
                            }
                            if (bl && (n2 = visibleTreeNode2.getRow()) != -1) {
                                this.visibleNodes.removeElementAt(n2);
                                if (this.treeSelectionModel != null) {
                                    TreePath treePath = visibleTreeNode2.getTreePath();
                                    this.treeSelectionModel.removeSelectionPath(treePath);
                                }
                            }
                            visibleTreeNode.remove(visibleTreeNode2);
                        }
                        catch (Exception exception) {
                            System.out.println("Exception removing node" + exception);
                        }
                        --n;
                    }
                    if (this.treeSelectionModel != null) {
                        this.treeSelectionModel.resetRowSelection();
                    }
                    if (!this.isFixedRowHeight() && bl) {
                        if (visibleTreeNode == this.treeCacheRoot) {
                            if (this.getRowCount() > 0) {
                                this.getNode(0).setYOrigin(0);
                            }
                            this.updateYLocationsFrom(0);
                        } else {
                            this.updateYLocationsFrom(visibleTreeNode.getRow());
                        }
                        this.visibleNodesChanged();
                        return;
                    }
                    if (bl) {
                        this.visibleNodesChanged();
                        return;
                    }
                } else {
                    visibleTreeNode.modelChildCountChanged();
                }
                return;
            }
        } else if (treeModelEvent != null) {
            int n;
            Object[] objectArray = treeModelEvent.getPath();
            LargeTreeModelNode largeTreeModelNode = this.getLargeTreeModelNodeForPath(objectArray, false, false);
            int[] nArray = treeModelEvent.getChildIndices();
            if (largeTreeModelNode != null && nArray != null && (n = nArray.length) > 0) {
                Object[] objectArray2 = treeModelEvent.getChildren();
                int n3 = objectArray.length;
                boolean bl = largeTreeModelNode.isVisible() && largeTreeModelNode.isExpanded();
                int n4 = 0;
                while (n4 < n) {
                    LargeTreeModelNode largeTreeModelNode2 = largeTreeModelNode.childAtModelIndex(nArray[n4]);
                    if (largeTreeModelNode2 != null) {
                        largeTreeModelNode2.collapse(false);
                        largeTreeModelNode.remove(largeTreeModelNode2);
                    }
                    if (bl) {
                        --this.largeRowCount;
                    }
                    largeTreeModelNode.childRemovedAtModelIndex(nArray[n4]);
                    if (this.treeSelectionModel != null && objectArray2 != null && objectArray2[n4] != null) {
                        Object[] objectArray3 = new Object[n3 + 1];
                        System.arraycopy(objectArray, 0, objectArray3, 0, n3);
                        objectArray3[n3] = objectArray2[n4];
                        this.treeSelectionModel.removeSelectionPath(new TreePath(objectArray3));
                    }
                    ++n4;
                }
                if (bl) {
                    if (this.treeSelectionModel != null) {
                        this.treeSelectionModel.resetRowSelection();
                    }
                    this.visibleNodesChanged();
                    return;
                }
                largeTreeModelNode.modelChildCountChanged();
            }
        }
    }

    public synchronized void treeStructureChanged(TreeModelEvent treeModelEvent) {
        Object[] objectArray;
        if (treeModelEvent != null && !this.largeModel) {
            Object[] objectArray2 = treeModelEvent.getPath();
            VisibleTreeNode visibleTreeNode = this.getNodeForPath(objectArray2, false, false);
            if (visibleTreeNode == null && objectArray2 != null && objectArray2.length == 1) {
                visibleTreeNode = this.treeCacheRoot;
            }
            if (visibleTreeNode != null) {
                boolean bl;
                boolean bl2 = visibleTreeNode.isExpanded();
                boolean bl3 = bl = visibleTreeNode.getRow() != -1;
                if (visibleTreeNode == this.treeCacheRoot) {
                    this.rebuild();
                    return;
                }
                VisibleTreeNode visibleTreeNode2 = (VisibleTreeNode)visibleTreeNode.getParent();
                int n = visibleTreeNode2.getIndex(visibleTreeNode);
                if (bl && bl2) {
                    visibleTreeNode.collapse(false);
                }
                if (bl) {
                    this.visibleNodes.removeElement(visibleTreeNode);
                }
                visibleTreeNode.removeFromParent();
                this.createNodeAt(visibleTreeNode2, n);
                VisibleTreeNode visibleTreeNode3 = (VisibleTreeNode)visibleTreeNode2.getChildAt(n);
                if (bl && bl2) {
                    visibleTreeNode3.expand(false);
                }
                int n2 = visibleTreeNode3.getRow();
                if (!this.isFixedRowHeight() && bl) {
                    if (n2 == 0) {
                        this.updateYLocationsFrom(n2);
                    } else {
                        this.updateYLocationsFrom(n2 - 1);
                    }
                    this.visibleNodesChanged();
                    return;
                }
                if (bl) {
                    this.visibleNodesChanged();
                    return;
                }
            }
        } else if (treeModelEvent != null && (objectArray = treeModelEvent.getPath()) != null && objectArray.length > 0) {
            if (objectArray.length == 1) {
                this.rebuild();
                return;
            }
            LargeTreeModelNode largeTreeModelNode = this.getLargeTreeModelNodeForPath(objectArray, false, false);
            if (largeTreeModelNode != null) {
                LargeTreeModelNode largeTreeModelNode2 = (LargeTreeModelNode)largeTreeModelNode.getParent();
                boolean bl = largeTreeModelNode.isExpanded();
                boolean bl4 = largeTreeModelNode.isVisible();
                if (bl4 && bl) {
                    largeTreeModelNode.collapse(false);
                    largeTreeModelNode.removeFromParent();
                    largeTreeModelNode = this.getLargeTreeModelNodeForPath(objectArray, false, true);
                    largeTreeModelNode.expand(false);
                } else {
                    largeTreeModelNode.removeFromParent();
                }
                if (this.treeSelectionModel != null && bl4 && bl) {
                    this.treeSelectionModel.resetRowSelection();
                }
                if (bl4) {
                    this.visibleNodesChanged();
                    return;
                }
                largeTreeModelNode2.modelChildCountChanged();
            }
        }
    }

    public void rebuild() {
        if (!this.largeModel && this.treeCacheRoot != null) {
            this.treeCacheRoot.markInvalid();
        }
        if (this.treeModel != null) {
            if (!this.largeModel) {
                this.largeRoot = null;
                this.treeCacheRoot = this.createNodeForValue(this.treeModel.getRoot(), 0);
                this.visibleNodes.removeAllElements();
                if (this.isRootVisible()) {
                    this.visibleNodes.addElement(this.treeCacheRoot);
                }
                if (!this.treeCacheRoot.isExpanded()) {
                    this.treeCacheRoot.expand();
                } else {
                    Enumeration enumeration = this.treeCacheRoot.children();
                    while (enumeration.hasMoreElements()) {
                        this.visibleNodes.addElement(enumeration.nextElement());
                    }
                    if (!this.isFixedRowHeight()) {
                        this.updateYLocationsFrom(0);
                    }
                }
            } else {
                this.treeCacheRoot = null;
                this.visibleNodes.removeAllElements();
                this.largeRoot = this.createLargeTreeModelNodeForValue(this.treeModel.getRoot(), 0);
                this.largeRowCount = this.isRootVisible() ? 1 : 0;
                this.largeRoot.expand(true);
            }
        } else {
            this.visibleNodes.removeAllElements();
            this.treeCacheRoot = null;
            this.largeRoot = null;
            this.largeRowCount = 0;
        }
        if (this.treeSelectionModel != null) {
            this.treeSelectionModel.clearSelection();
        }
        this.visibleNodesChanged();
    }

    public void updateNodeSizes(boolean bl) {
        this.updateNodeSizes = false;
        int n = 0;
        int n2 = 0;
        int n3 = this.visibleNodes.size();
        while (n < n3) {
            VisibleTreeNode visibleTreeNode = (VisibleTreeNode)this.visibleNodes.elementAt(n);
            visibleTreeNode.setYOrigin(n2);
            if (bl || !visibleTreeNode.hasValidSize()) {
                visibleTreeNode.updatePreferredSize(n);
            }
            n2 += visibleTreeNode.getPreferredSize().height;
            ++n;
        }
    }

    public int getYOriginOfRow(int n) {
        if (n < 0) {
            return -1;
        }
        if (n >= this.getRowCount()) {
            return -1;
        }
        if (this.isFixedRowHeight()) {
            return n * this.getRowHeight();
        }
        return this.getNode(n).getYOrigin();
    }

    public int getRowContainingYLocation(int n) {
        if (this.isFixedRowHeight()) {
            if (this.getRowCount() == 0) {
                return -1;
            }
            return Math.max(0, Math.min(this.getRowCount() - 1, n / this.getRowHeight()));
        }
        int n2 = this.getRowCount();
        if (n2 <= 0) {
            return -1;
        }
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            n4 = (n2 - n3) / 2 + n3;
            VisibleTreeNode visibleTreeNode = (VisibleTreeNode)this.visibleNodes.elementAt(n4);
            int n5 = visibleTreeNode.getYOrigin();
            int n6 = n5 + visibleTreeNode.getPreferredSize().height;
            if (n < n5) {
                n2 = n4 - 1;
                continue;
            }
            if (n < n6) break;
            n3 = n4 + 1;
        }
        if (n3 == n2 && (n4 = n3) >= this.getRowCount()) {
            n4 = this.getRowCount() - 1;
        }
        return n4;
    }

    protected boolean ensureLargePathIsExpanded(TreePath treePath, boolean bl) {
        Object object = treePath.getPath();
        if (object != null) {
            Object object2;
            int n = ((Object[])object).length;
            if (this.treeModel.isLeaf(object[n - 1])) {
                if (n == 1) {
                    object = null;
                } else {
                    object2 = new Object[n - 1];
                    System.arraycopy(object, 0, object2, 0, n - 1);
                    object = object2;
                    bl = true;
                }
            }
            if (object != null && (object2 = this.getLargeTreeModelNodeForPath((Object[])object, false, true)) != null) {
                TreeNode[] treeNodeArray = ((DefaultMutableTreeNode)object2).getPath();
                int n2 = treeNodeArray.length - 1;
                int n3 = 0;
                while (n3 < n2) {
                    ((LargeTreeModelNode)treeNodeArray[n3]).expand(true);
                    ++n3;
                }
                if (bl) {
                    ((LargeTreeModelNode)treeNodeArray[n2]).expand(true);
                }
                return true;
            }
        }
        return false;
    }

    protected VisibleTreeNode[] ensurePathIsExpanded(TreePath treePath, boolean bl) {
        VisibleTreeNode[] visibleTreeNodeArray = this.getNodesForTreePath(treePath, false, true);
        if (visibleTreeNodeArray != null) {
            int n = 0;
            int n2 = bl ? visibleTreeNodeArray.length : visibleTreeNodeArray.length - 1;
            while (n < n2) {
                if (!visibleTreeNodeArray[n].isExpanded()) {
                    visibleTreeNodeArray[n].expand();
                }
                ++n;
            }
        }
        return visibleTreeNodeArray;
    }

    public TreePath getSelectionPath() {
        if (this.treeSelectionModel != null) {
            return this.treeSelectionModel.getSelectionPath();
        }
        return null;
    }

    public TreePath[] getSelectionPaths() {
        if (this.treeSelectionModel != null) {
            return this.treeSelectionModel.getSelectionPaths();
        }
        return null;
    }

    public int[] getSelectionRows() {
        if (this.treeSelectionModel != null) {
            return this.treeSelectionModel.getSelectionRows();
        }
        return null;
    }

    public int getMinSelectionRow() {
        if (this.treeSelectionModel != null) {
            return this.treeSelectionModel.getMinSelectionRow();
        }
        return -1;
    }

    public int getMaxSelectionRow() {
        if (this.treeSelectionModel != null) {
            return this.treeSelectionModel.getMaxSelectionRow();
        }
        return -1;
    }

    public boolean isPathSelected(TreePath treePath) {
        if (this.treeSelectionModel != null) {
            return this.treeSelectionModel.isPathSelected(treePath);
        }
        return false;
    }

    public boolean isRowSelected(int n) {
        if (this.treeSelectionModel != null) {
            return this.treeSelectionModel.isRowSelected(n);
        }
        return false;
    }

    public boolean isExpanded(TreePath treePath) {
        if (!this.largeModel) {
            VisibleTreeNode visibleTreeNode = this.getNodeForTreePath(treePath, true, false);
            if (visibleTreeNode != null) {
                return visibleTreeNode.isExpanded();
            }
        } else if (treePath != null) {
            LargeTreeModelNode largeTreeModelNode = this.getLargeTreeModelNodeForPath(treePath.getPath(), true, false);
            return largeTreeModelNode != null && largeTreeModelNode.isExpanded();
        }
        return false;
    }

    public boolean isExpanded(int n) {
        if (!this.largeModel) {
            return this.getNode(n).isExpanded();
        }
        LargeTreeModelNode largeTreeModelNode = this.getLargeTreeModelNodeForRow(n, false);
        if (largeTreeModelNode != null) {
            return largeTreeModelNode.isExpanded();
        }
        return false;
    }

    public boolean isCollapsed(TreePath treePath) {
        return !this.isExpanded(treePath);
    }

    public boolean isCollapsed(int n) {
        return !this.isExpanded(n);
    }

    public boolean isLeaf(int n) {
        if (!this.largeModel) {
            VisibleTreeNode visibleTreeNode = this.getNode(n);
            if (visibleTreeNode != null) {
                return visibleTreeNode.isLeaf();
            }
        } else {
            if (n == 0 && this.isRootVisible()) {
                return this.treeModel.isLeaf(this.treeModel.getRoot());
            }
            int[] nArray = new int[1];
            LargeTreeModelNode largeTreeModelNode = this.getLargeParentAndChildIndexOfRow(n, nArray);
            if (largeTreeModelNode != null) {
                return this.treeModel.isLeaf(this.treeModel.getChild(largeTreeModelNode.getUserObject(), nArray[0]));
            }
        }
        return true;
    }

    public void makeVisible(TreePath treePath) {
        if (!this.largeModel) {
            this.ensurePathIsExpanded(treePath, false);
            return;
        }
        this.ensureLargePathIsExpanded(treePath, false);
    }

    public boolean isVisible(TreePath treePath) {
        int n;
        Object[] objectArray;
        if (!this.largeModel) {
            VisibleTreeNode visibleTreeNode = this.getNodeForTreePath(treePath, true, false);
            if (visibleTreeNode != null) {
                return true;
            }
        } else if (treePath != null && (objectArray = treePath.getPath()) != null && (n = objectArray.length) > 0) {
            if (this.treeModel.isLeaf(objectArray[n - 1]) && n > 1) {
                Object[] objectArray2 = new Object[n - 1];
                System.arraycopy(objectArray, 0, objectArray2, 0, n - 1);
                LargeTreeModelNode largeTreeModelNode = this.getLargeTreeModelNodeForPath(objectArray2, true, false);
                return largeTreeModelNode != null && largeTreeModelNode.isVisible() && largeTreeModelNode.isExpanded();
            }
            LargeTreeModelNode largeTreeModelNode = this.getLargeTreeModelNodeForPath(objectArray, true, false);
            return largeTreeModelNode.isVisible();
        }
        return false;
    }

    public int getRowCount() {
        if (!this.largeModel) {
            return this.visibleNodes.size();
        }
        return this.largeRowCount;
    }

    public Rectangle getPathBounds(TreePath treePath) {
        if (!this.largeModel) {
            VisibleTreeNode visibleTreeNode = this.getNodeForTreePath(treePath, true, false);
            if (visibleTreeNode != null) {
                return visibleTreeNode.getNodeBounds();
            }
        } else if (treePath != null) {
            return this.getRowBounds(this.getRowForPath(treePath));
        }
        return null;
    }

    public Rectangle getRowBounds(int n) {
        if (n >= 0 && n < this.getRowCount()) {
            if (!this.largeModel) {
                return this.getNode(n).getNodeBounds();
            }
            if (n == 0 && this.isRootVisible()) {
                return this.getLargeBoundsOf(null, 0, this.largeRoot.getUserObject());
            }
            int[] nArray = new int[1];
            LargeTreeModelNode largeTreeModelNode = this.getLargeParentAndChildIndexOfRow(n, nArray);
            if (largeTreeModelNode != null) {
                return this.getLargeBoundsOf(largeTreeModelNode, n, this.treeModel.getChild(largeTreeModelNode.getUserObject(), nArray[0]));
            }
        }
        return null;
    }

    public TreePath getPathForRow(int n) {
        if (n >= 0 && n < this.getRowCount()) {
            if (!this.largeModel) {
                return this.getNode(n).getTreePath();
            }
            return this.getLargePathForRow(n);
        }
        return null;
    }

    public int getRowForPath(TreePath treePath) {
        if (treePath == null) {
            return -1;
        }
        if (!this.largeModel) {
            VisibleTreeNode visibleTreeNode = this.getNodeForTreePath(treePath, true, false);
            if (visibleTreeNode != null) {
                return visibleTreeNode.getRow();
            }
            return -1;
        }
        return this.getLargeRowForPath(treePath.getPath());
    }

    public int[] getRowsForPaths(TreePath[] treePathArray) {
        if (treePathArray == null) {
            return null;
        }
        int n = treePathArray.length;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = this.getRowForPath(treePathArray[n2]);
            ++n2;
        }
        return nArray;
    }

    public TreePath[] getPathsForRows(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int n = nArray.length;
        TreePath[] treePathArray = new TreePath[n];
        int n2 = 0;
        while (n2 < n) {
            treePathArray[n2] = this.getPathForRow(nArray[n2]);
            ++n2;
        }
        return treePathArray;
    }

    public void expandPath(TreePath treePath) {
        if (treePath != null) {
            if (!this.largeModel) {
                this.ensurePathIsExpanded(treePath, true);
                return;
            }
            this.ensureLargePathIsExpanded(treePath, true);
        }
    }

    public void expandRow(int n) {
        if (n >= 0 && n < this.getRowCount()) {
            if (!this.largeModel) {
                this.getNode(n).expand();
                return;
            }
            LargeTreeModelNode largeTreeModelNode = this.getLargeTreeModelNodeForRow(n, true);
            if (largeTreeModelNode != null) {
                largeTreeModelNode.expand(true);
            }
        }
    }

    public void collapsePath(TreePath treePath) {
        LargeTreeModelNode largeTreeModelNode;
        if (!this.largeModel) {
            VisibleTreeNode[] visibleTreeNodeArray = this.getNodesForTreePath(treePath, false, true);
            if (visibleTreeNodeArray != null) {
                int n = 0;
                int n2 = visibleTreeNodeArray.length - 1;
                while (n < n2) {
                    if (!visibleTreeNodeArray[n].isExpanded()) {
                        visibleTreeNodeArray[n].expand();
                    }
                    ++n;
                }
                if (visibleTreeNodeArray.length > 0) {
                    visibleTreeNodeArray[n].collapse();
                    return;
                }
            }
        } else if (treePath != null && (largeTreeModelNode = this.getLargeTreeModelNodeForPath(treePath.getPath(), false, true)) != null) {
            largeTreeModelNode.collapse(true);
        }
    }

    public void collapseRow(int n) {
        if (n >= 0 && n < this.getRowCount()) {
            if (!this.largeModel) {
                this.getNode(n).collapse();
                return;
            }
            LargeTreeModelNode largeTreeModelNode = this.getLargeTreeModelNodeForRow(n, false);
            if (largeTreeModelNode != null) {
                largeTreeModelNode.collapse(true);
            }
        }
    }

    public TreePath getClosestPathForLocation(int n, int n2) {
        if (this.getRowCount() == 0) {
            return null;
        }
        int n3 = this.getRowContainingYLocation(n2);
        if (!this.largeModel) {
            return this.getNode(n3).getTreePath();
        }
        return this.getLargePathForRow(n3);
    }

    public int getClosestRowForLocation(int n, int n2) {
        if (this.getRowCount() == 0) {
            return -1;
        }
        return this.getRowContainingYLocation(n2);
    }

    public Object getValue(int n) {
        if (!this.largeModel) {
            return this.getNode(n).getValue();
        }
        int[] nArray = new int[1];
        LargeTreeModelNode largeTreeModelNode = this.getLargeParentAndChildIndexOfRow(n, nArray);
        if (n == 0 && this.isRootVisible()) {
            return this.treeModel.getRoot();
        }
        if (largeTreeModelNode != null) {
            return this.treeModel.getChild(largeTreeModelNode.getUserObject(), nArray[0]);
        }
        return null;
    }

    public VisibleTreeNode getNode(int n) {
        return (VisibleTreeNode)this.visibleNodes.elementAt(n);
    }

    public Enumeration visibleNodes() {
        return this.visibleNodes.elements();
    }

    public int getMaxNodeWidth() {
        int n = 0;
        if (!this.largeModel) {
            int n2 = this.getRowCount() - 1;
            while (n2 >= 0) {
                VisibleTreeNode visibleTreeNode = this.getNode(n2);
                int n3 = visibleTreeNode.getPreferredSize().width + this.getXOriginOfNode(visibleTreeNode);
                if (n3 > n) {
                    n = n3;
                }
                --n2;
            }
        } else {
            int n4 = this.getRowCount() - 1;
            while (n4 >= 0) {
                Rectangle rectangle = this.getRowBounds(n4);
                n = Math.max(n, rectangle.x + rectangle.width);
                --n4;
            }
        }
        return n;
    }

    public void setSelectionModel(TreeSelectionModel treeSelectionModel) {
        if (this.treeSelectionModel != treeSelectionModel) {
            if (this.treeSelectionModel != null) {
                this.treeSelectionModel.removeTreeSelectionListener(this);
                this.treeSelectionModel.setRowMapper(null);
            }
            this.treeSelectionModel = treeSelectionModel;
            if (this.treeSelectionModel != null) {
                this.treeSelectionModel.addTreeSelectionListener(this);
                this.treeSelectionModel.setRowMapper(this);
                this.treeSelectionModel.resetRowSelection();
            }
        }
    }

    public TreeSelectionModel getSelectionModel() {
        return this.treeSelectionModel;
    }

    public boolean isSelectedIndex(int n) {
        if (this.treeSelectionModel != null) {
            return this.treeSelectionModel.isRowSelected(n);
        }
        return false;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath[] treePathArray;
        if (this.treeSelectionModel != null && (treePathArray = this.treeSelectionModel.getSelectionPaths()) != null) {
            int n = treePathArray.length - 1;
            while (n >= 0) {
                this.makeVisible(treePathArray[n]);
                --n;
            }
        }
    }

    protected VisibleTreeNode createNodeForValue(Object object, int n) {
        return new VisibleTreeNode(this, object, n);
    }

    protected LargeTreeModelNode createLargeTreeModelNodeForValue(Object object, int n) {
        return new LargeTreeModelNode(this, object, n);
    }

    protected LargeTreeModelNode getLargeParentAndChildIndexOfRow(int n, int[] nArray) {
        int[] nArray2 = new int[1];
        LargeTreeModelNode[] largeTreeModelNodeArray = new LargeTreeModelNode[1];
        boolean[] blArray = new boolean[1];
        nArray2[0] = this.isRootVisible() ? 0 : -1;
        if (this.largeRoot.getPathForRow(n, nArray2, null, largeTreeModelNodeArray, blArray, nArray)) {
            if (blArray[0]) {
                return largeTreeModelNodeArray[0];
            }
            nArray[0] = largeTreeModelNodeArray[0].getChildIndex();
            return (LargeTreeModelNode)largeTreeModelNodeArray[0].getParent();
        }
        return null;
    }

    protected LargeTreeModelNode getLargeTreeModelNodeForRow(int n, boolean bl) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        LargeTreeModelNode[] largeTreeModelNodeArray = new LargeTreeModelNode[1];
        boolean[] blArray = new boolean[1];
        nArray[0] = this.isRootVisible() ? 0 : -1;
        if (this.largeRoot.getPathForRow(n, nArray, null, largeTreeModelNodeArray, blArray, nArray2)) {
            if (blArray[0]) {
                if (bl) {
                    Object object = this.treeModel.getChild(largeTreeModelNodeArray[0].getUserObject(), nArray2[0]);
                    if (this.treeModel.isLeaf(object)) {
                        return null;
                    }
                    LargeTreeModelNode largeTreeModelNode = this.createLargeTreeModelNodeForValue(object, nArray2[0]);
                    largeTreeModelNodeArray[0].addLargeTreeModelNode(largeTreeModelNode);
                    return largeTreeModelNode;
                }
                return null;
            }
            return largeTreeModelNodeArray[0];
        }
        return null;
    }

    protected TreePath getLargePathForRow(int n) {
        int[] nArray = new int[1];
        TreePath[] treePathArray = new TreePath[1];
        nArray[0] = this.isRootVisible() ? 0 : -1;
        if (this.largeRoot.getPathForRow(n, nArray, treePathArray, null, null, null)) {
            return treePathArray[0];
        }
        return null;
    }

    protected int getLargeRowForPath(Object[] objectArray) {
        int[] nArray = new int[]{this.isRootVisible() ? 0 : -1};
        if (objectArray != null && this.largeRoot.getRow(objectArray, 0, objectArray.length, true, nArray)) {
            return nArray[0];
        }
        return -1;
    }

    protected LargeTreeModelNode getLargeTreeModelNodeForPath(Object[] objectArray, boolean bl, boolean bl2) {
        int n;
        if (objectArray != null && (n = objectArray.length) > 0) {
            return this.getLargeTreeModelNodeForPath(objectArray, bl, bl2, n);
        }
        return null;
    }

    protected LargeTreeModelNode getLargeTreeModelNodeForPath(Object[] objectArray, boolean bl, boolean bl2, int n) {
        if (objectArray[0].equals(this.largeRoot.getUserObject())) {
            LargeTreeModelNode largeTreeModelNode = this.largeRoot;
            int n2 = 1;
            while (n2 < n) {
                LargeTreeModelNode largeTreeModelNode2;
                if (bl && !largeTreeModelNode.isExpanded) {
                    return null;
                }
                int n3 = this.treeModel.getIndexOfChild(largeTreeModelNode.getUserObject(), objectArray[n2]);
                if (n3 < 0) {
                    throw new RuntimeException("invalid index " + n3 + " for path " + objectArray[n2]);
                }
                int n4 = largeTreeModelNode.getChildCount();
                LargeTreeModelNode largeTreeModelNode3 = largeTreeModelNode;
                int n5 = 0;
                while (n5 < n4) {
                    LargeTreeModelNode largeTreeModelNode4 = (LargeTreeModelNode)largeTreeModelNode.getChildAt(n5);
                    if (largeTreeModelNode4.childIndex == n3) {
                        largeTreeModelNode = largeTreeModelNode4;
                        n5 = n4;
                    } else if (largeTreeModelNode4.childIndex > n3) {
                        if (bl2) {
                            largeTreeModelNode2 = this.createLargeTreeModelNodeForValue(objectArray[n2], n3);
                            largeTreeModelNode.insert(largeTreeModelNode2, n5);
                            largeTreeModelNode = largeTreeModelNode2;
                            n5 = n4;
                        } else {
                            return null;
                        }
                    }
                    ++n5;
                }
                if (largeTreeModelNode3 == largeTreeModelNode) {
                    if (bl2) {
                        largeTreeModelNode2 = this.createLargeTreeModelNodeForValue(objectArray[n2], n3);
                        largeTreeModelNode.add(largeTreeModelNode2);
                        largeTreeModelNode = largeTreeModelNode2;
                    } else {
                        return null;
                    }
                }
                ++n2;
            }
            return largeTreeModelNode;
        }
        return null;
    }

    protected AbstractTreePath createTreePathFor(VisibleTreeNode visibleTreeNode) {
        return new AbstractTreePath(visibleTreeNode.getUserObjectPath(), visibleTreeNode);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Vector<Object> vector = new Vector<Object>();
        objectOutputStream.defaultWriteObject();
        if (this.treeModel != null && this.treeModel instanceof Serializable) {
            vector.addElement("treeModel");
            vector.addElement(this.treeModel);
        }
        if (this.treeSelectionModel != null && this.treeSelectionModel instanceof Serializable) {
            vector.addElement("treeSelectionModel");
            vector.addElement(this.treeSelectionModel);
        }
        objectOutputStream.writeObject(vector);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Vector vector = (Vector)objectInputStream.readObject();
        int n = 0;
        int n2 = vector.size();
        if (n < n2 && vector.elementAt(n).equals("treeModel")) {
            this.treeModel = (TreeModel)vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals("treeSelectionModel")) {
            this.treeSelectionModel = (TreeSelectionModel)vector.elementAt(++n);
            ++n;
        }
    }
}

