/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.plaf.basic.AbstractTreeUI;
import com.sun.java.swing.tree.DefaultMutableTreeNode;
import com.sun.java.swing.tree.MutableTreeNode;
import com.sun.java.swing.tree.TreeModel;
import com.sun.java.swing.tree.TreePath;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

public class VisibleTreeNode
extends DefaultMutableTreeNode {
    protected AbstractTreeUI treeUI;
    protected Dimension preferredSize;
    protected int yOrigin;
    protected boolean expanded;
    protected boolean hasBeenExpanded;
    protected boolean isValid;
    public static final Dimension EMPTY_SIZE = new Dimension(0, 0);

    public VisibleTreeNode(AbstractTreeUI abstractTreeUI, Object object, int n) {
        super(object);
        this.treeUI = abstractTreeUI;
        this.isValid = true;
        this.updatePreferredSize(n);
    }

    public void setParent(MutableTreeNode mutableTreeNode) {
        super.setParent(mutableTreeNode);
        if (mutableTreeNode == null) {
            this.markInvalid();
        }
    }

    void markInvalid() {
        this.isValid = false;
        if (this.children != null) {
            int n = this.children.size() - 1;
            while (n >= 0) {
                ((VisibleTreeNode)this.children.elementAt(n)).markInvalid();
                --n;
            }
        }
    }

    protected void setYOrigin(int n) {
        this.yOrigin = n;
    }

    public int getYOrigin() {
        if (this.treeUI.isFixedRowHeight()) {
            int n = this.getRow();
            if (n == -1) {
                return -1;
            }
            return this.treeUI.getRowHeight() * n;
        }
        return this.yOrigin;
    }

    protected void shiftYOriginBy(int n) {
        this.yOrigin += n;
    }

    public void updatePreferredSize() {
        this.updatePreferredSize(-1);
    }

    protected void updatePreferredSize(int n) {
        this.preferredSize = this.treeUI.getSizeOfNode(this, n);
        if (this.preferredSize == null) {
            this.preferredSize = EMPTY_SIZE;
            this.treeUI.updateNodeSizes = true;
        } else if (this.preferredSize.height == 0) {
            this.treeUI.updateNodeSizes = true;
        }
        int n2 = this.treeUI.getRowHeight();
        if (n2 > 0) {
            this.preferredSize.height = n2;
        }
    }

    public boolean hasValidSize() {
        return this.preferredSize == null || this.preferredSize.height == 0;
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public Rectangle getNodeBounds() {
        Dimension dimension = this.getPreferredSize();
        return new Rectangle(this.treeUI.getXOriginOfNode(this), this.getYOrigin(), dimension.width, dimension.height);
    }

    public int getVisibleLevel() {
        if (this.treeUI.isRootVisible()) {
            return this.getLevel();
        }
        return this.getLevel() - 1;
    }

    public int getRow() {
        return this.treeUI.visibleNodes.indexOf(this);
    }

    public boolean hasBeenExpanded() {
        return this.hasBeenExpanded;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public boolean isSelected() {
        return this.treeUI.isSelectedIndex(this.getRow());
    }

    public boolean isLeaf() {
        return this.treeUI.getModel().isLeaf(this.getValue());
    }

    public VisibleTreeNode getLastVisibleNode() {
        VisibleTreeNode visibleTreeNode = this;
        while (visibleTreeNode.isExpanded() && visibleTreeNode.getChildCount() > 0) {
            visibleTreeNode = (VisibleTreeNode)visibleTreeNode.getLastChild();
        }
        return visibleTreeNode;
    }

    public Enumeration getLoadedChildren(boolean bl) {
        if (!bl || this.hasBeenExpanded) {
            return super.children();
        }
        Object object = this.getValue();
        TreeModel treeModel = this.treeUI.getModel();
        int n = treeModel.getChildCount(object);
        this.hasBeenExpanded = true;
        int n2 = this.getRow();
        if (n2 == -1) {
            int n3 = 0;
            while (n3 < n) {
                VisibleTreeNode visibleTreeNode = this.treeUI.createNodeForValue(treeModel.getChild(object, n3), -1);
                this.add(visibleTreeNode);
                ++n3;
            }
        } else {
            ++n2;
            int n4 = 0;
            while (n4 < n) {
                VisibleTreeNode visibleTreeNode = this.treeUI.createNodeForValue(treeModel.getChild(object, n4), n2++);
                this.add(visibleTreeNode);
                ++n4;
            }
        }
        return super.children();
    }

    public Enumeration children() {
        if (!this.isExpanded()) {
            return DefaultMutableTreeNode.EMPTY_ENUMERATION;
        }
        return super.children();
    }

    public boolean isVisible() {
        return this.treeUI.visibleNodes.contains(this);
    }

    public void modelChildCountChanged() {
    }

    public int getModelChildCount() {
        if (this.hasBeenExpanded) {
            return super.getChildCount();
        }
        return this.treeUI.getModel().getChildCount(this.getValue());
    }

    public int visibleChildCount() {
        int n = -1;
        Enumeration enumeration = this.preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            ++n;
            enumeration.nextElement();
        }
        return n;
    }

    public void toggleExpanded() {
        if (this.isExpanded()) {
            this.collapse();
            return;
        }
        this.expand();
    }

    protected void didAdjustTree() {
    }

    public void expand() {
        this.expand(true);
    }

    /*
     * Unable to fully structure code
     */
    protected void expand(boolean var1_1) {
        block14: {
            block15: {
                if (this.isExpanded() || this.isLeaf()) break block14;
                var2_2 = this.getVisibleNodes();
                var3_3 = this.treeUI.isFixedRowHeight();
                this.expanded = true;
                var4_4 = this.getRow();
                if (!this.hasBeenExpanded) {
                    var6_5 = this.getValue();
                    var7_6 = this.treeUI.getModel();
                    var8_8 = var7_6.getChildCount(var6_5);
                    this.hasBeenExpanded = true;
                    if (var4_4 == -1) {
                        var9_11 = 0;
                        while (var9_11 < var8_8) {
                            var5_12 = this.treeUI.createNodeForValue(var7_6.getChild(var6_5, var9_11), -1);
                            this.add(var5_12);
                            ++var9_11;
                        }
                    } else {
                        var9_11 = var4_4 + 1;
                        var10_14 = 0;
                        while (var10_14 < var8_8) {
                            var5_12 = this.treeUI.createNodeForValue(var7_6.getChild(var6_5, var10_14), var9_11);
                            this.add(var5_12);
                            ++var10_14;
                        }
                    }
                }
                var5_13 = var4_4;
                var6_5 = this.preorderEnumeration();
                var6_5.nextElement();
                var7_7 = var3_3 != false ? 0 : (this == this.treeUI.treeCacheRoot && this.treeUI.isRootVisible() == false ? 0 : this.getYOrigin() + this.getPreferredSize().height);
                if (var3_3) ** GOTO lbl44
                var9_11 = this.treeUI.updateNodeSizes;
                while (var6_5.hasMoreElements()) {
                    var8_9 = (VisibleTreeNode)var6_5.nextElement();
                    if (var9_11 == 0 && !var8_9.hasValidSize()) {
                        var8_9.updatePreferredSize(var5_13 + 1);
                    }
                    var8_9.setYOrigin(var7_7);
                    var7_7 += var8_9.getPreferredSize().height;
                    var2_2.insertElementAt(var8_9, ++var5_13);
                }
                break block15;
lbl-1000:
                // 1 sources

                {
                    var8_10 = (VisibleTreeNode)var6_5.nextElement();
                    var2_2.insertElementAt(var8_10, ++var5_13);
lbl44:
                    // 2 sources

                    ** while (var6_5.hasMoreElements())
                }
            }
            var9_11 = var5_13++;
            if (var4_4 != var9_11 && var1_1) {
                if (!var3_3 && this.getChildCount() > 0 && var5_13 < this.treeUI.getRowCount()) {
                    var11_16 = var7_7 - (this.getYOrigin() + this.getPreferredSize().height);
                    var10_14 = var2_2.size() - 1;
                    while (var10_14 >= var5_13) {
                        ((VisibleTreeNode)var2_2.elementAt(var10_14)).shiftYOriginBy(var11_16);
                        --var10_14;
                    }
                }
                this.didAdjustTree();
                this.treeUI.visibleNodesChanged();
            }
            this.treeUI.pathWasExpanded(this.getTreePath());
            var10_15 = this.treeUI.getSelectionModel();
            if (var10_15 != null) {
                if (var4_4 != -1 && var4_4 < var9_11 && var10_15.isRowSelected(var4_4) && var10_15.isRowSelected(var4_4 + 1)) {
                    var11_17 = new TreePath[var9_11 - var4_4];
                    var5_13 = var9_11;
                    while (var5_13 > var4_4) {
                        var11_17[var9_11 - var5_13] = this.treeUI.getNode(var5_13).getTreePath();
                        --var5_13;
                    }
                    var10_15.addSelectionPaths(var11_17);
                    return;
                }
                var10_15.resetRowSelection();
            }
        }
    }

    public void collapse() {
        this.collapse(true);
    }

    /*
     * Unable to fully structure code
     */
    protected void collapse(boolean var1_1) {
        block12: {
            block13: {
                if (!this.isExpanded()) break block12;
                var2_2 = null;
                var3_3 = this.preorderEnumeration();
                var3_3.nextElement();
                var4_4 = 0;
                var5_5 = this.treeUI.isFixedRowHeight();
                var6_6 = var5_5 != false ? 0 : this.getPreferredSize().height + this.getYOrigin();
                var7_7 = var6_6;
                var8_8 = this.getRow();
                var9_9 = this.getVisibleNodes();
                var10_10 = this.treeUI.getSelectionModel();
                if (var5_5) ** GOTO lbl34
                while (var3_3.hasMoreElements()) {
                    var11_11 = (VisibleTreeNode)var3_3.nextElement();
                    if (!var9_9.contains(var11_11)) continue;
                    if (var10_10 != null && var10_10.isRowSelected(++var4_4 + var8_8)) {
                        if (var2_2 == null) {
                            var2_2 = new Vector<E>();
                        }
                        var2_2.addElement(var11_11.getTreePath());
                    }
                    var9_9.removeElement(var11_11);
                    var6_6 = var11_11.getYOrigin() + var11_11.getPreferredSize().height;
                }
                break block13;
lbl-1000:
                // 1 sources

                {
                    var11_11 = (VisibleTreeNode)var3_3.nextElement();
                    if (!var9_9.contains(var11_11)) continue;
                    if (var10_10 != null && var10_10.isRowSelected(++var4_4 + var8_8)) {
                        if (var2_2 == null) {
                            var2_2 = new Vector<TreePath>();
                        }
                        var2_2.addElement(var11_11.getTreePath());
                    }
                    var9_9.removeElement(var11_11);
lbl34:
                    // 3 sources

                    ** while (var3_3.hasMoreElements())
                }
            }
            if (var4_4 > 0 && var1_1 && var8_8 != -1) {
                if (!var5_5 && var8_8 + 1 < this.treeUI.getRowCount() && var7_7 != var6_6) {
                    var13_14 = var7_7 - var6_6;
                    var11_12 = var8_8 + 1;
                    var12_15 = var9_9.size();
                    while (var11_12 < var12_15) {
                        ((VisibleTreeNode)var9_9.elementAt(var11_12)).shiftYOriginBy(var13_14);
                        ++var11_12;
                    }
                }
                this.expanded = false;
                this.didAdjustTree();
                this.treeUI.visibleNodesChanged();
            } else {
                this.expanded = false;
            }
            this.treeUI.pathWasCollapsed(this.getTreePath());
            if (var10_10 != null && var4_4 > 0 && var8_8 != -1) {
                if (var2_2 != null) {
                    var11_13 = var2_2.size();
                    var12_16 = new TreePath[var11_13];
                    var2_2.copyInto(var12_16);
                    var10_10.removeSelectionPaths((TreePath[])var12_16);
                    var10_10.addSelectionPath(this.getTreePath());
                    return;
                }
                var10_10.resetRowSelection();
            }
        }
    }

    public Object getValue() {
        return this.getUserObject();
    }

    protected TreePath getTreePath() {
        return this.treeUI.createTreePathFor(this);
    }

    protected Vector getVisibleNodes() {
        return this.treeUI.visibleNodes;
    }

    protected void updateTreeYLocationsFrom(int n) {
        this.treeUI.updateYLocationsFrom(n);
    }
}

