CREATE TABLE DSArray_version 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     pArrayDef                 DBOID   ,
     constraint PKDSArray_version Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE TABLE DSUnion_version 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     pUnionDef                 DBOID   ,
     constraint PKDSUnion_version Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE TABLE DSEnumertdLst_vrsn   -- DSEnumeratedList_version
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     pEnumDef                  DBOID   ,
     constraint PKDSEnmrtdLst_vrsn Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE TABLE DSPointer_version 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     pPointerDef               DBOID   ,
     constraint PKDSPointer_versin Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE TABLE DSArrayDef 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     indexes                   VarChar(254)   ,
     lowerBound                Int   ,
     lowerBoundExpressn        VarChar(254)   ,
     lowerBoundVariable        DBOID   ,
     minimumExtent             Int   ,
     pDataDefinition           DBOID   ,
     pSharedArray              DBOID   ,
     pTypeDefReference         DBOID   ,
     upperBound                Int   ,
     upperBoundExpressn        VarChar(254)   ,
     upperBoundVariable        DBOID   ,
     pShareableElement         DBOID   ,
     constraint PKDSArrayDef Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSArrayDef AS --Plasma for DSArrayDef
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSArrayDef a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSUnionDef 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     pSharedUnion              DBOID   ,
     constraint PKDSUnionDef Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSUnionDef AS --Plasma for DSUnionDef
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSUnionDef a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSEnumerationDef 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     idList                    VarChar(254)   ,
     precision                 Int   ,
     pSharedEnumList           DBOID   ,
     constraint PKDSEnumerationDef Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSEnumerationDf AS --Plasma for DSEnumerationDef
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSEnumerationDef a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSPointerDef 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     isCobolProcPointer        Int   ,
     pDataDefinition           DBOID   ,
     pSharedPointer            DBOID   ,
     pTypeDefReference         DBOID   ,
     constraint PKDSPointerDef Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSPointerDef AS --Plasma for DSPointerDef
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSPointerDef a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSInclddSrcDf_vrsn   -- DSIncludedSourceDef_version
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     isrLanguage               VarChar(254)   ,
     isrProgrammer             VarChar(254)   ,
     constraint PKDIcdScfvs Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE TABLE DSIncludeStatement 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     language                  Int   ,
     referencedInclSorc        DBOID   ,
     text                      VarChar(254)   ,
     constraint PKDSIncludeStatmnt Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSIncludeSttmnt AS --Plasma for DSIncludeStatement
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSIncludeStatement a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSCobolDataDefintn   -- DSCobolDataDefinition
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     bBlankWhenZero            Int   ,
     bGlobal                   Int   ,
     bJustified                Int   ,
     refinedDataItem           DBOID   ,
     constraint PKDSCobolDataDfntn Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSCobolDatDfntn AS --Plasma for DSCobolDataDefinition
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSCobolDataDefintn a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSCobolSpecialDtNm   -- DSCobolSpecialDataName
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     conditionValues           VarChar(254)   ,
     conditionVariable         DBOID   ,
     endRenamedItem            DBOID   ,
     name                      VarChar(254)   ,
     startRenamedItem          DBOID   ,
     level66DataItem           DBOID   ,
     constraint PKDSCobolSpeclDtNm Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSCobolSpclDtNm AS --Plasma for DSCobolSpecialDataName
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSCobolSpecialDtNm a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSPLIDataDefinitin   -- DSPLIDataDefinition
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     hasBuiltInAttribut        Int   ,
     HasOptionalAttribt        Int   ,
     hasParameterAttrbt        Int   ,
     hasReservedAttribt        Int   ,
     hasSystemAttribute        Int   ,
     isAssignable              Int   ,
     isConnected               Int   ,
     isNative                  Int   ,
     isNormal                  Int   ,
     refinedDataItem           DBOID   ,
     storageClass              Int   ,
     constraint PKDSPLIDataDefintn Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSPLIDataDefntn AS --Plasma for DSPLIDataDefinition
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSPLIDataDefinitin a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSPLIArea 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     sizeExpression            VarChar(254)   ,
     sizeVariable              DBOID   ,
     constraint PKDSPLIArea Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSPLIArea AS --Plasma for DSPLIArea
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSPLIArea a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSOffset 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     expression                VarChar(254)   ,
     pPLIAreaVariable          DBOID   ,
     constraint PKDSOffset Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSOffset AS --Plasma for DSOffset
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSOffset a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSFunctionDeclartn   -- DSFunctionDeclaration
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     cFnPrototype              DBOID   ,
     parameterType             DBOID   ,
     pliEntryData              DBOID   ,
     returnedType              DBOID   ,
     constraint PKDSFunctionDclrtn Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSFunctinDclrtn AS --Plasma for DSFunctionDeclaration
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSFunctionDeclartn a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSPLIEntryDataDCL 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     hasVariableAttribt        Int   ,
     initialValue              VarChar(254)   ,
     isExternal                Int   ,
     name                      VarChar(254)   ,
     optionsList               VarChar(254)   ,
     pFunctionDcl              DBOID   ,
     storageClass              Int   ,
     constraint PKDSPLIEntryDatDCL Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSPLIEntryDtDCL AS --Plasma for DSPLIEntryDataDCL
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSPLIEntryDataDCL a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSTypeDefReference 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     cName                     DBOID   ,
     pliName                   DBOID   ,
     pSharedDataDef            DBOID   ,
     constraint PKDSTypeDefRefernc Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSTypeDefRefrnc AS --Plasma for DSTypeDefReference
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSTypeDefReference a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSCFunctionProttyp   -- DSCFunctionPrototype
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     pFunctionDcl              DBOID   ,
     constraint PKDSCFunctinPrttyp Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSCFunctnPrttyp AS --Plasma for DSCFunctionPrototype
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSCFunctionProttyp a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSLinkArrayDefKey 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     isAscending               Int   ,
     constraint PKDSLinkArrayDefKy Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSLinkArrayDfKy AS --Plasma for DSLinkArrayDefKey
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSLinkArrayDefKey a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

