CREATE TABLE ADAnnotationText 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     pAnnotatedObject          DBOID   ,
     contents                  VarChar(3000)   ,
     label                     VarChar(254)   ,
     constraint PKADAnnotationText Primary Key( OID, OVer ) )
     IN KERNEL ;

CREATE VIEW Pl_ADAnnotationTxt AS --Plasma for ADAnnotationText
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    ADAnnotationText a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE ADViewRoot 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     idSequence                Int   ,
     constraint PKADViewRoot Primary Key( OID, OVer ) )
     IN KERNEL ;

CREATE TABLE FHCVRoot 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     name                      VarChar(254)   ,
     freeSpace                 Int   ,
     constraint PKFHCVRoot Primary Key( OID, OVer ) )
     IN KERNEL ;

CREATE TABLE FHCVRootAnchor 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     roots                     DBOID   ,
     constraint PKFHCVRootAnchor Primary Key( OID, OVer ) )
     IN KERNEL ;

CREATE TABLE TCVersionClass 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     OIDC                      DBOIDC   ,
     versionId                 Int   ,
     changeType                VarChar(12)   ,
     osrelCollectorId          DBOID   ,
     osrelPreviousId           DBOIDC   ,
     previousOVer              DBOVer   ,
     previousSidSequenc        Int   ,
     osrelOVersionId           DBOID   ,
     contextId                 DBOID   ,
     sidSequence               Int   ,
     osrelFileId               DBOID   ,
     osrelTCSourceObjct        DBOID   ,
     osrelWorkAreaId           DBOID   ,
     osrelUserId               DBOID   ,
     osrelReleaseId            DBOID   ,
     constraint PKTCVersionClass Primary Key( OID, OVer ) )
     IN KERNEL ;

CREATE TABLE TCCollectorClass 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     typeName                  VarChar(127)   ,
     constraint PKTCCollectorClass Primary Key( OID, OVer ) )
     IN KERNEL ;

CREATE TABLE FHCOVersion 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     SID                       VarChar(47)   ,
     sidSequence               Int   ,
     frozen                    Int   ,
     newlyCheckedOut           Int   ,
     addDate                   VarChar(32)   ,
     freezeDate                VarChar(32)   ,
     releaseVersion            VarChar(3)   ,
     hasSuccessor              VarChar(3)   ,
     hasOutputs                VarChar(3)   ,
     remarks                   Long VarChar   ,
     isTip                     VarChar(3)   ,
     osrelReleaseId            DBOID   ,
     osrelWorkAreaId           DBOID   ,
     osrelLevelId              DBOID   ,
     osrelLevelMemberId        DBOID   ,
     osrelPreviousId           DBOID   ,
     branchPointId             DBOID   ,
     branchSidSequence         Int   ,
     myOVer                    DBOVer   ,
     constraint PKFHCOVersion Primary Key( OID ) )
     IN KERNEL ;

CREATE TABLE FHCVersion 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     OIDC                      DBOIDC   ,
     remarks                   Long VarChar   ,
     buildStatus               VarChar(16)   ,
     parserRC                  Int   ,
     staleSinceQueudFlg        Int   ,
     newlyAddedFlag            Int   ,
     checkStatusFlag           Int   ,
     internalFlags             Int   ,
     pParserMsgs               DBOID   ,
     osrelParserId             DBOID   ,
     generatedBy               DBOID   ,
     constraint PKFHCVersion Primary Key( OID, OVer ) )
     IN KERNEL ;

CREATE TABLE FHCConfFieldData 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     index                     Int   ,
     value                     VarChar(110)   ,
     pFHCConfField             DBOID   ,
     constraint PKFHCConfFieldData Primary Key( OID, OVer ) )
     IN KERNEL ;

CREATE TABLE TCSourceObject 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     transState                VarChar(15)   ,
     osrelAncestorId           DBOID   ,
     remarks                   Long VarChar   ,
     pBulk                     DBOID   ,
     type                      VarChar(8)   ,
     tempName                  VarChar(8)   ,
     nuAddDate                 VarChar(32)   ,
     nuDropDate                VarChar(32)   ,
     changeDate                VarChar(32)   ,
     osrelNuPathId             DBOID   ,
     verSize                   Int   ,
     fmode                     VarChar(4)   ,
     textFileIndicator         Int   ,
     constraint PKTCSourceObject Primary Key( OID ) )
     IN KERNEL ;

CREATE TABLE FhvBulkData 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     pBulk                     DBOID   ,
     compressedSize            Int   ,
     decompressedSize          Int   ,
     data                      Blob(1G) COMPACT    ,
     constraint PKFhvBulkData Primary Key( OID, OVer ) )
     IN BULKDATA ;

CREATE TABLE FhvBulk 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     fileType                  Int   ,
     sizeDecompressed          Int   ,
     sizeCompressed            Int   ,
     chunkSize                 Int   ,
     FhvStatValid              Int   ,
     FhvStat_dev               Int   ,
     FhvStat_ino               Int   ,
     FhvStat_mode              Int   ,
     FhvStat_nlink             Int   ,
     FhvStat_uid               Int   ,
     FhvStat_gid               Int   ,
     FhvStat_rdev              Int   ,
     FhvStat_size              Int   ,
     FhvStat_atime             Int   ,
     FhvStat_mtime             Int   ,
     FhvStat_ctime             Int   ,
     CompTypeFhvChnkLst        Int   ,
     FhvPredecessor            DBOID   ,
     FhvSuccessor              DBOID   ,
     constraint PKFhvBulk Primary Key( OID ) )
     IN BULKDATA ;

