/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcadmin;

import com.ibm.vatc.tcadmin.CopyFile;
import com.ibm.vatc.tcadmin.DeleteFile;
import com.ibm.vatc.tcadmin.ErrorDialog;
import com.ibm.vatc.tcadmin.ProcessMonitor;
import com.ibm.vatc.tcadmin.ProgressDialog;
import com.ibm.vatc.tcadmin.SettingsPanel;
import com.ibm.vatc.tcadmin.ldModel;
import com.ibm.vatc.tcadmin.ldPage;
import com.ibm.vatc.tcadmin.tcadmin;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ListResourceBundle;
import javax.swing.JPanel;

public class GrpsPage
extends JPanel
implements ActionListener {
    private ListResourceBundle locResource = tcadmin.locResource;
    private SettingsPanel Authority;
    private SettingsPanel Interest;
    private ldPage AuthoritPage;
    private ldPage InterestPage;
    private ldModel AuthoritLd;
    private ldModel InterestLd;

    public GrpsPage() {
        this.setLayout(this.getgridlayout());
        this.add("Authority", this.getAuthority());
        this.add("Interest", this.getInterest());
    }

    private GridLayout getgridlayout() {
        GridLayout gridLayout = null;
        gridLayout = new GridLayout();
        gridLayout.setVgap(3);
        gridLayout.setHgap(5);
        gridLayout.setColumns(1);
        gridLayout.setRows(4);
        return gridLayout;
    }

    private SettingsPanel getAuthority() {
        if (this.Authority == null) {
            this.Authority = new SettingsPanel((String)this.locResource.handleGetObject("STR_AUTHORITY_GB"), (String)this.locResource.handleGetObject("STR_AUTHORITY_TEXT"));
            this.Authority.getSettings().addActionListener(this);
        }
        return this.Authority;
    }

    private SettingsPanel getInterest() {
        if (this.Interest == null) {
            this.Interest = new SettingsPanel((String)this.locResource.handleGetObject("STR_INTEREST_GB"), (String)this.locResource.handleGetObject("STR_INTEREST_TEXT"));
            this.Interest.getSettings().addActionListener(this);
        }
        return this.Interest;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.getAuthority().getSettings()) {
            this.AuthoritLd.ReadSettings();
            this.AuthoritPage = new ldPage(1, this.AuthoritLd);
            ((Component)this.AuthoritPage).setVisible(true);
        }
        if (object == this.getInterest().getSettings()) {
            this.InterestLd.ReadSettings();
            this.InterestPage = new ldPage(2, this.InterestLd);
            ((Component)this.InterestPage).setVisible(true);
        }
    }

    public boolean readSettings(File file, Frame frame) {
        boolean bl;
        block4: {
            bl = false;
            if (file == null) break block4;
            try {
                File file2;
                File file3 = new File(file, "authorit.ld");
                if (!file3.exists()) {
                    file2 = new File(tcadmin.tcAdminDir, "authorit.ld");
                    new CopyFile(file2, file);
                }
                this.AuthoritLd = new ldModel(file3, 1);
                file2 = new File(file, "interest.ld");
                if (!file2.exists()) {
                    File file4 = new File(tcadmin.tcAdminDir, "interest.ld");
                    new CopyFile(file4, file);
                }
                this.InterestLd = new ldModel(file2, 2);
                bl = true;
            }
            catch (Throwable throwable) {
                ErrorDialog errorDialog = ErrorDialog.getErrorDialog(frame, (String)tcadmin.locResource.handleGetObject("STR_ERR"), (String)tcadmin.locResource.handleGetObject("STR_ERR_COPY_GRPS"));
                ((Component)errorDialog).setVisible(true);
            }
        }
        return bl;
    }

    public static boolean copySettings(File file, File file2, Frame frame) {
        boolean bl;
        block2: {
            bl = false;
            if (file == null || file2 == null) break block2;
            try {
                new CopyFile(new File(file, "authorit.ld"), file2);
                new CopyFile(new File(file, "interest.ld"), file2);
                bl = true;
            }
            catch (Throwable throwable) {
                ErrorDialog errorDialog = ErrorDialog.getErrorDialog(frame, (String)tcadmin.locResource.handleGetObject("STR_ERR"), (String)tcadmin.locResource.handleGetObject("STR_ERR_COPY_GRPS"));
                ((Component)errorDialog).setVisible(true);
            }
        }
        return bl;
    }

    public static boolean applySettings(File file, String[] stringArray, ProgressDialog progressDialog) {
        ErrorDialog errorDialog;
        int n;
        ProcessMonitor processMonitor;
        String string;
        File file2;
        boolean bl = true;
        if (bl) {
            progressDialog.setMessage((String)tcadmin.locResource.handleGetObject("STR_MSG_UPDATE_INTEREST"));
            progressDialog.increment();
            file2 = new File(file, "interest.ld");
            string = "fhclintr " + file2.getAbsolutePath();
            if (tcadmin.errLog != null) {
                tcadmin.errLog.println(string.toString());
            }
            processMonitor = new ProcessMonitor(string, stringArray);
            processMonitor.addIoListener(progressDialog);
            n = processMonitor.waitFor();
            if (n != 0) {
                errorDialog = ErrorDialog.getErrorDialog(progressDialog.getFrame(), (String)tcadmin.locResource.handleGetObject("STR_ERR"), (String)tcadmin.locResource.handleGetObject("STR_ERR_UPDATE_INTEREST"));
                errorDialog.setOutput(progressDialog.getOutput());
                ((Component)errorDialog).setVisible(true);
                bl = false;
                progressDialog.dispose();
            } else {
                progressDialog.clearOutput();
            }
        }
        if (bl && !progressDialog.isCancelled()) {
            progressDialog.setMessage((String)tcadmin.locResource.handleGetObject("STR_MSG_UPDATE_AUTHORITY"));
            progressDialog.increment();
            file2 = new File(file, "authorit.ld");
            string = "fhclauth " + file2.getAbsolutePath();
            if (tcadmin.errLog != null) {
                tcadmin.errLog.println(string.toString());
            }
            processMonitor = new ProcessMonitor(string, stringArray);
            processMonitor.addIoListener(progressDialog);
            n = processMonitor.waitFor();
            if (n != 0) {
                errorDialog = ErrorDialog.getErrorDialog(progressDialog.getFrame(), (String)tcadmin.locResource.handleGetObject("STR_ERR"), (String)tcadmin.locResource.handleGetObject("STR_ERR_UPDATE_AUTHORIT"));
                errorDialog.setOutput(progressDialog.getOutput());
                ((Component)errorDialog).setVisible(true);
                bl = false;
                progressDialog.dispose();
            } else {
                progressDialog.clearOutput();
            }
        }
        return bl;
    }

    public boolean writeSettings(File file, String[] stringArray, ProgressDialog progressDialog) {
        ErrorDialog errorDialog;
        int n;
        ProcessMonitor processMonitor;
        String string;
        File file2;
        boolean bl = true;
        if (bl && !progressDialog.isCancelled() && this.InterestLd.getWriteable()) {
            progressDialog.setMessage((String)tcadmin.locResource.handleGetObject("STR_MSG_UPDATE_INTEREST"));
            progressDialog.increment();
            this.InterestLd.WriteSettings();
            file2 = new File(file, "interest.ld");
            string = "fhclintr " + file2.getAbsolutePath();
            if (tcadmin.errLog != null) {
                tcadmin.errLog.println(string.toString());
            }
            processMonitor = new ProcessMonitor(string, stringArray);
            processMonitor.addIoListener(progressDialog);
            n = processMonitor.waitFor();
            if (n != 0) {
                errorDialog = ErrorDialog.getErrorDialog(progressDialog.getFrame(), (String)tcadmin.locResource.handleGetObject("STR_ERR"), (String)tcadmin.locResource.handleGetObject("STR_ERR_UPDATE_INTEREST"));
                errorDialog.setOutput(progressDialog.getOutput());
                ((Component)errorDialog).setVisible(true);
                bl = false;
                progressDialog.dispose();
            } else {
                progressDialog.clearOutput();
            }
        }
        if (bl && !progressDialog.isCancelled() && this.AuthoritLd.getWriteable()) {
            progressDialog.setMessage((String)tcadmin.locResource.handleGetObject("STR_MSG_UPDATE_AUTHORITY"));
            progressDialog.increment();
            this.AuthoritLd.WriteSettings();
            file2 = new File(file, "authorit.ld");
            string = "fhclauth " + file2.getAbsolutePath();
            if (tcadmin.errLog != null) {
                tcadmin.errLog.println(string.toString());
            }
            processMonitor = new ProcessMonitor(string, stringArray);
            processMonitor.addIoListener(progressDialog);
            n = processMonitor.waitFor();
            if (n != 0) {
                errorDialog = ErrorDialog.getErrorDialog(progressDialog.getFrame(), (String)tcadmin.locResource.handleGetObject("STR_ERR"), (String)tcadmin.locResource.handleGetObject("STR_ERR_UPDATE_AUTHORIT"));
                errorDialog.setOutput(progressDialog.getOutput());
                ((Component)errorDialog).setVisible(true);
                bl = false;
                progressDialog.dispose();
            } else {
                progressDialog.clearOutput();
            }
        }
        return bl;
    }

    public static void deleteSettings(File file) {
        if (file != null) {
            new DeleteFile(new File(file, "authorit.ld"));
            new DeleteFile(new File(file, "interest.ld"));
        }
    }
}

