/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcmerge;

import com.ibm.vatc.reuse.awt.ButtonPanel;
import com.ibm.vatc.reuse.awt.GridTools;
import com.ibm.vatc.tcmerge.MakeViews;
import com.ibm.vatc.tcmerge.Printer;
import com.ibm.vatc.tcmerge.TextComposite;
import com.ibm.vatc.tcmerge.TextRefFiles;
import com.ibm.vatc.tcmerge.TextRefOutput;
import com.ibm.vatc.tcmerge.WarningDialog;
import com.ibm.vatc.tcmerge.tcmerge;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;

public class PrintDialog
extends Dialog {
    Frame parentFrame;
    Printer printer;
    MakeViews makeViews;
    CheckboxGroup cbg;
    Checkbox cb1;
    ButtonPanel buttonPanel;
    Font font;
    FontMetrics fontmetric;
    int textLocation;
    int fontHeight;
    int pageHeight;
    int pageWidth;

    public PrintDialog(Frame frame, MakeViews makeViews) {
        super(frame, tcmerge.locResource.getString("TITLE_PRINT"), true);
        this.parentFrame = frame;
        this.makeViews = makeViews;
        this.font = tcmerge.getDefaultFont();
        ((Component)this).setFont(this.font);
        Toolkit toolkit = this.getToolkit();
        this.fontmetric = toolkit.getFontMetrics(this.font);
        this.fontHeight = this.fontmetric.getHeight() + 2;
        this.createDialog();
    }

    public void createDialog() {
        DialogListener dialogListener = new DialogListener();
        this.addWindowListener(dialogListener);
        KeyboardListener keyboardListener = new KeyboardListener();
        this.addKeyListener(keyboardListener);
        ((Component)this).setSize(this.calculateSize());
        this.setLayout(new GridBagLayout());
        GridTools.constrain((Container)this, (Component)new Label(tcmerge.locResource.getString("TITLE_PRINT")), (int)2, (int)2, (int)1, (int)1, (int)0, (int)0, (int)17, (int)0);
        this.cbg = new CheckboxGroup();
        this.cb1 = new Checkbox(tcmerge.locResource.getString("ITEM_COMPOSITE"), this.cbg, true);
        this.cb1.addKeyListener(keyboardListener);
        GridTools.constrain((Container)this, (Component)this.cb1, (int)2, (int)3, (int)1, (int)1, (int)0, (int)0, (int)17, (int)0);
        Checkbox checkbox = new Checkbox(tcmerge.locResource.getString("ITEM_MAXIMIZE_INPUT1"), this.cbg, false);
        checkbox.addKeyListener(keyboardListener);
        GridTools.constrain((Container)this, (Component)checkbox, (int)2, (int)4, (int)1, (int)1, (int)0, (int)0, (int)17, (int)0);
        Checkbox checkbox2 = new Checkbox(tcmerge.locResource.getString("ITEM_MAXIMIZE_INPUT2"), this.cbg, false);
        checkbox2.addKeyListener(keyboardListener);
        GridTools.constrain((Container)this, (Component)checkbox2, (int)2, (int)5, (int)1, (int)1, (int)0, (int)0, (int)17, (int)0);
        Checkbox checkbox3 = new Checkbox(tcmerge.locResource.getString("ITEM_MAXIMIZE_INPUT3"), this.cbg, false);
        checkbox3.addKeyListener(keyboardListener);
        GridTools.constrain((Container)this, (Component)checkbox3, (int)2, (int)6, (int)1, (int)1, (int)0, (int)0, (int)17, (int)0);
        Checkbox checkbox4 = new Checkbox(tcmerge.locResource.getString("ITEM_MAXIMIZE_OUTPUT"), this.cbg, false);
        checkbox4.addKeyListener(keyboardListener);
        GridTools.constrain((Container)this, (Component)checkbox4, (int)2, (int)7, (int)1, (int)1, (int)0, (int)0, (int)17, (int)0);
        String[][] stringArray = new String[][]{{tcmerge.locResource.getString("TITLE_PRINT"), "Print"}, {tcmerge.locResource.getString("STR_CANCEL"), "Cancel"}};
        ButtonPanel buttonPanel = new ButtonPanel(stringArray, (ActionListener)new ButtonListener());
        buttonPanel.addKeyListener((KeyListener)keyboardListener);
        GridTools.constrain((Container)this, (Component)buttonPanel, (int)2, (int)9, (int)1, (int)1, (int)0, (int)0, (int)13, (int)0);
        Canvas canvas = new Canvas();
        canvas.setSize(15, 15);
        GridTools.constrain((Container)this, (Component)canvas, (int)1, (int)1, (int)1, (int)1);
        Canvas canvas2 = new Canvas();
        canvas2.setSize(15, 15);
        GridTools.constrain((Container)this, (Component)canvas2, (int)3, (int)10, (int)1, (int)1);
        Canvas canvas3 = new Canvas();
        canvas3.setSize(190, 20);
        GridTools.constrain((Container)this, (Component)canvas3, (int)2, (int)8, (int)1, (int)1);
        Dimension dimension = this.parentFrame.getSize();
        Dimension dimension2 = this.getSize();
        Point point = this.parentFrame.getLocationOnScreen();
        ((Component)this).setLocation(point.x + (dimension.width - dimension2.width) / 2, point.y + (dimension.height - dimension2.height) / 2);
    }

    Dimension calculateSize() {
        int n;
        int n2 = 14;
        int n3 = 10;
        Dimension dimension = new Dimension();
        int n4 = n2 * this.getToolkit().getFontMetrics(tcmerge.getDefaultFont()).getHeight();
        if (n4 < 230) {
            n4 = 230;
        }
        if ((n = n3 * this.getToolkit().getFontMetrics(tcmerge.getDefaultFont()).charWidth('W')) < 260) {
            n = 260;
        }
        dimension.setSize(n, n4);
        return dimension;
    }

    private void printComposite() {
        Vector vector = this.makeViews.getTableComposite();
        Dimension dimension = this.printer.createPrintJob();
        if (dimension == null) {
            return;
        }
        this.pageHeight = dimension.height;
        this.pageWidth = dimension.width;
        this.printHeader();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            TextComposite textComposite = (TextComposite)enumeration.nextElement();
            if ((textComposite.flag & 1) != 0) {
                this.printer.tab(5);
                if ((textComposite.flag & 0x10) != 0) {
                    this.printer.print("1:");
                } else if ((textComposite.flag & 0x20) != 0) {
                    this.printer.print("2:");
                } else {
                    this.printer.print("3:");
                }
            }
            this.printer.tab(8);
            this.fitToPage(this.formatString(textComposite.text));
            if (this.textLocation + 10 <= this.pageHeight) continue;
            this.printer.newPage();
            this.printHeader();
        }
        this.printer.newPage();
        this.printer.endJob();
    }

    private void printInput(int n) {
        Enumeration enumeration;
        switch (n) {
            case 1: {
                enumeration = this.makeViews.getTableFileZero().elements();
                break;
            }
            case 2: {
                enumeration = this.makeViews.getTableFileOne().elements();
                break;
            }
            default: {
                enumeration = this.makeViews.getTableFileTwo().elements();
            }
        }
        Vector vector = this.makeViews.getTableComposite();
        Dimension dimension = this.printer.createPrintJob();
        if (dimension == null) {
            return;
        }
        this.pageHeight = dimension.height;
        this.pageWidth = dimension.width;
        this.printHeader();
        while (enumeration.hasMoreElements()) {
            TextRefFiles textRefFiles = (TextRefFiles)enumeration.nextElement();
            TextComposite textComposite = (TextComposite)vector.elementAt(textRefFiles.reference);
            this.printer.tab(8);
            this.fitToPage(this.formatString(textComposite.text));
            if (this.textLocation + 10 <= this.pageHeight) continue;
            this.printer.newPage();
            this.printHeader();
        }
        this.printer.newPage();
        this.printer.endJob();
    }

    private void printOutput() {
        Vector vector = this.makeViews.getTableComposite();
        Vector vector2 = this.makeViews.getTableEdit();
        Dimension dimension = this.printer.createPrintJob();
        if (dimension == null) {
            return;
        }
        this.pageHeight = dimension.height;
        this.pageWidth = dimension.width;
        this.printHeader();
        Enumeration enumeration = this.makeViews.getTableOutput().elements();
        while (enumeration.hasMoreElements()) {
            TextRefOutput textRefOutput = (TextRefOutput)enumeration.nextElement();
            this.printer.tab(8);
            if (textRefOutput.textRef == -2) continue;
            if (textRefOutput.textRef == -1) {
                this.println(">>>");
                continue;
            }
            if ((textRefOutput.flag & 1) != 0 && (textRefOutput.flag & 8) != 0) {
                this.fitToPage(this.formatString((String)vector2.elementAt(textRefOutput.textRef)));
            } else {
                TextComposite textComposite = (TextComposite)vector.elementAt(textRefOutput.textRef);
                this.fitToPage(this.formatString(textComposite.text));
            }
            if (this.textLocation + 10 <= this.pageHeight) continue;
            this.printer.newPage();
            this.printHeader();
        }
        this.printer.newPage();
        this.printer.endJob();
    }

    private void fitToPage(String string) {
        if (this.fontmetric.stringWidth(string) + 120 > this.pageWidth) {
            int n = string.length() - 1;
            while (this.fontmetric.stringWidth(string.substring(0, n)) + 120 > this.pageWidth) {
                --n;
            }
            this.println(string.substring(0, n));
            this.printer.tab(8);
            this.fitToPage(string.substring(n));
            return;
        }
        this.println(string);
    }

    private void println(String string) {
        this.printer.println(string);
        this.textLocation += this.fontHeight;
    }

    private void printHeader() {
        this.printer.setFont(this.font);
        this.printer.println("");
        this.printer.println("");
        this.printer.println("");
        this.textLocation = 3 * this.fontHeight;
    }

    private String formatString(String string) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer(512);
        if (string.equals("^~:ZeroLength:~^")) {
            string2 = "";
        } else if (string.length() == 0) {
            string2 = "";
        } else {
            int n;
            int n2 = 12;
            stringBuffer.insert(0, string);
            while ((n = (string2 = stringBuffer.toString()).indexOf(9, 0)) != -1) {
                int n3 = n % n2;
                int n4 = 0;
                while (n4 < n2 - n3) {
                    if (n4 == 0) {
                        stringBuffer.setCharAt(n + n4, ' ');
                    } else {
                        stringBuffer.insert(n + n4, ' ');
                    }
                    ++n4;
                }
            }
            string2 = stringBuffer.toString();
            stringBuffer = null;
        }
        return string2;
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
            PrintDialog.this = PrintDialog.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Cancel")) {
                ((Component)PrintDialog.this).setVisible(false);
                return;
            }
            PrintDialog.this.printer = new Printer(PrintDialog.this.parentFrame);
            Checkbox checkbox = PrintDialog.this.cbg.getSelectedCheckbox();
            String string2 = checkbox.getLabel();
            if (string2.equals(tcmerge.locResource.getString("ITEM_COMPOSITE"))) {
                PrintDialog.this.printComposite();
            } else if (string2.equals(tcmerge.locResource.getString("ITEM_MAXIMIZE_INPUT1"))) {
                PrintDialog.this.printInput(1);
            } else if (string2.equals(tcmerge.locResource.getString("ITEM_MAXIMIZE_INPUT2"))) {
                PrintDialog.this.printInput(2);
            } else if (string2.equals(tcmerge.locResource.getString("ITEM_MAXIMIZE_INPUT3"))) {
                if (PrintDialog.this.makeViews.getDiffInput().numInputFiles() < 3) {
                    WarningDialog warningDialog = new WarningDialog(PrintDialog.this.parentFrame, tcmerge.locResource.getString("STR_CANNOT_PRINT_INPUT3"));
                    warningDialog.show();
                    return;
                }
                PrintDialog.this.printInput(3);
            } else {
                PrintDialog.this.printOutput();
            }
            ((Component)PrintDialog.this).setVisible(false);
        }
    }

    class DialogListener
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            ((Component)PrintDialog.this).setVisible(false);
        }

        DialogListener() {
            PrintDialog.this = PrintDialog.this;
        }
    }

    class KeyboardListener
    extends KeyAdapter {
        KeyboardListener() {
            PrintDialog.this = PrintDialog.this;
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27) {
                ((Component)PrintDialog.this).setVisible(false);
            }
        }
    }
}

