/*
*********************************************************************
*             IBM TeamConnection for OS/2
*                     Version 1 Release 0
*
*                       5622-717
*    (C) Copyright, IBM Corp., 1995. All Rights Reserved.
*             Licensed Materials - Property of IBM
*
*         US Government Users Restricted Rights
*     - Use, duplication or disclosure restricted by
*         GSA ADP Schedule Contract with IBM Corp.
*
*              IBM is a registered trademark of
*        International Business Machines Corporation
*********************************************************************
*
*           NOTICE TO USERS OF THE SOURCE CODE EXAMPLES
*
* INTERNATIONAL BUSINESS MACHINES CORPORATION PROVIDES THE SOURCE CODE
* EXAMPLES, BOTH INDIVIDUALLY AND AS ONE OR MORE GROUPS, "AS IS" WITHOUT
* WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
* PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE
* OF THE SOURCE CODE EXAMPLES, BOTH INDIVIDUALLY AND AS ONE OR MORE GROUPS,
* IS WITH YOU.  SHOULD ANY PART OF THE SOURCE CODE EXAMPLES PROVE
* DEFECTIVE, YOU (AND NOT IBM OR AN AUTHORIZED DEALER) ASSUME THE ENTIRE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
*********************************************************************
 | COMPONENT_NAME: mailexit.c
 |
 |      This module is a sample mailexit to be used with the
 |      TeamConnection notify deamon.  It uses sendmail.
 |      This is intended as a sample, and does not include
 |      error checking or special handling.
 |
 | COMPILE:
 |
 |      icc mailexit.c
 |
 |
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

main(int argc, char *argv[])
{

   char *cmd;
   char *addressees;
   int  i;
   int  count=3;    /* a little extra */
#if defined(__NT__)
   FILE *stream;
#endif

   /* make sure that arguements are passed */
   if (argc == 1)
      return -1;


   /* count how big the addresses and command are and then alloc memory */
   for(i=2; i<argc; i++)
      {
       count += strlen(argv[i]);
       count++;   /* for a separator character */
      }

   addressees = malloc(count);
   cmd        = malloc(strlen(argv[1]) + count + 100);
   *addressees = '\0';
   *cmd        = '\0';


   for(i=2; argv[i] != NULL; i++) {
      strcat(addressees, argv[i]);
      strcat(addressees, " ");
   }

#if defined(__OS2__)
   sprintf(cmd, "sendmail -af %s -f %s", argv[1], addressees);
#endif
#if defined(__NT__)
   /* until we find a mailexit just log it */
   stream = fopen("mailexit.out","a+");
   fprintf(stream,"Addressees=%s\n", addressees);
   fclose(stream);
   sprintf(cmd, "type %s >> mailexit.out", argv[1] );
#endif
#if defined(__UNIX__)
   sprintf(cmd, "sendmail %s <%s", addressees, argv[1]);
#endif
   system(cmd);

   free(cmd);
   free(addressees);
   return 0;
}
