/*
 *   Lotus Notes 4.5 C API
 *
 *   tcextpwd.c - Windows DLL framework for extension manager password override.
 *
 *   The program will bypass the password prompt by a Lotus Notes client.
 *
 *   The environment variable TC_LNPWD is checked for the password.
 *   If set it is used, otherwise it defaults to "TCLNPWD".
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifdef UNIX
#include <termios.h>
#include <unistd.h>
#endif

#include <global.h>
#include <names.h>
#include <extmgr.h>
#include <bsafeerr.h>
#include <nsferr.h>

/************************************************************/
/* Update the next line for the Lotus Notes Client password */
/************************************************************/
#define LN_DFLT_PWD  "TCLNPWD"

HEMREGISTRATION hHandler;

STATUS LNPUBLIC handler(EMRECORD *data);
STATUS LNPUBLIC MainEntryPoint();

/* this handler is will return the password */
STATUS LNPUBLIC handler(EMRECORD *data)
{
        VARARG_PTR              pArgs;
        DWORD                   MaxPwdLen;
        DWORD far *             retLength;
        char far *              retPassword;
        char far *              FileName;
        char far *              OwnerName;
        DWORD                   DataLen;
        BYTE far *              Data;
        char *                  password;


        if (EM_GETPASSWORD != data->EId)
                return (ERR_EM_CONTINUE);

               /* Fetch the arguments */
                pArgs = data->Ap;
            MaxPwdLen = VARARG_GET (pArgs, DWORD);
            retLength = VARARG_GET (pArgs, DWORD far *);
          retPassword = VARARG_GET (pArgs, char far *);
             FileName = VARARG_GET (pArgs, char far *);
            OwnerName = VARARG_GET (pArgs, char far *);
              DataLen = VARARG_GET (pArgs, DWORD);
                 Data = VARARG_GET (pArgs, BYTE far *);

        password = getenv("TC_LNPWD");
        if (password)
           strcpy(retPassword,password);
        else
           strcpy(retPassword,LN_DFLT_PWD);
        *retLength = strlen(retPassword);

        return ERR_BSAFE_EXTERNAL_PASSWORD;
}

STATUS LNPUBLIC MainEntryPoint()
{
        STATUS err;

        /* Register the handler for the password */
        if(err=EMRegister(EM_GETPASSWORD, EM_REG_BEFORE, handler,0, &hHandler))
            fprintf(stderr, "EMRegister failed.\n");

        return err;
}
