#!/usr/bin/ksh
#
# NAME: tcDBcfg familyName
# EXAMPLE USAGE:
#      tcDBcfg.ksh testfam  2>&1  |  tee tcdbconfig.out
#
# ENVIRONMENT VARIABLES:
#      TC_FAMILY
#      TC_BECOME
#
# DESCRIPTION:
#   This command displays the db2level, tclevel, all db2 variables and
#   all tc_ variables, the DB2 "admin", "dbm", and
#   "db" configurations, as well as info for bufferpools, tablespaces,
#   TCPERF% indexes, and current statistics.
#
# NOTE:
# * It must be run from the VA TC family user id.
#****************************************************************************

function settcfamily
{
  unset tcfamily
  if [[ -n ${TC_FAMILY} ]] ; then
    tcfamily=$(print ${TC_FAMILY} | sed 's/@.*$//')
  else
    print -u2 Cannot determine TeamConnection family name
    return 1
  fi
  return 0
}

## For problem determination purposes, tracing is done by
## uncommenting the following variables:
# export TC_TRACE=*
# export TC_TRACEFILE=${TC_DBPATH}/trace.out
 
## display command line
print -u2 "# ${0} ${*}"
## check for valid arguments
if [[ ${#} > 0 ]]
then
  print -u2 'tcDBcfg -- display the DB2 configuration parameters of a TC family database '
  print -u2 ' '
  print -u2 'Usage:'
  print -u2 '    tcDBcfg'
  print -u2 ' '
  print -u2 'Examples:'
  print -u2 '    tcDBcfg'
  return 1
fi
 
if settcfamily
then
  print '+-------------------------------------------------------------+'
  print '|                                                             |' 
  print '| VisualAge TeamConnection and DB2 Configuration information  |' 
  print '|                                                             |' 
  print '+-------------------------------------------------------------+' 
  print ' ' 
  print 'Date: ' `date`

  print 'tcDBcfg ---------------------------------TeamConnection version'
  print 'tclevel'
  tclevel

  print 'tcDBcfg -------------------TeamConnection environment variables'
  print 'env | grep -i tc_'
  env | grep -i tc_

  print 'tcDBcfg ---------------------------Operating system and version'
  print 'uname -a'
  uname -a

  print 'tcDBcfg ----------------------------------------------User info'
  print 'Login name: ' $LOGNAME
  print 'Directory: ' `pwd`

  print 'tcDBcfg -----------------------------------Available disk space'
  print 'df -k'
  df -k

  print 'tcDBcfg --------------------------------------------DB2 version'
  print 'db2level'
  db2level
 
  print 'tcDBcfg ---------------------------------DB2 registry variables' 
  print 'db2set -all'
  db2set -all

  print 'tcDBcfg ------------------------------DB2 environment variables'
  print 'env | grep -i db2'
  env | grep -i db2 
 
  print 'tcDBcfg --------------------------------DB2 admin configuration'
  print 'db2 get admin cfg'
  db2 get admin cfg
 
  print 'tcDBcfg ----------------------DB2 database manager configuration' 
  print 'db2 get dbm cfg'
  db2 get dbm cfg
 
  print 'tcDBcfg ----------------------DB2 family database configuration'
  print "db2 get db cfg for ${tcfamily}"
  db2 get db cfg for ${tcfamily}

  print 'tcDBcfg ------------------------Connecting to tcFamily database'
  db2 connect to ${tcfamily}
 
  print 'tcDBcfg ----------------------------------------Bufferpool info'
  print 'db2 "select * from syscat.bufferpools"'
  db2 "select * from syscat.bufferpools"
 
  print 'tcDBcfg ----------------------------------------Tablespace info'
  print 'db2 "select definer, tbspace, tbspacetype as type, tbspaceid as id, bufferpoolid as pool, datatype, extentsize, prefetchsize, pagesize, overhead, transferrate from syscat.tablespaces"'
  db2 "select definer, tbspace, tbspacetype as type, tbspaceid as id, bufferpoolid as pool, datatype, extentsize, prefetchsize, pagesize, overhead, transferrate from syscat.tablespaces"
 
  print 'tcDBcfg -----------------------------Last table statistics time'
  print 'db2 "select tabschema, tabname, stats_time, card from syscat.tables where type='"'T'"' and tabschema=(select tabschema from syscat.tables where tabname='"'FHCFILE'"') order by tabname"'
  db2 "select tabschema, tabname, stats_time, card from syscat.tables where type='T' and tabschema=(select tabschema from syscat.tables where tabname='FHCFILE') order by tabname"
 
  print 'tcDBcfg -----------------------------Last index statistics time'
  print 'db2 "select tabname, indname, stats_time, unique_colcount, colnames from syscat.indexes where tabschema=(select tabschema from syscat.tables where tabname='"'FHCFILE'"') order by tabname, indname"'
  db2 "select tabname, indname, stats_time, unique_colcount, colnames from syscat.indexes where tabschema=(select tabschema from syscat.tables where tabname='FHCFILE') order by tabname, indname"
 
  print 'tcDBcfg ---------------------------------Last package bind time'
  print 'db2 "select pkgschema, pkgname, valid, last_bind_time from syscat.packages where pkgschema=(select pkgschema from syscat.packages where pkgname='"'TCMOD'"') order by pkgname"'
  db2 "select pkgschema, pkgname, valid, last_bind_time from syscat.packages where pkgschema=(select pkgschema from syscat.packages where pkgname='TCMOD') order by pkgname"
 
  print 'tcDBcfg -------------------------------DB2 reorganization check'
  print 'db2 "reorgchk current statistics on table user"'
  db2 "reorgchk current statistics on table user"

  print 'tcDBcfg ---------------Disconnecting from the tcFamily '
  db2 connect reset
   
# This stuff needs to be last, to avoid problems with the piping and tee

  print 'tcDBcfg --------------------------TeamConnection user exit info' 
  found=0
  print 'grep -v "^#" config/userExit'
  grep -v "^#" config/userExit
  print ' '
  grep -v "^#" config/userExit | awk '{ print $3 }' |
  while read userExit
    do
	     find ${HOME} -type f -name "${userExit}" -print -exec ls -lt {} \; |
	     awk '{ print $5" "$6" "$7" "$8" "$9 }'
       found=1
    done
  if ((found==0))
     then print 'no user exit programs were found in config/userExit'
  fi


else
  exit 1
fi

exit 0

# end of file
