#!/usr/bin/ksh

# This program takes no parameters. It is used to generate shell script files on Unix to
# Delete levelMembers from Levels in the integrate state prior to migrating to TC.
# It also generates a shell script to Add teh levelMembers back into TC once the migration
#of Levels are complete.


function usage
{
   print -u2 'usage:  processLevels DATABASE  '
   print  "           details: DATABASE = DB2|ORACLE|ORACLE7|SYBASE|INFORMIX"
   exit 1
}

#main
#set -x
curDir=$PWD
#TMPFILE=/tmp/tmpfile.$$
TMPFILE=tempfile
RenMem=$curDir/renameLevelsCMVC.ksh
OUTFILE=$curDir/renameLevelsCMVC.log

if [ -f ${OUTFILE} ]
  then
   rm -f ${OUTFILE}
fi
#if [ -f ${TMPFILE} ]
#  then
#   rm -f ${TMPFILE}
#fi
if [ -f ${RenMem} ]
  then
   rm -f ${RenMem}
fi

if [ "$#" -ne 1 ]
  then usage
fi

if [ -z "${CMVC_FAMILY}" ]
  then
     print " "
     print -u2 "ERROR: CMVC_FAMILY must be set"
     print " "
     return 1
   fi

DATABASE=${1}
case "${DATABASE}" in

  ORACLE|ORACLE7|oracle|oracle7 )
    SQL="${ORACLE_HOME}/bin/sqlplus"
    U_STRING=""
    COMMIT_STRING=""
    PASSWORD_STRING="/${ORACLE_PASS}"
    SEMI_STRING=";"
    INIT_CMD="${SQL} ${U_STRING} ${FAMILY}${PASSWORD_STRING}"
    ;;

  DB2|db2 )
    SQL="${DB2_HOME}/sqllib/bin/db2"
    U_STRING=" -o -t +v"
    COMMIT_STRING=""
    PASSWORD_STRING=""
    SEMI_STRING=";"
    INIT_CMD="${SQL} ${U_STRING}"
    ;;

  INFORMIX|informix )
    SQL="${INFORMIXDIR}/bin/isql"
    U_STRING=""
    COMMIT_STRING="commit work;"
    PASSWORD_STRING=""
    SEMI_STRING=";"
    INIT_CMD="${SQL} ${U_STRING} ${FAMILY} ${PASSWORD_STRING}"
    ;;

  SYBASE|sybase )
    SQL="${SYBASE}/bin/isql"
    U_STRING=""
    COMMIT_STRING="go"
    PASSWORD_STRING=" -P ${SYBASE_PASS}"
    SEMI_STRING=""
    INIT_CMD="${SQL} ${U_STRING} ${PASSWORD_STRING}"
    ;;

  * )
    print "Unrecognized DATABASE $DATABASE" | tee -a $OUTFILE
    usage
    ;;

esac


Report -raw -view levelView -where "name in (select defectName from TrackView) OR name in (select name from releaseView) order by name, releasename"  | awk -F\| '{ print $1 }' > ${TMPFILE}
rc=$?
if (( $rc > 0 ))
  then
  print "ERROR: Could not generate the list of levels to be renamed."
  print "Verify connectivity to your CMVC family and that you are a SuperUser"
  print " "
  return 1
fi


if [ -s ${TMPFILE} ]
  then
   print "processing levels"
   print  " "
   echo "########################################################################"  > ${RenMem}
   echo "# Run this script on your CMVC source family to rename levels that have"  >> ${RenMem}
   echo "# the same name as an existing release or existing defect."                 >> ${RenMem}
   echo "# This must be executed prior  to migrating to TeamConnection Version 3"  >> ${RenMem}
   echo "########################################################################" >> ${RenMem}

   echo "${INIT_CMD} | tee  ${OUTFILE} "  >> ${RenMem}
   if [ ${DATABASE} = "DB2" -o ${DATABASE} = "db2" ]
   then
      echo  "connect to ${CMVC_FAMILY} 2>&1 | tee -a ${OUTFILE} "          >> ${RenMem}
   fi

   while read level
   do
      echo "update levels set name='${level}L' where name='${level}' 2>&1 | tee -a ${OUTFILE} "  >> ${RenMem}
      echo "${SEMI_STRING}"  >> ${RenMem}
      echo "${COMMIT_STRING}"  >> ${RenMem}
   done < ${TMPFILE}


   if [ ${DATABASE} = "DB2" -o ${DATABASE} = "db2" ]
   then
     echo  "commit 2>&1 | tee -a ${OUTFILE}"                  >> ${RenMem}
     echo  "connect reset 2>&1 | tee -a ${OUTFILE}"           >> ${RenMem}
   fi

   echo " " >> ${RenMem}
   echo "print \"Results are logged in file: ${OUTFILE}\" "     >> ${RenMem}

else
  print " There Are No Levels  required to be renamed prior to Migration"
  return 0
fi

print "Successful Completion !!!"
#print "-----------------------------------------"
if [ -s ${RenMem} ]
  then
  print " "
  print " This program did not modify your CMVC or TeamConnection families. It only created the "
  print " the following shell script to be executed by your Family Administrators."
  print " "
  print " =========  review the comments in the generated script file prior to executing. ========"
  print " "
  print "generated script to RENAME levels from CMVC: ${RenMem}"
fi
exit 0

