#!/usr/bin/ksh
# NAME:    release_delete.ksh
# PURPOSE: 
#  This utility will delete work in a given release.
#  It will also identify a list of vc (SCCS/PVCS) files that are not
#  related to any other release that can be removed to save disk space.
# NOTE:
#   This script must be run by a CMVC superuser id.


################################################################################
function usage
{
        print -u2 "USAGE: ${PROG} -f <FAMILY> -r <RELEASENAME> -d <DEFECT> -w"
        print -u2 "WHERE: FAMILY      is the CMVC family to process"
        print -u2 "       RELEASENAME is the active CMVC release"
        print -u2 "       DEFECT      is the CMVC defect for the track"
        print -u2 "NOTE : script must be run by the family account SUPERUSER"
	print -u2 "       w option define what sccs and mapfiles can be deleted"
        exit 1
}
################################################################################
function initialize
{
	RC=0
	if [ -z "${FAMILY}" ]
          then  print -u2 "<<ERROR>> FAMILY name required"
                RC=1
          else  CMVC_FAMILY=${FAMILY}
        fi
        WHOAMI=`id -u -n`
        SUPERUSER=`Report -view users -wh "login = '${WHOAMI}' AND superuser = 'yes'" -raw`
        if [ -z "${SUPERUSER}" ]
          then  print -u2 "<<ERROR>> LOGIN invalid or not SUPERUSER"
                RC=1
        fi
        if [ -z "${RELEASE}" ]
          then  print -u2 "<<ERROR>> RELEASE name required"
                RC=1
          else  PROCESS=`Report -view releaseview -wh "dropdate is null AND name = '${RELEASE}'" -raw | cut -d\| -f3`
                if [ -z "${PROCESS}" ]
                  then  print -u2 "<<ERROR>>  RELEASE name INVALID or deleted"
                        RC=1
                fi
	fi
        if [ -z "${DEFECT}" ]
          then  print -u2 "<<ERROR>> DEFECT name required"
                RC=1
	  else	CHECK=`Report -view trackview -wh "state = 'fix' AND defectname = '${DEFECT}' AND releasename = '${RELEASE}'" -raw`
		if [ -z "${CHECK}" ]
		  then	print -u2 "<<ERROR>> Track not in fix state"
			RC=1
		fi
	fi
	CHECK=`Report -view fileview -where "releasename = '${RELEASE}' AND versionsid != nuversionsid" -raw`
	if [ -n "${CHECK}" ]
	  then	print -u2 "<<ERROR>> All work needs to be committed"
		RC=1
	fi
	CHECK=`Report -view filesoutview -where "releasename = '${RELEASE}'" -raw`
	if [ -n "${CHECK}" ]
	  then	print -u2 "<<ERROR>> All files need to be unlocked"
		RC=1
	fi
	OUTFILE=/tmp/outfile.$$
	BADFILE=/tmp/badfile.$$
	TMPFILE=/tmp/tmpfile.$$
}
################################################################################
function process
{
        print "OUTPUT FILE: ${OUTFILE}"
        print "FAILED CMDS: ${BADFILE}"
	Report -view fileview -where "releasename = '${RELEASE}' AND dropdate is NULL AND nudropdate is NULL" -raw |
	while read record
	  do
		FILE=`print ${record} | cut -d\| -f8`
		cmd="File -delete ${FILE} -release ${RELEASE} -defect ${DEFECT}"
		cmd="${cmd} -force"
		print "${cmd}"
		eval ${cmd} 2>/dev/null
		if [ $? -ne 0 ]
		  then	print "${cmd}" >>${BADFILE}
 			RC=1
		fi
	  done
}
################################################################################
function process_text
{
	typeset -R4 BASENAME
	BASENAME=`head -2 ${TMPFILE} | tail -1 | cut -d\, -f3`
	PATHNAME=`head -3 ${TMPFILE} | tail -1 | cut -d\, -f2`/${BASENAME}
	print "rm -rf ${PATHNAME}" >>${OUTFILE}
}
################################################################################
function process_binary
{
	PATHNAME=`head -3 ${TMPFILE} | tail -1 | cut -d\, -f1`
	print "rm -rf ${PATHNAME}" >>${OUTFILE}
}
################################################################################
function process_unknown
{
	print "Unknown type from file: ${FILE} ${TMPFILE}" >>${BADFILE}
	RC=1
}
################################################################################
function process_dasd_recovery
{
# NOTE: shared, destroyed files from other releases will be removed
	Report -view fileview -wh "releasename = '${RELEASE}' and sourceid not in (select sourceid from fileview where releasename != '${RELEASE}')" -raw | cut -d\| -f8 |
	while read FILE
	  do
		vcPath ${FILE} ${RELEASE} >${TMPFILE} 2>/dev/null
		SIZE=`wc -l ${TMPFILE} 2>/dev/null | awk '{ print $1 }'`
		case "${SIZE}" in
  		  6)	process_binary
			;;
  		  4)	process_text
			;;
  		  *)	process_unknown
			;;
		esac
	  done
	print "rm -rf ${HOME}/maps/${RELEASE}" >>${OUTFILE}
}
################################################################################
# main processing
PROG=${0##*/}
while getopts :f:r:d:w argument
  do
        case "${argument}" in
          f)    FAMILY=${OPTARG}
                ;;
          r)    RELEASE=${OPTARG}
                ;;
          d)    DEFECT=${OPTARG}
                ;;
          w)    WIPEOUT=yes
                ;;
          \?)   usage
                ;;
        esac
  done
initialize
if [ "${RC}" -eq "0" ]
  then  process
	if [ "${RC}" -eq 0 ]  
	  then	if [ "${WIPEOUT}" = "yes" ]
	  	  then	process_dasd_recovery
		fi
	fi
  else  usage
fi
rm -rf ${TMPFILE} >/dev/null 2>&1
exit ${RC}

# end of file

