#!/usr/bin/ksh
#
# NAME:  do-what.ksh levelListFile includeFileBaseName
#
# SAMPLE INVOCATION:
#
#   do-what.ksh master.list what-info
#
# PURPOSE:
#
# PURPOSE:
# To generate the java class whatInfo which will be instantiated
# by both the myapp and myapplevel applications.  The "report"
# method will be used to display all the serviceability strings.

# CUSTOMIZATION NOTES:
#  * See the sections labeled "CUSTOMIZATION REQUIRED". 
#  * You may want to customize this script to suit your needs. For example:
#    * Replace the value for the "keyword" variable to identify 
#      your application.
#
#*********************************************************************/

# CUSTOMIZATION NEEDED.
# Set the keyword to be used during what and grep

keyword="myapp"

# Verify the input parameters

if [ "$#" -eq 2 ]
then
  levelListFile=$1
  includeFileBaseName=$2
  infoFile=`echo $includeFileBaseName`".java"
  print "do-what.ksh begin"
  print " -> file with level information: $levelListFile "
  print " -> info file:         $infoFile"
else
  print "*** Error. Invalid number of arguments"
  print "Usage: do-what.ksh levelListFile includeFileBaseName"
  print ""
  exit 1
fi

#
# Generating the java info file
#

print ""
print "do-what.ksh: generating info file: $infoFile"

rm $infoFile 2>/dev/null
print "/* Name:	 $infoFile */"                             >> $infoFile
print "/* Purpose: This file is generated during build time.    */" >> $infoFile
print "/*  It has the 'build-time' serviceability information.  */" >> $infoFile
print "/*  to be displayed by using the myapplevel utility.           */" >> $infoFile
print ""                                                            >> $infoFile
print "package $keyword;"                                          >> $infoFile
print ""                                                            >> $infoFile
print "public class $includeFileBaseName"                          >> $infoFile
print "{"                                                          >> $infoFile
print "  //This class is generated by do-what.ksh or do-what.cmd.  Do not modify!" >> $infoFile
print "  //VARIABLES"                                              >> $infoFile

while read line
do
   name=`echo $line | cut -d' ' -f1`    # Get first field
   value=`echo $line | cut -d' ' -f2-`  # Get everything after the first field
   
   stringValue=`echo "  public String $name = \"@(#) $keyword $value\";"`     
   print "$stringValue"                                             >> $infoFile
done < $levelListFile

print "  //METHODS"                                              >> $infoFile
print "    public void report()"                                 >> $infoFile
print "    {"                                                    >> $infoFile
print ""                                                         >> $infoFile
while read line
do
   name=`echo $line | cut -d' ' -f1`    # Get first field
   value=`echo $line | cut -d' ' -f2-`  # Get everything after the first field
   
   stringValue=`echo "	System.out.println(this.$name);"`     
   print "$stringValue"                                             >> $infoFile
done < $levelListFile
print "    }//end of report()"                                   >> $infoFile
print "}//end of whatInfo"                                       >> $infoFile
print ""                                                         >> $infoFile
print "/* end of file */"                                        >> $infoFile



print "do-what.ksh: done!"
print ""

exit 0

# end of file
