/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tpf.installHandler;

import com.ibm.tpf.installHandler.InstallHandlerUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;

public class EnvVarResolver {
    private static final char ENVVAR_PREFIX = '%';
    protected Properties envVars;
    public static EnvVarResolver resolver;

    protected EnvVarResolver() {
        try {
            String line;
            Process p = null;
            this.envVars = new Properties();
            Runtime r = Runtime.getRuntime();
            String OS = System.getProperty("os.name").toLowerCase();
            p = OS.indexOf("windows 9") > -1 ? r.exec("command.com /c set") : (OS.indexOf("nt") > -1 || OS.indexOf("windows 2000") > -1 || OS.indexOf("windows xp") > -1 ? r.exec("cmd.exe /c set") : r.exec("env"));
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = br.readLine()) != null) {
                int idx = line.indexOf(61);
                String key = line.substring(0, idx);
                String value = line.substring(idx + 1);
                this.envVars.setProperty(key, value);
            }
        }
        catch (Exception exception) {}
    }

    public static EnvVarResolver getInstance() {
        if (resolver == null) {
            resolver = new EnvVarResolver();
        }
        return resolver;
    }

    public String getEnvVar(String variable) {
        String result = null;
        result = this.envVars.getProperty(variable);
        return result;
    }

    public String resolveAllVariables(String original, InstallHandlerUtil util) {
        StringBuffer buffer = new StringBuffer();
        if (original != null) {
            boolean variableInProgress = false;
            StringBuffer lastVariable = new StringBuffer();
            int i = 0;
            while (i < original.length()) {
                if (original.charAt(i) == '%') {
                    if (variableInProgress) {
                        String parsed = resolver.getEnvVar(lastVariable.toString().toUpperCase());
                        if (parsed != null) {
                            buffer.append(parsed);
                        } else {
                            if (lastVariable.toString().toUpperCase().equals("WORKSPACE")) {
                                parsed = EnvVarResolver.getWorkspaceLocation(util);
                            }
                            if (parsed != null) {
                                buffer.append(parsed);
                            } else {
                                buffer.append(String.valueOf('%') + lastVariable.toString() + '%');
                            }
                        }
                        variableInProgress = false;
                        lastVariable = new StringBuffer();
                    } else {
                        variableInProgress = true;
                        lastVariable = new StringBuffer();
                    }
                } else if (variableInProgress) {
                    lastVariable.append(original.charAt(i));
                } else {
                    buffer.append(original.charAt(i));
                }
                ++i;
            }
        } else {
            util.log("Variable resolution failed.", "Can't resolve variables in null String.");
        }
        return buffer.toString();
    }

    public static String getWorkspaceLocation(InstallHandlerUtil util) {
        IPath workspaceLocation = null;
        String location = null;
        try {
            Class<?> resourcesPlugin = Platform.getPlugin((String)"org.eclipse.core.resources").getDescriptor().getPluginClassLoader().loadClass("org.eclipse.core.resources.ResourcesPlugin");
            Object workspace = resourcesPlugin.getMethod("getWorkspace", null).invoke(null, null);
            workspace = workspace.getClass().getMethod("getRoot", null).invoke(workspace, null);
            workspace = workspace.getClass().getMethod("getLocation", null).invoke(workspace, null);
            workspaceLocation = (IPath)workspace;
        }
        catch (Exception e) {
            util.log("Failed getting workspace.", "Exception occured retrieving workspace location: ", e);
        }
        if (workspaceLocation != null) {
            location = workspaceLocation.toOSString();
        }
        return location;
    }
}

