/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import jclass.bwt.HeaderButton;
import jclass.bwt.HeaderConverter;
import jclass.bwt.HeaderLabel;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCButton;
import jclass.bwt.JCComponent;
import jclass.bwt.JCContainer;
import jclass.bwt.JCLabel;
import jclass.bwt.JCMultiColumnData;
import jclass.bwt.JCMultiColumnInterface;
import jclass.bwt.JCScrollableInterface;
import jclass.bwt.Viewport;
import jclass.util.JCVector;

public class JCHeader
extends JCContainer
implements JCMultiColumnInterface {
    protected JCMultiColumnData data = new JCMultiColumnData(this);
    protected JCMultiColumnInterface comp;
    protected int resize_col = -999;
    protected boolean resizing = false;
    boolean num_columns_set = false;
    boolean update_parent = true;
    boolean batched = false;
    protected JCVector actionListeners = new JCVector(0);
    private static final String base = "header";
    private static int nameCounter;
    private static int x_save;

    public JCHeader() {
        this(null, null, null);
    }

    public JCHeader(String[] stringArray) {
        this(stringArray, null, null);
    }

    public JCHeader(JCVector jCVector) {
        this(null, null, null);
        if (jCVector != null) {
            this.setLabels(jCVector);
        }
    }

    public JCHeader(String[] stringArray, Applet applet, String string) {
        super(applet, string);
        if (string == null) {
            this.setName(base + nameCounter++);
        }
        this.setLayout(null);
        if (this.getClass().getName().equals("jclass.bwt.JCHeader")) {
            this.getParameters(applet);
        }
        if (stringArray != null) {
            this.setLabels(new JCVector(stringArray));
        }
    }

    protected void getParameters() {
        super.getParameters();
        HeaderConverter.getParams(this);
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.getPeer() == null) {
            return;
        }
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            ((JCLabel)componentArray[n]).setFontInternal(font);
            ++n;
        }
        this.data.calcColumnWidths();
        this.resize(this.preferredSize().width, this.size().height);
        this.layout();
        this.repaint();
    }

    public JCMultiColumnInterface getMultiColumnComponent() {
        return this.comp;
    }

    public void setMultiColumnComponent(JCMultiColumnInterface jCMultiColumnInterface) {
        if (this.comp == jCMultiColumnInterface) {
            return;
        }
        this.comp = jCMultiColumnInterface;
        if (jCMultiColumnInterface instanceof JCComponent) {
            this.insets = new Insets(0, ((JCComponent)((Object)jCMultiColumnInterface)).getInsets().left, 0, ((JCComponent)((Object)jCMultiColumnInterface)).getInsets().right);
        }
        int[] nArray = jCMultiColumnInterface.getColumnWidths();
        int n = 0;
        while (n < jCMultiColumnInterface.getNumColumns()) {
            this.data.setColumnAlignment(n, jCMultiColumnInterface.getColumnAlignment(n));
            this.data.setColumnRightMargin(n, jCMultiColumnInterface.getColumnRightMargin(n));
            this.data.setColumnLeftMargin(n, jCMultiColumnInterface.getColumnLeftMargin(n));
            if (n < nArray.length) {
                this.data.setColumnWidth(n, nArray[n]);
            }
            ++n;
        }
        this.layout();
        this.repaint();
    }

    public JCComponent[] getLabels() {
        Component[] componentArray = this.getComponents();
        JCComponent[] jCComponentArray = new JCComponent[componentArray.length];
        int n = 0;
        while (n < componentArray.length) {
            jCComponentArray[n] = (JCComponent)componentArray[n];
            ++n;
        }
        return jCComponentArray;
    }

    public void setColumnLabels(JCVector jCVector) {
        this.setLabels(jCVector);
    }

    public void setLabels(JCVector jCVector) {
        this.removeAll();
        if (!this.num_columns_set) {
            this.data.setNumColumns(0);
        }
        this.update_parent = false;
        int n = 0;
        while (jCVector != null && n < jCVector.size()) {
            this.addLabel(jCVector.elementAt(n));
            ++n;
        }
        this.update_parent = true;
        this.recalc();
        this.updateParent();
    }

    public void setColumnButtons(JCVector jCVector) {
        this.setButtons(jCVector);
    }

    public void setButtons(JCVector jCVector) {
        this.removeAll();
        if (!this.num_columns_set) {
            this.data.setNumColumns(0);
        }
        this.update_parent = false;
        int n = 0;
        while (jCVector != null && n < jCVector.size()) {
            this.addButton(jCVector.elementAt(n));
            ++n;
        }
        this.update_parent = true;
        this.recalc();
        this.updateParent();
    }

    public JCLabel addLabel(Object object) {
        HeaderLabel headerLabel = new HeaderLabel(this, object);
        if (!this.num_columns_set) {
            this.data.setNumColumns(this.getNumColumns() + 1);
        }
        this.add(headerLabel);
        this.updateParent();
        return headerLabel;
    }

    public JCButton addButton(Object object) {
        HeaderButton headerButton = new HeaderButton(this, object);
        int n = 0;
        while (n < this.actionListeners.size()) {
            headerButton.addActionListener((JCActionListener)this.actionListeners.elementAt(n));
            ++n;
        }
        if (!this.num_columns_set) {
            this.data.setNumColumns(this.getNumColumns() + 1);
        }
        this.add(headerButton);
        this.updateParent();
        return headerButton;
    }

    public void updateParent() {
        if (this.update_parent && this.getPeer() != null) {
            this.data.calcColumnWidths();
            this.invalidate();
            Container container = this.getParent();
            if (container instanceof Viewport) {
                container = container.getParent();
            }
            container.invalidate();
            container.validate();
        }
    }

    public void addNotify() {
        super.addNotify();
        this.data.calcColumnWidths();
    }

    public void layout() {
        int n;
        int n2 = 0;
        Component[] componentArray = this;
        synchronized (componentArray) {
            n2 = this.getNumColumns();
            if (n2 == 0 && this.comp != null && !this.num_columns_set) {
                n = this.num_columns_set;
                this.num_columns_set = true;
                n2 = this.comp.getNumColumns();
                this.setNumColumns(n2);
                this.num_columns_set = n;
            }
        }
        componentArray = this.getComponents();
        int n3 = 0;
        n = super.firstColumnOffset();
        int n4 = 0;
        while (n4 < componentArray.length) {
            JCLabel jCLabel = (JCLabel)componentArray[n4];
            if (n4 >= n2) {
                jCLabel.hide();
            } else {
                jCLabel.insets.left = this.getColumnLeftMargin(n4) - jCLabel.shadow;
                jCLabel.insets.right = this.getColumnRightMargin(n4) - jCLabel.shadow;
                int n5 = this.getColumnWidth(n4);
                if (n4 == 0) {
                    jCLabel.insets.left += n;
                    n5 += n;
                }
                jCLabel.alignment = this.getColumnAlignment(n4);
                jCLabel.reshape(n3, 0, n5 + jCLabel.shadow, this.size().height);
                jCLabel.show();
                n3 += n5;
            }
            ++n4;
        }
    }

    public void recalc() {
        this.data.calcColumnWidths();
        this.resize(this.preferredWidth(), this.size().height);
        this.layout();
        this.repaint();
    }

    protected int preferredHeight() {
        int n = 0;
        Component[] componentArray = this.getComponents();
        int n2 = 0;
        while (n2 < componentArray.length) {
            n = Math.max(n, componentArray[n2].preferredSize().height);
            ++n2;
        }
        return n + this.insets().top + this.insets().bottom;
    }

    private int firstColumnOffset() {
        int n;
        int n2 = n = this.comp != null ? this.comp.getColumnPosition(0) : 0;
        if (this.comp instanceof JCScrollableInterface) {
            n += ((JCScrollableInterface)((Object)this.comp)).getHorizOrigin();
        }
        return n;
    }

    protected int preferredWidth() {
        JCComponent jCComponent = (JCComponent)((Object)this.comp);
        return this.data.preferredWidth() + this.firstColumnOffset() + 2 + (2 * jCComponent.shadow + jCComponent.highlight) + jCComponent.insets().left + jCComponent.insets().right;
    }

    public void addActionListener(JCActionListener jCActionListener) {
        this.actionListeners.add(jCActionListener);
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof JCButton) {
                ((JCButton)componentArray[n]).addActionListener(jCActionListener);
            }
            ++n;
        }
    }

    public void removeActionListener(JCActionListener jCActionListener) {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof JCButton) {
                ((JCButton)componentArray[n]).removeActionListener(jCActionListener);
            }
            ++n;
        }
        this.actionListeners.removeElement(jCActionListener);
    }

    protected boolean mouseMove(Event event) {
        if (this.resizing) {
            return true;
        }
        JCComponent jCComponent = (JCComponent)event.target;
        this.resize_col = this.getComponent(jCComponent);
        if (event.x > jCComponent.size().width - 5) {
            jCComponent.setCursor(10);
            return true;
        }
        if (event.x < 5) {
            --this.resize_col;
            while (this.getColumnWidth(this.resize_col) == 0 && this.resize_col >= 0) {
                --this.resize_col;
            }
            if (this.resize_col >= 0) {
                jCComponent.setCursor(10);
                return true;
            }
        }
        return this.mouseExit(event);
    }

    protected boolean mouseExit(Event event) {
        if (this.resizing) {
            return true;
        }
        this.resize_col = -999;
        this.setCursor(0);
        return true;
    }

    protected boolean mouseDown(Event event) {
        if (this.resize_col == -999) {
            return false;
        }
        this.resizing = true;
        JCComponent jCComponent = (JCComponent)event.target;
        this.drawLine(false, event.x + jCComponent.location().x);
        return true;
    }

    protected boolean mouseDrag(Event event) {
        if (!this.resizing) {
            return false;
        }
        Component component = (Component)event.target;
        int n = event.x + component.location().x;
        if (n - this.getColumnPosition(this.resize_col) - this.getColumnLeftMargin(this.resize_col) < 20) {
            return false;
        }
        this.drawLine(true, 0);
        this.drawLine(false, n);
        return true;
    }

    protected boolean mouseUp(Event event) {
        if (!this.resizing) {
            return false;
        }
        Component component = (Component)event.target;
        this.drawLine(true, 0);
        int n = event.x + component.location().x;
        int n2 = Math.max(10, this.getColumnWidth(this.resize_col) + n - this.getColumnPosition(this.resize_col + 1));
        if (this.comp != null) {
            this.comp.setColumnWidth(this.resize_col, n2);
        } else {
            this.setColumnWidth(this.resize_col, n2);
        }
        this.resize_col = -999;
        this.resizing = false;
        this.setCursor(0);
        return true;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        if (this.resizing) {
            return false;
        }
        this.resize_col = -999;
        this.resizing = false;
        this.setCursor(0);
        return true;
    }

    protected void drawLine(boolean bl, int n) {
        if (!bl) {
            x_save = n;
        } else if (x_save == -999) {
            return;
        }
        n = x_save;
        Component component = this.locate(n, 0);
        if (component == null) {
            return;
        }
        Graphics graphics = component.getGraphics();
        graphics.translate(-component.location().x, 0);
        graphics.setXORMode(this.getBackground());
        graphics.drawLine(n, 0, n, this.size().height);
        graphics.dispose();
    }

    public int calcWidth(int n) {
        int n2;
        int[] nArray;
        Component[] componentArray = this.getComponents();
        if (n >= componentArray.length) {
            return 0;
        }
        JCLabel jCLabel = (JCLabel)componentArray[n];
        int n3 = 0;
        int[] nArray2 = nArray = this.comp != null ? this.comp.getColumnWidths() : new int[]{};
        if (this.comp != null) {
            n2 = this.getColumnLeftMargin(n) + this.getColumnRightMargin(n);
            n3 = this.comp.getColumnWidth(n);
            if (n < nArray.length && nArray[n] != -998) {
                if (n3 - n2 > 0) {
                    return n3;
                }
                n3 = 0;
            }
        }
        jCLabel.insets.left = this.getColumnLeftMargin(n);
        jCLabel.insets.right = this.getColumnRightMargin(n);
        n2 = jCLabel.preferredSize().width - jCLabel.shadow;
        if (n2 > n3 && n < nArray.length && nArray[n] == -998 && this.comp.getMultiColumnData() != null) {
            this.comp.getMultiColumnData().setColumnWidthInternal(n, n2);
        }
        return Math.max(n3, n2);
    }

    public int[] getColumnWidths() {
        return this.data.getColumnWidths();
    }

    public void setColumnWidths(int[] nArray) {
        this.data.setColumnWidths(nArray);
        this.layout();
        this.resize(this.preferredWidth(), this.size().height);
        this.repaint();
    }

    public int getColumnWidth(int n) {
        int n2 = this.data.getColumnWidth(n);
        if ((n == 0 || n == this.data.getNumColumns() - 1) && this.comp != null && this.comp instanceof JCComponent) {
            JCComponent jCComponent = (JCComponent)((Object)this.comp);
            n2 += jCComponent.shadow + jCComponent.highlight;
            n2 = n == 0 ? (n2 += jCComponent.insets().left) : (n2 += jCComponent.insets().right);
        }
        return n2;
    }

    public void setColumnWidth(int n, int n2) {
        int n3 = n2 - this.getColumnWidth(n);
        this.data.setColumnWidth(n, n2);
        if (this.getParent() == null) {
            return;
        }
        int n4 = this.getParent() instanceof Viewport ? Math.max(this.size().width + n3, this.getParent().size().width) : this.preferredWidth();
        this.resize(n4, this.size().height);
        this.updateParent();
        this.repaint();
    }

    public int getNumColumns() {
        return this.data.num_columns;
    }

    public void setNumColumns(int n) {
        this.data.setNumColumns(n != -998 ? n : this.countComponents());
        this.num_columns_set = n != -998;
        this.data.calcColumnWidths();
        if (!this.batched) {
            this.resize(this.preferredWidth(), this.size().height);
            this.updateParent();
        }
    }

    public int[] getColumnAlignments() {
        return this.data.getColumnAlignments();
    }

    public int getColumnAlignment(int n) {
        return this.data.getColumnAlignment(n);
    }

    public void setColumnAlignment(int n, int n2) {
        this.data.setColumnAlignment(n, n2);
        if (n < this.countComponents()) {
            ((JCLabel)this.getComponent(n)).setAlignment(n2);
        }
        this.repaint();
    }

    public void setColumnAlignments(int[] nArray) {
        this.data.setColumnAlignments(nArray);
        this.layout();
        this.repaint();
    }

    public int getColumnPosition(int n) {
        return this.data.getColumnPosition(n) + this.insets().left;
    }

    public int getColumnLeftMargin(int n) {
        return this.data.getColumnLeftMargin(n);
    }

    public void setColumnLeftMargin(int n, int n2) {
        int n3 = this.getColumnLeftMargin(n);
        this.data.setColumnLeftMargin(n, n2);
        if (this.getParent() == null || n >= this.getNumColumns()) {
            return;
        }
        this.resize(this.size().width + n2 - n3, this.size().height);
        this.updateParent();
    }

    public int getColumnRightMargin(int n) {
        return this.data.getColumnRightMargin(n);
    }

    public void setColumnRightMargin(int n, int n2) {
        int n3 = this.getColumnRightMargin(n);
        this.data.setColumnRightMargin(n, n2);
        if (this.getParent() == null || n >= this.getNumColumns()) {
            return;
        }
        this.resize(this.size().width + n2 - n3, this.size().height);
        this.updateParent();
    }

    public JCMultiColumnData getMultiColumnData() {
        return this.data;
    }

    public final void setLayout(LayoutManager layoutManager) {
    }

    static {
        x_save = -999;
    }
}

