/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;
import jclass.bwt.BWTUtil;
import jclass.bwt.JCComponent;
import jclass.bwt.JCMultiColumnInterface;
import jclass.bwt.JCSerializable;

public class JCMultiColumnData
implements JCSerializable {
    protected JCMultiColumnInterface multi;
    protected JCComponent comp;
    public int[] column_widths = new int[0];
    public int[] column_widths_ext = new int[0];
    public int num_columns = 1;
    public int[] alignments = new int[0];
    public int[] left_margins = new int[0];
    public int[] right_margins = new int[0];
    Rectangle rect = new Rectangle();

    public JCMultiColumnData() {
    }

    public JCMultiColumnData(JCMultiColumnInterface jCMultiColumnInterface) {
        this.multi = jCMultiColumnInterface;
        if (jCMultiColumnInterface instanceof JCComponent) {
            this.comp = (JCComponent)((Object)jCMultiColumnInterface);
        }
    }

    protected void adjustDrawingRect(int n, Rectangle rectangle, Rectangle rectangle2) {
        int n2 = this.multi.getColumnLeftMargin(n);
        rectangle2.x = this.multi.getColumnPosition(n) + n2;
        rectangle2.width -= n2 + this.multi.getColumnRightMargin(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void draw(Graphics graphics, Object object, Rectangle rectangle) {
        if (rectangle == null) {
            if (this.comp != null) {
                this.rect = this.comp.getDrawingArea();
            } else {
                if (!(this.multi instanceof Component)) return;
                this.rect = ((Component)((Object)this.multi)).bounds();
            }
        } else {
            this.rect.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        Color color = null;
        if (this.comp != null && !this.comp.isEnabled()) {
            color = graphics.getColor();
            graphics.setColor(Color.lightGray.darker().darker());
        }
        if (!(object instanceof Vector) || BWTUtil.is_jcstring(object)) {
            if (this.comp == null) {
                return;
            }
            BWTUtil.draw(this.comp, graphics, object, this.multi.getColumnAlignment(0), rectangle);
            if (this.comp.isEnabled()) return;
            graphics.setColor(color);
            return;
        }
        Rectangle rectangle2 = null;
        if (this.comp instanceof JCComponent) {
            rectangle2 = this.comp.getPaintRect();
        }
        if (rectangle2 == null) {
            rectangle2 = graphics.getClipRect();
        }
        int n = 0;
        while (n < ((Vector)object).size()) {
            if (n >= this.num_columns) return;
            this.rect.width = this.multi.getColumnWidth(n);
            if (this.rect.width < 0) return;
            this.adjustDrawingRect(n, rectangle, this.rect);
            if (rectangle2.intersects(this.rect)) {
                Graphics graphics2 = graphics.create();
                graphics2.clipRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
                BWTUtil.draw((Component)((Object)this.multi), graphics2, ((Vector)object).elementAt(n), this.multi.getColumnAlignment(n), this.rect);
                graphics2.dispose();
            }
            ++n;
        }
    }

    public int preferredWidth() {
        int n = this.getColumnPosition(this.getNumColumns());
        if (this.comp != null) {
            n += 2 * this.comp.shadow + 2 * this.comp.highlight + this.comp.insets().left + this.comp.insets().right;
        }
        return n;
    }

    public void calcColumnWidths() {
        if (((Component)((Object)this.multi)).getPeer() == null) {
            return;
        }
        this.column_widths_ext = BWTUtil.copyList(this.column_widths_ext, this.num_columns, -998);
        this.column_widths = BWTUtil.copyList(this.column_widths, this.num_columns, -998);
        System.arraycopy(this.column_widths_ext, 0, this.column_widths, 0, this.num_columns);
        int n = 0;
        while (n < this.num_columns) {
            if (this.column_widths_ext[n] == -998) {
                this.column_widths[n] = this.multi.calcWidth(n);
            }
            ++n;
        }
    }

    public int[] getColumnWidths() {
        return this.column_widths_ext;
    }

    public void setColumnWidths(int[] nArray) {
        this.column_widths_ext = nArray != null ? nArray : new int[]{};
        this.calcColumnWidths();
    }

    public int getColumnWidth(int n) {
        if (n >= 0 && n < this.column_widths.length) {
            return this.column_widths[n];
        }
        return 0;
    }

    public void setColumnWidth(int n, int n2) {
        this.column_widths = BWTUtil.copyList(this.column_widths, n + 1, -998);
        this.column_widths_ext = BWTUtil.copyList(this.column_widths_ext, n + 1, -998);
        this.column_widths_ext[n] = this.column_widths[n] = n2;
        if (n2 == -998) {
            this.column_widths[n] = this.multi.calcWidth(n);
        }
    }

    void setColumnWidthInternal(int n, int n2) {
        this.column_widths = BWTUtil.copyList(this.column_widths, n + 1, -998);
        this.column_widths_ext = BWTUtil.copyList(this.column_widths_ext, n + 1, -998);
        this.column_widths[n] = n2;
        if (n2 == -998) {
            this.column_widths[n] = this.multi.calcWidth(n);
        }
    }

    public int getNumColumns() {
        return this.num_columns;
    }

    public void setNumColumns(int n) {
        this.num_columns = n;
    }

    public int getColumnAlignment(int n) {
        if (n < this.alignments.length) {
            return this.alignments[n];
        }
        return 3;
    }

    public int[] getColumnAlignments() {
        this.alignments = BWTUtil.copyList(this.alignments, this.num_columns, 3);
        return this.alignments;
    }

    public void setColumnAlignment(int n, int n2) {
        this.alignments = BWTUtil.copyList(this.alignments, n + 1, 3);
        this.alignments[n] = n2;
    }

    public void setColumnAlignments(int[] nArray) {
        this.alignments = nArray != null ? nArray : new int[]{};
    }

    public int getColumnPosition(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.column_widths.length && n3 < n) {
            n2 += this.column_widths[n3];
            ++n3;
        }
        return n2;
    }

    public int getColumnLeftMargin(int n) {
        if (n < this.left_margins.length) {
            return this.left_margins[n];
        }
        return 5;
    }

    public void setColumnLeftMargin(int n, int n2) {
        this.left_margins = BWTUtil.copyList(this.left_margins, n + 1, 5);
        this.left_margins[n] = n2;
    }

    public int getColumnRightMargin(int n) {
        if (n < this.right_margins.length) {
            return this.right_margins[n];
        }
        return 5;
    }

    public void setColumnRightMargin(int n, int n2) {
        this.right_margins = BWTUtil.copyList(this.right_margins, n + 1, 5);
        this.right_margins[n] = n2;
    }
}

