/*
 * (c) Copyright 1997, KL GROUP INC.  
 * ALL RIGHTS RESERVED 
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of KL Group not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * KL Group.
 *
 * KL GROUP MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL KL GROUP OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES 
 * RELATING TO THE USE OF THIS SOFTWARE.
 */
// RCSID -- $RCSfile: labels.java $ $Revision: 2.1 $ $Date: 1997/10/10 18:02:42 $ $Locker: $  KL Group Inc.

package jclass.bwt.examples;
import jclass.bwt.BWTEnum;
import jclass.bwt.JCLabel;
import jclass.util.JCString;
import jclass.util.JCImageCreator;
import jclass.util.JCUtilConverter;
import jclass.contrib.ContribFrame;
import java.awt.*;
import java.applet.Applet;

/**
 * This example demonstrates various types of JCLabels.
 * Using JCStrings, you can easily create complex and attractive labels.
 */
public class labels extends Applet {

static final String[] arrow_pixels = {
	"  rrrrr  ",
	"  rrrrr  ",
	"  rrrrr  ",
	"  rrrrr  ",
	"  rrrrr  ",
	"  rrrrr  ",
	"rrrrrrrrr",
	" rrrrrrr ",
	"  rrrrr  ",
	"   rrr   ",
	"    r    ",
};

Applet applet;

public labels() {}
public labels(Applet applet) { this.applet = applet; }

public void init() {
	if (applet == null) applet = this;
	setBackground(Color.lightGray);

	JCLabel label = new JCLabel("Simple label");
	label.setBackground(Color.red);
	label.setForeground(Color.yellow);
	add(label);

	label = new JCLabel("Multi-line\nLabel");
	label.setBackground(Color.lightGray);
	label.setFont(new Font("TimesRoman", Font.BOLD, 14));
	label.setPreferredSize(80, 50);
	add(label);

	label = new JCLabel(null, "../images/smile32.gif", applet,
						BWTEnum.STRING_RIGHT);
	label.setBackground(Color.lightGray);
	add(label);

	label = new JCLabel("Image", "../images/smile32.gif", 
						applet, BWTEnum.STRING_BOTTOM);
	label.setBackground(Color.cyan);
	label.setFont(new Font("Courier", Font.ITALIC, 14));
	add(label);

	JCImageCreator im = 
		new JCImageCreator(this, arrow_pixels[0].length(), arrow_pixels.length);
	im.setColor('r', Color.red);
	Image arrow = im.create(arrow_pixels);
	label = new JCLabel("Aligned\nBottom-Right", arrow, BWTEnum.STRING_TOP);
	label.setBackground(Color.yellow);
	label.setForeground(Color.blue);
	label.setFont(new Font("Helvetica", Font.PLAIN, 14));
	label.setAlignment(BWTEnum.BOTTOMRIGHT);
	label.setPreferredSize(100, 80);
	add(label);

	label = new JCLabel();
	label.setBackground(Color.white);
	JCString s = JCString.parse(applet, "Mix images [IMG=../images/cut16.gif], [COLOR=red]colors,\n[RESET][font=TimesRoman-ITALIC-20]fonts,[DEFAULT_FONT]\n[ST]Mistakes[/ST],\n even URLs: [COLOR=blue][href=http://www.klg.com/jclass/index.html]KL's JClass page[/href]");
	label.setLabel(s);
	add(label);
}

public static void main(String args[]) {
	ContribFrame frame = new ContribFrame("Labels");
	labels s = new labels();

	s.init();
	frame.add(s);
	frame.pack();
	frame.show();
}
}
