/*
 * (c) Copyright 1997, KL GROUP INC.  
 * ALL RIGHTS RESERVED 
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of KL Group not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * KL Group.
 *
 * KL GROUP MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL KL GROUP OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES 
 * RELATING TO THE USE OF THIS SOFTWARE.
 */
// RCSID -- $RCSfile: tabManager.java $ $Revision: 2.1 $ $Date: 1997/09/26 19:36:52 $ $Locker: $  KL Group Inc.

package jclass.bwt.examples;
import jclass.bwt.BWTEnum;
import jclass.bwt.JCCheckbox;
import jclass.bwt.JCCheckboxGroup;
import jclass.bwt.JCContainer;
import jclass.bwt.JCGridLayout;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;
import jclass.bwt.JCLabel;
import jclass.bwt.JCTabButton;
import jclass.bwt.JCTabManager;
import jclass.bwt.JCTabManagerEvent;
import jclass.bwt.JCTabManagerListener;
import jclass.contrib.ContribFrame;
import jclass.util.JCString;
import jclass.util.JCUtilConverter;
import java.awt.*;
import java.util.Date;

/**
 * This example creates a JCTabManager which displays some of the other
 * examples.
 */
public class tabManager extends java.applet.Applet 
implements Runnable, JCTabManagerListener, JCItemListener {

JCLabel label = new JCLabel();
JCTabManager tab_manager;
transient Thread updater;

// JCItemListener method
public void itemStateChanged(JCItemEvent ev) {
	JCCheckboxGroup group = 
		(JCCheckboxGroup) ((Component)ev.getSource()).getParent();

	if (group.getTitle().equals("Shape"))
		tab_manager.setTabShape(group.getValue());
	else if (group.getTitle().equals("Side")) 
		tab_manager.setTabSide(group.getValue());
}

/*
 *  JCTabManagerListener methods
 */

// Sets the page when the Date or Vendor tab is clicked
public void tabManagerChangeBegin(JCTabManagerEvent ev) {
	JCTabButton tab = ev.getNextTab();

	if (tab.getName().equals("Date")) {
		label.setLabel(""+new Date());
		start();
		return;
	}

	// Stop date thread if it is running
	stop();
	if (tab.getName().equals("Vendor")) {
		String url = "http://www.klg.com/jclass";
		JCString s = JCString.parse(this, "[COLOR=blue][href=" + url + " TARGET=_blank]" + url);
		label.setLabel(s);
	}
}

public void tabManagerChangeEnd(JCTabManagerEvent ev) {}

public Insets insets() { return new Insets(5,5,5,5); }

static String side_labels[] = { "Top", "Bottom" };
static int side_values[] = { BWTEnum.TOP, BWTEnum.BOTTOM } ;

static String shape_labels[] = { "Rectangular", "Slanted" };
static int shape_values[] = { BWTEnum.RECTANGLE, BWTEnum.SLANTED };

public void init() {
	// Force tab manager to be same size as applet
	setLayout(new GridLayout(1,1));

	tab_manager = new JCTabManager();
	tab_manager.addTabManagerListener(this);
	setBackground(Color.lightGray);

	JCCheckboxGroup sides = JCCheckbox.makeGroup(side_labels, side_values, true);
	sides.setTitle("Side");
	sides.addItemListener(this);
	JCCheckboxGroup shapes = JCCheckbox.makeGroup(shape_labels, shape_values, true);
	shapes.setTitle("Shape");
	shapes.addItemListener(this);

	JCContainer panel = new JCContainer();
	panel.setInsets(new Insets(0, 20, 0, 20));
	panel.setLayout(new JCGridLayout(1, BWTEnum.VARIABLE, 10, 10));
	panel.add(sides);
	panel.add(shapes);
	tab_manager.addPage(makeLabel("Tab Styles", "../images/fonts.gif"), panel);

	labels l = new labels(this);
	l.init();
	tab_manager.addPage(makeLabel("Labels", "../images/hardware.gif"), l);
	l.setBackground(new Color(200,130,130));

	buttons b = new buttons(this);
	b.init();
	tab_manager.addPage(makeLabel("Buttons", "../images/software.gif"), b);
	b.setBackground(jclass.util.JCUtilConverter.toColor("#D0D0D0"));

	/*
	 * Add tabs which share the same page. The page contents will be set
	 * in the listener method when the tab is clicked.
	 */
	label.setFont(new Font("TimesRoman", Font.BOLD, 20));
	label.setBackground(new Color(200,255,255));

	int pos = 
		tab_manager.addPage(makeLabel("JClass Vendor", "../images/account.gif"), label);
	JCTabButton tab = tab_manager.getTab(pos);
	tab.setName("Vendor");

	pos = tab_manager.addPage(makeLabel("Current Date", "../images/office.gif"), label);
	tab = tab_manager.getTab(pos);
	tab.setName("Date");
	tab.setBackground(jclass.util.JCUtilConverter.toColor("#F0F0F0"));

	add(tab_manager);
}

JCString makeLabel(String s, String image) {
	return new JCString(s, JCUtilConverter.toImage(this, image),
						BWTEnum.STRING_RIGHT);
}
 
public void start() {
	super.start();
	if (updater == null) {
		updater = new Thread(this);
		updater.start();
	}
}

public void stop() {
	if (updater != null) {
		updater.yield();
		updater.stop();
	}
	updater = null;
}

/** Writes the current time every second. */
public void run() {
	while (true) {
		try {
			Thread.sleep(1000);
		} catch (Exception e) {}

		if (!Thread.currentThread().isAlive() || updater == null) 
			return;
		label.setLabel(""+new Date());
	}
}

public static void main(String args[]) {
	ContribFrame frame = new ContribFrame("TabManager");
	tabManager s = new tabManager();

	s.init();
	frame.add(s);
	frame.pack();
	frame.show();
}
}
