/*
 * (c) Copyright 1997, KL GROUP INC.  
 * ALL RIGHTS RESERVED 
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of KL Group not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * KL Group.
 *
 * KL GROUP MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL KL GROUP OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES 
 * RELATING TO THE USE OF THIS SOFTWARE.
 */
// RCSID -- $RCSfile: text.java $ $Revision: 2.3 $ $Date: 1997/11/11 16:09:22 $ $Locker: $  KL Group Inc.

package jclass.bwt.examples;
import jclass.bwt.BWTEnum;
import jclass.bwt.BWTUtil;
import jclass.bwt.JCAlignerLayout;
import jclass.bwt.JCLabel;
import jclass.bwt.JCTextArea;
import jclass.bwt.JCTextComponent;
import jclass.bwt.JCTextCursorEvent;
import jclass.bwt.JCTextCursorListener;
import jclass.bwt.JCTextField;
import jclass.bwt.JCTextEvent;
import jclass.bwt.JCTextListener;
import jclass.contrib.ContribFrame;
import java.awt.*;

/**
 * This example demonstrates the use of a JCTextField and JCTextArea.
 */
public class text extends java.applet.Applet 
implements JCTextListener, JCTextCursorListener {

/** Processes cursor movements in the phone field. */
public void textCursorMoveBegin(JCTextCursorEvent ev) {
	JCTextComponent field = (JCTextComponent) ev.getSource();
	if (!field.getName().equals("phone")) return;
	int new_pos = ev.getNewPosition();
	if (new_pos == field.getNumChar())
		return;
	char c = field.getText().charAt(new_pos);

	// Skip over "-"
	if (c == '-') {
		if (new_pos > ev.getCurrentPosition())
			ev.setNewPosition(new_pos+1);
		else
			ev.setNewPosition(new_pos-1);
	}
}
public void textCursorMoveEnd(JCTextCursorEvent ev) {}

/** Processes value changes in the phone field. */
public void textValueChangeBegin(JCTextEvent ev) {
	JCTextComponent field = (JCTextComponent) ev.getSource();
	if (!field.getName().equals("phone")) return;
	boolean allow = true;
	int text_len = ev.getText().length(), start = ev.getStartPosition();

	// Disallow pasting more than 1 char
	if (text_len > 1 || ev.getEndPosition() - start > 1)
		allow = false;

	// Don't allow "-" to be deleted
	else if (field.getText().charAt(start) == '-') {
		if (ev.isDeletion()) {
			ev.setText(" -");
			ev.setStartPosition(start-1);
		}
		else
			ev.setText("-");
	} else if (ev.getText().length() == 0) {
		// Insert blank space if deleting a digit.
		ev.setText(" ");
	}

	// Only allow numerics
	else if (text_len == 1) {
		char c = ev.getText().charAt(0);
		if (c != ' ' && !Character.isDigit(c))
			allow = false;
	}

	ev.setAllowChange(allow);
	if (!allow)
		field.beep();
}

public void textValueChangeEnd(JCTextEvent ev) {}

final static String PHONE = "416-594-1026";

public void init() {
	JCTextField f1, f2, f3, f4;
	setBackground(Color.lightGray);
	setLayout(new JCAlignerLayout(2, 10, 10));

	add(new JCLabel("Name:"));
	add(f1 = new JCTextField("Robert Jones"));

	add(new JCLabel("Password:"));
	add(f2 = new JCTextField("WHO KNOWS?"));
	f2.setEchoChar('*');

	add(new JCLabel("JClass Vendor:"));
	add(f4 = new JCTextField("KL Group Inc."));
	f4.setEditable(false);
	f4.setShowCursorPosition(false);

	add(new JCLabel("Phone:"));
	add(f3 = new JCTextField(PHONE, null, "phone"));
	f3.setOverstrike(true);
	f3.setMaximumLength(PHONE.length());
	f3.addTextListener(this);
	f3.addTextCursorListener(this);

	add(new JCLabel("Comments:"));
	JCTextArea area = new JCTextArea();
	area.setScrollbarDisplay(BWTEnum.DISPLAY_VERTICAL_ONLY);
	add(area);
}

public static void main(String args[]) {
	ContribFrame frame = new ContribFrame("Text");
	text t = new text();

	t.init();
	frame.add(t);
	frame.pack();
	frame.show();
}
}

