/*
 * (c) Copyright 1996, KL GROUP INC.  
 * ALL RIGHTS RESERVED 
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of KL Group not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * KL Group.
 *
 * KL GROUP MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL KL GROUP OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES 
 * RELATING TO THE USE OF THIS SOFTWARE.
 */
//   RCSID -- $RCSfile: ContribCheckbox.java $ $Revision: 2.0 $
//            $Date: 1997/06/09 18:21:34 $  $Locker: $  KL Group Inc.

package jclass.contrib;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Panel;

/**
 * The Checkbox class in the Java AWT does not allow a value to
 * be associated with the checkbox. ContribCheckbox does allow this
 * through the <STRONG>value</STRONG> member variable.
 * ContribCheckbox also contains two functions for building
 * groups of checkboxes:
 * makeGroup() takes an array of labels and an array of values and creates a group
 * of radio buttons with associated values for each button.
 * makeCollection() takes the same parameters and produces an array of individual check boxes.
 * In combination with ContribCheckboxGroup, these functions can simplify the creation of checkboxes.
 * The .class files are also reduced in size.
 */

public class ContribCheckbox extends Checkbox {

/** This is the value associated with the checkbox. */
public int value;

/**
 * This is the constructor. The first two arguments are
 * passed to the Checkbox construcor. If the group argument
 * is an instance of ContribCheckboxGroup, then the checkbox is
 * added to the list of items in ContribCheckboxGroup.  See
 * ContribCheckboxGroup for details.
 * @param label this is the text that appears beside the checkbox
 * @param group this is the "owner" of the box. This can be null.
 * @param val this is the value associated with the checkbox
 */
public ContribCheckbox(String label, CheckboxGroup group, int val) {
    super(label, group, false);
    if (group instanceof ContribCheckboxGroup) 
        ((ContribCheckboxGroup)group).addCheckbox(this);
    value = val;
}

/**
 * This static function creates a group of radio
 * buttons when given an array of labels and an array of values.
 * @param panel this is the AWT panel where the checkbox group resides
 * @param labels[] this is an array of labels for the checkboxes
 * @param values[] this is an array of values for the checkboxes
 * @return         a ContribCheckboxGroup containing the specified check
 *                 boxes.
 */
public static ContribCheckboxGroup
makeGroup(Panel parent, String labels[], int values[]) {
    if (labels == null || values == null || parent == null)
		return null;
    ContribCheckboxGroup rval = new ContribCheckboxGroup();
    for (int i = 0; i < labels.length && i < values.length; i++) 
        parent.add(new ContribCheckbox(labels[i], rval, values[i]));
    return rval;
}

/**
 * This static function creates a grouping of independent
 * checkboxes with associated values for each of the checkboxes
 * @param panel this is the AWT panel where the checkbox group resides
 * @param labels[] this is an array of labels for the checkboxes
 * @param values[] this is an array of values for the checkboxes
 * @return         an array of ContribCheckbox objects
 */
public static ContribCheckbox[]
makeCollection(Panel parent, String labels[], int values[]) {
    if (labels == null || values == null || parent == null)
		return null;

    ContribCheckbox r[] = new ContribCheckbox[labels.length];
    for (int i = 0; i < labels.length && i < values.length; i++) 
        parent.add((r[i] = new ContribCheckbox(labels[i], null, values[i])));
	return r;
}

}

