/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.base;

import com.objectshare.base.draw.OSIBorderPolicy;
import com.objectshare.gf.base.GF2DWorldViewTransform;
import com.objectshare.gf.base.GFLogicalFont;
import com.objectshare.gf.base.geometry.GF2DDimension;
import com.objectshare.gf.base.geometry.GF2DEllipse;
import com.objectshare.gf.base.geometry.GF2DPoint;
import com.objectshare.gf.base.geometry.GF2DPolygon;
import com.objectshare.gf.base.geometry.GF2DRectangle;
import com.objectshare.gf.base.geometry.GF2DVector;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.util.Hashtable;

public class GFGraphics {
    protected Graphics g;
    protected GF2DWorldViewTransform transform;
    protected static Hashtable fontTable = new Hashtable();

    public GFGraphics(Graphics graphics) {
        this(graphics, new GF2DWorldViewTransform());
    }

    public GFGraphics(Graphics graphics, GF2DWorldViewTransform gF2DWorldViewTransform) {
        this.g = graphics;
        this.transform = gF2DWorldViewTransform;
    }

    public GFGraphics create() {
        return new GFGraphics(this.g.create(), this.transform);
    }

    public GFGraphics create(float f, float f2, float f3, float f4) {
        GFGraphics gFGraphics = this.create();
        gFGraphics.translate(f, f2);
        gFGraphics.clipRect(0.0f, 0.0f, f3, f4);
        return gFGraphics;
    }

    public void dispose() {
        this.g.dispose();
    }

    public void finalize() {
        this.dispose();
    }

    public GFGraphics newFor(Graphics graphics) {
        return new GFGraphics(graphics);
    }

    public GFGraphics newFor(GFGraphics gFGraphics) {
        return gFGraphics;
    }

    public Graphics getGraphics() {
        return this.g;
    }

    public GF2DWorldViewTransform getWorldViewTransform() {
        return this.transform;
    }

    public void translate(Point point) {
        this.translate(point.x, point.y);
    }

    public void translate(GF2DPoint gF2DPoint) {
        this.translate(gF2DPoint.x, gF2DPoint.y);
    }

    public void translate(int n, int n2) {
        this.translate((float)n, (float)n2);
    }

    public void translate(float f, float f2) {
        Point point = this.transform.world2View(f, f2);
        this.g.translate(point.x, point.y);
    }

    public GF2DRectangle getClipRect() {
        return this.transform.view2World(this.g.getClipRect());
    }

    public void clipRect(float f, float f2, float f3, float f4) {
        Rectangle rectangle = this.transform.world2View(f, f2, f3, f4);
        this.g.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Color getColor() {
        return this.g.getColor();
    }

    public void setColor(Color color) {
        this.g.setColor(color);
    }

    public void setPaintMode() {
        this.g.setPaintMode();
    }

    public void setXORMode(Color color) {
        this.g.setXORMode(color);
    }

    public static Font transformFont(Font font, GF2DWorldViewTransform gF2DWorldViewTransform) {
        Font font2;
        int n = gF2DWorldViewTransform.world2View((Dimension)new Dimension((int)0, (int)font.getSize())).height;
        n = Math.max(n, 1);
        GFLogicalFont gFLogicalFont = new GFLogicalFont(font.getName(), font.getStyle(), n);
        Object v = fontTable.get(gFLogicalFont);
        if (v == null) {
            font2 = new Font(font.getName(), font.getStyle(), n);
            fontTable.put(gFLogicalFont, font2);
        } else {
            font2 = (Font)v;
        }
        return font2;
    }

    public Font getFont() {
        Font font = this.g.getFont();
        Dimension dimension = this.transform.view2World(new Dimension(0, font.getSize())).toDimension();
        GFLogicalFont gFLogicalFont = new GFLogicalFont(font.getName(), font.getStyle(), dimension.height);
        Object v = fontTable.get(gFLogicalFont);
        if (v == null) {
            Font font2 = new Font(font.getName(), font.getStyle(), dimension.height);
            fontTable.put(gFLogicalFont, font2);
            return font2;
        }
        return (Font)v;
    }

    public void setFont(Font font) {
        Font font2;
        int n = this.transform.world2View((Dimension)new Dimension((int)0, (int)font.getSize())).height;
        n = Math.max(n, 1);
        GFLogicalFont gFLogicalFont = new GFLogicalFont(font.getName(), font.getStyle(), n);
        Object v = fontTable.get(gFLogicalFont);
        if (v == null) {
            font2 = new Font(font.getName(), font.getStyle(), n);
            fontTable.put(gFLogicalFont, font2);
        } else {
            font2 = (Font)v;
        }
        this.g.setFont(font2);
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.g.getFontMetrics(font);
    }

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    public void drawLine(float f, float f2, float f3, float f4) {
        Point point = this.transform.world2View(f, f2);
        Point point2 = this.transform.world2View(f3, f4);
        this.g.drawLine(point.x, point.y, point2.x, point2.y);
    }

    public void drawLine(GF2DPoint gF2DPoint, GF2DPoint gF2DPoint2) {
        this.drawLine(gF2DPoint.x, gF2DPoint.y, gF2DPoint2.x, gF2DPoint2.y);
    }

    public void drawLine(GF2DVector gF2DVector) {
        this.drawLine(gF2DVector.p1, gF2DVector.p2);
    }

    public void drawRect(GF2DRectangle gF2DRectangle) {
        this.drawRect(gF2DRectangle.x, gF2DRectangle.y, gF2DRectangle.width, gF2DRectangle.height);
    }

    public void drawRect(float f, float f2, float f3, float f4) {
        Rectangle rectangle = this.transform.world2View(f, f2, f3, f4);
        this.g.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
    }

    public void drawRect(GF2DRectangle gF2DRectangle, int n) {
        this.drawRect(gF2DRectangle.x, gF2DRectangle.y, gF2DRectangle.width, gF2DRectangle.height, n);
    }

    public void drawRect(float f, float f2, float f3, float f4, int n) {
        Rectangle rectangle = this.transform.world2View(f, f2, f3, f4);
        --rectangle.width;
        --rectangle.height;
        int n2 = 0;
        while (n2 < n && rectangle.width > 0 && rectangle.height > 0) {
            this.g.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            rectangle.grow(-1, -1);
            ++n2;
        }
    }

    public void fillRect(GF2DRectangle gF2DRectangle) {
        this.fillRect(gF2DRectangle.x, gF2DRectangle.y, gF2DRectangle.width, gF2DRectangle.height);
    }

    public void fillRect(float f, float f2, float f3, float f4) {
        Rectangle rectangle = this.transform.world2View(f, f2, f3, f4);
        this.g.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void clearRect(GF2DRectangle gF2DRectangle) {
        this.clearRect(gF2DRectangle.x, gF2DRectangle.y, gF2DRectangle.width, gF2DRectangle.height);
    }

    public void clearRect(float f, float f2, float f3, float f4) {
        Rectangle rectangle = this.transform.world2View(f, f2, f3, f4);
        this.g.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void drawRoundRect(GF2DRectangle gF2DRectangle, GF2DDimension gF2DDimension) {
        Rectangle rectangle = this.transform.world2View(gF2DRectangle);
        Dimension dimension = this.transform.world2View(gF2DDimension);
        this.g.drawRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, dimension.width, dimension.height);
    }

    public void drawRoundRect(float f, float f2, float f3, float f4, int n, int n2) {
        this.drawRoundRect(new GF2DRectangle(f, f2, f3, f4), new GF2DDimension(n, n2));
    }

    public void fillRoundRect(GF2DRectangle gF2DRectangle, GF2DDimension gF2DDimension) {
        Rectangle rectangle = this.transform.world2View(gF2DRectangle);
        Dimension dimension = this.transform.world2View(gF2DDimension);
        this.g.fillRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, dimension.width, dimension.height);
    }

    public void fillRoundRect(float f, float f2, float f3, float f4, float f5, float f6) {
        this.fillRoundRect(new GF2DRectangle(f, f2, f3, f4), new GF2DDimension(f5, f6));
    }

    public void drawBorder(float f, float f2, float f3, float f4, OSIBorderPolicy oSIBorderPolicy) {
        Rectangle rectangle = this.transform.world2View(f, f2, f3, f4);
        oSIBorderPolicy.display(this.g, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void drawOval(GF2DEllipse gF2DEllipse) {
        this.drawOval(gF2DEllipse.getBoundingBox());
    }

    public void drawOval(GF2DRectangle gF2DRectangle) {
        this.drawOval(gF2DRectangle.x, gF2DRectangle.y, gF2DRectangle.width, gF2DRectangle.height);
    }

    public void drawOval(float f, float f2, float f3, float f4) {
        Rectangle rectangle = this.transform.world2View(f, f2, f3, f4);
        this.g.drawOval(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
    }

    public void drawOval(GF2DEllipse gF2DEllipse, int n) {
        this.drawOval(gF2DEllipse.getBoundingBox(), n);
    }

    public void drawOval(GF2DRectangle gF2DRectangle, int n) {
        this.drawOval(gF2DRectangle.x, gF2DRectangle.y, gF2DRectangle.width, gF2DRectangle.height, n);
    }

    public void drawOval(float f, float f2, float f3, float f4, int n) {
        Rectangle rectangle = this.transform.world2View(f, f2, f3, f4);
        --rectangle.width;
        --rectangle.height;
        int n2 = 0;
        while (n2 < n && rectangle.width > 0 && rectangle.height > 0) {
            this.g.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            rectangle.grow(-1, -1);
            ++n2;
        }
    }

    public void fillOval(GF2DEllipse gF2DEllipse) {
        this.fillOval(gF2DEllipse.getBoundingBox());
    }

    public void fillOval(GF2DRectangle gF2DRectangle) {
        this.fillOval(gF2DRectangle.x, gF2DRectangle.y, gF2DRectangle.width, gF2DRectangle.height);
    }

    public void fillOval(float f, float f2, float f3, float f4) {
        Rectangle rectangle = this.transform.world2View(f, f2, f3, f4);
        this.g.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void drawArc(GF2DRectangle gF2DRectangle, float f, float f2) {
        this.drawArc(gF2DRectangle.x, gF2DRectangle.y, gF2DRectangle.width, gF2DRectangle.height, f, f2);
    }

    public void drawArc(GF2DEllipse gF2DEllipse, float f, float f2) {
        this.drawArc(gF2DEllipse.getBoundingBox(), f, f2);
    }

    public void drawArc(float f, float f2, float f3, float f4, float f5, float f6) {
        Rectangle rectangle = this.transform.world2View(f, f2, f3, f4);
        this.g.drawArc(rectangle.x, rectangle.y, rectangle.width, rectangle.height, Math.round(f5), Math.round(f6));
    }

    public void fillArc(GF2DRectangle gF2DRectangle, float f, float f2) {
        this.fillArc(gF2DRectangle.x, gF2DRectangle.y, gF2DRectangle.width, gF2DRectangle.height, f, f2);
    }

    public void fillArc(GF2DEllipse gF2DEllipse, float f, float f2) {
        this.fillArc(gF2DEllipse.getBoundingBox(), f, f2);
    }

    public void fillArc(float f, float f2, float f3, float f4, float f5, float f6) {
        Rectangle rectangle = this.transform.world2View(f, f2, f3, f4);
        this.g.fillArc(rectangle.x, rectangle.y, rectangle.width, rectangle.height, Math.round(f5), Math.round(f6));
    }

    public void drawPolygon(GF2DPoint[] gF2DPointArray) {
        this.drawPolygon(gF2DPointArray, gF2DPointArray.length);
    }

    public void drawPolygon(GF2DPoint[] gF2DPointArray, int n) {
        boolean bl = n >= 3 && gF2DPointArray[0].equals(gF2DPointArray[n - 1]);
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            Point point = this.transform.world2View(gF2DPointArray[n2]);
            nArray[n2] = point.x;
            nArray2[n2] = point.y;
            ++n2;
        }
        if (bl) {
            this.g.drawPolygon(nArray, nArray2, n);
            return;
        }
        int n3 = 0;
        while (n3 < n - 1) {
            this.g.drawLine(nArray[n3], nArray2[n3], nArray[n3 + 1], nArray2[n3 + 1]);
            ++n3;
        }
    }

    public void drawPolygon(GF2DPolygon gF2DPolygon) {
        this.drawPolygon(gF2DPolygon.points);
    }

    public void fillPolygon(GF2DPoint[] gF2DPointArray) {
        this.fillPolygon(gF2DPointArray, gF2DPointArray.length);
    }

    public void fillPolygon(GF2DPoint[] gF2DPointArray, int n) {
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            Point point = this.transform.world2View(gF2DPointArray[n2]);
            nArray[n2] = point.x;
            nArray2[n2] = point.y;
            ++n2;
        }
        this.g.fillPolygon(nArray, nArray2, n);
    }

    public void fillPolygon(GF2DPolygon gF2DPolygon) {
        this.fillPolygon(gF2DPolygon.points);
    }

    public void drawString(String string, int n, int n2) {
        this.drawString(string, (float)n, (float)n2);
    }

    public void drawString(String string, float f, float f2) {
        Point point = this.transform.world2View(f, f2);
        this.g.drawString(string, point.x, point.y);
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.copyArea((float)n, (float)n2, (float)n3, (float)n4, (float)n5, (float)n6);
    }

    public void copyArea(float f, float f2, float f3, float f4, float f5, float f6) {
        Rectangle rectangle = this.transform.world2View(f, f2, f3, f4);
        Dimension dimension = this.transform.world2View(new GF2DDimension(f5, f6));
        this.g.copyArea(rectangle.x, rectangle.y, rectangle.width, rectangle.height, dimension.width, dimension.height);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.drawImage(image, (float)n, (float)n2, imageObserver);
    }

    public boolean drawImage(Image image, float f, float f2, ImageObserver imageObserver) {
        Point point = this.transform.world2View(f, f2);
        return this.g.drawImage(image, point.x, point.y, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.drawImage(image, (float)n, (float)n2, (float)n3, (float)n4, imageObserver);
    }

    public boolean drawImage(Image image, float f, float f2, float f3, float f4, ImageObserver imageObserver) {
        Rectangle rectangle = this.transform.world2View(f, f2, f3, f4);
        return this.g.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.drawImage(image, (float)n, (float)n2, color, imageObserver);
    }

    public boolean drawImage(Image image, float f, float f2, Color color, ImageObserver imageObserver) {
        Point point = this.transform.world2View(f, f2);
        return this.g.drawImage(image, point.x, point.y, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        return this.drawImage(image, (float)n, (float)n2, (float)n3, (float)n4, color, imageObserver);
    }

    public boolean drawImage(Image image, float f, float f2, float f3, float f4, Color color, ImageObserver imageObserver) {
        Rectangle rectangle = this.transform.world2View(f, f2, f3, f4);
        return this.g.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, color, imageObserver);
    }
}

