/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.base.geometry;

import com.objectshare.gf.base.geometry.GF2DPoint;
import java.awt.Point;
import java.io.Serializable;

public class GF2DMatrix
implements Serializable {
    public float sxr11 = 1.0f;
    public float r12 = 0.0f;
    public float tx = 0.0f;
    public float r21 = 0.0f;
    public float syr22 = 1.0f;
    public float ty = 0.0f;

    public static GF2DMatrix translation(float f, float f2) {
        GF2DMatrix gF2DMatrix = new GF2DMatrix();
        gF2DMatrix.tx = f;
        gF2DMatrix.ty = f2;
        return gF2DMatrix;
    }

    public static GF2DMatrix rotation(float f) {
        GF2DMatrix gF2DMatrix = new GF2DMatrix();
        gF2DMatrix.syr22 = gF2DMatrix.sxr11 = (float)Math.cos(f);
        gF2DMatrix.r21 = (float)Math.sin(f);
        gF2DMatrix.r12 = -gF2DMatrix.r21;
        return gF2DMatrix;
    }

    public static GF2DMatrix scaling(float f, float f2) {
        GF2DMatrix gF2DMatrix = new GF2DMatrix();
        gF2DMatrix.sxr11 = f;
        gF2DMatrix.syr22 = f2;
        return gF2DMatrix;
    }

    public GF2DPoint multiply(float f, float f2) {
        float f3 = this.sxr11 * f + this.r12 * f2 + this.tx;
        float f4 = this.r21 * f + this.syr22 * f2 + this.ty;
        return new GF2DPoint(f3, f4);
    }

    public GF2DPoint multiply(GF2DPoint gF2DPoint) {
        return this.multiply(gF2DPoint.x, gF2DPoint.y);
    }

    public GF2DPoint multiply(Point point) {
        return this.multiply(point.x, point.y);
    }

    public GF2DMatrix multiply(GF2DMatrix gF2DMatrix) {
        GF2DMatrix gF2DMatrix2 = new GF2DMatrix();
        gF2DMatrix2.sxr11 = this.sxr11 * gF2DMatrix.sxr11 + this.r21 * gF2DMatrix.r12;
        gF2DMatrix2.r12 = this.r12 * gF2DMatrix.sxr11 + this.syr22 * gF2DMatrix.r12;
        gF2DMatrix2.tx = this.tx * gF2DMatrix.sxr11 + this.ty * gF2DMatrix.r12 + gF2DMatrix.tx;
        gF2DMatrix2.r21 = this.sxr11 * gF2DMatrix.r21 + this.r21 * gF2DMatrix.syr22;
        gF2DMatrix2.syr22 = this.r12 * gF2DMatrix.r21 + this.syr22 * gF2DMatrix.syr22;
        gF2DMatrix2.ty = this.tx * gF2DMatrix.r21 + this.ty * gF2DMatrix.syr22 + gF2DMatrix.ty;
        return gF2DMatrix2;
    }

    public boolean isUnity() {
        return this.sxr11 == 1.0f && this.r12 == 0.0f && this.tx == 0.0f && this.r21 == 0.0f && this.syr22 == 1.0f && this.ty == 0.0f;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[[" + this.sxr11 + "," + this.r12 + "," + this.tx + "]" + "[" + this.r21 + "," + this.syr22 + "," + this.ty + "]" + "[0,0,1]]";
    }
}

