/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.connect;

import com.objectshare.base.event.OSIEventMulticaster;
import com.objectshare.gf.base.GFGO;
import com.objectshare.gf.base.geometry.GF2DPoint;
import com.objectshare.gf.connect.event.GFLocatorChangedListener;
import com.objectshare.gf.connect.event.GFLocatorEvent;
import com.objectshare.gf.connect.event.GFLocatorEventMulticaster;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;

public abstract class GFLocator
implements Serializable {
    protected transient GFLocatorChangedListener changedListener;
    protected boolean isListeningToTarget = false;
    protected static final String changedListenerK = "changedL";

    public abstract GFLocator copyForTarget(GFGO var1);

    protected GFLocator copyForTargetInto(GFLocator gFLocator) {
        return gFLocator;
    }

    public abstract GF2DPoint toPoint();

    public abstract GFGO getTarget();

    public int hashCode() {
        return this.getTarget().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.getTarget() == ((GFLocator)object).getTarget();
    }

    public void addChangedListener(GFLocatorChangedListener gFLocatorChangedListener) {
        this.changedListener = GFLocatorEventMulticaster.add(this.changedListener, gFLocatorChangedListener);
        if (this.changedListener != null && !this.isListeningToTarget) {
            this.listenToTarget();
            this.isListeningToTarget = true;
        }
    }

    public void removeChangedListener(GFLocatorChangedListener gFLocatorChangedListener) {
        this.changedListener = GFLocatorEventMulticaster.remove(this.changedListener, gFLocatorChangedListener);
        if (this.changedListener == null && this.isListeningToTarget) {
            this.unlistenToTarget();
            this.isListeningToTarget = false;
        }
    }

    protected void triggerChangedEvent() {
        GFLocatorChangedListener gFLocatorChangedListener = this.changedListener;
        if (gFLocatorChangedListener != null) {
            gFLocatorChangedListener.locatorChanged(new GFLocatorEvent(this));
        }
    }

    protected abstract void listenToTarget();

    protected abstract void unlistenToTarget();

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        this.writeEventListeners(objectOutputStream);
        objectOutputStream.writeObject(null);
    }

    protected void writeEventListeners(ObjectOutputStream objectOutputStream) throws IOException {
        OSIEventMulticaster.save((ObjectOutputStream)objectOutputStream, (String)changedListenerK, (EventListener)this.changedListener);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        while ((object = objectInputStream.readObject()) != null) {
            String string = ((String)object).intern();
            Object object2 = objectInputStream.readObject();
            this.registerEventListener(string, object2);
        }
    }

    protected boolean registerEventListener(String string, Object object) throws IOException {
        if (string == changedListenerK) {
            this.addChangedListener((GFLocatorChangedListener)object);
            return true;
        }
        return false;
    }
}

