/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.example.draw;

import com.objectshare.base.example.OSIExampleApplet;
import com.objectshare.base.example.OSIExampleFrame;
import com.objectshare.gf.base.GFDrawingManager;
import com.objectshare.gf.base.GFGO;
import com.objectshare.gf.base.geometry.GF2DPoint;
import com.objectshare.gf.example.draw.AnimatedPolylineGO;
import com.objectshare.gf.example.draw.BringToFrontAction;
import com.objectshare.gf.example.draw.ConnectionHandleAdapter;
import com.objectshare.gf.example.draw.ConnectionToolAdapter;
import com.objectshare.gf.example.draw.HostGOCreationAdapter;
import com.objectshare.gf.example.draw.ScaleFieldAdapter;
import com.objectshare.gf.example.draw.SendToBackAction;
import com.objectshare.gf.example.howto.HowTo;
import com.objectshare.gf.go.GFButtonGO;
import com.objectshare.gf.go.GFEllipseGO;
import com.objectshare.gf.go.GFHostGO;
import com.objectshare.gf.tool.GFConnectionTool;
import com.objectshare.gf.tool.GFCreationTool;
import com.objectshare.gf.tool.GFGOAction;
import com.objectshare.gf.tool.GFGOActionTool;
import com.objectshare.gf.tool.GFToolCategory;
import com.objectshare.gf.tool.GFToolPalette;
import com.objectshare.gf.tool.adapter.GFDefaultToolSelector;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Panel;
import java.awt.TextField;
import java.util.Vector;

public class DrawingEditor
extends HowTo {
    public TextField scaleTextField;
    public Button scaleButton;
    public Checkbox debugCheckbox;
    public AnimatedPolylineGO animatedGO;
    public Checkbox animationCheckbox = new Checkbox("Animate");
    public Thread animationThread;
    public Checkbox largeToolsCheckbox = new Checkbox("Large Tools");
    public Checkbox liveCheckbox = new Checkbox("Live");
    protected GFDefaultToolSelector defaultToolSelector;
    protected HostGOCreationAdapter hostGOInitializer;
    protected ConnectionHandleAdapter handleListener = new ConnectionHandleAdapter();
    protected ConnectionToolAdapter connectionListener = new ConnectionToolAdapter();

    protected void initDrawing(GFDrawingManager gFDrawingManager) {
        Vector<GF2DPoint> vector = new Vector<GF2DPoint>();
        int n = 10;
        while (n < 150) {
            vector.addElement(new GF2DPoint(n, n + 50));
            n += 30;
        }
        this.animatedGO = new AnimatedPolylineGO(vector);
        this.animatedGO.makeClosed();
        this.animatedGO.setColor(Color.blue);
        gFDrawingManager.add(this.animatedGO);
        GFButtonGO gFButtonGO = new GFButtonGO(this.getDocumentBase(), "../images/osilogo.gif", 10.0f, 10.0f);
        gFButtonGO.addHandleListener(this.handleListener);
        gFDrawingManager.add(gFButtonGO);
    }

    public void initPalette(GFToolPalette gFToolPalette) {
        this.defaultToolSelector = new GFDefaultToolSelector(gFToolPalette);
        this.hostGOInitializer = new HostGOCreationAdapter(this.liveCheckbox);
        GFToolCategory gFToolCategory = this.createSelectionTools();
        gFToolCategory.addTool(new GFGOActionTool((GFGOAction)new BringToFrontAction(), "com.objectshare.gf.tool.BringToFront.gif"));
        gFToolCategory.addTool(new GFGOActionTool((GFGOAction)new SendToBackAction(), "com.objectshare.gf.tool.SendToBack.gif"));
        gFToolPalette.addCategory(gFToolCategory);
        gFToolCategory = this.createShapeGOTools();
        Vector vector = gFToolCategory.getTools();
        int n = 0;
        while (n < vector.size()) {
            if (vector.elementAt(n) instanceof GFCreationTool) {
                GFCreationTool gFCreationTool = (GFCreationTool)vector.elementAt(n);
                gFCreationTool.addToolListener(this.defaultToolSelector);
                gFCreationTool.addCreationToolListener(this.handleListener);
            }
            ++n;
        }
        gFToolPalette.addCategory(gFToolCategory);
        gFToolCategory = this.createDecoratedLineGOTools();
        vector = gFToolCategory.getTools();
        int n2 = 0;
        while (n2 < vector.size()) {
            if (vector.elementAt(n2) instanceof GFCreationTool) {
                GFCreationTool gFCreationTool = (GFCreationTool)vector.elementAt(n2);
                gFCreationTool.addToolListener(this.defaultToolSelector);
            }
            ++n2;
        }
        gFToolPalette.addCategory(gFToolCategory);
        gFToolCategory = this.createConnectionTools();
        vector = gFToolCategory.getTools();
        int n3 = 0;
        while (n3 < vector.size()) {
            if (vector.elementAt(n3) instanceof GFConnectionTool) {
                GFConnectionTool gFConnectionTool = (GFConnectionTool)vector.elementAt(n3);
                gFConnectionTool.addToolListener(this.defaultToolSelector);
                gFConnectionTool.addConnectionToolListener(this.connectionListener);
            }
            ++n3;
        }
        gFToolPalette.addCategory(gFToolCategory);
        gFToolCategory = this.createHostGOTools();
        vector = gFToolCategory.getTools();
        int n4 = 0;
        while (n4 < vector.size()) {
            if (vector.elementAt(n4) instanceof GFCreationTool) {
                GFCreationTool gFCreationTool = (GFCreationTool)vector.elementAt(n4);
                gFCreationTool.addToolListener(this.defaultToolSelector);
                gFCreationTool.addCreationToolListener(this.hostGOInitializer);
                gFCreationTool.addCreationToolListener(this.handleListener);
            }
            ++n4;
        }
        gFToolPalette.addCategory(gFToolCategory);
    }

    public GFCreationTool createEllipseTool() {
        GFCreationTool gFCreationTool = super.createEllipseTool();
        gFCreationTool.setCreationHandle(GFCreationTool.default2DTranslateHandle);
        ((GFEllipseGO)gFCreationTool.getPrototype()).reshape(0.0f, 0.0f, 70.0f, 40.0f);
        return gFCreationTool;
    }

    protected void initTopControls(Panel panel) {
        this.scaleTextField = new TextField("1.0", 10);
        this.manager.addTransformListener(new ScaleFieldAdapter(this.scaleTextField));
        panel.add(this.scaleTextField);
        this.scaleButton = new Button("Set Scale");
        panel.add(this.scaleButton);
        this.animationCheckbox.setState(true);
        panel.add(this.animationCheckbox);
        panel.add(this.largeToolsCheckbox);
        this.liveCheckbox.setState(true);
        panel.add(this.liveCheckbox);
        this.debugCheckbox = new Checkbox("Debug");
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.scaleButton || event.target == this.scaleTextField) {
            float f = new Float(this.scaleTextField.getText()).floatValue();
            this.manager.setWorld2ViewCentered(this.manager.getWorldPort().center(), f, f);
            this.manager.redraw();
        }
        if (event.target == this.debugCheckbox) {
            this.manager.debug = this.debugCheckbox.getState();
        }
        if (event.target == this.animationCheckbox) {
            if (this.animationCheckbox.getState()) {
                this.startAnimation();
            } else {
                this.stopAnimation();
            }
        }
        if (event.target == this.largeToolsCheckbox) {
            if (this.largeToolsCheckbox.getState()) {
                this.paletteGO.setToolSize(35, 35);
                this.paletteCanvas.setPreferredSize(new Dimension(71, 71));
            } else {
                this.paletteGO.setToolSize(19, 19);
                this.paletteCanvas.setPreferredSize(new Dimension(39, 39));
            }
            ((Container)((Object)this)).layout();
        }
        if (event.target == this.liveCheckbox) {
            GFGO[] gFGOArray = this.manager.getContents().elements();
            int n = 0;
            while (gFGOArray[n] != null) {
                if (gFGOArray[n] instanceof GFHostGO) {
                    GFHostGO gFHostGO = (GFHostGO)gFGOArray[n];
                    gFHostGO.setToolEventsEnabled(!this.liveCheckbox.getState());
                    gFHostGO.setHostEventsEnabled(this.liveCheckbox.getState());
                }
                ++n;
            }
        }
        return true;
    }

    public void start() {
        if (this.animationCheckbox.getState()) {
            this.startAnimation();
        }
    }

    public void stop() {
        this.stopAnimation();
    }

    protected void stopAnimation() {
        if (this.animationThread != null) {
            this.animationThread.stop();
            this.animationThread = null;
        }
    }

    protected void startAnimation() {
        if (this.animationThread == null) {
            this.animationThread = new Thread(this.animatedGO);
            this.animationThread.start();
        }
    }

    public static void main(String[] stringArray) {
        DrawingEditor drawingEditor = new DrawingEditor();
        new OSIExampleFrame((OSIExampleApplet)drawingEditor, ((Object)((Object)drawingEditor)).getClass().getName(), 550, 350);
    }
}

