/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.go;

import com.objectshare.gf.base.GF2DWorldViewTransform;
import com.objectshare.gf.base.GFDrawingManager;
import com.objectshare.gf.base.GFGO;
import com.objectshare.gf.base.GFGOArray;
import com.objectshare.gf.base.GFGraphics;
import com.objectshare.gf.base.GFHandle;
import com.objectshare.gf.base.GFUnsortedGOArray;
import com.objectshare.gf.base.geometry.GF2DDimension;
import com.objectshare.gf.base.geometry.GF2DPoint;
import com.objectshare.gf.base.geometry.GF2DRectangle;
import com.objectshare.gf.base.geometry.GF2DVector;
import com.objectshare.gf.connect.GF2DIndexedPointLocator;
import com.objectshare.gf.go.GF2DIndexedPointGO;
import com.objectshare.gf.go.GFAbstractPathGO;
import com.objectshare.gf.go.event.GF2DGOLocationListener;
import com.objectshare.gf.go.event.GF2DGOReshapingEvent;
import com.objectshare.gf.go.lineend.GFAbstractLineEnd;
import com.objectshare.gf.go.lineend.GFLineEnd;
import com.objectshare.gf.tool.GF2DPointCreationHandle;
import com.objectshare.gf.tool.GF2DPointHandle;
import java.awt.Color;

public class GFLineGO
extends GFAbstractPathGO
implements GF2DIndexedPointGO {
    protected GF2DVector lineSegment;
    protected GF2DVector displayedLine;
    protected GFLineEnd[] lineEnds = new GFLineEnd[2];

    protected GFLineGO() {
        this(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public GFLineGO(GF2DVector gF2DVector) {
        this.basicSetLine(gF2DVector);
    }

    public GFLineGO(GF2DPoint gF2DPoint, GF2DPoint gF2DPoint2) {
        this(new GF2DVector(gF2DPoint, gF2DPoint2));
    }

    public GFLineGO(float f, float f2, float f3, float f4) {
        this(new GF2DVector(f, f2, f3, f4));
    }

    public GFGO copyForCreation() {
        return this.copyForCreationInto(new GFLineGO());
    }

    protected GFGO copyForCreationInto(GFGO gFGO) {
        super.copyForCreationInto(gFGO);
        GFLineGO gFLineGO = (GFLineGO)gFGO;
        gFLineGO.basicSetLine(this.lineSegment);
        if (this.lineEnds[0] != null) {
            gFLineGO.setLineEnd(0, this.lineEnds[0].copyForLine());
        }
        if (this.lineEnds[1] != null) {
            gFLineGO.setLineEnd(-1, this.lineEnds[1].copyForLine());
        }
        return gFGO;
    }

    public void basicSetManager(GFDrawingManager gFDrawingManager) {
        super.basicSetManager(gFDrawingManager);
        int n = 0;
        while (n < this.lineEnds.length) {
            if (this.lineEnds[n] != null) {
                this.lineEnds[n].basicSetManager(gFDrawingManager);
            }
            ++n;
        }
    }

    public void basicSetAllManagerAttributes(GFDrawingManager gFDrawingManager) {
        super.basicSetAllManagerAttributes(gFDrawingManager);
        int n = 0;
        while (n < this.lineEnds.length) {
            if (this.lineEnds[n] != null) {
                this.lineEnds[n].basicSetAllManagerAttributes(gFDrawingManager);
            }
            ++n;
        }
    }

    public void setLineEnd(int n, GFLineEnd gFLineEnd) {
        int n2;
        this.beginDamage();
        int n3 = n2 = GFAbstractLineEnd.getEndPointForIndex(this, n) == 0 ? 0 : 1;
        if (this.lineEnds[n2] != null) {
            this.lineEnds[n2].basicSetLine(null, 0);
        }
        this.lineEnds[n2] = gFLineEnd;
        if (gFLineEnd != null) {
            gFLineEnd.basicSetLine(this, GFAbstractLineEnd.getIndexForEndPoint(this, n));
        }
        this.basicSetLine(this.lineSegment);
        this.endDamage();
    }

    public GFLineEnd getLineEnd(int n) {
        int n2 = GFAbstractLineEnd.getEndPointForIndex(this, n) == 0 ? 0 : 1;
        return this.lineEnds[n2];
    }

    public void setLineEndAttachment(int n, GF2DPoint gF2DPoint) {
        if (n == 0) {
            this.displayedLine = new GF2DVector(gF2DPoint, this.displayedLine.p2);
            return;
        }
        this.displayedLine = new GF2DVector(this.displayedLine.p1, gF2DPoint);
    }

    public void display(GFGraphics gFGraphics) {
        gFGraphics.setColor(this.getColor());
        gFGraphics.drawLine(this.displayedLine);
        int n = 0;
        while (n < this.lineEnds.length) {
            if (this.lineEnds[n] != null) {
                this.lineEnds[n].display(gFGraphics);
            }
            ++n;
        }
    }

    public void displayShape(GFGraphics gFGraphics) {
        gFGraphics.setColor(Color.black);
        gFGraphics.drawLine(this.displayedLine);
        int n = 0;
        while (n < this.lineEnds.length) {
            if (this.lineEnds[n] != null) {
                this.lineEnds[n].displayShape(gFGraphics);
            }
            ++n;
        }
    }

    public boolean containsPoint(GF2DPoint gF2DPoint) {
        int n = 0;
        while (n < this.lineEnds.length) {
            if (this.lineEnds[n] != null && this.lineEnds[n].containsPoint(gF2DPoint)) {
                return true;
            }
            ++n;
        }
        if (this.isHorizontalOrVertical()) {
            return this.displayBox().expandBy(3.0f, 3.0f).inside(gF2DPoint);
        }
        GF2DWorldViewTransform gF2DWorldViewTransform = this.getWorldViewTransform();
        GF2DPoint gF2DPoint2 = new GF2DPoint(gF2DWorldViewTransform.world2View(gF2DPoint));
        GF2DVector gF2DVector = new GF2DVector(gF2DWorldViewTransform.world2View(this.displayedLine.p1), gF2DWorldViewTransform.world2View(this.displayedLine.p2));
        return gF2DVector.includes(gF2DPoint2, 4.0f);
    }

    public boolean intersects(GF2DRectangle gF2DRectangle) {
        return this.lineSegment.liangBarskyClipTo(gF2DRectangle) != null;
    }

    public GF2DRectangle displayBox() {
        GF2DRectangle gF2DRectangle = new GF2DRectangle(this.displayedLine.p1, this.displayedLine.p2).expandBy(this.getWidth(), this.getWidth());
        int n = 0;
        while (n < this.lineEnds.length) {
            if (this.lineEnds[n] != null) {
                gF2DRectangle = gF2DRectangle.union(this.lineEnds[n].displayBox());
            }
            ++n;
        }
        return gF2DRectangle;
    }

    public boolean isHorizontalOrVertical() {
        return this.lineSegment.isHorizontal() || this.lineSegment.isVertical();
    }

    public int getNumPoints() {
        return 2;
    }

    public GF2DPoint getPoint(int n) {
        switch (n) {
            case 0: {
                return this.getStartPoint();
            }
            case 1: {
                return this.getEndPoint();
            }
        }
        return null;
    }

    public GF2DPoint getStartPoint() {
        return this.lineSegment.p1;
    }

    public GF2DPoint getEndPoint() {
        return this.lineSegment.p2;
    }

    public void setLine(GF2DVector gF2DVector) {
        this.beginDamage();
        this.basicSetLine(gF2DVector);
        this.endDamage();
        this.triggerReshapedEvent();
    }

    protected void basicSetLine(GF2DVector gF2DVector) {
        this.lineSegment = gF2DVector;
        this.displayedLine = gF2DVector;
        int n = 0;
        while (n < this.lineEnds.length) {
            if (this.lineEnds[n] != null) {
                this.lineEnds[n].lineChanged();
            }
            ++n;
        }
    }

    public GF2DVector getLine() {
        return this.lineSegment;
    }

    public float getTangentialTheta(int n, int n2) {
        GF2DPoint gF2DPoint;
        GF2DPoint gF2DPoint2 = this.getPoint(n);
        if (n2 == 0) {
            if (n == 0) {
                throw new IllegalArgumentException();
            }
            gF2DPoint = this.getPoint(n - 1);
        } else {
            if (n >= this.getNumPoints() - 1) {
                throw new IllegalArgumentException();
            }
            gF2DPoint = this.getPoint(n + 1);
        }
        GF2DPoint gF2DPoint3 = gF2DPoint.subtract(gF2DPoint2);
        return (float)Math.atan2(gF2DPoint3.y, gF2DPoint3.x);
    }

    public boolean basicReshape(float f, float f2, float f3, float f4) {
        float f5;
        float f6;
        float f7;
        float f8;
        if (this.lineSegment.p1.x <= this.lineSegment.p2.x) {
            f8 = f;
            f7 = f + f3;
        } else {
            f7 = f;
            f8 = f + f3;
        }
        if (this.lineSegment.p1.y <= this.lineSegment.p2.y) {
            f6 = f2;
            f5 = f2 + f4;
        } else {
            f5 = f2;
            f6 = f2 + f4;
        }
        this.basicSetLine(new GF2DVector(f8, f6, f7, f5));
        return true;
    }

    public boolean basicTranslate(float f, float f2) {
        this.basicSetLine(this.lineSegment.translateBy(f, f2));
        return true;
    }

    public void setPoint(int n, GF2DPoint gF2DPoint) {
        switch (n) {
            case 0: {
                this.setStartPoint(gF2DPoint);
                return;
            }
            case 1: {
                this.setEndPoint(gF2DPoint);
                return;
            }
        }
    }

    public void setStartPoint(GF2DPoint gF2DPoint) {
        GF2DPoint[] gF2DPointArray = new GF2DPoint[]{gF2DPoint, this.lineSegment.p2};
        if (!this.triggerAboutToReshapeLineEndsEvent(gF2DPointArray)) {
            return;
        }
        this.beginDamage();
        this.basicSetLine(new GF2DVector(gF2DPointArray[0], gF2DPointArray[1]));
        this.endDamage();
        this.triggerReshapedEvent();
    }

    public void setEndPoint(GF2DPoint gF2DPoint) {
        GF2DPoint[] gF2DPointArray = new GF2DPoint[]{this.lineSegment.p1, gF2DPoint};
        if (!this.triggerAboutToReshapeLineEndsEvent(gF2DPointArray)) {
            return;
        }
        this.beginDamage();
        this.basicSetLine(new GF2DVector(gF2DPointArray[0], gF2DPointArray[1]));
        this.endDamage();
        this.triggerReshapedEvent();
    }

    public GFGOArray defaultHandles() {
        GFUnsortedGOArray gFUnsortedGOArray = new GFUnsortedGOArray(2);
        gFUnsortedGOArray.add(new GF2DPointHandle(new GF2DIndexedPointLocator(this, 0, 0.0f, 0.0f), 0, 1.0f, 1.0f));
        gFUnsortedGOArray.add(new GF2DPointHandle(new GF2DIndexedPointLocator(this, 1, 0.0f, 0.0f), 1, 1.0f, 1.0f));
        return gFUnsortedGOArray;
    }

    public GFHandle defaultCreationHandle() {
        return new GF2DPointCreationHandle(this, 1);
    }

    public GFGOArray defaultConnectionHandles() {
        return new GFUnsortedGOArray();
    }

    protected boolean triggerAboutToReshapeLineEndsEvent(GF2DPoint[] gF2DPointArray) {
        float f;
        float f2;
        float f3;
        float f4;
        GF2DGOLocationListener gF2DGOLocationListener = this.locationListener;
        if (gF2DGOLocationListener == null) {
            return true;
        }
        boolean bl = gF2DPointArray[0].isLeftOf(gF2DPointArray[1]);
        boolean bl2 = gF2DPointArray[0].isAbove(gF2DPointArray[1]);
        GF2DDimension gF2DDimension = gF2DPointArray[0].absExtent(gF2DPointArray[1]);
        GF2DRectangle gF2DRectangle = new GF2DRectangle(bl ? gF2DPointArray[0].x : gF2DPointArray[1].x, bl2 ? gF2DPointArray[0].y : gF2DPointArray[1].y, gF2DDimension.width, gF2DDimension.height);
        GF2DGOReshapingEvent gF2DGOReshapingEvent = new GF2DGOReshapingEvent(this, gF2DRectangle);
        gF2DGOLocationListener.aboutToReshapeGO(gF2DGOReshapingEvent);
        if (gF2DGOReshapingEvent.isVetoed()) {
            return false;
        }
        gF2DRectangle = gF2DGOReshapingEvent.getBoundingBox();
        if (bl) {
            f4 = gF2DRectangle.x;
            f3 = gF2DRectangle.x + gF2DRectangle.width;
        } else {
            f3 = gF2DRectangle.x;
            f4 = gF2DRectangle.x + gF2DRectangle.width;
        }
        if (bl2) {
            f2 = gF2DRectangle.y;
            f = gF2DRectangle.y + gF2DRectangle.height;
        } else {
            f = gF2DRectangle.y;
            f2 = gF2DRectangle.y + gF2DRectangle.height;
        }
        gF2DPointArray[0] = new GF2DPoint(f4, f2);
        gF2DPointArray[1] = new GF2DPoint(f3, f);
        return true;
    }
}

