/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.go3d;

import com.objectshare.gf.base.GFCompositeGO;
import com.objectshare.gf.base.GFGOArray;
import com.objectshare.gf.base.GFGraphics;
import com.objectshare.gf.base.GFUnsortedGOArray;
import com.objectshare.gf.base.geometry.GF2DPoint;
import com.objectshare.gf.base.geometry.GF2DRectangle;
import com.objectshare.gf.base.geometry.GF3DPoint;
import com.objectshare.gf.connect.GFDisplayBoxLocator;
import com.objectshare.gf.go.GFPolylineGO;
import com.objectshare.gf.go.GFTextGO;
import com.objectshare.gf.go3d.GF3DGraphicObject;
import com.objectshare.gf.tool.GF3DRotatable;
import com.objectshare.gf.tool.GF3DRotationHandle;
import java.awt.Color;
import java.awt.Font;

public abstract class GF25DGraphicObject
extends GF3DGraphicObject
implements GF3DRotatable {
    protected GF2DPoint origin2D;
    protected GF2DPoint globalOrigin2D = new GF2DPoint(200.0f, 200.0f);
    protected float perspective = 500.0f;
    protected GF3DPoint[] rawFigure;
    protected GF3DPoint[] rot3D;
    protected GF3DPoint[] points3D;
    protected GF2DPoint[] points2D;
    protected GFCompositeGO composite;
    protected GF2DRectangle displayBox;

    public GF25DGraphicObject() {
        this.origin2D = new GF2DPoint(0.0f, 0.0f);
    }

    protected GF3DPoint[] rawFigure() {
        if (this.rawFigure == null) {
            this.rawFigure = this.computeRawFigure();
        }
        return this.rawFigure;
    }

    protected void invalidateRawFigure() {
        this.rawFigure = null;
        this.invalidateRotatedFigure();
    }

    protected abstract GF3DPoint[] computeRawFigure();

    protected GF3DPoint[] rotatedFigure() {
        if (this.rot3D == null) {
            this.rot3D = this.computeRotatedFigure();
        }
        return this.rot3D;
    }

    protected void invalidateRotatedFigure() {
        this.rot3D = null;
        this.invalidate2DRepresentation();
    }

    protected synchronized GF3DPoint[] computeRotatedFigure() {
        GF3DPoint[] gF3DPointArray = this.rawFigure();
        GF3DPoint[] gF3DPointArray2 = new GF3DPoint[gF3DPointArray.length];
        int n = 0;
        while (n < gF3DPointArray.length) {
            float f = this.cosYaw * gF3DPointArray[n].x - this.sinYaw * gF3DPointArray[n].y;
            float f2 = this.sinYaw * gF3DPointArray[n].x + this.cosYaw * gF3DPointArray[n].y;
            float f3 = this.cosRoll * gF3DPointArray[n].z - this.sinRoll * f;
            float f4 = this.cosRoll * f + this.sinRoll * gF3DPointArray[n].z;
            float f5 = this.cosPitch * f2 - this.sinPitch * f3;
            float f6 = this.sinPitch * f2 + this.cosPitch * f3;
            gF3DPointArray2[n] = new GF3DPoint(f4, f5, f6);
            ++n;
        }
        return gF3DPointArray2;
    }

    protected synchronized void computeProjectedFigure() {
        GF3DPoint[] gF3DPointArray = this.rotatedFigure();
        int n = gF3DPointArray.length;
        this.points3D = new GF3DPoint[n];
        this.points2D = new GF2DPoint[n];
        float f = Float.MAX_VALUE;
        float f2 = Float.MAX_VALUE;
        float f3 = Float.MIN_VALUE;
        float f4 = Float.MIN_VALUE;
        float f5 = 300.0f;
        int n2 = 0;
        while (n2 < n) {
            float f6;
            float f7;
            float f8 = gF3DPointArray[n2].x + this.origin2D.x;
            float f9 = gF3DPointArray[n2].y + f5;
            float f10 = gF3DPointArray[n2].z + this.origin2D.y;
            this.points3D[n2] = new GF3DPoint(f8, f9, f10);
            if (f9 == 0.0f) {
                f7 = 0.0f;
                f6 = 0.0f;
            } else {
                f7 = f8 / f9 * this.perspective + this.globalOrigin2D.x;
                f6 = f10 / f9 * this.perspective + this.globalOrigin2D.y;
            }
            this.points2D[n2] = new GF2DPoint(f7, f6);
            f = Math.min(f, f7);
            f2 = Math.min(f2, f6);
            f3 = Math.max(f3, f7);
            f4 = Math.max(f4, f6);
            ++n2;
        }
        this.displayBox = new GF2DRectangle(f, f2, f3 - f, f4 - f2);
    }

    protected void invalidate2DRepresentation() {
        this.points3D = null;
        this.points2D = null;
        this.displayBox = null;
    }

    protected void validate2DRepresentation() {
        if (this.points2D == null) {
            this.compute2DRepresentation();
        }
    }

    protected synchronized void compute2DRepresentation() {
        this.computeProjectedFigure();
        this.composite = new GFCompositeGO(this.compute2DGOs());
    }

    protected GFGOArray compute2DGOs() {
        return new GFUnsortedGOArray();
    }

    protected GFPolylineGO compute2DFaceFromVertexIndices(int[] nArray) {
        GF2DPoint[] gF2DPointArray = new GF2DPoint[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            gF2DPointArray[n] = this.points2D[nArray[n]];
            ++n;
        }
        GFPolylineGO gFPolylineGO = new GFPolylineGO(gF2DPointArray);
        gFPolylineGO.makeClosed();
        float f = 0.0f;
        if (nArray.length >= 3) {
            GF3DPoint gF3DPoint = GF3DPoint.surfaceNormal(this.points3D[nArray[0]], this.points3D[nArray[1]], this.points3D[nArray[2]]);
            GF3DPoint gF3DPoint2 = new GF3DPoint(this.sinRoll * this.cosYaw, this.sinYaw * this.sinRoll, this.cosRoll);
            GF3DPoint gF3DPoint3 = gF3DPoint2.subtract(this.points3D[nArray[0]]);
            f = gF3DPoint.x * gF3DPoint3.x + gF3DPoint.y * gF3DPoint3.y + gF3DPoint.z * gF3DPoint3.z;
        }
        gFPolylineGO.zOrderIndex = f;
        return gFPolylineGO;
    }

    public GF2DRectangle displayBox() {
        this.validate2DRepresentation();
        return this.displayBox;
    }

    public void display(GFGraphics gFGraphics) {
        this.validate2DRepresentation();
        this.composite.display(gFGraphics);
    }

    public void displayShape(GFGraphics gFGraphics) {
        this.validate2DRepresentation();
        this.composite.displayShape(gFGraphics);
    }

    public void changeYawPitchRoll(float f, float f2, float f3) {
        this.beginDamage();
        this.basicSetYaw(this.yaw + f);
        this.basicSetPitch(this.pitch + f2);
        this.basicSetRoll(this.roll + f3);
        this.invalidateRotatedFigure();
        this.endDamage();
    }

    public boolean basicReshape(float f, float f2, float f3, float f4) {
        GF2DPoint gF2DPoint = this.displayCenter();
        GF2DPoint gF2DPoint2 = new GF2DRectangle(f, f2, f3, f4).center();
        this.origin2D = this.origin2D.translateBy(gF2DPoint2.x - gF2DPoint.x, gF2DPoint2.y - gF2DPoint.y);
        this.invalidate2DRepresentation();
        return true;
    }

    public boolean basicTranslate(float f, float f2) {
        this.origin2D = this.origin2D.translateBy(f, f2);
        this.invalidate2DRepresentation();
        return true;
    }

    public GF2DPoint translationOrigin() {
        return new GF2DPoint(this.origin2D.x, this.origin2D.y);
    }

    public GFGOArray defaultHandles() {
        return this.default3DRotationHandles();
    }

    public GFGOArray default3DRotationHandles() {
        GFUnsortedGOArray gFUnsortedGOArray = new GFUnsortedGOArray(3);
        gFUnsortedGOArray.add(new GF3DRotationHandle(new GFDisplayBoxLocator(this, 0.5f, 0.5f, 0.0f, -10.0f), 0.02f, 0.0f, 0.0f, -0.02f, 0.0f, 0.0f));
        gFUnsortedGOArray.add(new GF3DRotationHandle(new GFDisplayBoxLocator(this, 0.5f, 0.5f, -10.0f, 10.0f), 0.02f, 0.0f, 0.0f, 0.0f, 0.0f, 0.02f));
        gFUnsortedGOArray.add(new GF3DRotationHandle(new GFDisplayBoxLocator(this, 0.5f, 0.5f, 10.0f, 10.0f), 0.0f, 0.0f, 0.0f, -0.02f, 0.02f, 0.0f));
        return gFUnsortedGOArray;
    }

    public GFGOArray xyzRotationHandles() {
        GFUnsortedGOArray gFUnsortedGOArray = new GFUnsortedGOArray(3);
        Font font = new Font("Helvetica", 1, 12);
        GF3DRotationHandle gF3DRotationHandle = new GF3DRotationHandle(new GFDisplayBoxLocator(this, 0.5f, 0.5f, 10.0f, 10.0f), 0.0f, 0.0f, 0.0f, -0.02f, 0.0f, 0.0f);
        GFTextGO gFTextGO = new GFTextGO(0.0f, 0.0f, "X");
        gFTextGO.setFont(font);
        gF3DRotationHandle.setDisplayGO(gFTextGO);
        gFUnsortedGOArray.add(gF3DRotationHandle);
        gF3DRotationHandle = new GF3DRotationHandle(new GFDisplayBoxLocator(this, 0.5f, 0.5f, 0.0f, -10.0f), 0.02f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        gFTextGO = new GFTextGO(0.0f, 0.0f, "Y");
        gFTextGO.setFont(font);
        gF3DRotationHandle.setDisplayGO(gFTextGO);
        gFUnsortedGOArray.add(gF3DRotationHandle);
        gF3DRotationHandle = new GF3DRotationHandle(new GFDisplayBoxLocator(this, 0.5f, 0.5f, -10.0f, 10.0f), 0.02f, 0.0f, 0.0f, 0.0f, 0.02f, 0.0f);
        GFCompositeGO gFCompositeGO = new GFCompositeGO();
        gFTextGO = new GFTextGO(0.0f, 0.0f, "Z");
        gFTextGO.setFont(font);
        gFTextGO.setColor(Color.white);
        gFCompositeGO.add(gFTextGO);
        gFTextGO = new GFTextGO(5.0f, 5.0f, "Z");
        gFTextGO.setFont(font);
        gFTextGO.setColor(Color.blue);
        gF3DRotationHandle.setDisplayGO(gFTextGO);
        gFCompositeGO.add(gFTextGO);
        gFUnsortedGOArray.add(gF3DRotationHandle);
        return gFUnsortedGOArray;
    }

    public void releaseAllResources() {
        if (this.composite != null) {
            this.composite.releaseAllResources();
        }
        super.releaseAllResources();
    }
}

