/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.tool;

import com.objectshare.gf.base.GFDrawingCanvas;
import com.objectshare.gf.base.GFGO;
import com.objectshare.gf.base.event.GFDrawingMouseEvent;
import com.objectshare.gf.tool.GFTool;
import com.objectshare.gf.tool.event.GFPopupMenuToolEvent;
import com.objectshare.gf.tool.event.GFPopupMenuToolListener;
import com.objectshare.gf.tool.event.GFToolEventMulticaster;
import java.awt.PopupMenu;

public class GFPopupMenuTool
extends GFTool {
    protected PopupMenu backgroundMenu;
    protected GFPopupMenuToolListener menuListener;

    public GFPopupMenuTool() {
        this(null);
    }

    public GFPopupMenuTool(PopupMenu popupMenu) {
        this.setMenu(popupMenu);
        this.setImage("com.objectshare.gf.tool.GFSelectionTool.gif");
    }

    public void setMenu(PopupMenu popupMenu) {
        this.backgroundMenu = popupMenu;
    }

    public PopupMenu getMenu() {
        return this.backgroundMenu;
    }

    protected void basicProcessMouseDown(GFDrawingMouseEvent gFDrawingMouseEvent) {
        if (gFDrawingMouseEvent.isPopupDown()) {
            GFGO gFGO = gFDrawingMouseEvent.getGraphicObject();
            if (gFGO != null) {
                this.selectGO(gFGO, gFDrawingMouseEvent);
            }
            if (gFDrawingMouseEvent.isPopupTrigger()) {
                this.processPopupTrigger(gFDrawingMouseEvent);
            }
            gFDrawingMouseEvent.setHandled(true);
        }
    }

    protected void basicProcessMouseUp(GFDrawingMouseEvent gFDrawingMouseEvent) {
        if (gFDrawingMouseEvent.isPopupTrigger()) {
            this.processPopupTrigger(gFDrawingMouseEvent);
            gFDrawingMouseEvent.setHandled(true);
        }
    }

    protected void processPopupTrigger(GFDrawingMouseEvent gFDrawingMouseEvent) {
        PopupMenu popupMenu = null;
        GFGO gFGO = gFDrawingMouseEvent.getGraphicObject();
        if (gFGO != null) {
            popupMenu = gFGO.triggerNeedsMenuEvent(gFDrawingMouseEvent);
        }
        if (popupMenu == null) {
            popupMenu = this.triggerNeedsMenuEvent(gFDrawingMouseEvent);
        }
        if (popupMenu != null) {
            GFDrawingCanvas gFDrawingCanvas = this.getManager().getCanvas();
            gFDrawingCanvas.show(popupMenu, gFDrawingMouseEvent.getViewLocation(), false);
            gFDrawingMouseEvent.setHandled(true);
        }
    }

    public void addPopupMenuToolListener(GFPopupMenuToolListener gFPopupMenuToolListener) {
        this.menuListener = GFToolEventMulticaster.add(this.menuListener, gFPopupMenuToolListener);
    }

    public void removePopupMenuToolListener(GFPopupMenuToolListener gFPopupMenuToolListener) {
        this.menuListener = GFToolEventMulticaster.remove(this.menuListener, gFPopupMenuToolListener);
    }

    protected PopupMenu triggerNeedsMenuEvent(GFDrawingMouseEvent gFDrawingMouseEvent) {
        GFPopupMenuToolListener gFPopupMenuToolListener = this.menuListener;
        if (gFPopupMenuToolListener != null) {
            GFPopupMenuToolEvent gFPopupMenuToolEvent = new GFPopupMenuToolEvent(this, gFDrawingMouseEvent);
            gFPopupMenuToolListener.toolNeedsMenu(gFPopupMenuToolEvent);
            return gFPopupMenuToolEvent.getMenu();
        }
        return this.getMenu();
    }
}

