/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.tool;

import com.objectshare.gf.base.GFGO;
import com.objectshare.gf.base.GFGraphics;
import com.objectshare.gf.base.GFHandle;
import com.objectshare.gf.base.event.GFDrawingMouseEvent;
import com.objectshare.gf.base.geometry.GF2DDimension;
import com.objectshare.gf.base.geometry.GF2DPoint;
import com.objectshare.gf.base.geometry.GF2DRectangle;
import java.awt.Color;

public class GFRubberHandle
extends GFHandle {
    protected Color defaultLineColor = new Color(192, 0, 64);
    protected Color defaultXORColor = Color.white;
    protected GF2DPoint anchor = new GF2DPoint(0.0f, 0.0f);
    protected GF2DPoint corner = new GF2DPoint(0.0f, 0.0f);
    protected GF2DRectangle rubberbandRect;
    protected Color lineColor = this.defaultLineColor;
    protected Color xorColor = this.defaultXORColor;
    protected boolean constrainAspectRatio = false;
    protected float aspectRatio = 1.0f;

    public GFRubberHandle() {
        this(GFHandle.defaultLimit, GFHandle.defaultSnapToGrid);
    }

    public GFRubberHandle(float f) {
        super(null, GFHandle.defaultDescription, GFHandle.defaultHandleExtent, GFHandle.defaultLimit, GFHandle.defaultSnapToGrid);
        this.aspectRatio = f;
        this.constrainAspectRatio = true;
    }

    public GFRubberHandle(boolean bl, boolean bl2) {
        super(null, GFHandle.defaultDescription, GFHandle.defaultHandleExtent, bl, bl2);
    }

    public GFHandle copyForOwner(GFGO gFGO) {
        return this.copyForOwnerInto(new GFRubberHandle(), gFGO);
    }

    protected GFHandle copyForOwnerInto(GFHandle gFHandle) {
        GFRubberHandle gFRubberHandle = (GFRubberHandle)gFHandle;
        super.copyForOwnerInto(gFHandle);
        gFRubberHandle.lineColor = new Color(this.lineColor.getRGB());
        gFRubberHandle.xorColor = new Color(this.xorColor.getRGB());
        gFRubberHandle.constrainAspectRatio = this.constrainAspectRatio;
        gFRubberHandle.aspectRatio = this.aspectRatio;
        return gFHandle;
    }

    public boolean basicTranslate(float f, float f2) {
        this.anchor = this.anchor.translateBy(f, f2);
        this.corner = this.corner.translateBy(f, f2);
        return true;
    }

    protected GF2DRectangle calculateRubberbandRect() {
        GF2DRectangle gF2DRectangle = new GF2DRectangle(this.anchor.leftMostAndHighest(this.corner), this.anchor.absExtent(this.corner));
        if (this.constrainAspectRatio) {
            if (gF2DRectangle.width / gF2DRectangle.height > this.aspectRatio) {
                float f = gF2DRectangle.width / this.aspectRatio;
                gF2DRectangle.y -= (f - gF2DRectangle.height) / 2.0f;
                gF2DRectangle.height = f;
            } else {
                float f = gF2DRectangle.height * this.aspectRatio;
                gF2DRectangle.x -= (f - gF2DRectangle.width) / 2.0f;
                gF2DRectangle.width = f;
            }
        }
        return gF2DRectangle;
    }

    public GF2DRectangle displayBox() {
        if (this.rubberbandRect == null) {
            this.rubberbandRect = this.calculateRubberbandRect();
        }
        return this.rubberbandRect;
    }

    public GF2DDimension displayExtent() {
        return this.displayBox().extent();
    }

    public void display(GFGraphics gFGraphics) {
        gFGraphics.setColor(this.lineColor);
        gFGraphics.setXORMode(this.xorColor);
        gFGraphics.drawRect(this.displayBox());
        gFGraphics.setPaintMode();
    }

    public void displayShape(GFGraphics gFGraphics) {
    }

    public void processMouseDown(GFDrawingMouseEvent gFDrawingMouseEvent) {
        super.processMouseDown(gFDrawingMouseEvent);
        this.corner = this.anchor = new GF2DPoint(gFDrawingMouseEvent.getWorldLocation());
        this.rubberbandRect = null;
        gFDrawingMouseEvent.setHandled(true);
    }

    public void processMouseDrag(GFDrawingMouseEvent gFDrawingMouseEvent) {
        super.processMouseDrag(gFDrawingMouseEvent);
        this.beginDamage();
        this.corner = new GF2DPoint(gFDrawingMouseEvent.getWorldLocation());
        this.rubberbandRect = null;
        this.endDamage();
        gFDrawingMouseEvent.setHandled(true);
    }
}

