/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.tool;

import com.objectshare.gf.base.GFDrawingManager;
import com.objectshare.gf.base.event.GFDrawingKeyEvent;
import com.objectshare.gf.base.event.GFDrawingMouseEvent;
import com.objectshare.gf.base.geometry.GF2DDimension;
import com.objectshare.gf.base.geometry.GF2DRectangle;
import com.objectshare.gf.tool.GFRubberHandle;
import com.objectshare.gf.tool.GFTool;
import java.awt.Dimension;

public class GFRubberZoomTool
extends GFTool {
    protected boolean constrainRubberbandAspectRatio;
    protected boolean constrainXYScales;
    protected Dimension panZoomThreshold = new Dimension(5, 5);
    protected float zoomOutRatio = 1.25f;
    protected GFRubberHandle rubberband;

    public GFRubberZoomTool() {
        this(true, true);
    }

    public GFRubberZoomTool(boolean bl, boolean bl2) {
        this.setConstrainRubberbandAspectRatio(bl);
        this.setConstrainXYScales(bl2);
    }

    public void setConstrainRubberbandAspectRatio(boolean bl) {
        this.constrainRubberbandAspectRatio = bl;
    }

    public boolean getConstrainRubberbandAspectRatio() {
        return this.constrainRubberbandAspectRatio;
    }

    public void setConstrainXYScales(boolean bl) {
        this.constrainXYScales = bl;
    }

    public boolean getConstrainXYScales() {
        return this.constrainXYScales;
    }

    public void setPanZoomThreshold(Dimension dimension) {
        this.panZoomThreshold.width = dimension.width;
        this.panZoomThreshold.height = dimension.height;
    }

    public Dimension getPanZoomThreshold() {
        return new Dimension(this.panZoomThreshold);
    }

    public void setZoomOutRatio(float f) {
        this.zoomOutRatio = f;
    }

    public float getZoomOutRatio() {
        return this.zoomOutRatio;
    }

    public void basicProcessKeyDown(GFDrawingKeyEvent gFDrawingKeyEvent) {
        if (this.rubberband != null && gFDrawingKeyEvent.isEscapeKey()) {
            this.complete();
            gFDrawingKeyEvent.setHandled(true);
        }
    }

    protected void basicProcessMouseDown(GFDrawingMouseEvent gFDrawingMouseEvent) {
        GFDrawingManager gFDrawingManager = this.getManager();
        if (this.constrainRubberbandAspectRatio) {
            GF2DDimension gF2DDimension = gFDrawingManager.getWorldPort().extent();
            this.rubberband = new GFRubberHandle(gF2DDimension.width / gF2DDimension.height);
        } else {
            this.rubberband = new GFRubberHandle();
        }
        gFDrawingManager.add(this.rubberband);
        this.processMouseDownInDelegate(this.rubberband, gFDrawingMouseEvent);
        gFDrawingMouseEvent.setHandled(true);
    }

    protected void basicProcessMouseUp(GFDrawingMouseEvent gFDrawingMouseEvent) {
        if (this.rubberband == null) {
            return;
        }
        GFDrawingManager gFDrawingManager = this.getManager();
        GF2DRectangle gF2DRectangle = this.rubberband.displayBox();
        if (gFDrawingMouseEvent.isShiftDown()) {
            if (this.constrainXYScales) {
                this.zoomOutConstrained(gF2DRectangle);
            } else {
                this.zoomOutUnconstrained(gF2DRectangle);
            }
        } else {
            Dimension dimension = gFDrawingManager.getWorldViewTransform().world2View(gF2DRectangle.extent());
            if (dimension.width >= this.panZoomThreshold.width && dimension.height >= this.panZoomThreshold.height) {
                if (this.constrainXYScales) {
                    this.zoomInConstrained(gF2DRectangle);
                } else {
                    this.zoomInUnconstrained(gF2DRectangle);
                }
            } else {
                gFDrawingManager.setWorldPortCenter(gF2DRectangle.center());
            }
        }
        gFDrawingMouseEvent.setHandled(true);
    }

    protected void completed() {
        GFDrawingManager gFDrawingManager = this.getManager();
        if (this.rubberband == null || !gFDrawingManager.includes(this.rubberband)) {
            this.rubberband = null;
            return;
        }
        gFDrawingManager.remove(this.rubberband);
        this.rubberband = null;
    }

    protected void zoomInUnconstrained(GF2DRectangle gF2DRectangle) {
        this.getManager().setWorldPort(gF2DRectangle);
    }

    protected void zoomInConstrained(GF2DRectangle gF2DRectangle) {
        GFDrawingManager gFDrawingManager = this.getManager();
        float f = gF2DRectangle.width / (float)gFDrawingManager.getViewPort().width;
        float f2 = gF2DRectangle.height / (float)gFDrawingManager.getViewPort().height;
        float f3 = (f + f2) / 2.0f;
        gFDrawingManager.setWorld2ViewCentered(gF2DRectangle.center(), f3, f3);
    }

    protected void zoomOutUnconstrained(GF2DRectangle gF2DRectangle) {
        GFDrawingManager gFDrawingManager = this.getManager();
        float f = gFDrawingManager.getWorld2ViewXScale() * this.zoomOutRatio;
        float f2 = gFDrawingManager.getWorld2ViewYScale() * this.zoomOutRatio;
        gFDrawingManager.setWorld2ViewCentered(gF2DRectangle.center(), f, f2);
    }

    protected void zoomOutConstrained(GF2DRectangle gF2DRectangle) {
        GFDrawingManager gFDrawingManager = this.getManager();
        float f = (gFDrawingManager.getWorld2ViewXScale() + gFDrawingManager.getWorld2ViewYScale()) * this.zoomOutRatio / 2.0f;
        gFDrawingManager.setWorld2ViewCentered(gF2DRectangle.center(), f, f);
    }
}

