/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.tool;

import com.objectshare.gf.base.GFDrawingManager;
import com.objectshare.gf.base.GFEventModel;
import com.objectshare.gf.tool.GFPvtPaletteDwgMgrAdapter;
import com.objectshare.gf.tool.GFTool;
import com.objectshare.gf.tool.GFToolCategory;
import com.objectshare.gf.tool.event.GFPaletteCategoryEvent;
import com.objectshare.gf.tool.event.GFPaletteEventMulticaster;
import com.objectshare.gf.tool.event.GFPaletteListener;
import com.objectshare.gf.tool.event.GFPaletteToolEvent;
import java.util.Enumeration;
import java.util.Vector;

public class GFToolPalette
extends GFEventModel {
    protected GFDrawingManager manager;
    protected GFToolCategory activeCategory;
    protected GFTool activeTool;
    protected Vector categories = new Vector();
    protected GFPvtPaletteDwgMgrAdapter paletteAdapter;
    protected GFPaletteListener toolPaletteListener;

    public GFToolPalette(GFDrawingManager gFDrawingManager) {
        this.setManager(gFDrawingManager);
    }

    public GFDrawingManager getManager() {
        return this.manager;
    }

    public void setManager(GFDrawingManager gFDrawingManager) {
        if (this.manager == gFDrawingManager) {
            return;
        }
        if (this.paletteAdapter != null) {
            this.removeToolPaletteListener(this.paletteAdapter);
            this.paletteAdapter = null;
        }
        this.manager = gFDrawingManager;
        if (this.manager != null) {
            this.paletteAdapter = new GFPvtPaletteDwgMgrAdapter(this.manager);
            this.addToolPaletteListener(this.paletteAdapter);
            this.manager.setTool(this.getTool());
        }
    }

    public void addCategory(GFToolCategory gFToolCategory) {
        if (!this.categories.contains(gFToolCategory)) {
            this.categories.addElement(gFToolCategory);
            gFToolCategory.setPalette(this);
            this.triggerToolCategoryAddedEvent(gFToolCategory);
            this.getCategory();
        }
    }

    public Vector getCategories() {
        return this.categories;
    }

    public void removeCategory(GFToolCategory gFToolCategory) {
        if (this.categories.contains(gFToolCategory)) {
            this.categories.removeElement(gFToolCategory);
            gFToolCategory.setPalette(null);
            if (this.activeCategory == gFToolCategory) {
                this.setCategory(null);
            }
            this.triggerToolCategoryRemovedEvent(gFToolCategory);
        }
    }

    public GFToolCategory getCategory() {
        if (this.activeCategory == null && this.categories.size() > 0) {
            this.setCategory((GFToolCategory)this.categories.elementAt(0));
        }
        return this.activeCategory;
    }

    public void setCategory(GFToolCategory gFToolCategory) {
        if (this.activeCategory != gFToolCategory) {
            this.activeCategory = gFToolCategory;
            this.triggerToolCategorySelectedEvent(this.getCategory());
            this.setTool(this.activeCategory == null ? null : this.activeCategory.getDefaultTool());
        }
    }

    public GFTool getTool() {
        if (this.activeTool == null && this.getCategory() != null) {
            this.activeTool = this.getCategory().getDefaultTool();
        }
        return this.activeTool;
    }

    public GFTool getDefaultTool() {
        GFToolCategory gFToolCategory = this.getCategory();
        if (gFToolCategory == null) {
            return null;
        }
        return gFToolCategory.getDefaultTool();
    }

    public synchronized void setTool(GFTool gFTool) {
        this.activeTool = gFTool;
        this.triggerToolSelectedEvent(this.getCategory(), this.getTool());
    }

    public void setDefaultTool() {
        GFToolCategory gFToolCategory = this.getCategory();
        if (gFToolCategory != null) {
            this.setTool(gFToolCategory.getDefaultTool());
        }
    }

    public Vector allTools() {
        Vector vector = new Vector();
        Enumeration enumeration = this.categories.elements();
        while (enumeration.hasMoreElements()) {
            Enumeration enumeration2 = ((GFToolCategory)enumeration.nextElement()).getTools().elements();
            while (enumeration2.hasMoreElements()) {
                Object e = enumeration2.nextElement();
                if (vector.contains(e)) continue;
                vector.addElement(e);
            }
        }
        return vector;
    }

    public void addToolPaletteListener(GFPaletteListener gFPaletteListener) {
        this.toolPaletteListener = GFPaletteEventMulticaster.add(this.toolPaletteListener, gFPaletteListener);
    }

    public void removeToolPaletteListener(GFPaletteListener gFPaletteListener) {
        this.toolPaletteListener = GFPaletteEventMulticaster.remove(this.toolPaletteListener, gFPaletteListener);
    }

    public void triggerToolCategoryAddedEvent(GFToolCategory gFToolCategory) {
        if (this.toolPaletteListener != null) {
            this.toolPaletteListener.toolCategoryAdded(new GFPaletteCategoryEvent(this, gFToolCategory));
        }
    }

    public void triggerToolCategorySelectedEvent(GFToolCategory gFToolCategory) {
        if (this.toolPaletteListener != null) {
            this.toolPaletteListener.toolCategorySelected(new GFPaletteCategoryEvent(this, gFToolCategory));
        }
    }

    public void triggerToolCategoryRemovedEvent(GFToolCategory gFToolCategory) {
        if (this.toolPaletteListener != null) {
            this.toolPaletteListener.toolCategoryRemoved(new GFPaletteCategoryEvent(this, gFToolCategory));
        }
    }

    public void triggerToolAddedEvent(GFToolCategory gFToolCategory, GFTool gFTool) {
        if (this.toolPaletteListener != null) {
            this.toolPaletteListener.toolAdded(new GFPaletteToolEvent(this, gFToolCategory, gFTool));
        }
    }

    public void triggerToolSelectedEvent(GFToolCategory gFToolCategory, GFTool gFTool) {
        if (this.toolPaletteListener != null) {
            this.toolPaletteListener.toolSelected(new GFPaletteToolEvent(this, gFToolCategory, gFTool));
        }
    }

    public void triggerToolRemovedEvent(GFToolCategory gFToolCategory, GFTool gFTool) {
        if (this.toolPaletteListener != null) {
            this.toolPaletteListener.toolRemoved(new GFPaletteToolEvent(this, gFToolCategory, gFTool));
        }
    }
}

